/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.ObserverPartitionTest$;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.Defaults$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0011#\u0005\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!I\u0011\t\u0001a\u0001\u0002\u0004%\tA\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0002)C\u0011\u0002\u0015\u0001A\u0002\u0003\u0005\u000b\u0015B\"\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001]\u0011%q\u0006\u00011A\u0001B\u0003&1\u000bC\u0005`\u0001\u0001\u0007\t\u0019!C\u0001A\"IA\r\u0001a\u0001\u0002\u0004%\t!\u001a\u0005\nO\u0002\u0001\r\u0011!Q!\n\u0005Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u00191\b\u0001)A\u0005a\"9q\u000f\u0001b\u0001\n\u0003A\bBB@\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002,!9\u0011Q\n\u0001\u0005\u0002\u0005-raBA,E!\u0005\u0011\u0011\f\u0004\u0007C\tB\t!a\u0017\t\r9jB\u0011AA/\u0011\u001d\ty&\bC\u0001\u0003CBq!a\u001d\u001e\t\u0003\t)HA\u000bPEN,'O^3s!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005\r\"\u0013aB2mkN$XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\u0005i&lW-F\u00015!\t)\u0004(D\u00017\u0015\t9D%A\u0003vi&d7/\u0003\u0002:m\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0005ce>\\WM]%e+\u0005i\u0004CA\u0015?\u0013\ty$FA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u00151|w-T1oC\u001e,'/F\u0001D!\t!u)D\u0001F\u0015\t1E%A\u0002m_\u001eL!\u0001S#\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0005-s\u0005CA\u0015M\u0013\ti%F\u0001\u0003V]&$\bbB(\b\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\n\u0014a\u00037pO6\u000bg.Y4fe\u0002\na\u0001^7q\t&\u0014X#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016AA5p\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fHCA&^\u0011\u001dy%\"!AA\u0002M\u000bq\u0001^7q\t&\u0014\b%A\u0005qCJ$\u0018\u000e^5p]V\t\u0011\r\u0005\u00022E&\u00111M\t\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fHCA&g\u0011\u001dyU\"!AA\u0002\u0005\f!\u0002]1si&$\u0018n\u001c8!\u0003=!W\r\\1z\u001fB,'/\u0019;j_:\u001cX#\u00016\u0011\u0005EZ\u0017B\u00017#\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u0001\u0011I\u0016d\u0017-_(qKJ\fG/[8og\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005M$\u0013AB:feZ,'/\u0003\u0002ve\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%A\tpM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiN,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yJ\f1b\u00195fG.\u0004x.\u001b8ug&\u0011ap\u001f\u0002\u0012\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\u0018AE8gMN,Go\u00115fG.\u0004x.\u001b8ug\u0002\n\u0011#[:s\u0007\"\fgnZ3MSN$XM\\3s+\t\t)\u0001E\u00022\u0003\u000fI1!!\u0003#\u0005EI5O]\"iC:<W\rT5ti\u0016tWM]\u0001\u0013SN\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005E\u0001\u0003BA\n\u0003Gi!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\nYB\u0003\u0003\u0002\u001e\u0005}\u0011AB1qC\u000eDWM\u0003\u0002\u0002\"\u0005\u0019qN]4\n\t\u0005\u0015\u0012Q\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0004H#A&)\u0007e\ty\u0003\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002:\u0005m\u0012a\u00026va&$XM\u001d\u0006\u0005\u0003{\ty\"A\u0003kk:LG/\u0003\u0003\u0002B\u0005M\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u001b\u0003\u000f\u0002B!!\r\u0002J%!\u00111JA\u001a\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0018uKN$\b*[4i/\u0006$XM]7be.Len\u0019:fCN,7oV5uQ>,Ho\u00142tKJ4XM\u001d$fi\u000eD\u0007fA\u000e\u0002RA!\u0011\u0011GA*\u0013\u0011\t)&a\r\u0003\tQ+7\u000f^\u0001\u0016\u001f\n\u001cXM\u001d<feB\u000b'\u000f^5uS>tG+Z:u!\t\tTd\u0005\u0002\u001eQQ\u0011\u0011\u0011L\u0001\fg\u0016,G\rT8h\t\u0006$\u0018\rF\u0004L\u0003G\nY'a\u001c\t\r\u0019{\u0002\u0019AA3!\r!\u0015qM\u0005\u0004\u0003S*%aC!cgR\u0014\u0018m\u0019;M_\u001eDa!!\u001c \u0001\u0004i\u0014A\u00038v[J+7m\u001c:eg\"1\u0011\u0011O\u0010A\u0002u\n1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!\u0011qOAB!\u0011\tI(a \u000e\u0005\u0005m$bAA?/\u0006!Q\u000f^5m\u0013\u0011\t\t)a\u001f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002\u0006\u0002\u0002\r!a\"\u0002\u0013=4XM\u001d:jI\u0016\u001c\b\u0003CAE\u0003/\u000bi*!(\u000f\t\u0005-\u00151\u0013\t\u0004\u0003\u001bSSBAAH\u0015\r\t\tJJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U%&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\u000bYJA\u0002NCBT1!!&+!\u0011\tI)a(\n\t\u0005\u0005\u00161\u0014\u0002\u0007'R\u0014\u0018N\\4")
public final class ObserverPartitionTest {
    private final MockTime time = new MockTime();
    private final int brokerId;
    private LogManager logManager;
    private File tmpDir;
    private Partition partition;
    private final DelayedOperations delayOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private final IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
    private final TopicPartition topicPartition = new TopicPartition("test-observer", 0);

    public static Properties createLogProperties(scala.collection.immutable.Map<String, String> map) {
        return ObserverPartitionTest$.MODULE$.createLogProperties(map);
    }

    public static void seedLogData(AbstractLog abstractLog, int n, int n2) {
        ObserverPartitionTest$.MODULE$.seedLogData(abstractLog, n, n2);
    }

    public MockTime time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public DelayedOperations delayOperations() {
        return this.delayOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public IsrChangeListener isrChangeListener() {
        return this.isrChangeListener;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @BeforeEach
    public void setup() {
        Properties logProperties = ObserverPartitionTest$.MODULE$.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "replica"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "observer"))))}))));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        File logDir1 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProperties);
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)Nil$.MODULE$), new LogConfig((Map)logProperties, LogConfig$.MODULE$.apply$default$2()), configRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10), this.time(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.isrChangeListener(), this.delayOperations(), this.metadataCache(), this.logManager(), (Option)new Some(Mockito.mock(TierReplicaManager.class)), (Option)new Some(Mockito.mock(TierStateFetcher.class)), (Option)None$.MODULE$, (AlterIsrManager)Mockito.mock(AlterIsrManager.class)));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    @AfterEach
    public void tearDown() {
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testHighWatermarkIncreasesWithoutObserverFetch() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int followerId = this.brokerId() + 1;
        int observerId = followerId + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)Nil$.MODULE$))).asJava();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        ObserverPartitionTest$.MODULE$.seedLogData(log, 6, 4);
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topicPartition().topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertTrue((boolean)this.partition().updateFollowerFetchState(observerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 3L), (String)"Leader didn't recognize replica");
        Assertions.assertTrue((boolean)this.partition().updateFollowerFetchState(followerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 5L), (String)"Leader didn't recognize replica");
        Assertions.assertEquals((long)this.partition().localLogOrException().highWatermark(), (long)5L, (String)"Expect the highwatermark to only include followers");
    }

    public ObserverPartitionTest() {
        this.brokerId = 101;
    }
}

