/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004M\u0001\u0001\u0006Ia\u0011\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003C\u0011\u0019q\u0005\u0001)A\u0005\u0007\"9q\n\u0001b\u0001\n\u0013\u0011\u0005B\u0002)\u0001A\u0003%1\tC\u0004R\u0001\t\u0007I\u0011\u0002*\t\r%\u0004\u0001\u0015!\u0003T\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015a\b\u0001\"\u0001l\u0011\u0015q\b\u0001\"\u0001l\u0011\u0019\t\t\u0001\u0001C\u0001W\"1\u0011Q\u0001\u0001\u0005\u0002-Da!!\u0003\u0001\t\u0003Y\u0007BBA\u0007\u0001\u0011\u00051\u000e\u0003\u0004\u0002\u0012\u0001!\ta\u001b\u0005\u0007\u0003+\u0001A\u0011A6\t\r\u0005e\u0001\u0001\"\u0001l\u0011\u0019\ti\u0002\u0001C\u0001W\"1\u0011\u0011\u0005\u0001\u0005\u0002-Da!!\n\u0001\t\u0003Y\u0007BBA\u0015\u0001\u0011\u00051\u000e\u0003\u0004\u0002.\u0001!\ta\u001b\u0005\t\u0003c\u0001\u0001\u0015\"\u0003\u00024!1\u0011Q\f\u0001\u0005\u0002-Da!!\u0019\u0001\t\u0003Y\u0007BBA3\u0001\u0011\u00051\u000e\u0003\u0004\u0002j\u0001!\ta\u001b\u0005\u0007\u0003[\u0002A\u0011A6\t\r\u0005E\u0004\u0001\"\u0001l\u0011\u0019\t)\b\u0001C\u0001W\"1\u0011\u0011\u0010\u0001\u0005\u0002-Da!! \u0001\t\u0003Y\u0007BBAA\u0001\u0011\u00051\u000e\u0003\u0004\u0002\u0006\u0002!\ta\u001b\u0005\u0007\u0003\u0013\u0003A\u0011A6\t\r\u00055\u0005\u0001\"\u0001l\u0011\u0019\t\t\n\u0001C\u0001W\"1\u0011Q\u0013\u0001\u0005\u0002-Da!!'\u0001\t\u0003Y\u0007BBAO\u0001\u0011\u00051\u000e\u0003\u0004\u0002\"\u0002!\ta\u001b\u0005\u0007\u0003K\u0003A\u0011A6\t\r\u0005%\u0006\u0001\"\u0001l\u0011\u0019\ti\u000b\u0001C\u0001W\"1\u0011\u0011\u0017\u0001\u0005\u0002-\u0014Ab\u00142tKJ4XM\u001d+fgRT!AM\u001a\u0002\u000f\rdWo\u001d;fe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fA\u0011\u0001\tA\u0007\u0002c\u0005!Co\u001c9jG^KG\u000f[(cg\u0016\u0014h/\u001a:QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG/F\u0001D!\rADIR\u0005\u0003\u000bf\u0012aa\u00149uS>t\u0007CA$K\u001b\u0005A%BA%4\u0003\u0019\u0019w.\\7p]&\u00111\n\u0013\u0002\u000f)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0003\u0015\"x\u000e]5d/&$\bn\u00142tKJ4XM\u001d)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\b%A\u0014u_BL7mV5uQR;xn\u00142tKJ4XM\u001d)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\u0018\u0001\u000b;pa&\u001cw+\u001b;i)^|wJY:feZ,'\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004\u0013a\b;pa&\u001cw+\u001b;i_V$xJY:feZ,'o]\"p]N$(/Y5oi\u0006\u0001Co\u001c9jG^KG\u000f[8vi>\u00137/\u001a:wKJ\u001c8i\u001c8tiJ\f\u0017N\u001c;!\u0003Q\tG\u000e\u001c\"s_.,'o]!uiJL'-\u001e;fgV\t1\u000b\u0005\u0003U3nsV\"A+\u000b\u0005Y;\u0016!C5n[V$\u0018M\u00197f\u0015\tA\u0016(\u0001\u0006d_2dWm\u0019;j_:L!AW+\u0003\u00075\u000b\u0007\u000f\u0005\u000299&\u0011Q,\u000f\u0002\u0004\u0013:$\b\u0003B0aC\u0006l\u0011aV\u0005\u00035^\u0003\"AY4\u000e\u0003\rT!\u0001Z3\u0002\t1\fgn\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0004TiJLgnZ\u0001\u0016C2d'I]8lKJ\u001c\u0018\t\u001e;sS\n,H/Z:!\u0003\u001d\"Xm\u001d;QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG\u000f\u0015:fI&\u001c\u0017\r^3Tk\u000e\u001cWm]:\u0015\u00031\u0004\"\u0001O7\n\u00059L$\u0001B+oSRD#A\u00039\u0011\u0005ETX\"\u0001:\u000b\u0005M$\u0018aA1qS*\u0011QO^\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\b0A\u0003kk:LGOC\u0001z\u0003\ry'oZ\u0005\u0003wJ\u0014A\u0001V3ti\u00069C/Z:u!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e)sK\u0012L7-\u0019;f\r\u0006LG.\u001e:fQ\tY\u0001/A\u0017uKN$\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oiB\u0013X\rZ5dCR,gj\\\"p]N$(/Y5oiND#\u0001\u00049\u0002YQ,7\u000f\u001e)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\bK]3eS\u000e\fG/\u001a(p\u0005J|7.\u001a:SC\u000e\\\u0007FA\u0007q\u0003U!Xm\u001d;NKJ<W\rR5tU>Lg\u000e^'baND#A\u00049\u0002#Q,7\u000f^'fe\u001e,W)\u001c9us6\u000b\u0007\u000f\u000b\u0002\u0010a\u0006)B/Z:u\u001b\u0016\u0014x-Z'baZ\u000bG.^3TC6,\u0007F\u0001\tq\u0003M!Xm\u001d;NKJ<W-T1q\u0017\u0016L8+Y7fQ\t\t\u0002/\u0001\u000euKN$X*\u001a:hK\u0012K7O[8j]R\u001cV-];f]\u000e,7\u000f\u000b\u0002\u0013a\u00069B/Z:u\u001b\u0016\u0014x-Z#naRL8+Z9vK:\u001cWm\u001d\u0015\u0003'A\f\u0011$\\3sO\u0016tuN\u001c#jg*|\u0017N\u001c;TKF,XM\\2fg\"\u0012A\u0003]\u0001!i\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ce>\\WM]:Cs\u000e{gn\u001d;sC&tG\u000f\u000b\u0002\u0016a\u0006aC/Z:u!\u0006\u0014H/\u001b;j_:\u0014%o\\6feN\u0014\u0015pQ8ogR\u0014\u0018-\u001b8u\u0013:4\u0018\r\\5e\u0007>,h\u000e\u001e\u0015\u0003-A\fA\u0006^3tiJ\u000b7m[+oC^\f'/\u001a(p\u0007>t7\u000f\u001e:bS:$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0005]\u0001\u0018A\u0010;fgR\u0014\u0016mY6V]\u0006<\u0018M]3SKBd\u0017nY1BgNLwM\\7f]R<\u0016\u000e\u001e5QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG/T5tg&tw\r\u000b\u0002\u0019a\u0006!c/\u00197jI\u0006$XMU1dWVs\u0017m^1sKJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fF\u0003m\u0003k\tY\u0005C\u0004\u00028e\u0001\r!!\u000f\u0002\u000f\t\u0014xn[3sgB)A+a\u000f\u0002@%\u0019\u0011QH+\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)eM\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\bCe>\\WM]'fi\u0006$\u0017\r^1\t\u000f\u00055\u0013\u00041\u0001\u0002P\u0005Y\u0011m]:jO:lWM\u001c;t!\u0015y\u0006mWA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,g\u0005Q1m\u001c8ue>dG.\u001a:\n\t\u0005m\u0013Q\u000b\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018A\u000b;fgR\u0014\u0016mY6Bo\u0006\u0014XMT8D_:\u001cHO]1j]R\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u00035A\fA\u0006^3tiJ\u000b7m[!xCJ,w+\u001b;i\u0007>t7\u000f\u001e:bS:$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0005m\u0001\u0018A\u000f;fgR\u0014\u0016mY6Bo\u0006\u0014XmV5uQ\u000e{gn\u001d;sC&tGOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u/&$\bn\u0015;beRLe\u000eZ3yQ\ta\u0002/A\u000ewC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:LgnZ*vG\u000e,7o\u001d\u0015\u0003;A\f1D^1mS\u0012\fG/\u001a)beRLG/[8oS:<g)Y5mkJ,\u0007F\u0001\u0010q\u000352\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\\5oO\u001a\u000b\u0017\u000e\\;sK6+H\u000e^5qY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003?A\f\u0011\u0006^3tiZ\u000bG.\u001b3bi\u0016\u0014V\r\u001d7jG\u0006\u001chj\u001c)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$\bF\u0001\u0011q\u0003}!Xm\u001d;WC2LG-\u0019;f\u001f\n\u001cXM\u001d<feN\u001cuN\\:ue\u0006Lg\u000e\u001e\u0015\u0003CA\fQ\u0005^3tiZ\u000bG.\u001b3bi\u0016\u0014V\r\u001d7jG\u0006\u001cX*\u0019;dQ\u0016\u001c8i\u001c8tiJ\f\u0017N\u001c;)\u0005\t\u0002\u0018a\n;fgR4\u0016\r\\5eCR,'+\u001a9mS\u000e\f7o\u0014<fe\u000e{gn\u001d;sC&tGoQ8v]RD#a\t9\u0002QQ,7\u000f\u001e,bY&$\u0017\r^3SKBd\u0017nY1t+:$WM]\"p]N$(/Y5oi\u000e{WO\u001c;)\u0005\u0011\u0002\u0018\u0001\r;fgR\u0014V\r\u001d7jG\u0006Le\u000eZ5wS\u0012,\u0018\r\\\"p]N$(/Y5oi\u000e{WO\u001c;O_R\u001c\u0016\r^5tM&,G\r\u000b\u0002&a\u0006iB/Z:u\u001f\n\u001cXM\u001d<fe6\u000bGo\u00195fg\u000e{gn\u001d;sC&tG\u000f\u000b\u0002'a\u0006AB/Z:u\u0013:4\u0018\r\\5e\u001f\n\u001cXM\u001d<fe\u000e{WO\u001c;)\u0005\u001d\u0002\u0018\u0001\b;fgRLeN^1mS\u0012|%m]3sm\u0016\u0014\u0018\t\u001e;sS\n,H/\u001a\u0015\u0003QA\fq\u0004^3tiJ+\u0007\u000f\\5dCND\u0015m](cg\u0016\u0014h/\u001a:BgN+hMZ5yQ\tI\u0003/A\u000buKN$hj\u001c#va2L7-\u0019*fa2L7-Y:)\u0005)\u0002\u0018\u0001\u0007;fgRtuNT3hCRLg/\u001a*fa2L7-Y%eg\"\u00121\u0006]\u0001(i\u0016\u001cHOV1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u\u00032dwJ\u001a4mS:,wJY:feZ,'\u000f\u000b\u0002-a\u00069C/Z:u-\u0006d\u0017\u000e\u001a*fCN\u001c\u0018n\u001a8nK:$xJ\\3PM\u001ad\u0017N\\3PEN,'O^3sQ\ti\u0003/A\u0015uKN$\u0018J\u001c<bY&$'+Z1tg&<g.\\3oi:+wo\u00144gY&tWm\u00142tKJ4XM\u001d\u0015\u0003]A\f!\u0005^3ti&sg/\u00197jIJ+\u0017m]:jO:lWM\u001c;PM\u001ad\u0017N\\3Ts:\u001c\u0007FA\u0018q\u0001")
public class ObserverTest {
    private final Option<TopicPlacement> topicWithObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithTwoObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithoutObserversConstraint;
    private final scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes;

    private Option<TopicPlacement> topicWithObserverPlacementConstraint() {
        return this.topicWithObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithTwoObserverPlacementConstraint() {
        return this.topicWithTwoObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithoutObserversConstraint() {
        return this.topicWithoutObserversConstraint;
    }

    private scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes() {
        return this.allBrokersAttributes;
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"));
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateSuccess$1(replicaBroker, observerBroker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateFailure$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"));
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$);
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable & scala.Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateNoBrokerRack$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMergeDisjointMaps() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        scala.collection.mutable.Map mergedMap = Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap);
        Assertions.assertEquals((Object)firstMap.$plus$plus((GenTraversableOnce)secondMap), (Object)mergedMap);
    }

    @Test
    public void testMergeEmptyMap() {
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(assignmentMap, (Map)Map$.MODULE$.empty()));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)assignmentMap));
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeAssignmentMap(Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty()));
    }

    @Test
    public void testMergeMapValueSame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 16))}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeMapKeySame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}));
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 15))}))), (Object)Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20);
        Assertions.assertEquals((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testMergeEmptySequences() {
        Range.Inclusive testSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)testSeq, (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Nil$.MODULE$, (Seq)testSeq));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$));
    }

    @Test
    public void mergeNonDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 15);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testPartitionBrokersByConstraint() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$1 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)x$2 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$2(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(21), 30).map((Function1 & Serializable & scala.Serializable)x$3 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$3(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
        Seq replicasTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, seq);
        Seq replicas = (Seq)replicasTuple.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Seq replica = (Seq)x0$1._2();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom()), (Object)replicas);
        Seq replicaCount = (Seq)replicasTuple.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$6(x0$2)), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicaCount);
        seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala();
        Seq observersTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, seq);
        Seq observers = (Seq)observersTuple.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            void var1_1;
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            Seq observer = (Seq)x0$3._2();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)west1Brokers, (Object)observers);
        Seq observersCount = (Seq)observersTuple.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$8(x0$4)), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)observersCount);
    }

    @Test
    public void testPartitionBrokersByConstraintInvalidCount() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}")).stripMargin();
        IndexedSeq east1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$4 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$1(BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq east2Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 13).map((Function1 & Serializable & scala.Serializable)x$5 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$2(BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq west1Brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(14), 20).map((Function1 & Serializable & scala.Serializable)x$6 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$3(BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq allBrokers = (IndexedSeq)((TraversableLike)east1Brokers.$plus$plus((GenTraversableOnce)east2Brokers, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)west1Brokers, IndexedSeq$.MODULE$.canBuildFrom());
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Function1 & Serializable & scala.Serializable partitionFunction = (Function1 & Serializable & scala.Serializable)constraints -> Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, constraints);
        Seq seq = (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala();
        Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, constraints);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> partitionFunction.apply(CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala()));
    }

    @Test
    public void testRackUnawareNoConstraintReplicaAssignment() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$7 -> ObserverTest.$anonfun$testRackUnawareNoConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
    }

    @Test
    public void testRackUnawareReplicaAssignmentWithPlacementConstraintMissing() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$8 -> ObserverTest.$anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)"{\"version\":1, \"replicas\":[{\"count\":3}]}"))), numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
    }

    private void validateRackUnawareReplicaAssignment(IndexedSeq<BrokerMetadata> brokers2, Map<Object, ReplicaAssignment> assignments) {
        ((Iterable)((GenericTraversableTemplate)assignments.values().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$2(assignedPartitions);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)assignments.values().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)brokers -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$6(brokers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareNoConstraintReplicaAssignment() {
        int numPartitions = 9;
        int replicationFactor = 3;
        IndexedSeq racks = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).flatMap((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq brokers = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).zip((GenIterable)racks, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int id = x0$1._1$mcI$sp();
            String rack = (String)x0$1._2();
            BrokerMetadata brokerMetadata = new BrokerMetadata(id, (Option)new Some((Object)rack));
            return brokerMetadata;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        ((IterableLike)assignments.values().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$5(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((GenericTraversableTemplate)assignments.values().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$7(assignedBrokers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignment() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 3,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack2\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}")).stripMargin();
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$3(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.observers(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$8(observers);
            return BoxedUnit.UNIT;
        });
        ((Iterable)((GenericTraversableTemplate)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.replicas(), Iterable$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$11(assignedPartitions);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithStartIndex() {
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 4,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 3,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}")).stripMargin();
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 15, 3, 2, 3);
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 11, 13}));
        Set matchingAssignment = ((TraversableOnce)partitionAssignment.values().filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(expectedObservers, x$16)))).toSet();
        Assertions.assertTrue((boolean)matchingAssignment.nonEmpty(), (String)new StringBuilder(14).append(expectedObservers).append(" not found in ").append(partitionAssignment.values()).toString());
        Set matchingReplicas = (Set)matchingAssignment.map((Function1 & Serializable & scala.Serializable)x$17 -> (Seq)x$17.replicas().slice(0, 4), Set$.MODULE$.canBuildFrom());
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3, 4}));
        Assertions.assertTrue((boolean)matchingReplicas.contains((Object)expectedReplicas), (String)new StringBuilder(14).append(expectedReplicas).append(" not found in ").append(matchingAssignment).toString());
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.replicas(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$5(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)partitionAssignment.values().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.observers(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$9(observers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void validatePartitioningSuccess() {
        IndexedSeq partitionedBrokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable & scala.Serializable)partitionNumber -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)partitionNumber))), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> ObserverTest.$anonfun$validatePartitioningSuccess$2(partitionNumber, BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom())), IndexedSeq$.MODULE$.canBuildFrom());
        Observer$.MODULE$.validatePartitioning((Seq)partitionedBrokers);
    }

    @Test
    public void validatePartitioningFailure() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        .colon.colon partitionedBrokers = new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailure$1((Seq)partitionedBrokers));
    }

    @Test
    public void validatePartitioningFailureMultiplePartitions() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1")), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$));
        .colon.colon partitionedBrokers = new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), new .colon.colon((Object)new BrokerMetadata(5, (Option)new Some((Object)"rack-1")), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)commonBrokers, List$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$)));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailureMultiplePartitions$1((Seq)partitionedBrokers));
    }

    @Test
    public void testValidateReplicasNoPlacementConstraint() {
        Observer$.MODULE$.validateAssignment((Option)None$.MODULE$, new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
    }

    @Test
    public void testValidateObserversConstraint() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.error()));
    }

    @Test
    public void testValidateReplicasMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
    }

    @Test
    public void testValidateReplicasOverConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.error()));
    }

    @Test
    public void testValidateReplicasUnderConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.error()));
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfied() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 5, 6, 7})), (Seq)Nil$.MODULE$), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.error()));
    }

    @Test
    public void testObserverMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6)), this.allBrokersAttributes());
    }

    @Test
    public void testInvalidObserverCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7)), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.error()));
    }

    @Test
    public void testInvalidObserverAttribute() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 9}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.error()));
    }

    @Test
    public void testReplicasHasObserverAsSuffix() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.error()));
    }

    @Test
    public void testNoDuplicaReplicas() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 1})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.error()));
    }

    @Test
    public void testNoNegativeReplicaIds() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, -2})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.error()));
    }

    @Test
    public void testValidReassignmentAllOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus$minus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.error()));
    }

    @Test
    public void testValidReassignmentOneOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.error()));
    }

    @Test
    public void testInvalidReassignmentNewOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})), IndexedSeq$.MODULE$.canBuildFrom()))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.error()));
    }

    @Test
    public void testInvalidReassignmentOfflineSync() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), IndexedSeq$.MODULE$.canBuildFrom()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.error()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$allBrokersAttributes$1(int id) {
        switch (id) {
            default: 
        }
        String rack = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).contains(id) ? "east-1" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 4).contains(id) ? "east-2" : (RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(5), 7).contains(id) ? "west-1" : "west-2"));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), (Object)rack)})));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateSuccess$1(BrokerMetadata replicaBroker$1, BrokerMetadata observerBroker$1, TopicPlacement topicPlacement) {
        Buffer replicaConstraints = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)replicaConstraints.head()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)((IterableLike)replicaConstraints.tail()).head()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(observerBroker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateFailure$1(BrokerMetadata broker$1, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateNoBrokerRack$1(BrokerMetadata broker$2, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$1(int x$1) {
        return new BrokerMetadata(x$1, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$2(int x$2) {
        return new BrokerMetadata(x$2, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$3(int x$3) {
        return new BrokerMetadata(x$3, (Option)new Some((Object)"west-1"));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$6(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int count = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$8(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        int count = x0$4._1$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$1(int x$4) {
        return new BrokerMetadata(x$4, (Option)new Some((Object)"east-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$2(int x$5) {
        return new BrokerMetadata(x$5, (Option)new Some((Object)"east-2"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$3(int x$6) {
        return new BrokerMetadata(x$6, (Option)new Some((Object)"west-1"));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareNoConstraintReplicaAssignment$1(int x$7) {
        return new BrokerMetadata(x$7, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(int x$8) {
        return new BrokerMetadata(x$8, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$4(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$2(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable & scala.Serializable)brokerIds -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$4(brokerIds);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)10, (int)assignedPartitions.size());
        Assertions.assertEquals((int)5, (int)assignedPartitions.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$6(Seq brokers) {
        Assertions.assertEquals((int)3, (int)brokers.size());
    }

    public static final /* synthetic */ List $anonfun$testRackAwareNoConstraintReplicaAssignment$1(int id) {
        return (List)List$.MODULE$.fill(3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append("rack").append(id).toString());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$5(Seq assignedBrokers) {
        Assertions.assertEquals((int)3, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$7(Iterable assignedBrokers) {
        Assertions.assertEquals((int)9, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignment$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$3(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableLike)assignedBrokers.take(3)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(3, 5)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$8(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$13(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$11(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable & scala.Serializable)brokerIds -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$13(brokerIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ boolean $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(Seq expectedObservers$1, ReplicaAssignment x$16) {
        return x$16.observers().equals((Object)expectedObservers$1);
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$5(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableLike)assignedBrokers.take(4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableLike)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$9(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$validatePartitioningSuccess$2(int partitionNumber$1, int brokerId) {
        return new BrokerMetadata(partitionNumber$1 * 5 + brokerId, (Option)new Some((Object)"rack"));
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailure$1(Seq partitionedBrokers$1) {
        Observer$.MODULE$.validatePartitioning(partitionedBrokers$1);
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailureMultiplePartitions$1(Seq partitionedBrokers$2) {
        Observer$.MODULE$.validatePartitioning(partitionedBrokers$2);
    }

    public ObserverTest() {
        String placementJson = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"observers\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"observers\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"replicas\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")).stripMargin();
        this.topicWithTwoObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson2)));
        String placementJsonWithoutObservers = new StringOps(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"west-1\"\n      |      }\n      |    }\n      |  ]\n      |}")).stripMargin();
        this.topicWithoutObserversConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutObservers)));
        this.allBrokersAttributes = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable & scala.Serializable)id -> ObserverTest.$anonfun$allBrokersAttributes$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

