/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$;
import kafka.controller.ControlMetadataBatchIntegrationTest$KafkaControllerTest$;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DelegationTokenManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCQA\u0013\u0001\u0005\u0002-CQa\u0018\u0001\u0005\n\u00014Aa\u001b\u0001\u0001Y\"A!\r\u0002BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005r\t\t\u0005\t\u0015!\u0003d\u0011\u00151E\u0001\"\u0001s\u0011\u001d1HA1A\u0005\u0002]DaA \u0003!\u0002\u0013A\b\u0002C@\u0005\u0005\u0004%\t!!\u0001\t\u0011\u0005%A\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0005\u0001\u0004%\t!!\u0004\t\u0013\u0005mA\u00011A\u0005\u0002\u0005u\u0001\u0002CA\u0012\t\u0001\u0006K!a\u0004\t\r\u0005\u0015B\u0001\"\u0001L\u0011\u0019\t9\u0003\u0002C\u0001\u0017\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003k\u0001A\u0011BA\u001c\r\u0019\tY\u0004\u0001\u0001\u0002>!Aa\u000f\u0006BC\u0002\u0013\u0005s\u000f\u0003\u0006\u007f)\t\u0005\t\u0015!\u0003y\u0003\u000bB!\"a\u0003\u0015\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\t9\u0005\u0006B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003?\"\"\u0011!Q\u0001\n\u0005\u0005\u0004BCA6)\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u0011Q\u000e\u000b\u0003\u0002\u0003\u0006I!a\u001c\t\u0015\u0005UDC!A!\u0002\u0013\t9\b\u0003\u0006\u0002~Q\u0011\t\u0011)A\u0005\u0003\u007fB!\"!%\u0015\u0005\u0003\u0005\u000b\u0011BAJ\u0011)\tY\u000b\u0006B\u0001B\u0003%\u0011Q\u0016\u0005\u000b\u0003g#\"\u0011!Q\u0001\n\u0005U\u0006B\u0002$\u0015\t\u0003\tY\fC\u0004\u0002VR!\t%a6\b\u0013\u0005m\b!!A\t\u0002\u0005uh!CA\u001e\u0001\u0005\u0005\t\u0012AA\u0000\u0011\u00191E\u0005\"\u0001\u0003\u0002!I!1\u0001\u0013\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u00057!\u0013\u0013!C\u0001\u0005;A\u0011B!\t%#\u0003%\tAa\t\u0007\r\t\u001d\u0002\u0001\u0001B\u0015\u0011)\t\t/\u000bB\u0001B\u0003%\u00111\u001d\u0005\tm&\u0012\t\u0011)A\u0005q\"Q\u0011qI\u0015\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005}\u0013F!A!\u0002\u0013\t\t\u0007\u0003\u0006\u0002r&\u0012\t\u0011)A\u0005\u0003gD!\"!%*\u0005\u0003\u0005\u000b\u0011BAJ\u0011\u00191\u0015\u0006\"\u0001\u0003,!9!1H\u0015\u0005R\tu\u0002b\u0002B(S\u0011E#\u0011\u000b\u0005\b\u0005/JC\u0011\u000bB-\u0011\u001d\u0011)&\u000bC\u0001\u0005;:\u0011B!\u0019\u0001\u0003\u0003E\tAa\u0019\u0007\u0013\t\u001d\u0002!!A\t\u0002\t\u0015\u0004B\u0002$7\t\u0003\u00119\u0007C\u0005\u0003jY\n\n\u0011\"\u0001\u0003$\t\u00193i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u001e=\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\t\u0019E(\u0001\u0002{W&\u0011QI\u0011\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0005CA%\u0001\u001b\u0005Q\u0014A\u000f;fgRdU-\u00193fe\u0006sG-S:s\t>,7OT8u%\u00164WM\u001d+p\u0005J|7.\u001a:t\u001d>$\u0018J\\'fi\u0006$\u0017\r^1DC\u000eDW-W3u)\u0005a\u0005CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%\u0001B+oSRD#AA*\u0011\u0005QkV\"A+\u000b\u0005Y;\u0016aA1qS*\u0011\u0001,W\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ6,A\u0003kk:LGOC\u0001]\u0003\ry'oZ\u0005\u0003=V\u0013A\u0001V3ti\u0006Qc/\u001a:jMfdU-\u00193fe\u0006sG-S:s\u0005\u0006$8\r\u001b*fM\u0016\u0014Hk\\&o_^t'I]8lKJ\u001cHc\u0001'bM\")!m\u0001a\u0001G\u0006A!M]8lKJLE\r\u0005\u0002NI&\u0011QM\u0014\u0002\u0004\u0013:$\b\"B4\u0004\u0001\u0004A\u0017a\u00042s_.,'o\u0015;bi\u0016LeNZ8\u0011\u0005%K\u0017B\u00016;\u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\u0003\u0015Q+7\u000f\u001e\"s_.,'o\u0005\u0002\u0005[B\u0011QJ\\\u0005\u0003_:\u0013a!\u00118z%\u00164W#A2\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004CCA:v!\t!H!D\u0001\u0001\u0011\u0015\u0011w\u00011\u0001d\u0003\u0019\u0019wN\u001c4jOV\t\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002|y\u000511/\u001a:wKJL!! >\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003)\u0011'o\\6fe&sgm\\\u000b\u0003\u0003\u0007\u00012!QA\u0003\u0013\r\t9A\u0011\u0002\u000b\u0005J|7.\u001a:J]\u001a|\u0017a\u00032s_.,'/\u00138g_\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0003\u0003\u001f\u0001R!TA\t\u0003+I1!a\u0005O\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011)a\u0006\n\u0007\u0005e!IA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\ru.\u001cE.[3oi~#S-\u001d\u000b\u0004\u0019\u0006}\u0001\"CA\u0011\u001b\u0005\u0005\t\u0019AA\b\u0003\rAH%M\u0001\nu.\u001cE.[3oi\u0002\nqaY8o]\u0016\u001cG/\u0001\u0006eSN\u001cwN\u001c8fGR\fAb\u0019:fCR,7i\u001c8gS\u001e$2\u0001_A\u0017\u0011\u0015\u0011\u0017\u00031\u0001d\u0003A\u0019'/Z1uK\n\u0013xn[3s\u0013:4w\u000e\u0006\u0003\u0002\u0004\u0005M\u0002\"\u0002<\u0013\u0001\u0004A\u0018AD2sK\u0006$XMW6DY&,g\u000e\u001e\u000b\u0005\u0003+\tI\u0004C\u0003w'\u0001\u0007\u0001PA\nLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s)\u0016\u001cHoE\u0002\u0015\u0003\u007f\u00012!SA!\u0013\r\t\u0019E\u000f\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&\u0019a/!\u0011\u0002\tQLW.\u001a\t\u0005\u0003\u0017\nY&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0015)H/\u001b7t\u0015\u0011\t\u0019&!\u0016\u0002\r\r|W.\\8o\u0015\ri\u0014q\u000b\u0006\u0004\u00033Z\u0016AB1qC\u000eDW-\u0003\u0003\u0002^\u00055#\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002d\u0005\u001dTBAA3\u0015\u0011\ty&!\u0015\n\t\u0005%\u0014Q\r\u0002\b\u001b\u0016$(/[2t\u0003EIg.\u001b;jC2\u0014%o\\6fe&sgm\\\u0001\u0013S:LG/[1m\u0005J|7.\u001a:Fa>\u001c\u0007\u000eE\u0002N\u0003cJ1!a\u001dO\u0005\u0011auN\\4\u0002\u0019Q|7.\u001a8NC:\fw-\u001a:\u0011\u0007e\fI(C\u0002\u0002|i\u0014a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u0014i&,'\u000fV8qS\u000el\u0015M\\1hKJ|\u0005\u000f\u001e\t\u0006\u001b\u0006E\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0015!x\u000e]5d\u0015\r\tY\tP\u0001\u0005i&,'/\u0003\u0003\u0002\u0010\u0006\u0015%\u0001\u0005+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0003N\u0003#\t)\n\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003C\u00032!a'O\u001b\t\tiJC\u0002\u0002 z\na\u0001\u0010:p_Rt\u0014bAAR\u001d\u00061\u0001K]3eK\u001aLA!a*\u0002*\n11\u000b\u001e:j]\u001eT1!a)O\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN\u00042!_AX\u0013\r\t\tL\u001f\u0002\u000f\u0005J|7.\u001a:GK\u0006$XO]3t\u000311W-\u0019;ve\u0016\u001c\u0015m\u00195f!\rI\u0018qW\u0005\u0004\u0003sS(!\u0006$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.\u001a\u000b\u0019\u0003{\u000by,!1\u0002D\u0006\u0015\u0017qYAe\u0003\u0017\fi-a4\u0002R\u0006M\u0007C\u0001;\u0015\u0011\u00151\u0018\u00051\u0001y\u0011\u001d\tY!\ta\u0001\u0003+Aq!a\u0012\"\u0001\u0004\tI\u0005C\u0004\u0002`\u0005\u0002\r!!\u0019\t\u000f\u0005-\u0014\u00051\u0001\u0002\u0004!9\u0011QN\u0011A\u0002\u0005=\u0004\"CA;CA\u0005\t\u0019AA<\u0011%\ti(\tI\u0001\u0002\u0004\ty\bC\u0005\u0002\u0012\u0006\u0002\n\u00111\u0001\u0002\u0014\"9\u00111V\u0011A\u0002\u00055\u0006bBAZC\u0001\u0007\u0011QW\u0001\u001c]\u0016<8i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0015\u001d\u0005e\u0017q\\Au\u0003W\fi/a<\u0002zB\u0019\u0011*a7\n\u0007\u0005u'H\u0001\rD_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJDq!!9#\u0001\u0004\t\u0019/A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u00042!SAs\u0013\r\t9O\u000f\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\b\"\u0002<#\u0001\u0004A\bbBA$E\u0001\u0007\u0011\u0011\n\u0005\b\u0003?\u0012\u0003\u0019AA1\u0011\u001d\t\tP\ta\u0001\u0003g\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\rI\u0015Q_\u0005\u0004\u0003oT$!E*uCR,7\t[1oO\u0016dunZ4fe\"9\u0011\u0011\u0013\u0012A\u0002\u0005M\u0015aE&bM.\f7i\u001c8ue>dG.\u001a:UKN$\bC\u0001;%'\t!S\u000e\u0006\u0002\u0002~\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"Aa\u0002+\t\u0005]$\u0011B\u0016\u0003\u0005\u0017\u0001BA!\u0004\u0003\u00185\u0011!q\u0002\u0006\u0005\u0005#\u0011\u0019\"A\u0005v]\u000eDWmY6fI*\u0019!Q\u0003(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001a\t=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"Aa\b+\t\u0005}$\u0011B\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\u0015\"\u0006BAJ\u0005\u0013\u0011AdQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s)\u0016\u001cHoE\u0002*\u00033$bB!\f\u00030\tE\"1\u0007B\u001b\u0005o\u0011I\u0004\u0005\u0002uS!9\u0011\u0011\u001d\u0019A\u0002\u0005\r\b\"\u0002<1\u0001\u0004A\bbBA$a\u0001\u0007\u0011\u0011\n\u0005\b\u0003?\u0002\u0004\u0019AA1\u0011\u001d\t\t\u0010\ra\u0001\u0003gD\u0011\"!%1!\u0003\u0005\r!a%\u0002\u0019\u0005$GMT3x\u0005J|7.\u001a:\u0015\u00071\u0013y\u0004C\u0004\u0003BE\u0002\rAa\u0011\u0002\r\t\u0014xn[3s!\u0011\u0011)Ea\u0013\u000e\u0005\t\u001d#b\u0001B%y\u000591\r\\;ti\u0016\u0014\u0018\u0002\u0002B'\u0005\u000f\u0012aA\u0011:pW\u0016\u0014\u0018\u0001\u0006:f[>4X-\u0012=jgRLgn\u001a\"s_.,'\u000fF\u0002M\u0005'BaA!\u00163\u0001\u0004A\u0017a\u00032s_.,'o\u0015;bi\u0016\fac\u001d;beR\u0014V-];fgR\u001cVM\u001c3UQJ,\u0017\r\u001a\u000b\u0004\u0019\nm\u0003\"\u000224\u0001\u0004\u0019Gc\u00015\u0003`!)!\r\u000ea\u0001G\u0006a2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:UKN$\bC\u0001;7'\t1T\u000e\u0006\u0002\u0003d\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\u0002")
public class ControlMetadataBatchIntegrationTest
extends ZooKeeperTestHarness {
    private volatile ControlMetadataBatchIntegrationTest$KafkaControllerTest$ KafkaControllerTest$module;
    private volatile ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$ ControllerChannelManagerTest$module;

    public ControlMetadataBatchIntegrationTest$KafkaControllerTest$ KafkaControllerTest() {
        if (this.KafkaControllerTest$module == null) {
            this.KafkaControllerTest$lzycompute$1();
        }
        return this.KafkaControllerTest$module;
    }

    public ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$ ControllerChannelManagerTest() {
        if (this.ControllerChannelManagerTest$module == null) {
            this.ControllerChannelManagerTest$lzycompute$1();
        }
        return this.ControllerChannelManagerTest$module;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet() {
        Metrics metrics = new Metrics();
        TestBroker broker0 = null;
        ObjectRef broker1 = ObjectRef.create(null);
        ObjectRef broker2 = ObjectRef.create(null);
        ObjectRef controller = ObjectRef.create(null);
        try {
            broker0 = new TestBroker(this, 0);
            broker1.elem = new TestBroker(this, 1);
            broker2.elem = new TestBroker(this, 2);
            broker0.connect();
            BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
            KafkaConfig x$1 = broker0.config();
            KafkaZkClient x$2 = (KafkaZkClient)broker0.zkClient().get();
            Time x$3 = Time.SYSTEM;
            BrokerInfo x$5 = broker0.brokerInfo();
            long x$6 = 0L;
            FinalizedFeatureCache x$8 = new FinalizedFeatureCache(brokerFeatures);
            DelegationTokenManager x$9 = this.KafkaControllerTest().$lessinit$greater$default$7();
            Option<TierTopicManager> x$10 = this.KafkaControllerTest().$lessinit$greater$default$8();
            Option<String> x$11 = this.KafkaControllerTest().$lessinit$greater$default$9();
            controller.elem = new KafkaControllerTest(x$1, x$2, x$3, metrics, x$5, x$6, x$9, x$10, x$11, brokerFeatures, x$8);
            ((KafkaController)controller.elem).startup();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$1(controller)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ControllerChannelManagerTest controllerChannelManager = (ControllerChannelManagerTest)((KafkaController)controller.elem).controllerChannelManager();
            ((TestBroker)broker1.elem).connect();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$3(controller, broker1)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((TestBroker)broker2.elem).connect();
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$5(controller, broker2)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.createTopicWithAssignment("topic", new Properties(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Nil$.MODULE$))})), adminZkClient.createTopicWithAssignment$default$4(), adminZkClient.createTopicWithAssignment$default$5(), adminZkClient.createTopicWithAssignment$default$6(), adminZkClient.createTopicWithAssignment$default$7());
            long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$7(controllerChannelManager)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$8());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$9(controllerChannelManager)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$10());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((TestBroker)broker2.elem).disconnect();
            long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime6 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$11(controller, broker2)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$12());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((TestBroker)broker1.elem).disconnect();
            long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime7 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$13(controller, broker1)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$14());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Option leaderAndIsr = ((KafkaController)controller.elem).controllerContext().partitionLeadershipInfo(new TopicPartition("topic", 0));
            Assertions.assertTrue((boolean)leaderAndIsr.isDefined());
            Assertions.assertEquals((int)-1, (int)((LeaderIsrAndControllerEpoch)leaderAndIsr.get()).leaderAndIsr().leader());
            Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)((LeaderIsrAndControllerEpoch)leaderAndIsr.get()).leaderAndIsr().isr());
            ((TestBroker)broker2.elem).connect();
            long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime8 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$15(controller, broker2)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$16());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((TestBroker)broker1.elem).connect();
            long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l18 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime9 = System.currentTimeMillis();
            while (!ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$17(controller, broker1)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControlMetadataBatchIntegrationTest.$anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$18());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.verifyLeaderAndIsrBatchReferToKnownBrokers(1, controllerChannelManager.brokerState(1));
            this.verifyLeaderAndIsrBatchReferToKnownBrokers(2, controllerChannelManager.brokerState(2));
        }
        catch (Throwable throwable) {
            if ((KafkaController)controller.elem != null) {
                ((KafkaController)controller.elem).shutdown();
            }
            if (broker0 != null) {
                broker0.disconnect();
            }
            if ((TestBroker)broker1.elem != null) {
                ((TestBroker)broker1.elem).disconnect();
            }
            if ((TestBroker)broker2.elem != null) {
                ((TestBroker)broker2.elem).disconnect();
            }
            metrics.close();
            throw throwable;
        }
        if ((KafkaController)controller.elem != null) {
            ((KafkaController)controller.elem).shutdown();
        }
        broker0.disconnect();
        if ((TestBroker)broker1.elem != null) {
            ((TestBroker)broker1.elem).disconnect();
        }
        if ((TestBroker)broker2.elem != null) {
            ((TestBroker)broker2.elem).disconnect();
        }
        metrics.close();
    }

    private void verifyLeaderAndIsrBatchReferToKnownBrokers(int brokerId, ControllerBrokerStateInfo brokerStateInfo) {
        Set knownBrokers = Predef$.MODULE$.Set().empty();
        while (brokerStateInfo.messageQueue().size() > 0) {
            ControlMetadataBatch controlMetadataBatch = brokerStateInfo.messageQueue().take().batch();
            if (controlMetadataBatch instanceof UpdateMetadataBatch) {
                knownBrokers = ((TraversableOnce)((UpdateMetadataBatch)controlMetadataBatch).liveBrokers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Set$.MODULE$.canBuildFrom())).toSet();
                continue;
            }
            if (controlMetadataBatch instanceof LeaderAndIsrBatch) {
                LeaderAndIsrBatch leaderAndIsrBatch = (LeaderAndIsrBatch)controlMetadataBatch;
                Set unknownBroker = (Set)((TraversableOnce)((TraversableLike)leaderAndIsrBatch.partitions().values().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.leader()), Iterable$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0)).toSet().$minus$minus((GenTraversableOnce)knownBrokers);
                if (!unknownBroker.nonEmpty()) continue;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(58).append("Received an LeaderAndIsrBatch ").append(leaderAndIsrBatch).append(" for ").append(brokerId).append(" with unknown brokers: ").append(unknownBroker).toString());
                continue;
            }
            if (controlMetadataBatch instanceof StopReplicaBatch) continue;
            throw new MatchError((Object)controlMetadataBatch);
        }
    }

    public KafkaConfig kafka$controller$ControlMetadataBatchIntegrationTest$$createConfig(int brokerId) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public BrokerInfo kafka$controller$ControlMetadataBatchIntegrationTest$$createBrokerInfo(KafkaConfig config) {
        return BrokerInfo$.MODULE$.apply(new Broker(config.brokerId(), (Seq)new .colon.colon((Object)new EndPoint("", 0, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures(), Predef$.MODULE$.Map().empty()), config.interBrokerProtocolVersion(), -1);
    }

    public KafkaZkClient kafka$controller$ControlMetadataBatchIntegrationTest$$createZkClient(KafkaConfig config) {
        return KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), config.zkMaxInFlightRequests(), Time.SYSTEM, new StringBuilder(6).append("Kafka ").append(config.brokerId()).toString(), new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
    }

    private final void KafkaControllerTest$lzycompute$1() {
        synchronized (this) {
            if (this.KafkaControllerTest$module == null) {
                this.KafkaControllerTest$module = new ControlMetadataBatchIntegrationTest$KafkaControllerTest$(this);
            }
            return;
        }
    }

    private final void ControllerChannelManagerTest$lzycompute$1() {
        synchronized (this) {
            if (this.ControllerChannelManagerTest$module == null) {
                this.ControllerChannelManagerTest$module = new ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$1(ObjectRef controller$1) {
        return ((KafkaController)controller$1.elem).isActive();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$2() {
        return "Controller has not become active";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$3(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$4() {
        return "Broker 1 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$5(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$6() {
        return "Broker 2 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$7(ControllerChannelManagerTest controllerChannelManager$1) {
        return controllerChannelManager$1.brokerState(1).messageQueue().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$8() {
        return "Broker 1 does not have the expected number of pending requests";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$9(ControllerChannelManagerTest controllerChannelManager$1) {
        return controllerChannelManager$1.brokerState(2).messageQueue().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$10() {
        return "Broker 2 does not have the expected number of pending requests";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$11(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$12() {
        return "Broker 1 has not left";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$13(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$14() {
        return "Broker 2 has not left";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$15(ObjectRef controller$1, ObjectRef broker2$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker2$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$16() {
        return "Broker 2 has not joined";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$17(ObjectRef controller$1, ObjectRef broker1$1) {
        return ((KafkaController)controller$1.elem).controllerContext().liveOrShuttingDownBroker(((TestBroker)broker1$1.elem).brokerId()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrDoesNotReferToBrokersNotInMetadataCacheYet$18() {
        return "Broker 1 has not joined";
    }

    public class ControllerChannelManagerTest
    extends ControllerChannelManager {
        public void addNewBroker(Broker broker) {
            ControlMetadataAccumulator messageQueue = new ControlMetadataAccumulator();
            this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo(null, new Node(broker.id(), "", 0), messageQueue, null, null, null, (Option)None$.MODULE$));
        }

        public void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
            Predef$.MODULE$.println((Object)brokerState);
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
        }

        public void startRequestSendThread(int brokerId) {
        }

        public ControllerBrokerStateInfo brokerState(int brokerId) {
            return (ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$ControllerChannelManagerTest$$$outer() {
            return ControlMetadataBatchIntegrationTest.this;
        }

        public ControllerChannelManagerTest(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
            if (ControlMetadataBatchIntegrationTest.this == null) {
                throw null;
            }
            super(controllerContext, config, time, metrics, stateChangeLogger, threadNamePrefix);
        }
    }

    public class KafkaControllerTest
    extends KafkaController {
        public KafkaConfig config() {
            return super.config();
        }

        public ControllerChannelManager newControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
            return this.kafka$controller$ControlMetadataBatchIntegrationTest$KafkaControllerTest$$$outer().new ControllerChannelManagerTest(controllerContext, config, time, metrics, stateChangeLogger, threadNamePrefix);
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$KafkaControllerTest$$$outer() {
            return ControlMetadataBatchIntegrationTest.this;
        }

        public KafkaControllerTest(KafkaConfig config, KafkaZkClient zkClient, Time time, Metrics metrics, BrokerInfo initialBrokerInfo, long initialBrokerEpoch, DelegationTokenManager tokenManager, Option<TierTopicManager> tierTopicManagerOpt, Option<String> threadNamePrefix, BrokerFeatures brokerFeatures, FinalizedFeatureCache featureCache) {
            if (ControlMetadataBatchIntegrationTest.this == null) {
                throw null;
            }
            super(config, zkClient, time, metrics, initialBrokerInfo, initialBrokerEpoch, tokenManager, tierTopicManagerOpt, (ClusterLinkFactory.LinkManager)new ClusterLinkDisabled.LinkManager(), brokerFeatures, featureCache, new ReplicaExclusionCache(), threadNamePrefix);
        }
    }

    public class TestBroker {
        private final int brokerId;
        private final KafkaConfig config;
        private final BrokerInfo brokerInfo;
        private Option<KafkaZkClient> zkClient;
        public final /* synthetic */ ControlMetadataBatchIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public KafkaConfig config() {
            return this.config;
        }

        public BrokerInfo brokerInfo() {
            return this.brokerInfo;
        }

        public Option<KafkaZkClient> zkClient() {
            return this.zkClient;
        }

        public void zkClient_$eq(Option<KafkaZkClient> x$1) {
            this.zkClient = x$1;
        }

        public void connect() {
            KafkaZkClient client = this.kafka$controller$ControlMetadataBatchIntegrationTest$TestBroker$$$outer().kafka$controller$ControlMetadataBatchIntegrationTest$$createZkClient(this.config());
            client.createTopLevelPaths();
            client.registerBroker(this.brokerInfo());
            this.zkClient_$eq((Option<KafkaZkClient>)new Some((Object)client));
        }

        public void disconnect() {
            this.zkClient().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.zkClient_$eq((Option<KafkaZkClient>)None$.MODULE$);
        }

        public /* synthetic */ ControlMetadataBatchIntegrationTest kafka$controller$ControlMetadataBatchIntegrationTest$TestBroker$$$outer() {
            return this.$outer;
        }

        public TestBroker(ControlMetadataBatchIntegrationTest $outer, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.config = $outer.kafka$controller$ControlMetadataBatchIntegrationTest$$createConfig(brokerId);
            this.brokerInfo = $outer.kafka$controller$ControlMetadataBatchIntegrationTest$$createBrokerInfo(this.config());
            this.zkClient = None$.MODULE$;
        }
    }
}

