/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u00049\u0001\u0001\u0007I\u0011A\u001d\t\r}\u0002\u0001\u0015)\u00036\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005Ca\u0001\u0013\u0001!\u0002\u0013\u0011\u0005bB%\u0001\u0005\u0004%\tA\u0013\u0005\u00075\u0002\u0001\u000b\u0011B&\t\u000fm\u0003!\u0019!C\u00019\"1q\r\u0001Q\u0001\nuCq\u0001\u001b\u0001C\u0002\u0013\u0005A\f\u0003\u0004j\u0001\u0001\u0006I!\u0018\u0005\bU\u0002\u0011\r\u0011\"\u0001]\u0011\u0019Y\u0007\u0001)A\u0005;\")A\u000e\u0001C\u0001[\")\u0011\u0010\u0001C\u0005u\"1\u00111\u0004\u0001\u0005\u00025Da!!\n\u0001\t\u0003i\u0007BBA\u0015\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002.\u0001!\t!\u001c\u0005\u0007\u0003c\u0001A\u0011A7\t\r\u0005U\u0002\u0001\"\u0001n\u0011\u0019\tI\u0004\u0001C\u0001[\"1\u0011Q\b\u0001\u0005\u00025Da!!\u0011\u0001\t\u0003i\u0007BBA#\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002J\u0001!\t!\u001c\u0005\u0007\u0003\u001b\u0002A\u0011A7\t\r\u0005E\u0003\u0001\"\u0001n\u0011\u0019\t)\u0006\u0001C\u0001[\"1\u0011\u0011\f\u0001\u0005\u00025Da!!\u0018\u0001\t\u0003i\u0007BBA1\u0001\u0011\u0005QNA\u000bD_:$(o\u001c7mKJ\u001cuN\u001c;fqR$Vm\u001d;\u000b\u0005\u0011*\u0013AC2p]R\u0014x\u000e\u001c7fe*\ta%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002G\u000591m\u001c8uKb$X#A\u001b\u0011\u0005I2\u0014BA\u001c$\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002;{A\u0011!fO\u0005\u0003y-\u0012A!\u00168ji\"9ahAA\u0001\u0002\u0004)\u0014a\u0001=%c\u0005A1m\u001c8uKb$\b%\u0001\bfq\u000edWo]5p]\u000e\u000b7\r[3\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\u0013\u0002\r\r|W.\\8o\u0013\t9EIA\u000bSKBd\u0017nY1Fq\u000edWo]5p]\u000e\u000b7\r[3\u0002\u001f\u0015D8\r\\;tS>t7)Y2iK\u0002\nqA\u0019:pW\u0016\u00148/F\u0001L!\raEk\u0016\b\u0003\u001bJs!AT)\u000e\u0003=S!\u0001U\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013BA*,\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0007M+\u0017O\u0003\u0002TWA\u0011!\u0006W\u0005\u00033.\u00121!\u00138u\u0003!\u0011'o\\6feN\u0004\u0013a\u0001;qcU\tQ\f\u0005\u0002_K6\tqL\u0003\u0002FA*\u0011a%\u0019\u0006\u0003E\u000e\fa!\u00199bG\",'\"\u00013\u0002\u0007=\u0014x-\u0003\u0002g?\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qc\u0001\n1\u0001\u001e93\u0003\u0011!\bO\r\u0011\u0002\u0007Q\u00048'\u0001\u0003uaN\u0002\u0013!B:fiV\u0003H#\u0001\u001e)\u0005=y\u0007C\u00019x\u001b\u0005\t(B\u0001:t\u0003\r\t\u0007/\u001b\u0006\u0003iV\fqA[;qSR,'O\u0003\u0002wG\u0006)!.\u001e8ji&\u0011\u00010\u001d\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001F4f]\u0016\u0014\u0018\r^3Ce>\\WM]#q_\u000eD7\u000fF\u0002|\u0003+\u0001b\u0001`@\u0002\u0004\u0005=Q\"A?\u000b\u0005y\\\u0013AC2pY2,7\r^5p]&\u0019\u0011\u0011A?\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!J\u0001\bG2,8\u000f^3s\u0013\u0011\ti!a\u0002\u0003\r\t\u0013xn[3s!\rQ\u0013\u0011C\u0005\u0004\u0003'Y#\u0001\u0002'p]\u001eDq!a\u0006\u0011\u0001\u0004\tI\"A\bce>\\WM]!oI\u0016\u0003xn\u00195t!\u0015axpVA\b\u0003\u0001#Xm\u001d;Va\u0012\fG/\u001a)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;P]2L\bfA\t\u0002 A\u0019\u0001/!\t\n\u0007\u0005\r\u0012O\u0001\u0003UKN$\u0018\u0001\u0011;fgR,\u0006\u000fZ1uKB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007I\ty\"A&uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiJ+G/\u001e:og\u0016k\u0007\u000f^=TKFLe\rV8qS\u000e|%\u000fU1si&$\u0018n\u001c8E_\u0016\u001chj\u001c;Fq&\u001cH\u000fK\u0002\u0014\u0003?\ta\u000b^3tiB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9us\u0006\u001b8/[4o[\u0016tG/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007Q\ty\"\u0001%uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\u001a{'\u000fV8qS\u000e\u0014V\r^;s]N,U\u000e\u001d;z\u001b\u0006\u0004\u0018J\u001a+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u001aQ#a\b\u0002\u000fR,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/\u0012=qK\u000e$X\r\u001a*fa2L7-Y!tg&<g.\\3oiND3AFA\u0010\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0018\u0003?\t\u0011\u0006^3tiJ+\u0017m]:jO:lWM\u001c;Ge>lwJY:feZ,'\u000fV8Ts:\u001c'+\u001a9mS\u000e\f\u0007f\u0001\r\u0002 \u0005AB/Z:u%\u0016lwN^1m\u001f\u001a\u001c\u0016P\\2SKBd\u0017nY1)\u0007e\ty\"A\u000buKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:)\u0007i\ty\"A\u001auKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:B]\u0012l\u0015m[3Ts:\u001c'+\u001a9mS\u000e\f\u0017J\u001c;p\u001f\n\u001cXM\u001d<fe\"\u001a1$a\b\u0002SQ,7\u000f\u001e*f[>4\u0018\r\\(g'ft7MU3qY&\u001c\u0017-\u00118e\u001f\n\u001cXM\u001d<fe\u000eC\u0017M\\4fQ\ra\u0012qD\u0001.i\u0016\u001cHOU3bgNLwM\\7f]R\u001cv/\u00199t\u001f\n\u001cXM\u001d<feN\fe\u000eZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001c\bfA\u000f\u0002 \u0005IB/Z:u%\u0016\f7o]5h]R{\u0017\nZ3na>$XM\\2fQ\rq\u0012qD\u0001\u000fi\u0016\u001cHOU3bgNLwM\u001c+pQ\ry\u0012qD\u0001\"i\u0016\u001cHOU3n_ZLgn\u001a*fa2L7-\u0019+be\u001e,Go\u00142tKJ4XM\u001d\u0015\u0004A\u0005}\u0011a\t;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-S7cC2\fgnY3NKR\u0014\u0018n\u0019\u0015\u0004C\u0005}\u0001")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final ReplicaExclusionCache exclusionCache = new ReplicaExclusionCache();
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @BeforeEach
    public void setUp() {
        this.context_$eq(new ControllerContext());
        Map<Broker, Object> brokerEpochs = this.generateBrokerEpochs((Map<Object, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        this.context().setLiveBrokers(brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        new .colon.colon((Object)this.tp1(), (List)new .colon.colon((Object)this.tp2(), (List)new .colon.colon((Object)this.tp3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ControllerContextTest.$anonfun$setUp$1(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    private Map<Broker, Object> generateBrokerEpochs(Map<Object, Object> brokerAndEpochs) {
        return (Map)brokerAndEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            long brokerEpoch = x0$1._2$mcJ$sp();
            EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)brokerEpoch));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(expectedReplicas, (Seq)Nil$.MODULE$));
        Seq assignment = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedReplicas, (Object)assignment);
        Assertions.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(initialReplicas, (Seq)Nil$.MODULE$));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assertions.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assertions.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.empty();
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        Map expectedAssignments = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assertions.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition.targetAssignment());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition2.targetAssignment());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition3.targetAssignment());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$);
        Assertions.assertFalse((boolean)partition.isBeingReassigned());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$), (Object)partition.targetReplicaAssignment());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition4.targetAssignment());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition5.targetAssignment());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Nil$.MODULE$), (Object)nonReassigningPartition.targetReplicaAssignment());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assertions.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignmentFromObserverToSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserverAndMakeSyncReplicaIntoObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplicaAndObserverChange() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testReassignmentSwapsObserversAndSyncReplicas() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)reassignment.effectiveObservers());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
    }

    @Test
    public void testReassignToIdempotence() {
        ReplicaAssignment assignment1 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)assignment1, (Object)assignment1.reassignTo(new ReplicaAssignment.Assignment(assignment1.replicas(), assignment1.observers())));
        ReplicaAssignment assignment2 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment2, (Object)assignment2.reassignTo((ReplicaAssignment.Assignment)assignment2.targetAssignment().get()));
        ReplicaAssignment assignment3 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment3, (Object)assignment3.reassignTo((ReplicaAssignment.Assignment)assignment3.targetAssignment().get()));
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment firstReassign = assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)firstReassign);
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)assignment, (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$)));
    }

    @Test
    public void testRemovingReplicaTargetObserver() {
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))).removeReplica(3), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), false), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), false), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), false), 0));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), false), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    public static final /* synthetic */ void $anonfun$setUp$1(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = (IndexedSeq)$this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())), IndexedSeq$.MODULE$.canBuildFrom());
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)Nil$.MODULE$));
        ++leaderIndex$1.elem;
    }
}

