/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.AlterReplicaExclusionOp;
import kafka.common.AlterReplicaExclusionsResult;
import kafka.common.BrokerReplicaExclusion;
import kafka.common.BrokerReplicaExclusionResult;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.DataBalanceManager;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.KafkaControllerTest$SuccessfulExclusionScenario$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerFeatures;
import kafka.server.DelegationTokenManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u001e=\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013\u0005Q\n\u0003\u0004\\\u0001\u0001\u0006IA\u0014\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0011\u0019I\u0007\u0001)A\u0005=\"9!\u000e\u0001b\u0001\n\u0003Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\u0001\u0007I\u0011A9\t\u000fa\u0004\u0001\u0019!C\u0001s\"1q\u0010\u0001Q!\nID\u0011\"!\u0001\u0001\u0001\u0004%\t!a\u0001\t\u0013\u0005E\u0001\u00011A\u0005\u0002\u0005M\u0001\u0002CA\f\u0001\u0001\u0006K!!\u0002\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001\"CA\u0014\u0001\u0001\u0007I\u0011AA\u0015\u0011!\ti\u0003\u0001Q!\n\u0005u\u0001\"CA\u0018\u0001\u0001\u0007I\u0011AA\u0019\u0011%\tI\u0004\u0001a\u0001\n\u0003\tY\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0015BA\u001a\u0011%\t\t\u0005\u0001a\u0001\n\u0003\t\u0019\u0005C\u0005\u0002L\u0001\u0001\r\u0011\"\u0001\u0002N!A\u0011\u0011\u000b\u0001!B\u0013\t)\u0005C\u0005\u0002T\u0001\u0001\r\u0011\"\u0001\u0002V!I\u00111\u0010\u0001A\u0002\u0013\u0005\u0011Q\u0010\u0005\t\u0003\u0003\u0003\u0001\u0015)\u0003\u0002X!I\u00111\u0011\u0001A\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0001\u0003\u001fC\u0001\"a%\u0001A\u0003&\u0011q\u0011\u0005\n\u0003+\u0003\u0001\u0019!C\u0001\u0003/C\u0011\"a(\u0001\u0001\u0004%\t!!)\t\u0011\u0005\u0015\u0006\u0001)Q\u0005\u00033C\u0011\"a*\u0001\u0001\u0004%\t!!+\t\u0013\u0005E\u0006\u00011A\u0005\u0002\u0005M\u0006\u0002CA\\\u0001\u0001\u0006K!a+\t\u0013\u0005e\u0006A1A\u0005\u0002\u0005m\u0006\u0002CAb\u0001\u0001\u0006I!!0\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005\u001d\u0007\u0002CAh\u0001\u0001\u0006I!!3\t\u0013\u0005E\u0007A1A\u0005\u0002\u0005M\u0007\u0002CAp\u0001\u0001\u0006I!!6\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u00111 \u0001\u0005\u0002\u0005\r\bb\u0002B\u0003\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u0013\u0001A\u0011AAr\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003GDqA!\u0005\u0001\t\u0003\t\u0019oB\u0004\u0003\u0016\u0001A\tAa\u0006\u0007\u000f\tm\u0001\u0001#\u0001\u0003\u001e!1\u0001\n\rC\u0001\u0005?A\u0011B!\t1\u0005\u0004%\tAa\t\t\u0011\tm\u0002\u0007)A\u0005\u0005KAqA!\u00101\t\u0003\t\u0019\u000fC\u0004\u0003@A\"\tA!\u0011\t\u000f\t-\u0004\u0001\"\u0001\u0002d\"9!q\u000e\u0001\u0005\n\tE\u0004b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005?\u0003A\u0011\u0002Bn\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005K\u00141cS1gW\u0006\u001cuN\u001c;s_2dWM\u001d+fgRT!!\u0010 \u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001@\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\n\u0005\u0002L\u00015\tA(\u0001\u0003uS6,W#\u0001(\u0011\u0005=KV\"\u0001)\u000b\u0005E\u0013\u0016!B;uS2\u001c(BA*U\u0003\u0019\u0019w.\\7p]*\u0011q(\u0016\u0006\u0003-^\u000ba!\u00199bG\",'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[!\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003M!\u0018.\u001a:U_BL7-T1oC\u001e,'o\u00149u+\u0005q\u0006cA\"`C&\u0011\u0001\r\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017!\u0002;pa&\u001c'B\u00014?\u0003\u0011!\u0018.\u001a:\n\u0005!\u001c'\u0001\u0005+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0003Q!\u0018.\u001a:U_BL7-T1oC\u001e,'o\u00149uA\u0005\u0011\u0012N\\5uS\u0006d'I]8lKJ,\u0005o\\2i+\u0005a\u0007CA\"n\u0013\tqGI\u0001\u0003M_:<\u0017aE5oSRL\u0017\r\u001c\"s_.,'/\u00129pG\"\u0004\u0013AB2p]\u001aLw-F\u0001s!\t\u0019h/D\u0001u\u0015\t)h(\u0001\u0004tKJ4XM]\u0005\u0003oR\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005il\bCA\"|\u0013\taHI\u0001\u0003V]&$\bb\u0002@\n\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\tu.\u001cE.[3oiV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002 \u0002\u0005i\\\u0017\u0002BA\b\u0003\u0013\u0011QbS1gW\u0006T6n\u00117jK:$\u0018\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHc\u0001>\u0002\u0016!Aa\u0010DA\u0001\u0002\u0004\t)!A\u0005{W\u000ec\u0017.\u001a8uA\u00059Q.\u001a;sS\u000e\u001cXCAA\u000f!\u0011\ty\"a\t\u000e\u0005\u0005\u0005\"bAA\r%&!\u0011QEA\u0011\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0019!0a\u000b\t\u0011y|\u0011\u0011!a\u0001\u0003;\t\u0001\"\\3ue&\u001c7\u000fI\u0001\u0012S:LG/[1m\u0005J|7.\u001a:J]\u001a|WCAA\u001a!\u0011\t9!!\u000e\n\t\u0005]\u0012\u0011\u0002\u0002\u000b\u0005J|7.\u001a:J]\u001a|\u0017!F5oSRL\u0017\r\u001c\"s_.,'/\u00138g_~#S-\u001d\u000b\u0004u\u0006u\u0002\u0002\u0003@\u0013\u0003\u0003\u0005\r!a\r\u0002%%t\u0017\u000e^5bY\n\u0013xn[3s\u0013:4w\u000eI\u0001\ri>\\WM\\'b]\u0006<WM]\u000b\u0003\u0003\u000b\u00022a]A$\u0013\r\tI\u0005\u001e\u0002\u0017\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe\u0006\u0001Bo\\6f]6\u000bg.Y4fe~#S-\u001d\u000b\u0004u\u0006=\u0003\u0002\u0003@\u0016\u0003\u0003\u0005\r!!\u0012\u0002\u001bQ|7.\u001a8NC:\fw-\u001a:!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0005\u0005]\u0003\u0003BA-\u0003krA!a\u0017\u0002p9!\u0011QLA6\u001d\u0011\ty&!\u001b\u000f\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001aA\u0003\u0019a$o\\8u}%\tq(\u0003\u0002v}%\u0019\u0011Q\u000e;\u0002\t1Lgn[\u0005\u0005\u0003c\n\u0019(\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL(bAA7i&!\u0011qOA=\u0005-a\u0015N\\6NC:\fw-\u001a:\u000b\t\u0005E\u00141O\u0001\u0017G2,8\u000f^3s\u0019&t7.T1oC\u001e,'o\u0018\u0013fcR\u0019!0a \t\u0011yD\u0012\u0011!a\u0001\u0003/\n1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\naB\u0019:pW\u0016\u0014h)Z1ukJ,7/\u0006\u0002\u0002\bB\u00191/!#\n\u0007\u0005-EO\u0001\bCe>\\WM\u001d$fCR,(/Z:\u0002%\t\u0014xn[3s\r\u0016\fG/\u001e:fg~#S-\u001d\u000b\u0004u\u0006E\u0005\u0002\u0003@\u001c\u0003\u0003\u0005\r!a\"\u0002\u001f\t\u0014xn[3s\r\u0016\fG/\u001e:fg\u0002\nABZ3biV\u0014XmQ1dQ\u0016,\"!!'\u0011\u0007M\fY*C\u0002\u0002\u001eR\u0014QCR5oC2L'0\u001a3GK\u0006$XO]3DC\u000eDW-\u0001\tgK\u0006$XO]3DC\u000eDWm\u0018\u0013fcR\u0019!0a)\t\u0011yt\u0012\u0011!a\u0001\u00033\u000bQBZ3biV\u0014XmQ1dQ\u0016\u0004\u0013aD6bM.\f7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005-\u0006cA&\u0002.&\u0019\u0011q\u0016\u001f\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\f1c[1gW\u0006\u001cuN\u001c;s_2dWM]0%KF$2A_A[\u0011!q\u0018%!AA\u0002\u0005-\u0016\u0001E6bM.\f7i\u001c8ue>dG.\u001a:!\u0003M\u0011\u0017\r\\1oG\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l+\t\ti\fE\u0002L\u0003\u007fK1!!1=\u0005I!\u0015\r^1CC2\fgnY3NC:\fw-\u001a:\u0002)\t\fG.\u00198dKJl\u0015M\\1hKJlunY6!\u00039)\u0007o\\2i5.4VM]:j_:,\"!!3\u0011\u0007\r\u000bY-C\u0002\u0002N\u0012\u00131!\u00138u\u0003=)\u0007o\\2i5.4VM]:j_:\u0004\u0013AD3yG2,8/[8o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003+\u0004B!a6\u0002\\6\u0011\u0011\u0011\u001c\u0006\u0003'zJA!!8\u0002Z\n)\"+\u001a9mS\u000e\fW\t_2mkNLwN\\\"bG\",\u0017aD3yG2,8/[8o\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003iD3!KAt!\u0011\tI/a>\u000e\u0005\u0005-(\u0002BAw\u0003_\f1!\u00199j\u0015\u0011\t\t0a=\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q_,\u0002\u000b),h.\u001b;\n\t\u0005e\u00181\u001e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0015;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c8i\\7qY\u0016$Xm]\"bY2\u0014\u0017mY6XSRDWK\\6o_^t7+\u001a:wKJ,\u0005pY3qi&|gn\u00148[\u0017\u0016C8-\u001a9uS>t\u0007f\u0001\u0016\u0002\u0000B!\u0011\u0011\u001eB\u0001\u0013\u0011\u0011\u0019!a;\u0003\tQ+7\u000f^\u0001Ci\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u001d*fiV\u0014hn]%om\u0006d\u0017\u000eZ#yG2,8/[8o\u001f:,f\u000e[1oI2,Gm\u00149UsB,\u0007fA\u0016\u0002\u0000\u0006QB/Z:u\u00032$XM\u001d*fa2L7-Y#yG2,8/[8og\"\u001aA&a@\u0002wQ,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:E_\u0016\u001ch\u000e\u001e)feNL7\u000f^(o\tV\u0004H.[2bi\u0016,\u0005p\u00197vg&|g\u000eK\u0002.\u0003\u007f\f\u0011\t^3ti\u0006cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N<vN]6t\u0013\u001a$\u0015\r^1CC2\fgnY3s)\"\u0014xn^:P]:{G/\u001b4jG\u0006$\u0018n\u001c8)\u00079\ny0A\u000eTk\u000e\u001cWm]:gk2,\u0005p\u00197vg&|gnU2f]\u0006\u0014\u0018n\u001c\t\u0004\u00053\u0001T\"\u0001\u0001\u00037M+8mY3tg\u001a,H.\u0012=dYV\u001c\u0018n\u001c8TG\u0016t\u0017M]5p'\t\u0001$\t\u0006\u0002\u0003\u0018\u0005aQ\r_2mkNLwN\\(qgV\u0011!Q\u0005\t\u0007\u0005O\u0011yC!\u000e\u000f\t\t%\"1\u0006\t\u0004\u0003C\"\u0015b\u0001B\u0017\t\u00061\u0001K]3eK\u001aLAA!\r\u00034\t\u00191+\u001a;\u000b\u0007\t5B\t\u0005\u0003\u0002X\n]\u0012\u0002\u0002B\u001d\u00033\u0014q#\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u00149\u0002\u001b\u0015D8\r\\;tS>tw\n]:!\u0003\u0011!Xm\u001d;\u0002C\u0005\u001c8/\u001a:u'V\u001c7-Z:tMVdW\t_2mkNLwN\\\"bY2\u0014\u0017mY6\u0015\u0007i\u0014\u0019\u0005C\u0004\u0003FU\u0002\rAa\u0012\u0002\rI,7/\u001e7u!!\u0011IEa\u0015\u0003Z\t\u0015d\u0002\u0002B&\u0005\u001frA!!\u0019\u0003N%\tQ)C\u0002\u0003R\u0011\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003V\t]#AB#ji\",'OC\u0002\u0003R\u0011\u0003BAa\u0017\u0003b5\u0011!Q\f\u0006\u0004\u0005?\u0012\u0016\u0001\u0003:fcV,7\u000f^:\n\t\t\r$Q\f\u0002\t\u0003BLWI\u001d:peB!\u0011q\u001bB4\u0013\u0011\u0011I'!7\u00039\u0005cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N\u0014Vm];mi\u0006AB/Z:u\u00032Lg/\u001a\"s_.,'o]*oCB\u001c\bn\u001c;)\u0007Y\ny0A\u0010bgN,'\u000f^*vG\u000e,7o\u001d4vY\u0016C8\r\\;tS>t'+Z:vYR$rA\u001fB:\u0005\u007f\u0012\u0019\tC\u0004\u0003v]\u0002\rAa\u001e\u0002\u001fI,7-Z5wK\u0012\u0014Vm];miN\u0004bAa\n\u00030\te\u0004\u0003BAl\u0005wJAA! \u0002Z\na\"I]8lKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gNU3tk2$\bb\u0002BAo\u0001\u0007\u0011\u0011Z\u0001\u0011Kb\u0004Xm\u0019;fI\n\u0013xn[3s\u0013\u0012DqA!\"8\u0001\u0004\u00119)\u0001\bfqB,7\r^3e\u001fB$\u0016\u0010]3\u0011\t\t%%\u0011\u0014\b\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003\u0015\tG-\\5o\u0015\r\u0011\u0019\nV\u0001\bG2LWM\u001c;t\u0013\u0011\u00119J!$\u0002\u0017\u0015C8\r\\;tS>tw\n]\u0005\u0005\u00057\u0013iJ\u0001\u0004PaRK\b/\u001a\u0006\u0005\u0005/\u0013i)A\twKJLg-_'fiJL7MV1mk\u0016$rA\u001fBR\u0005{\u00139\rC\u0004\u0003&b\u0002\rAa*\u0002\u001f5,GO]5dgJ+w-[:uef\u0004BA!+\u0003:6\u0011!1\u0016\u0006\u0005\u0005[\u0013y+\u0001\u0003d_J,'\u0002BA\r\u0005cSAAa-\u00036\u00061\u00110Y7nKJT!Aa.\u0002\u0007\r|W.\u0003\u0003\u0003<\n-&aD'fiJL7m\u001d*fO&\u001cHO]=\t\u000f\t}\u0006\b1\u0001\u0003B\u0006\u0001R.\u001a;sS\u000e\u001c\u0016.\u001c9mK:\u000bW.\u001a\t\u0005\u0005O\u0011\u0019-\u0003\u0003\u0003F\nM\"AB*ue&tw\rC\u0004\u0003Jb\u0002\rAa3\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f!\u0011\u0011iMa6\u000e\u0005\t='\u0002\u0002Bi\u0005'\fA\u0001\\1oO*\u0011!Q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003Z\n='aB%oi\u0016<WM\u001d\u000b\bu\nu'q\u001cBq\u0011\u001d\u0011)+\u000fa\u0001\u0005OCqAa0:\u0001\u0004\u0011\t\rC\u0004\u0003Jf\u0002\rA!1\u0002\r5,GO]5d)\u0019\u00119O!<\u0003pB!!\u0011\u0016Bu\u0013\u0011\u0011YOa+\u0003\r5+GO]5d\u0011\u001d\u0011)K\u000fa\u0001\u0005OCqAa0;\u0001\u0004\u0011\t\r")
public class KafkaControllerTest {
    private volatile KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario$module;
    private final Time time = new MockTime();
    private final Option<TierTopicManager> tierTopicManagerOpt = None$.MODULE$;
    private final long initialBrokerEpoch;
    private KafkaConfig config = null;
    private KafkaZkClient zkClient = null;
    private Metrics metrics = null;
    private BrokerInfo initialBrokerInfo = null;
    private DelegationTokenManager tokenManager = null;
    private ClusterLinkFactory.LinkManager clusterLinkManager = null;
    private BrokerFeatures brokerFeatures = null;
    private FinalizedFeatureCache featureCache = null;
    private KafkaController kafkaController = null;
    private final DataBalanceManager balancerManagerMock = (DataBalanceManager)Mockito.mock(DataBalanceManager.class);
    private final int epochZkVersion;
    private final ReplicaExclusionCache exclusionCache = new ReplicaExclusionCache();

    public KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario() {
        if (this.SuccessfulExclusionScenario$module == null) {
            this.SuccessfulExclusionScenario$lzycompute$1();
        }
        return this.SuccessfulExclusionScenario$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public long initialBrokerEpoch() {
        return this.initialBrokerEpoch;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void initialBrokerInfo_$eq(BrokerInfo x$1) {
        this.initialBrokerInfo = x$1;
    }

    public DelegationTokenManager tokenManager() {
        return this.tokenManager;
    }

    public void tokenManager_$eq(DelegationTokenManager x$1) {
        this.tokenManager = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    public BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    public void brokerFeatures_$eq(BrokerFeatures x$1) {
        this.brokerFeatures = x$1;
    }

    public FinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    public void featureCache_$eq(FinalizedFeatureCache x$1) {
        this.featureCache = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public DataBalanceManager balancerManagerMock() {
        return this.balancerManagerMock;
    }

    public int epochZkVersion() {
        return this.epochZkVersion;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        this.config_$eq(KafkaConfig$.MODULE$.apply((java.util.Map)props));
        this.zkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.metrics_$eq(new Metrics());
        this.initialBrokerInfo_$eq((BrokerInfo)Mockito.mock(BrokerInfo.class));
        this.tokenManager_$eq((DelegationTokenManager)Mockito.mock(DelegationTokenManager.class));
        this.clusterLinkManager_$eq((ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
        this.brokerFeatures_$eq((BrokerFeatures)Mockito.mock(BrokerFeatures.class));
        this.featureCache_$eq((FinalizedFeatureCache)Mockito.mock(FinalizedFeatureCache.class));
        TestUtils$.MODULE$.clearYammerMetrics();
        KafkaYammerMetrics.defaultRegistry().shutdown();
        this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.time(), this.metrics(), this.initialBrokerInfo(), this.initialBrokerEpoch(), this.tokenManager(), this.tierTopicManagerOpt(), this.clusterLinkManager(), this.brokerFeatures(), this.featureCache(), this.exclusionCache(), KafkaController$.MODULE$.$lessinit$greater$default$13()));
        this.kafkaController().dataBalancer_$eq(this.balancerManagerMock());
    }

    @Test
    public void testAlterReplicaExclusionsCompletesCallbackWithUnknownServerExceptionOnZKException() {
        AlterReplicaExclusionOp exclusionOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.SET);
        this.zkClient().setOrCreateReplicaExclusions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(exclusionOp.brokerId(), exclusionOp.reason())})), this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)"replica_exclusions");
        });
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{exclusionOp})), (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$1(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusionsReturnsInvalidExclusionOnUnhandledOpType() {
        AlterReplicaExclusionOp unknownOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.UNKNOWN);
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{unknownOp})), (Function1 & Serializable & scala.Serializable)result -> {
            KafkaControllerTest.callback$2(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusions() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusions$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusions$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(1, "maintenance")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusions$3(x$2);
            return BoxedUnit.UNIT;
        });
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "delete")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(x$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set exclusionOps = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{new AlterReplicaExclusionOp(1, "", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(2, "excluded", ExclusionOp.OpType.SET)}));
        this.kafkaController().alterBrokerReplicaExclusions((Set)exclusionOps, (Function1 & Serializable & scala.Serializable)result -> {
            this.callback$3(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        ((DataBalanceManager)Mockito.verify((Object)this.balancerManagerMock(), (VerificationMode)Mockito.never())).onAlteredExclusions((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification() {
        this.kafkaController().replicaExclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(1, "maintenance")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$3(x$4);
            return BoxedUnit.UNIT;
        });
        this.balancerManagerMock().onAlteredExclusions((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            throw new Exception("test!");
        });
        this.SuccessfulExclusionScenario().test();
    }

    @Test
    public void testAliveBrokersSnapshot() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.exclusionCache().overrideMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"reason")}))).asJava());
        Assertions.assertEquals((Object)new AliveBrokersSnapshot((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)3L))}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava()), (Object)this.kafkaController().aliveBrokersSnapshot());
    }

    public void kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult(scala.collection.immutable.Set<BrokerReplicaExclusionResult> receivedResults, int expectedBrokerId, ExclusionOp.OpType expectedOpType) {
        Option findOpt = receivedResults.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KafkaControllerTest.$anonfun$assertSuccessfulExclusionResult$1(expectedBrokerId, p)));
        Assertions.assertFalse((boolean)findOpt.isEmpty(), (String)new StringBuilder(34).append("Could not find broker ").append(expectedBrokerId).append(" in results ").append(receivedResults).toString());
        BrokerReplicaExclusionResult exclusion = (BrokerReplicaExclusionResult)findOpt.get();
        Assertions.assertEquals((int)expectedBrokerId, (int)exclusion.brokerId());
        Assertions.assertEquals((Object)expectedOpType, (Object)exclusion.opType());
        Assertions.assertTrue((boolean)exclusion.apiErrorOpt().isEmpty(), (String)new StringBuilder(51).append("Expected exclusion for broker ").append(expectedBrokerId).append(" to not have an error").toString());
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, String expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$3(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$4(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        java.util.Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.controller", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    private final void SuccessfulExclusionScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulExclusionScenario$module == null) {
                this.SuccessfulExclusionScenario$module = new KafkaControllerTest$SuccessfulExclusionScenario$(this);
            }
            return;
        }
    }

    private static final void callback$1(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error.error());
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected an error while processing exclusions");
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$2(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertFalse((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to not be successful");
            Assertions.assertEquals((int)1, (int)result2.brokerReplicaExclusionResults().size());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.INVALID_REPLICA_EXCLUSION})), (Object)((SetLike)((TraversableLike)result2.brokerReplicaExclusionResults().map((Function1 & Serializable & scala.Serializable)r -> r.apiErrorOpt(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.isDefined()))).map((Function1 & Serializable & scala.Serializable)e -> ((ApiError)e.get()).error(), Set$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusions$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusions$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusions$3(InvocationOnMock x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(InvocationOnMock x$3) {
    }

    private final void callback$3(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertTrue((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to be successful");
            Assertions.assertEquals((int)2, (int)result2.brokerReplicaExclusionResults().size());
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 1, ExclusionOp.OpType.DELETE);
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 2, ExclusionOp.OpType.SET);
            java.util.Map exclusions = this.kafkaController().replicaExclusionCache().exclusions();
            Assertions.assertEquals((int)1, (int)exclusions.size());
            Assertions.assertTrue((boolean)exclusions.containsKey(BoxesRunTime.boxToInteger((int)1)), (String)"Expected exclusion for broker 1 to be present");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$3(InvocationOnMock x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulExclusionResult$1(int expectedBrokerId$1, BrokerReplicaExclusionResult p) {
        return p.brokerId() == expectedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(KafkaControllerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$3(KafkaControllerTest $this, MetricsRegistry metricsRegistry$2, String metricSimpleName$2, AtomicReference lastSeenValue$2, String expectedValue$2) {
        String value = (String)((Gauge)$this.metric(metricsRegistry$2, metricSimpleName$2)).value();
        lastSeenValue$2.set(value);
        String string = expectedValue$2;
        return !(string != null ? !string.equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$4(String metricSimpleName$2, String expectedValue$2, AtomicReference lastSeenValue$2) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$2).append(" to be ").append(expectedValue$2).append(" but instead was ").append(lastSeenValue$2.get()).toString();
    }

    public KafkaControllerTest() {
        this.initialBrokerEpoch = 0L;
        this.epochZkVersion = 0;
    }
}

