/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001A\u0002\u0013%\u0011\nC\u0004N\u0001\u0001\u0007I\u0011\u0002(\t\rQ\u0003\u0001\u0015)\u0003K\u0011\u001d)\u0006\u00011A\u0005\nYCq!\u0018\u0001A\u0002\u0013%a\f\u0003\u0004a\u0001\u0001\u0006Ka\u0016\u0005\bC\u0002\u0001\r\u0011\"\u0003c\u0011\u001d1\u0007\u00011A\u0005\n\u001dDa!\u001b\u0001!B\u0013\u0019\u0007b\u00026\u0001\u0001\u0004%Ia\u001b\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0011\u0019\u0011\b\u0001)Q\u0005Y\"91\u000f\u0001b\u0001\n\u0013!\bB\u0002=\u0001A\u0003%Q\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\r\u0001\u0001)A\u0005w\"A\u0011Q\u0001\u0001C\u0002\u0013%A\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011B;\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0002\u0002CA\u001b\u0001\u0001\u0006I!!\u000b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA/\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003O\u0002A\u0011AA\u001d\u0011\u001d\tY\u0007\u0001C\u0001\u0003sAq!a\u001c\u0001\t\u0003\tI\u0004C\u0004\u0002t\u0001!\t!!\u000f\t\u000f\u0005]\u0004\u0001\"\u0001\u0002:!9\u00111\u0010\u0001\u0005\u0002\u0005e\u0002bBA@\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u0007\u0003A\u0011AA\u001d\u0011\u001d\t9\t\u0001C\u0001\u0003sAq!a#\u0001\t\u0003\tI\u0004C\u0004\u0002\u0010\u0002!\t!!\u000f\t\u000f\u0005M\u0005\u0001\"\u0001\u0002:!9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0002bBAN\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003?\u0003A\u0011AA\u001d\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003sAq!a*\u0001\t\u0003\tI\u0004C\u0004\u0002,\u0002!\t!!\u000f\t\u000f\u0005=\u0006\u0001\"\u0001\u0002:!9\u00111\u0017\u0001\u0005\u0002\u0005e\u0002bBA\\\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003w\u0003A\u0011AA\u001d\u0011\u001d\ty\f\u0001C\u0001\u0003sAq!a1\u0001\t\u0013\t)\rC\u0004\u0002`\u0002!\t!!\u000f\t\u000f\u0005\r\b\u0001\"\u0001\u0002:!9\u0011q\u001d\u0001\u0005\u0002\u0005e\u0002bBAv\u0001\u0011%\u0011Q\u001e\u0002\u001a!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u0002:u\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003m\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0011\u0005\u001d\u0003Q\"\u0001\u001d\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001K!\t95*\u0003\u0002Mq\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002+\r|g\u000e\u001e:pY2,'oQ8oi\u0016DHo\u0018\u0013fcR\u0011qJ\u0015\t\u0003\u007fAK!!\u0015!\u0003\tUs\u0017\u000e\u001e\u0005\b'\u000e\t\t\u00111\u0001K\u0003\rAH%M\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b%\u0001\u0007n_\u000e\\'l[\"mS\u0016tG/F\u0001X!\tA6,D\u0001Z\u0015\tQ&(\u0001\u0002{W&\u0011A,\u0017\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!5|7m\u001b.l\u00072LWM\u001c;`I\u0015\fHCA(`\u0011\u001d\u0019f!!AA\u0002]\u000bQ\"\\8dWj[7\t\\5f]R\u0004\u0013\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012a\u0019\t\u0003\u000f\u0012L!!\u001a\u001d\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0006!Sn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002PQ\"91+CA\u0001\u0002\u0004\u0019\u0017!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002YB\u0011q)\\\u0005\u0003]b\u0012Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-A\rqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3`I\u0015\fHCA(r\u0011\u001d\u0019F\"!AA\u00021\fa\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rI\u0001\tEJ|7.\u001a:JIV\tQ\u000f\u0005\u0002@m&\u0011q\u000f\u0011\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOV\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fu\u000511/\u001a:wKJL1!!\u0001~\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002 5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004d_6lwN\u001c\u0006\u0004w\u0005]!\u0002BA\r\u00037\ta!\u00199bG\",'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t\tB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!!\u000b\u0011\r\u0005-\u0012\u0011GA\u0007\u001b\t\tiCC\u0002\u00020\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019$!\f\u0003\u0007M+\u0017/A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013!B:fiV\u0003H#A()\u0007a\ti\u0004\u0005\u0003\u0002@\u00055SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002H\u0005%\u0013a\u00026va&$XM\u001d\u0006\u0005\u0003\u0017\nY\"A\u0003kk:LG/\u0003\u0003\u0002P\u0005\u0005#A\u0003\"fM>\u0014X-R1dQ\u0006q\u0001/\u0019:uSRLwN\\*uCR,G\u0003BA+\u00037\u00022aRA,\u0013\r\tI\u0006\u000f\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u001d\tI!\u0007a\u0001\u0003\u001b\t\u0001\u0007^3ti:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)>tUm\u001e)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u000e\u0002bA!\u0011qHA2\u0013\u0011\t)'!\u0011\u0003\tQ+7\u000f^\u0001;i\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3aGA1\u0003m\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u00049\u0005\u0005\u0014a\u000b;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007u\t\t'A*uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o5>|7*Z3qKJ\u001cE.[3oi\u0016C8-\u001a9uS>tgI]8n\u0007J,\u0017\r^3Ti\u0006$Xm\u001d\u0015\u0004=\u0005\u0005\u0014\u0001\u0012;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8FeJ|'oQ8eK\u001a\u0013x.\\\"sK\u0006$Xm\u0015;bi\u0016\u001c\bfA\u0010\u0002b\u0005aC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004A\u0005\u0005\u0014a\u000e;fgRLeN^1mS\u0012tUm\u001e)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002\"\u0003C\nQ\u0005^3ti>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,GK]1og&$\u0018n\u001c8)\u0007\t\n\t'\u0001\u001euKN$xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a+sC:\u001c\u0018\u000e^5p]\u001a{'oQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001a1%!\u0019\u0002MQ,7\u000f^(oY&tW\rU1si&$\u0018n\u001c8U_>3g\r\\5oKR\u0013\u0018M\\:ji&|g\u000eK\u0002%\u0003C\n!\b^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0015\n\t'\u0001\u001auKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8OK^\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r1\u0013\u0011M\u00010i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004O\u0005\u0005\u0014A\u000f;fgR$UmY8eKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3[\u001d>$WmV5uQ>,H/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014h\t\\1hQ\rA\u0013\u0011M\u00017i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_Vs7\r\\3b]>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004S\u0005\u0005\u0014!\u0010;fgR,fn\u00197fC:|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8V]\u000edW-\u00198P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0016\u0002b\u00051D/Z:u+:\u001cG.Z1o\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1&!\u0019\u0002\u0013R,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8XSRDWK\\2mK\u0006tW\t\\3di&|g.\u00128bE2,G\rK\u0002-\u0003C\nA\u0005^3ti\n\u0013xn[3s\u0005>,hnY3BMR,'/\u00168dY\u0016\fg.\u00127fGRLwN\u001c\u0015\u0004[\u0005\u0005\u0014A\u0016;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t'l\\8LK\u0016\u0004XM]\"mS\u0016tG/\u0012=dKB$\u0018n\u001c8Ge>l7\u000b^1uK2{wn[;qQ\rq\u0013\u0011M\u0001Hi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\\#se>\u00148i\u001c3f\rJ|Wn\u0015;bi\u0016dun\\6va\"\u001aq&!\u0019\u0002iQ,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u00021\u0003C\n1\u0007^3ti&sg/\u00197jI>3g\r\\5oKB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007E\n\t'A\u0013qe\u0016\u0004\u0018M]3N_\u000e\\Gk\\#mK\u000e$H*Z1eKJ4uN\u001d)beRLG/[8ogR\u0019q*a2\t\u000f\u0005\u0015\"\u00071\u0001\u0002JB1\u00111ZAn\u0003\u001bqA!!4\u0002X:!\u0011qZAk\u001b\t\t\tNC\u0002\u0002Tr\na\u0001\u0010:p_Rt\u0014\"A!\n\u0007\u0005e\u0007)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0012Q\u001c\u0006\u0004\u00033\u0004\u0015A\t;fgR,\u0006\u000fZ1uS:<wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:D_VtG\u000fK\u00024\u0003C\n!\u0007^3ti:{wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:DQ\u0006tw-\u001a$peR{\u0007/[2t\u0005\u0016Lgn\u001a#fY\u0016$X\r\u001a\u0015\u0004i\u0005\u0005\u0014!\u000e;fgR,\u0006\u000fZ1uS:<wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:D_VtG\u000fR;sS:<Gk\u001c9jG\u0012+G.\u001a;j_:D3!NA1\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0005\u0003_\f)\u0010E\u0002H\u0003cL1!a=9\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\b\u0003o4\u0004\u0019AA}\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#BAf\u00037,\b")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andThrow((Throwable)new ZooKeeperClientException("test"));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId(), false);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), false);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).andReturn((Object)new Tuple2((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Map$.MODULE$.empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId(), false);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testDecodeTopicPartitionStateZNodeWithoutUncleanLeaderFlag() {
        byte[] zNodeData = Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.initialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava())}))).asJava());
        Stat zNodeDataStat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(zNodeData, zNodeDataStat, this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), this.controllerEpoch());
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.initialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_is_unclean_leader"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))).asJava()), zNodeDataStat, this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), true, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), this.controllerEpoch());
    }

    @Test
    public void testOfflinePartitionToUncleanOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), true);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToUncleanOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), true);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), true);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), true);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionWithUncleanElectionEnabled() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testBrokerBounceAfterUncleanElection() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), true);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.empty());
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        EasyMock.reset((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), true);
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andThrow((Throwable)new ZooKeeperClientException(""));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient()});
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient, (Option)None$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Nil$.MODULE$);
    }

    private static final void decodeTopicPartitionStateZNodeAndValidate$1(byte[] responseData, Stat responseStat, int leader, List isr, boolean expectedUncleanFlag, int leaderEpoch, int controllerEpoch) {
        Option option = TopicPartitionStateZNode$.MODULE$.decode(responseData, responseStat);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            Assertions.assertEquals((int)leader, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leader(), (String)"Leader mismatch");
            Assertions.assertEquals((Object)isr, (Object)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), (String)"Isr mismatch");
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedUncleanFlag), (Object)BoxesRunTime.boxToBoolean((boolean)leaderIsrAndControllerEpoch.leaderAndIsr().isUnclean()), (String)"Unclean leader flag mismatch");
            Assertions.assertEquals((int)leaderEpoch, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch(), (String)"Leader Epoch mismatch");
            Assertions.assertEquals((int)controllerEpoch, (int)leaderIsrAndControllerEpoch.controllerEpoch(), (String)"Controller Epoch mismatch");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(true, (Function0 & Serializable & scala.Serializable)() -> "Could not decode TopicPartitionStateZNode data");
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1 & Serializable & scala.Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).andReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).andReturn((Object)new Tuple2((Object)Map$.MODULE$.empty(), (Object)Map$.MODULE$.empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)package$.MODULE$.Right().apply((Object)v));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$2) {
        return new TopicPartition(topic$2, x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

