/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013%A\u0005\u0003\u0004)\u0001\u0001\u0006I!\n\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0011\u0019\t\u0004\u0001)A\u0005W!9!\u0007\u0001b\u0001\n\u0013\u0019\u0004BB\u001c\u0001A\u0003%A\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003K\u0001\u0011\u0005\u0011\bC\u0003M\u0001\u0011\u0005\u0011\bC\u0003O\u0001\u0011\u0005\u0011\bC\u0003Q\u0001\u0011\u0005\u0011\bC\u0003S\u0001\u0011\u0005\u0011\bC\u0003U\u0001\u0011\u0005\u0011\bC\u0003W\u0001\u0011\u0005\u0011\bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\tABk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005Q)\u0012AC2p]R\u0014x\u000e\u001c7fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002'\u0005A!M]8lKJLE-F\u0001&!\tQb%\u0003\u0002(7\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013AB2p]\u001aLw-F\u0001,!\tas&D\u0001.\u0015\tqS#\u0001\u0004tKJ4XM]\u0005\u0003a5\u00121bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u00043fY\u0016$\u0018n\u001c8DY&,g\u000e^\u000b\u0002iA\u0011!%N\u0005\u0003mM\u0011a\u0002R3mKRLwN\\\"mS\u0016tG/A\beK2,G/[8o\u00072LWM\u001c;!\u0003I!Xm\u001d;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8\u0015\u0003i\u0002\"AG\u001e\n\u0005qZ\"\u0001B+oSRD#\u0001\u0003 \u0011\u0005}BU\"\u0001!\u000b\u0005\u0005\u0013\u0015aA1qS*\u00111\tR\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)e)A\u0003kk:LGOC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0002\u0013A\u0001V3ti\u0006\tB/Z:u\u0005\u0006\u001c\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0005%q\u0014A\b;fgR\u0014\u0015m]5d\t\u0016dW\r^5p]>3G+[3sK\u0012$v\u000e]5dQ\tQa(\u0001\u0013uKN$X\t_2faRLwN\\,iK:$U\r\\3uS:<G+[3sK\u0012$v\u000e]5dQ\tYa(A\u0011uKN$H)\u001a7fi&|g\u000eR;sS:<7\u000b[;uI><h\u000e\u0015:pG\u0016\u001c8\u000f\u000b\u0002\r}\u0005iB/Z:u\t\u0016dW\r^5p]^KG\u000f\u001b\"s_.,'o\u00144gY&tW\r\u000b\u0002\u000e}\u0005)C/Z:u\u0005J|7.\u001a:GC&dWO]3BMR,'\u000fR3mKRLwN\\*uCJ$X\r\u001a\u0015\u0003\u001dy\n\u0001\u0005^3ti6+H\u000e^5qY\u0016$\u0016.\u001a:fIR{\u0007/[2EK2,G/[8og\"\u0012qBP\u0001\fS:LGoQ8oi\u0016DH\u000f\u0006\u0004[;.D(\u0010 \t\u0003EmK!\u0001X\n\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fC\u0003_!\u0001\u0007q,A\u0004ce>\\WM]:\u0011\u0007\u0001DWE\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AmF\u0001\u0007yI|w\u000e\u001e \n\u0003qI!aZ\u000e\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\u0004'\u0016\f(BA4\u001c\u0011\u0015a\u0007\u00031\u0001n\u0003\u0019!x\u000e]5dgB\u0019aN];\u000f\u0005=\u0004\bC\u00012\u001c\u0013\t\t8$\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u00141aU3u\u0015\t\t8\u0004\u0005\u0002om&\u0011q\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\t\u000be\u0004\u0002\u0019A\u0013\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0015Y\b\u00031\u0001&\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b{B\u0001\n\u00111\u0001\u007f\u0003)\tG\r\u001a+pa&\u001c\u0017\n\u001a\t\u00035}L1!!\u0001\u001c\u0005\u001d\u0011un\u001c7fC:\fQ#\u001b8ji\u000e{g\u000e^3yi\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\b)\u001aa0!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        replicaStateMachine.clear();
        partitionStateMachine.clear();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)barPartitions, (Object)controllerContext.partitionsInState("bar", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)barReplicas, (Object)controllerContext.replicasInState("bar", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions.$plus$plus((GenTraversableOnce)barPartitions));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion(fooReplicas.$plus$plus((GenTraversableOnce)barReplicas));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$1(x$1))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("bar"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$2(x$2))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)OfflinePartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)OfflineReplica$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicDeletionOfTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        AtomicInteger finishInvoked = new AtomicInteger(0);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionManager, finishInvoked){
            private final TopicDeletionManager deletionManager$1;
            private final AtomicInteger finishInvoked$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$1.finishTopicDelete((String)invocation.getArgument(0));
                this.finishInvoked$1.getAndIncrement();
            }
            {
                this.deletionManager$1 = deletionManager$1;
                this.finishInvoked$1 = finishInvoked$1;
            }
        });
        future.complete(TierPartitionState.AppendResult.ACCEPTED);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicDeletionManagerTest.$anonfun$testBasicDeletionOfTieredTopic$1(finishInvoked)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicDeletionManagerTest.$anonfun$testBasicDeletionOfTieredTopic$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)finishInvoked.get());
        ((DeletionClient)Mockito.verify((Object)this.deletionClient(), (VerificationMode)Mockito.times((int)1))).completeDeleteTopic("foo");
        ((DeletionClient)Mockito.verify((Object)this.deletionClient(), (VerificationMode)Mockito.times((int)0))).completeDeleteTopic("bar");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletionOfTieredTopic$3(x$3))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testExceptionWhenDeletingTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally((Throwable)new TierMetadataRetriableException("exception on tier topic append"));
        CompletableFuture<TierPartitionState.AppendResult> successfulFuture = CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionManager){
            private final TopicDeletionManager deletionManager$2;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$2.finishTopicDelete((String)invocation.getArgument(0));
            }
            {
                this.deletionManager$2 = deletionManager$2;
            }
        });
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(successfulFuture);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testExceptionWhenDeletingTieredTopic$1(x$4))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testDeletionDuringShutdownProcess() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally(new CancellationException("TierTopicManager is shutting down"));
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletionWithBrokerOffline() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$1(failedBrokerId, x$5)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        void offlineReplicas2 = var12_11;
        void onlineReplicas2 = var13_12;
        replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), (ReplicaState)OfflineReplica$.MODULE$, replicaStateMachine.handleStateChanges$default$3());
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)offlineReplicas2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$2(x$7))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBrokerFailureAfterDeletionStarted$1(failedBrokerId, x$8)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        void offlineReplicas2 = var12_11;
        void onlineReplicas2 = var13_12;
        deletionManager.failReplicaDeletion((Set)offlineReplicas2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
    }

    @Test
    public void testMultipleTieredTopicDeletions() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        ListBuffer deletionsBeingCompleted = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionsBeingCompleted){
            private final ListBuffer deletionsBeingCompleted$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionsBeingCompleted$1.$plus$eq(invocation.getArgument(0));
            }
            {
                this.deletionsBeingCompleted$1 = deletionsBeingCompleted$1;
            }
        });
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (Object)deletionsBeingCompleted);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})));
        deletionManager.completeReplicaDeletion((Set)barReplicas);
        Assertions.assertEquals((Object)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)Nil$.MODULE$)), (Object)deletionsBeingCompleted);
    }

    public ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor, boolean addTopicId) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)brokerId -> TopicDeletionManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokers((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        context.setAllTopics(topics);
        if (addTopicId) {
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                context.addTopicId(topic, Uuid.randomUuid());
                return BoxedUnit.UNIT;
            });
        }
        return context;
    }

    public boolean initContext$default$5() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$1(PartitionAndReplica x$1) {
        String string = x$1.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$2(PartitionAndReplica x$2) {
        String string = x$2.topic();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletionOfTieredTopic$1(AtomicInteger finishInvoked$1) {
        return finishInvoked$1.get() > 0;
    }

    public static final /* synthetic */ String $anonfun$testBasicDeletionOfTieredTopic$2() {
        return "Timed out waiting for deletion to be completed";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletionOfTieredTopic$3(PartitionAndReplica x$3) {
        String string = x$3.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testExceptionWhenDeletingTieredTopic$1(PartitionAndReplica x$4) {
        String string = x$4.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$1(int failedBrokerId$1, PartitionAndReplica x$5) {
        return x$5.replica() == failedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$2(PartitionAndReplica x$7) {
        String string = x$7.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerFailureAfterDeletionStarted$1(int failedBrokerId$2, PartitionAndReplica x$8) {
        return x$8.replica() == failedBrokerId$2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$1, String topic) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartition partition = new TopicPartition(topic, partitionId);
            IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size())), IndexedSeq$.MODULE$.canBuildFrom());
            context$1.updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)Nil$.MODULE$));
            ++leaderIndex$1.elem;
        });
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

