/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B'O\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004k\u0001\u0001\u0006IA\u0019\u0005\bW\u0002\u0011\r\u0011\"\u0003b\u0011\u0019a\u0007\u0001)A\u0005E\"9Q\u000e\u0001b\u0001\n\u0013\t\u0007B\u00028\u0001A\u0003%!\rC\u0004p\u0001\t\u0007I\u0011B1\t\rA\u0004\u0001\u0015!\u0003c\u0011\u001d\t\bA1A\u0005\n\u0005DaA\u001d\u0001!\u0002\u0013\u0011\u0007bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B;\t\u000fe\u0004!\u0019!C\u0005i\"1!\u0010\u0001Q\u0001\nUDqa\u0014\u0001A\u0002\u0013%1\u0010\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0011\u001d\ti\u0001\u0001Q!\nqDq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002.\u0001!\t!!\u0005\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\u0012!9\u00111\b\u0001\u0005\u0002\u0005E\u0001bBA \u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u0007\u0002A\u0011AA\t\u0011\u001d\t9\u0005\u0001C\u0001\u0003#Aq!a\u0013\u0001\t\u0003\t\t\u0002C\u0004\u0002P\u0001!\t!!\u0005\t\u000f\u0005M\u0003\u0001\"\u0001\u0002\u0012!9\u0011q\u000b\u0001\u0005\u0002\u0005E\u0001bBA.\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003?\u0002A\u0011AA\t\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003#Aq!a\u001a\u0001\t\u0003\t\t\u0002C\u0004\u0002l\u0001!\t!!\u0005\t\u000f\u0005=\u0004\u0001\"\u0001\u0002\u0012!9\u00111\u000f\u0001\u0005\u0002\u0005E\u0001bBA<\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003s\u0002A\u0011AA\t\u0011\u001d\ti\b\u0001C\u0001\u0003#Aq!!!\u0001\t\u0003\t\t\u0002C\u0004\u0002\u0006\u0002!\t!!\u0005\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\u0012!9\u0011Q\u0012\u0001\u0005\u0002\u0005E\u0001bBAI\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0003A\u0011AA\t\u0011\u001d\tI\n\u0001C\u0001\u0003#Aq!!(\u0001\t\u0003\t\t\u0002C\u0004\u0002\"\u0002!\t!!\u0005\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005E\u0001bBAW\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003c\u0003A\u0011AA\t\u0011\u001d\t)\f\u0001C\u0001\u0003#Aq!!/\u0001\t\u0003\t\t\u0002C\u0004\u0002>\u0002!\t!!\u0005\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002\u0012!9\u0011Q\u0019\u0001\u0005\u0002\u0005E\u0001bBAe\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u001b\u0004A\u0011AA\t\u0011\u001d\t\t\u000e\u0001C\u0001\u0003#Aq!!6\u0001\t\u0003\t\t\u0002C\u0004\u0002Z\u0002!\t!!\u0005\t\u000f\u0005u\u0007\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u001d\u0001\u0005\u0002\u0005E\u0001bBAs\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003S\u0004A\u0011AA\t\u0011\u001d\ti\u000f\u0001C\u0001\u0003#Aq!!=\u0001\t\u0003\t\t\u0002C\u0004\u0002v\u0002!\t!!\u0005\t\u000f\u0005e\b\u0001\"\u0001\u0002\u0012!9\u0011Q \u0001\u0005\u0002\u0005E\u0001b\u0002B\u0001\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0005\u000b\u0001A\u0011AA\t\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003#AqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u001e\u0001!IAa\b\u0003#\u001d\u0013x.\u001e9NKR\fG-\u0019;b)\u0016\u001cHO\u0003\u0002P!\u0006)qM]8va*\u0011\u0011KU\u0001\fG>|'\u000fZ5oCR|'OC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\f\u0005\u0002`\u00015\ta*\u0001\u0007qe>$xnY8m)f\u0004X-F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003mC:<'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014aa\u0015;sS:<\u0017!\u00049s_R|7m\u001c7UsB,\u0007%A\bhe>,\b/\u00138ti\u0006t7-Z%e\u0003A9'o\\;q\u0013:\u001cH/\u00198dK&#\u0007%\u0001\u0005nK6\u0014WM]%e\u0003%iW-\u001c2fe&#\u0007%\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0006dY&,g\u000e\u001e%pgR\f1b\u00197jK:$\bj\\:uA\u0005\u0011\"/\u001a2bY\u0006t7-\u001a+j[\u0016|W\u000f^'t+\u0005)\bCA,w\u0013\t9\bLA\u0002J]R\f1C]3cC2\fgnY3US6,w.\u001e;Ng\u0002\n\u0001c]3tg&|g\u000eV5nK>,H/T:\u0002#M,7o]5p]RKW.Z8vi6\u001b\b%F\u0001}!\tyV0\u0003\u0002\u007f\u001d\niqI]8va6+G/\u00193bi\u0006\f\u0011b\u001a:pkB|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004/\u0006\u0015\u0011bAA\u00041\n!QK\\5u\u0011!\tY!EA\u0001\u0002\u0004a\u0018a\u0001=%c\u00051qM]8va\u0002\nQa]3u+B$\"!a\u0001)\u0007M\t)\u0002\u0005\u0003\u0002\u0018\u0005%RBAA\r\u0015\u0011\tY\"!\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002 \u0005\u0005\u0012a\u00026va&$XM\u001d\u0006\u0005\u0003G\t)#A\u0003kk:LGO\u0003\u0002\u0002(\u0005\u0019qN]4\n\t\u0005-\u0012\u0011\u0004\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0007;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gn\u0015;bE2,\u0007f\u0001\u000b\u00022A!\u0011qCA\u001a\u0013\u0011\t)$!\u0007\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHoQ1o%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8D_6\u0004H.\u001a;j]\u001e\u0014VMY1mC:\u001cW\rK\u0002\u0016\u0003c\t\u0011\u0006^3ti\u000e\u000bgN\\8u%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,\u0007f\u0001\f\u00022\u0005YB/Z:u\u0007\u0006tgn\u001c;SK\n\fG.\u00198dK^CWM\u001c#fC\u0012D3aFA\u0019\u0003!\"Xm\u001d;Ti\u0006\u0014G.\u001a+p!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u0016:b]NLG/[8oQ\rA\u0012\u0011G\u0001\u001bi\u0016\u001cHo\u0015;bE2,Gk\u001c#fC\u0012$&/\u00198tSRLwN\u001c\u0015\u00043\u0005E\u0012a\r;fgR\fu/Y5uS:<'+\u001a2bY\u0006t7-\u001a+p!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u0016:b]NLG/[8oQ\rQ\u0012\u0011G\u0001'i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{G)Z1e)J\fgn]5uS>t\u0007fA\u000e\u00022\u00059C/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8F[B$\u0018\u0010\u0016:b]NLG/[8oQ\ra\u0012\u0011G\u0001\u001ai\u0016\u001cH/R7qif$v\u000eR3bIR\u0013\u0018M\\:ji&|g\u000eK\u0002\u001e\u0003c\tq\u0005^3ti\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW\rV8Ti\u0006\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aa$!\r\u0002EQ,7\u000f^#naRLHk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\ry\u0012\u0011G\u0001$i\u0016\u001cHo\u0015;bE2,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r\u0001\u0013\u0011G\u0001.i\u0016\u001cH/R7qif$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fA\u0011\u00022\u0005YD/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\t\n\t$A\u0018uKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002$\u0003c\t\u0011\b^3ti\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW\rV8Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004I\u0005E\u0012a\b;fgR$U-\u00193U_\u0012+\u0017\rZ%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\u0006\tC/Z:u\t\u0016\fG\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aa%!\r\u0002[Q,7\u000f\u001e#fC\u0012$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002(\u0003c\tA\u0006^3ti\u0012+\u0017\r\u001a+p\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007!\n\t$\u0001\nuKN$8+\u001a7fGR\u0004&o\u001c;pG>d\u0007fA\u0015\u00022\u0005\u0019C/Z:u'\u0016dWm\u0019;Qe>$xnY8m%\u0006L7/Z:JM:{W*Z7cKJ\u001c\bf\u0001\u0016\u00022\u0005YC/Z:u'\u0016dWm\u0019;Qe>$xnY8m\u0007\"|wn]3t\u0007>l\u0007/\u0019;jE2,\u0007K]8u_\u000e|G\u000eK\u0002,\u0003c\tQ\u0003^3tiN+\b\u000f]8siN\u0004&o\u001c;pG>d7\u000fK\u0002-\u0003c\tA\u0003^3tiN+(m]2sS\n,G\rV8qS\u000e\u001c\bfA\u0017\u00022\u0005!C/Z:u'V\u00147o\u0019:jE\u0016$Gk\u001c9jGNtuN\\\"p]N,X.\u001a:He>,\b\u000fK\u0002/\u0003c\ta\u0003^3ti&s\u0017\u000e\u001e(fqR<UM\\3sCRLwN\u001c\u0015\u0004_\u0005E\u0012\u0001\t;fgRLe.\u001b;OKb$x)\u001a8fe\u0006$\u0018n\u001c8F[B$\u0018p\u0012:pkBD3\u0001MA\u0019\u0003A!Xm\u001d;PM\u001a\u001cX\r^\"p[6LG\u000fK\u00022\u0003c\tq\u0003^3ti>3gm]3u\u0007>lW.\u001b;GC&dWO]3)\u0007I\n\t$A\u0015uKN$xJ\u001a4tKR\u001cu.\\7ji\u001a\u000b\u0017\u000e\\;sK^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004g\u0005E\u0012A\t;fgR|eMZ:fi\u000e{W.\\5u/&$\b.\u00118pi\",'\u000fU3oI&tw\rK\u00025\u0003c\t!\u0006^3ti\u000e{gn];nKJ\u0014U-\u0019;t)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LG\u000fK\u00026\u0003c\t\u0001\u0006^3tiR\u0013\u0018M\\:bGRLwN\u001c\"fCR\u001c8i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSRD3ANA\u0019\u0003U\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\\"p[6LG/S:BE>\u0014H/\u001a3B]\u0012\u001cuN\\:v[\u0016\u00148i\\7nSR<\u0016N\\:)\u0007]\n\t$A\u0017uKN$h)Y5mK\u0012$\u0006P\\(gMN,GoQ8n[&$H*Z1wKNtu\u000eU3oI&twm\u0015;bi\u0016D3\u0001OA\u0019\u00035\"Xm\u001d;SKBd\u0017mY3He>,\b/\u00138ti\u0006t7-Z,ji\"tuN\\#ySN$\u0018N\\4NK6\u0014WM\u001d\u0015\u0004s\u0005E\u0012\u0001\u0007;fgR\u0014V\r\u001d7bG\u0016<%o\\;q\u0013:\u001cH/\u00198dK\"\u001a!(!\r\u0002-Q,7\u000f^%om>\\WMS8j]\u000e\u000bG\u000e\u001c2bG.D3aOA\u0019\u0003e!Xm\u001d;O_RLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6)\u0007q\n\t$\u0001\fuKN$\u0018J\u001c<pW\u0016\u001c\u0016P\\2DC2d'-Y2lQ\ri\u0014\u0011G\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3Ts:\u001c7)\u00197mE\u0006\u001c7\u000eK\u0002?\u0003c\t1\u0004^3ti\"\u000b7\u000fU3oI&twMT8o)btwJ\u001a4tKR\u001c\bfA \u00022\u0005AB/Z:u\u0011\u0006\u001c\b+\u001a8eS:<G\u000b\u001f8PM\u001a\u001cX\r^:)\u0007\u0001\u000b\t$A\u000euKN$(+\u001a2bY\u0006t7-Z*uCJ$H+[7fgR\fW\u000e\u001d\u0015\u0004\u0003\u0006E\u0012A\t;fgR\u001c\u0015M\u001c8pi\u0006#G\rU3oI&tw-T3nE\u0016\u0014\u0018JZ*uC\ndW\rK\u0002C\u0003c\t\u0011\u0006^3tiJ+Wn\u001c<bY\u001a\u0013x.\u001c)f]\u0012LgnZ!gi\u0016\u0014X*Z7cKJL5o\u0015;bE2,\u0007fA\"\u00022\u0005IC/Z:u%\u0016lwN^1m\rJ|W\u000eU3oI&twm\u00165f]6+WNY3s\u0013N\u0014V-\\8wK\u0012D3\u0001RA\u0019\u0003%\"Xm\u001d;DC:tw\u000e^!eIN#\u0018\r^5d\u001b\u0016l'-\u001a:JM\u0006c'/Z1esB\u0013Xm]3oi\"\u001aQ)!\r\u0002OQ,7\u000f^\"b]:|G/\u00113e!\u0016tG-\u001b8h'ft7m\u00144V].twn\u001e8NK6\u0014WM\u001d\u0015\u0004\r\u0006E\u0012A\u000b;fgR\u001c\u0015M\u001c8piJ+Wn\u001c<f!\u0016tG-\u001b8h'ft7m\u00144V].twn\u001e8NK6\u0014WM\u001d\u0015\u0004\u000f\u0006E\u0012\u0001\n;fgR\u001c\u0015M\\!eI\u0006sGMU3n_Z,\u0007+\u001a8eS:<7+\u001f8d\u001b\u0016l'-\u001a:)\u0007!\u000b\t$A\u0017uKN$(+Z7pm\u0006dgI]8n!\u0016tG-\u001b8h'ft7m\u00165f]6+WNY3s\u0013N\u0014V-\\8wK\u0012D3!SA\u0019\u0003%\"Xm\u001d;OK^<UM\\3sCRLwN\\\"mK\u0006\u00148\u000fU3oI&twmU=oG6+WNY3sg\"\u001a!*!\r\u0002\u0017\u0005\u001c8/\u001a:u'R\fG/\u001a\u000b\u0007\u0003\u0007\u0011\tBa\u0005\t\u000b=[\u0005\u0019\u0001?\t\u000f\tU1\n1\u0001\u0003\u0018\u0005YA/\u0019:hKR\u001cF/\u0019;f!\ry&\u0011D\u0005\u0004\u00057q%AC$s_V\u00048\u000b^1uK\u0006\trN\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\u0015\t\t\u0005\"Q\u0006\t\u0005\u0005G\u0011I#\u0004\u0002\u0003&)\u0019!q\u0005*\u0002\r\r|W.\\8o\u0013\u0011\u0011YC!\n\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u000301\u0003\rA!\r\u0002\r=4gm]3u!\r9&1G\u0005\u0004\u0005kA&\u0001\u0002'p]\u001e\u0004")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupInstanceId;
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava())).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        member.supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        member.awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)new Some((Object)this.memberId()), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId);
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)new Some((Object)newMemberId), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testRebalanceStartTimestamp() {
        MockTime time = new MockTime();
        GroupMetadata group = new GroupMetadata("groupId2", (GroupState)Empty$.MODULE$, (Time)time);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Option expectedRebalanceStartTimestamp = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)time.milliseconds()));
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        expectedRebalanceStartTimestamp = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)time.milliseconds()));
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        group.transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        this.group().remove(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().hasStaticMember(this.groupInstanceId()));
        Assertions.assertThrows(IllegalStateException.class, () -> {
            GroupMetadata qual$2 = this.group();
            Function1 x$4 = qual$2.add$default$2();
            qual$2.add(member, x$4);
        });
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupInstanceId = "groupInstanceId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

