/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003U\u0011\u0019Q\u0006\u0001)A\u0005+\"91\f\u0001b\u0001\n\u0013a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\n5Da!\u001d\u0001!\u0002\u0013q\u0007b\u0002:\u0001\u0005\u0004%I!\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u00028\t\u000fQ\u0004!\u0019!C\u0005)\"1Q\u000f\u0001Q\u0001\nUCqA\u001e\u0001C\u0002\u0013%A\u000b\u0003\u0004x\u0001\u0001\u0006I!\u0016\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u001d\ty\u0001\u0001Q\u0001\niD\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005u\u0001\u0001)A\u0005\u0003+A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005U\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u001b\t\u0011\u0005U\u0004\u0001)A\u0005\u0003WB\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wB\u0011\"a!\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003wBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\u0012\u0002!\t!!#\t\u000f\u0005%\u0006\u0001\"\u0001\u0002\n\"9\u0011Q\u0016\u0001\u0005\u0002\u0005%\u0005bBAY\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003k\u0003A\u0011AAE\u0011\u001d\tI\f\u0001C\u0001\u0003\u0013Cq!!0\u0001\t\u0003\tI\tC\u0004\u0002B\u0002!\t!!#\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002\n\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005%\u0005bBAg\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003#\u0004A\u0011AAE\u0011\u001d\t)\u000e\u0001C\u0001\u0003\u0013Cq!!7\u0001\t\u0003\tI\tC\u0004\u0002^\u0002!\t!!#\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002\n\"9\u0011Q\u001d\u0001\u0005\u0002\u0005%\u0005bBAu\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003[\u0004A\u0011AAE\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\f\u0001!IA!\u0004\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0002.)J\fgn]1di&|g.T1sW\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:UKN$(B\u0001\"D\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u0011+\u0015aC2p_J$\u0017N\\1u_JT\u0011AR\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0003\"A\u0015\u0001\u000e\u0003\u0005\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002+B\u0011!JV\u0005\u0003/.\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8oA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002QB\u0011!*[\u0005\u0003U.\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\ta\u000e\u0005\u0002K_&\u0011\u0001o\u0013\u0002\u0006'\"|'\u000f^\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0003Ea\u0017m\u001d;Qe>$WoY3s\u000bB|7\r[\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0007%\u0001\u0007uq:$\u0016.\\3pkRl5/A\u0007uq:$\u0016.\\3pkRl5\u000fI\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\f\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0003%!\bP\u001c*fgVdG/F\u0001{!\rY\u00181B\u0007\u0002y*\u0011QP`\u0001\te\u0016\fX/Z:ug*\u0019q0!\u0001\u0002\r\r|W.\\8o\u0015\r1\u00151\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\t1a\u001c:h\u0013\r\ti\u0001 \u0002\u0012)J\fgn]1di&|gNU3tk2$\u0018A\u0003;y]J+7/\u001e7uA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u000b!\u0011\t9\"!\u0007\u000e\u0003yL1!a\u0007\u007f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010ibt\u0017\nZ!oI6\u000b'o[3sgV\u0011\u00111\u0005\t\u0007\u0003K\tY#a\f\u000e\u0005\u0005\u001d\"bAA\u0015C\u0006!Q\u000f^5m\u0013\u0011\ti#a\n\u0003\t1K7\u000f\u001e\t\u0004%\u0006E\u0012bAA\u001a\u0003\n\u0019B\u000b\u001f8JI\u0006sG-T1sW\u0016\u0014XI\u001c;ss\u0006\u0001B\u000f\u001f8JI\u0006sG-T1sW\u0016\u00148\u000fI\u0001\fibtW*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002<A\u0019!+!\u0010\n\u0007\u0005}\u0012IA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-\u0001\u0007uq:lU\r^1eCR\f\u0007%\u0001\u000bnCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u000b\u0003\u0003\u000f\u00022AUA%\u0013\r\tY%\u0011\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018!F7be.,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\u0010ibt7\u000b^1uK6\u000bg.Y4feV\u0011\u00111\u000b\t\u0004%\u0006U\u0013bAA,\u0003\n9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0011ibt7\u000b^1uK6\u000bg.Y4fe\u0002\nq\u0001[1oI2,'/\u0006\u0002\u0002`A\u0019!+!\u0019\n\u0007\u0005\r\u0014IA\u0015Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM]\u0001\tQ\u0006tG\r\\3sA\u00059Q.\u001a;sS\u000e\u001cXCAA6!\u0011\ti'!\u001d\u000e\u0005\u0005=$bAA4}&!\u00111OA8\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0019gR\fG/Z#se>\u0014(+\u0019;f\u001b\u0016$(/[2OC6,WCAA>!\u0011\t9\"! \n\u0007\u0005}dP\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f\u0011d\u001d;bi\u0016,%O]8s%\u0006$X-T3ue&\u001cg*Y7fA\u0005I2\u000f^1uK\u0016\u0013(o\u001c:D_VtG/T3ue&\u001cg*Y7f\u0003i\u0019H/\u0019;f\u000bJ\u0014xN]\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003%iwnY6DC\u000eDW\r\u0006\u0002\u0002\fB\u0019!*!$\n\u0007\u0005=5J\u0001\u0003V]&$\u0018aL:i_VdGMU3F]F,X-^3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8Ce>\\WM\u001d#jg\u000e|gN\\3di\u0016$\u0007fA\u0014\u0002\u0016B!\u0011qSAS\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015aA1qS*!\u0011qTAQ\u0003\u001dQW\u000f]5uKJTA!a)\u0002\b\u0005)!.\u001e8ji&!\u0011qUAM\u0005\u0011!Vm\u001d;\u0002{MDw.\u001e7e)\"\u0014xn^%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\%g\u000bJ\u0014xN]\"pI\u0016tu\u000e^!wC&d\u0017M\u00197f\r>\u0014\b+\u001b3)\u0007!\n)*\u0001\u0016tQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\u001c(p\u000bJ\u0014xN]:)\u0007%\n)*\u0001\u0019tQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\u001c(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004U\u0005U\u0015\u0001N:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gnQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ5oO\"\u001a1&!&\u0002sMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3o\u0007>|'\u000fZ5oCR|'/\u00129pG\"\u001c\u0005.\u00198hK\u0012D3\u0001LAK\u0003Y\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u00165f]&sg/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2iQ\ri\u0013QS\u00018g\"|W\u000f\u001c3D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:<\u0006.Z\"p_J$\u0017N\\1u_J,\u0005o\\2i\r\u0016t7-\u001a3)\u00079\n)*\u0001\u0019tQ>,H\u000e\u001a+ie><\u0018\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>tw\u000b[3o+:\\gn\\<o\u000bJ\u0014xN\u001d\u0015\u0004_\u0005U\u0015aN:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3FeJ|'\u000fK\u00021\u0003+\u000b\u0001h\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\\'fgN\fw-\u001a+p_2\u000b'oZ3FeJ|'\u000fK\u00022\u0003+\u000b1h\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\u001c*fG>\u0014H\rT5tiR{w\u000eT1sO\u0016,%O]8sQ\r\u0011\u0014QS\u0001=g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|gn\u00165f]&sg/\u00197jIJ+\u0017/^5sK\u0012\f5m[:FeJ|'\u000fK\u00024\u0003+\u000bAg\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:,%O]8sQ\r!\u0014QS\u00011g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016tgj\u001c;MK\u0006$WM](s\r>dGn\\<fe\u0016\u0013(o\u001c:)\u0007U\n)*\u0001\u0018tQ>,H\u000e\u001a*fiJL\b+\u0019:uSRLwN\\,iK:tu\u000e^#o_V<\u0007NU3qY&\u001c\u0017m]#se>\u0014\bf\u0001\u001c\u0002\u0016\u0006I4\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8O_R,en\\;hQJ+\u0007\u000f\\5dCN\fe\r^3s\u0003B\u0004XM\u001c3FeJ|'\u000fK\u00028\u0003+\u000b\u0011f\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o\u0017\u000647.Y*u_J\fw-Z#se>\u0014\bf\u0001\u001d\u0002\u0016\u0006)5\u000f[8vY\u0012\u0014V-\\8wKR{\u0007/[2QCJ$\u0018\u000e^5p]\u001a\u0013x.\\,bSRLgnZ*fi>sWK\\:vaB|'\u000f^3e\r>\u0014X*Z:tC\u001e,gi\u001c:nCRD3!OAK\u0003u1XM]5gsJ+GO]5fgB\u000b'\u000f^5uS>twJ\\#se>\u0014H\u0003BAF\u0003kDq!a>;\u0001\u0004\tI0A\u0003feJ|'\u000f\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\r\tyP`\u0001\taJ|Go\\2pY&!!1AA\u007f\u0005\u0019)%O]8sg\u00069c/\u001a:jMf$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u001f:,%O]8s)\u0011\tYI!\u0003\t\u000f\u0005]8\b1\u0001\u0002z\u0006)c/\u001a:jMf\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003\u0017\u0013y\u0001C\u0004\u0002xr\u0002\r!!?\u0002GY,'/\u001b4z%\u0016lwN^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]>sWI\u001d:peR!\u00111\u0012B\u000b\u0011\u001d\t90\u0010a\u0001\u0003s\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'/\u00133FeJ|'/T1q)\u0011\u0011YBa\u000b\u0011\u0011\u0005\u0015\"Q\u0004B\u0011\u0005KIAAa\b\u0002(\t9\u0001*Y:i\u001b\u0006\u0004\bc\u00010\u0003$%\u0011!n\u0018\t\t\u0003K\u00119#!\u0006\u0002z&!!\u0011FA\u0014\u0005\ri\u0015\r\u001d\u0005\b\u0005[q\u0004\u0019AA}\u0003\u0019)'O]8sg\u0006)2/\u001a;vaN#\u0018\r^3FeJ|'oU3og>\u0014HC\u0001B\u001a!\u0011\tiG!\u000e\n\t\t]\u0012q\u000e\u0002\u0007'\u0016t7o\u001c:")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkers = Arrays.asList((Object[])new TxnIdAndMarkerEntry[]{new TxnIdAndMarkerEntry(this.transactionalId(), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.txnIdAndMarkers());
    private final Metrics metrics = new Metrics();
    private final MetricName stateErrorRateMetricName = this.metrics().metricName("transaction-state-error-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which state errors occur within the transaction coordinator");
    private final MetricName stateErrorCountMetricName = this.metrics().metricName("transaction-state-error-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of state errors that have occurred within the transaction coordinator");

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private List<TxnIdAndMarkerEntry> txnIdAndMarkers() {
        return this.txnIdAndMarkers;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public MetricName stateErrorRateMetricName() {
        return this.stateErrorRateMetricName;
    }

    public MetricName stateErrorCountMetricName() {
        return this.stateErrorCountMetricName;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        EasyMock.expect((Object)this.txnStateManager().stateErrorSensor()).andReturn((Object)this.setupStateErrorSensor());
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorCountMetricName()).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorRateMetricName()).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWheCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderOrFollowerError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRetryPartitionWhenKafkaStorageError() {
        this.verifyRetriesPartitionOnError(Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    private void verifyThrowIllegalStateExceptionOnError(Errors error) {
        EasyMock.expect((Object)this.txnStateManager().stateErrorSensor()).andReturn((Object)this.setupStateErrorSensor());
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorCountMetricName()).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.metrics().metric(this.stateErrorRateMetricName()).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().maybeWriteTxnCompletion(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            completed.elem = true;
            return BoxedUnit.UNIT;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assertions.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        this.markerChannelManager().removeMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            removed.elem = true;
            return BoxedUnit.UNIT;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)removed.elem);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor setupStateErrorSensor() {
        void var3_3;
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Sensor sensor = this.metrics().sensor("TransactionStateErrors");
        sensor.add((CompoundStat)new Meter(this.stateErrorRateMetricName(), this.stateErrorCountMetricName()));
        return var3_3;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

