/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditJobResult;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0015+\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001A\u0002\u0013\u0005Q\bC\u0004G\u0001\u0001\u0007I\u0011A$\t\r5\u0003\u0001\u0015)\u0003?\u0011\u001dq\u0005\u00011A\u0005\u0002=CqA\u0016\u0001A\u0002\u0013\u0005q\u000b\u0003\u0004Z\u0001\u0001\u0006K\u0001\u0015\u0005\n5\u0002\u0001\r\u00111A\u0005\u0002mC\u0011B\u0019\u0001A\u0002\u0003\u0007I\u0011A2\t\u0013\u0015\u0004\u0001\u0019!A!B\u0013a\u0006b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\bW\u0002\u0001\r\u0011\"\u0001m\u0011\u0019q\u0007\u0001)Q\u0005Q\"9q\u000e\u0001a\u0001\n\u0003\u0001\b\"CA\t\u0001\u0001\u0007I\u0011AA\n\u0011\u001d\t9\u0002\u0001Q!\nED\u0011\"!\u0007\u0001\u0001\u0004%\t!a\u0007\t\u0013\u00055\u0002\u00011A\u0005\u0002\u0005=\u0002\u0002CA\u001a\u0001\u0001\u0006K!!\b\t\u0013\u0005U\u0002A1A\u0005\u0002\u0005]\u0002\u0002CA \u0001\u0001\u0006I!!\u000f\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013\u0005\u00111\t\u0005\f\u0003\u001f\u0002\u0001\u0019!a\u0001\n\u0003\t\t\u0006C\u0006\u0002V\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0003bCA,\u0001\u0001\u0007\t\u0019!C\u0001\u00033B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002d!Y\u0011q\r\u0001A\u0002\u0003\u0005\u000b\u0015BA.\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a!\u0001\t\u0003\tY\u0007C\u0004\u0002\u000e\u0002!\t!a\u001b\t\u000f\u0005]\u0005\u0001\"\u0001\u0002l!9\u00111\u0014\u0001\u0005\u0002\u0005-\u0004bBAP\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003G\u0003A\u0011AA6\u0011\u001d\t9\u000b\u0001C\u0001\u0003WBq!a+\u0001\t\u0003\tY\u0007C\u0004\u00020\u0002!\t!a\u001b\t\u000f\u0005M\u0006\u0001\"\u0001\u0002l!9\u0011q\u0017\u0001\u0005\u0002\u0005-\u0004bBA^\u0001\u0011\u0005\u00111\u000e\u0002\r\u0003V$\u0017\u000e\u001e&pER+7\u000f\u001e\u0006\u0003W1\nQ!Y;eSRT!!\f\u0018\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u00010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002<\u00015\t!&\u0001\u0004m_\u001e$\u0015N]\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003S>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003\u0011.\u0003\"aM%\n\u0005)#$\u0001B+oSRDq\u0001T\u0002\u0002\u0002\u0003\u0007a(A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003':\n1\u0001\\8h\u0013\t)&K\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002I1\"9AJBA\u0001\u0002\u0004\u0001\u0016a\u00037pO6\u000bg.Y4fe\u0002\nA\u0001^5nKV\tA\f\u0005\u0002^A6\taL\u0003\u0002`]\u0005)Q\u000f^5mg&\u0011\u0011M\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006AA/[7f?\u0012*\u0017\u000f\u0006\u0002II\"9A*CA\u0001\u0002\u0004a\u0016!\u0002;j[\u0016\u0004\u0013\u0001C1vI&$(j\u001c2\u0016\u0003!\u0004\"aO5\n\u0005)T#\u0001C!vI&$(j\u001c2\u0002\u0019\u0005,H-\u001b;K_\n|F%Z9\u0015\u0005!k\u0007b\u0002'\r\u0003\u0003\u0005\r\u0001[\u0001\nCV$\u0017\u000e\u001e&pE\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002cB\u0019!O_?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<1\u0003\u0019a$o\\8u}%\tQ'\u0003\u0002zi\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003sR\u00022A`A\u0007\u001b\u0005y(\u0002BA\u0001\u0003\u0007\taaY8n[>t'bA\u0018\u0002\u0006)!\u0011qAA\u0005\u0003\u0019\t\u0007/Y2iK*\u0011\u00111B\u0001\u0004_J<\u0017bAA\b\u007f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:`I\u0015\fHc\u0001%\u0002\u0016!9AjDA\u0001\u0002\u0004\t\u0018\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003!y'M[*u_J,WCAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tQa\u001d;pe\u0016T1!a\n/\u0003\u0011!\u0018.\u001a:\n\t\u0005-\u0012\u0011\u0005\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006aqN\u00196Ti>\u0014Xm\u0018\u0013fcR\u0019\u0001*!\r\t\u00111\u0013\u0012\u0011!a\u0001\u0003;\t\u0011b\u001c2k'R|'/\u001a\u0011\u0002\u000b)|'-\u00133\u0016\u0005\u0005e\u0002cA\u001a\u0002<%\u0019\u0011Q\b\u001b\u0003\u0007%sG/\u0001\u0004k_\nLE\rI\u0001\b[\u0016$(/[2t+\t\t)\u0005\u0005\u0003\u0002H\u0005-SBAA%\u0015\r\t\te`\u0005\u0005\u0003\u001b\nIEA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0004\u0011\u0006M\u0003\u0002\u0003'\u0018\u0003\u0003\u0005\r!!\u0012\u0002\u00115,GO]5dg\u0002\nab]5na2,'+\u001a9peR,'/\u0006\u0002\u0002\\A\u00191(!\u0018\n\u0007\u0005}#FA\u0007Bk\u0012LGOU3q_J$XM]\u0001\u0013g&l\u0007\u000f\\3SKB|'\u000f^3s?\u0012*\u0017\u000fF\u0002I\u0003KB\u0001\u0002\u0014\u000e\u0002\u0002\u0003\u0007\u00111L\u0001\u0010g&l\u0007\u000f\\3SKB|'\u000f^3sA\u0005)1/\u001a;VaR\t\u0001\nK\u0002\u001d\u0003_\u0002B!!\u001d\u0002\u00005\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0002ba&TA!!\u001f\u0002|\u00059!.\u001e9ji\u0016\u0014(\u0002BA?\u0003\u0013\tQA[;oSRLA!!!\u0002t\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!HAD!\u0011\t\t(!#\n\t\u0005-\u00151\u000f\u0002\n\u0003\u001a$XM]#bG\"\fA\u0003^3tiNKW\u000e\u001d7f\u001f\u001a47/\u001a;TG\u0006t\u0007f\u0001\u0010\u0002\u0012B!\u0011\u0011OAJ\u0013\u0011\t)*a\u001d\u0003\tQ+7\u000f^\u0001\u001bi\u0016\u001cHoU5na2,G+[3sK\u0012|eMZ:fiN\u001b\u0017M\u001c\u0015\u0004?\u0005E\u0015a\b;fgRl\u0015n]:j]\u001e\u001cVmZ7f]RLen\u00142kK\u000e$8\u000b^8sK\"\u001a\u0001%!%\u0002\u001fQ,7\u000f^#oIR{WI\u001c3Sk:D3!IAI\u0003\r\"Xm\u001d;PM\u001a\u001cX\r^$ba\n+Go^3f]RKWM]!oI2{7-\u00197M_\u001eD3AIAI\u0003a!Xm\u001d;US\u0016\u0014xJ\u001a4tKR<\u0015\r\u001d*fiJLWm\u001d\u0015\u0004G\u0005E\u0015A\u0006;fgRtuN\\!mS\u001etW\rZ*fO6,g\u000e^:)\u0007\u0011\n\t*A\u000euKN$8i\\7qC\u000e$X\r\u001a+pa&\u001c\u0017j]!w_&$W\r\u001a\u0015\u0004K\u0005E\u0015!\t;fgRd\u0015\r^2i\u0007>,h\u000e\u001e3po:$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007f\u0001\u0014\u0002\u0012\u0006)C/Z:u\u0003V$\u0017\u000e\u001e&pENcW-\u001a9t\r>\u0014H+[3s-\u0016\u0014\u0018NZ5dCRLwN\u001c\u0015\u0004O\u0005E\u0015\u0001\u000b;fgR$\u0016.\u001a:M_\u001e\u001cVmZ7f]R\u001cuN\u001c<feNLwN\u001c$peZ\u000bG.\u001b3bi>\u0014\bf\u0001\u0015\u0002\u0012\u0002")
public class AuditJobTest {
    private File logDir = null;
    private LogManager logManager = null;
    private MockTime time;
    private AuditJob auditJob = null;
    private Seq<TopicPartition> topicPartitions = Nil$.MODULE$;
    private TierObjectStore objStore = null;
    private final int jobId;
    private Metrics metrics;
    private AuditReporter simpleReporter;

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public AuditJob auditJob() {
        return this.auditJob;
    }

    public void auditJob_$eq(AuditJob x$1) {
        this.auditJob = x$1;
    }

    public Seq<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(Seq<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public TierObjectStore objStore() {
        return this.objStore;
    }

    public void objStore_$eq(TierObjectStore x$1) {
        this.objStore = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter simpleReporter() {
        return this.simpleReporter;
    }

    public void simpleReporter_$eq(AuditReporter x$1) {
        this.simpleReporter = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.time_$eq(new MockTime());
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)TierObjectStoreConfig.createEmpty()));
        this.metrics_$eq(new Metrics(new MetricConfig(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (Time)this.time()));
        this.simpleReporter_$eq(AuditReporter$.MODULE$.apply(new DurabilityMetricsManager("0", this.metrics(), (Time)this.time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4())));
    }

    @AfterEach
    public void tearDown() {
        if (this.objStore() != null) {
            this.objStore().close();
        }
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testSimpleOffsetScan() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time()));
        Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$3());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), segments, (Seq<TierLogSegment>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)4L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleTieredOffsetScan() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)mockLogManager.getLog((TopicPartition)this.topicPartitions().head(), mockLogManager.getLog$default$2())).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), mockLogManager, new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time()));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testSimpleTieredOffsetScan$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testMissingSegmentInObjectStore() {
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        Mockito.when((Object)mockLogManager.getLog((TopicPartition)this.topicPartitions().head(), mockLogManager.getLog$default$2())).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        this.auditJob_$eq(new AuditJob(this, mockLogManager){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata((TierLogSegment)tierSegments.head()), this.objStore());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1010L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testEndToEndRun() {
        long expectedTotalMsgCount = 2004L;
        long expectedGapCount = 0L;
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)new .colon.colon((Object)new TopicPartition("some-topic", 2), (List)Nil$.MODULE$)));
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)TierObjectStoreConfig.createEmpty()));
        Map logMap = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)topicPartition, this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
            tierSegments.foreach((Function1 & Serializable & scala.Serializable)tierSegment -> {
                AuditJobTest.$anonfun$testEndToEndRun$2(this, tierSegment);
                return BoxedUnit.UNIT;
            });
            Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 2000L);
            return new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, localSegments, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)logMap));
        CountDownLatch countdown = new CountDownLatch(1);
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), countdown, this.simpleReporter(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time()));
        this.auditJob().run();
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            AuditJobTest.$anonfun$testEndToEndRun$3(this, expectedGapCount, expectedTotalMsgCount, topicPartition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Assertions.assertEquals((long)0L, (long)countdown.getCount());
    }

    @Test
    public void testOffsetGapBetweenTierAndLocalLog() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        int localLogStartOffset = 2042;
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)mockLogManager.getLog((TopicPartition)this.topicPartitions().head(), mockLogManager.getLog$default$2())).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)localLogStartOffset));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), mockLogManager, new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time()));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testOffsetGapBetweenTierAndLocalLog$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)42L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierOffsetGapRetries() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time()));
        Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap$default$4());
        Seq<TierLogSegment> secondaryTierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 2000L);
        ((IterableLike)tierSegments.$plus$plus(secondaryTierSegments, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testTierOffsetGapRetries$1(this, segment);
            return BoxedUnit.UNIT;
        });
        Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 4000L);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<Seq<TierLogSegment>>)new Some(tierSegments.$plus$plus(secondaryTierSegments, Seq$.MODULE$.canBuildFrom())), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)4004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testNonAlignedSegments() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)mockLogManager.getLog((TopicPartition)this.topicPartitions().head(), mockLogManager.getLog$default$2())).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), mockLogManager, new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time()));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 11L, 20L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 18L, 31L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6()), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            AuditJobTest.$anonfun$testNonAlignedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(20L, 30L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(31L, 40L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(41L, 50L, this.logDir(), LogTestUtils$.MODULE$.createLocalLogSegment$default$4(), LogTestUtils$.MODULE$.createLocalLogSegment$default$5(), LogTestUtils$.MODULE$.createLocalLogSegment$default$6()), (List)Nil$.MODULE$)));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)66L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicIsAvoided() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time()));
        Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap$default$3());
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Nil$ x$3 = Nil$.MODULE$;
        boolean x$4 = true;
        Option<Seq<TierLogSegment>> x$5 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$6 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$7 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        AuditJobResult auditResult = this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog(x$1, segments, (Seq<TierLogSegment>)x$3, x$5, x$6, x$7, x$4));
        Assertions.assertEquals((long)0L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertFalse((boolean)auditResult.errorOpt().isEmpty());
        Predef$.MODULE$.assert(auditResult.errorOpt().get() instanceof UnsupportedOperationException);
        Assertions.assertTrue((boolean)((Throwable)auditResult.errorOpt().get()).getMessage().contains("shouldn't be audited"));
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLatchCountdownThrowsException() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), new CountDownLatch(0), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time()));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6()), (List)Nil$.MODULE$);
        Assertions.assertThrows(InterruptedException.class, () -> AuditJobTest.$anonfun$testLatchCountdownThrowsException$1(this, (Seq)tierSegments), () -> "Expected InterruptedException to be thrown");
    }

    @Test
    public void testAuditJobSleepsForTierVerification() {
        this.topicPartitions_$eq((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new AuditJob(this.topicPartitions(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.jobId(), (Option)None$.MODULE$, (Time)this.time()));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        Seq tierSegments = (Seq)Seq$.MODULE$.fill(AuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE() + 1, (Function0 & Serializable & scala.Serializable)() -> LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), LogTestUtils$.MODULE$.createTierLogSegment$default$5(), LogTestUtils$.MODULE$.createTierLogSegment$default$6()));
        long beforeAccessTimestamp = this.time().milliseconds();
        this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
        Assertions.assertEquals((long)(AuditJob$.MODULE$.SLEEP_TIME_MS() * 2L), (long)(this.time().milliseconds() - beforeAccessTimestamp));
    }

    @Test
    public void testTierLogSegmentConversionForValidator() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        int keyBaseOffset = 44;
        int virtualBaseOffset = 43;
        int endOffset = 55;
        int maxTimestamp = 100;
        int size = 33;
        SegmentState segmentState = new SegmentState(0, UUID.randomUUID(), (long)virtualBaseOffset, (long)keyBaseOffset, (long)endOffset, (long)maxTimestamp, size, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, false, false, TierObjectStore.OpaqueData.ZEROED, 99L);
        TierLogSegment tierLogSegmentOverlapping = new TierLogSegment(topicIdPartition, segmentState);
        TierObjectMetadata overlappingMetadata = AuditJob$.MODULE$.getTierObjectMetadata(tierLogSegmentOverlapping);
        Assertions.assertEquals((long)keyBaseOffset, (long)overlappingMetadata.baseOffset(), (String)"tier log segment with virtually bounded base offset should return true key base offset in metadata");
        Assertions.assertEquals((long)55L, (long)overlappingMetadata.endOffset());
        Assertions.assertEquals((long)100L, (long)overlappingMetadata.maxTimestamp());
        Assertions.assertEquals((int)33, (int)size);
    }

    public static final /* synthetic */ void $anonfun$testSimpleTieredOffsetScan$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$2(AuditJobTest $this, TierLogSegment tierSegment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(tierSegment), $this.objStore());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEndToEndRun$3(AuditJobTest $this, long expectedGapCount$1, long expectedTotalMsgCount$1, TopicPartition topicPartition) {
        void var7_5;
        void var9_6;
        Tuple2 tuple2 = $this.simpleReporter().getDurabilityCounters(topicPartition);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long total = tuple2._1$mcJ$sp();
        long gap = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)expectedGapCount$1, (long)var9_6, (String)new StringBuilder(19).append("Incorrect gap for: ").append(topicPartition).toString());
        Assertions.assertEquals((long)expectedTotalMsgCount$1, (long)var7_5, (String)new StringBuilder(21).append("Incorrect total for: ").append(topicPartition).toString());
    }

    public static final /* synthetic */ void $anonfun$testOffsetGapBetweenTierAndLocalLog$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierOffsetGapRetries$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testNonAlignedSegments$1(AuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(AuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testLatchCountdownThrowsException$1(AuditJobTest $this, Seq tierSegments$1) {
        $this.auditJob().doAuditSafely(DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)$this.topicPartitions().head(), (Seq<LogSegment>)Nil$.MODULE$, (Seq<TierLogSegment>)tierSegments$1, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7()));
    }

    public AuditJobTest() {
        this.jobId = 0;
    }
}

