/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kafka.durability.audit.AuditManager;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.DeletePartitionRequest;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.EpochChangeRequest;
import kafka.durability.audit.HealthCheckRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest$;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\u0012$\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004C\u0001\u0001\u0006Ia\u000e\u0005\b\u0007\u0002\u0011\r\u0011\"\u00017\u0011\u0019!\u0005\u0001)A\u0005o!IQ\t\u0001a\u0001\u0002\u0004%\tA\u0012\u0005\n\u001b\u0002\u0001\r\u00111A\u0005\u00029C\u0011\u0002\u0016\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00031\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u0011%\u0001\u0007\u00011A\u0001B\u0003&q\u000bC\u0004b\u0001\u0001\u0007I\u0011\u00012\t\u000f9\u0004\u0001\u0019!C\u0001_\"1\u0011\u000f\u0001Q!\n\rD\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A:\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0003i\b\"C@\u0001\u0001\u0004\u0005\t\u0015)\u0003u\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%\t!a\u0001\t\u0017\u0005-\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0002\u0005\f\u0003#\u0001\u0001\u0019!A!B\u0013\t)\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u0016!9\u0011q\u0007\u0001\u0005\u0002\u0005U\u0001bBA!\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003\u000b\u0002A\u0011AA\u000b\u0011\u001d\tI\u0005\u0001C\u0001\u0003+Aq!!\u0014\u0001\t\u0003\t)\u0002C\u0004\u0002R\u0001!\t!!\u0006\t\u000f\u0005U\u0003\u0001\"\u0001\u0002\u0016!9\u0011\u0011\f\u0001\u0005\u0002\u0005U\u0001bBA/\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003C\u0002A\u0011AA\u000b\u0011\u001d\t)\u0007\u0001C\u0001\u0003+\u0011\u0001#Q;eSRl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\u0011*\u0013!B1vI&$(B\u0001\u0014(\u0003)!WO]1cS2LG/\u001f\u0006\u0002Q\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011aI\u0001\u0004iB\fT#A\u001c\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014AB2p[6|gN\u0003\u0002)y)\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\t\u0015H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nA\u0001^5nKV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002Ks\u0005)Q\u000f^5mg&\u0011A*\u0013\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\ty%\u000b\u0005\u0002-!&\u0011\u0011+\f\u0002\u0005+:LG\u000fC\u0004T\u000f\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'A\u0003uS6,\u0007%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!AW\u0014\u0002\rM,'O^3s\u0013\ta\u0016L\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0003\u001f~Cqa\u0015\u0006\u0002\u0002\u0003\u0007q+A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003=!\u0018.\u001a:PE*\u001cFo\u001c:f\u001fB$X#A2\u0011\u00071\"g-\u0003\u0002f[\t1q\n\u001d;j_:\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000bM$xN]3\u000b\u0005-<\u0013\u0001\u0002;jKJL!!\u001c5\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'n\u0015;pe\u0016|\u0005\u000f^0%KF$\"a\u00149\t\u000fMk\u0011\u0011!a\u0001G\u0006\u0001B/[3s\u001f\nT7\u000b^8sK>\u0003H\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0005%|'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\u0005=s\bbB*\u0011\u0003\u0003\u0005\r\u0001^\u0001\bi6\u0004H)\u001b:!\u0003A!Xm\u001d;Bk\u0012LG/T1oC\u001e,'/\u0006\u0002\u0002\u0006A\u0019A'a\u0002\n\u0007\u0005%1E\u0001\tUKN$\u0018)\u001e3ji6\u000bg.Y4fe\u0006!B/Z:u\u0003V$\u0017\u000e^'b]\u0006<WM]0%KF$2aTA\b\u0011!\u00196#!AA\u0002\u0005\u0015\u0011!\u0005;fgR\fU\u000fZ5u\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\tq\nK\u0002\u0016\u00033\u0001B!a\u0007\u0002*5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0002ba&TA!a\t\u0002&\u00059!.\u001e9ji\u0016\u0014(bAA\u0014}\u0005)!.\u001e8ji&!\u00111FA\u000f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aa#!\r\u0011\t\u0005m\u00111G\u0005\u0005\u0003k\tiBA\u0005BMR,'/R1dQ\u0006\u0011#)Y:jG\u0006+H-\u001b;NC:\fw-\u001a:J]N$\u0018M\u001c;jCRLwN\u001c+fgRD3aFA\u001e!\u0011\tY\"!\u0010\n\t\u0005}\u0012Q\u0004\u0002\u0005)\u0016\u001cH/A\u000eCCNL7-Q;eSRl\u0015M\\1hKJ,e/\u001a8ugR+7\u000f\u001e\u0015\u00041\u0005m\u0012!\f+fgR$UO]1cS2LG/_!vI&$(+Z:u_J,W*[:tS:<'+Z4jgR\u0014\u0018\r^5p]\"\u001a\u0011$a\u000f\u0002E\t\u000b7/[2F]\u0012\u0014TI\u001c3Bk\u0012LG/T1oC\u001e,'/\u0012<f]R\u001cH+Z:uQ\rQ\u00121H\u0001\u0015\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u0012<f]R$Vm\u001d;)\u0007m\tY$A\tPM\u001a\u001cX\r^\"iC:<W-\u0012<f]RD3\u0001HA\u001e\u0003]!Xm\u001d;BY2|w/\u001a3Fm\u0016tGo\u001d$jYR,'\u000fK\u0002\u001e\u0003w\tA\u0005^3ti\u0006+H-\u001b;K_\n,U.\u001b;t\u001b\u0016$(/[2t/&$\bNT8Fm\u0016tGo\u001d\u0015\u0004=\u0005m\u0012\u0001\u000b;fgR\u001c6\r[3ek2,\u0017)\u001e3ji*{'MU3ta\u0016\u001cGo]%oSRL\u0017\r\u001c#fY\u0006L\bfA\u0010\u0002<\u0005)C/Z:u'\u000eDW\rZ;mK\u0006+H-\u001b;K_\n\u0014Vm\u001d9fGR\u001cH)Y=PMf+\u0017M\u001d\u0015\u0004A\u0005m\u0012!\u000b;fgR\u001c6\r[3ek2,\u0017)\u001e3ji*{'MU3ta\u0016\u001cGo\u001d'bgR$\u0015-_(g3\u0016\f'\u000fK\u0002\"\u0003w\u0001")
public class AuditManagerTest {
    private final TopicPartition tp1 = new TopicPartition("t1", 1);
    private final TopicPartition tp2 = new TopicPartition("t1", 2);
    private Time time;
    private ReplicaManager replicaManager;
    private Option<TierObjectStore> tierObjStoreOpt = None$.MODULE$;
    private File tmpDir;
    private TestAuditManager testAuditManager;

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Option<TierObjectStore> tierObjStoreOpt() {
        return this.tierObjStoreOpt;
    }

    public void tierObjStoreOpt_$eq(Option<TierObjectStore> x$1) {
        this.tierObjStoreOpt = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public TestAuditManager testAuditManager() {
        return this.testAuditManager;
    }

    public void testAuditManager_$eq(TestAuditManager x$1) {
        this.testAuditManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.tierObjStoreOpt_$eq((Option<TierObjectStore>)new Some((Object)TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)TierObjectStoreConfig.createEmpty())));
        this.testAuditManager_$eq(new TestAuditManager());
    }

    @AfterEach
    public void tearDown() {
        this.testAuditManager().cleanUp();
        this.tierObjStoreOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerInstantiationTest() {
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, false));
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)1);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        this.testAuditManager().startAuditManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, false));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerEventsTest() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicAuditManagerEventsTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeletePartitionRequest(this.tp1(), 0));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertNotEquals((Object)this.testAuditManager().instance().db().fetchPartitionState(this.tp1()), (Object)None$.MODULE$, (String)"Deleted partition reported before fetch");
    }

    @Test
    public void TestDurabilityAuditRestoreMissingRegistration() {
        TestAuditManager testAuditManagerMock = new TestAuditManager(null){

            public int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
                return 1;
            }
        };
        Assertions.assertEquals((int)testAuditManagerMock.pendingRegistration().size(), (int)0);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManagerMock, this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        testAuditManagerMock.startAuditManager();
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicEnd2EndAuditManagerEventsTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().auditRequestsQueue().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$9(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        Assertions.assertEquals((int)1, (int)eventList.length());
        Assertions.assertEquals((Object)eventList.head(), (Object)EpochChangeEvent$.MODULE$.apply(this.tp1(), 111L, 1, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void HealthCheckEventTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        TopicPartition tp = new TopicPartition("durability-health-check", 0);
        this.time().sleep(5L);
        long produceTime = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 0, produceTime));
        this.time().sleep(20L);
        long produceTimeDelayed = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 1, produceTimeDelayed));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 2, produceTimeDelayed));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$HealthCheckEventTest$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$HealthCheckEventTest$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (!this.testAuditManager().queue().isEmpty()) {
            ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
            Assertions.assertNotNull(events);
            events.forEach(record -> eventList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDurabilityEvent[]{Deserializer$.MODULE$.deserialize((byte[])record.key(), (byte[])record.value())})));
        }
        Assertions.assertEquals((int)3, (int)eventList.length());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OffsetChangeEvent() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 10L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 1, 10L, 7L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, StartOffsetChangeRequest$.MODULE$.apply$default$7()));
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$4 = false;
        boolean x$5 = qual$2.doWorkActual$default$1();
        boolean x$6 = qual$2.doWorkActual$default$2();
        qual$2.doWorkActual(x$5, x$6, x$4);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 8L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        AuditManager qual$3 = this.testAuditManager().instance();
        boolean x$7 = true;
        boolean x$8 = qual$3.doWorkActual$default$1();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$8, x$7, x$9);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"event received at consumer should not have changed from 1");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 8L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        AuditManager qual$4 = this.testAuditManager().instance();
        boolean x$10 = true;
        boolean x$11 = qual$4.doWorkActual$default$1();
        boolean x$12 = qual$4.doWorkActual$default$3();
        qual$4.doWorkActual(x$11, x$10, x$12);
        Assertions.assertEquals((int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (int)0, (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 0, 8L, 4L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, StartOffsetChangeRequest$.MODULE$.apply$default$7()));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 11L, 4L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        AuditManager qual$5 = this.testAuditManager().instance();
        boolean x$13 = qual$5.doWorkActual$default$1();
        boolean x$14 = qual$5.doWorkActual$default$2();
        boolean x$15 = qual$5.doWorkActual$default$3();
        qual$5.doWorkActual(x$13, x$14, x$15);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 1");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)this.testAuditManager().queue().size(), (int)2, (String)"event not received at consumer");
        AuditManager qual$6 = this.testAuditManager().instance();
        boolean x$16 = true;
        boolean x$17 = qual$6.doWorkActual$default$1();
        boolean x$18 = qual$6.doWorkActual$default$3();
        qual$6.doWorkActual(x$17, x$16, x$18);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$OffsetChangeEvent$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$OffsetChangeEvent$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, false));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp2(), 1, 10L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        AuditManager qual$7 = this.testAuditManager().instance();
        boolean x$19 = true;
        boolean x$20 = qual$7.doWorkActual$default$1();
        boolean x$21 = qual$7.doWorkActual$default$3();
        qual$7.doWorkActual(x$20, x$19, x$21);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
    }

    @Test
    public void testAllowedEventsFilter() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Set x$3 = Predef$.MODULE$.Set().empty();
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Option<TopicPartition> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, (Set<Enumeration.Value>)x$3, x$7);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$8 = qual$1.doWorkActual$default$1();
        boolean x$9 = qual$1.doWorkActual$default$2();
        boolean x$10 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$8, x$9, x$10);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Assertions.assertEquals((Object)this.tp1(), (Object)this.testAuditManager().instance().db().getTopicPartitionsForAudit().head());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, HighWatermarkUpdateRequest$.MODULE$.apply$default$5(), HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 110L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)this.testAuditManager().instance().auditRequestsQueue().size());
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$11 = qual$2.doWorkActual$default$1();
        boolean x$12 = qual$2.doWorkActual$default$2();
        boolean x$13 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().queue().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuditJobEmitsMetricsWithNoEvents() {
        TopicIdPartition tpId1 = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        .colon.colon tieredOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(11L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(25L, 38L), (List)Nil$.MODULE$));
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(140L, 152L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(160L, 168L), (List)Nil$.MODULE$));
        AbstractLog tp1Log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId1, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)tieredOffsets, this.tierObjStoreOpt());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)tp1Log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Option<TierObjectStore> x$4 = this.tierObjStoreOpt();
        Set x$5 = Predef$.MODULE$.Set().empty();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Option<TopicPartition> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, replicaManager, x$4, x$6, (Set<Enumeration.Value>)x$5, x$7);
        Assertions.assertNotNull((Object)this.testAuditManager().instance());
        Metrics metrics = this.testAuditManager().instance().config().metrics();
        Assertions.assertEquals((int)2, (int)metrics.metrics().size());
        Assertions.assertEquals((long)0L, (long)this.testAuditManager().instance().metricsManager().totalLostMessages());
        MetricName name = DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)metrics.metric(name).metricValue());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        AuditManager qual$1 = this.testAuditManager().instance();
        boolean x$8 = qual$1.doWorkActual$default$1();
        boolean x$9 = qual$1.doWorkActual$default$2();
        boolean x$10 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$8, x$9, x$10);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        AuditManager qual$2 = this.testAuditManager().instance();
        boolean x$11 = true;
        boolean x$12 = qual$2.doWorkActual$default$2();
        boolean x$13 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$11, x$12, x$13);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)10, (int)metrics.metrics().size());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)11L), (Object)metrics.metric(DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics)).metricValue());
    }

    @Test
    public void testScheduleAuditJobRespectsInitialDelay() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsDayOfYear() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-01-30T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(30);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYear() {
        TestAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1());
        ReplicaManager x$4 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3();
        Option<TierObjectStore> x$5 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4();
        boolean x$6 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5();
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, x$5, x$6, x$7, (Option<TopicPartition>)x$3);
        AuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(366);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().pendingRegistration().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$2() {
        return "AuditManager didn't start within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$4() {
        return "AuditManager didn't flush within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$5(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 2;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().highWatermarkUpdateRequests().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$1(AuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$3(AuditManagerTest $this) {
        return $this.testAuditManager().instance().auditRequestsQueue().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$5(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().highWatermarkUpdateRequests().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$7(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$9(AuditManagerTest $this) {
        return $this.testAuditManager().queue().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$10() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$1(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$3(AuditManagerTest $this) {
        return 0 == $this.testAuditManager().instance().auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$5(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$1(AuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$2() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$3(AuditManagerTest $this) {
        return 2 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$4() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$5(AuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$6() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$testAuditJobEmitsMetricsWithNoEvents$1(AuditManagerTest $this) {
        return 0L == $this.testAuditManager().instance().auditJobCountdownLatch().getCount();
    }

    public static final /* synthetic */ String $anonfun$testAuditJobEmitsMetricsWithNoEvents$2() {
        return "AuditJob didn't complete within timeout";
    }
}

