/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import java.io.File;
import java.io.Serializable;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001F\u000b\u00019!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0003A\u0003B\u0002\u001b\u0001A\u0003%\u0011\u0006C\u00046\u0001\t\u0007I\u0011\u0001\u001c\t\r\u0015\u0003\u0001\u0015!\u00038\u0011\u001d1\u0005A1A\u0005\u0002\u001dCa\u0001\u0015\u0001!\u0002\u0013A\u0005bB)\u0001\u0005\u0004%\ta\u0012\u0005\u0007%\u0002\u0001\u000b\u0011\u0002%\t\u000fM\u0003!\u0019!C\u0001)\"1\u0001\f\u0001Q\u0001\nUCQ!\u0017\u0001\u0005\u0002iCQ!\u001b\u0001\u0005\u0002iCQA\u001c\u0001\u0005\u0002iCQ\u0001\u001d\u0001\u0005\u0002iCQA\u001d\u0001\u0005\u0002iCQ\u0001\u001e\u0001\u0005\u0002iCQA\u001e\u0001\u0005\u0002iCQ\u0001\u001f\u0001\u0005\u0002i\u0013\u0001\u0003R;sC\nLG.\u001b;z\t\n#Vm\u001d;\u000b\u0005Y9\u0012A\u00013c\u0015\tA\u0012$\u0001\u0006ekJ\f'-\u001b7jifT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003U\t!\u0001\u001e9\u0016\u0003%\u0002\"A\u000b\u001a\u000e\u0003-R!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\tQbF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a,\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003))\u0007o\\2i\u0007\"\f\u0017N\\\u000b\u0002oA!\u0001(P C\u001b\u0005I$B\u0001\u001e<\u0003\u001diW\u000f^1cY\u0016T!\u0001P\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002?s\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u0010A\u0013\t\tuDA\u0002J]R\u0004\"AH\"\n\u0005\u0011{\"\u0001\u0002'p]\u001e\f1\"\u001a9pG\"\u001c\u0005.Y5oA\u00051A/\u001c9ESJ,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000b!![8\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n!\u0001]:\u0016\u0003U\u0003\"A\n,\n\u0005]+\"A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003m\u0003\"A\b/\n\u0005u{\"\u0001B+oSRD#\u0001D0\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017aA1qS*\u0011A-Z\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1\u0007'A\u0003kk:LG/\u0003\u0002iC\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0015\tV\u0014\u0018MY5mSRLHIQ%oSR$Vm\u001d;)\u00055Y\u0007C\u00011m\u0013\ti\u0017M\u0001\u0003UKN$\u0018\u0001\f#ve\u0006\u0014\u0017\u000e\\5us\u0012\u00135+\u001a:jC2L'0\u0019;j_:$Um]3sS\u0006d\u0017N_1uS>tG+Z:uQ\tq1.A\u000fEkJ\f'-\u001b7jif$%)\u00138ji\u000eCWmY6Q_&tG/\u001b8hQ\ty1.A\fEkJ\f'-\u001b7jif$%)R7qif$%IR5mK\"\u0012\u0001c[\u0001$\tV\u0014\u0018MY5mSRLHIQ'vYRL\u0007\u000f\\3QCJ$\u0018\u000e^5p]V\u0003H-\u0019;fQ\t\t2.A\rB!&\u000b5mY3tg&s\u0017J\\5u'R\fG/^:UKN$\bF\u0001\nl\u0003=!U\r\\3uKB\u000b'\u000f^5uS>t\u0007FA\nl\u0001")
public class DurabilityDBTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain());

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void DurabilityDBInitTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        Assertions.assertTrue((boolean)db.header().equals((Object)new DbHeader(1, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))), (String)"Database failed to initialize");
        Assertions.assertEquals((int)db.topicStates().size(), (int)0, (String)"Database failed to initialize");
    }

    @Test
    public void DurabilityDBSerializationDeserializationTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        DurabilityDB newDB = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)newDB.header().equals((Object)db.header()), (String)"Check-pointing and recovery of db not consistent");
        Assertions.assertEquals((Object)newDB.fetchPartitionState(this.tp()).get(), (Object)this.ps(), (String)"PartitionState not preserved after recovery");
    }

    @Test
    public void DurabilityDBInitCheckPointing() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)db.header().equals((Object)newDb.header()), (String)"Inconsistent db after check pointing in empty state");
        Assertions.assertEquals((Object)newDb.topicStates(), (Object)db.topicStates(), (String)"Inconsistent db after check pointing in empty state");
    }

    @Test
    public void DurabilityDBEmptyDBFile() {
        DurabilityDB$.MODULE$.apply(this.logDir()).dbFile().createNewFile();
        Assertions.assertTrue((boolean)DurabilityDB$.MODULE$.apply(this.logDir()).header().equals((Object)new DbHeader(1, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))), (String)"Database not in empty state");
    }

    @Test
    public void DurabilityDBMultiplePartitionUpdate() {
        ObjectRef db = ObjectRef.create((Object)DurabilityDB$.MODULE$.apply(this.logDir()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4000).foreach((Function1 & Serializable & scala.Serializable)ii -> DurabilityDBTest.$anonfun$DurabilityDBMultiplePartitionUpdate$1(this, db, BoxesRunTime.unboxToInt((Object)ii)));
        ((DurabilityDB)db.elem).close();
        db.elem = DurabilityDB$.MODULE$.apply(this.logDir());
        Seq committed = ((DurabilityDB)db.elem).getDurabilityTopicPartitionOffsets();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ii -> {
            TopicPartition id = new TopicPartition(this.tp().topic(), ii);
            Assertions.assertEquals((long)((PartitionState)((DurabilityDB)db$1.elem).fetchPartitionState(id).get()).startOffset(), (long)ii, (String)new StringBuilder(45).append("Failed to get last valid state for partition ").append(ii).toString());
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)committed.apply(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT())), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()), (String)new StringBuilder(54).append("Failed to fetch latest committed offset for partition ").append(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()).toString());
        });
    }

    @Test
    public void APIAccessInInitStatusTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.status_$eq(DbStatus$.MODULE$.Init());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> db.addPartition(this.tp(), this.ps()), ClassTag$.MODULE$.apply(DurabilityDBNotReadyException.class), new Position("DurabilityDBTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    @Test
    public void DeletePartition() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        TopicPartition id = new TopicPartition(this.tp().topic(), 2);
        PartitionState ps2 = PartitionState$.MODULE$.apply(2, 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain());
        db.addPartition(id, ps2);
        Assertions.assertTrue((boolean)((PartitionState)db.fetchPartitionState(this.tp()).get()).equals((Object)this.ps()), (String)"Fetch for partition failed");
        db.deletePartition(this.tp());
        Assertions.assertEquals((Object)db.fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
        db.close();
        Assertions.assertEquals((Object)DurabilityDB$.MODULE$.apply(this.logDir()).fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
    }

    public static final /* synthetic */ Option $anonfun$DurabilityDBMultiplePartitionUpdate$1(DurabilityDBTest $this, ObjectRef db$1, int ii) {
        TopicPartition id = new TopicPartition($this.tp().topic(), ii);
        PartitionState ps = PartitionState$.MODULE$.apply(id.partition(), (long)ii, 100L, 0L, 2L, 100L, 3600L, 1024L, $this.epochChain());
        ((DurabilityDB)db$1.elem).updateDurabilityTopicPartitionOffset(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()));
        return ((DurabilityDB)db$1.elem).addPartition(id, ps);
    }
}

