/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import java.io.Serializable;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.exceptions.DurabilityMetadataDeserializationException;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0005\n\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003BB\u0019\u0001A\u0003%a\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\t\r]\u0002\u0001\u0015!\u00035\u0011\u001dA\u0004A1A\u0005\u0002MBa!\u000f\u0001!\u0002\u0013!\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"\u0002&\u0001\t\u0003Y\u0004\"\u0002'\u0001\t\u0003Y\u0004\"\u0002(\u0001\t\u0003Y\u0004\"\u0002)\u0001\t\u0003Y\u0004\"\u0002*\u0001\t\u0003Y\u0004\"\u0002+\u0001\t\u0003Y\u0004\"\u0002,\u0001\t\u0003Y\u0004\"\u0002-\u0001\t\u0003Y$aG!cgR\u0014\u0018m\u0019;EkJ\f'-\u001b7jif,e/\u001a8u)\u0016\u001cHO\u0003\u0002\u0014)\u00051QM^3oiNT!!\u0006\f\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!#\u0001\u0003ua&$W#\u0001\u0014\u0011\u0005\u001dzS\"\u0001\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0018W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001\u0004F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u000bQ\u0004\u0018\u000e\u001a\u0011\u0002\u000b\u0015\u0004xn\u00195\u0016\u0003Q\u0002\"aG\u001b\n\u0005Yb\"aA%oi\u00061Q\r]8dQ\u0002\nqA^3sg&|g.\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0003EzeMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e^*fe&\fG.\u001b>bi&|g\u000eR3tKJL\u0017\r\\5{CRLwN\u001c+fgR$\u0012\u0001\u0010\t\u00037uJ!A\u0010\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011\u0001\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002F\r\u00069!.\u001e9ji\u0016\u0014(BA$.\u0003\u0015QWO\\5u\u0013\tI%I\u0001\u0003UKN$\u0018\u0001O(gMN,Go\u00115b]\u001e,WI^3oi^KG\u000f[%T%N+'/[1mSj\fG/[8o\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003\u0013\u0001\u000b1&\u00129pG\"\u001c\u0005.\u00198hKN+'/[1mSj\fG/[8o\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003\u0015\u0001\u000bQ\u0006R3mKR,'+Z2pe\u0012\u001c8+\u001a:jC2L'0\u0019;j_:$Um]3sS\u0006d\u0017N_1uS>tG+Z:uQ\tY\u0001)A\u0018SKR,g\u000e^5p]\u000eC\u0017M\\4f'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8EKN,'/[1mSj\fG/[8o)\u0016\u001cH\u000f\u000b\u0002\r\u0001\u0006I\u0013j\u0015*FqB\fg\u000eZ*fe&\fG.\u001b>bi&|g\u000eR3tKJL\u0017\r\\5{CRLwN\u001c+fgRD#!\u0004!\u0002cM#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<WmU3sS\u0006d\u0017N_1uS>tG)Z:fe&\fG.\u001b>bi&|g\u000eV3ti\"\u0012a\u0002Q\u00010\t\u0016dW\r^3QCJ$\u0018\u000e^5p]N+'/[1mSj\fG/[8o\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003\u001f\u0001\u000ba$\u0012=dKB$\u0018n\u001c8J]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005A\u0001\u0005")
public class AbstractDurabilityEventTest {
    private final TopicPartition tpid = new TopicPartition("test", 0);
    private final int epoch;
    private final int version;

    public TopicPartition tpid() {
        return this.tpid;
    }

    public int epoch() {
        return this.epoch;
    }

    public int version() {
        return this.version;
    }

    @Test
    public void OffsetChangeEventSerializationDeserializationTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize OffsetChangeEvent");
    }

    @Test
    public void OffsetChangeEventWithISRSerializationDeserializationTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})));
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize OffsetChangeEvent");
    }

    @Test
    public void EpochChangeSerializationDeserializationTest() {
        EpochChangeEvent obj = EpochChangeEvent$.MODULE$.apply(this.tpid(), 50L, this.epoch(), 100L, 0L, EpochChangeEvent$.MODULE$.apply$default$6());
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize EpochChangeEvent");
    }

    @Test
    public void DeleteRecordsSerializationDeserializationTest() {
        DeleteRecordsEvent obj = DeleteRecordsEvent$.MODULE$.apply(this.tpid(), 100L, this.epoch(), 100L, 0L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize DeleteRecordsEvent");
    }

    @Test
    public void RetentionChangeSerializationDeserializationTest() {
        RetentionChangeEvent obj = RetentionChangeEvent$.MODULE$.apply(this.tpid(), 50L, 1000L, this.version(), this.epoch(), 100L, 0L);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize RetentionChangeEvent");
    }

    @Test
    public void ISRExpandSerializationDeserializationTest() {
        IsrExpandEvent obj = IsrExpandEvent$.MODULE$.apply(this.tpid(), 5, this.epoch(), 100L, 0L);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize ISRExpandEvent");
    }

    @Test
    public void StartOffsetChangeSerializationDeserializationTest() {
        StartOffsetChangeEvent obj = StartOffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 21L, (byte)RetentionType$.MODULE$.SizeBasedRetention().id(), 0L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize StartOffsetChangeEvent");
    }

    @Test
    public void DeletePartitionSerializationDeserializationTest() {
        DeletePartitionEvent obj = DeletePartitionEvent$.MODULE$.apply(this.tpid(), this.epoch());
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        AbstractDurabilityEvent deserialize = Deserializer$.MODULE$.deserialize(keyBB, bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize DeletePartitionEvent");
    }

    @Test
    public void ExceptionInDeserializationTest() {
        byte[] garbage = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4}), ClassTag$.MODULE$.Byte());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> Deserializer$.MODULE$.deserialize(garbage, garbage), ClassTag$.MODULE$.apply(DurabilityMetadataDeserializationException.class), new Position("AbstractDurabilityEventTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public AbstractDurabilityEventTest() {
        this.epoch = 0;
        this.version = 1;
    }
}

