/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.materialization.Validator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u0014(\u00019BQ!\u000e\u0001\u0005\u0002YB\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003<\u0011%y\u0005\u00011AA\u0002\u0013%\u0001\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00051\"I!\f\u0001a\u0001\u0002\u0003\u0006K!\u0015\u0005\n7\u0002\u0001\r\u00111A\u0005\nqC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00022\t\u0013\u0011\u0004\u0001\u0019!A!B\u0013i\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005q\u0001\u0001\u0007\t\u0011)Q\u0005O\"I\u0011\u000f\u0001a\u0001\u0002\u0004%IA\u001d\u0005\nq\u0002\u0001\r\u00111A\u0005\neD\u0011b\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B:\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\bbCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA!\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003\u007f\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005%\u0002\u00011AA\u0002\u0013%\u00111\u0006\u0005\f\u0003_\u0001\u0001\u0019!A!B\u0013\tI\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024!A\u0011Q\b\u0001!\u0002\u0013\t)\u0004C\u0005\u0002@\u0001\u0011\r\u0011\"\u0003\u0002B!A\u0011q\f\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002p!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005=\u0004bBAN\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003?\u0003A\u0011AA8\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003_Bq!a*\u0001\t\u0003\ty\u0007C\u0004\u0002,\u0002!\t!a\u001c\t\u000f\u0005=\u0006\u0001\"\u0001\u0002p\tyB)\u001e:bE&d\u0017\u000e^=Fm\u0016tGo]'bi\u0016\u0014\u0018.\u00197ju\u0016$Vm\u001d;\u000b\u0005!J\u0013aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005)Z\u0013A\u00033ve\u0006\u0014\u0017\u000e\\5us*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002O\u00059Q.\u001a;sS\u000e\u001cX#A\u001e\u0011\u0005q*U\"A\u001f\u000b\u0005er$BA A\u0003\u0019\u0019w.\\7p]*\u0011A&\u0011\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G{\t9Q*\u001a;sS\u000e\u001c\u0018aC7fiJL7m]0%KF$\"!\u0013'\u0011\u0005AR\u0015BA&2\u0005\u0011)f.\u001b;\t\u000f5\u001b\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\u00115,GO]5dg\u0002\n\u0001B]3q_J$XM]\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A+K\u0001\u0006CV$\u0017\u000e^\u0005\u0003-N\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018\u0001\u0004:fa>\u0014H/\u001a:`I\u0015\fHCA%Z\u0011\u001die!!AA\u0002E\u000b\u0011B]3q_J$XM\u001d\u0011\u0002\u00115l\u0015M\\1hKJ,\u0012!\u0018\t\u0003=~k\u0011!K\u0005\u0003A&\u0012\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u00031iW*\u00198bO\u0016\u0014x\fJ3r)\tI5\rC\u0004N\u0013\u0005\u0005\t\u0019A/\u0002\u00135l\u0015M\\1hKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003Uz\nQ!\u001e;jYNL!\u0001\\5\u0003\tQKW.Z\u0001\ti&lWm\u0018\u0013fcR\u0011\u0011j\u001c\u0005\b\u001b2\t\t\u00111\u0001h\u0003\u0015!\u0018.\\3!\u0003\t!'-F\u0001t!\t!h/D\u0001v\u0015\t\t\u0018&\u0003\u0002xk\naA)\u001e:bE&d\u0017\u000e^=E\u0005\u00061AMY0%KF$\"!\u0013>\t\u000f5{\u0011\u0011!a\u0001g\u0006\u0019AM\u0019\u0011\u0002\rQl\u0007\u000fR5s+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0002j_*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\rI\u0015\u0011\u0003\u0005\b\u001bJ\t\t\u00111\u0001\u007f\u0003\u001d!X\u000e\u001d#je\u0002\nA\u0002^5fe>\u0013'n\u0015;pe\u0016,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005)1\u000f^8sK*\u0019\u00111E\u0016\u0002\tQLWM]\u0005\u0005\u0003O\tiBA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003A!\u0018.\u001a:PE*\u001cFo\u001c:f?\u0012*\u0017\u000fF\u0002J\u0003[A\u0001\"T\u000b\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u000ei&,'o\u00142k'R|'/\u001a\u0011\u0002\u0007Q\u0004\u0018'\u0006\u0002\u00026A!\u0011qGA\u001d\u001b\u0005q\u0014bAA\u001e}\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qc\u0001\n!\"\u001a9pG\"\u001c\u0005.Y5o+\t\t\u0019\u0005\u0005\u0005\u0002F\u0005=\u00131KA-\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001b\n\u0014AC2pY2,7\r^5p]&!\u0011\u0011KA$\u0005\u001dA\u0015m\u001d5NCB\u00042\u0001MA+\u0013\r\t9&\r\u0002\u0004\u0013:$\bc\u0001\u0019\u0002\\%\u0019\u0011QL\u0019\u0003\t1{gnZ\u0001\fKB|7\r[\"iC&t\u0007%\u0001\u0002qgV\u0011\u0011Q\r\t\u0004i\u0006\u001d\u0014bAA5k\nq\u0001+\u0019:uSRLwN\\*uCR,\u0017a\u00019tA\u0005)1/\u001a;VaR\t\u0011\nK\u0002\u001e\u0003g\u0002B!!\u001e\u0002\u00046\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0002ba&TA!! \u0002\u0000\u00059!.\u001e9ji\u0016\u0014(bAAA\u0007\u0006)!.\u001e8ji&!\u0011QQA<\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aa$a#\u0011\t\u0005U\u0014QR\u0005\u0005\u0003\u001f\u000b9HA\u0005BMR,'/R1dQ\u0006yB/Z:u'6\fG\u000e\\3s\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:)\u0007}\t)\n\u0005\u0003\u0002v\u0005]\u0015\u0002BAM\u0003o\u0012A\u0001V3ti\u0006qB/Z:u\u0019\u0006\u0014x-\u001a:IS\u001eDw+\u0019;fe6\f'o[\"iC:<Wm\u001d\u0015\u0004A\u0005U\u0015a\u0005;fgR$U\r\\3uKB\u000b'\u000f^5uS>t\u0007fA\u0011\u0002\u0016\u0006AB/Z:u\u000bB|7\r[\"iC&tg+\u00197jI\u0006$\u0018n\u001c8)\u0007\t\n)*\u0001\u0011uKN$H+[7f\u0005\u0006\u001cX\r\u001a*fi\u0016tG/[8o-\u0006d\u0017\u000eZ1uS>t\u0007fA\u0012\u0002\u0016\u0006aD/Z:u)&lWMQ1tK\u0012\u0014V\r^3oi&|gNV1mS\u0012\fG/[8o/&$\bNT8EK2,G/\u001a3TK\u001elWM\u001c;NKR\fG-\u0019;bQ\r!\u0013QS\u00011i\u0016\u001cH\u000fV5nK\n\u000b7/\u001a3SKR,g\u000e^5p]Z\u000bG.\u001b3bi&|gnV5uQV\u001bXM\u001d#fY\u0016$\u0018n\u001c8)\u0007\u0015\n)\n")
public class DurabilityEventsMaterializeTest {
    private Metrics metrics;
    private AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    private DurabilityMetricsManager mManager;
    private Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    private DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    private File tmpDir;
    private TierObjectStore tierObjStore;
    private final TopicPartition tp1 = new TopicPartition("t1", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))}));
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp1().partition(), 0L, 40L, 0L, 0L, 0L, 36000000L, 1024L, this.epochChain());

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    public Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq(Time x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time = x$1;
    }

    public DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DurabilityDB x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db = x$1;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    private TierObjectStore tierObjStore() {
        return this.tierObjStore;
    }

    private void tierObjStore_$eq(TierObjectStore x$1) {
        this.tierObjStore = x$1;
    }

    private TopicPartition tp1() {
        return this.tp1;
    }

    private HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    private PartitionState ps() {
        return this.ps;
    }

    @BeforeEach
    public void setUp() {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time()));
        this.mManager_$eq(new DurabilityMetricsManager("0", this.metrics(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter$.MODULE$.apply(this.mManager()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.tierObjStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)TierObjectStoreConfig.createEmpty()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db());
        Utils.delete((File)this.tmpDir());
        this.tierObjStore().close();
    }

    @Test
    public void testSmallerHighWatermarkChanges() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$1;
            }
        };
        materialize.materializeHighWatermarkChanges(this.tp1(), 2, 30L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)10L, (long)lapse);
        Assertions.assertEquals((long)10L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testLargerHighWatermarkChanges() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        TopicIdPartition tpId = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$2;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(this.tp1(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletePartition() {
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$3(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7());
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1()), (Object)None$.MODULE$, (String)"Register partition failed");
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(replicaManager, testAuditManager.instance().db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        DeletePartitionEvent evt = DeletePartitionEvent$.MODULE$.apply(this.tp1(), 3);
        materialize.materializeDeletePartition(evt);
        Assertions.assertEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
    }

    @Test
    public void testEpochChainValidation() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        TopicIdPartition tpId = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)log)}))));
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)props);
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(config, logManager);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(replicaManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        IsrExpandEvent evt = IsrExpandEvent$.MODULE$.apply(this.tp1(), 1, 3, this.ps().highWatermark(), this.ps().committedStartOffset());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException();
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = Nil$.MODULE$;
                this.file = TestUtils$.MODULE$.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp1(), checkpoint);
        cache.assign(0, 0L);
        cache.assign(1, 11L);
        cache.assign(2, 21L);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)Option$.MODULE$.apply((Object)cache));
        materialize.materializeISRExpandEvent(evt, this.ps());
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        cache.assign(2, 15L);
        materialize.materializeISRExpandEvent(evt, this.ps());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testTimeBasedRetentionValidation() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        TopicIdPartition tpId = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$3;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierObjectStore.OpaqueData.ZEROED, 1L)));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)5L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 20L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Tuple2 tuple22 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapse2 = tuple22._2$mcJ$sp();
        Assertions.assertEquals((long)15L, (long)lapse2);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)20L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 21L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Tuple2 tuple23 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long lapse3 = tuple23._2$mcJ$sp();
        Assertions.assertEquals((long)16L, (long)lapse3);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)21L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 25L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        RetentionChangeEvent evt2 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, this.ps().latestEpoch(), -1L, -1L);
        materialize.materializeRetentionChangeEvent(evt2, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 30L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithNoDeletedSegmentMetadata() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        TopicIdPartition tpId = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$4;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 221L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)221L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithUserDeletion() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        TopicIdPartition tpId = new TopicIdPartition(this.tp1().topic(), UUID.randomUUID(), this.tp1().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7());
        DurabilityDB db = (DurabilityDB)Mockito.mock(DurabilityDB.class);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, db, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$5;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierObjectStore.OpaqueData.ZEROED, 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.ps().highWatermark()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        DeleteRecordsEvent delEvent = DeleteRecordsEvent$.MODULE$.apply(this.tp1(), 5L, this.ps().latestEpoch(), this.ps().highWatermark(), 0L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        materialize.materializeDeleteRecordEvent(delEvent, this.ps());
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1());
        if (tuple2 != null) {
            long lapse = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)0L, (long)lapse);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartition$1(TestAuditManager testAuditManager$1) {
        return testAuditManager$1.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeletePartition$2() {
        return "";
    }
}

