/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.topic.DurabilityTopicManager;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0004\b\u0001+!)A\u0004\u0001C\u0001;!9q\u0002\u0001b\u0001\n\u0003\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011%\u0001\u0004\u00011AA\u0002\u0013\u0005\u0011\u0007C\u00058\u0001\u0001\u0007\t\u0019!C\u0001q!Ia\b\u0001a\u0001\u0002\u0003\u0006KA\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u001d\u0002!\t\u0001\u0011\u0005\u0006'\u0002!\t\u0001\u0011\u0005\u00061\u0002!\t\u0001\u0011\u0002\u001b\tV\u0014\u0018MY5mSRLHk\u001c9jG6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u001fA\tQ\u0001^8qS\u000eT!!\u0005\n\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\ta\"F\u0001\"!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]V\tA\u0006\u0005\u0002\u0018[%\u0011a\u0006\u0007\u0002\u0004\u0013:$\u0018A\u00039beRLG/[8oA\u0005\u0011AMY\u000b\u0002eA\u00111'N\u0007\u0002i)\u0011\u0001\u0007E\u0005\u0003mQ\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001\u001a2`I\u0015\fHCA\u001d=!\t9\"(\u0003\u0002<1\t!QK\\5u\u0011\u001dit!!AA\u0002I\n1\u0001\u001f\u00132\u0003\r!'\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u0012\u0011B\u0011\t\u0003\u00072k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1!\u00199j\u0015\t9\u0005*A\u0004kkBLG/\u001a:\u000b\u0005%S\u0015!\u00026v]&$(\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#A\u0003)\u0011\u0005\r\u000b\u0016B\u0001*E\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0010CCNL7\rR;sC\nLG.\u001b;z)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRD#aC+\u0011\u0005\r3\u0016BA,E\u0005\u0011!Vm\u001d;\u0002AQ{\u0007/[2NC:\fw-\u001a:Qe>$WoY3s\u0007>t7/^7feR+7\u000f\u001e\u0015\u0003\u0019U\u0003")
public class DurabilityTopicManagerTest {
    private final String topic;
    private final int partition;
    private DurabilityDB db;

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.db());
    }

    @Test
    public void BasicDurabilityTopicManagerTest() {
        DurabilityTopicManager manager = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager(this.db(), DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2(), DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$3());
        Assertions.assertFalse((boolean)manager.isReady());
        manager.start();
        Assertions.assertTrue((boolean)manager.consumerProvider().isReady());
        Assertions.assertTrue((boolean)manager.isReady());
        manager.shutdown();
        Assertions.assertTrue((boolean)manager.isShutdown());
        Assertions.assertFalse((boolean)manager.consumerProvider().isReady());
    }

    @Test
    public void TopicManagerProducerConsumerTest() {
        TopicPartition tpid = new TopicPartition("test", 50);
        int epoch = 0;
        ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(32);
        DurabilityDB x$1 = this.db();
        Some x$2 = new Some(resultQueue);
        BlockingQueue<ConsumerRecords<byte[], byte[]>> x$3 = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
        DurabilityTopicManager manager = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager(x$1, x$3, (Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>>)x$2);
        manager.database().addPartition(tpid, PartitionState$.MODULE$.apply(tpid.partition()));
        manager.start();
        manager.addDurabilityEvent((AbstractDurabilityEvent)OffsetChangeEvent$.MODULE$.apply(tpid, epoch, 100L, 0L));
        Assertions.assertEquals((int)resultQueue.size(), (int)1);
        manager.shutdown();
    }

    public DurabilityTopicManagerTest() {
        this.topic = "test-topic";
        this.partition = 50;
    }
}

