/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.controller.ReplicaAssignment$;
import kafka.durability.audit.AuditManager;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.RetentionConfigChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.RetentionType$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.materialization.Validator;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogManager;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.network.Processor;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.scalactic.Fail;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0001\r\u0011\"\u0001L\u0011\u001d!\u0006\u00011A\u0005\u0002UCaa\u0017\u0001!B\u0013a\u0005b\u0002/\u0001\u0001\u0004%\t!\u0018\u0005\bU\u0002\u0001\r\u0011\"\u0001l\u0011\u0019i\u0007\u0001)Q\u0005=\"9a\u000e\u0001a\u0001\n\u0003y\u0007b\u0002;\u0001\u0001\u0004%\t!\u001e\u0005\u0007o\u0002\u0001\u000b\u0015\u00029\t\u000fa\u0004!\u0019!C\u0001s\"1Q\u0010\u0001Q\u0001\niDqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0001\u0011%\ti\u0001\u0001b\u0001\n\u0003\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011!\ty\u0002\u0001b\u0001\n\u0003\u0011\u0005bBA\u0011\u0001\u0001\u0006Ia\u0011\u0005\n\u0003G\u0001!\u0019!C\u0001\u0003KA\u0001\"a\u000f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003KA\u0001\"a\u0013\u0001A\u0003%\u0011q\u0005\u0005\n\u0003\u001b\u0002!\u0019!C\u0001\u0003KA\u0001\"a\u0014\u0001A\u0003%\u0011q\u0005\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\tY\u0007\u0001C!\u0003'Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002|\u0001!I!! \t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\tI\r\u0001C\u0001\u0003'Bq!a5\u0001\t\u0003\t\u0019\u0006C\u0004\u0002f\u0002!\t!a\u0015\t\u000f\u0005-\b\u0001\"\u0001\u0002T!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\u0003bBA{\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003s\u0004A\u0011AA*\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003'BqA!\u0003\u0001\t\u0003\t\u0019\u0006C\u0004\u0003\u000e\u0001!\t!a\u0015\t\u000f\tE\u0001\u0001\"\u0001\u0002T\t\u0019B)\u001e:bE&d\u0017\u000e^=Bk\u0012LG\u000fV3ti*\u0011!gM\u0001\fS:$Xm\u001a:bi&|gNC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\u001a\u0014A\u0001>l\u0013\ta\u0014H\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"\u0001\u0011\u0001\u000e\u0003E\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ\u0019\u0016\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u00131!\u00138u\u0003)\u0011'o\\6fe&#\u0017\u0007I\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005kRLGNC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Ms%A\u0003)s_B,'\u000f^5fg\u0006\u00012m\u001c8gS\u001e\u0004&o\u001c9tc}#S-\u001d\u000b\u0003-f\u0003\"\u0001R,\n\u0005a+%\u0001B+oSRDqAW\u0003\u0002\u0002\u0003\u0007A*A\u0002yIE\nQbY8oM&<\u0007K]8qgF\u0002\u0013aB2p]\u001aLwm]\u000b\u0002=B\u0019qL\u00193\u000e\u0003\u0001T!!Y#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002dA\n\u00191+Z9\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\u001c\u0014AB:feZ,'/\u0003\u0002jM\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005Yc\u0007b\u0002.\t\u0003\u0003\u0005\rAX\u0001\tG>tg-[4tA\u000591/\u001a:wKJ\u001cX#\u00019\u0011\u0007}\u0013\u0017\u000f\u0005\u0002fe&\u00111O\u001a\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHC\u0001,w\u0011\u001dQ6\"!AA\u0002A\f\u0001b]3sm\u0016\u00148\u000fI\u0001\u0019K:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tW#\u0001>\u0011\u0005\u0011[\u0018B\u0001?F\u0005\u001d\u0011un\u001c7fC:\f\u0011$\u001a8bE2,7i\u001c8ue>dG.\u001a3TQV$Hm\\<oA\u00051!/\u00198e_6,\"!!\u0001\u0011\t\u0005\r\u0011qA\u0007\u0003\u0003\u000bQ!aT#\n\t\u0005%\u0011Q\u0001\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005)Ao\u001c9jGV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003)\u0002\t1\fgnZ\u0005\u0005\u00037\t)B\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4feV\u0011\u0011q\u0005\t\u0005\u0003S\t9$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0015awn\u001a\u001bk\u0015\u0011\t\t$a\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)$A\u0002pe\u001eLA!!\u000f\u0002,\t1Aj\\4hKJ\fqC\\3uo>\u00148\u000e\u0015:pG\u0016\u001c8o\u001c:M_\u001e<WM\u001d\u0011\u0002'9;\u0006K]8dKN\u001cxN\u001d'pO2+g/\u001a7\u0016\u0005\u0005\u0005\u0003\u0003BA\u0015\u0003\u0007JA!!\u0012\u0002,\t)A*\u001a<fY\u0006!bj\u0016)s_\u000e,7o]8s\u0019><G*\u001a<fY\u0002\nq\"\\1uKJL\u0017\r\\5{CRLwN\\\u0001\u0011[\u0006$XM]5bY&T\u0018\r^5p]\u0002\n\u0011B^1mS\u0012\fGo\u001c:\u0002\u0015Y\fG.\u001b3bi>\u0014\b%A\u0003tKR,\u0006\u000fF\u0001WQ\ri\u0012q\u000b\t\u0005\u00033\n9'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\r\t\u0007/\u001b\u0006\u0005\u0003C\n\u0019'A\u0004kkBLG/\u001a:\u000b\t\u0005\u0015\u00141G\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003S\nYF\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004=\u0005=\u0004\u0003BA-\u0003cJA!a\u001d\u0002\\\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001.o\u0006LG/\u00168uS2\fE\u000e\u001c)f]\u0012Lgn\u001a#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u0003J,g\t\\;tQ\u0016$Gc\u0001,\u0002z!)an\ba\u0001a\u0006a1\u000f^1si\n\u0013xn[3sgR\u0019a+a \t\u000f\u0005\u0005\u0005\u00051\u0001\u0002\u0004\u000691\r\\;ti\u0016\u0014\bcA0c\u0019\u0006q1\u000f[;uI><hnU3sm\u0016\u0014Hc\u0001,\u0002\n\")q-\ta\u0001c\u0006\u00112m\u001c8tk6,\u0017\t\u001c7NKN\u001c\u0018mZ3t)\u0019\ty)!*\u0002(B!qLYAI!\u0011\t\u0019*!)\u000f\t\u0005U\u0015Q\u0014\t\u0004\u0003/+UBAAM\u0015\r\tY*N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}U)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\t\u0019KC\u0002\u0002 \u0016Cq!!\u0004#\u0001\u0004\t\t\n\u0003\u0004\u0002*\n\u0002\raQ\u0001\f]VlW*Z:tC\u001e,7/A\u0007d_:4\u0017nZ;sK6{7m\u001b\u000b\u0004-\u0006=\u0006BBAYG\u0001\u0007A*\u0001\u0007tKJ4XM]\"p]\u001aLw-\u0001\bqe\u0016\u0004\u0018M]3US\u0016\u0014Hj\\4\u0015\u0005\u0005]\u0006c\u0002#\u0002:\u0006u6)]\u0005\u0004\u0003w+%A\u0002+va2,7\u0007\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019mM\u0001\u0004Y><\u0017\u0002BAd\u0003\u0003\u00141\"\u00112tiJ\f7\r\u001e'pO\u0006yB/Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiR{\u0007/[2D_:4\u0017nZ:)\u0007\u0015\ni\r\u0005\u0003\u0002Z\u0005=\u0017\u0002BAi\u00037\u0012A\u0001V3ti\u0006!E/Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u000e\u000bGo\u00195j]\u001eD\u0015n\u001a5XCR,'/T1sW2\u000b\u0007o]3J]Vs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u001aa%!4)\u000f\u0019\nI.a8\u0002bB!\u0011\u0011LAn\u0013\u0011\ti.a\u0017\u0003\u0011\u0011K7/\u00192mK\u0012\fQA^1mk\u0016\f#!a9\u0002\u0003RKG\u000e\u001c\u0011xK\u00022\u0017N\u001c3!o\"L\b\u0005\\1ti\u0002\u001aH/Y4fA5\fG/\u001a:jC2L'0\u0019;j_:\u0004\u0013n\u001d\u0011t_\u0002\u001aHn\\<!S:\u0004#.\u001a8lS:\u001c\u0018a\u000b;fgR$UO]1cS2LG/_!vI&$8)\u0019;dQ&twm\u0015;beR|eMZ:fi2\u000b\u0007o]3)\u0007\u001d\ni\rK\u0004(\u00033\fy.!9\u0002MQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;IC:$G.Z:EK2,G/\u001a*fG>\u0014H\rK\u0002)\u0003\u001bDs\u0001KAm\u0003?\f\t/\u0001\u0017uKN$8+[7qY\u0016$UO]1cS2LG/_!vI&$\b*\u00198eY\u0016\u001cH)\u001a7fi\u0016\u0014VmY8sI\"\u001a\u0011&!4\u0002UQ,7\u000f^*j[BdW\rR;sC\nLG.\u001b;z\u0003V$\u0017\u000e\u001e+jKJ$U\r\\3uS>tG*\u00199tK\"\u001a!&!4\u0002YQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;US\u0016\u0014H)\u001a7fi&|g\u000eR;f)>\u001c&P\u0011:fC\u000eD\u0007fA\u0016\u0002N\":1&!7\u0002`\u0006}\u0018E\u0001B\u0001\u0003U[E)\u0011+B[YB\u0004\u0005V3na>\u0014\u0018M]5ms\u0002\"\u0017n]1cY&tw\r\t;fgR\u0004C/\u001b7mA],\u0007%[7qe>4X\rI8oAM,w-\\3oi\u0002\u001a\u0018N_3!G>tg-[4!E\u0016Lgn\u001a\u0011vg\u0016$\u0017a\n;fgR\u0014V\r^3oi&|gn\u00115b]\u001e,WI^3oi\u0012+(/\u00192jY&$\u00180Q;eSRD3\u0001LAgQ\u001da\u0013\u0011\\Ap\u0003\u007f\f\u0001\u0007^3ti\u0012+(/\u00192jY&$\u00180Q;eSRD\u0015n\u001a5XCR,'/T1sW\u0016\u0003xn\u00195DQ\u0006tw-Z#wK:$\bfA\u0017\u0002N\u00069C/Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:,e/\u001a8uQ\rq\u0013QZ\u0001(i\u0016\u001cH\u000fR;sC\nLG.\u001b;z'R\f'\u000f^(gMN,G\u000fT1qg\u0016$v\u000e\\3sC:\u001cW\rK\u00020\u0003\u001b\u0004")
public class DurabilityAuditTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private Properties configProps1 = null;
    private Seq<KafkaConfig> configs = Nil$.MODULE$;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final boolean enableControlledShutdown;
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);
    private final Level NWProcessorLogLevel = this.networkProcessorLogger().getLevel();
    private final Logger materialization = Logger.getLogger(DurabilityEventsMaterialize.class);
    private final Logger validator = Logger.getLogger(Validator.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Level NWProcessorLogLevel() {
        return this.NWProcessorLogLevel;
    }

    public Logger materialization() {
        return this.materialization;
    }

    public Logger validator() {
        return this.validator;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps1().put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown()));
        this.configProps1().put("controlled.shutdown.max.retries", "1");
        this.configProps1().put("controlled.shutdown.retry.backoff.ms", "1000");
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps1().put("confluent.durability.audit.enable", Boolean.toString(true));
        this.configProps1().put("confluent.durability.topic.replication.factor", "1");
        this.configProps1().put("confluent.durability.topic.partition.count", "1");
        this.configProps1().put("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.configProps1().put("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,StartOffsetChangeType,DeleteRecordsType");
        this.networkProcessorLogger().setLevel(Level.FATAL);
        this.materialization().setLevel(Level.ERROR);
        this.validator().setLevel(Level.ERROR);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.networkProcessorLogger().setLevel(this.NWProcessorLogLevel());
        super.tearDown();
    }

    private void waitUntilAllPendingDurabilityEventsAreFlushed(Seq<KafkaServer> servers) {
        servers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            DurabilityAuditTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(server);
            return BoxedUnit.UNIT;
        });
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            DurabilityAuditTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$3 = false;
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private void configureMock(Properties serverConfig) {
        serverConfig.put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        serverConfig.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        serverConfig.put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        serverConfig.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        serverConfig.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        serverConfig.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        serverConfig.put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        serverConfig.put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        serverConfig.put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
    }

    /*
     * WARNING - void declaration
     */
    private Tuple3<AbstractLog, Object, KafkaServer> prepareTierLog() {
        this.configProps1().put("confluent.tier.enable", "true");
        this.configProps1().put("confluent.tier.local.hotset.bytes", "1");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "1");
        this.configureMock(this.configProps1());
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$22 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})), (Seq)Nil$.MODULE$))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$22, x$3, x$4, x$5, x$6, x$7);
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$prepareTierLog$1(this, x$2))).get();
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$prepareTierLog$2(this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$prepareTierLog$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$3 = server.replicaManager().logManager();
        TopicPartition x$10 = new TopicPartition(this.topic(), this.partitionId());
        boolean x$11 = qual$3.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$3.getLog(x$10, x$11).get();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$prepareTierLog$5(leaderId, x$3)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)50, (int)this.consumeAllMessages(this.topic(), 50).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        ((AuditManager)server.auditManager().get()).auditRequestsQueue().offer(new RetentionConfigChangeRequest(log.topicPartition(), BoxesRunTime.unboxToInt((Object)log.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), Predef$.MODULE$.Long2long(log.config().retentionSize()), Predef$.MODULE$.Long2long(log.config().retentionMs())));
        log.roll(log.roll$default$1());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$prepareTierLog$7(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$prepareTierLog$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$prepareTierLog$9(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$prepareTierLog$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((long)((AuditManager)server.auditManager().get()).metricsManager().totalLostMessages(), (long)0L);
        HostedPartition hostedPartition = server.replicaManager().getPartition(log.topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(1L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(server).append(" ").append(log.topicPartition()).toString());
        }
        Assertions.assertTrue((log.logStartOffset() > 0L ? 1 : 0) != 0);
        return new Tuple3((Object)log, (Object)BoxesRunTime.boxToInteger((int)leaderId), (Object)server);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityAuditTopicConfigs() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditTopicConfigs$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditTopicConfigs$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Properties resultConfig = (Properties)this.adminZkClient().getAllTopicConfigs().apply((Object)DurabilityAuditConstants$.MODULE$.TOPIC_NAME());
        Assertions.assertEquals((Object)"delete", (Object)resultConfig.get("cleanup.policy"));
        Assertions.assertEquals((Object)Long.toString(DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS()), (Object)resultConfig.get("retention.ms"));
        Assertions.assertEquals((Object)"-1", (Object)resultConfig.get("retention.bytes"));
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="Till we find why last stage materialization is so slow in jenkins")
    @Test
    public void testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})), (Seq)Nil$.MODULE$))}));
        boolean x$42 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$42, x$5, x$6, x$7);
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$1(this, x$4))).get();
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.servers());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$3(leaderId, x$5)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)5, (int)this.consumeAllMessages(this.topic(), 5).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$4(this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$3 = server.replicaManager().logManager();
        TopicPartition x$10 = new TopicPartition(this.topic(), this.partitionId());
        boolean x$11 = qual$3.getLog$default$2();
        ObjectRef log = ObjectRef.create((Object)((AbstractLog)qual$3.getLog(x$10, x$11).get()));
        ((AbstractLog)log.elem).truncateTo(3L);
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        this.shutdownServer(server);
        server.startup();
        KafkaZkClient x$12 = this.zkClient();
        String x$13 = this.topic();
        int x$14 = this.partitionId();
        Some x$15 = new Some((Object)BoxesRunTime.boxToInteger((int)this.brokerId1()));
        long x$16 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$17 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$12, x$13, x$14, x$16, x$17, (Option<Object>)x$15);
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$6(this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$5 = server.replicaManager().logManager();
        TopicPartition x$20 = new TopicPartition(this.topic(), this.partitionId());
        boolean x$21 = qual$5.getLog$default$2();
        log.elem = (AbstractLog)qual$5.getLog(x$20, x$21).get();
        DurabilityDB db = ((AuditManager)server.auditManager().get()).db();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.isEpochChangeEventMaterialized$1(db, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)5L, (long)((AuditManager)server.auditManager().get()).metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="Till we find why last stage materialization is so slow in jenkins")
    @Test
    public void testDurabilityAuditCatchingStartOffsetLapse() {
        this.configProps1().put("confluent.tier.enable", "true");
        this.configProps1().put("confluent.tier.local.hotset.bytes", "1000");
        this.configProps1().put("retention.bytes", "-1");
        this.configureMock(this.configProps1());
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})), (Seq)Nil$.MODULE$))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$62 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$4, x$5, x$62, x$7);
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$1(this, x$6))).get();
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$2(this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$3 = server.replicaManager().logManager();
        TopicPartition x$10 = new TopicPartition(this.topic(), this.partitionId());
        boolean x$11 = qual$3.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$3.getLog(x$10, x$11).get();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$5(leaderId, x$7)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)51, (int)this.consumeAllMessages(this.topic(), 51).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        log.roll(log.roll$default$1());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$7(leaderId, x$8)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)102, (int)this.consumeAllMessages(this.topic(), 102).length());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$8(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$10(server, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((PartitionState)((AuditManager)server.auditManager().get()).db().fetchPartitionState(log.topicPartition()).get()).highWatermark() == 102L ? 1 : 0) != 0);
        log.maybeIncrementLogStartOffset(55L, (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        log.deleteOldSegments();
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$12(server, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((AuditManager)server.auditManager().get()).metricsManager().totalLostMessages() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="Till we find why last stage materialization is so slow in jenkins")
    @Test
    public void testDurabilityAuditHandlesDeleteRecord() {
        this.configProps1().put("confluent.tier.enable", "true");
        this.configProps1().put("confluent.tier.local.hotset.bytes", "1000");
        this.configProps1().put("retention.bytes", "-1");
        this.configureMock(this.configProps1());
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})), (Seq)Nil$.MODULE$))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$4, x$5, x$6, x$7);
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$1(this, x$9))).get();
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.waitUntilAllPendingDurabilityEventsAreFlushed(this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$2(this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$3 = server.replicaManager().logManager();
        TopicPartition x$10 = new TopicPartition(this.topic(), this.partitionId());
        boolean x$11 = qual$3.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$3.getLog(x$10, x$11).get();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$5(leaderId, x$10)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)50, (int)this.consumeAllMessages(this.topic(), 50).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        log.roll(log.roll$default$1());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$7(leaderId, x$11)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)100, (int)this.consumeAllMessages(this.topic(), 100).length());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$8(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((long)((AuditManager)server.auditManager().get()).metricsManager().totalLostMessages(), (long)0L);
        HostedPartition hostedPartition = server.replicaManager().getPartition(log.topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(50L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(server).append(" ").append(log.topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$11(leaderId, x$12)))), this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertEquals((int)100, (int)this.consumeAllMessages(this.topic(), 100).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((long)50L, (long)log.logStartOffset());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$12(server, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)((AuditManager)server.auditManager().get()).metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleDurabilityAuditHandlesDeleteRecord() {
        void var3_3;
        void var2_2;
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        KafkaServer server = (KafkaServer)tuple3._3();
        void log2 = var2_2;
        void server2 = var3_3;
        HostedPartition hostedPartition = server2.replicaManager().getPartition(log2.topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(log2.localLogStartOffset());
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(server2).append(" ").append(log2.topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$1((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)log2.localLogStartOffset(), (long)log2.logStartOffset());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$3((KafkaServer)server2, (AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)((AuditManager)server2.auditManager().get()).metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleDurabilityAuditTierDeletionLapse() {
        void var3_3;
        void var2_2;
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        KafkaServer server = (KafkaServer)tuple3._3();
        void log2 = var2_2;
        void server2 = var3_3;
        log2.maybeIncrementLogStartOffset(log2.localLogStartOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$1((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)log2.localLogStartOffset(), (long)log2.logStartOffset());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$3((KafkaServer)server2, (AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((AuditManager)server2.auditManager().get()).metricsManager().totalLostMessages() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="KDATA-68 Temporarily disabling test till we improve on segment size config being used")
    @Test
    public void testDurabilityAuditTierDeletionDueToSzBreach() {
        void var4_4;
        void var3_3;
        void var2_2;
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "500");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000");
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        int leaderId = BoxesRunTime.unboxToInt((Object)tuple3._2());
        KafkaServer server = (KafkaServer)tuple3._3();
        Assertions.assertTrue((var2_2.logStartOffset() > 0L ? 1 : 0) != 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$1((AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$3((AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long offset = var2_2.logStartOffset();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 49).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$7(this, (int)var3_3, arg_0)));
        Assertions.assertEquals((int)50, (int)this.consumeAllMessages(this.topic(), 50).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$9((AbstractLog)var2_2, offset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)((AuditManager)var4_4.auditManager().get()).metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="KDATA-68 Temporarily disabling test till we improve on segment size config being used")
    @Test
    public void testRetentionChangeEventDurabilityAudit() {
        void var3_3;
        void var2_2;
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "500");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1073741824");
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        KafkaServer server = (KafkaServer)tuple3._3();
        void log2 = var2_2;
        void server2 = var3_3;
        Assertions.assertTrue((log2.logStartOffset() > 0L ? 1 : 0) != 0);
        log2.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$1((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$3((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long lapseCount = ((AuditManager)server2.auditManager().get()).metricsManager().totalLostMessages();
        Assertions.assertTrue((lapseCount > 0L ? 1 : 0) != 0);
        ((AuditManager)server2.auditManager().get()).auditRequestsQueue().offer(new RetentionConfigChangeRequest(log2.topicPartition(), BoxesRunTime.unboxToInt((Object)log2.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), 1000L, -1L));
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$8((KafkaServer)server2, (AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        log2.maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$10((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$12((AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testRetentionChangeEventDurabilityAudit$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)lapseCount, (long)((AuditManager)server2.auditManager().get()).metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityAuditHighWaterMarkEpochChangeEvent() {
        void var3_3;
        void var2_2;
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        KafkaServer server = (KafkaServer)tuple3._3();
        void log2 = var2_2;
        void server2 = var3_3;
        long end = log2.highWatermark();
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$1((KafkaServer)server2, (AbstractLog)log2, end)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        log2.truncateTo(end - 5L);
        ((AuditManager)server2.auditManager().get()).auditRequestsQueue().offer(new StartOffsetChangeRequest(log2.topicPartition(), 0, log2.highWatermark(), log2.logStartOffset(), RetentionType$.MODULE$.Other(), -1L, -1L));
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$3((KafkaServer)server2, (AbstractLog)log2, end)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((AuditManager)server2.auditManager().get()).metricsManager().totalLostMessages() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityAuditDeletePartitionEvent() {
        void var3_3;
        void var2_2;
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        KafkaServer server = (KafkaServer)tuple3._3();
        void log2 = var2_2;
        void server2 = var3_3;
        long end = log2.highWatermark();
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$1((KafkaServer)server2, (AbstractLog)log2, end)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$3((KafkaServer)server2, (AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HostedPartition hostedPartition = server2.replicaManager().getPartition(log2.topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().delete();
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(server2).append(" ").append(log2.topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)server2, (List)Nil$.MODULE$));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$5((KafkaServer)server2, (AbstractLog)log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityAuditDeletePartitionEvent$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityStartOffsetLapseTolerance() {
        void var3_3;
        void var4_4;
        void var2_2;
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "-1");
        this.configProps1().setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "-1");
        Tuple3<AbstractLog, Object, KafkaServer> tuple3 = this.prepareTierLog();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple3._1();
        int leaderId = BoxesRunTime.unboxToInt((Object)tuple3._2());
        KafkaServer server = (KafkaServer)tuple3._3();
        long offset = var2_2.tierPartitionState().endOffset();
        HostedPartition hostedPartition = var4_4.replicaManager().getPartition(var2_2.topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(offset);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(var4_4).append(" ").append(var2_2.topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$1((KafkaServer)var4_4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 19).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$3(this, (int)var3_3, arg_0)));
        Assertions.assertEquals((int)21, (int)this.consumeAllMessages(this.topic(), 21).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$));
        var2_2.roll(var2_2.roll$default$1());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$5((AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        var2_2.maybeIncrementLogStartOffset(offset + 5L, (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$7((KafkaServer)var4_4, (AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$9((KafkaServer)var4_4, (AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HostedPartition hostedPartition2 = var4_4.replicaManager().getPartition(var2_2.topicPartition());
        if (hostedPartition2 instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition2).partition().deleteRecordsOnLeader(offset + 5L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(var4_4).append(" ").append(var2_2.topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed((Seq<KafkaServer>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$11((KafkaServer)var4_4, (AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$13((KafkaServer)var4_4, (AbstractLog)var2_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$14());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$15((KafkaServer)var4_4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$16());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$2(KafkaServer server$1) {
        Tuple2 tuple2 = ((AuditManager)server$1.auditManager().get()).getQueuedEvents();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        return tuple2 != null && tuple2.equals(sp2);
    }

    public static final /* synthetic */ String $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$3() {
        return "Failed to flush all the events from durability audit queue.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$2(server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityAuditTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(DurabilityAuditTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$1(DurabilityAuditTest $this, KafkaServer x$2) {
        return x$2.config().brokerId() == $this.brokerId1();
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$2(DurabilityAuditTest $this, KafkaServer server$2) {
        LogManager qual$2 = server$2.replicaManager().logManager();
        TopicPartition x$8 = new TopicPartition($this.topic(), $this.partitionId());
        boolean x$9 = qual$2.getLog$default$2();
        return qual$2.getLog(x$8, x$9).isDefined();
    }

    public static final /* synthetic */ String $anonfun$prepareTierLog$3() {
        return "Log not ready";
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$5(int leaderId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$7(AbstractLog log$1) {
        return log$1.tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$prepareTierLog$8() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$9(AbstractLog log$1) {
        log$1.deleteOldSegments();
        return log$1.localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$prepareTierLog$10() {
        return "hot set reduction did not kick in";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTopicConfigs$1(DurabilityAuditTest $this) {
        return $this.adminZkClient().getAllTopicConfigs().contains((Object)DurabilityAuditConstants$.MODULE$.TOPIC_NAME());
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTopicConfigs$2() {
        return new StringBuilder(31).append(DurabilityAuditConstants$.MODULE$.TOPIC_NAME()).append(" was not created before timeout").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$1(DurabilityAuditTest $this, KafkaServer x$4) {
        return x$4.config().brokerId() == $this.brokerId1();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$3(int leaderId$2, KafkaServer x$5) {
        return x$5.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$4(DurabilityAuditTest $this, KafkaServer server$3) {
        LogManager qual$2 = server$3.replicaManager().logManager();
        TopicPartition x$8 = new TopicPartition($this.topic(), $this.partitionId());
        boolean x$9 = qual$2.getLog$default$2();
        return qual$2.getLog(x$8, x$9).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$5() {
        return "Not able to get log instance";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$6(DurabilityAuditTest $this, KafkaServer server$3) {
        LogManager qual$4 = server$3.replicaManager().logManager();
        TopicPartition x$18 = new TopicPartition($this.topic(), $this.partitionId());
        boolean x$19 = qual$4.getLog$default$2();
        return qual$4.getLog(x$18, x$19).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$7() {
        return "Not able to get log instance on restart";
    }

    private static final boolean isEpochChangeEventMaterialized$1(DurabilityDB db$1, ObjectRef log$2) {
        PartitionState state = (PartitionState)db$1.fetchPartitionState(((AbstractLog)log$2.elem).topicPartition()).get();
        return BoxesRunTime.unboxToLong((Object)state.epochChain().apply((Object)BoxesRunTime.boxToInteger((int)state.latestEpoch()))) == 3L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$9() {
        return "Events not yet materialized";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$1(DurabilityAuditTest $this, KafkaServer x$6) {
        return x$6.config().brokerId() == $this.brokerId1();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$2(DurabilityAuditTest $this, KafkaServer server$4) {
        LogManager qual$2 = server$4.replicaManager().logManager();
        TopicPartition x$8 = new TopicPartition($this.topic(), $this.partitionId());
        boolean x$9 = qual$2.getLog$default$2();
        return qual$2.getLog(x$8, x$9).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$3() {
        return "Not able to get log instance";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$5(int leaderId$3, KafkaServer x$7) {
        return x$7.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$7(int leaderId$3, KafkaServer x$8) {
        return x$8.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$8(AbstractLog log$3) {
        return log$3.tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$9() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$10(KafkaServer server$4, AbstractLog log$3) {
        return ((AuditManager)server$4.auditManager().get()).db().fetchPartitionState(log$3.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$11() {
        return "failed waiting for audit manager to contain partition state";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$12(KafkaServer server$4, AbstractLog log$3) {
        return ((PartitionState)((AuditManager)server$4.auditManager().get()).db().fetchPartitionState(log$3.topicPartition()).get()).startOffset() == 55L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$13() {
        return "StartOffset not yet decremented";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$1(DurabilityAuditTest $this, KafkaServer x$9) {
        return x$9.config().brokerId() == $this.brokerId1();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$2(DurabilityAuditTest $this, KafkaServer server$5) {
        LogManager qual$2 = server$5.replicaManager().logManager();
        TopicPartition x$8 = new TopicPartition($this.topic(), $this.partitionId());
        boolean x$9 = qual$2.getLog$default$2();
        return qual$2.getLog(x$8, x$9).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHandlesDeleteRecord$3() {
        return "Not able to get log instance";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$5(int leaderId$4, KafkaServer x$10) {
        return x$10.config().brokerId() == leaderId$4;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$7(int leaderId$4, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderId$4;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$8(AbstractLog log$4) {
        return log$4.tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHandlesDeleteRecord$9() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$11(int leaderId$4, KafkaServer x$12) {
        return x$12.config().brokerId() == leaderId$4;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$12(KafkaServer server$5, AbstractLog log$4) {
        return ((PartitionState)((AuditManager)server$5.auditManager().get()).db().fetchPartitionState(log$4.topicPartition()).get()).highWatermark() == 150L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHandlesDeleteRecord$13() {
        return "Timeout waiting for durability event materialization";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$1(AbstractLog log$5) {
        return log$5.tieredLogSegments().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$2() {
        return "Failed tier segment deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$3(KafkaServer server$6, AbstractLog log$5) {
        return ((PartitionState)((AuditManager)server$6.auditManager().get()).db().fetchPartitionState(log$5.topicPartition()).get()).startOffset() == log$5.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$4() {
        return "Timeout waiting for durability event materialization";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditTierDeletionLapse$1(AbstractLog log$6) {
        return log$6.tieredLogSegments().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditTierDeletionLapse$2() {
        return "Failed tier segment deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditTierDeletionLapse$3(KafkaServer server$7, AbstractLog log$6) {
        return ((PartitionState)((AuditManager)server$7.auditManager().get()).db().fetchPartitionState(log$6.topicPartition()).get()).startOffset() == log$6.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditTierDeletionLapse$4() {
        return "Timeout waiting for durability event materialization";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$1(AbstractLog log$7) {
        return log$7.logStartOffset() > 1L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$2() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$3(AbstractLog log$7) {
        return BoxesRunTime.unboxToLong((Object)log$7.tieredLogSegments().toList().headOption().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$6() {
        return "not deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$8(int leaderId$5, KafkaServer x$17) {
        return x$17.config().brokerId() == leaderId$5;
    }

    public static final /* synthetic */ void $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$7(DurabilityAuditTest $this, int leaderId$5, int _) {
        TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)$this.servers().filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$8(leaderId$5, x$17)))), $this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$9(AbstractLog log$7, long offset$1) {
        return log$7.logStartOffset() > offset$1;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$10() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$1(AbstractLog log$8) {
        return log$8.logStartOffset() == 10L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$2() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$3(AbstractLog log$8) {
        return BoxesRunTime.unboxToLong((Object)log$8.tieredLogSegments().toList().headOption().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$6() {
        return "not deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$8(KafkaServer server$8, AbstractLog log$8) {
        return ((PartitionState)((AuditManager)server$8.auditManager().get()).db().fetchPartitionState(log$8.topicPartition()).get()).retentionSz() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$9() {
        return "Retention event not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$10(AbstractLog log$8) {
        return log$8.logStartOffset() >= 20L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$11() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$12(AbstractLog log$8) {
        return BoxesRunTime.unboxToLong((Object)log$8.tieredLogSegments().toList().headOption().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) >= 20L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$15() {
        return "not deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$1(KafkaServer server$9, AbstractLog log$9, long end$1) {
        return ((PartitionState)((AuditManager)server$9.auditManager().get()).db().fetchPartitionState(log$9.topicPartition()).get()).highWatermark() == end$1;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$2() {
        return "HWM not set";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$3(KafkaServer server$9, AbstractLog log$9, long end$1) {
        return ((PartitionState)((AuditManager)server$9.auditManager().get()).db().fetchPartitionState(log$9.topicPartition()).get()).highWatermark() == end$1 - 5L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$4() {
        return "HWM not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$1(KafkaServer server$10, AbstractLog log$10, long end$2) {
        return ((PartitionState)((AuditManager)server$10.auditManager().get()).db().fetchPartitionState(log$10.topicPartition()).get()).highWatermark() == end$2;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$2() {
        return "HWM not set";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$3(KafkaServer server$10, AbstractLog log$10) {
        return ((AuditManager)server$10.auditManager().get()).db().fetchPartitionState(log$10.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$4() {
        return "Partition record does not exists";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$5(KafkaServer server$10, AbstractLog log$10) {
        return !((AuditManager)server$10.auditManager().get()).db().fetchPartitionState(log$10.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$6() {
        return "Partition record still exists";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$1(KafkaServer server$11) {
        return ((AuditManager)server$11.auditManager().get()).metricsManager().totalLostMessages() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$4(int leaderId$6, KafkaServer x$24) {
        return x$24.config().brokerId() == leaderId$6;
    }

    public static final /* synthetic */ void $anonfun$testDurabilityStartOffsetLapseTolerance$3(DurabilityAuditTest $this, int leaderId$6, int _) {
        TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)((Seq)$this.servers().filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)DurabilityAuditTest.$anonfun$testDurabilityStartOffsetLapseTolerance$4(leaderId$6, x$24)))), $this.topic(), "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$5(AbstractLog log$11) {
        return log$11.tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$6() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$7(KafkaServer server$11, AbstractLog log$11) {
        return ((PartitionState)((AuditManager)server$11.auditManager().get()).db().fetchPartitionState(log$11.topicPartition()).get()).startOffset() == log$11.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$9(KafkaServer server$11, AbstractLog log$11) {
        return ((PartitionState)((AuditManager)server$11.auditManager().get()).db().fetchPartitionState(log$11.topicPartition()).get()).lapseWatchStartTime() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$10() {
        return "events not processed";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$11(KafkaServer server$11, AbstractLog log$11) {
        return ((PartitionState)((AuditManager)server$11.auditManager().get()).db().fetchPartitionState(log$11.topicPartition()).get()).lapseWatchStartTime() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$12() {
        return "events not processed";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$13(KafkaServer server$11, AbstractLog log$11) {
        return ((PartitionState)((AuditManager)server$11.auditManager().get()).db().fetchPartitionState(log$11.topicPartition()).get()).startOffset() == log$11.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$14() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$15(KafkaServer server$11) {
        return ((AuditManager)server$11.auditManager().get()).metricsManager().totalLostMessages() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$16() {
        return "lapse message found";
    }

    public DurabilityAuditTest() {
        this.brokerId1 = 0;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

