/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%d!B\u00181\u0003\u0003)\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002!\u0001\u0005\u0004%\t!\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\"\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"9q\u000b\u0001a\u0001\n\u0003A\u0006B\u00020\u0001A\u0003&1\nC\u0004`\u0001\u0001\u0007I\u0011\u00011\t\u000f)\u0004\u0001\u0019!C\u0001W\"1Q\u000e\u0001Q!\n\u0005DqA\u001c\u0001A\u0002\u0013\u0005q\u000eC\u0004|\u0001\u0001\u0007I\u0011\u0001?\t\ry\u0004\u0001\u0015)\u0003q\u0011!y\b\u00011A\u0005\u0002\u0005\u0005\u0001\"CA\b\u0001\u0001\u0007I\u0011AA\t\u0011!\t)\u0002\u0001Q!\n\u0005\r\u0001BBA\f\u0001\u0019\u0005!\nC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005u\u0001\u0001\"\u0001\u0002\u001c!1\u0011q\u0004\u0001\u0005\u0002)Cq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005U\u0002\u0001\"\u0005\u00028!9\u0011q\u000b\u0001\u0005\u0012\u0005e\u0003bBA4\u0001\u0011E\u0011\u0011\u000e\u0005\b\u0003{\u0002A\u0011CA@\u0011\u001d\ty\t\u0001C\t\u0003\u007fBq!!%\u0001\t#\t\u0019\nC\u0004\u0002&\u0002!\t\"a*\t\u000f\u0005%\u0006\u0001\"\u0011\u0002\u001c!9\u0011\u0011\u0019\u0001\u0005B\u0005m\u0001bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\n\u0003W\u0004\u0011\u0013!C\u0001\u0003[D\u0011Ba\u0001\u0001#\u0003%\t!!<\t\u0013\t\u0015\u0001!%A\u0005\u0002\t\u001d\u0001bBAf\u0001\u0011\u0005!1\u0002\u0005\b\u0003\u0017\u0004A\u0011\u0001B\r\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqA!\n\u0001\t\u0003\u00119\u0003C\u0004\u0003.\u0001!\t!a\u0007\t\u000f\t=\u0002\u0001\"\u0001\u00032!I!q\u0007\u0001\u0012\u0002\u0013\u0005!\u0011\b\u0005\b\u0005{\u0001A\u0011\u0001B \u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003^\u0001!\tAa\u0018\t\u000f\t\r\u0004\u0001\"\u0001\u0003f\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u00022e\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0015\u0005\u0019\u0014!B6bM.\f7\u0001A\n\u0003\u0001Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u001a\u0002\u0005i\\\u0017BA\u001e9\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003\u007f\u0001i\u0011\u0001M\u0001\u000eM&\u00148\u000f\u001e\"s_.,'/\u00133\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u00131!\u00138u\u000391\u0017N]:u\u0005J|7.\u001a:JI\u0002\nq\"\u001b8ti\u0006t7-Z\"p]\u001aLwm]\u000b\u0002\u0017B\u0019AjT)\u000e\u00035S!A\u0014#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Q\u001b\n\u00191+Z9\u0011\u0005I+V\"A*\u000b\u0005Q\u0013\u0014AB:feZ,'/\u0003\u0002W'\nY1*\u00194lC\u000e{gNZ5h\u0003MIgn\u001d;b]\u000e,7i\u001c8gS\u001e\u001cx\fJ3r)\tIF\f\u0005\u0002D5&\u00111\f\u0012\u0002\u0005+:LG\u000fC\u0004^\u000b\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'\u0001\tj]N$\u0018M\\2f\u0007>tg-[4tA\u000591/\u001a:wKJ\u001cX#A1\u0011\u0007\t,w-D\u0001d\u0015\t!W*A\u0004nkR\f'\r\\3\n\u0005\u0019\u001c'A\u0002\"vM\u001a,'\u000f\u0005\u0002SQ&\u0011\u0011n\u0015\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHCA-m\u0011\u001di\u0006\"!AA\u0002\u0005\f\u0001b]3sm\u0016\u00148\u000fI\u0001\u000bEJ|7.\u001a:MSN$X#\u00019\u0011\u0005EDhB\u0001:w!\t\u0019H)D\u0001u\u0015\t)H'\u0001\u0004=e>|GOP\u0005\u0003o\u0012\u000ba\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000fR\u0001\u000fEJ|7.\u001a:MSN$x\fJ3r)\tIV\u0010C\u0004^\u0017\u0005\u0005\t\u0019\u00019\u0002\u0017\t\u0014xn[3s\u0019&\u001cH\u000fI\u0001\u0006C2Lg/Z\u000b\u0003\u0003\u0007\u0001RaQA\u0003\u0003\u0013I1!a\u0002E\u0005\u0015\t%O]1z!\r\u0019\u00151B\u0005\u0004\u0003\u001b!%a\u0002\"p_2,\u0017M\\\u0001\nC2Lg/Z0%KF$2!WA\n\u0011!if\"!AA\u0002\u0005\r\u0011AB1mSZ,\u0007%A\bhK:,'/\u0019;f\u0007>tg-[4t\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012!W\u0001#G>tg-[4ve\u0016\u001cVmY;sSRL\u0018I\u001a;feN+'O^3sgN#\u0018M\u001d;\u0002\u000f\r|gNZ5hg\u0006Y1/\u001a:wKJ4uN]%e)\u0011\t)#a\u000b\u0011\t\r\u000b9cZ\u0005\u0004\u0003S!%AB(qi&|g\u000e\u0003\u0004\u0002.Q\u0001\rAQ\u0001\u0003S\u0012\f\u0011BY8v]\u0012\u0004vN\u001d;\u0015\u0007\t\u000b\u0019\u0004C\u0003U+\u0001\u0007q-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\u0011\u0011\u0011\b\t\u0005\u0003w\t\u0019&\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005\r\u0013QI\u0001\tg\u0016\u001cWO]5us*!\u0011qIA%\u0003\u0019\u0019w.\\7p]*\u00191'a\u0013\u000b\t\u00055\u0013qJ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0013aA8sO&!\u0011QKA\u001f\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u0007mSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002\\A!\u0011QLA2\u001b\t\tyF\u0003\u0003\u0002b\u0005\u0015\u0013a\u00028fi^|'o[\u0005\u0005\u0003K\nyF\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0005\u0005-\u0004#B\"\u0002(\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0003S>T!!a\u001e\u0002\t)\fg/Y\u0005\u0005\u0003w\n\tH\u0001\u0003GS2,\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/\u0006\u0002\u0002\u0002B)1)a\n\u0002\u0004B!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u0006U\u0014\u0001B;uS2LA!!$\u0002\b\nQ\u0001K]8qKJ$\u0018.Z:\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0003)\u0011'o\\6feRKW.\u001a\u000b\u0005\u0003+\u000b\t\u000b\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*!\u0012\u0002\u000bU$\u0018\u000e\\:\n\t\u0005}\u0015\u0011\u0014\u0002\u0005)&lW\r\u0003\u0004\u0002$n\u0001\rAQ\u0001\tEJ|7.\u001a:JI\u0006\u0001RM\\1cY\u00164uN]<be\u0012LgnZ\u000b\u0003\u0003\u0013\tQa]3u+BD3!HAW!\u0011\ty+!0\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b1!\u00199j\u0015\u0011\t9,!/\u0002\u000f),\b/\u001b;fe*!\u00111XA(\u0003\u0015QWO\\5u\u0013\u0011\ty,!-\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rq\u0012Q\u0019\t\u0005\u0003_\u000b9-\u0003\u0003\u0002J\u0006E&!C!gi\u0016\u0014X)Y2i\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0015\u0005=\u00171\\Ap\u0003G\f9\u000f\u0005\u0004\u0002R\u0006]'IQ\u0007\u0003\u0003'T1!!6N\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002Z\u0006M'aA'ba\"1\u0011Q\\\u0010A\u0002A\fQ\u0001^8qS\u000eD\u0001\"!9 !\u0003\u0005\rAQ\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0011\u0005\u0015x\u0004%AA\u0002\t\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011%\tIo\bI\u0001\u0002\u0004\t\u0019)A\u0006u_BL7mQ8oM&<\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0003_T3AQAyW\t\t\u0019\u0010\u0005\u0003\u0002v\u0006}XBAA|\u0015\u0011\tI0a?\u0002\u0013Ut7\r[3dW\u0016$'bAA\u007f\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005\u0011q\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HeM\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IA\u000b\u0003\u0002\u0004\u0006EHCBAh\u0005\u001b\u0011y\u0001\u0003\u0004\u0002^\u000e\u0002\r\u0001\u001d\u0005\b\u0005#\u0019\u0003\u0019\u0001B\n\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019a%Q\u0003\"\u0003\u0018%\u0019\u0011\u0011\\'\u0011\u00071{%\t\u0006\u0005\u0002P\nm!Q\u0004B\u0010\u0011\u0019\ti\u000e\na\u0001a\"9!\u0011\u0003\u0013A\u0002\tM\u0001bBAuI\u0001\u0007\u00111Q\u0001\u0011W&dGNU1oI>l'I]8lKJ$\u0012AQ\u0001\u000bW&dGN\u0011:pW\u0016\u0014HcA-\u0003*!1!1\u0006\u0014A\u0002\t\u000bQ!\u001b8eKb\fab[5mY\u0006cGN\u0011:pW\u0016\u00148/\u0001\nsKN$\u0018M\u001d;EK\u0006$'I]8lKJ\u001cHcA-\u00034!I!Q\u0007\u0015\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X-\u0001\u000fsKN$\u0018M\u001d;EK\u0006$'I]8lKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm\"\u0006BA\u0005\u0003c\faf^1ji\u001a{'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2$v.\u00119qK\u0006\u0014xJ\\!mY\n\u0013xn[3sgR)\u0011L!\u0011\u0003F!1!1\t\u0016A\u0002A\fqb\u00197jK:$\bK]5oG&\u0004\u0018\r\u001c\u0005\u0007\u0005\u000fR\u0003\u0019\u00019\u0002\u001b5,7\r[1oSNlg*Y7f\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\tq-A\u0006hKR$v\u000e]5d\u0013\u0012\u001cHC\u0001B)!\u0019\t(1\u000b9\u0003V%\u0019\u0011\u0011\u001c>\u0011\t\t]#\u0011L\u0007\u0003\u0003\u000bJAAa\u0017\u0002F\t!Q+^5e\u000359W\r\u001e+pa&\u001cg*Y7fgR\u0011!\u0011\r\t\u0007c\nM#Q\u000b9\u0002%M,'O^3s/&$\bN\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0004O\n\u001d\u0004BBAR]\u0001\u0007!\t")
public abstract class KafkaServerTestHarness
extends ZooKeeperTestHarness {
    private final int firstBrokerId;
    private Seq<KafkaConfig> instanceConfigs = null;
    private Buffer<KafkaServer> servers = new ArrayBuffer();
    private String brokerList = null;
    private boolean[] alive = null;

    public int firstBrokerId() {
        return this.firstBrokerId;
    }

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerList() {
        return this.brokerList;
    }

    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart() {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    public boolean enableForwarding() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart();
        this.configs().foreach((Function1 & Serializable & scala.Serializable)config -> this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer((KafkaConfig)config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, this.enableForwarding())));
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.alive_$eq(new boolean[this.servers().length()]);
        Arrays.fill(this.alive(), true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.servers() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        }
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaServer>)this.servers(), topicConfig);
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaServer>)this.servers());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties topicConfig) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaServer>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this.servers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaServer)this.servers().apply(index)).shutdown();
            ((KafkaServer)this.servers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void killAllBrokers() {
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        this.servers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (reconfigure) {
                this.servers().update(i, (Object)TestUtils$.MODULE$.createServer((KafkaConfig)this.configs().apply(i), this.brokerTime(((KafkaConfig)this.configs().apply(i)).brokerId()), (Option<String>)None$.MODULE$, this.enableForwarding()));
            }
            ((KafkaServer)this.servers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        return this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        return this.getController().kafkaController().controllerContext().topicNames().toMap(Predef$.MODULE$.$conforms());
    }

    public KafkaServer serverWithBrokerId(int brokerId) {
        return (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverWithBrokerId$1(brokerId, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(25).append("Broker with id ").append(brokerId).append(" not found").toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$serverWithBrokerId$1(int brokerId$1, KafkaServer x$1) {
        return x$1.config().brokerId() == brokerId$1;
    }

    public KafkaServerTestHarness() {
        this.firstBrokerId = 0;
    }
}

