/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.link.FailureType;
import kafka.link.FailureType$AuthenticationFailure$;
import kafka.link.FailureType$AuthorizationFailure$;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.link.FailureType$NetworkFailure$;
import kafka.link.FailureType$SourceTopicDelete$;
import kafka.link.FailureType$UndecodableConfigs$;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.server.link.ConnectionMode;
import kafka.server.link.TopicLinkMirror$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0016,\u0001ABQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0011:\u0011\u0019y\u0004\u0001)A\u0005u!9\u0001\t\u0001b\u0001\n\u0003\n\u0005B\u0002%\u0001A\u0003%!\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\rM\u0003\u0001\u0015!\u0003L\u0011\u001d!\u0006A1A\u0005\nUCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0005\u0004%I!\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002,\t\u000fq\u0003!\u0019!C\u0005;\"1\u0011\r\u0001Q\u0001\nyC\u0011B\u0019\u0001A\u0002\u0003\u0007I\u0011B2\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0013\u0011\b\"\u0003=\u0001\u0001\u0004\u0005\t\u0015)\u0003e\u0011%I\b\u00011AA\u0002\u0013%!\u0010C\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0001BCA\u0005\u0001\u0001\u0007\t\u0011)Q\u0005w\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u0013\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003_\u0001A\u0011AA\u0007\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003\u001bAq!a\u000e\u0001\t\u0003\ti\u0001C\u0004\u0002<\u0001!\t!!\u0004\t\u000f\u0005}\u0002\u0001\"\u0001\u0002\u000e!9\u00111\t\u0001\u0005\u0002\u00055\u0001bBA$\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0017\u0002A\u0011AA\u0007\u0011\u001d\ty\u0005\u0001C\u0001\u0003\u001bAq!a\u0015\u0001\t\u0003\ti\u0001C\u0004\u0002X\u0001!\t!!\u0004\t\u000f\u0005m\u0003\u0001\"\u0001\u0002\u000e!9\u0011q\f\u0001\u0005\u0002\u00055\u0001bBA2\u0001\u0011E\u0011Q\r\u0005\n\u0003\u0013\u0003\u0011\u0013!C\t\u0003\u0017Cq!!)\u0001\t\u0013\ti\u0001C\u0004\u0002$\u0002!I!!*\t\u000f\u0005E\u0007\u0001\"\u0003\u0002\u000e\t12\t\\;ti\u0016\u0014H*\u001b8l\r\u0006LG.\u001e:f)\u0016\u001cHO\u0003\u0002-[\u0005!A.\u001b8l\u0015\u0005q\u0013!B6bM.\f7\u0001A\n\u0003\u0001E\u0002\"AM\u001a\u000e\u0003-J!\u0001N\u0016\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u0007\u0005\u00023\u0001\u0005i1o\\;sG\u0016\u001cE.^:uKJ,\u0012A\u000f\t\u0003emJ!\u0001P\u0016\u0003-\rcWo\u001d;fe2Kgn\u001b+fgRD\u0015M\u001d8fgN\fab]8ve\u000e,7\t\\;ti\u0016\u0014\b%A\u0006eKN$8\t\\;ti\u0016\u0014\u0018\u0001\u00043fgR\u001cE.^:uKJ\u0004\u0013!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;peV\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0003TQ>\u0014H/\u0001\nsKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013!D2p]N,X.\u001a:He>,\b/F\u0001L!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0003mC:<'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013aa\u0015;sS:<\u0017AD2p]N,X.\u001a:He>,\b\u000fI\u0001\u0007gft7-T:\u0016\u0003Y\u0003\"aQ,\n\u0005a#%\u0001\u0002'p]\u001e\fqa]=oG6\u001b\b%A\u0004sKR\u0014\u00180T:\u0002\u0011I,GO]=Ng\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\u0005q\u0006CA\"`\u0013\t\u0001GIA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0002IB\u0011Qm\\\u0007\u0002M*\u0011q\r[\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003S*\fqa\u00197jK:$8O\u0003\u0002/W*\u0011A.\\\u0001\u0007CB\f7\r[3\u000b\u00039\f1a\u001c:h\u0013\t\u0001hM\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u001b\u0011,7\u000f^!e[&tw\fJ3r)\t\u0019h\u000f\u0005\u0002Di&\u0011Q\u000f\u0012\u0002\u0005+:LG\u000fC\u0004x#\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'\u0001\u0006eKN$\u0018\tZ7j]\u0002\na\u0001\\5oW&#W#A>\u0011\u0005q|X\"A?\u000b\u0005y|\u0015\u0001B;uS2L1!!\u0001~\u0005\u0011)V+\u0013#\u0002\u00151Lgn[%e?\u0012*\u0017\u000fF\u0002t\u0003\u000fAqa\u001e\u000b\u0002\u0002\u0003\u000710A\u0004mS:\\\u0017\n\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003MD3AFA\t!\u0011\t\u0019\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\t1!\u00199j\u0015\u0011\tY\"!\b\u0002\u000f),\b/\u001b;fe*\u0019\u0011qD7\u0002\u000b),h.\u001b;\n\t\u0005\r\u0012Q\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\b;fgR\u001cv.\u001e:dK\u000ecWo\u001d;fe:{G/\u0011<bS2\f'\r\\3)\u0007]\tI\u0003\u0005\u0003\u0002\u0014\u0005-\u0012\u0002BA\u0017\u0003+\u0011A\u0001V3ti\u0006IB/Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\rA\u0012\u0011F\u0001\u0019i\u0016\u001cH/Q;uQ>\u0014\u0018N_1uS>tg)Y5mkJ,\u0007fA\r\u0002*\u0005\u0011B/Z:u\u0007>\u0014(/\u001e9u\u0007>tg-[4tQ\rQ\u0012\u0011F\u0001\u0017i\u0016\u001cH/\u00168eK\u000e|G-\u00192mK\u000e{gNZ5hg\"\u001a1$!\u000b\u0002+Q,7\u000f^*pkJ\u001cW\rV8qS\u000e$U\r\\3uK\"\u001aA$!\u000b\u0002[Q,7\u000f^*pkJ\u001cW\rV8qS\u000e\u0014Vm\u0019:fCR,G)\u001a;fGRLwN\\+tS:<Gk\u001c9jG&#7\u000fK\u0002\u001e\u0003S\tq\u0003^3tiN{WO]2f\u0019\u0016\fG-\u001a:DQ\u0006tw-Z:)\u0007y\tI#A\u0019uKN$XK\\2mK\u0006t7k\\;sG\u0016dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5EKN$X\t]8dQ\u0006CW-\u00193)\u0007}\tI#A\u000buKN$H)Z:u\u0019\u0016\fG-\u001a:DQ\u0006tw-Z:)\u0007\u0001\nI#A\u000fuKN$H)Z:u\r>dGn\\<fe\u0006CW-\u00193PM2+\u0017\rZ3sQ\r\t\u0013\u0011F\u0001/i\u0016\u001cH\u000fR3tiJ+\u0007\u000f\\5dCRLwN\u001c(pi&k\u0007/Y2uK\u0012\u0014\u0015pU8ve\u000e,g)Y5mkJ,7\u000fK\u0002#\u0003S\t!\t^3ti\u0012+7\u000f\u001e*fa2L7-\u0019;j_:tu\u000e^%na\u0006\u001cG/\u001a3CsN{WO]2f\r\u0006LG.\u001e:fg^KG\u000f[(mI6+7o]1hK\u001a{'/\\1uQ\r\u0019\u0013\u0011F\u0001\u001di\u0016\u001cH\u000fR3ti&t\u0017\r^5p]\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\r!\u0013\u0011F\u0001\u0019m\u0016\u0014\u0018NZ=GC&dWO]3B]\u0012\u0014VmY8wKJLH#C:\u0002h\u0005E\u00141PA@\u0011\u001d\tI'\na\u0001\u0003W\n1BZ1jYV\u0014X\rV=qKB\u0019!'!\u001c\n\u0007\u0005=4FA\u0006GC&dWO]3UsB,\u0007bBA:K\u0001\u0007\u0011QO\u0001\rgR\f'\u000f\u001e$bS2,(/\u001a\t\u0005\u0007\u0006]4/C\u0002\u0002z\u0011\u0013\u0011BR;oGRLwN\u001c\u0019\t\u000f\u0005uT\u00051\u0001\u0002v\u0005Y1\u000f^8q\r\u0006LG.\u001e:f\u0011%\t\t)\nI\u0001\u0002\u0004\t\u0019)A\u0013wKJLg-_!wC&d\u0017MY5mSRLX*\u001a;sS\u000e\fe\r^3s%\u0016\u001cwN^3ssB\u00191)!\"\n\u0007\u0005\u001dEIA\u0004C_>dW-\u00198\u0002EY,'/\u001b4z\r\u0006LG.\u001e:f\u0003:$'+Z2pm\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tiI\u000b\u0003\u0002\u0004\u0006=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mE)\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f]\f\u0017\u000e\u001e$peJ+7m\u001c<fef\f!\"Y2m\u0005&tG-\u001b8h)\u0019\t9+a.\u0002HB!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016aA1dY*\u0019\u0011\u0011\u00176\u0002\r\r|W.\\8o\u0013\u0011\t),a+\u0003\u0015\u0005\u001bGNQ5oI&tw\rC\u0004\u0002:\"\u0002\r!a/\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fSA!!1\u00020\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0002F\u0006}&\u0001\u0004*fg>,(oY3UsB,\u0007bBAeQ\u0001\u0007\u00111Z\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\tI+!4\n\t\u0005=\u00171\u0016\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0017aC1eI2Kgn[!dYNDs\u0001AAk\u00037\fi\u000e\u0005\u0003\u0002\u0014\u0005]\u0017\u0002BAm\u0003+\u00111\u0001V1h\u0003\u00151\u0018\r\\;fC\t\ty.A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkFailureTest
extends AbstractClusterLinkIntegrationTest {
    private final ClusterLinkTestHarness sourceCluster;
    private final ClusterLinkTestHarness destCluster;
    private final short replicationFactor;
    private final String consumerGroup;
    private final long syncMs;
    private final long retryMs;
    private final int numRecords;
    private ConfluentAdmin destAdmin;
    private UUID linkId;

    @Override
    public ClusterLinkTestHarness sourceCluster() {
        return this.sourceCluster;
    }

    @Override
    public ClusterLinkTestHarness destCluster() {
        return this.destCluster;
    }

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    private String consumerGroup() {
        return this.consumerGroup;
    }

    private long syncMs() {
        return this.syncMs;
    }

    private long retryMs() {
        return this.retryMs;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(ConfluentAdmin x$1) {
        this.destAdmin = x$1;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private void linkId_$eq(UUID x$1) {
        this.linkId = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.sourceCluster().serverConfig().setProperty("super.users", new StringBuilder(11).append("User:").append(JaasTestUtils$.MODULE$.KafkaScramAdmin()).append(";User:").append(JaasTestUtils$.MODULE$.KafkaScramUser2()).toString());
        super.setUp();
        this.addLinkAcls();
        this.destAdmin_$eq(this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1()));
    }

    @Test
    public void testSourceClusterNotAvailable() {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.verifyFailureAndRecovery(FailureType$NetworkFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().killAllBrokers(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.restartCluster(this.sourceCluster(), this.restartCluster$default$2()), true);
    }

    @Test
    public void testAuthenticationFailure() {
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        ObjectRef newJaasConfig = ObjectRef.create(null);
        this.verifyFailureAndRecovery(FailureType$AuthenticationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            newJaasConfig$1.elem = this.updateCredentials(connectionTarget);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)((String)newJaasConfig$1.elem))})))), this.verifyFailureAndRecovery$default$4());
    }

    @Test
    public void testAuthorizationFailure() {
        AclBinding denyTopicAcl = this.aclBinding(ResourceType.TOPIC, AclPermissionType.DENY);
        this.verifyFailureAndRecovery(FailureType$AuthorizationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().deleteAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), this.verifyFailureAndRecovery$default$4());
    }

    @Test
    public void testCorruptConfigs() {
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.verifyFailureAndRecovery(FailureType$CorruptConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.updateConfig$1(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkFailureTest.$anonfun$testCorruptConfigs$2(this, (Product)destConnectionMode)), this.verifyFailureAndRecovery$default$4());
    }

    @Test
    public void testUndecodableConfigs() {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties linkConfigs = new Properties();
        this.verifyFailureAndRecovery(FailureType$UndecodableConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.makeConfigUndecodable$1(linkConfigs), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reconfigureLink$1(linkConfigs), this.verifyFailureAndRecovery$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceTopicDelete() {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.syncMs() * 4L, this.consumerGroup());
        Assertions.assertTrue((boolean)this.destCluster().topicLinkState(this.topic()).state().shouldSync());
        this.sourceCluster().deleteTopic(this.topic(), this.sourceCluster().deleteTopic$default$2());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 20000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testSourceTopicDelete$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFailureTest.$anonfun$testSourceTopicDelete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        Properties topicProps = new Properties();
        topicProps.put("max.message.bytes", "100000");
        this.sourceCluster().createTopic(this.topic(), 1, this.replicationFactor(), topicProps);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.syncMs() * 4L, this.consumerGroup());
        Assertions.assertEquals((int)this.numPartitions(), (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Option maxMessageSize = Option$.MODULE$.apply((Object)this.destCluster().describeTopicConfig(this.topic()).get("max.message.bytes"));
        Assertions.assertTrue((boolean)maxMessageSize.nonEmpty());
        Assertions.assertNotEquals((Object)"100000", (Object)((ConfigEntry)maxMessageSize.get()).value());
        Assertions.assertFalse((boolean)this.destCluster().topicLinkState(this.topic()).state().shouldSync());
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testSourceTopicRecreateDetectionUsingTopicIds() {
        this.numPartitions_$eq(1);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), 300000L, this.consumerGroup()));
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), this.sourceCluster().deleteTopic$default$2());
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        this.produceToSourceCluster(5);
        this.truncate(5);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testSourceLeaderChanges() {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.verifyMirrorWithSourceEpochChanges(false);
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testUncleanSourceLeaderElectionWithDestEpochAhead() {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDestLeaderChanges() {
        void var5_5;
        void var3_3;
        this.numPartitions_$eq(this.sourceCluster().brokerCount());
        TopicPartition tp = (TopicPartition)this.partitions().head();
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader1 = tuple2._1$mcI$sp();
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaServer>)((Seq)this.destCluster().servers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1$adapted(this, (int)var3_3, arg_0))), this.waitForMirror$default$2());
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        this.destCluster().startBroker((int)var3_3);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaServer>)((Seq)this.destCluster().servers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2$adapted(this, (int)var5_5, arg_0))), this.waitForMirror$default$2());
        this.destCluster().serverWithBrokerId((int)var5_5).startup();
        this.produceToSourceCluster(this.numPartitions());
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDestFollowerAheadOfLeader() {
        void var13_12;
        void var3_3;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions().head();
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), 2, this.sourceCluster().createTopic$default$4());
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int destBroker1 = tuple2._1$mcI$sp();
        KafkaZkClient x$1 = this.destCluster().zkClient();
        String x$2 = this.topic();
        int x$3 = 0;
        Some x$42 = new Some((Object)BoxesRunTime.boxToInteger((int)var3_3));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int destBroker2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, (Option<Object>)x$42, x$6);
        this.produceToSourceCluster(100);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> {
            this.sourceCluster().bounceLeader(tp);
            this.produceToSourceCluster(100);
        });
        Tuple2<Object, Object> tuple22 = this.sourceCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int sourceBroker1 = tuple22._1$mcI$sp();
        this.produceToSourceCluster(100);
        this.waitForMirror((Seq<KafkaServer>)new .colon.colon((Object)this.destCluster().serverWithBrokerId(destBroker2), (List)Nil$.MODULE$), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.destCluster().shutdownLeader(tp);
        this.sourceCluster().shutdownLeader(tp);
        this.truncate(100);
        this.sourceCluster().startBroker((int)var13_12);
        this.destCluster().startBroker((int)var3_3);
        KafkaZkClient x$7 = this.destCluster().zkClient();
        String x$8 = this.topic();
        int x$9 = 0;
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)destBroker2));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, (Option<Object>)x$10, x$12);
        Assertions.assertEquals((int)var3_3, (int)newLeader);
        this.destCluster().startBroker(destBroker2);
        this.produceToSourceCluster(100);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testDestReplicationNotImpactedBySourceFailures() {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(new Properties(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        boolean x$2 = false;
        Seq<KafkaServer> x$3 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$3, x$2);
    }

    @Test
    public void testDestReplicationNotImpactedBySourceFailuresWithOldMessageFormat() {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        boolean x$2 = false;
        Seq<KafkaServer> x$3 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$3, x$2);
    }

    @Test
    public void testDestinationHighWatermark() {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions().head();
        Properties props = new Properties();
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), props);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        LongRef startOffset = LongRef.create((long)0L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.destCluster().servers(), tp, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        Buffer destReplicaManagers = (Buffer)((TraversableLike)this.destCluster().servers().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.replicaManager(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$8(tp, x$9)));
        ReplicaManager sourceReplicaManager = this.sourceCluster().partitionLeader(tp).replicaManager();
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        destReplicaManagers.foreach((Function1 & Serializable & scala.Serializable)replicaManager -> {
            this.verifyLog$1(replicaManager, this.verifyLog$default$2$1(), tp, startOffset);
            return BoxedUnit.UNIT;
        });
        startOffset.elem = 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$10 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$10(x$10);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(100);
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        destReplicaManagers.foreach((Function1 & Serializable & scala.Serializable)replicaManager -> {
            this.verifyLog$1(replicaManager, this.verifyLog$default$2$1(), tp, startOffset);
            return BoxedUnit.UNIT;
        });
        int follower = ((ReplicaManager)((IterableLike)destReplicaManagers.filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$12(tp, x$11)))).head()).config().brokerId();
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        long x$1 = this.producedRecords().size() - 100;
        ReplicaManager x$2 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$2, x$1, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset() - 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$12 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$13(x$12);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        startOffset.elem -= 50L;
        long x$3 = startOffset.elem;
        ReplicaManager x$4 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$4, x$3, tp, startOffset);
        startOffset.elem += 50L;
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset();
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$13 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$14(x$13);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))), (Seq<KafkaServer>)new .colon.colon((Object)this.destCluster().partitionLeader(tp), (List)Nil$.MODULE$));
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.produceToSourceCluster(100);
        long x$5 = startOffset.elem;
        ReplicaManager x$6 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$6, x$5, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.produceToSourceCluster(100);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().startBroker(follower);
        this.verifyLog$1(this.destCluster().serverWithBrokerId(follower).replicaManager(), this.verifyLog$default$2$1(), tp, startOffset);
    }

    public void verifyFailureAndRecovery(FailureType failureType, Function0<BoxedUnit> startFailure, Function0<BoxedUnit> stopFailure, boolean verifyAvailabilityMetricAfterRecovery) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup()));
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        startFailure.apply$mcV$sp();
        this.waitForFailure(this.destAdmin(), failureType);
        stopFailure.apply$mcV$sp();
        this.waitForRecovery();
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyOffsetMigration(this.topic(), 0, 10L, this.syncMs() * 4L, this.consumerGroup());
        if (verifyAvailabilityMetricAfterRecovery) {
            double unavailabilityCount = this.unavailabilityCountMetricValue(this.linkName(), this.unavailabilityCountMetricValue$default$2());
            Thread.sleep(5L * this.retryMs());
            Assertions.assertEquals((double)unavailabilityCount, (double)this.unavailabilityCountMetricValue(this.linkName(), this.unavailabilityCountMetricValue$default$2()), (double)0.0);
        }
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    public boolean verifyFailureAndRecovery$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForRecovery() {
        void var5_22;
        Tuple2 tuple2;
        void var3_14;
        Tuple2 tuple22;
        void var1_6;
        Tuple2 tuple23;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple23._1();
        Assertions.assertTrue((boolean)var1_6.available(), (String)"Link not available");
        MirrorTopicDescription.State activeTopicState = MirrorTopicDescription.State.ACTIVE;
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            MirrorTopicDescription.State computeUntilTrue_result;
            MirrorTopicDescription.State state;
            if (ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activeTopicState, state = (computeUntilTrue_result = ClusterLinkFailureTest.$anonfun$waitForRecovery$3(this)))) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        MirrorTopicDescription.State mirrorState = (MirrorTopicDescription.State)tuple22._1();
        Assertions.assertEquals((Object)activeTopicState, (Object)var3_14);
        Assertions.assertTrue((boolean)this.destCluster().topicLinkState(this.topic()).state().shouldSync());
        Set activePartitionState = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE}));
        long l5 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l6 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Set computeUntilTrue_result;
            Set set;
            if (ClusterLinkFailureTest.$anonfun$waitForRecovery$6(activePartitionState, set = (computeUntilTrue_result = this.mirrorPartitionStates(this.destAdmin())))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set actualStates = (Set)tuple2._1();
        Assertions.assertEquals((Object)activePartitionState, (Object)var5_22);
        this.waitForLinkCountMetric("destination", "active", this.destCluster());
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), this.totalKafkaMetricValue$default$4()));
        Assertions.assertEquals((double)this.numPartitions(), (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-partition-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()));
    }

    private AclBinding aclBinding(ResourceType resourceType, AclPermissionType permissionType) {
        ResourcePattern resource = new ResourcePattern(resourceType, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(new StringBuilder(5).append("User:").append(this.linkUserName(this.linkName())).toString(), "*", AclOperation.ALL, permissionType);
        return new AclBinding(resource, ace);
    }

    private void addLinkAcls() {
        this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)this.aclBinding(ResourceType.TOPIC, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.CLUSTER, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.GROUP, AclPermissionType.ALLOW), (List)Nil$.MODULE$))));
    }

    private final void updateConfig$1(String name, String value) {
        Properties props = ((KafkaServer)this.destCluster().servers().head()).zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), this.linkId().toString());
        props.put(name, value);
        new AdminZkClient(((KafkaServer)this.destCluster().servers().head()).zkClient()).changeClusterLinkConfig(this.linkId(), props);
    }

    public static final /* synthetic */ void $anonfun$testCorruptConfigs$2(ClusterLinkFailureTest $this, Product destConnectionMode$1) {
        $this.updateConfig$1(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode$1).name());
    }

    private final void makeConfigUndecodable$1(Properties linkConfigs$1) {
        Properties props = ((KafkaServer)this.destCluster().servers().head()).zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), this.linkId().toString());
        Properties decodedProps = ((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().configEncoder().decode(props);
        linkConfigs$1.putAll((java.util.Map<?, ?>)decodedProps);
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "bad-secret");
        Properties newProps = new ClusterLinkConfigEncoder(KafkaConfig$.MODULE$.fromProps(brokerProps)).encode(decodedProps);
        new AdminZkClient(((KafkaServer)this.destCluster().servers().head()).zkClient()).changeClusterLinkConfig(this.linkId(), newProps);
    }

    public static final /* synthetic */ boolean $anonfun$testUndecodableConfigs$2(Tuple2 x$1) {
        Object object = x$1._1();
        String string = ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp();
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final void reconfigureLink$1(Properties linkConfigs$1) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkName());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.destAdmin().describeConfigs(Collections.singleton(resource)).all(), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.alterClusterLink(this.linkName(), (Map<String, String>)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(linkConfigs$1).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testUndecodableConfigs$2(x$1)))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(linkConfigs$1).asScala()));
    }

    public static final /* synthetic */ boolean $anonfun$testSourceTopicDelete$1(ClusterLinkFailureTest $this) {
        return !$this.destCluster().topicLinkState($this.topic()).state().shouldSync();
    }

    public static final /* synthetic */ String $anonfun$testSourceTopicDelete$2() {
        return "Source topic deletion not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$1(ClusterLinkFailureTest $this, int leader1$1, KafkaServer x$2) {
        KafkaServer kafkaServer = x$2;
        KafkaServer kafkaServer2 = $this.destCluster().serverWithBrokerId(leader1$1);
        return kafkaServer == null ? kafkaServer2 != null : !kafkaServer.equals(kafkaServer2);
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$2(ClusterLinkFailureTest $this, int leader2$1, KafkaServer x$3) {
        KafkaServer kafkaServer = x$3;
        KafkaServer kafkaServer2 = $this.destCluster().serverWithBrokerId(leader2$1);
        return kafkaServer == null ? kafkaServer2 != null : !kafkaServer.equals(kafkaServer2);
    }

    private static final String logDesc$1(ReplicaManager replicaManager$1, TopicPartition tp$2, AbstractLog log$1, LongRef startOffset$1, int endOffset$1, long highWatermark$1) {
        return new StringBuilder(67).append("isLeader=").append(replicaManager$1.getPartitionOrException(tp$2).isLeader()).append(" ").append("actual (start=").append(log$1.logStartOffset()).append(", end=").append(log$1.logEndOffset()).append(", hwm=").append(log$1.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset$1).append(", hwm=").append(highWatermark$1).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$2(LongRef startOffset$1, long x$5) {
        return x$5 == startOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$4(int endOffset$1, long x$6) {
        return x$6 == (long)endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$6(long highWatermark$1, long x$7) {
        return x$7 == highWatermark$1;
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLog$1(ReplicaManager replicaManager, long highWatermark, TopicPartition tp$2, LongRef startOffset$1) {
        void var12_27;
        Tuple2 tuple2;
        void var10_20;
        Tuple2 tuple22;
        void var8_13;
        Tuple2 tuple23;
        AbstractLog log = (AbstractLog)replicaManager.getLog(tp$2).get();
        int endOffset = this.producedRecords().size();
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l3 = log.logStartOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l3);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$2(startOffset$1, l3)) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long logStartOffset = tuple23._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var8_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$2, log, startOffset$1, endOffset, highWatermark)).toString());
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l5 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l6 = log.logEndOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$4(endOffset, l6)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long logEndOffset = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)endOffset, (long)var10_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$2, log, startOffset$1, endOffset, highWatermark)).toString());
        long l7 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l8 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l9 = log.highWatermark();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l9);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$6(highWatermark, l9)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long logHighWatermark = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)highWatermark, (long)var12_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$2, log, startOffset$1, endOffset, highWatermark)).toString());
    }

    private final ReplicaManager verifyLog$default$1$1(TopicPartition tp$2) {
        return this.destCluster().partitionLeader(tp$2).replicaManager();
    }

    private final long verifyLog$default$2$1() {
        return this.producedRecords().size();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$8(TopicPartition tp$2, ReplicaManager x$9) {
        return x$9.getLog(tp$2).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$10(Map x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$12(TopicPartition tp$2, ReplicaManager x$11) {
        return x$11.getPartitionOrException(tp$2).isLeader();
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$13(Map x$12) {
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$14(Map x$13) {
    }

    public static final /* synthetic */ MirrorTopicDescription.State $anonfun$waitForRecovery$3(ClusterLinkFailureTest $this) {
        return $this.mirrorDescription($this.destAdmin()).state();
    }

    public static final /* synthetic */ boolean $anonfun$waitForRecovery$4(MirrorTopicDescription.State activeTopicState$1, MirrorTopicDescription.State x$15) {
        MirrorTopicDescription.State state = x$15;
        return !(state != null ? !state.equals(activeTopicState$1) : activeTopicState$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForRecovery$6(Set activePartitionState$1, Set x$16) {
        Set set = x$16;
        return !(set != null ? !set.equals(activePartitionState$1) : activePartitionState$1 != null);
    }

    public ClusterLinkFailureTest() {
        SecurityProtocol x$1 = SecurityProtocol.SASL_SSL;
        int x$2 = 0;
        int x$3 = 3;
        Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.sourceCluster = new ClusterLinkTestHarness(x$1, x$4, x$2, x$3);
        SecurityProtocol x$5 = SecurityProtocol.SASL_PLAINTEXT;
        int x$6 = 100;
        int x$7 = 3;
        Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.destCluster = new ClusterLinkTestHarness(x$5, x$8, x$6, x$7);
        this.replicationFactor = (short)3;
        this.consumerGroup = "testGroup";
        this.syncMs = 100L;
        this.retryMs = 1000L;
        this.numRecords = 20;
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$1$adapted(ClusterLinkFailureTest $this, int leader1$1, KafkaServer x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1($this, leader1$1, x$2));
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$2$adapted(ClusterLinkFailureTest $this, int leader2$1, KafkaServer x$3) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2($this, leader2$1, x$3));
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$2$adapted(ClusterLinkListing x$14) {
        return BoxesRunTime.boxToBoolean((boolean)x$14.available());
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$4$adapted(MirrorTopicDescription.State activeTopicState$1, MirrorTopicDescription.State x$15) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activeTopicState$1, x$15));
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$6$adapted(Set activePartitionState$1, Set x$16) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$waitForRecovery$6(activePartitionState$1, x$16));
    }
}

