/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.link.FailureType$CircularMirror$;
import kafka.link.FailureType$SourceTopicDelete$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001i4AAE\n\u00011!)Q\u0004\u0001C\u0001=!9\u0001\u0005\u0001b\u0001\n\u0003\n\u0003BB\u0013\u0001A\u0003%!\u0005C\u0004'\u0001\t\u0007I\u0011I\u0011\t\r\u001d\u0002\u0001\u0015!\u0003#\u0011\u001dA\u0003A1A\u0005B%Ba\u0001\r\u0001!\u0002\u0013Q\u0003\"B\u0019\u0001\t\u0003\u0012\u0004\"B\"\u0001\t\u0003\u0011\u0004\"\u0002%\u0001\t\u0003\u0011\u0004\"\u0002&\u0001\t\u0003\u0011\u0004\"\u0002'\u0001\t\u0003\u0011\u0004\"\u0002(\u0001\t\u0003\u0011\u0004\"\u0002)\u0001\t\u0003\u0011\u0004\"\u0002*\u0001\t\u0013\u0019\u0006b\u00024\u0001#\u0003%Ia\u001a\u0005\be\u0002\t\n\u0011\"\u0003h\u0005Q\u0019E.^:uKJd\u0015N\\6JEB\u0014d\u0007V3ti*\u0011A#F\u0001\u0005Y&t7NC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\n\n\u0005q\u0019\"AI!cgR\u0014\u0018m\u0019;DYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\u000eg>,(oY3DYV\u001cH/\u001a:\u0016\u0003\t\u0002\"AG\u0012\n\u0005\u0011\u001a\"AF\"mkN$XM\u001d'j].$Vm\u001d;ICJtWm]:\u0002\u001dM|WO]2f\u00072,8\u000f^3sA\u0005YA-Z:u\u00072,8\u000f^3s\u00031!Wm\u001d;DYV\u001cH/\u001a:!\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t)1\u000b[8si\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0004CA\u00165\u0013\t)DF\u0001\u0003V]&$\bF\u0001\u00058!\tA\u0014)D\u0001:\u0015\tQ4(A\u0002ba&T!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tK$A\u0003\"fM>\u0014X-R1dQ\u0006YB/Z:u'>,(oY3DQ\u0006tw-\u001a)s_B\fw-\u0019;j_:D#!C#\u0011\u0005a2\u0015BA$:\u0005\u0011!Vm\u001d;\u0002cQ,7\u000f^+oG2,\u0017M\\*pkJ\u001cW\rT3bI\u0016\u0014X\t\\3di&|gnV5uQ\u0012+7\u000f^#q_\u000eD\u0017\t[3bI\"\u0012!\"R\u0001+i\u0016\u001cH/T5se>\u0014x+\u001b;i'>,(oY3GC&dWO]3t/&$\bn\u00147e\t\u0016\u001cH/\u00139cQ\tYQ)\u0001\u0017uKN$X*\u001b:s_J<\u0016\u000e\u001e5T_V\u00148-\u001a$bS2,(/Z:XSRDw\n\u001c3T_V\u00148-Z%qE\"\u0012A\"R\u0001,i\u0016\u001cHoU8ve\u000e,Gk\u001c9jGJ+7M]3bi\u0016$U\r^3di\u0016$wJ\u001c+sk:\u001c\u0017\r^5p]\"\u0012Q\"R\u0001\u0013i\u0016\u001cHoQ5sGVd\u0017M]'jeJ|'\u000f\u000b\u0002\u000f\u000b\u0006i1/\u001a;Va\u000ecWo\u001d;feN$2a\r+e\u0011\u001d)v\u0002%AA\u0002Y\u000bq\u0001Z3ti&\u0013\u0007\u000fE\u0002,/fK!\u0001\u0017\u0017\u0003\r=\u0003H/[8o!\tQ\u0016M\u0004\u0002\\?B\u0011A\fL\u0007\u0002;*\u0011alF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001d\u0013A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001\u0019\u0017\t\u000f\u0015|\u0001\u0013!a\u0001-\u0006I1o\\;sG\u0016L%\r]\u0001\u0018g\u0016$X\u000b]\"mkN$XM]:%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001b\u0016\u0003-&\\\u0013A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005=d\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\u000f\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF:fiV\u00038\t\\;ti\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133Q\u0011\u0001Ao\u001e=\u0011\u0005a*\u0018B\u0001<:\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0002s\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public class ClusterLinkIbp26Test
extends AbstractClusterLinkIntegrationTest {
    private final ClusterLinkTestHarness sourceCluster;
    private final ClusterLinkTestHarness destCluster;
    private final short replicationFactor;

    @Override
    public ClusterLinkTestHarness sourceCluster() {
        return this.sourceCluster;
    }

    @Override
    public ClusterLinkTestHarness destCluster() {
        return this.destCluster;
    }

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSourceChangePropagation() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), this.setUpClusters$default$2());
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = 10000L;
        long x$4 = this.destCluster().createDestClusterLink$default$3();
        long x$5 = this.destCluster().createDestClusterLink$default$5();
        Properties x$6 = this.destCluster().createDestClusterLink$default$6();
        this.destCluster().createDestClusterLink(x$1, x$2, x$4, x$3, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(false);
        Assertions.assertTrue((boolean)this.destCluster().topicLinkState(this.topic()).state().shouldSync());
        this.sourceCluster().deleteTopic(this.topic(), false);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 20000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIbp26Test.$anonfun$testSourceChangePropagation$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIbp26Test.$anonfun$testSourceChangePropagation$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testUncleanSourceLeaderElectionWithDestEpochAhead() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), this.setUpClusters$default$2());
        this.destCluster().createDestClusterLink(this.linkName(), this.sourceCluster(), this.destCluster().createDestClusterLink$default$3(), this.destCluster().createDestClusterLink$default$4(), this.destCluster().createDestClusterLink$default$5(), this.destCluster().createDestClusterLink$default$6());
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldDestIpb() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), this.setUpClusters$default$2());
        int recordsBeforeSourceFailure = 10;
        Properties x$2 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$1();
        int x$3 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(x$2, recordsBeforeSourceFailure, x$3);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        KafkaServer destLeader = this.destCluster().partitionLeader(tp);
        this.waitForMirror((Seq<KafkaServer>)new .colon.colon((Object)destLeader, (List)Nil$.MODULE$), this.waitForMirror$default$2());
        ((IterableLike)this.destCluster().servers().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(destLeader, x$1)))).foreach((Function1 & Serializable & scala.Serializable)follower -> {
            ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(this, recordsBeforeSourceFailure, tp, follower);
            return BoxedUnit.UNIT;
        });
        String x$4 = this.topic();
        String x$5 = this.linkName();
        boolean x$6 = false;
        boolean x$7 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$4, x$5, x$7, x$6);
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldSourceIpb() {
        Some x$1 = new Some((Object)"2.4");
        Option<String> x$2 = this.setUpClusters$default$1();
        this.setUpClusters(x$2, (Option<String>)x$1);
        Properties topicConfig = new Properties();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$3 = this.topic();
        boolean x$4 = false;
        Seq<KafkaServer> x$5 = this.verifyMirror$default$2();
        this.verifyMirror(x$3, x$5, x$4);
    }

    @Test
    public void testSourceTopicRecreateDetectedOnTruncation() {
        this.numPartitions_$eq(1);
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), this.setUpClusters$default$2());
        ConfluentAdmin destAdmin = this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1());
        this.setupLinkAndMirrorForFailureTest(20000L, 60000L, "testGroup");
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), this.sourceCluster().deleteTopic$default$2());
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(5);
        this.truncate(5);
        this.waitForFailure(destAdmin, FailureType$SourceTopicDelete$.MODULE$);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().killAllBrokers();
        ConfluentAdmin destAdmin2 = (ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get();
        this.waitForFailure(destAdmin2, FailureType$SourceTopicDelete$.MODULE$);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @Test
    public void testCircularMirror() {
        Some x$1 = new Some((Object)"2.6");
        Option<String> x$2 = this.setUpClusters$default$1();
        this.setUpClusters(x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties linkPropOverrides = new Properties();
        linkPropOverrides.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        String x$3 = this.linkName();
        ClusterLinkTestHarness x$4 = this.sourceCluster();
        long x$6 = this.destCluster().createDestClusterLink$default$3();
        long x$7 = this.destCluster().createDestClusterLink$default$4();
        long x$8 = this.destCluster().createDestClusterLink$default$5();
        UUID linkId = this.destCluster().createDestClusterLink(x$3, x$4, x$6, x$7, x$8, linkPropOverrides);
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", this.destCluster().brokerList());
        linkProps.putAll((Map<?, ?>)this.destCluster().clientSecurityProps(this.linkName()));
        linkProps.put("sasl.jaas.config", this.createLinkCredentials(this.linkName(), this.destCluster(), this.createLinkCredentials$default$3()));
        String x$9 = this.linkName();
        ClusterLinkTestHarness x$10 = this.destCluster();
        long x$12 = this.sourceCluster().createDestClusterLink$default$3();
        long x$13 = this.sourceCluster().createDestClusterLink$default$4();
        long x$14 = this.sourceCluster().createDestClusterLink$default$5();
        UUID sourceLinkId = this.sourceCluster().createDestClusterLink(x$9, x$10, x$12, x$13, x$14, linkPropOverrides);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.sourceCluster().deleteTopic(this.topic(), this.sourceCluster().deleteTopic$default$2());
        this.sourceCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.sourceCluster().linkTopic$default$4());
        ConfluentAdmin sourceAdmin = this.sourceCluster().createAdminClient(this.sourceCluster().createAdminClient$default$1());
        ConfluentAdmin destAdmin = this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1());
        this.waitForReplicaState$1(sourceAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForReplicaState$1(destAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForBlockedPartition$1(sourceLinkId, linkId, tp);
        String x$15 = this.topic();
        String x$16 = this.linkName();
        boolean x$17 = false;
        boolean x$18 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$15, x$16, x$18, x$17);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        KafkaProducer producer = this.destCluster().createProducer(this.destCluster().createProducer$default$1(), this.destCluster().createProducer$default$2(), this.destCluster().createProducer$default$3());
        this.produceRecords(producer, this.topic(), 20, this.produceRecords$default$4());
        producer.close();
        this.waitForMirror((Seq<KafkaServer>)this.sourceCluster().servers(), this.waitForMirror$default$2());
        this.waitForReplicaState$1(sourceAdmin, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE})));
    }

    private void setUpClusters(Option<String> destIbp, Option<String> sourceIbp) {
        destIbp.foreach((Function1 & Serializable & scala.Serializable)ibp -> this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        sourceIbp.foreach((Function1 & Serializable & scala.Serializable)ibp -> this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        super.setUp();
    }

    private Option<String> setUpClusters$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setUpClusters$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testSourceChangePropagation$1(ClusterLinkIbp26Test $this) {
        return !$this.destCluster().topicLinkState($this.topic()).state().shouldSync();
    }

    public static final /* synthetic */ String $anonfun$testSourceChangePropagation$2() {
        return "Source topic deletion not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(KafkaServer destLeader$1, KafkaServer x$1) {
        KafkaServer kafkaServer = x$1;
        return !(kafkaServer != null ? !kafkaServer.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(ClusterLinkIbp26Test $this, int recordsBeforeSourceFailure$1, TopicPartition tp$1, KafkaServer follower) {
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)recordsBeforeSourceFailure$1)), $this.logEndOffset(follower, tp$1));
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForReplicaState$1(ConfluentAdmin admin, Set expectedStates) {
        void var3_9;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Set computeUntilTrue_result;
            Set set;
            if ((set = (computeUntilTrue_result = this.mirrorPartitionStates(admin))).subsetOf((GenSet)expectedStates)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set actualStates = (Set)tuple2._1();
        Assertions.assertTrue((boolean)var3_9.subsetOf((GenSet)expectedStates), (String)new StringBuilder(25).append("Expected subset of ").append(expectedStates).append(", got ").append(var3_9).toString());
    }

    private static final ConcurrentHashMap waitingPartitions$1(ClusterLinkTestHarness cluster, UUID linkId, TopicPartition tp$2) {
        return (ConcurrentHashMap)TestUtils.fieldValue((Object)cluster.partitionLeader(tp$2).clusterLinkManager().fetcherManager(linkId).get(), ClusterLinkFetcherManager.class, (String)"waitingPartitions");
    }

    public static final /* synthetic */ boolean $anonfun$testCircularMirror$3(ConcurrentHashMap sourceWaitingPartitions$1, TopicPartition tp$2, ConcurrentHashMap destWaitingPartitions$1) {
        return sourceWaitingPartitions$1.containsKey(tp$2) || destWaitingPartitions$1.containsKey(tp$2);
    }

    public static final /* synthetic */ String $anonfun$testCircularMirror$4() {
        return "Partition not blocked after consecutive epoch bumps";
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForBlockedPartition$1(UUID sourceLinkId$1, UUID linkId$1, TopicPartition tp$2) {
        ConcurrentHashMap sourceWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.sourceCluster(), sourceLinkId$1, tp$2);
        ConcurrentHashMap destWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.destCluster(), linkId$1, tp$2);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIbp26Test.$anonfun$testCircularMirror$3(sourceWaitingPartitions, tp$2, destWaitingPartitions)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIbp26Test.$anonfun$testCircularMirror$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public ClusterLinkIbp26Test() {
        SecurityProtocol x$1 = SecurityProtocol.SASL_SSL;
        int x$2 = 0;
        int x$3 = 3;
        Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.sourceCluster = new ClusterLinkTestHarness(x$1, x$4, x$2, x$3);
        SecurityProtocol x$5 = SecurityProtocol.SASL_PLAINTEXT;
        int x$6 = 100;
        int x$7 = 3;
        Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.destCluster = new ClusterLinkTestHarness(x$5, x$8, x$6, x$7);
        this.replicationFactor = (short)3;
    }

    public static final /* synthetic */ Object $anonfun$testCircularMirror$2$adapted(Set expectedStates$1, Set x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.subsetOf((GenSet)expectedStates$1));
    }
}

