/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.controller.ReplicaAssignment;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherThread;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\tuc\u0001\u0002\u001d:\u0001yBQa\u0011\u0001\u0005\u0002\u0011CqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011A/\t\r!\u0004\u0001\u0015!\u0003_\u0011\u001dI\u0007A1A\u0005\u0002uCaA\u001b\u0001!\u0002\u0013q\u0006\"B6\u0001\t\u0003a\u0007\"B?\u0001\t\u0003a\u0007\"B@\u0001\t\u0003a\u0007BBA\u0002\u0001\u0011\u0005A\u000e\u0003\u0004\u0002\b\u0001!\t\u0001\u001c\u0005\u0007\u0003\u0017\u0001A\u0011\u00017\t\r\u0005=\u0001\u0001\"\u0001m\u0011\u0019\t\u0019\u0002\u0001C\u0001Y\"1\u0011q\u0003\u0001\u0005\u00021Da!a\u0007\u0001\t\u0003a\u0007BBA\u0010\u0001\u0011\u0005A\u000e\u0003\u0004\u0002$\u0001!\t\u0001\u001c\u0005\u0007\u0003O\u0001A\u0011\u00017\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u0019\ty\f\u0001C\u0001Y\"1\u00111\u0019\u0001\u0005\u00021Da!a2\u0001\t\u0003a\u0007BBAf\u0001\u0011\u0005A\u000e\u0003\u0004\u0002P\u0002!\t\u0001\u001c\u0005\u0007\u0003'\u0004A\u0011\u00017\t\r\u0005]\u0007\u0001\"\u0001m\u0011\u0019\tY\u000e\u0001C\u0001Y\"1\u0011q\u001c\u0001\u0005\u00021Da!a9\u0001\t\u0003a\u0007BBAt\u0001\u0011\u0005A\u000e\u0003\u0004\u0002l\u0002!\t\u0001\u001c\u0005\u0007\u0003_\u0004A\u0011\u00017\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9\u0011\u0011 \u0001\u0005\n\u0005m\bB\u0002B\u0004\u0001\u0011\u0005A\u000e\u0003\u0004\u0003\f\u0001!\t\u0001\u001c\u0005\u0007\u0005\u001f\u0001A\u0011\u00017\t\r\tM\u0001\u0001\"\u0001m\u0011\u0019\u00119\u0002\u0001C\u0001Y\"1!1\u0004\u0001\u0005\u00021DaAa\b\u0001\t\u0003a\u0007b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\n\u0005W\u0001\u0011\u0013!C\u0005\u0005[AaAa\u0011\u0001\t\u0003a\u0007B\u0002B$\u0001\u0011\u0005A\u000e\u0003\u0004\u0003L\u0001!\t\u0001\u001c\u0002\u001b\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003um\nA\u0001\\5oW*\tA(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0004C\u0001!B\u001b\u0005I\u0014B\u0001\":\u0005\t\n%m\u001d;sC\u000e$8\t\\;ti\u0016\u0014H*\u001b8l\u0013:$Xm\u001a:bi&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012!\u0012\t\u0003\u0001\u0002\tab\u001c4gg\u0016$Hk\\\"p[6LG/F\u0001I!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0011auN\\4\u0002\u001f=4gm]3u)>\u001cu.\\7ji\u0002\n!b]=oGB+'/[8e\u0003-\u0019\u0018P\\2QKJLw\u000e\u001a\u0011\u0002\u001b\r|gn];nKJ<%o\\;q+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\u001d\r|gn];nKJ<%o\\;qA\u0005YAo\u001c9jG\u001aKG\u000e^3s+\u0005q\u0006CA0g\u001d\t\u0001G\r\u0005\u0002b\u00156\t!M\u0003\u0002d{\u00051AH]8pizJ!!\u001a&\u0002\rA\u0013X\rZ3g\u0013\tQvM\u0003\u0002f\u0015\u0006aAo\u001c9jG\u001aKG\u000e^3sA\u00051\u0012N\\2mk\u0012,\u0017\t\u001c7U_BL7m\u001d$jYR,'/A\fj]\u000edW\u000fZ3BY2$v\u000e]5dg\u001aKG\u000e^3sA\u0005)B/Z:u\u0007J,\u0017\r^3NSJ\u0014xN\u001d+pa&\u001cG#A7\u0011\u0005%s\u0017BA8K\u0005\u0011)f.\u001b;)\u00051\t\bC\u0001:|\u001b\u0005\u0019(B\u0001;v\u0003\r\t\u0007/\u001b\u0006\u0003m^\fqA[;qSR,'O\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`:\u0003\tQ+7\u000f^\u0001 i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]N<\u0016\u000e\u001e5NSJ\u0014xN\u001d+pa&\u001c\u0007FA\u0007r\u0003\u0015\"Xm\u001d;Ti>\u0004X*\u001b:s_J$v\u000e]5d/&$\b.\u00138wC2LGMU3rk\u0016\u001cH\u000f\u000b\u0002\u000fc\u0006qA/Z:u'R|\u0007/T5se>\u0014\bFA\br\u0003\u001d\"Xm\u001d;Ti>\u0004X*\u001b:s_J<\u0016\u000e\u001e5T_V\u00148-Z\"mkN$XM]*ikR$wn\u001e8)\u0005A\t\u0018A\t;fgR\u001c%/Z1uK\u0006sG\rR3mKR,\u0017I\u001c3SK\u000e\u0014X-\u0019;f\u0019&t7\u000e\u000b\u0002\u0012c\u0006!B/Z:u\u001b&\u0014(o\u001c:OK^\u0014VmY8sIND#AE9\u00023Q,7\u000f^'jeJ|'/\u0012=jgRLgn\u001a*fG>\u0014Hm\u001d\u0015\u0003'E\f1\u0003^3tiR{\u0007/[2D_:4\u0017nZ*z]\u000eD#\u0001F9\u0002-Q,7\u000f\u001e'jgR$Um]2sS\n,W*\u001b:s_JD#!F9\u0002-Q,7\u000f^*pkJ\u001cWm\u00117vgR,'/U;pi\u0006D#AF9\u0002?Q,7\u000f\u001e#fgRLg.\u0019;j_:\u001cE.^:uKJd\u0015N\\6Rk>$\u0018\r\u000b\u0002\u0018c\u0006QC/Z:u\t\u0016\u001cH/\u001b8bi&|gn\u00117vgR,'\u000fT5oW\n\u0013xn[3s\u0019\u00164X\r\\)v_R\f\u0007F\u0001\rr\u0003\u00052XM]5gs\u0012+7\u000f^5oCRLwN\\\"mkN$XM\u001d'j].\fVo\u001c;b)\u0019\ty#a\u000f\u0002bA!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026]\u000bA!\u001e;jY&!\u0011\u0011HA\u001a\u0005\u0011)V+\u0013#\t\u000f\u0005u\u0012\u00041\u0001\u0002@\u0005I!/Z:pkJ\u001cWm\u001d\t\u0007\u0003\u0003\n9%a\u0013\u000e\u0005\u0005\r#bAA#\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00131\t\u0002\u0004'\u0016\f\b\u0003BA'\u0003;j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0007G>tg-[4\u000b\t\u0005U\u0013qK\u0001\u0007G>lWn\u001c8\u000b\u0007q\nIFC\u0002\u0002\\e\fa!\u00199bG\",\u0017\u0002BA0\u0003\u001f\u0012abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0002de\u0001\r!!\u001a\u0002\u0013E,x\u000e^1N_\u0012,\u0007\u0003BA4\u0003\u0013sA!!\u001b\u0002\u0004:!\u00111NA@\u001d\u0011\ti'! \u000f\t\u0005=\u00141\u0010\b\u0005\u0003c\nIH\u0004\u0003\u0002t\u0005]dbA1\u0002v%\t!0C\u0002\u0002\\eL1\u0001PA-\u0013\u0011\t)&a\u0016\n\t\u0005E\u00131K\u0005\u0005\u0003\u0003\u000by%A\u0005j]R,'O\\1mg&!\u0011QQAD\u0003A\u0019uN\u001c4mk\u0016tGoQ8oM&<7O\u0003\u0003\u0002\u0002\u0006=\u0013\u0002BAF\u0003\u001b\u0013Ac\u00117vgR,'\u000fT5oWF+x\u000e^1N_\u0012,'\u0002BAC\u0003\u000f\u000bqB^3sS\u001aL\u0018+^8uC6{G-\u001a\u000b\u0004[\u0006M\u0005bBA25\u0001\u0007\u0011QM\u0001!I\u0016\u001cHo\u00117vgR,'\u000fT5oWJ+\u0007\u000f\\5dCN$\u0006N]8ui2,G\r\u0006\u0002\u0002\u001aB\u0019\u0011*a'\n\u0007\u0005u%JA\u0004C_>dW-\u00198\u0002/Y,'/\u001b4z\r\u0016$8\r\u001b*fgB|gn]3TSj,G#B7\u0002$\u0006\u001d\u0006bBAS9\u0001\u0007\u0011qF\u0001\u0007Y&t7.\u00133\t\u000f\u0005%F\u00041\u0001\u0002,\u0006aQ\r\u001f9fGR,GmU5{KB)\u0011*!,\u00022&\u0019\u0011q\u0016&\u0003\r=\u0003H/[8o!\u0011\t\u0019,a/\u000e\u0005\u0005U&b\u0001\u001e\u00028*\u0019\u0011\u0011X\u001e\u0002\rM,'O^3s\u0013\u0011\ti,!.\u0003#\u0019+Go\u00195SKN\u0004xN\\:f'&TX-\u0001\u0019uKN$H)Z:uS:\fG/[8o\u00072,8\u000f^3s\u0019&t7.U;pi\u0006<\u0016\u000e\u001e5Ce>\\WM\u001d*fgR\f'\u000f\u001e\u0015\u0003;E\fQ\u0005^3ti\u0012+7\u000f^5oCRLwN\u001c'bO2Kgn\u001b$fi\u000eDWM\u001d+ie>$H\u000f\\3)\u0005y\t\u0018!\u0005;fgR\fE\r\u001a)beRLG/[8og\"\u0012q$]\u0001\u001ci\u0016\u001cH/\u00117uKJ\u001cE.^:uKJd\u0015N\\6D_:4\u0017nZ:)\u0005\u0001\n\u0018!\u000b;fgR|eMZ:fi6KwM]1uS>tw+\u001b;i\u0003\u0012$W\rZ\"p]N,X.\u001a:He>,\b\u000f\u000b\u0002\"c\u0006\tC/Z:u\u001f\u001a47/\u001a;NS\u001e\u0014\u0018\r^5p]^KG\u000f[!eI\u0016$Gk\u001c9jG\"\u0012!%]\u0001\u0011i\u0016\u001cH\u000fR3tiJ+\u0017\rZ(oYfD#aI9\u00029Q,7\u000f\u001e#fY\u0016$Xm\u00117vgR,'\u000fT5oW\u000ecW-\u00198va\"\u0012A%]\u0001!i\u0016\u001cH/T5se>\u0014X\r\u001a+pa&\u001cW*\u0019:lK\u00124uN\u001d#fY\u0016$X\r\u000b\u0002&c\u0006qA/Z:u!\u0006,8/\u001a+pa&\u001c\u0007F\u0001\u0014r\u0003Q!Xm\u001d;QCV\u001cXm\u00117vgR,'\u000fT5oW\"\u0012q%]\u0001\u0012i\u0016\u001cHOU3qY&\u001c\u0017m\u0015;biV\u001c\bF\u0001\u0015r\u0003E!Xm\u001d;BkR|W*\u001b:s_JLgn\u001a\u0015\u0003SE\fq\"Y;u_6K'O]8s)>\u0004\u0018n\u0019\u000b\u0004[\u0006]\b\"B(+\u0001\u0004A\u0015!\b3fgRd\u0015N\\6Qe>\u00048OR8s\u0003V$x.T5se>\u0014\u0018N\\4\u0015\t\u0005u(1\u0001\t\u0005\u0003c\ty0\u0003\u0003\u0003\u0002\u0005M\"A\u0003)s_B,'\u000f^5fg\"1!QA\u0016A\u0002y\u000bA\u0002^8qS\u000e4\u0015\u000e\u001c;feN\f1\u0007^3ti2\u000b7\u000f\u001e$fi\u000eDW\rZ(gMN,G\u000f\u0015:p[>$X\rZ'jeJ|'\u000fV8qS\u000e$Um]2sSB$\u0018n\u001c8)\u00051\n\u0018!\u000e;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3PM\u001a\u001cX\r\u001e$bS2,Gm\u0014<fe6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:D#!L9\u0002UQ,7\u000f^!vi>l\u0015N\u001d:pe&twMT8Pm\u0016\u0014H.\u00199qS:<Gk\u001c9jG\u001aKG\u000e^3sg\"\u0012a&]\u0001(i\u0016\u001cH/Q;u_6K'O]8sS:<\u0017\t\u001c7poNd\u0015N\\6D_:4\u0017nZ+qI\u0006$X\r\u000b\u00020c\u0006\u0019C/Z:u\u0003V$x.T5se>\u0014\u0018N\\4Va\u0012\fG/Z#ySN$\u0018N\\4MS:\\\u0007F\u0001\u0019r\u0003\u0019\"Xm\u001d;BkR|W*\u001b:s_JLgnZ!eI&tw-\u00113eSRLwN\\1m)>\u0004\u0018n\u0019\u0015\u0003cE\f\u0001\u0005^3ti\u0006+Ho\\'jeJ|'/\u001b8h\u001d>,\u00050[:uS:<Gk\u001c9jG\"\u0012!']\u00013i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]R\u0019QNa\n\t\u0013\t%2\u0007%AA\u0002\u0005e\u0015a\u00029s_6|G/Z\u0001=i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00030)\"\u0011\u0011\u0014B\u0019W\t\u0011\u0019\u0004\u0005\u0003\u00036\t}RB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001f\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005#q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b;fgR$U\r\\3uK\u0006+Ho\\'jeJ|'/\u001a3U_BL7m\u001d\u0015\u0003kE\f!\u0005^3ti&sG/\u001a:wC2\u001c\u0005.\u00198hK\u001a{'\u000fU3sS>$\u0017n\u0019+bg.\u001c\bF\u0001\u001cr\u0003%\"Xm\u001d;NSJ\u0014xN\u001d$bS2|g/\u001a:XQ\u0016t7k\\;sG\u0016L5/\u00168bm\u0006LG.\u00192mK\"\u0012q'\u001d\u0015\b\u0001\tE#q\u000bB-!\r\u0011(1K\u0005\u0004\u0005+\u001a(a\u0001+bO\u0006)a/\u00197vK\u0006\u0012!1L\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class ClusterLinkIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long offsetToCommit;
    private final long syncPeriod;
    private final String consumerGroup;
    private final String topicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"").append(this.topic()).append("\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |").toString())).stripMargin();
    private final String includeAllTopicsFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"*\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |")).stripMargin();

    public long offsetToCommit() {
        return this.offsetToCommit;
    }

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public String topicFilter() {
        return this.topicFilter;
    }

    public String includeAllTopicsFilter() {
        return this.includeAllTopicsFilter;
    }

    @Test
    public void testCreateMirrorTopic() {
        String retentionMs = "10000";
        Properties configs = new Properties();
        configs.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), configs);
        String x$12 = this.linkName();
        boolean x$2 = true;
        Properties x$3 = this.createClusterLink$default$2();
        Option<Properties> x$4 = this.createClusterLink$default$3();
        this.createClusterLink(x$12, x$3, x$4, x$2);
        CreateTopicsResult result = this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(this.topic()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(this.topic()).get()));
        Assertions.assertEquals((Object)retentionMs, (Object)((Config)result.config(this.topic()).get()).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopic$1(this, x$1)))).head()).topics().get()).asScala()).toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionsWithMirrorTopic() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        String x$1 = this.linkName();
        boolean x$2 = true;
        Properties x$3 = this.createClusterLink$default$2();
        Option<Properties> x$4 = this.createClusterLink$default$3();
        this.createClusterLink(x$1, x$3, x$4, x$2);
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        Properties producerProps = new Properties();
        producerProps.setProperty("transactional.id", "test_txn");
        producerProps.setProperty("acks", "all");
        ByteArraySerializer x$6 = this.destCluster().createProducer$default$1();
        ByteArraySerializer x$7 = this.destCluster().createProducer$default$2();
        KafkaProducer producer = this.destCluster().createProducer(x$6, x$7, producerProps);
        Properties consumerProps = new Properties();
        consumerProps.setProperty("isolation.level", "read_committed");
        ByteArrayDeserializer x$9 = this.destCluster().createConsumer$default$1();
        ByteArrayDeserializer x$10 = this.destCluster().createConsumer$default$2();
        List<String> x$11 = this.destCluster().createConsumer$default$4();
        KafkaConsumer consumer = this.destCluster().createConsumer(x$9, x$10, consumerProps, x$11);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.partitions()).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.produceRecords((KafkaProducer<byte[], byte[]>)producer, this.topic(), 10, this.produceRecords$default$4()));
        Assertions.assertTrue((boolean)e.getMessage().contains("INVALID_REQUEST"), (String)new StringBuilder(17).append("Unexpected error ").append(e.getMessage()).toString());
        producer.abortTransaction();
        this.producedRecords().clear();
        String x$12 = this.topic();
        String x$13 = this.linkName();
        boolean x$14 = false;
        boolean x$15 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$12, x$13, x$15, x$14);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        producer.beginTransaction();
        this.produceRecords(producer, this.topic(), 10, this.produceRecords$default$4());
        producer.commitTransaction();
        producer.close();
        this.consumeRecords(consumer);
    }

    @Test
    public void testStopMirrorTopicWithInvalidRequest() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(100);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().unlinkTopic(this.topic(), this.linkName(), false, false));
        this.destCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.destCluster().createTopic$default$4());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().unlinkTopic(this.topic(), this.linkName(), false, false));
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().unlinkTopic(this.topic(), this.linkName(), false, false));
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testStopMirror() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(100);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, x$3);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testStopMirrorWithSourceClusterShutdown() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.sourceCluster().killAllBrokers();
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, x$3);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.restartSource$1();
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        String x$5 = this.topic();
        String x$6 = this.linkName();
        boolean x$7 = false;
        boolean x$8 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$5, x$6, x$8, x$7);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testCreateAndDeleteAndRecreateLink() {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$1(this, x$4)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertTrue((boolean)listing.isEmpty());
        if (this.useSourceInitiatedLink()) {
            this.sourceCluster().deleteClusterLink(this.linkName(), this.sourceCluster().deleteClusterLink$default$2(), this.sourceCluster().deleteClusterLink$default$3());
            listing = this.sourceCluster().listClusterLinks(true);
            Assertions.assertTrue((boolean)listing.isEmpty());
        }
        UUID newLinkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$2(this, x$5)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), newLinkId);
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
        if (!this.useSourceInitiatedLink()) {
            Properties invalidLinkProps = this.destLinkProps(this.destLinkProps$default$1());
            invalidLinkProps.setProperty("sasl.jaas.config", invalidLinkProps.getProperty("sasl.jaas.config").replace(this.linkName(), new StringBuilder(6).append("wrong-").append(this.linkName()).toString()));
            this.verifyValidateLinkFailure(invalidLinkProps, SaslAuthenticationException.class, "Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256");
        }
    }

    @Test
    public void testMirrorNewRecords() {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(numRecords);
        this.consume(this.sourceCluster());
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        String jaasConfig = this.connectingCluster().adminZkClient().fetchClusterLinkConfig(linkId).getProperty("sasl.jaas.config");
        Assertions.assertNotNull((Object)jaasConfig);
        Assertions.assertFalse((boolean)jaasConfig.contains("secret-"), (String)new StringBuilder(24).append("Password not encrypted: ").append(jaasConfig).toString());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testMirrorExistingRecords() {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(numRecords);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigSync() {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(numRecords);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyTopicConfigChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListDescribeMirror() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.sourceCluster().listMirrorTopics(this.sourceCluster().listMirrorTopics$default$1()));
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()));
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(this.topic());
        Assertions.assertEquals((Object)this.linkName(), (Object)desc.linkName());
        Assertions.assertEquals((Object)this.topic(), (Object)desc.mirrorTopic());
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)desc.state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        Assertions.assertEquals((Object)this.destCluster().describeMirrorTopic(this.topic()).state(), (Object)MirrorTopicDescription.State.PENDING_STOPPED);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(true));
        Assertions.assertEquals((Object)this.destCluster().describeMirrorTopic(this.topic()).state(), (Object)MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.destCluster().listMirrorTopics(true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().describeMirrorTopic(this.topic()));
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()));
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.destCluster().pauseTopic(this.topic(), true);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.destCluster().deleteClusterLink(this.linkName(), true, this.destCluster().deleteClusterLink$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testSourceClusterQuota() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp()), (Object)"100")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        ConfluentAdmin sourceAdmin = this.sourceCluster().createAdminClient(this.sourceCluster().createAdminClient$default$1());
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> this.setQuota$1(byteRate, sourceAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.throttled$1(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
    }

    @Test
    public void testDestinationClusterLinkQuota() {
        .colon.colon resources = new .colon.colon((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (List)Nil$.MODULE$);
        UUID linkId = this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND);
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)None$.MODULE$);
        ConfluentAdmin destAdmin = this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1());
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.fetch.response.total.bytes", "10000"), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)new Some((Object)new FetchResponseSize(5000, 10000)));
    }

    @Test
    public void testDestinationClusterLinkBrokerLevelQuota() {
        Seq resources = ((SeqLike)((TraversableLike)this.destCluster().servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$1(x$7)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)brokerId -> ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$2(BoxesRunTime.unboxToInt((Object)brokerId)), Buffer$.MODULE$.canBuildFrom())).toSeq();
        this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY);
    }

    /*
     * WARNING - void declaration
     */
    public UUID verifyDestinationClusterLinkQuota(Seq<ConfigResource> resources, ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        void var3_3;
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        ConfluentAdmin destAdmin = this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1());
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> ClusterLinkIntegrationTest.setQuota$2(byteRate, resources, destAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), true);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyQuotaMode(quotaMode);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void verifyQuotaMode(ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        ConfluentAdmin admin = this.sourceCluster().createAdminClient(this.sourceCluster().createAdminClient$default$1());
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        AlterConfigOp alterProduceQuotaOp = new AlterConfigOp(new ConfigEntry("producer_byte_rate", "100000"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp, alterProduceQuotaOp}))).asJavaCollection());
        admin.incrementalAlterConfigs(configs).all().get();
        KafkaServer broker = this.sourceCluster().partitionLeader(new TopicPartition(this.topic(), 0));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$1(broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$3(broker, quotaMode)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(20);
        this.verifyClusterLinkQuotaMetrics((Seq<KafkaServer>)new .colon.colon((Object)broker, (List)Nil$.MODULE$), quotaMode.equals(ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND));
    }

    private boolean destClusterLinkReplicasThrottled() {
        return this.yammerMetricMaxValue("kafka.server:type=ReplicaManager,name=ThrottledClusterLinkReplicasPerSec", (Option<String>)None$.MODULE$) > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFetchResponseSize(UUID linkId, Option<FetchResponseSize> expectedSize) {
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)((IterableLike)((TraversableLike)this.destCluster().servers().map((Function1 & Serializable & scala.Serializable)x$10 -> (ClusterLinkFetcherManager)x$10.clusterLinkManager().fetcherManager(linkId).get(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$2(x$11)))).head();
        ClusterLinkFetcherThread fetcherThread = (ClusterLinkFetcherThread)((HashMap)TestUtils.fieldValue((Object)fetcherManager, AbstractFetcherManager.class, (String)"fetcherThreadMap")).values().head();
        Object expectedFetchSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.perPartitionSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchMaxBytes());
        Object expectedFetchResponseSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.responseSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchResponseMaxBytes());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchSize$1(fetcherThread);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$8(expectedFetchSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchSize$1(fetcherThread)));
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThread);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$10(expectedFetchResponseSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchResponseSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThread)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDestinationClusterLinkQuotaWithBrokerRestart() {
        void var7_7;
        void var6_6;
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        ConfluentAdmin destAdmin = this.destCluster().createAdminClient(this.destCluster().createAdminClient$default$1());
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), "100"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection());
        destAdmin.incrementalAlterConfigs(configs).all().get();
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int oldLeaderId = tuple2._1$mcI$sp();
        int oldLeaderEpoch = tuple2._2$mcI$sp();
        this.destCluster().waitForLeaderChange(tp, (int)var6_6, (int)var7_7);
        this.destCluster().startBroker((int)var6_6);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(destAdmin, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$2(this, tp, (int)var6_6)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().updateBootstrapServers();
        this.produceUntil(this.sourceCluster().createProducer(this.sourceCluster().createProducer$default$1(), this.sourceCluster().createProducer$default$2(), this.sourceCluster().createProducer$default$3()), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), "Destination quota not applied after broker restart");
    }

    @Test
    public void testDestinationLagLinkFetcherThrottle() {
        this.numPartitions_$eq(2);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-2")}))), this.destCluster().alterClusterLink$default$3());
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()) == 0.0 ? 1 : 0) != 0);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-1")}))), this.destCluster().alterClusterLink$default$3());
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()) == 0.0 ? 1 : 0) != 0);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"10485760")}))), this.destCluster().alterClusterLink$default$3());
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()) == 0.0 ? 1 : 0) != 0);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"0")}))), this.destCluster().alterClusterLink$default$3());
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "link-fetcher-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddPartitions() {
        void var2_8;
        Tuple2 tuple2;
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.numPartitions_$eq(4);
        this.sourceCluster().createPartitions(this.topic(), this.numPartitions());
        this.produceToSourceCluster(8);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testAddPartitions$1(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAddPartitions$2(this, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)this.numPartitions(), (int)var2_8);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAddPartitionMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterClusterLinkConfigs() {
        void var11_17;
        Tuple2 tuple2;
        ClusterLinkTestHarness connectingCluster;
        this.numPartitions_$eq(8);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.sourceLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness clusterLinkTestHarness = connectingCluster = super.connectingCluster();
        ClusterLinkTestHarness clusterLinkTestHarness2 = this.destCluster();
        ClusterLinkTestHarness otherCluster = !(clusterLinkTestHarness != null ? !clusterLinkTestHarness.equals(clusterLinkTestHarness2) : clusterLinkTestHarness2 != null) ? this.sourceCluster() : this.destCluster();
        String metadataMaxAge = "60000";
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)metadataMaxAge)}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertEquals((Object)metadataMaxAge, (Object)connectingCluster.describeClusterLink(this.linkName()).get("metadata.max.age.ms").value());
        otherCluster.servers().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            x$18.shutdown();
            return BoxedUnit.UNIT;
        });
        otherCluster.servers().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            x$19.startup();
            return BoxedUnit.UNIT;
        });
        otherCluster.updateBootstrapServers();
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)otherCluster.brokerList())}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"SOURCE")}))), this.destCluster().alterClusterLink$default$3()));
        Assertions.assertThrows(InvalidRequestException.class, () -> connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConnectionModeProp()), (Object)"INBOUND")}))), connectingCluster.alterClusterLink$default$3()));
        Assertions.assertEquals((Object)LinkMode.Destination$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().linkMode());
        Assertions.assertEquals((Object)ConnectionMode.Outbound$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)connectingCluster.servers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().connectionMode());
        String trustStoreConfigName = this.useSourceInitiatedLink() ? new StringBuilder(23).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.location").toString() : "ssl.truststore.location";
        File oldFile = new File(connectingCluster.describeClusterLink(this.linkName()).get(trustStoreConfigName).value());
        File newFile = File.createTempFile("truststore", ".jks");
        Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trustStoreConfigName), (Object)newFile.getAbsolutePath())}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        int firstBroker = ((KafkaServer)this.destCluster().servers().head()).config().brokerId();
        scala.collection.immutable.Map reassignment = ((TraversableOnce)((Map)this.destCluster().zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).apply((Object)this.topic())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(this.topic(), partition), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{firstBroker, BoxesRunTime.unboxToInt((Object)replicas.replicas().head())})));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.destCluster().zkClient().createPartitionReassignment((Map)reassignment);
        Assertions.assertEquals((int)1, (int)this.maxFetcherThreadCount(linkId));
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"3")}))), this.destCluster().alterClusterLink$default$3());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = this.maxFetcherThreadCount(linkId);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAlterClusterLinkConfigs$7(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int threads = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)3, (int)var11_17);
        this.produceToSourceCluster(8);
        this.consume(this.destCluster());
    }

    @Test
    public void testOffsetMigrationWithAddedConsumerGroup() {
        long finalOffset = 20L;
        String additionalConsumerGroup = "testGroup2";
        String multiConsumerGroupFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"groupFilters\": [\n          |  {\n          |     \"name\": \"").append(this.consumerGroup()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(additionalConsumerGroup).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, this.offsetToCommit(), this.syncPeriod() * 4L, this.consumerGroup());
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)multiConsumerGroupFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)updatedProps, this.destCluster().alterClusterLink$default$3());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, additionalConsumerGroup);
        this.verifyOffsetMigration(this.topic(), 0, finalOffset, this.syncPeriod() * 4L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, finalOffset, this.syncPeriod() * 4L, additionalConsumerGroup);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testOffsetMigrationWithAddedTopic() {
        long finalOffset = 20L;
        String additionalTopic = "linkedTopic2";
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.sourceCluster().createTopic(additionalTopic, this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, this.offsetToCommit(), this.syncPeriod() * 4L, this.consumerGroup());
        this.destCluster().linkTopic(additionalTopic, (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), additionalTopic, 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, finalOffset, this.syncPeriod() * 4L, this.consumerGroup());
        this.verifyOffsetMigration(additionalTopic, 0, finalOffset, this.syncPeriod() * 4L, this.consumerGroup());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), false, this.destCluster().unlinkTopic$default$4());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter(this.consumerGroup()).replaceAll("include", "exclude"))}))));
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", this.consumerGroup());
        ByteArrayDeserializer x$2 = this.destCluster().createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.destCluster().createConsumer$default$2();
        List<String> x$4 = this.destCluster().createConsumer$default$4();
        KafkaConsumer destConsumer = this.destCluster().createConsumer(x$2, x$3, consumerProps, x$4);
        destConsumer.subscribe(Collections.singleton(additionalTopic));
        do {
            destConsumer.poll(Duration.ofMillis(10L));
        } while (destConsumer.assignment().isEmpty());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> destConsumer.poll(Duration.ofMillis(10L)));
        try {
            this.destCluster().unlinkTopic(additionalTopic, this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
            this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, additionalTopic);
        }
        finally {
            executor.shutdownNow();
        }
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testDestReadOnly() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        KafkaProducer destProducer = this.destCluster().createProducer(this.destCluster().createProducer$default$1(), this.destCluster().createProducer$default$2(), this.destCluster().createProducer$default$3());
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> destProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes())).get(15L, TimeUnit.SECONDS))).getCause() instanceof InvalidRequestException));
        Assertions.assertThrows(InvalidPartitionsException.class, () -> this.destCluster().createPartitions(this.topic(), 8));
        this.destCluster().withAdmin((Function1 & Serializable & scala.Serializable)admin -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$3(this, admin);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        this.produceRecords(destProducer, this.topic(), 10, this.produceRecords$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testDeleteClusterLinkCleanup() {
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        scala.collection.immutable.Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkIntegrationTest.$anonfun$testDeleteClusterLinkCleanup$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.sourceCluster().createTopic((String)topic, this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
            return this.destCluster().linkTopic((String)topic, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        });
        Assertions.assertEquals((int)topics.size(), (int)this.destCluster().zkClient().getClusterLinkForTopics(topics).size());
        ClusterLinkInUseException e = (ClusterLinkInUseException)Assertions.assertThrows(ClusterLinkInUseException.class, () -> this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3()));
        Assertions.assertEquals((Object)new StringBuilder(46).append("Cluster link '").append(this.linkName()).append("' with ID '").append(linkId).append("' in used by topics: ").append(topics.mkString(", ")).toString(), (Object)e.getMessage());
        this.destCluster().deleteClusterLink(this.linkName(), true, this.destCluster().deleteClusterLink$default$3());
        Assertions.assertTrue((boolean)this.destCluster().zkClient().getClusterLinkForTopics(topics).isEmpty());
        Assertions.assertTrue((boolean)this.destCluster().zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString()).isEmpty());
    }

    @Test
    public void testMirroredTopicMarkedForDelete() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        int brokerId = this.destCluster().shutdownLeader((TopicPartition)partitions.head())._1$mcI$sp();
        Buffer otherBrokers = (Buffer)this.destCluster().servers().filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$2(brokerId, x$21)));
        this.destCluster().deleteTopic(this.topic(), false);
        otherBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$3(partitions, linkId, broker);
            return BoxedUnit.UNIT;
        });
        String x$1 = this.linkName();
        boolean x$3 = this.destCluster().deleteClusterLink$default$2();
        this.destCluster().deleteClusterLink(x$1, x$3, (Buffer<KafkaServer>)otherBrokers);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPauseTopic() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().pauseTopic(this.topic(), this.destCluster().pauseTopic$default$2()));
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.destCluster().pauseTopic(this.topic(), this.destCluster().pauseTopic$default$2());
        this.destCluster().pauseTopic(this.topic(), this.destCluster().pauseTopic$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testPauseTopic$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyMirrorTopicCountMetric("mirror-topic-count", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)"PausedMirror")}))), this.verifyMirrorTopicCountMetric$default$3(), this.verifyMirrorTopicCountMetric$default$4());
        Seq oldLeaderOffsets = this.leaderOffsets$1();
        this.produceToSourceCluster(8);
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)oldLeaderOffsets, (Object)this.leaderOffsets$1());
        this.destCluster().pauseTopic(this.topic(), false);
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)((ReplicaStatus.MirrorInfo)((ReplicaStatus)((IterableLike)this.destCluster().replicaStatus(this.topic(), partition, this.destCluster().replicaStatus$default$3()).filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.isLeader()))).head()).mirrorInfo().get()).state()));
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.destCluster().pauseTopic(this.topic(), this.destCluster().pauseTopic$default$2()));
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPauseClusterLink() {
        void var10_22;
        Tuple2 tuple2;
        void var9_15;
        Tuple2 tuple22;
        int oldNumPartitions = this.numPartitions();
        String oldDeleteRetentionMs = "10000";
        int oldOffset = 10;
        this.sourceCluster().createTopic(this.topic(), oldNumPartitions, this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)oldDeleteRetentionMs)}))));
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty("metadata.max.age.ms", "100");
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, oldOffset, 1000L, this.consumerGroup());
        this.verifyConsumerOffsetMigrationMetrics();
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        int newNumPartitions = oldNumPartitions + 2;
        String newDeleteRetentionMs = "20000";
        int newOffset = 20;
        this.sourceCluster().createPartitions(this.topic(), newNumPartitions);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)newDeleteRetentionMs)}))));
        this.produceToSourceCluster(8);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyPausedLinkMetrics();
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.destCluster().pauseTopic(this.topic(), this.destCluster().pauseTopic$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        Assertions.assertThrows(ClusterLinkPausedException.class, () -> this.destCluster().linkTopic("paused-topic", this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4()));
        Thread.sleep(250L);
        Assertions.assertEquals((int)oldNumPartitions, (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Assertions.assertEquals((Object)oldDeleteRetentionMs, (Object)this.destCluster().describeTopicConfig(this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value());
        Assertions.assertEquals((long)oldOffset, (long)this.destCluster().getOffset(this.topic(), 0, this.consumerGroup()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$2(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$3(newNumPartitions, n)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)newNumPartitions, (int)var9_15);
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            String computeUntilTrue_result;
            String string;
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs, string = (computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$4(this)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String destDeleteRetentionMs = (String)tuple2._1();
        Assertions.assertEquals((Object)newDeleteRetentionMs, (Object)var10_22);
        this.verifyOffsetMigration(this.topic(), 0, newOffset, 1000L, this.consumerGroup());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testReplicaStatus() {
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        rs1 = this.sourceCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)2, (int)rs1.size());
        leader1 = (ReplicaStatus)((IterableLike)rs1.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$1$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)leader1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)leader1.mirrorInfo());
        follower1 = (ReplicaStatus)((IterableLike)rs1.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$2$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)follower1.mirrorInfo());
        timestamp = Time.SYSTEM.milliseconds();
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        var27_5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var25_6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs2 = this.destCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)4, (int)rs2.size());
        localLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$5$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)localLeader2.mirrorInfo().isPresent());
        mi2 = (ReplicaStatus.MirrorInfo)localLeader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi2.state());
        Assertions.assertTrue((boolean)(timestamp <= mi2.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(timestamp).append(" <= ").append(mi2.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)numRecords, (long)mi2.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        localFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$6$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)localFollower2.mirrorInfo());
        remoteLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$7$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteLeader2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteLeader2.mirrorInfo());
        remoteFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$8$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteFollower2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteFollower2.mirrorInfo());
        lastFetchTimeMs = mi2.lastFetchTimeMs();
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs3 = this.destCluster().replicaStatus(this.topic(), 0, false);
        Assertions.assertEquals((int)2, (int)rs3.size());
        leader3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$9$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader3.mirrorInfo().isPresent());
        mi3 = (ReplicaStatus.MirrorInfo)leader3.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi3.state());
        Assertions.assertTrue((boolean)(lastFetchTimeMs <= mi3.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(lastFetchTimeMs).append(" <= ").append(mi3.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)(numRecords * 2), (long)mi3.lastFetchSourceHighWatermark());
        follower3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$10$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower3.mirrorInfo());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        rs4 = ObjectRef.create(null);
        var33_21 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var31_22 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$11(this, rs4)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leader4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$13$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader4.mirrorInfo().isPresent());
        mi4 = (ReplicaStatus.MirrorInfo)leader4.mirrorInfo().get();
        v0 = mi4.state();
        var22_26 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        if (!(v0 == null ? var22_26 != null : v0.equals(var22_26) == false)) ** GOTO lbl-1000
        v1 = mi4.state();
        var23_27 = ReplicaStatus.MirrorInfo.State.STOPPED;
        if (!(v1 != null ? v1.equals(var23_27) == false : var23_27 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchTimeMs());
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        follower4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$14$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower4.mirrorInfo());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoMirroring() {
        this.autoMirrorTopic(this.syncPeriod());
        String newTopic = new StringBuilder(2).append(this.topic()).append("-2").toString();
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}))), this.destCluster().alterClusterLink$default$3());
        this.sourceCluster().createTopic(String.valueOf(newTopic), this.sourceCluster().createTopic$default$2(), this.sourceCluster().createTopic$default$3(), this.sourceCluster().createTopic$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroring$1(this, newTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroring$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(newTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter)}))), this.destCluster().alterClusterLink$default$3());
        this.destCluster().deleteTopic(newTopic, this.destCluster().deleteTopic$default$2());
        Thread.sleep(1000L);
        Assertions.assertFalse((boolean)this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()).contains((Object)newTopic));
        String conflictingTopic = new StringBuilder(9).append(this.topic()).append("-conflict").toString();
        this.destCluster().createTopic(conflictingTopic, this.destCluster().createTopic$default$2(), this.destCluster().createTopic$default$3(), this.destCluster().createTopic$default$4());
        this.sourceCluster().createTopic(conflictingTopic, this.sourceCluster().createTopic$default$2(), this.sourceCluster().createTopic$default$3(), this.sourceCluster().createTopic$default$4());
        this.destCluster().deleteTopic(conflictingTopic, false);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroring$3(this, conflictingTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroring$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().unlinkTopic(conflictingTopic, this.linkName(), false, this.destCluster().unlinkTopic$default$4());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private void autoMirrorTopic(long syncPeriod) {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), Long.toString(syncPeriod * 10L));
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = syncPeriod * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$autoMirrorTopic$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$autoMirrorTopic$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAutoMirroringSuccessMetric();
    }

    private Properties destLinkPropsForAutoMirroring(String topicFilters) {
        scala.collection.mutable.Map autoMirrorOverrides = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)topicFilters);
        autoMirrorOverrides.put((Object)"metadata.max.age.ms", (Object)Long.toString(this.syncPeriod()));
        return this.destLinkProps((Map<String, String>)autoMirrorOverrides);
    }

    @Test
    public void testLastFetchedOffsetPromotedMirrorTopicDescription() {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(this.testLastFetchedOffsetStoppedMirrorTopicDescription$default$1());
    }

    @Test
    public void testLastFetchedOffsetFailedOverMirrorTopicDescription() {
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(false);
    }

    @Test
    public void testAutoMirroringNoOverlappingTopicFilters() {
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        Properties linkPropsTwo = this.destLinkPropsForAutoMirroring(this.includeAllTopicsFilter());
        UUID linkIdTwo = this.createClusterLink(linkNameTwo, linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().alterClusterLink(linkNameTwo, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3()));
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
        if (this.useSourceInitiatedLink()) {
            this.sourceCluster().deleteClusterLink(this.linkName(), this.sourceCluster().deleteClusterLink$default$2(), this.sourceCluster().deleteClusterLink$default$3());
            Assertions.assertTrue((this.sourceCluster().listClusterLinks(this.sourceCluster().listClusterLinks$default$1()).size() == 1 ? 1 : 0) != 0);
        }
        this.destCluster().alterClusterLink(linkNameTwo, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.destCluster().alterClusterLink(linkNameTwo, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.createClusterLink(this.linkName(), linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().alterClusterLink(linkNameTwo, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}))), this.destCluster().alterClusterLink$default$3());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
        this.destCluster().deleteClusterLink(linkNameTwo, this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoMirroringAllowsLinkConfigUpdate() {
        int numRecords = 20;
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(numRecords);
        Properties linkPropsOne = this.destLinkPropsForAutoMirroring(this.topicFilter());
        this.createClusterLink(this.linkName(), linkPropsOne, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))), this.destCluster().alterClusterLink$default$3());
        String topicTwo = "linkedTopicTwo";
        this.sourceCluster().createTopic(topicTwo, this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(numRecords);
        ObjectRef linkPropsTwo = ObjectRef.create((Object)this.destLinkPropsForAutoMirroring(this.topicFilter()));
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo$1.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        linkPropsTwo.elem = this.destLinkPropsForAutoMirroring(topicFilterTwo);
        this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$6(this, topicTwo)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAllowsLinkConfigUpdate$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))), this.destCluster().alterClusterLink$default$3());
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, x$3);
        boolean x$7 = false;
        boolean x$8 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(topicTwo, linkNameTwo, x$8, x$7);
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
        this.destCluster().deleteClusterLink(linkNameTwo, this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoMirroringUpdateExistingLink() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)Long.toString(this.syncPeriod()))}))));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.destCluster().createTopic$default$4());
        scala.collection.mutable.Map autoMirrorProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)this.topicFilter());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)autoMirrorProps, this.destCluster().alterClusterLink$default$3()));
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)autoMirrorProps, this.destCluster().alterClusterLink$default$3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringUpdateExistingLink$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringUpdateExistingLink$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, x$3);
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoMirroringAddingAdditionalTopic() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAddingAdditionalTopic$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAddingAdditionalTopic$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String topicTwo = "linkedTopic2";
        this.sourceCluster().createTopic(topicTwo, this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilterTwo)}))), this.destCluster().alterClusterLink$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAddingAdditionalTopic$3(this, topicTwo)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testAutoMirroringAddingAdditionalTopic$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), false, false);
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(topicTwo, x$2, x$4, x$3);
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    @Test
    public void testAutoMirroringNoExistingTopic() {
        this.destCluster().createTopic(this.topic(), this.destCluster().createTopic$default$2(), this.destCluster().createTopic$default$3(), this.destCluster().createTopic$default$4());
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3()));
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}))), this.destCluster().alterClusterLink$default$3());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().servers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private void testLastFetchedOffsetStoppedMirrorTopicDescription(boolean promote) {
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ReplicaStatus leader = (ReplicaStatus)((IterableLike)this.destCluster().replicaStatus(this.topic(), 0, this.destCluster().replicaStatus$default$3()).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(rs)))).head();
        Assertions.assertTrue((boolean)leader.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi.state());
        Assertions.assertEquals((long)numRecords, (long)mi.lastFetchSourceHighWatermark());
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, promote);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        ReplicaStatus leader2 = (ReplicaStatus)((IterableLike)this.destCluster().replicaStatus(this.topic(), 0, this.destCluster().replicaStatus$default$3()).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(rs)))).head();
        Assertions.assertTrue((boolean)leader2.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi2 = (ReplicaStatus.MirrorInfo)leader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.STOPPED, (Object)mi2.state());
        Assertions.assertEquals((long)-1L, (long)mi2.lastFetchSourceHighWatermark());
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(this.topic());
        Assertions.assertEquals((Object)desc.state(), (Object)MirrorTopicDescription.State.STOPPED);
        Assertions.assertEquals((int)1, (int)desc.stoppedLogEndOffsets().size());
        Assertions.assertEquals((long)numRecords, (long)Predef$.MODULE$.Long2long((Long)desc.stoppedLogEndOffsets().get(0)));
    }

    private boolean testLastFetchedOffsetStoppedMirrorTopicDescription$default$1() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAutoMirroredTopics() {
        this.autoMirrorTopic(this.syncPeriod());
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(this.topic(), false));
        Assertions.assertTrue((boolean)this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()).contains((Object)this.topic()));
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.destCluster().deleteTopic(this.topic(), false);
        Assertions.assertFalse((boolean)this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()).contains((Object)this.topic()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testDeleteAutoMirroredTopics$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testDeleteAutoMirroredTopics$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), this.sourceCluster().deleteTopic$default$2());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.FAILED, this.waitUntilMirrorState$default$2());
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.produceToSourceCluster(20);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testDeleteAutoMirroredTopics$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testDeleteAutoMirroredTopics$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}));
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)updatedProps, this.destCluster().alterClusterLink$default$3());
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        Assertions.assertFalse((boolean)this.destCluster().listMirrorTopics(this.destCluster().listMirrorTopics$default$1()).contains((Object)this.topic()));
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIntervalChangeForPeriodicTasks() {
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        linkProps.setProperty("metadata.max.age.ms", String.valueOf(300000));
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), 2, this.sourceCluster().createTopic$default$4());
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), this.destCluster().linkTopic$default$4());
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyTopicConfigChangeMetrics();
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        this.verifyOffsetMigration(this.topic(), 0, this.offsetToCommit(), this.syncPeriod() * 4L, this.consumerGroup());
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}))));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.syncPeriod() * 4L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}))));
        this.destCluster().unlinkTopic(this.topic(), this.linkName(), this.destCluster().unlinkTopic$default$3(), this.destCluster().unlinkTopic$default$4());
        this.destCluster().deleteClusterLink(this.linkName(), this.destCluster().deleteClusterLink$default$2(), this.destCluster().deleteClusterLink$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMirrorFailoverWhenSourceIsUnavailable() {
        this.numPartitions_$eq(1);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        this.updateCredentials(connectionTarget);
        this.waitUntilOneOfMirrorStates((scala.collection.immutable.Set<ReplicaStatus.MirrorInfo.State>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.SOURCE_AUTHENTICATION_FAILED, ReplicaStatus.MirrorInfo.State.SOURCE_UNAVAILABLE}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = this.destCluster().unlinkTopic$default$3();
        this.destCluster().unlinkTopic(x$1, x$2, x$4, x$3);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$1) {
        String string = x$1.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionsWithMirrorTopic$2(ClusterLinkIntegrationTest $this) {
        return ((SeqLike)$this.partitions().flatMap((Function1 & Serializable & scala.Serializable)tp -> (Buffer)((TraversableLike)$this.destCluster().servers().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(x$2.replicaManager().onlinePartition(tp)), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.linkedUpdatesOnly())), Seq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionsWithMirrorTopic$6() {
        return "Mirror not stopped";
    }

    private final void restartMirrorTopic$1() {
        this.destCluster().deleteTopic(this.topic(), this.destCluster().deleteTopic$default$2());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
    }

    private final void restartSource$1() {
        this.sourceCluster().restartDeadBrokers(this.sourceCluster().restartDeadBrokers$default$1());
        this.sourceCluster().updateBootstrapServers();
        if (!this.useSourceInitiatedLink()) {
            this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.sourceCluster().brokerList())}))), this.destCluster().alterClusterLink$default$3());
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$4) {
        String string = x$4.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$2(ClusterLinkIntegrationTest $this, ClusterLinkListing x$5) {
        String string = x$5.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSync$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSync$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$1(ClusterLinkIntegrationTest $this) {
        MirrorTopicDescription.State state = $this.destCluster().describeMirrorTopic($this.topic()).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$2() {
        return "Mirror took too long to stop.";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics(true).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$5() {
        return "Mirror state not removed";
    }

    private final void setQuota$1(long byteRate, ConfluentAdmin sourceAdmin$1) {
        ClientQuotaEntity quotaUser = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)this.linkUserName(this.linkName()))}))).asJava());
        ClientQuotaAlteration.Op quotaOp = new ClientQuotaAlteration.Op(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), Predef$.MODULE$.double2Double((double)byteRate));
        ClientQuotaAlteration quota = new ClientQuotaAlteration(quotaUser, Collections.singleton(quotaOp));
        sourceAdmin$1.alterClientQuotas(Collections.singleton(quota)).all().get(15L, TimeUnit.SECONDS);
    }

    private final boolean throttled$1() {
        return this.kafkaMetricMaxValue((Seq<KafkaServer>)this.destCluster().servers(), "fetch-throttle-time-max", "cluster-link", (Option<String>)new Some((Object)this.linkName()), this.kafkaMetricMaxValue$default$5(), this.kafkaMetricMaxValue$default$6()) > 0.0;
    }

    public static final /* synthetic */ int $anonfun$testDestinationClusterLinkBrokerLevelQuota$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ ConfigResource $anonfun$testDestinationClusterLinkBrokerLevelQuota$2(int brokerId) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId));
    }

    private static final void setQuota$2(long byteRate, Seq resources$1, ConfluentAdmin destAdmin$1) {
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), Long.toString(byteRate)), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources$1.map((Function1 & Serializable & scala.Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$9), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin$1.incrementalAlterConfigs(configs).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$verifyQuotaMode$1(KafkaServer broker$1) {
        return broker$1.quotaManagers().produce().quotasEnabled();
    }

    public static final /* synthetic */ String $anonfun$verifyQuotaMode$2() {
        return "Produce quota not enabled";
    }

    public static final /* synthetic */ boolean $anonfun$verifyQuotaMode$3(KafkaServer broker$1, ConfluentConfigs.ClusterLinkQuotaMode quotaMode$1) {
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = broker$1.config().clusterLinkQuotaMode();
        return !(clusterLinkQuotaMode != null ? !clusterLinkQuotaMode.equals(quotaMode$1) : quotaMode$1 != null);
    }

    public static final /* synthetic */ String $anonfun$verifyQuotaMode$4() {
        return "Quota mode not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$2(ClusterLinkFetcherManager x$11) {
        return x$11.fetcherThreadCount() > 0;
    }

    private static final int fetchSize$1(ClusterLinkFetcherThread fetcherThread$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)fetcherThread$1, ReplicaFetcherThread.class, (String)"fetchSize"));
    }

    private static final int fetchResponseSize$1(ClusterLinkFetcherThread fetcherThread$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)fetcherThread$1, ClusterLinkFetcherThread.class, (String)"fetchResponseSize"));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$8(Object expectedFetchSize$1, int x$14) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$14), (Object)expectedFetchSize$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$10(Object expectedFetchResponseSize$1, int x$15) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$15), (Object)expectedFetchResponseSize$1);
    }

    public static final /* synthetic */ void $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(ConfluentAdmin destAdmin$2, TopicPartition tp$2) {
        try {
            destAdmin$2.electLeaders(ElectionType.PREFERRED, Collections.singleton(tp$2)).all().get(15L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Preferred leader election failed");
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$2(ClusterLinkIntegrationTest $this, TopicPartition tp$2, int oldLeaderId$1) {
        Option option = Option$.MODULE$.apply((Object)$this.destCluster().partitionLeader(tp$2));
        Option<KafkaServer> option2 = $this.destCluster().serverForId(oldLeaderId$1);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$3() {
        return "Preferred leader not elected";
    }

    public static final /* synthetic */ int $anonfun$testAddPartitions$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic($this.topic()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitions$2(ClusterLinkIntegrationTest $this, int x$17) {
        return x$17 == $this.numPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterClusterLinkConfigs$7(int x$20) {
        return x$20 == 3;
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$4(ConfluentAdmin admin$1, ConfigResource resource$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            AlterConfigOp alterConfigOp;
            boolean expectSuccess;
            String name = (String)x0$1._1();
            Option value = (Option)x0$1._2();
            String string = name;
            String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (expectSuccess = false);
            if (value instanceof Some) {
                String v = (String)((Some)value).value();
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, v), AlterConfigOp.OpType.SET);
            } else if (None$.MODULE$.equals(value)) {
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, null), AlterConfigOp.OpType.DELETE);
            } else {
                throw new MatchError((Object)value);
            }
            try {
                Set<AlterConfigOp> ops = Collections.singleton(alterConfigOp);
                admin$1.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource$1), ops)}))).asJava()).all().get();
                Assertions.assertTrue((boolean)expectSuccess);
                return;
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidConfigurationException));
                Assertions.assertFalse((boolean)expectSuccess);
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$3(ClusterLinkIntegrationTest $this, ConfluentAdmin admin) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, $this.topic());
        try {
            admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.empty()).asJavaCollection()))}))).asJava()).all().get(20L, TimeUnit.SECONDS);
            Assertions.fail((String)"alterConfigs() on a mirror topic should fail");
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidRequestException));
        }
        new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)new Some((Object)"true")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)None$.MODULE$), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)new Some((Object)"compact")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)None$.MODULE$), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$4(admin, resource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLinkCleanup$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirroredTopicMarkedForDelete$1(ClusterLinkIntegrationTest $this, int i) {
        return new TopicPartition($this.topic(), i);
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$2(int brokerId$1, KafkaServer x$21) {
        return x$21.config().brokerId() != brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$4(IndexedSeq partitions$1, KafkaServer broker$2) {
        return ((SeqLike)partitions$1.flatMap((Function1 & Serializable & scala.Serializable)tp -> Option$.MODULE$.option2Iterable(broker$2.replicaManager().onlinePartition(tp)), IndexedSeq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$6() {
        return "Partitions not offline after topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$7(KafkaServer broker$2, UUID linkId$3) {
        return ((ClusterLinkFetcherManager)broker$2.clusterLinkManager().fetcherManager(linkId$3).get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$8() {
        return "Fetcher manager not empty after topic deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMirroredTopicMarkedForDelete$3(IndexedSeq partitions$1, UUID linkId$3, KafkaServer broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$4(partitions$1, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$7(broker, linkId$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$5(ReplicaStatus.MirrorInfo mi) {
        ReplicaStatus.MirrorInfo.State state = mi.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PAUSED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$2(ClusterLinkIntegrationTest $this) {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.numPartitions()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)partition -> Option$.MODULE$.apply(((ReplicaStatus)((IterableLike)$this.destCluster().replicaStatus($this.topic(), partition, $this.destCluster().replicaStatus$default$3()).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isLeader()))).head()).mirrorInfo().orElse(null)).exists((Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$5(mi))));
    }

    public static final /* synthetic */ String $anonfun$testPauseTopic$6() {
        return "Topic's partitions not paused";
    }

    private final Seq leaderOffsets$1() {
        return ((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)partition -> ((ReplicaStatus)((IterableLike)this.destCluster().replicaStatus(this.topic(), partition, this.destCluster().replicaStatus$default$3()).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isLeader()))).head()).logEndOffset(), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ int $anonfun$testPauseClusterLink$2(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic($this.topic()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$3(int newNumPartitions$1, int x$25) {
        return x$25 == newNumPartitions$1;
    }

    public static final /* synthetic */ String $anonfun$testPauseClusterLink$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$5(String newDeleteRetentionMs$1, String x$26) {
        String string = x$26;
        return !(string != null ? !string.equals(newDeleteRetentionMs$1) : newDeleteRetentionMs$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$3(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= 1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$4() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$5(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$6(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$7(ReplicaStatus rs) {
        return rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$8(ReplicaStatus rs) {
        return !rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$9(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$10(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$11(ClusterLinkIntegrationTest $this, ObjectRef rs4$1) {
        rs4$1.elem = $this.destCluster().replicaStatus($this.topic(), 0, true);
        return ((Seq)rs4$1.elem).size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$12() {
        return "Cluster link not removed from topic's partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$13(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$14(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroring$1(ClusterLinkIntegrationTest $this, String newTopic$1) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)newTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroring$2() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroring$3(ClusterLinkIntegrationTest $this, String conflictingTopic$1) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)conflictingTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroring$4() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$autoMirrorTopic$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$autoMirrorTopic$2() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringAllowsLinkConfigUpdate$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringAllowsLinkConfigUpdate$2() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringAllowsLinkConfigUpdate$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringAllowsLinkConfigUpdate$5() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringAllowsLinkConfigUpdate$6(ClusterLinkIntegrationTest $this, String topicTwo$1) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)topicTwo$1);
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringAllowsLinkConfigUpdate$7() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringUpdateExistingLink$2(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringUpdateExistingLink$3() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringAddingAdditionalTopic$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringAddingAdditionalTopic$2() {
        return "Source topic not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testAutoMirroringAddingAdditionalTopic$3(ClusterLinkIntegrationTest $this, String topicTwo$2) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)topicTwo$2);
    }

    public static final /* synthetic */ String $anonfun$testAutoMirroringAddingAdditionalTopic$4() {
        return "Source topic not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= 1;
    }

    public static final /* synthetic */ String $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteAutoMirroredTopics$2(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testDeleteAutoMirroredTopics$3() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteAutoMirroredTopics$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testDeleteAutoMirroredTopics$5() {
        return "Source topics not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testIntervalChangeForPeriodicTasks$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testIntervalChangeForPeriodicTasks$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testIntervalChangeForPeriodicTasks$3(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics($this.destCluster().listMirrorTopics$default$1()).contains((Object)$this.topic());
    }

    public static final /* synthetic */ String $anonfun$testIntervalChangeForPeriodicTasks$4() {
        return "Source topic not automatically mirrored.";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= 1;
    }

    public static final /* synthetic */ String $anonfun$testMirrorFailoverWhenSourceIsUnavailable$2() {
        return "Destination leader epoch not updated";
    }

    public ClusterLinkIntegrationTest() {
        this.offsetToCommit = 10L;
        this.syncPeriod = 100L;
        this.consumerGroup = "testGroup";
    }

    public static final /* synthetic */ Object $anonfun$testPauseClusterLink$5$adapted(String newDeleteRetentionMs$1, String x$26) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs$1, x$26));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$1$adapted(ReplicaStatus x$27) {
        return BoxesRunTime.boxToBoolean((boolean)x$27.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$2$adapted(ReplicaStatus x$28) {
        return BoxesRunTime.boxToBoolean((boolean)x$28.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$5$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$5(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$6$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$6(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$7$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$7(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$8$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$8(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$9$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$9(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$10$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$10(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$13$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$13(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$14$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$14(rs));
    }
}

