/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.link.MockPolicy;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.HashMap$;
import scala.reflect.ScalaSignature;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00053\u0006\u0003\u00040\u0001\u0001\u0006I\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u0011,\u0011\u0019\t\u0004\u0001)A\u0005Y!9!\u0007\u0001b\u0001\n\u0003\u001a\u0004B\u0002\u001e\u0001A\u0003%A\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\t\r\u0015\u0003\u0001\u0015!\u0003>\u0011\u001d1\u0005A1A\u0005\u0002\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%\ta\u0012\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\t\u000fE\u0003!\u0019!C\u0001\u000f\"1!\u000b\u0001Q\u0001\n!Cqa\u0015\u0001C\u0002\u0013\u0005q\t\u0003\u0004U\u0001\u0001\u0006I\u0001\u0013\u0005\u0006+\u0002!\tE\u0016\u0005\u0006O\u0002!I\u0001\u001b\u0005\b]\u0002\t\n\u0011\"\u0003p\u0011\u0015Q\b\u0001\"\u0001W\u0011\u0015y\b\u0001\"\u0001W\u0011\u0019\t\u0019\u0001\u0001C\u0001-\"1\u0011q\u0001\u0001\u0005\u0002YCa!!\u0003\u0001\t\u00031\u0006BBA\u0006\u0001\u0011\u0005a\u000b\u0003\u0004\u0002\u000e\u0001!\tA\u0016\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eU8mS\u000eLH+Z:u\u0015\tqr$\u0001\u0003mS:\\'\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\t\t\u0003I\u0015j\u0011!H\u0005\u0003Mu\u0011!%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].Le\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001*!\t!\u0003!A\u0007t_V\u00148-Z\"mkN$XM]\u000b\u0002YA\u0011A%L\u0005\u0003]u\u0011ac\u00117vgR,'\u000fT5oWR+7\u000f\u001e%be:,7o]\u0001\u000fg>,(oY3DYV\u001cH/\u001a:!\u0003-!Wm\u001d;DYV\u001cH/\u001a:\u0002\u0019\u0011,7\u000f^\"mkN$XM\u001d\u0011\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'/F\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0015\u0019\u0006n\u001c:u\u0003I\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002'Q|\u0007/[2Ts:\u001c\u0017J\u001c;feZ\fG.T:\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u0015i>\u0004\u0018nY*z]\u000eLe\u000e^3sm\u0006dWj\u001d\u0011\u00023YLw\u000e\\1uS:<\u0017\t\\<bsN\u001c\u0016P\\2D_:4\u0017nZ\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111*Q\u0001\u0005kRLG.\u0003\u0002N\u0015\nQ\u0001K]8qKJ$\u0018.Z:\u00025YLw\u000e\\1uS:<\u0017\t\\<bsN\u001c\u0016P\\2D_:4\u0017n\u001a\u0011\u0002+Y\fG.\u001b3BY^\f\u0017p]*z]\u000e\u001cuN\u001c4jO\u00061b/\u00197jI\u0006cw/Y=t'ft7mQ8oM&<\u0007%\u0001\rwS>d\u0017\r^5oO:+g/\u001a:Ts:\u001c7i\u001c8gS\u001e\f\u0011D^5pY\u0006$\u0018N\\4OKZ,'oU=oG\u000e{gNZ5hA\u0005!b/\u00197jI:+g/\u001a:Ts:\u001c7i\u001c8gS\u001e\fQC^1mS\u0012tUM^3s'ft7mQ8oM&<\u0007%A\u0003tKR,\u0006\u000fF\u0001X!\t)\u0004,\u0003\u0002Zm\t!QK\\5uQ\t\u00112\f\u0005\u0002]K6\tQL\u0003\u0002_?\u0006\u0019\u0011\r]5\u000b\u0005\u0001\f\u0017a\u00026va&$XM\u001d\u0006\u0003E\u000e\fQA[;oSRT\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000eg\u0016$X\u000b]\"mkN$XM]:\u0015\u0005]K\u0007b\u00026\u0014!\u0003\u0005\ra[\u0001\u001e_Z,'O]5eKZKw\u000e\\1uS:<7*\u00194lC\u0012+g-Y;miB\u0011Q\u0007\\\u0005\u0003[Z\u0012qAQ8pY\u0016\fg.A\ftKR,\u0006o\u00117vgR,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u0002lc.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003oZ\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\t^3ti6K'O]8s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8D_:4\u0017n\u001a)pY&\u001c\u0017pU8ve\u000e,7\t\\;ti\u0016\u0014x+\u001b;i-\u0006d\u0017\u000e\u001a#fM\u0006,H\u000e^:)\u0005Ua\bC\u0001/~\u0013\tqXL\u0001\u0003UKN$\u0018!\u0012;fgR\u001c%/Z1uK6K'O]8s'>,(oY3BY^\f\u0017p]*z]\u000e\u001cuN\u001c4jO\u000ecWo\u001d;fe2+g/\u001a7Pm\u0016\u0014(/\u001b3eK:4\u0016n\u001c7bi&|g\u000e\u000b\u0002\u0017y\u0006yD/Z:u\u0007J,\u0017\r^3NSJ\u0014xN]*pkJ\u001cW-\u00117xCf\u001c8+\u001f8d\u0007>tg-[4ICJ$7i\u001c3fI\u0012+g-Y;miZKw\u000e\\1uS>t\u0007FA\f}\u0003q2XM]5gs\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:T_V\u00148-Z!mo\u0006L8oU=oG\u000e{gNZ5h)>\u0004\u0018n\u0019'fm\u0016dwJ^3se&$G-\u001a8\u0002wY,'/\u001b4z\u0007J,\u0017\r^3NSJ\u0014xN]*pkJ\u001cWMT3wKJ\u001c\u0016P\\2D_:4\u0017n\u001a+pa&\u001cG*\u001a<fY>3XM\u001d:jI\u0012,g.\u0001\u0015wKJLg-_\"sK\u0006$X-T5se>\u0014\b+Y:tS:<g+[8mCRLgnZ\"p]\u001aLw-A\u0017wKJLg-\u001f*v]RLW.\u001a#fgRLg.\u0019;j_:\u001cuN\u001c4jO\u000eC\u0017M\\4f-&|G.\u0019;j_:Ds\u0001AA\t\u0003/\tI\u0002E\u0002]\u0003'I1!!\u0006^\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u00037\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClusterLinkPolicyTest
extends AbstractClusterLinkIntegrationTest {
    private final ClusterLinkTestHarness sourceCluster;
    private final ClusterLinkTestHarness destCluster;
    private final short replicationFactor;
    private final String topicSyncIntervalMs;
    private final Properties violatingAlwaysSyncConfig;
    private final Properties validAlwaysSyncConfig;
    private final Properties violatingNeverSyncConfig;
    private final Properties validNeverSyncConfig;

    @Override
    public ClusterLinkTestHarness sourceCluster() {
        return this.sourceCluster;
    }

    @Override
    public ClusterLinkTestHarness destCluster() {
        return this.destCluster;
    }

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    public Properties violatingAlwaysSyncConfig() {
        return this.violatingAlwaysSyncConfig;
    }

    public Properties validAlwaysSyncConfig() {
        return this.validAlwaysSyncConfig;
    }

    public Properties violatingNeverSyncConfig() {
        return this.violatingNeverSyncConfig;
    }

    public Properties validNeverSyncConfig() {
        return this.validNeverSyncConfig;
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    private void setUpClusters(boolean overrideViolatingKafkaDefault) {
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockPolicy.MockCreateTopicPolicy.class.getName());
        this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), MockPolicy.MockAlterTopicPolicy.class.getName());
        this.destCluster().serverConfig().setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), this.topicSyncIntervalMs());
        if (overrideViolatingKafkaDefault) {
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp(), "500");
        }
        super.setUp();
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
    }

    private boolean setUpClusters$default$1() {
        return true;
    }

    @Test
    public void testMirrorTopicCreationConfigPolicySourceClusterWithValidDefaults() {
        this.setUpClusters(this.setUpClusters$default$1());
        this.verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorPassingViolatingConfig();
        this.verifyRuntimeDestinationConfigChangeViolation();
    }

    @Test
    public void testCreateMirrorSourceAlwaysSyncConfigClusterLevelOverriddenViolation() {
        this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp(), "2000");
        this.setUpClusters(false);
        String topic = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topic, this.replicationFactor(), this.sourceCluster().createTopic$default$3(), this.sourceCluster().createTopic$default$4());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$1;

            public void execute() {
                this.$outer.destCluster().linkTopic(this.topic$1, this.$outer.replicationFactor(), this.$outer.linkName(), this.$outer.destCluster().linkTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (String)new StringBuilder(87).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster defaults violate the destination policy").toString());
    }

    @Test
    public void testCreateMirrorSourceAlwaysSyncConfigHardCodedDefaultViolation() {
        this.setUpClusters(false);
        String topic = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topic, this.replicationFactor(), this.sourceCluster().createTopic$default$3(), this.sourceCluster().createTopic$default$4());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$2;

            public void execute() {
                this.$outer.destCluster().linkTopic(this.topic$2, this.$outer.replicationFactor(), this.$outer.linkName(), this.$outer.destCluster().linkTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (String)new StringBuilder(98).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster hard-coded defaults violate the destination policy").toString());
    }

    public void verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden() {
        String topicWithViolatingAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topicWithViolatingAlwaysSyncConfig, this.numPartitions(), this.replicationFactor(), this.violatingAlwaysSyncConfig());
        this.sourceCluster().createTopic(topicWithValidAlwaysSyncConfig, this.numPartitions(), this.replicationFactor(), this.validAlwaysSyncConfig());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithViolatingAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithViolatingAlwaysSyncConfig$1;

            public void execute() {
                this.$outer.destCluster().linkTopic(this.topicWithViolatingAlwaysSyncConfig$1, this.$outer.replicationFactor(), this.$outer.linkName(), this.$outer.destCluster().linkTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithViolatingAlwaysSyncConfig$1 = topicWithViolatingAlwaysSyncConfig$1;
            }
        }, (String)new StringBuilder(95).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source topic config overridden violates the destination policy").toString());
        Assertions.assertDoesNotThrow(() -> this.destCluster().linkTopic(topicWithValidAlwaysSyncConfig, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4()), (String)"Mirror should not fail");
    }

    public void verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden() {
        String topicWithViolatingNeverSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topicWithViolatingNeverSyncConfig, this.numPartitions(), this.replicationFactor(), this.violatingNeverSyncConfig());
        this.sourceCluster().createTopic(topicWithValidNeverSyncConfig, this.numPartitions(), this.replicationFactor(), this.validNeverSyncConfig());
        Assertions.assertDoesNotThrow(() -> {
            this.destCluster().linkTopic(topicWithViolatingNeverSyncConfig, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
            return this.destCluster().linkTopic(topicWithValidNeverSyncConfig, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        }, (String)"Mirror should not fail");
    }

    public void verifyCreateMirrorPassingViolatingConfig() {
        String topic = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topic, this.replicationFactor(), this.sourceCluster().createTopic$default$3(), this.sourceCluster().createTopic$default$4());
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$3;

            public void execute() {
                this.$outer.destCluster().linkTopic(this.topic$3, this.$outer.replicationFactor(), this.$outer.linkName(), (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"1050")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, (String)new StringBuilder(124).append("Mirror should fail with ").append(InvalidConfigurationException.class).append(" because ").append("the config overridden passed by user during mirror creation violates the destination policy").toString());
    }

    public void verifyRuntimeDestinationConfigChangeViolation() {
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        this.sourceCluster().createTopic(topicWithValidAlwaysSyncConfig, this.numPartitions(), this.replicationFactor(), this.validAlwaysSyncConfig());
        this.sourceCluster().createTopic(topicWithValidNeverSyncConfig, this.numPartitions(), this.replicationFactor(), this.validNeverSyncConfig());
        Assertions.assertDoesNotThrow(() -> {
            this.destCluster().linkTopic(topicWithValidAlwaysSyncConfig, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
            return this.destCluster().linkTopic(topicWithValidNeverSyncConfig, this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        }, (String)"Mirror should not fail");
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"950")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(103).append("Alter config should fail with ").append(InvalidConfigurationException.class).append(" because ").append("we don't allow alternation on always-sync configs on destination").toString());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"2400")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(79).append("Alter config should fail with ").append(PolicyViolationException.class).append(" because ").append("the config value is violating the policy").toString());
        Assertions.assertDoesNotThrow((Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"1600")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)"Alter config should not fail");
    }

    public ClusterLinkPolicyTest() {
        SecurityProtocol x$1 = SecurityProtocol.SASL_SSL;
        int x$2 = 0;
        int x$3 = 1;
        Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.sourceCluster = new ClusterLinkTestHarness(x$1, x$4, x$2, x$3);
        SecurityProtocol x$5 = SecurityProtocol.SASL_PLAINTEXT;
        int x$6 = 100;
        int x$7 = 1;
        Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        this.destCluster = new ClusterLinkTestHarness(x$5, x$8, x$6, x$7);
        this.replicationFactor = 1;
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
        this.violatingAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "1050");
            }
        };
        this.validAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "950");
            }
        };
        this.violatingNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "500");
            }
        };
        this.validNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "1500");
            }
        };
    }
}

