/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0003\u0005\u0003\u0004%\u0001\u0001\u0006I!\t\u0005\bK\u0001\u0011\r\u0011\"\u0011!\u0011\u00191\u0003\u0001)A\u0005C!)q\u0005\u0001C!Q!)A\b\u0001C\u0001Q!)\u0011\t\u0001C\u0001Q!)1\t\u0001C\u0005\t\"9q\nAI\u0001\n\u0013\u0001\u0006\"B.\u0001\t\u0013A\u0003\"\u0002/\u0001\t\u0013i\u0006\"B8\u0001\t\u0013\u0001\b\"\u0002=\u0001\t\u0013I\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0005I\u0019E.^:uKJd\u0015N\\6Tg2$Vm\u001d;\u000b\u0005M!\u0012\u0001\u00027j].T\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\t!#\u0003\u0002\u001c%\t\u0011\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005e\u0001\u0011!D:pkJ\u001cWm\u00117vgR,'/F\u0001\"!\tI\"%\u0003\u0002$%\t12\t\\;ti\u0016\u0014H*\u001b8l)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\bt_V\u00148-Z\"mkN$XM\u001d\u0011\u0002\u0017\u0011,7\u000f^\"mkN$XM]\u0001\rI\u0016\u001cHo\u00117vgR,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\t1\u0001\u0007\u0005\u00022u5\t!G\u0003\u00024i\u0005\u0019\u0011\r]5\u000b\u0005U2\u0014a\u00026va&$XM\u001d\u0006\u0003oa\nQA[;oSRT\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001 i\u0016\u001cHo\u00117vgR,'\u000fT5oW^KG\u000f\u001b)f[N\u001bHn\u0015;pe\u0016\u001c\bFA\u0004?!\t\tt(\u0003\u0002Ae\t!A+Z:u\u0003q!Xm\u001d;F]\u000e\u0014\u0018\u0010\u001d;j_:\u001cVm\u0019:fiJ{G/\u0019;j_:D#\u0001\u0003 \u0002\u0019M\u001cH\u000eT5oWB\u0013x\u000e]:\u0015\u0005\u0015k\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0011)H/\u001b7\u000b\u0003)\u000bAA[1wC&\u0011Aj\u0012\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002(\n!\u0003\u0005\r!R\u0001\u000e_Z,'O]5eKB\u0013x\u000e]:\u0002-M\u001cH\u000eT5oWB\u0013x\u000e]:%I\u00164\u0017-\u001e7uIE*\u0012!\u0015\u0016\u0003\u000bJ[\u0013a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005a[\u0013AC1o]>$\u0018\r^5p]&\u0011!,\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0003<fe&4\u0017\u0010T5oW\u0006Y!M]8lKJ\u0004&o\u001c9t+\u0005q\u0006\u0003\u0002$`C2L!\u0001Y$\u0003\u000f!\u000b7\u000f['baB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z\u0016\u000e\u0003\u0015T!A\u001a\f\u0002\rq\u0012xn\u001c;?\u0013\tA7&\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015,!\tQS.\u0003\u0002oW\t1\u0011I\\=SK\u001a\fA#\u001a8d_\u0012,'oV5uQ>cGmU3de\u0016$X#A9\u0011\u0005I4X\"A:\u000b\u0005M!(BA;\u0015\u0003\u0019\u0019XM\u001d<fe&\u0011qo\u001d\u0002\u0019\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014\u0018\u0001\u00053fG>$W\rT5oW\u000e{gNZ5h)\rI#\u0010 \u0005\u0006w:\u0001\r!]\u0001\bK:\u001cw\u000eZ3s\u0011\u0015ih\u00021\u0001\u007f\u0003\u0019a\u0017N\\6JIB\u0011ai`\u0005\u0004\u0003\u00039%\u0001B+V\u0013\u0012\u000bac^1ji\u001a{'o\u00147e'\u0016\u001c'/\u001a;EK2,G/\u001a\u000b\u0004S\u0005\u001d\u0001\"B?\u0010\u0001\u0004q\u0018\u0001\u0007<fe&4\u0017pQ8oM&<\u0017I\u001a;feJ+7\u000f^1siR)\u0011&!\u0004\u0002\u0010!)Q\u0010\u0005a\u0001}\"9\u0011\u0011\u0003\tA\u0002\u0005M\u0011!C3ya\u0016\u001cGo\u00147e!\rQ\u0013QC\u0005\u0004\u0003/Y#a\u0002\"p_2,\u0017M\u001c\u0015\b\u0001\u0005m\u0011\u0011EA\u0012!\r\t\u0014QD\u0005\u0004\u0003?\u0011$a\u0001+bO\u0006)a/\u00197vK\u0006\u0012\u0011QE\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class ClusterLinkSslTest
extends AbstractClusterLinkIntegrationTest {
    private final ClusterLinkTestHarness sourceCluster;
    private final ClusterLinkTestHarness destCluster;

    @Override
    public ClusterLinkTestHarness sourceCluster() {
        return this.sourceCluster;
    }

    @Override
    public ClusterLinkTestHarness destCluster() {
        return this.destCluster;
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
    }

    @Test
    public void testClusterLinkWithPemSslStores() {
        super.setUp();
        UUID linkId = this.destCluster().createClusterLink(this.linkName(), this.sslLinkProps(this.sslLinkProps$default$1()), (Option<String>)new Some((Object)((KafkaServer)this.sourceCluster().servers().head()).clusterId()), this.destCluster().createClusterLink$default$4());
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        Config linkConfig = this.destCluster().describeClusterLink(this.linkName());
        Map linkProps = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(linkConfig.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.keystore.type"));
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.truststore.type"));
        this.verifyConfigAfterRestart(linkId, true);
        this.verifyLink();
        Properties overrideProps = new Properties();
        overrideProps.setProperty("ssl.truststore.location", this.destCluster().clientSecurityProps(this.linkName()).getProperty("ssl.truststore.location"));
        Properties invalidLinkProps = this.sslLinkProps(overrideProps);
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "SSL handshake failed");
        invalidLinkProps.remove("ssl.truststore.certificates");
        invalidLinkProps.setProperty("ssl.truststore.location", "nonexistent.pem");
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "Unable to create client using provided properties when validating the cluster link: Failed to load PEM SSL keystore nonexistent.pem, root cause: java.nio.file.NoSuchFileException: nonexistent.pem");
    }

    @Test
    public void testEncryptionSecretRotation() {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this.destCluster().serverConfig().put("confluent.password.encoder.old.secret.ttl.ms", "1000");
        super.setUp();
        UUID linkId = this.destCluster().createClusterLink(this.linkName(), this.sslLinkProps(this.sslLinkProps$default$1()), (Option<String>)new Some((Object)((KafkaServer)this.sourceCluster().servers().head()).clusterId()), this.destCluster().createClusterLink$default$4());
        this.waitForOldSecretDelete(linkId);
        this.waitForOldSecretDelete(this.destCluster().createClusterLink("anotherLink", this.sslLinkProps(this.sslLinkProps$default$1()), (Option<String>)None$.MODULE$, this.destCluster().createClusterLink$default$4()));
        HashMap<String, Object> encoderProps = this.brokerProps();
        encoderProps.remove("confluent.password.encoder.old.secret.ttl.ms");
        ClusterLinkConfigEncoder encoder = new ClusterLinkConfigEncoder(new KafkaConfig(encoderProps));
        Properties linkProps = this.destCluster().adminZkClient().fetchClusterLinkConfig(linkId);
        this.destCluster().adminZkClient().changeClusterLinkConfig(linkId, (Properties)encoder.maybeReencode(linkProps).get());
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        this.verifyConfigAfterRestart(linkId, false);
        this.verifyLink();
    }

    /*
     * WARNING - void declaration
     */
    private Properties sslLinkProps(Properties overrideProps) {
        void var2_2;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.sourceCluster().brokerList());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sourceCluster().clientSecurityProps(this.linkName()));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(overrideProps);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        Assertions.assertNull((Object)props.get("ssl.keystore.location"));
        Assertions.assertNull((Object)props.get("ssl.truststore.location"));
        return var2_2;
    }

    private Properties sslLinkProps$default$1() {
        return new Properties();
    }

    private void verifyLink() {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), this.sourceCluster().createTopic$default$4());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), this.destCluster().linkTopic$default$4());
        this.produceToSourceCluster(20);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> brokerProps() {
        void var1_1;
        HashMap props = new HashMap();
        props.putAll(((KafkaServer)this.destCluster().servers().head()).config().originals());
        return var1_1;
    }

    private ClusterLinkConfigEncoder encoderWithOldSecret() {
        HashMap<String, Object> oldEncoderProps = this.brokerProps();
        oldEncoderProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), oldEncoderProps.remove(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp()));
        return new ClusterLinkConfigEncoder(new KafkaConfig(oldEncoderProps));
    }

    private void decodeLinkConfig(ClusterLinkConfigEncoder encoder, UUID linkId) {
        Properties props = this.destCluster().zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
        encoder.clusterLinkConfig(props);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOldSecretDelete(UUID linkId) {
        ClusterLinkConfigEncoder oldEncoder = this.encoderWithOldSecret();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$1(this, oldEncoder, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConfigAfterRestart(UUID linkId, boolean expectOld) {
        int brokerId = ((KafkaServer)this.destCluster().servers().head()).config().brokerId();
        this.destCluster().shutdownBroker(brokerId);
        this.destCluster().startBroker(brokerId);
        if (expectOld) {
            this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
            return;
        }
        this.waitForOldSecretDelete(linkId);
    }

    public static final /* synthetic */ boolean $anonfun$waitForOldSecretDelete$1(ClusterLinkSslTest $this, ClusterLinkConfigEncoder oldEncoder$1, UUID linkId$1) {
        try {
            $this.decodeLinkConfig(oldEncoder$1, linkId$1);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static final /* synthetic */ String $anonfun$waitForOldSecretDelete$2() {
        return "Configs encrypted with old secret not deleted";
    }

    public ClusterLinkSslTest() {
        SecurityProtocol x$1 = SecurityProtocol.SSL;
        int x$2 = 0;
        Option<SecurityProtocol> x$3 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.sourceCluster = new ClusterLinkTestHarness(x$1, x$3, x$2, x$4);
        SecurityProtocol x$5 = SecurityProtocol.SSL;
        int x$6 = 100;
        Option<SecurityProtocol> x$7 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.destCluster = new ClusterLinkTestHarness(x$5, x$7, x$6, x$8);
    }
}

