/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQ\u0001\r\u0001\u0005\u0002qAQ!\u000e\u0001\u0005\u0002qAQa\u000e\u0001\u0005\naBQ!\u0012\u0001\u0005\n\u0019CQA\u000f\u0001\u0005\neCQA\u0017\u0001\u0005\neCQa\u0017\u0001\u0005\nqCQa\u001c\u0001\u0005\nADq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\b\u0001!I!!\u0003\u0003=\rcWo\u001d;fe2Kgn\u001b+jKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\b\u0011\u0003\u0011a\u0017N\\6\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u001d%\u0011qC\u0004\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000b\u0001\u0003\u0015\u0019X\r^+q)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRD#A\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYC&A\u0003kk:LGOC\u0001.\u0003\ry'oZ\u0005\u0003_\u0019\u0012!BQ3g_J,W)Y2i\u0003\u001d\"Xm\u001d;NSJ\u0014xN]5oO^KG\u000f\u001b+jKJLgnZ#oC\ndW\rZ(o'>,(oY3)\u0005\r\u0011\u0004CA\u00134\u0013\t!dE\u0001\u0003UKN$\u0018A\f;fgRl\u0015N\u001d:pe&twmV5uQRKWM]5oO\u0016s\u0017M\u00197fI>s7k\\;sG\u0016\fe\u000e\u001a#fgRD#\u0001\u0002\u001a\u0002CY,'/\u001b4z\u001b&\u0014(o\u001c:j]\u001e<\u0016\u000e\u001e5US\u0016\u0014\u0018N\\4F]\u0006\u0014G.\u001a3\u0015\u0007uI4\tC\u0003;\u000b\u0001\u00071(\u0001\tt_V\u00148-\u001a+pa&\u001c\u0007K]8qgB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005kRLGNC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$A\u0003)s_B,'\u000f^5fg\")A)\u0002a\u0001w\u0005qA-Z:u)>\u0004\u0018n\u0019)s_B\u001c\u0018!D3oC\ndW\rV5fe&tw\rF\u0002\u001e\u000f2CQ\u0001\u0013\u0004A\u0002%\u000bqa\u00197vgR,'\u000f\u0005\u0002\u0016\u0015&\u00111J\u0004\u0002\u0017\u00072,8\u000f^3s\u0019&t7\u000eV3ti\"\u000b'O\\3tg\")QJ\u0002a\u0001\u001d\u00061!-^2lKR\u0004\"a\u0014,\u000f\u0005A#\u0006CA) \u001b\u0005\u0011&BA*\u0013\u0003\u0019a$o\\8u}%\u0011QkH\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V?U\t1(A\u0005uS\u0016\u0014\bK]8qg\u0006Y\u0002O]8ek\u000e,\u0017I\u001c3TS6,H.\u0019;f%\u0016$XM\u001c;j_:$\"!H/\t\u000byK\u0001\u0019A0\u0002\u0011A\u0014x\u000eZ;dKJ\u0004B\u0001Y4jS6\t\u0011M\u0003\u0002_E*\u00111\rZ\u0001\bG2LWM\u001c;t\u0015\t\tRM\u0003\u0002gY\u00051\u0011\r]1dQ\u0016L!\u0001[1\u0003\u001b-\u000bgm[1Qe>$WoY3s!\rq\"\u000e\\\u0005\u0003W~\u0011Q!\u0011:sCf\u0004\"AH7\n\u00059|\"\u0001\u0002\"zi\u0016\fqc^1jiVsG/\u001b7TK\u001elWM\u001c;t)&,'/\u001a3\u0015\u0007u\t(\u000fC\u0003I\u0015\u0001\u0007\u0011\nC\u0003t\u0015\u0001\u0007A/\u0001\bnS:tU/\\*fO6,g\u000e^:\u0011\t=+x/`\u0005\u0003mb\u00131!T1q!\tA80D\u0001z\u0015\tQH-\u0001\u0004d_6lwN\\\u0005\u0003yf\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u001f}&\u0011qp\b\u0002\u0004\u0013:$\u0018!E:j[Vd\u0017\r^3SKR,g\u000e^5p]R\u0019Q$!\u0002\t\u000b![\u0001\u0019A%\u0002\u00131,\u0017\rZ3s\u0019><GCBA\u0006\u0003/\tI\u0002\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002E\u0001\u0004Y><\u0017\u0002BA\u000b\u0003\u001f\u00111\"\u00112tiJ\f7\r\u001e'pO\")\u0001\n\u0004a\u0001\u0013\"1\u00111\u0004\u0007A\u0002]\f!\u0001\u001e9)\u000f\u0001\ty\"!\n\u0002(A\u0019Q%!\t\n\u0007\u0005\rbEA\u0002UC\u001e\fQA^1mk\u0016\f#!!\u000b\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkTierIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    @Override
    @BeforeEach
    public void setUp() {
    }

    @Test
    public void testMirroringWithTieringEnabledOnSource() {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        super.setUp();
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), new Properties());
    }

    @Test
    public void testMirroringWithTieringEnabledOnSourceAndDest() {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        this.enableTiering(this.destCluster(), "destBucket");
        super.setUp();
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), this.tierProps());
    }

    private void verifyMirroringWithTieringEnabled(Properties sourceTopicProps, Properties destTopicProps) {
        this.numPartitions_$eq(2);
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), this.replicationFactor(), sourceTopicProps);
        KafkaProducer producer = this.sourceCluster().createProducer(this.sourceCluster().createProducer$default$1(), this.sourceCluster().createProducer$default$2(), this.sourceCluster().createProducer$default$3());
        this.produceAndSimulateRetention(producer);
        this.consume(this.sourceCluster());
        this.destCluster().createDestClusterLink(this.linkName(), this.sourceCluster(), this.destCluster().createDestClusterLink$default$3(), this.destCluster().createDestClusterLink$default$4(), this.destCluster().createDestClusterLink$default$5(), this.destCluster().createDestClusterLink$default$6());
        this.destCluster().linkTopic(this.topic(), this.replicationFactor(), this.linkName(), (Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(destTopicProps).asScala()));
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceAndSimulateRetention(producer);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    private void enableTiering(ClusterLinkTestHarness cluster, String bucket) {
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), bucket);
        cluster.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    private Properties sourceTopicProps() {
        void var1_1;
        Properties props = new Properties();
        props.putAll((java.util.Map<?, ?>)this.tierProps());
        props.put("segment.bytes", "2000");
        props.put("retention.bytes", "-1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties tierProps() {
        void var1_1;
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("confluent.tier.local.hotset.bytes", "1000");
        return var1_1;
    }

    private void produceAndSimulateRetention(KafkaProducer<byte[], byte[]> producer) {
        scala.collection.immutable.Map minTiered = ((TraversableOnce)this.partitions().map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToInteger((int)(this.leaderLog(this.sourceCluster(), (TopicPartition)tp).tierPartitionState().numSegments() + 3))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> this.produceRecords(producer, this.topic(), 50, this.produceRecords$default$4()));
        this.waitUntilSegmentsTiered(this.sourceCluster(), (scala.collection.immutable.Map<TopicPartition, Object>)minTiered);
        this.simulateRetention(this.sourceCluster());
    }

    private void waitUntilSegmentsTiered(ClusterLinkTestHarness cluster, scala.collection.immutable.Map<TopicPartition, Object> minNumSegments) {
        this.partitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$1(this, cluster, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(ClusterLinkTestHarness cluster) {
        this.partitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$1(this, cluster, tp);
            return BoxedUnit.UNIT;
        });
    }

    private AbstractLog leaderLog(ClusterLinkTestHarness cluster, TopicPartition tp) {
        LogManager qual$1 = cluster.partitionLeader(tp).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(tp, x$2).get();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierState$1, int minSegments$1) {
        return tierState$1.numSegments() >= minSegments$1 && tierState$1.endOffset() == tierState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(scala.collection.immutable.Map minNumSegments$1) {
        return new StringBuilder(54).append("Timed out waiting for ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$1, scala.collection.immutable.Map minNumSegments$1, TopicPartition tp) {
        TierPartitionState tierState = $this.leaderLog(cluster$1, tp).tierPartitionState();
        int minSegments = BoxesRunTime.unboxToInt((Object)minNumSegments$1.apply((Object)tp));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$2(tierState, minSegments)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$simulateRetention$2(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp$1) {
        return $this.leaderLog(cluster$2, tp$1).deleteOldSegments() > 0;
    }

    public static final /* synthetic */ String $anonfun$simulateRetention$3() {
        return "tiered segments should have been deleted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$simulateRetention$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$2($this, cluster$2, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }
}

