/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u000b\u0016\u0001iAQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00048\u0001\u0001\u0006IA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019\u0001\u0005\u0001)A\u0005u!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0003O\u0001\u0011\u0005q\nC\u0003_\u0001\u0011\u0005q\nC\u0003v\u0001\u0011%a\u000fC\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005m\u0001\u0001\"\u0003\u0002X!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBA;\u0001\u0011%\u0011q\u000f\u0005\u0007\u0003\u0003\u0003A\u0011A(\t\r\u0005\u0015\u0005\u0001\"\u0001P\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!,\u0001\t\u0013\ty\u000b\u0003\u0004\u0002V\u0002!\ta\u0014\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0017/\u0005\u0019An\\4\u000b\u0003a\tQa[1gW\u0006\u001c\u0001aE\u0002\u00017}\u0001\"\u0001H\u000f\u000e\u0003UI!AH\u000b\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t:\u0012aB7fiJL7m]\u0005\u0003I\u0005\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002\u001d\u0001\u0005)1m\u001c3fGV\t!\u0006\u0005\u0002,k5\tAF\u0003\u0002.]\u00051!/Z2pe\u0012T!a\f\u0019\u0002\r\r|W.\\8o\u0015\tA\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c-\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017AB2pI\u0016\u001c\u0007%\u0001\u0003uS6,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u:\u0012!B;uS2\u001c\u0018BA =\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\r\u00032\u0001R$J\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%!B!se\u0006L\bC\u0001&L\u001b\u0005q\u0013B\u0001'/\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\t\u0001\u000b\u0005\u0002E#&\u0011!+\u0012\u0002\u0005+:LG\u000f\u000b\u0002\t)B\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\u0004CBL'BA-[\u0003\u001dQW\u000f]5uKJT!aW\u001a\u0002\u000b),h.\u001b;\n\u0005u3&!C!gi\u0016\u0014X)Y2i\u0003i\"Xm\u001d;NCJ\\7\u000fU1si&$\u0018n\u001c8t\u0003N|eM\u001a7j]\u0016\fe\u000e\u001a)paVd\u0017\r^3t+:\u001cG.Z1oC\ndW-T3ue&\u001c7\u000f\u000b\u0002\nAB\u0011Q+Y\u0005\u0003EZ\u0013A\u0001V3ti\"2\u0011\u0002Z4iS*\u0004\"!V3\n\u0005\u00194&a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0003ua\rA!\u001e8ji\u0012\n1.\u0003\u0002m[\u0006aQ*\u0013'M\u0013N+5i\u0014(E'*\u0011an\\\u0001\t)&lW-\u00168ji*\u0011\u0001/]\u0001\u000bG>t7-\u001e:sK:$(B\u0001:t\u0003\u0011)H/\u001b7\u000b\u0003Q\fAA[1wC\u0006Iq-\u001a;NKR\u0014\u0018n\u0019\u000b\u0004o\u0006\u0015\u0001c\u0001=\u0002\u00025\t\u0011P\u0003\u0002{w\u0006!1m\u001c:f\u0015\t\u0011CP\u0003\u0002~}\u00061\u00110Y7nKJT\u0011a`\u0001\u0004G>l\u0017bAA\u0002s\n1Q*\u001a;sS\u000eDq!a\u0002\u000b\u0001\u0004\tI!\u0001\u0004gS2$XM\u001d\t\b\t\u0006-\u0011qBA\u000b\u0013\r\ti!\u0012\u0002\n\rVt7\r^5p]F\u00022\u0001_A\t\u0013\r\t\u0019\"\u001f\u0002\u000b\u001b\u0016$(/[2OC6,\u0007c\u0001#\u0002\u0018%\u0019\u0011\u0011D#\u0003\u000f\t{w\u000e\\3b]\u0006Aq-\u001a;HCV<W-\u0006\u0003\u0002 \u0005-B\u0003BA\u0011\u0003{\u0001R\u0001_A\u0012\u0003OI1!!\nz\u0005\u00159\u0015-^4f!\u0011\tI#a\u000b\r\u0001\u00119\u0011QF\u0006C\u0002\u0005=\"!\u0001+\u0012\t\u0005E\u0012q\u0007\t\u0004\t\u0006M\u0012bAA\u001b\u000b\n9aj\u001c;iS:<\u0007c\u0001#\u0002:%\u0019\u00111H#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002@-\u0001\r!!\u0011\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002D\u0005Ec\u0002BA#\u0003\u001b\u00022!a\u0012F\u001b\t\tIEC\u0002\u0002Le\ta\u0001\u0010:p_Rt\u0014bAA(\u000b\u00061\u0001K]3eK\u001aLA!a\u0015\u0002V\t11\u000b\u001e:j]\u001eT1!a\u0014F+\u0011\tI&a\u0018\u0015\r\u0005m\u0013\u0011MA2!\u0015A\u00181EA/!\u0011\tI#a\u0018\u0005\u000f\u00055BB1\u0001\u00020!9\u0011q\b\u0007A\u0002\u0005\u0005\u0003bBA3\u0019\u0001\u0007\u0011\u0011I\u0001\f[\u0016$(/[2TG>\u0004X-\u0001\u0005hKRlU\r^3s)\u0019\tY'!\u001d\u0002tA\u0019\u00010!\u001c\n\u0007\u0005=\u0014PA\u0003NKR,'\u000fC\u0004\u0002@5\u0001\r!!\u0011\t\u000f\u0005\u0015T\u00021\u0001\u0002B\u0005aq-\u001a;ISN$xn\u001a:b[R!\u0011\u0011PA@!\rA\u00181P\u0005\u0004\u0003{J(!\u0003%jgR|wM]1n\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\nq\u0003^3ti6\u000b\u0007\u0010T8h\u0007>l\u0007/Y2uS>tG*Y4)\u0005=\u0001\u0017!\u0006;fgR\u001cu.\u001c9bGRLwN\\'fiJL7m\u001d\u0015\u0003!\u0001\f1B]3bI\u001a\u0013x.\u001c'pOR!\u0011QRAS!\u0019\ty)!&\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0004\u0003'+\u0015AC2pY2,7\r^5p]&!\u0011qSAI\u0005!IE/\u001a:bE2,\u0007c\u0002#\u0002\u001c\u0006}\u0015qT\u0005\u0004\u0003;+%A\u0002+va2,'\u0007E\u0002E\u0003CK1!a)F\u0005\rIe\u000e\u001e\u0005\u0007-E\u0001\r!a*\u0011\u0007q\tI+C\u0002\u0002,V\u00111\"\u00112tiJ\f7\r\u001e'pO\u0006aqO]5uK.+\u0017\u0010R;qgR\u0001\u0012\u0011WA\\\u0003w\u000by,!1\u0002D\u00065\u0017\u0011\u001b\t\u0007\u0003\u001f\u000b\u0019,!'\n\t\u0005U\u0016\u0011\u0013\u0002\u0004'\u0016\f\bbBA]%\u0001\u0007\u0011qT\u0001\b]Vl7*Z=t\u0011\u001d\tiL\u0005a\u0001\u0003?\u000bqA\\;n\tV\u00048\u000f\u0003\u0004\u0017%\u0001\u0007\u0011q\u0015\u0005\u0006QI\u0001\rA\u000b\u0005\b\u0003\u000b\u0014\u0002\u0019AAd\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002E\u0003\u0013L1!a3F\u0005\u0011auN\\4\t\u000f\u0005='\u00031\u0001\u0002 \u0006Q1\u000f^1siZ\u000bG.^3\t\u000f\u0005M'\u00031\u0001\u0002 \u0006!1\u000f^3q\u0003I!Xm\u001d;JgRC'/Z1e\r\u0006LG.\u001a3)\u0005M\u0001\u0007")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, x$3, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$122));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.localLogSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.localLogSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.cleaner().logs().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes.value()));
    }

    private Metric getMetric(Function1<MetricName, Object> filter) {
        return (Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(metricName, mName));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$2(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Meter getMeter(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMeter$1(metricName, metricScope, k));
        return (Meter)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Histogram getHistogram(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getHistogram$1(metricName, k));
        return (Histogram)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, firstBlockCleanableSegmentOffset, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$17 = activeSegAtT1.baseOffset();
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, x$17, x$18);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    @Test
    public void testCompactionMetrics() {
        double eps = 1.0E-6;
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        this.writeKeyDups(100, 3, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSeg = log.activeSegment();
        this.cleaner().startup();
        Meter readBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Histogram achievedCleaningRatio = this.getHistogram("AchievedCleaningRatio");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.writeKeyDups(100, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 0);
        long expectedReadBytes = log.size();
        log.roll(log.roll$default$1());
        long blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, blockCleanableSegmentOffset, x$15);
        Assertions.assertEquals((long)expectedReadBytes, (long)readBytesPerSec.count(), (String)new StringBuilder(35).append("log cleaner should have read ").append(expectedReadBytes).append(" bytes").toString());
        Assertions.assertEquals((long)log.size(), (long)writeBytesPerSec.count(), (String)new StringBuilder(8).append("a ").append(log.size()).append(" bytes").toString());
        Assertions.assertEquals((double)100.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        log.size();
        this.writeKeyDups(75, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        activeSeg = log.activeSegment();
        log.roll(log.roll$default$1());
        blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs * 2);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, blockCleanableSegmentOffset, x$18);
        Assertions.assertTrue((achievedCleaningRatio.mean() < (double)100 ? 1 : 0) != 0, (String)"achieved cleaning ratio should be less than 100");
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$22 = 100000;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, x$22, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = log.activeSegment().log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(Tuple2 x$1) {
        return ((AbstractLog)x$1._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$2(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeter$1(String metricName$3, String metricScope$2, MetricName k) {
        return k.getName().endsWith(metricName$3) && k.getScope().endsWith(metricScope$2);
    }

    public static final /* synthetic */ boolean $anonfun$getHistogram$1(String metricName$4, MetricName k) {
        return k.getName().endsWith(metricName$4) && k.getScope() == null;
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }

    public LogCleanerIntegrationTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

