/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.tier.state.TierPartitionState;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001\u0002*T\u0001aCQ!\u001a\u0001\u0005\u0002\u0019Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0001k\u0011\u0019)\b\u0001)A\u0005W\"9a\u000f\u0001b\u0001\n\u0003Q\u0007BB<\u0001A\u0003%1\u000eC\u0004y\u0001\t\u0007I\u0011\u00016\t\re\u0004\u0001\u0015!\u0003l\u0011\u001dQ\bA1A\u0005\u0002mDq!a\u0004\u0001A\u0003%A\u0010\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001|\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nqD\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oA\u0011\"a\u0010\u0001\u0005\u0004%\t!!\u0011\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u0007B\u0011\"a\u0013\u0001\u0005\u0004%\t!!\u0014\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003\u001f2a!a\u001a\u0001\u0001\u0005%\u0004\u0002DA91\t\u0005\t\u0015!\u0003\u0002t\u0005-\u0005\u0002DAG1\t\u0005\t\u0015!\u0003\u0002\u0010\u0006m\u0005\u0002DAO1\t\u0005\t\u0015!\u0003\u0002 \u0006-\u0006BB3\u0019\t\u0003\ti\u000bC\u0004\u0002:b!\t%a/\t\u000f\u0005-\u0007\u0004\"\u0011\u0002N\"I\u0011q\u001e\r\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0005\u000fA\u0012\u0013!C\u0001\u0005\u0013AqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003(\u0001!IA!\u000b\t\u000f\te\u0002\u0001\"\u0001\u0003\u0010!9!1\t\u0001\u0005\u0002\t=\u0001b\u0002B$\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u0017\u0002A\u0011\u0001B\b\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005\u001fAqAa\u0015\u0001\t\u0003\u0011y\u0001C\u0004\u0003X\u0001!\tAa\u0004\t\u000f\tm\u0003\u0001\"\u0001\u0003\u0010!9!q\f\u0001\u0005\u0002\t=\u0001b\u0002B2\u0001\u0011\u0005!q\u0002\u0005\b\u0005O\u0002A\u0011\u0001B\b\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005\u001fAqAa\u001c\u0001\t\u0003\u0011y\u0001C\u0004\u0003t\u0001!\tAa\u0004\t\u000f\t]\u0004\u0001\"\u0001\u0003\u0010!9!1\u0010\u0001\u0005\u0002\t=\u0001b\u0002B@\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u0007\u0003A\u0011\u0001B\b\u0011\u001d\u00119\t\u0001C\u0001\u0005\u001fAqAa#\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u0010\u0002!\tAa\u0004\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0010!9!q\u0013\u0001\u0005\u0002\t=\u0001b\u0002BN\u0001\u0011\u0005!q\u0002\u0005\b\u0005?\u0003A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005\u001fAqAa*\u0001\t\u0003\u0011y\u0001C\u0004\u0003,\u0002!\tAa\u0004\t\u000f\t=\u0006\u0001\"\u0001\u0003\u0010!9!1\u0017\u0001\u0005\u0002\t=\u0001b\u0002B\\\u0001\u0011\u0005!q\u0002\u0005\b\u0005w\u0003A\u0011\u0001B\b\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u001fAqAa1\u0001\t\u0003\u0011y\u0001C\u0004\u0003H\u0002!IA!3\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003N\"9!q\u001b\u0001\u0005\n\te\u0007b\u0002Bp\u0001\u0011%!\u0011\u001d\u0005\n\u0005k\u0004\u0011\u0013!C\u0005\u0005oD\u0011Ba?\u0001#\u0003%IA!@\t\u000f\r\u0005\u0001\u0001\"\u0003\u0004\u0004!I1q\u0002\u0001\u0012\u0002\u0013%1\u0011\u0003\u0005\b\u0007+\u0001A\u0011BB\f\u0011\u001d\u00199\u0003\u0001C\u0005\u0007SAqa!\r\u0001\t\u0013\u0019\u0019\u0004C\u0005\u0004D\u0001\t\n\u0011\"\u0003\u0003~\"91Q\t\u0001\u0005\n\r\u001d#!\u0006'pO\u000ecW-\u00198fe6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003)V\u000b1\u0001\\8h\u0015\u00051\u0016!B6bM.\f7\u0001A\n\u0004\u0001e{\u0006C\u0001.^\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&AB!osJ+g\r\u0005\u0002aG6\t\u0011M\u0003\u0002c+\u0006)Q\u000f^5mg&\u0011A-\u0019\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\r\u0005\u0002i\u00015\t1+\u0001\u0004u[B$\u0015N]\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0003S>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\nq\u0001^7q\t&\u0014('\u0001\u0005u[B$\u0015N\u001d\u001a!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013a\u00027pO\u0012K'OM\u0001\tY><G)\u001b:3A\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001?\u0011\u0007u\fY!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0007G>lWn\u001c8\u000b\u0007Y\u000b\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB1qC\u000eDWM\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055aP\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gNM\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8oe\u0001\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?y\u0017\u0001B;uS2LA!a\t\u0002\u001e\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\tY\u0003E\u0002i\u0003[I1!a\fT\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\nA\u0001^5nKV\u0011\u0011q\u0007\t\u0004A\u0006e\u0012bAA\u001eC\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0004pM\u001a\u001cX\r^\u000b\u0003\u0003\u0007\u00022AWA#\u0013\r\t9e\u0017\u0002\u0004\u0013:$\u0018aB8gMN,G\u000fI\u0001\u0013G2,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002PA9\u0011\u0011KA.y\u0006}SBAA*\u0015\u0011\t)&a\u0016\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011L.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005M#aA'baB\u0019!,!\u0019\n\u0007\u0005\r4L\u0001\u0003M_:<\u0017aE2mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN\u0004#!\u0006'pO\u000ecW-\u00198fe6\u000bg.Y4fe6{7m[\n\u00041\u0005-\u0004c\u00015\u0002n%\u0019\u0011qN*\u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\u0004m_\u001e$\u0015N]:\u0011\u000b\u0005U\u0014QQ6\u000f\t\u0005]\u0014\u0011\u0011\b\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP,\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0016bAAB7\u00069\u0001/Y2lC\u001e,\u0017\u0002BAD\u0003\u0013\u00131aU3r\u0015\r\t\u0019iW\u0005\u0005\u0003c\ni'\u0001\u0003m_\u001e\u001c\bC\u00021\u0002\u0012r\f)*C\u0002\u0002\u0014\u0006\u0014A\u0001U8pYB\u0019\u0001.a&\n\u0007\u0005e5KA\u0006BEN$(/Y2u\u0019><\u0017\u0002BAG\u0003[\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015V+\u0001\u0004tKJ4XM]\u0005\u0005\u0003S\u000b\u0019K\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0005\u0005\u0003;\u000bi\u0007\u0006\u0005\u00020\u0006M\u0016QWA\\!\r\t\t\fG\u0007\u0002\u0001!9\u0011\u0011\u000f\u000fA\u0002\u0005M\u0004bBAG9\u0001\u0007\u0011q\u0012\u0005\b\u0003;c\u0002\u0019AAP\u0003U\tG\u000e\\\"mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!!0\u0011\u000f\u0005}\u0016q\u0019?\u0002`9!\u0011\u0011YAb!\r\tIhW\u0005\u0004\u0003\u000b\\\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005%'bAAc7\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\u0011\u0005=\u0017Q[Am\u0003S\u00042AWAi\u0013\r\t\u0019n\u0017\u0002\u0005+:LG\u000f\u0003\u0004\u0002Xz\u0001\ra[\u0001\bI\u0006$\u0018\rR5s\u0011%\tYN\bI\u0001\u0002\u0004\ti.\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u0015Q\u0016q\\Ar\u0013\r\t\to\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ri\u000b)\u000f`A0\u0013\r\t9o\u0017\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005-h\u0004%AA\u0002\u00055\u0018!\u00059beRLG/[8o)>\u0014V-\\8wKB!!,a8}\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001f\u0016\u0005\u0003;\f)p\u000b\u0002\u0002xB!\u0011\u0011 B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018!C;oG\",7m[3e\u0015\r\u0011\taW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0003\u0003w\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0002\u0016\u0005\u0003[\f)0\u0001\u0005uK\u0006\u0014Hi\\<o)\t\ty\rK\u0002\"\u0005'\u0001BA!\u0006\u0003$5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"A\u0002ba&TAA!\b\u0003 \u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u0011\u0003\u000f\tQA[;oSRLAA!\n\u0003\u0018\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001cg\u0016$X\u000f]%oGJ,\u0017m]5oO2Lh)\u001b7uQfdunZ:\u0015\u0011\u0005=%1\u0006B\u0019\u0005kAqA!\f#\u0001\u0004\u0011y#\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!!\u001e\u0002\u0006rDqAa\r#\u0001\u0004\t\u0019%A\bti\u0006\u0014HOT;n\u0005\u0006$8\r[3t\u0011\u001d\u00119D\ta\u0001\u0003\u0007\naBY1uG\"Len\u0019:f[\u0016tG/\u0001\u001euKN$8\t[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012\u001c\u0005.Z2lg\u001a{'O\u0012:pu\u0016tGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\u000b^1uK\"\u001a1E!\u0010\u0011\t\tU!qH\u0005\u0005\u0005\u0003\u00129B\u0001\u0003UKN$\u0018!\r;fgR\feo\\5e\u001b\u0006D8i\\7qC\u000e$\u0018n\u001c8EK2\f\u0017pQ1mGVd\u0017\r^5p]2\u000bw-T1y-\u0006dW/\u001a\u0015\u0004I\tu\u0012A\t;fgRl\u0015\r_\"p[B\f7\r^5p]2\u000bwMR8sG\u0016\u001cHj\\4DY\u0016\fg\u000eK\u0002&\u0005{\tA\u0006^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a+ie><8/\u0012=dKB$\u0018n\u001c8)\u0007\u0019\u0012i$\u0001\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h%\u0016$XO\u001d8t\u0019><w+\u001b;i\t&\u0014H/[3tiJ\u000bG/[8)\u0007\u001d\u0012i$A\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rA#QH\u00019i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8tQ\rI#QH\u0001Ui\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg\n{G\u000f[%o!J|wM]3tgB\u000b'\u000f^5uS>t7/\u00118e+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rQ#QH\u0001*i\u0016\u001cH\u000fR5sif|eMZ:fiJ+7/\u001a;JM2\u000b'oZ3s)\"\fg.\u00128e\u001f\u001a47/\u001a;)\u0007-\u0012i$\u0001\u0017uKN$H)\u001b:us>3gm]3u%\u0016\u001cX\r^%g'6\fG\u000e\\3s)\"\fgn\u0015;beR|eMZ:fi\"\u001aAF!\u0010\u0002gQ,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e'be\u001e,'\u000f\u00165b]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$\bfA\u0017\u0003>\u0005\u0001D/Z:u\t&\u0014H/_(gMN,G\u000fT1sO\u0016\u0014H\u000b[1o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;CCN,wJ\u001a4tKRD3A\fB\u001f\u0003\u0011#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010R3mKR,Gj\\4tQ\ry#QH\u0001Ii\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;EK2,G/\u001a'pOND3\u0001\rB\u001f\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di2{wm\u001d\u0015\u0004c\tu\u0012a\u000b;fgRdunZ:V]\u0012,'o\u00117fC:,\b/\u00138fY&<\u0017N\u00197f\r>\u00148i\\7qC\u000e$\u0018n\u001c8)\u0007I\u0012i$A\u0018uKN$X\u000b\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:TQ>,H\u000eZ!eI>3gm]3u)>\u0004\u0016M\u001d;ji&|g\u000eK\u00024\u0005{\ta\u0006^3tiV\u0003H-\u0019;f\u0007\",7m\u001b9pS:$8o\u00155pk2$'+Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\"\u001aAG!\u0010\u0002[Q,7\u000f\u001e%b]\u0012dW\rT8h\t&\u0014h)Y5mkJ,7\u000b[8vY\u0012\u0014V-\\8wK\u0012K'/\u00118e\t\u0006$\u0018\rK\u00026\u0005{\tQ\u0006^3ti6\u000b\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$8\u000b[8vY\u0012$&/\u001e8dCR,G)\u0019;bQ\r1$QH\u0001=i\u0016\u001cH/\u00117uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeNCw.\u001e7e%\u0016lwN^3ECR\f\u0017J\\*sG\u0012K'/\u00118e\u0003\u0012$\u0017J\u001c(fo\u0012K'\u000fK\u00028\u0005{\t\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gj\\4UeVt7-\u0019;j_:D3\u0001\u000fB\u001f\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oIR{\u0007/[2EK2,G/[8oQ\rI$QH\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u0014XK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u001e\u0003>\u0005AB/Z:u\u0007>l\u0007/Y2uK\u0012\u0014\u0015\u0010^3t\u001b\u0016$(/[2)\u0007m\u0012i$A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$pe:{g.\u001a\u0015\u0004y\tu\u0012a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s)&lW\rK\u0002>\u0005{\t\u0001\u0005^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:TQ>\u0014H\u000fV5nK\"\u001aaH!\u0010\u0002QQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u001d\u0016,Gm]\"iK\u000e\\\u0007o\\5oiJ+7/\u001a;)\u0007}\u0012i$\u0001\u0016uKN$XK\u001c3fG&$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000eR1uC:{Go\u00117fC:\f'\r\\3)\u0007\u0001\u0013i$\u0001\tuKN$Hi\u001c8f\u00072,\u0017M\\5oO\"\u001a\u0011I!\u0010\u0002!Q,7\u000f\u001e#p]\u0016$U\r\\3uS:<\u0007f\u0001\"\u0003>\u0005yC/Z:u\u0007\",7m\u001b9pS:$X\u000b\u001d3bi\u0016$gi\u001c:J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e(p\u00072,\u0017M\\5oO\"\u001a1I!\u0010\u0002aQ,7\u000f^\"iK\u000e\\\u0007o\\5oiV\u0003H-\u0019;fI\u001a{'/\u00138wC2LGm\u00144gg\u0016$hj\u001c;TK2,7\r^3eQ\r!%QH\u0001\u0015GJ,\u0017\r^3DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0015\t\u0005-$1\u001a\u0005\u0007)\u0016\u0003\r!!&\u0015\t\u0005-$q\u001a\u0005\b\u0003\u001b3\u0005\u0019\u0001Bi!\u0019\tyLa5\u0002\u0016&!!Q[Ae\u0005\r\u0019V\r^\u0001\u0019GJ,\u0017\r^3DY\u0016\fg.\u001a:NC:\fw-\u001a:N_\u000e\\G\u0003BAX\u00057DqA!8H\u0001\u0004\ty)\u0001\u0003q_>d\u0017!C2sK\u0006$X\rT8h))\t)Ja9\u0003h\nE(1\u001f\u0005\b\u0005KD\u0005\u0019AA\"\u0003-\u0019XmZ7f]R\u001c\u0016N_3\t\u000f\t%\b\n1\u0001\u0003l\u0006i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a0\u0003n&!!q^Ae\u0005\u0019\u0019FO]5oO\"9!\u0010\u0013I\u0001\u0002\u0004a\bb\u0002<I!\u0003\u0005\ra[\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005sT3\u0001`A{\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yPK\u0002l\u0003k\f1d\u0019:fCR,Gj\\<SKR,g\u000e^5p]2{wmQ8oM&<G\u0003CA\u0016\u0007\u000b\u00199a!\u0003\t\u000f\t\u00158\n1\u0001\u0002D!9!\u0011^&A\u0002\t-\b\"CB\u0006\u0017B\u0005\t\u0019AB\u0007\u0003Ii\u0017\r_\"p[B\f7\r^5p]2\u000bw-T:\u0011\u000bi\u000by.a\u0018\u0002K\r\u0014X-\u0019;f\u0019><(+\u001a;f]RLwN\u001c'pO\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u001aTCAB\nU\u0011\u0019i!!>\u0002\u0019]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:\u0015\u0015\u0005=7\u0011DB\u000e\u0007?\u0019\u0019\u0003\u0003\u0004U\u001b\u0002\u0007\u0011Q\u0013\u0005\b\u0007;i\u0005\u0019AA\"\u0003)qW/\u001c\"bi\u000eDWm\u001d\u0005\b\u0007Ci\u0005\u0019AA\"\u0003=\u0011XmY8sIN\u0004VM\u001d\"bi\u000eD\u0007bBB\u0013\u001b\u0002\u0007\u00111I\u0001\u0012E\u0006$8\r[3t!\u0016\u00148+Z4nK:$\u0018!D1qa\u0016tGMU3d_J$7\u000f\u0006\u0004\u0002P\u000e-2Q\u0006\u0005\u0007):\u0003\r!!&\t\u000f\r=b\n1\u0001\u0002D\u0005Qa.^7SK\u000e|'\u000fZ:\u0002\u000f5\f7.\u001a'pOR11QGB\u001e\u0007\u007f\u00012\u0001[B\u001c\u0013\r\u0019Id\u0015\u0002\n\u001b\u0016\u0014x-\u001a3M_\u001eD\u0001b!\u0010P!\u0003\u0005\ra[\u0001\u0004I&\u0014\bbBB!\u001f\u0002\u0007\u00111F\u0001\u0007G>tg-[4\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$\u0013'A\u0004sK\u000e|'\u000fZ:\u0015\u0011\r%3QKB-\u0007;\u0002Baa\u0013\u0004R5\u00111Q\n\u0006\u0004\u0007\u001fr\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0004T\r5#!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0004XE\u0003\r!a\u0011\u0002\u0007-,\u0017\u0010C\u0004\u0004\\E\u0003\r!a\u0011\u0002\u000bY\fG.^3\t\u000f\r}\u0013\u000b1\u0001\u0002`\u0005IA/[7fgR\fW\u000e\u001d")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File tmpDir2;
    private final File logDir;
    private final File logDir2;
    private final TopicPartition topicPartition;
    private final TopicPartition topicPartition2;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, AbstractLog> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testCheckCleaningAbortedChecksForFrozenLogStartOffsetState() {
        TopicPartition tp = new TopicPartition("test-topic", 0);
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)mockLog);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        cleanerManager.checkCleaningAborted(tp);
        Object object = cleanerManager.cleaningState(tp).get();
        LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
        Assertions.assertTrue((!(object != null ? !object.equals(logCleaningInProgress$) : logCleaningInProgress$ != null) ? 1 : 0) != 0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleanerManager.checkCleaningAborted(tp));
    }

    @Test
    public void testAvoidMaxCompactionDelayCalculationLagMaxValue() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(logSegmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), "1");
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), Long.toString(Long.MAX_VALUE));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxProducerIdExpirationMs, ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        MockScheduler x$6 = this.time().scheduler();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        MockTime x$9 = this.time();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TopicPartition x$11 = this.topicPartition();
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        NoOpLogOffsetsListener$ x$17 = NoOpLogOffsetsListener$.MODULE$;
        Function1 x$18 = Log$.MODULE$.$lessinit$greater$default$16();
        Function0 x$19 = Log$.MODULE$.$lessinit$greater$default$17();
        Option x$20 = Log$.MODULE$.$lessinit$greater$default$20();
        Log localLog = new Log(tpDir, config, segments, x$4, x$5, (Scheduler)x$6, x$7, x$8, (Time)x$9, x$10, x$11, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)x$17, x$18, x$19, (Option)x$15, x$16, x$20);
        TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        TierPartitionState tierPartitionState = tierLogComponents.partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler());
        MergedLog log = new MergedLog(null, localLog, tierPartitionState, tierLogComponents){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> logSegments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertFalse((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
    }

    @Test
    public void testMaxCompactionLagForcesLogClean() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(logSegmentSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "10");
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.00");
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        MockScheduler x$6 = this.time().scheduler();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        MockTime x$9 = this.time();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        NoOpLogOffsetsListener$ x$17 = NoOpLogOffsetsListener$.MODULE$;
        Function1 x$18 = Log$.MODULE$.$lessinit$greater$default$16();
        Function0 x$19 = Log$.MODULE$.$lessinit$greater$default$17();
        Option x$20 = Log$.MODULE$.$lessinit$greater$default$20();
        Log localLog = new Log(tpDir, config, segments, x$4, x$5, (Scheduler)x$6, x$7, x$8, (Time)x$9, x$10, tp, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)x$17, x$18, x$19, (Option)x$15, x$16, x$20);
        TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        TierPartitionState tierPartitionState = tierLogComponents.partitionStateFactory().initState(this.logDir(), tp, localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler());
        MergedLog log = new MergedLog(localLog, 0L, true, tierPartitionState, tierLogComponents);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
        this.time().sleep(11L);
        Assertions.assertTrue((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        int maxProducerIdExpirationMs = 3600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion().recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxProducerIdExpirationMs, ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        MockScheduler x$6 = this.time().scheduler();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        MockTime x$9 = this.time();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        NoOpLogOffsetsListener$ x$17 = NoOpLogOffsetsListener$.MODULE$;
        Function1 x$18 = Log$.MODULE$.$lessinit$greater$default$16();
        Function0 x$19 = Log$.MODULE$.$lessinit$greater$default$17();
        Option x$20 = Log$.MODULE$.$lessinit$greater$default$20();
        Log localLog = new Log(tpDir, config, segments, x$4, x$5, (Scheduler)x$6, x$7, x$8, (Time)x$9, x$10, tp, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)x$17, x$18, x$19, (Option)x$15, x$16, x$20);
        TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        TierPartitionState tierPartitionState = tierLogComponents.partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler());
        MergedLog log = new MergedLog(null, localLog, tierPartitionState, tierLogComponents){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)log, (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        AbstractLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, this.createLog$default$4());
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        AbstractLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, this.createLog$default$4());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> (TopicPartition)x$4._1(), Iterable$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCompactedBytesMetric() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log_1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-1", 0), this.logDir());
        AbstractLog log_2 = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), new TopicPartition("topic-2", 2), this.logDir());
        AbstractLog log_3 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-2", 5), this.logDir());
        AbstractLog log_4 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), new TopicPartition("topic-2", 10), this.logDir2());
        AbstractLog log_5 = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), new TopicPartition("topic-1", 2), this.logDir2());
        AbstractLog log_6 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), new TopicPartition("topic-3", 2), this.logDir());
        AbstractLog log_7 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), new TopicPartition("topic-4", 2), this.logDir2());
        Set logs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log_1, log_2, log_3, log_4, log_5, log_6, log_7}));
        IntRef numBatches = IntRef.create((int)5);
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$1(this, numBatches, log);
            return BoxedUnit.UNIT;
        });
        this.createCleanerManager((Set<AbstractLog>)logs);
        long logDirSize = log_1.size() + log_2.size() + log_3.size();
        long logDir2Size = log_4.size() + log_5.size();
        Assertions.assertTrue((logDirSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDir2Size > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDirSize != logDir2Size ? 1 : 0) != 0);
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir2().getAbsolutePath()).value()));
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3(), this.createLog$default$4());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp).get()), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((AbstractLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp0).get()), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(AbstractLog log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManager createCleanerManager(Set<AbstractLog> logs) {
        Pool compactedLogs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> (AbstractLog)compactedLogs.put((Object)log.topicPartition(), log));
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), compactedLogs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, AbstractLog> pool) {
        return new LogCleanerManagerMock((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private AbstractLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition, File logDir) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy, this.createLowRetentionLogConfig$default$3());
        File partitionDir = new File(logDir, Log$.MODULE$.logDirName(topicPartition));
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        None$ x$14 = None$.MODULE$;
        boolean x$15 = true;
        LogOffsetsListener x$16 = Log$.MODULE$.apply$default$16();
        Option x$17 = Log$.MODULE$.apply$default$17();
        return Log$.MODULE$.apply(partitionDir, config, x$3, x$4, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, (Option)x$12, x$13, (Option)x$14, x$15, x$16, x$17);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private File createLog$default$4() {
        return this.logDir();
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy, Option<Object> maxCompactionLagMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        maxCompactionLagMs.foreach((Function1 & Serializable & scala.Serializable)lag -> logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), Long.toString(BoxesRunTime.unboxToLong((Object)lag))));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private Option<Object> createLowRetentionLogConfig$default$3() {
        return None$.MODULE$;
    }

    private void writeRecords(AbstractLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    private void appendRecords(AbstractLog log, int numRecords) {
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private MergedLog makeLog(File dir, LogConfig config) {
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        boolean x$14 = true;
        boolean x$15 = true;
        LogOffsetsListener x$16 = Log$.MODULE$.apply$default$16();
        Option x$17 = Log$.MODULE$.apply$default$17();
        return Log$.MODULE$.apply(dir, config, x$3, x$4, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, (Option)x$13, x$14, (Option)x$12, x$15, x$16, x$17);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        AbstractLog log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp, $this.createLog$default$4());
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$1(LogCleanerManagerTest $this, IntRef numBatches$2, AbstractLog log) {
        $this.writeRecords(log, numBatches$2.elem, 1, 5);
        numBatches$2.elem += 10;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$2(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    private static final Metric getMetric$1(Function1 filter) {
        return (Metric)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$testCompactedBytesMetric$2_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$testCompactedBytesMetric$2_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).head())._2();
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$3(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric$1_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$3(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$testCompactedBytesMetric$2_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$testCompactedBytesMetric$2_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).head())._2());
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, AbstractLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.tmpDir2 = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.topicPartition2 = new TopicPartition("log2", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

