/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.MergedLog;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.tier.state.TierPartitionState;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015c\u0001B5k\u0001=DQA\u001e\u0001\u0005\u0002]DqA\u001f\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005-\u0001A1A\u0005\u0002mDq!!\u0004\u0001A\u0003%A\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0001\u0002\u0012!A\u0011q\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u00020!A\u0011Q\b\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002@\u0001\u0011\r\u0011\"\u0001\u0002B!A\u0011\u0011\n\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005=\u0004\u0001\"\u0001\u0002N!9\u0011\u0011\u0010\u0001\u0005\u0002\u00055\u0003bBA?\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u0003\u0003A\u0011AA'\u0011\u001d\t)\t\u0001C\u0001\u0003\u001bBq!!#\u0001\t\u0003\ti\u0005C\u0004\u0002\u000e\u0002!\t!!\u0014\t\u000f\u0005E\u0005\u0001\"\u0001\u0002N!9\u0011Q\u0013\u0001\u0005\u0002\u00055\u0003bBAM\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003;\u0003A\u0011AA'\u0011\u001d\t\t\u000b\u0001C\u0001\u0003\u001bBq!!*\u0001\t\u0003\ti\u0005C\u0004\u0002*\u0002!\t!!\u0014\t\u000f\u00055\u0006\u0001\"\u0001\u0002N!9\u0011\u0011\u0017\u0001\u0005\u0002\u00055\u0003bBA[\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003s\u0003A\u0011AA'\u0011\u001d\ti\f\u0001C\u0001\u0003\u001bBq!!1\u0001\t\u0003\ti\u0005C\u0004\u0002F\u0002!\t!!\u0014\t\u000f\u0005%\u0007\u0001\"\u0001\u0002N!9\u0011Q\u001a\u0001\u0005\u0002\u00055\u0003bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003c\u0004A\u0011AA'\u0011\u001d\t)\u0010\u0001C\u0001\u0003\u001bBq!!?\u0001\t\u0003\ti\u0005C\u0004\u0002~\u0002!\t!!\u0014\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002N!9!Q\u0001\u0001\u0005\u0002\u00055\u0003b\u0002B\u0005\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005\u001b\u0001A\u0011AA'\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003\u001bBqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003.\u0001!\tAa\f\t\u000f\te\u0002\u0001\"\u0001\u0003<!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005?\u0002A\u0011AA'\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0003\u001bBqAa\u001a\u0001\t\u0003\ti\u0005C\u0004\u0003l\u0001!\t!!\u0014\t\u000f\t=\u0004\u0001\"\u0001\u0002N!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002BE\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005\u001b\u0003A\u0011AA'\u0011\u001d\u0011\t\n\u0001C\u0001\u0003\u001bBqA!&\u0001\t\u0003\ti\u0005C\u0004\u0003\u001a\u0002!\t!!\u0014\t\u000f\tu\u0005\u0001\"\u0001\u0002N!9!\u0011\u0015\u0001\u0005\u0002\u00055\u0003b\u0002BS\u0001\u0011\u0005\u0011Q\n\u0005\b\u0005S\u0003A\u0011AA'\u0011\u001d\u0011i\u000b\u0001C\u0001\u0003\u001bBqA!-\u0001\t\u0003\ti\u0005C\u0004\u00036\u0002!IAa.\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"I!q\u001d\u0001\u0012\u0002\u0013%!\u0011\u001e\u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011\u001d\u0011y\u0010\u0001C\u0005\u00077Aqaa\t\u0001\t\u0013\u0019)\u0003C\u0005\u00042\u0001\t\n\u0011\"\u0003\u00044!I1q\u0007\u0001\u0012\u0002\u0013%1\u0011\b\u0005\n\u0007{\u0001\u0011\u0013!C\u0005\u0007\u007fAqaa\u0011\u0001\t\u0013\u0019)\u0005C\u0005\u0004`\u0001\t\n\u0011\"\u0003\u0004b!I1Q\r\u0001\u0012\u0002\u0013%1q\r\u0005\b\u0005k\u0003A\u0011BB6\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007gBqA!5\u0001\t\u0013\u0019)\tC\u0005\u0004\"\u0002\t\n\u0011\"\u0003\u0004@!I11\u0015\u0001\u0012\u0002\u0013%1Q\u0015\u0005\n\u0007S\u0003\u0011\u0013!C\u0005\u0007OB\u0011ba+\u0001#\u0003%Iaa\u001a\t\u000f\r5\u0006\u0001\"\u0003\u00040\"I1q\u001a\u0001\u0012\u0002\u0013%1q\r\u0005\n\u0007#\u0004\u0011\u0013!C\u0005\u0007'Dqaa6\u0001\t\u0013\u0019I\u000eC\u0005\u0004p\u0002\t\n\u0011\"\u0003\u0004r\"I1Q\u001f\u0001\u0012\u0002\u0013%1q\r\u0005\n\u0007o\u0004\u0011\u0013!C\u0005\u0007'Dqa!?\u0001\t\u0013\u0019Y\u0010C\u0005\u0005\u0006\u0001\t\n\u0011\"\u0003\u0004@!9Aq\u0001\u0001\u0005\n\u0011%\u0001\"\u0003C\t\u0001E\u0005I\u0011BB \u0011\u001d!\u0019\u0002\u0001C\u0005\t+AqA!5\u0001\t\u0013!I\u0003C\u0004\u00050\u0001!I\u0001\"\r\t\u000f\u0011U\u0002\u0001\"\u0003\u00058!9A1\b\u0001\u0005\n\u0011u\"A\u0004'pO\u000ecW-\u00198feR+7\u000f\u001e\u0006\u0003W2\f1\u0001\\8h\u0015\u0005i\u0017!B6bM.\f7\u0001A\n\u0003\u0001A\u0004\"!\u001d;\u000e\u0003IT\u0011a]\u0001\u0006g\u000e\fG.Y\u0005\u0003kJ\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001y!\tI\b!D\u0001k\u0003\u0019!X\u000e\u001d3jeV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011AA5p\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004}\n!a)\u001b7f\u0003\u001d!X\u000e\u001d3je\u0002\n1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\u00111|w\r\u0015:paN,\"!a\u0005\u0011\t\u0005U\u00111D\u0007\u0003\u0003/QA!!\u0007\u0002\u0002\u0005!Q\u000f^5m\u0013\u0011\ti\"a\u0006\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005m_\u001e\u0004&o\u001c9tA\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003K\u00012!_A\u0014\u0013\r\tIC\u001b\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]B.A\u0003vi&d7/\u0003\u0003\u0002<\u0005U\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0013QD'o\u001c;uY\u0016\u0014XCAA\"!\u0011\t\u0019$!\u0012\n\t\u0005\u001d\u0013Q\u0007\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!!X-\u0019:e_^tGCAA(!\r\t\u0018\u0011K\u0005\u0004\u0003'\u0012(\u0001B+oSRD3ADA,!\u0011\tI&a\u001b\u000e\u0005\u0005m#\u0002BA/\u0003?\n1!\u00199j\u0015\u0011\t\t'a\u0019\u0002\u000f),\b/\u001b;fe*!\u0011QMA4\u0003\u0015QWO\\5u\u0015\t\tI'A\u0002pe\u001eLA!!\u001c\u0002\\\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001c\bfA\b\u0002tA!\u0011\u0011LA;\u0013\u0011\t9(a\u0017\u0003\tQ+7\u000f^\u0001/i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0007>t7-\u001e:sK:$8+Z4nK:$H)\u001a7fi&|g\u000eK\u0002\u0011\u0003g\nq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD3!EA:\u0003}!Xm\u001d;EkBd\u0017nY1uK\u000eCWmY6BMR,'o\u00117fC:Lgn\u001a\u0015\u0004%\u0005M\u0014!\t;fgR\u0014\u0015m]5d)J\fgn]1di&|g.Q<be\u0016\u001cE.Z1oS:<\u0007fA\n\u0002t\u0005yD/Z:u\u0003\n|'\u000f^3e\t\u0006$\u0018-\u00118e\u001b\u0006\u00148.\u001a:SK6|g/\u001a3J[6,G-[1uK2Lx+\u001b;i\u001d>$U\r\\3uKJ+G/\u001a8uS>t\u0007f\u0001\u000b\u0002t\u0005yE/Z:u\u0003\n|'\u000f^3e\t\u0006$\u0018-\u00118e\u001b\u0006\u00148.\u001a:SKR\f\u0017N\\3e)>\u0004&/Z:feZ,7+Z9vK:\u001cW-\u00118e\u000bB|7\r[,ji\"tu\u000eR3mKR,'+\u001a;f]RLwN\u001c\u0015\u0004+\u0005M\u0014!\u0015;fgR\u001cu.\\7jiR,G\rR1uC\u0006sG-T1sW\u0016\u0014(+Z7pm\u0016$\u0017*\\7fI&\fG/\u001a7z\u0013\u001atunS3zgJ+G/Y5oK\u0012<\u0016\u000e\u001e5O_\u0012+G.\u001a;f%\u0016$XM\u001c;j_:D3AFA:\u0003E#Xm\u001d;D_6l\u0017\u000e\u001e;fI\u0012\u000bG/Y!oI6\u000b'o[3s%\u0016$\u0018-\u001b8fIR{\u0007K]3tKJ4XmU3rk\u0016t7-Z!oI\u0016\u0003xn\u00195XSRDgj\u001c#fY\u0016$XMU3uK:$\u0018n\u001c8)\u0007]\t\u0019(A\u0015uKN$8\t\\3b]^KG\u000f\u001b+sC:\u001c\u0018m\u0019;j_:\u001c8\u000b]1o]&twmU3h[\u0016tGo\u001d\u0015\u00041\u0005M\u0014a\u0006;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016lwN^1mQ\rI\u00121O\u0001%i\u0016\u001cH\u000fR3mKR,GMQ1uG\",7oV5uQ:{W*Z:tC\u001e,7OU3bI\"\u001a!$a\u001d\u0002OQ,7\u000f^\"p[6LG/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u00047\u0005M\u0014A\u0007;fgR\u001cE.Z1o\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001\u000f\u0002t\u0005AC/Z:u\u0007>lW.\u001b;uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8Ta\u0006tg.\u001b8h'\u0016<W.\u001a8ug\"\u001aQ$a\u001d\u0002MQ,7\u000f^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0006/\u00198oS:<7+Z4nK:$8\u000fK\u0002\u001f\u0003g\na\u0003^3ti\u0006\u0013wN\u001d;NCJ\\WM\u001d*f[>4\u0018\r\u001c\u0015\u0004?\u0005M\u0014A\n;fgR,U\u000e\u001d;z\u0005\u0006$8\r\u001b*f[>4\u0018\r\\,ji\"\u001cV-];f]\u000e,'+Z;tK\"\u001a\u0001%a\u001d\u0002MQ,7\u000f^!c_J$X*\u0019:lKJ\u0014V\r^3oi&|gnV5uQ\u0016k\u0007\u000f^=CCR\u001c\u0007\u000eK\u0002\"\u0003g\n\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0007\t\n\u0019(A\u0012uKN$X*Z:tC\u001e,G*\u0019:hKJ$\u0006.\u00198NCblUm]:bO\u0016\u001c\u0016N_3)\u0007\r\n\u0019(\u0001\u001buKN$X*Z:tC\u001e,G*\u0019:hKJ$\u0006.\u00198NCblUm]:bO\u0016\u001c\u0016N_3XSRD7i\u001c:skB$\b*Z1eKJD3\u0001JA:\u00039\"Xm\u001d;D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3TSj,G*\u0019:hKJ$\u0006.\u00198CsR,7/\u0011<bS2\f'\r\\3)\u0007\u0015\n\u0019(\u0001\u0014de\u0016\fG/\u001a'pO^KG\u000f['fgN\fw-Z:MCJ<WM\u001d+iC:l\u0015\r_*ju\u0016$B!!6\u0002hB9\u0011/a6\u0002\\\u0006\u0005\u0018bAAme\n1A+\u001e9mKJ\u00022!_Ao\u0013\r\tyN\u001b\u0002\f\u0003\n\u001cHO]1di2{w\rE\u0002z\u0003GL1!!:k\u000551\u0015m[3PM\u001a\u001cX\r^'ba\"9\u0011\u0011\u001e\u0014A\u0002\u0005-\u0018\u0001\u00057be\u001e,W*Z:tC\u001e,7+\u001b>f!\r\t\u0018Q^\u0005\u0004\u0003_\u0014(aA%oi\u00069B/Z:u\u00072,\u0017M\\5oO^KG\u000f\u001b#fY\u0016$Xm\u001d\u0015\u0004O\u0005M\u0014a\u0005;fgRdunZ\"mK\u0006tWM]*uCR\u001c\bf\u0001\u0015\u0002t\u0005IC/Z:u\u0019><7\t\\3b]\u0016\u0014(+\u001a;bS:\u001c\bK]8ek\u000e,'\u000fT1tiN+\u0017/^3oG\u0016D3!KA:\u0003e\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]Nd\u0015m\u001d;TKF,XM\\2f\u000bZ,g.\u00134Ue\u0006t7/Y2uS>t\u0017IY8si\u0016$\u0007f\u0001\u0016\u0002t\u00059B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0004W\u0005M\u0014A\t;fgR\u001cE.Z1oS:<w+\u001b;i+:\u001cG.Z1oC\ndWmU3di&|g\u000eK\u0002-\u0003g\na\u0002^3ti2{w\rV8DY\u0016\fg\u000eK\u0002.\u0003g\nA\u0005^3ti2{w\rV8DY\u0016\fgnV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004]\u0005M\u0014a\b;fgR\u001cE.Z1oS:<w+\u001b;i+:\\W-_3e\u001b\u0016\u001c8/Y4fg\"\u001aq&a\u001d\u000211\f7\u000f^(gMN,Go\u001d)fe\n\u000bGo\u00195J]2{w\r\u0006\u0003\u0003\u001a\t-\u0002C\u0002B\u000e\u0005C\u0011)#\u0004\u0002\u0003\u001e)\u0019!q\u0004:\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003$\tu!\u0001C%uKJ\f'\r\\3\u0011\u0007E\u00149#C\u0002\u0003*I\u0014A\u0001T8oO\"11\u000e\ra\u0001\u00037\f!\u0003\\1tiN+\u0017/^3oG\u0016\u001c\u0018J\u001c'pOR!!\u0011\u0007B\u001c!!\u0011YBa\r\u0003&\u0005-\u0018\u0002\u0002B\u001b\u0005;\u00111!T1q\u0011\u0019Y\u0017\u00071\u0001\u0002\\\u0006aqN\u001a4tKR\u001c\u0018J\u001c'pOR!!\u0011\u0004B\u001f\u0011\u0019Y'\u00071\u0001\u0002\\\u0006ARO\\6fs\u0016$W*Z:tC\u001e,7i\\;oi&sGj\\4\u0015\t\u0005-(1\t\u0005\u0007WN\u0002\r!a7\u0002\u001d\u0005\u0014wN\u001d;DQ\u0016\u001c7\u000eR8oKR!\u0011q\nB%\u0011\u001d\u0011Y\u0005\u000ea\u0001\u0005\u001b\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003P\tmSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\r\r|W.\\8o\u0015\ri'q\u000b\u0006\u0005\u00053\n9'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0005;\u0012\tF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u00025Q,7\u000f^\"mK\u0006t7+Z4nK:$8oV5uQ\u0006\u0013wN\u001d;)\u0007U\n\u0019(A\nuKN$8+Z4nK:$xI]8va&tw\rK\u00027\u0003g\nA\u0007^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001e<\u0016\u000e\u001e5Ta\u0006\u00148/Z(gMN,Go]!oI\u0016k\u0007\u000f^=TK\u001elWM\u001c;tQ\r9\u00141O\u0001%i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgnZ,ji\"\u001c\u0006/\u0019:tK>3gm]3ug\"\u001a\u0001(a\u001d\u0002WQ,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4G_2dwn^5oO2{\u0017\rZ(g5\u0016\u0014x.\u00138eKbD3!OA:\u0003E\u0019\u0007.Z2l'\u0016<W.\u001a8u\u001fJ$WM\u001d\u000b\u0005\u0003\u001f\u00129\bC\u0004\u0003zi\u0002\rAa\u001f\u0002\r\u001d\u0014x.\u001e9t!\u0019\u0011YB! \u0003\u0002&!!q\u0010B\u000f\u0005\r\u0019V-\u001d\t\u0007\u00057\u0011iHa!\u0011\u0007e\u0014))C\u0002\u0003\b*\u0014!\u0002T8h'\u0016<W.\u001a8u\u0003I!Xm\u001d;Ck&dGm\u00144gg\u0016$X*\u00199)\u0007m\n\u0019(A\u000fuKN$8+Z4nK:$x+\u001b;i\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8xQ\ra\u00141O\u0001\u0017i\u0016\u001cHOU3d_Z,'/_!gi\u0016\u00148I]1tQ\"\u001aQ(a\u001d\u00027Q,7\u000f\u001e\"vS2$wJ\u001a4tKRl\u0015\r\u001d$bW\u0016d\u0015M]4fQ\rq\u00141O\u0001\u001ai\u0016\u001cHOQ;jY\u0012\u0004\u0016M\u001d;jC2|eMZ:fi6\u000b\u0007\u000fK\u0002@\u0003g\n!\u0004^3ti\u000ecW-\u00198D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3TKRD3\u0001QA:\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002B\u0003g\n!\u0006^3tiR{WNY:u_:,7\t\\3b]&twmV5uQ:{G)\u001a7fi\u0016\u0014V\r^3oi&|g\u000eK\u0002C\u0003g\n!\u0003^3ti\u000ecW-\u00198U_6\u00147\u000f^8oK\"\u001a1)a\u001d\u0002AQ,7\u000f^\"mK\u0006t\u0017N\\4CKf|g\u000eZ'jgNLgnZ(gMN,Go\u001d\u0015\u0004\t\u0006M\u0014\u0001\u0006;fgRl\u0015\r_\"mK\u0006tG+[7f'\u0016\u001c7\u000fK\u0002F\u0003g\n!b\u001e:ji\u0016$v\u000eT8h)!\u0011IB!/\u0003<\n\r\u0007BB6G\u0001\u0004\tY\u000eC\u0004\u0003>\u001a\u0003\rAa0\u0002\u001b-,\u0017p]!oIZ\u000bG.^3t!\u0019\u0011YB!\t\u0003BB9\u0011/a6\u0002l\u0006-\bb\u0002Bc\r\u0002\u0007!\u0011D\u0001\n_\u001a47/\u001a;TKF\fQ#\u001b8wC2LGm\u00117fC:,G-T3tg\u0006<W\r\u0006\u0005\u0003L\n]'1\u001cBo!\u0011\u0011iMa5\u000e\u0005\t='\u0002\u0002Bi\u0005#\naA]3d_J$\u0017\u0002\u0002Bk\u0005\u001f\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002Bm\u000f\u0002\u0007!QE\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\t\u000f\tuv\t1\u0001\u0003@\"I!q\\$\u0011\u0002\u0003\u0007!\u0011]\u0001\u0006G>$Wm\u0019\t\u0005\u0005\u001b\u0014\u0019/\u0003\u0003\u0003f\n='aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003l*\"!\u0011\u001dBwW\t\u0011y\u000f\u0005\u0003\u0003r\nmXB\u0001Bz\u0015\u0011\u0011)Pa>\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B}e\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu(1\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E7fgN\fw-Z,ji\"|eMZ:fiRA!1ZB\u0002\u0007'\u00199\u0002C\u0004\u0004\u0006%\u0003\raa\u0002\u0002\u0007-,\u0017\u0010E\u0003r\u0007\u0013\u0019i!C\u0002\u0004\fI\u0014Q!\u0011:sCf\u00042!]B\b\u0013\r\u0019\tB\u001d\u0002\u0005\u0005f$X\rC\u0004\u0004\u0016%\u0003\raa\u0002\u0002\u000bY\fG.^3\t\u000f\re\u0011\n1\u0001\u0003&\u00051qN\u001a4tKR$\u0002Ba3\u0004\u001e\r}1\u0011\u0005\u0005\b\u0007\u000bQ\u0005\u0019AAv\u0011\u001d\u0019)B\u0013a\u0001\u0003WDqa!\u0007K\u0001\u0004\u0011)#A\u0004nC.,Gj\\4\u0015\u0011\u0005m7qEB\u0015\u0007[A\u0001\"a\u0003L!\u0003\u0005\r\u0001 \u0005\n\u0007WY\u0005\u0013!a\u0001\u0003K\taaY8oM&<\u0007\"CB\u0018\u0017B\u0005\t\u0019\u0001B\u0013\u00035\u0011XmY8wKJL\bk\\5oi\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rU\"f\u0001?\u0003n\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rm\"\u0006BA\u0013\u0005[\f\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tE\u000b\u0003\u0003&\t5\u0018aC7bW\u0016\u001cE.Z1oKJ$\u0002ba\u0012\u0004N\rE31\f\t\u0004s\u000e%\u0013bAB&U\n91\t\\3b]\u0016\u0014\bbBB(\u001f\u0002\u0007\u00111^\u0001\tG\u0006\u0004\u0018mY5us\"I11K(\u0011\u0002\u0003\u00071QK\u0001\nG\",7m\u001b#p]\u0016\u0004r!]B,\u0005\u001b\ny%C\u0002\u0004ZI\u0014\u0011BR;oGRLwN\\\u0019\t\u0013\rus\n%AA\u0002\u0005-\u0018AD7bq6+7o]1hKNK'0Z\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\u0019G\u000b\u0003\u0004V\t5\u0018!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HeM\u000b\u0003\u0007SRC!a;\u0003nR1!\u0011DB7\u0007_Baa\u001b*A\u0002\u0005m\u0007bBB9%\u0002\u0007!qX\u0001\u0004g\u0016\fH\u0003BB;\u0007\u0003\u0003Baa\u001e\u0004~5\u00111\u0011\u0010\u0006\u0005\u0007w\n\t!A\u0002oS>LAaa \u0004z\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\r\r5\u000b1\u0001\u0003&\u0005\u0011\u0011\u000e\u001a\u000b\u000f\u0005\u0017\u001c9i!#\u0004\f\u000e=5\u0011TBO\u0011\u001d\u0019)\u0001\u0016a\u0001\u0003WDqa!\u0006U\u0001\u0004\tY\u000fC\u0005\u0004\u000eR\u0003\n\u00111\u0001\u0003&\u0005Q\u0001O]8ek\u000e,'/\u00133\t\u0013\rEE\u000b%AA\u0002\rM\u0015!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002r\u0007+K1aa&s\u0005\u0015\u0019\u0006n\u001c:u\u0011%\u0019Y\n\u0016I\u0001\u0002\u0004\tY/\u0001\u0005tKF,XM\\2f\u0011%\u0019y\n\u0016I\u0001\u0002\u0004\tY/\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r[\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIM\n\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u001d&\u0006BBJ\u0005[\f\u0001C]3d_J$G\u0005Z3gCVdG\u000fJ\u001b\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u00122\u0014aG1qa\u0016tG\r\u0016:b]N\f7\r^5p]\u0006d\u0017i\u001d'fC\u0012,'\u000f\u0006\u0007\u00042\u000em6QXB`\u0007\u0003\u001c)\rE\u0004r\u0007/\u001a\u0019l!.\u0011\r\tm!QPAv!\rI8qW\u0005\u0004\u0007sS'!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0003\u0004l3\u0002\u0007\u00111\u001c\u0005\b\u0007\u001bK\u0006\u0019\u0001B\u0013\u0011\u001d\u0019\t*\u0017a\u0001\u0007'C\u0011ba1Z!\u0003\u0005\r!a;\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0007\u000fL\u0006\u0013!a\u0001\u0007\u0013\faa\u001c:jO&t\u0007cA=\u0004L&\u00191Q\u001a6\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\u0002K\u0005\u0004\b/\u001a8e)J\fgn]1di&|g.\u00197Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\"\u0014!J1qa\u0016tG\r\u0016:b]N\f7\r^5p]\u0006d\u0017i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019)N\u000b\u0003\u0004J\n5\u0018\u0001G1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193feRq1\u0011WBn\u0007;\u001cyn!9\u0004l\u000e5\bBB6]\u0001\u0004\tY\u000eC\u0004\u0004\u000er\u0003\rA!\n\t\u000f\rEE\f1\u0001\u0004\u0014\"I11\u001d/\u0011\u0002\u0003\u00071Q]\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0019\u0011oa:\n\u0007\r%(OA\u0004C_>dW-\u00198\t\u0013\r\rG\f%AA\u0002\u0005-\b\"CBd9B\u0005\t\u0019ABe\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u001f\u0016\u0005\u0007K\u0014i/\u0001\u0012baB,g\u000eZ%eK6\u0004x\u000e^3oi\u0006\u001bH*Z1eKJ$C-\u001a4bk2$H%N\u0001#CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002\u0019\r|W.\\5u\u001b\u0006\u00148.\u001a:\u0015\u0011\t-7Q`B\u0000\t\u0003Aqa!$a\u0001\u0004\u0011)\u0003C\u0004\u0004\u0012\u0002\u0004\raa%\t\u0013\u0011\r\u0001\r%AA\u0002\t\u0015\u0012!\u0003;j[\u0016\u001cH/Y7q\u0003Y\u0019w.\\7ji6\u000b'o[3sI\u0011,g-Y;mi\u0012\u001a\u0014aC1c_J$X*\u0019:lKJ$\u0002Ba3\u0005\f\u00115Aq\u0002\u0005\b\u0007\u001b\u0013\u0007\u0019\u0001B\u0013\u0011\u001d\u0019\tJ\u0019a\u0001\u0007'C\u0011\u0002b\u0001c!\u0003\u0005\rA!\n\u0002+\u0005\u0014wN\u001d;NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aQM\u001c3Uq:l\u0015M]6feRa!1\u001aC\f\t3!Y\u0002\"\n\u0005(!91Q\u00123A\u0002\t\u0015\u0002bBBII\u0002\u000711\u0013\u0005\b\t;!\u0007\u0019\u0001C\u0010\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u0005\u0005\u001b$\t#\u0003\u0003\u0005$\t='!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"91\u0011\u00043A\u0002\t\u0015\u0002b\u0002C\u0002I\u0002\u0007!Q\u0005\u000b\u0007\u0005\u0017$Y\u0003\"\f\t\u000f\r\u0015Q\r1\u0001\u0002l\"91QC3A\u0002\r\u001d\u0011!D;oW\u0016LX\r\u001a*fG>\u0014H\r\u0006\u0003\u0003L\u0012M\u0002bBB\u000bM\u0002\u0007\u00111^\u0001\u0010i>l'm\u001d;p]\u0016\u0014VmY8sIR!!1\u001aC\u001d\u0011\u001d\u0019)a\u001aa\u0001\u0003W\fqB]3d_Z,'/\u00118e\u0007\",7m\u001b\u000b\u0007\u00037$y\u0004\"\u0011\t\u000f\r-\u0002\u000e1\u0001\u0002&!9A1\t5A\u0002\te\u0011\u0001D3ya\u0016\u001cG/\u001a3LKf\u001c\b")
public class LogCleanerTest {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$22, x$12, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.localLogSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$2)))), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        int maxProducerIdExpirationMs = 3600000;
        LogSegments logSegments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.dir(), topicPartition, logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), maxProducerIdExpirationMs, (Time)this.time());
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(this.dir(), topicPartition, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, logSegments, 0L, 0L, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        File x$1 = this.dir();
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        MockScheduler x$6 = this.time().scheduler();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        MockTime x$9 = this.time();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$15 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L;
        None$ x$16 = None$.MODULE$;
        boolean x$17 = true;
        NoOpLogOffsetsListener$ x$18 = NoOpLogOffsetsListener$.MODULE$;
        Function1 x$19 = Log$.MODULE$.$lessinit$greater$default$16();
        Option x$20 = Log$.MODULE$.$lessinit$greater$default$20();
        Log localLog = new Log(x$1, config, logSegments, x$4, x$5, (Scheduler)x$6, x$7, x$8, (Time)x$9, x$10, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)x$18, x$19, (Function0)x$15, (Option)x$16, x$17, x$20);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.dir(), topicPartition, localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler());
        MergedLog log = new MergedLog(null, localLog, tierPartitionState, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super(localLog$1, 0L, true, tierPartitionState$1, TierLogComponents$.MODULE$.EMPTY());
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final MergedLog log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            log.roll(log.roll$default$1());
        }
        Assertions.assertEquals((int)3, (int)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.localLogSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log.localLogSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap((AbstractLog)log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments((AbstractLog)log, segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assertions.assertEquals((int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertTrue((((LogSegment)log.localLogSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0, (String)"Cleaned segment file should be trimmed to its real size.");
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$2, x$1, x$3));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((AbstractLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((AbstractLog)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((AbstractLog)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        AbstractLog qual$1 = (AbstractLog)log.elem;
        Option x$4 = qual$1.roll$default$1();
        qual$1.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (AbstractLog)log.elem, 0L, ((AbstractLog)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTestUtils$.MODULE$.keysInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((AbstractLog)log.elem));
        this.reloadLog$1(log, logProps);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((AbstractLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((AbstractLog)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assertions.assertEquals((long)6L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((AbstractLog)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assertions.assertEquals((long)3L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((AbstractLog)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        AbstractLog qual$2 = (AbstractLog)log.elem;
        Option x$5 = qual$2.roll$default$1();
        qual$2.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (AbstractLog)log.elem, 0L, ((AbstractLog)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTestUtils$.MODULE$.keysInLog((AbstractLog)log.elem));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((AbstractLog)log.elem));
        this.reloadLog$1(log, logProps);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((AbstractLog)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((long)0L, (long)((LogOffsetMetadata)logAppendInfo.firstOffset().get()).messageOffset());
        Assertions.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertTrue((boolean)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()).nonEmpty());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testAbortedDataAndMarkerRemovedImmediatelyWithNoDeleteRetention() {
        Properties properties = new Properties();
        properties.put("delete.retention.ms", "0");
        LogConfig logConfig = new LogConfig((java.util.Map)properties, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        int leaderEpoch = 0;
        short producerEpoch = (short)0;
        int producerId = 1;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, leaderEpoch, this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3()).clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)LogTestUtils$.MODULE$.keysInLog(log).toSet());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedDataAndMarkerRetainedToPreserveSequenceAndEpochWithNoDeleteRetention() {
        Properties properties = new Properties();
        properties.put("delete.retention.ms", "0");
        LogConfig logConfig = new LogConfig((java.util.Map)properties, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        int leaderEpoch = 0;
        short producerEpoch = (short)0;
        int producerId = 1;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, leaderEpoch, this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3()).clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedDataAndMarkerRemovedImmediatelyIfNoKeysRetainedWithNoDeleteRetention() {
        Properties properties = new Properties();
        properties.put("delete.retention.ms", "0");
        LogConfig logConfig = new LogConfig((java.util.Map)properties, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        int leaderEpoch = 0;
        short producerEpoch = (short)0;
        int producerId = 1;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, leaderEpoch, this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3()).clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedDataAndMarkerRetainedToPreserveSequenceAndEpochWithNoDeleteRetention() {
        Properties properties = new Properties();
        properties.put("delete.retention.ms", "0");
        LogConfig logConfig = new LogConfig((java.util.Map)properties, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        int leaderEpoch = 0;
        short producerEpoch = (short)0;
        int producerId1 = 1;
        int producerId2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, producerId1, producerEpoch, leaderEpoch, this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId1, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        this.appendTransactionalAsLeader(log, producerId2, producerEpoch, leaderEpoch, this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        log.appendAsLeader(this.commitMarker(producerId2, producerEpoch, this.commitMarker$default$3()), leaderEpoch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3()).clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 7, 8})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()))._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTestUtils$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTestUtils$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 100;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$5, x$4, x$6);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int x$8 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$8, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int x$13 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$13, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assertions.assertEquals((int)0, (int)log.collectAbortedTransactions(0L, 100L).size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((int)0, (int)log.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$32 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$32, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$5, x$4, x$6);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)((LogSegment)log.localLogSegments().head()), (List)Nil$.MODULE$), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$3)))), LogTestUtils$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<AbstractLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(x$1, x$3, x$2).cleanSegments((AbstractLog)log2, (Seq)new .colon.colon((Object)((LogSegment)log2.localLogSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        Assertions.assertEquals((Object)((Iterable)LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2).filter((Function1)((JFunction1.mcZJ.sp & Serializable & scala.Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)offsetMap2, arg_0)))), LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<AbstractLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.localLogSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (AbstractLog)log2, (FakeOffsetMap)offsetMap2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<AbstractLog, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.localLogSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions.assertThrows(CorruptRecordException.class, () -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (AbstractLog)log2, (FakeOffsetMap)offsetMap2));
    }

    public Tuple2<AbstractLog, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keysFound = LogTestUtils$.MODULE$.keysInLog(log);
        Assertions.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log.updateConfig(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable & scala.Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Set keys = LogTestUtils$.MODULE$.keysInLog(log).toSet();
        Assertions.assertTrue((boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$7))), (String)"None of the keys we deleted should still exist.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerStats() {
        void var13_10;
        void var11_9;
        Cleaner cleaner = this.makeCleaner(4, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((long)5L, (long)var11_9);
        Assertions.assertEquals((long)5L, (long)var13_10.messagesRead());
        Assertions.assertEquals((long)initialLogSize, (long)var13_10.bytesRead());
        Assertions.assertEquals((long)2L, (long)var13_10.messagesWritten());
        Assertions.assertEquals((long)log.size(), (long)var13_10.bytesWritten());
        Assertions.assertEquals((long)0L, (long)var13_10.invalidMessagesRead());
        Assertions.assertTrue((var13_10.endTime() >= var13_10.startTime() ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.6, (double)log.lastShrinkageRatio(), (double)0.001);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)Nil$.MODULE$, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 > N), (String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.");
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))), (String)"The cleanable segments should have fewer number of values after cleaning");
        Assertions.assertTrue((boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))), (String)"The uncleanable segments should have the same number of values after cleaning");
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        Assertions.assertEquals((long)new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()).totalBytes(), (long)(log.size() - (long)log.activeSegment().size()), (String)"Total bytes of LogToClean should equal size of all segments excluding the active segment");
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        Seq segs = log.localLogSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), LogToClean$.MODULE$.apply$default$5());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertEquals((long)logToClean.cleanBytes(), (long)expectedCleanSize, (String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty");
        Assertions.assertEquals((long)logToClean.cleanableBytes(), (long)expectedCleanableSize, (String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset");
        Assertions.assertEquals((long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize), (String)"Total bytes should be the sum of the clean and cleanable segments");
        Assertions.assertEquals((double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6, (String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var14_11;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assertions.assertEquals((int)0, (int)this.unkeyedMessageCountInLog(log), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)expectedSizeAfterCleaning, (long)log.size(), (String)"Log should only contain keyed messages after cleaning.");
        Assertions.assertEquals((long)numInvalidMessages, (long)var14_11.invalidMessagesRead(), (String)"Cleaner should have seen %d invalid messages.");
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(AbstractLog log) {
        return ((TraversableOnce)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable & scala.Serializable)batch -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(AbstractLog log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        void makeCleaner_checkDone;
        void makeCleaner_maxMessageSize;
        int n = this.makeCleaner$default$3();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), (int)makeCleaner_maxMessageSize, (int)makeCleaner_maxMessageSize, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        Iterable<Object> keys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$15))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assertions.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assertions.assertTrue((boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$16))), (String)"All groups should be singletons.");
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.localLogSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$18))), (String)"All but the last group should be the target size.");
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.localLogSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$19)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assertions.assertTrue((boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$20))), (String)"All but the last group should be the target size.");
    }

    @Test
    public void testSegmentGroupingWithSparseOffsetsAndEmptySegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        byte[] k = "key".getBytes();
        byte[] v = "val".getBytes();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            MemoryRecords records = this.messageWithOffset(k, v, ((long)i + 1L) * 0x80000000L - 1L);
            log.appendAsFollower(records);
            Assertions.assertEquals((int)(i + 1), (int)log.numberOfSegments());
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(v, k, TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        int totalSegments = 4;
        long firstUncleanableOffset = log.logEndOffset() - 1L;
        int notCleanableSegments = 1;
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        List groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(totalSegments - notCleanableSegments), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((int)totalSegments, (int)log.numberOfSegments());
        Assertions.assertEquals((int)0, (int)((LogSegment)log.localLogSegments().head()).size());
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, firstUncleanableOffset);
        Assertions.assertEquals((int)(1 + 1), (int)groups.size());
        cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((int)(totalSegments - 1), (int)log.numberOfSegments());
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)1, (int)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)(log.numberOfSegments() - 1), (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, x$1, x$3);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assertions.assertTrue((log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Actual offset range should be > Int.MaxValue");
        Assertions.assertTrue((((LogSegment)log.localLogSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"index.lastOffset is reporting the wrong last offset");
        List groups = cleaner.groupSegmentsBySize(log.localLogSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assertions.assertEquals((int)2, (int)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> (Seq)x$21.map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)x$22.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets, (String)"Offsets should be in increasing order.");
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        AbstractLog log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.localLogSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        long x$2 = Long.MAX_VALUE;
        File x$3 = this.makeLog$default$1();
        AbstractLog log = this.makeLog(x$3, config, x$2);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        int numSegmentsInitial = log.localLogSegments().size();
        List allKeys = LogTestUtils$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            expectedKeysAfterCleaning.$plus$eq(allKeys.apply(k - 1));
            offsetMap.put(this.key(BoxesRunTime.unboxToLong((Object)allKeys.apply(k))), Long.MAX_VALUE);
        });
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)log.localLogSegments().size());
        Assertions.assertEquals((Object)allKeys, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentToClean, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)expectedKeysAfterCleaning, LogTestUtils$.MODULE$.keysInLog(log));
        Assertions.assertFalse((boolean)LogTestUtils$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, config, x$3);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$5 = 0;
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            RequestLocal x$8 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$4, x$5, x$6, x$7, x$8);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTestUtils$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.localLogSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.localLogSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        ((LogSegment)log.localLogSegments().head()).log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.localLogSegments().head()).log().file().getPath(), Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix())));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.localLogSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$6(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$7(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$9 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$10 = 0;
            AppendOrigin x$11 = log.appendAsLeader$default$3();
            ApiVersion x$12 = log.appendAsLeader$default$4();
            RequestLocal x$13 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$9, x$10, x$11, x$12, x$13);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.localLogSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$14 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$15 = 0;
            AppendOrigin x$16 = log.appendAsLeader$default$3();
            ApiVersion x$17 = log.appendAsLeader$default$4();
            RequestLocal x$18 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$14, x$15, x$16, x$17, x$18);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.localLogSegments().head()).timeIndex().file().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.localLogSegments().head()).timeIndex().file().getPath(), "", Log$.MODULE$.SwapFileSuffix())));
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$19 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$20 = 0;
            AppendOrigin x$21 = log.appendAsLeader$default$3();
            ApiVersion x$22 = log.appendAsLeader$default$4();
            RequestLocal x$23 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$19, x$20, x$21, x$22, x$23);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        ((LogSegment)log.localLogSegments().head()).timeIndex().file().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(((LogSegment)log.localLogSegments().head()).timeIndex().file().getPath(), "", Log$.MODULE$.SwapFileSuffix())));
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$24 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$25 = 0;
            AppendOrigin x$26 = log.appendAsLeader$default$3();
            ApiVersion x$27 = log.appendAsLeader$default$4();
            RequestLocal x$28 = log.appendAsLeader$default$5();
            log.appendAsLeader(x$24, x$25, x$26, x$27, x$28);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.localLogSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTestUtils$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((long)offsetEnd, (long)map.latestOffset(), (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(keyEnd - keyStart), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        Assertions.assertEquals((long)0L, (long)map.get(this.key(0L)), (String)"Map should contain first value");
        Assertions.assertEquals((long)offsetEnd, (long)map.get(this.key(1L)), (String)"Map should contain second value");
    }

    @Test
    public void testBuildPartialOffsetMap() {
        AbstractLog log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        OffsetMap map = cleaner.offsetMap();
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, map, stats);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assertions.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assertions.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assertions.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3()).buffer());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTombstoneCleaningWithNoDeleteRetention() {
        Properties properties = new Properties();
        properties.put("delete.retention.ms", "0");
        LogConfig logConfig = new LogConfig((java.util.Map)properties, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        this.append$1(1L, (Option)new Some((Object)"1"), log);
        this.append$1(2L, (Option)new Some((Object)"2"), log);
        this.append$1(3L, (Option)new Some((Object)"3"), log);
        this.append$1(2L, (Option)None$.MODULE$, log);
        this.append$1(1L, (Option)None$.MODULE$, log);
        log.roll(log.roll$default$1());
        this.append$1(2L, (Option)new Some((Object)"2"), log);
        this.append$1(4L, (Option)new Some((Object)"4"), log);
        this.append$1(3L, (Option)None$.MODULE$, log);
        log.roll(log.roll$default$1());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L, 4L})), (Object)LogTestUtils$.MODULE$.keysInLog(log).toSet());
        this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3()).clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 4L})), (Object)LogTestUtils$.MODULE$.keysInLog(log).toSet());
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        AbstractLog log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$7 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$8 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, x$8), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$12 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$13 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, x$13), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.localLogSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType x$17 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$18 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assertions.assertEquals((long)1L, (long)((RecordBatch)((LogSegment)log.localLogSegments().head()).log().batches().iterator().next()).lastOffset(), (String)"The tombstone should be retained.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_9;
        void var6_6;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(0x100000));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        AbstractLog log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)11L)));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)var6_6, (String)"Cleaning point should pass offset gap");
        AbstractLog log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(0L)).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)15L)));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24).zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(15), 24), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong(Predef$.MODULE$.longWrapper(15L)).to((Object)BoxesRunTime.boxToLong((long)24L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)30L)));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)log2.activeSegment().baseOffset(), (long)var10_9, (String)"Cleaning point should pass offset gap in multiple segments");
    }

    @Test
    public void testMaxCleanTimeSecs() {
        LogCleaner logCleaner = new LogCleaner(new CleanerConfig(CleanerConfig$.MODULE$.$lessinit$greater$default$1(), CleanerConfig$.MODULE$.$lessinit$greater$default$2(), CleanerConfig$.MODULE$.$lessinit$greater$default$3(), CleanerConfig$.MODULE$.$lessinit$greater$default$4(), CleanerConfig$.MODULE$.$lessinit$greater$default$5(), CleanerConfig$.MODULE$.$lessinit$greater$default$6(), CleanerConfig$.MODULE$.$lessinit$greater$default$7(), CleanerConfig$.MODULE$.$lessinit$greater$default$8(), CleanerConfig$.MODULE$.$lessinit$greater$default$9(), CleanerConfig$.MODULE$.$lessinit$greater$default$10()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir()}), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()), new LogDirFailureChannel(1), (Time)this.time());
        try {
            this.checkGauge$1("max-buffer-utilization-percent", logCleaner);
            this.checkGauge$1("max-clean-time-secs", logCleaner);
            this.checkGauge$1("max-compaction-delay-secs", logCleaner);
        }
        finally {
            logCleaner.shutdown();
        }
    }

    private Iterable<Object> writeToLog(AbstractLog log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null))).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$24)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])Integer.toString(kv._1$mcI$sp()).getBytes(), (byte[])Integer.toString(kv._2$mcI$sp()).getBytes()), Iterable$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToInteger((int)x$25.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(Integer.toString(key).getBytes(), Integer.toString(value).getBytes(), offset);
    }

    private AbstractLog makeLog(File dir, LogConfig config, long recoveryPoint) {
        long x$3 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        boolean x$14 = true;
        boolean x$15 = true;
        LogOffsetsListener x$16 = Log$.MODULE$.apply$default$16();
        Option x$17 = Log$.MODULE$.apply$default$17();
        return Log$.MODULE$.apply(dir, config, x$3, recoveryPoint, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, (Option)x$13, x$15, (Option)x$12, x$14, x$16, x$17);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$26 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$26);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(AbstractLog log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$27)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(Long.toString(id).getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(AbstractLog log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, true, leaderEpoch, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(AbstractLog log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$1 = Integer.toString(key).getBytes();
        CompressionType x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, x$4, x$5);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(Integer.toString(value).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private AbstractLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler());
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$1) {
        ((AbstractLog)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$2 = 0L;
        File x$3 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$3, x$1, x$2);
    }

    private static final void assertAbortedTransactionIndexed$1(AbstractLog log$3, long producerId$1) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        Assertions.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(Long.toString(k));
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$1, AbstractLog log$4, FakeOffsetMap offsetMap$2) {
        cleaner$1.cleanSegments(log$4, (Seq)new .colon.colon((Object)((LogSegment)log$4.localLogSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$2, AbstractLog log$5, FakeOffsetMap offsetMap$3) {
        cleaner$2.cleanSegments(log$5, (Seq)new .colon.colon((Object)((LogSegment)log$5.localLogSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(AbstractLog log$7) {
        return ((TraversableOnce)log$7.localLogSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int before = x0$1._1$mcI$sp();
        boolean bl = x0$1._2$mcI$sp() < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$15) {
        return x$15.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$16) {
        return x$16.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$18) {
        return x$18.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$19) {
        return x$19.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$20) {
        return x$20.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assertions.assertTrue((((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Relative offset greater than Int.MaxValue");
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$4, AbstractLog log$12) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$12, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assertions.assertEquals((long)end, (long)endOffset, (String)"Last offset should be the end offset.");
        Assertions.assertEquals((int)(end - start), (int)map.size(), (String)"Should have the expected number of messages in the map.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i)), (String)"Should find all the keys"));
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(start - 1)), (String)"Should not find a value too small");
        Assertions.assertEquals((long)-1L, (long)map.get(this.key(end)), (String)"Should not find a value too large");
        Assertions.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$6(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$7(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assertions.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assertions.assertEquals((long)offset, (long)value);
    }

    private final void append$1(long key, Option value, AbstractLog log$14) {
        byte[] x$1 = Long.toString(key).getBytes();
        byte[] x$2 = (byte[])value.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.getBytes()).orNull(Predef$.MODULE$.$conforms());
        long x$3 = this.time().milliseconds();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$14.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$2, x$1, x$4, x$3, x$5), 0, log$14.appendAsLeader$default$3(), log$14.appendAsLeader$default$4(), log$14.appendAsLeader$default$5());
    }

    public static final /* synthetic */ int kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1() {
        return 999;
    }

    private final void checkGauge$1(String name, LogCleaner logCleaner$1) {
        Gauge gauge = logCleaner$1.newGauge(name, (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerTest $outer;

            public final int value() {
                return LogCleanerTest.kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, logCleaner$1.newGauge$default$3());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, AbstractLog log$15, Tuple2 x$24) {
        long offset;
        Tuple2 tuple2;
        block3: {
            block2: {
                if (x$24 == null) break block2;
                tuple2 = (Tuple2)x$24._1();
                offset = x$24._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x$24);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$15.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$26) {
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, AbstractLog log$16, Tuple2 x$27) {
        if (x$27 == null) {
            throw new MatchError(null);
        }
        int key = x$27._1$mcI$sp();
        int value = x$27._2$mcI$sp();
        long l = ((LogOffsetMetadata)log$16.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$16.appendAsLeader$default$3(), log$16.appendAsLeader$default$4(), log$16.appendAsLeader$default$5()).firstOffset().get()).messageOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = Integer.toString(key).getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$1 = Double.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        MockTime x$3 = this.time();
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$1, x$2, x$4, x$5, x$6, (Time)x$3);
    }
}

