/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00022\u0001A\u0003%A\fC\u0004d\u0001\t\u0007I\u0011\u00023\t\r5\u0004\u0001\u0015!\u0003f\u0011\u001dq\u0007A1A\u0005\n\u0011Daa\u001c\u0001!\u0002\u0013)\u0007\"\u00029\u0001\t\u0003\t\bBBA\u0003\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002\u0010\u0001!\t!\u001d\u0005\u0007\u00033\u0001A\u0011A9\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u001e\u00191\u0011q\u0005\u0001\u0005\u0003SA\u0011\"O\t\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u0015\u0013C!A!\u0002\u0013\t9\u0005\u0003\u0004E#\u0011\u0005\u0011Q\n\u0005\n\u0003/\n\"\u0019!C\u0001\u00033B\u0001Ba\u0004\u0012A\u0003%\u00111\f\u0005\u0007\u0005#\tB\u0011I9\u0007\r\tM\u0001\u0001\u0002B\u000b\u0011%I\u0004D!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002Fa\u0011\t\u0011)A\u0005\u0003\u0003Ca\u0001\u0012\r\u0005\u0002\t]\u0001B\u0002B\t1\u0011\u0005\u0013\u000fC\u0004\u0003 \u0001!IA!\t\t\u0013\t5\u0002!%A\u0005\n\t=\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0004\u0007\u0003[\u0002A)a\u001c\t\u0015\u0005u\u0004E!f\u0001\n\u0003\ty\b\u0003\u0006\u0002\b\u0002\u0012\t\u0012)A\u0005\u0003\u0003C!\"!#!\u0005+\u0007I\u0011AAF\u0011)\ti\t\tB\tB\u0003%\u0011q\t\u0005\u0007\t\u0002\"\t!a$\t\u000f\u0005U\u0005\u0005\"\u0011\u0002\u0018\"I\u0011q\u0016\u0011\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003o\u0003\u0013\u0013!C\u0001\u0003sC\u0011\"a4!#\u0003%\t!!5\t\u0013\u0005U\u0007%!A\u0005B\u0005]\u0007\"CAoA\u0005\u0005I\u0011AAF\u0011%\ty\u000eIA\u0001\n\u0003\t\t\u000fC\u0005\u0002n\u0002\n\t\u0011\"\u0011\u0002p\"I\u0011\u0011 \u0011\u0002\u0002\u0013\u0005\u00111 \u0005\n\u0005\u000b\u0001\u0013\u0011!C!\u0005\u000fA\u0011B!\u0003!\u0003\u0003%\tEa\u0003\b\u0013\t5\u0003!!A\t\n\t=c!CA7\u0001\u0005\u0005\t\u0012\u0002B)\u0011\u0019!%\u0007\"\u0001\u0003`!I\u0011Q\u0013\u001a\u0002\u0002\u0013\u0015#\u0011\r\u0005\n\u0005G\u0012\u0014\u0011!CA\u0005KB\u0011Ba\u001b3\u0003\u0003%\tI!\u001c\u0003%1{wmQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\u0006\u0003si\n1\u0001\\8h\u0015\u0005Y\u0014!B6bM.\f7\u0001A\n\u0003\u0001y\u0002\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001G!\t9\u0005!D\u00019\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8/F\u0001K!\tYe*D\u0001M\u0015\ti%(\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u0013\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%\u0001\u0004sC:$w.\\\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bQ\u0001\u0005kRLG.\u0003\u0002Y+\n1!+\u00198e_6\fqA]1oI>l\u0007%A\u0005tG\",G-\u001e7feV\tA\f\u0005\u0002^A6\taL\u0003\u0002`u\u0005)Q\u000f^5mg&\u0011\u0011M\u0018\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0005%|'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u0014AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003I\u0004\"aP:\n\u0005Q\u0004%\u0001B+oSRD#\u0001\u0004<\u0011\u0007]\f\t!D\u0001y\u0015\tI(0A\u0002ba&T!a\u001f?\u0002\u000f),\b/\u001b;fe*\u0011QP`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\r\u0001P\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001b\u001d5vi\u0012|wO\u001c\u0015\u0004\u001b\u0005%\u0001cA<\u0002\f%\u0019\u0011Q\u0002=\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR,fnY8n[&$H/\u001a3ECR\fgj\u001c;D_:\u001cX/\\3eQ\rq\u00111\u0003\t\u0004o\u0006U\u0011bAA\fq\n!A+Z:u\u0003I\"Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,GM\u0012:fcV,g\u000e^*fO6,g\u000e\u001e*pY2\u001c\bfA\b\u0002\u0014Q\u0019!/a\b\t\re\u0002\u0002\u0019AA\u0011!\r9\u00151E\u0005\u0004\u0003KA$aC!cgR\u0014\u0018m\u0019;M_\u001e\u0014AbQ8ogVlWM\u001d+bg.\u001cR!EA\u0016\u0003o\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cI\u0017\u0001\u00027b]\u001eLA!!\u000e\u00020\t1qJ\u00196fGR\u0004R!!\u000f\u0002BIl!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u000bG>t7-\u001e:sK:$(B\u0001,j\u0013\u0011\t\u0019%a\u000f\u0003\u0011\r\u000bG\u000e\\1cY\u0016\f!\u0002\\1ti>3gm]3u!\ry\u0014\u0011J\u0005\u0004\u0003\u0017\u0002%aA%oiR1\u0011qJA*\u0003+\u00022!!\u0015\u0012\u001b\u0005\u0001\u0001BB\u001d\u0015\u0001\u0004\t\t\u0003C\u0004\u0002FQ\u0001\r!a\u0012\u0002\u001f\r|gn];nK\u0012\u0014\u0015\r^2iKN,\"!a\u0017\u0011\r\u0005u\u0013qMA6\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003K\u0002\u0015AC2pY2,7\r^5p]&!\u0011\u0011NA0\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0004\u0003#\u0002#\u0001\u0004$fi\u000eDW\r\u001a\"bi\u000eD7C\u0002\u0011?\u0003c\n9\bE\u0002@\u0003gJ1!!\u001eA\u0005\u001d\u0001&o\u001c3vGR\u00042aPA=\u0013\r\tY\b\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$XCAAA!\ry\u00141Q\u0005\u0004\u0003\u000b\u0003%\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005)Q\r]8dQV\u0011\u0011qI\u0001\u0007KB|7\r\u001b\u0011\u0015\r\u0005-\u0014\u0011SAJ\u0011\u001d\ti(\na\u0001\u0003\u0003Cq!!#&\u0001\u0004\t9%\u0001\u0005u_N#(/\u001b8h)\t\tI\n\u0005\u0003\u0002\u001c\u0006%f\u0002BAO\u0003K\u00032!a(A\u001b\t\t\tKC\u0002\u0002$r\na\u0001\u0010:p_Rt\u0014bAAT\u0001\u00061\u0001K]3eK\u001aLA!a+\u0002.\n11\u000b\u001e:j]\u001eT1!a*A\u0003\u0011\u0019w\u000e]=\u0015\r\u0005-\u00141WA[\u0011%\tih\nI\u0001\u0002\u0004\t\t\tC\u0005\u0002\n\u001e\u0002\n\u00111\u0001\u0002H\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA^U\u0011\t\t)!0,\u0005\u0005}\u0006\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!3A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\f\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002T*\"\u0011qIA_\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001c\t\u0005\u0003[\tY.\u0003\u0003\u0002,\u0006=\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003G\fI\u000fE\u0002@\u0003KL1!a:A\u0005\r\te.\u001f\u0005\n\u0003Wd\u0013\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAy!\u0019\t\u00190!>\u0002d6\u0011\u00111M\u0005\u0005\u0003o\f\u0019G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u007f\u0005\u0007\u00012aPA\u0000\u0013\r\u0011\t\u0001\u0011\u0002\b\u0005>|G.Z1o\u0011%\tYOLA\u0001\u0002\u0004\t\u0019/\u0001\u0005iCND7i\u001c3f)\t\t9%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003{\u0014i\u0001C\u0005\u0002lB\n\t\u00111\u0001\u0002d\u0006\u00012m\u001c8tk6,GMQ1uG\",7\u000fI\u0001\u0005G\u0006dGNA\u0007M_\u001e\f\u0005\u000f]3oIR\u000b7o[\n\u00061\u0005-\u0012q\u0007\u000b\u0007\u00053\u0011YB!\b\u0011\u0007\u0005E\u0003\u0004\u0003\u0004:7\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u000bZ\u0002\u0019AAA\u0003%\u0019'/Z1uK2{w\r\u0006\u0003\u0002\"\t\r\u0002\"\u0003B\u0013;A\u0005\t\u0019\u0001B\u0014\u0003\u0019\u0019wN\u001c4jOB\u0019qI!\u000b\n\u0007\t-\u0002HA\u0005M_\u001e\u001cuN\u001c4jO\u0006\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0007\u0016\u0005\u0005O\ti,\u0001\u000bwC2LG-\u0019;f\u0007>t7/^7fI\u0012\u000bG/\u0019\u000b\u0006e\n]\"\u0011\b\u0005\u0007s}\u0001\r!!\t\t\u000f\u0005]s\u00041\u0001\u0003<A1!Q\bB$\u0003WrAAa\u0010\u0003D9!\u0011q\u0014B!\u0013\u0005\t\u0015b\u0001B#\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B%\u0005\u0017\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005\u000b\u0002\u0015\u0001\u0004$fi\u000eDW\r\u001a\"bi\u000eD\u0007cAA)eM)!Ga\u0015\u0002xAQ!Q\u000bB.\u0003\u0003\u000b9%a\u001b\u000e\u0005\t]#b\u0001B-\u0001\u00069!/\u001e8uS6,\u0017\u0002\u0002B/\u0005/\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011y\u0005\u0006\u0002\u0002Z\u0006)\u0011\r\u001d9msR1\u00111\u000eB4\u0005SBq!! 6\u0001\u0004\t\t\tC\u0004\u0002\nV\u0002\r!a\u0012\u0002\u000fUt\u0017\r\u001d9msR!!q\u000eB>!\u0015y$\u0011\u000fB;\u0013\r\u0011\u0019\b\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f}\u00129(!!\u0002H%\u0019!\u0011\u0010!\u0003\rQ+\b\u000f\\33\u0011%\u0011iHNA\u0001\u0002\u0004\tY'A\u0002yIA\u0002")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(AbstractLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private AbstractLog createLog(LogConfig config) {
        File x$1 = this.logDir();
        long x$3 = 0L;
        long x$4 = 0L;
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Metrics x$7 = new Metrics();
        Time x$8 = Time.SYSTEM;
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        boolean x$14 = true;
        boolean x$15 = true;
        LogOffsetsListener x$16 = Log$.MODULE$.apply$default$16();
        Option x$17 = Log$.MODULE$.apply$default$17();
        return Log$.MODULE$.apply(x$1, config, x$3, x$4, (Scheduler)x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$12, x$15, (Option)x$13, x$14, x$16, x$17);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(AbstractLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        segment.log().batches().forEach(batch -> {
            if (iter$1.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
                }
            }
        });
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.readLocal(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true).records().batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, AbstractLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = (ListBuffer)ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    scala.Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer();
                    if (!bl) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (!(this.baseOffset() == fetchedBatch.baseOffset() && this.epoch() == fetchedBatch.epoch() && fetchedBatch.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable & scala.Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = TestUtils$.MODULE$.records$default$2();
                        CompressionType x$5 = TestUtils$.MODULE$.records$default$3();
                        long x$6 = TestUtils$.MODULE$.records$default$4();
                        short x$7 = TestUtils$.MODULE$.records$default$5();
                        int x$8 = TestUtils$.MODULE$.records$default$6();
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, AbstractLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

