/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-BQ\u0001\u0010\u0001\u0005\u0002-BQA\u0010\u0001\u0005\u0002-BQ\u0001\u0011\u0001\u0005\u0002-BQA\u0011\u0001\u0005\u0002-BQ\u0001\u0012\u0001\u0005\u0002-BQA\u0012\u0001\u0005\u0002-BQ\u0001\u0013\u0001\u0005\u0002-BQA\u0013\u0001\u0005\u0002-BQ\u0001\u0014\u0001\u0005\u0002-BQA\u0014\u0001\u0005\u0002-BQ\u0001\u0015\u0001\u0005\u0002-BQA\u0015\u0001\u0005\u0002-BQ\u0001\u0016\u0001\u0005\u0002-BQA\u0016\u0001\u0005\u0002-BQ\u0001\u0017\u0001\u0005\u0002-BQA\u0017\u0001\u0005\nmCQ\u0001\u001c\u0001\u0005\n5DQ!\u001e\u0001\u0005\u0002-BQa\u001e\u0001\u0005\u0002-BQ!\u001f\u0001\u0005\u0002-BQa\u001f\u0001\u0005\u0002-BQ! \u0001\u0005\ny\u0014Q\u0002T8h\u0007>tg-[4UKN$(BA\u000e\u001d\u0003\rawn\u001a\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001,K:\u001cXO]3O_N#\u0018\r^5d\u0013:LG/[1mSj\fG/[8o\u001fJ$WM\u001d#fa\u0016tG-\u001a8dsR\tA\u0006\u0005\u0002\"[%\u0011aF\t\u0002\u0005+:LG\u000f\u000b\u0002\u0003aA\u0011\u0011GO\u0007\u0002e)\u00111\u0007N\u0001\u0004CBL'BA\u001b7\u0003\u001dQW\u000f]5uKJT!a\u000e\u001d\u0002\u000b),h.\u001b;\u000b\u0003e\n1a\u001c:h\u0013\tY$G\u0001\u0003UKN$\u0018A\u0006;fgR\\\u0015MZ6b\u0007>tg-[4U_B\u0013x\u000e]:)\u0005\r\u0001\u0014A\r;fgR,e.\u00192mKN\u001b\u0007.Z7b-\u0006d\u0017\u000eZ1uS>tw+\u001b;i_V$8k\u00195f[\u0006\u0014VmZ5tiJLXK\u001d7)\u0005\u0011\u0001\u0014a\f;fgR,e.\u00192mKN\u001b\u0007.Z7b-\u0006d\u0017\u000eZ1uS>tw+\u001b;i'\u000eDW-\\1SK\u001eL7\u000f\u001e:z+Jd\u0007FA\u00031\u0003E\"Xm\u001d;F]\u0006\u0014G.Z*dQ\u0016l\u0017MV1mS\u0012\fG/[8o/&$\bn\\;u\u0013:$XM]2faR|'o\u00117bgND#A\u0002\u0019\u0002iQ,7\u000f^#oC\ndWmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8XSRD7)^:u_6Le\u000e^3sG\u0016\u0004Ho\u001c:DY\u0006\u001c8\u000f\u000b\u0002\ba\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\tA\u0001'\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003\u0013A\na\u0004^3ti&sg/\u00197jI\u000e{W\u000e]1di&|g\u000eT1h\u0007>tg-[4)\u0005)\u0001\u0014!J:i_VdGMV1mS\u0012\fG/\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u000e{gNZ5hQ\tY\u0001'A\buKN$Hk\u001c%u[2$\u0016M\u00197fQ\ta\u0001'\u0001\u0006uKN$Hk\u001c%u[2D#!\u0004\u0019\u0002#Q,7\u000f\u001e+p\u000b:\u0014\u0018n\u00195fIJ\u001bH\u000f\u000b\u0002\u000fa\u0005IA/Z:u)>\u00146\u000f\u001e\u0015\u0003\u001fA\n!\u0003^3ti\u001e+GoQ8oM&<g+\u00197vK\"\u0012\u0001\u0003M\u0001&i\u0016\u001cHo\u0014<feJLG\rZ3o\u0007>tg-[4t\u0003NdunZ4bE2,7\u000b\u001e:j]\u001eD#!\u0005\u0019\u0002\u000f%\u001ch+\u00197jIR\u0011Al\u0018\t\u0003CuK!A\u0018\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0001M\u0005a\u0001C\u0006Y1m\u001c8gS\u001e4\u0016\r\\;f!\t\u0011\u0017N\u0004\u0002dOB\u0011AMI\u0007\u0002K*\u0011aMH\u0001\u0007yI|w\u000e\u001e \n\u0005!\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b\u0012\u0002+\u0005\u001c8/\u001a:u!J|\u0007/\u001a:us&sg/\u00197jIR\u0019AF\u001c9\t\u000b=\u001c\u0002\u0019A1\u0002\t9\fW.\u001a\u0005\u0006cN\u0001\rA]\u0001\u0007m\u0006dW/Z:\u0011\u0007\u0005\u001a\b%\u0003\u0002uE\tQAH]3qK\u0006$X\r\u001a \u0002CQ,7\u000f\u001e'pG\u0006dGj\\4SKR,g\u000e^5p]\u0012+'/\u001b<fIB\u0013x\u000e]:)\u0005Q\u0001\u0014\u0001\u000b;fgRdunY1m\u0019><'+\u001a;f]RLwN\u001c#fe&4X\r\u001a#fM\u0006,H\u000e\u001e)s_B\u001c\bFA\u000b1\u0003i!Xm\u001d;M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:\u0004&o\u001c9tQ\t1\u0002'A\u0011uKN$\u0018J\u001c<bY&$Gj\\2bY2{wMU3uK:$\u0018n\u001c8Qe>\u00048\u000f\u000b\u0002\u0018a\u0005\u0019Cm\u001c+fgRLeN^1mS\u0012dunY1m\u0019><'+\u001a;f]RLwN\u001c)s_B\u001cH#C@\u0002\u0016\u0005}\u0011\u0011FA\u0017!\u0011\t\t!!\u0005\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\taaY8oM&<'\u0002BA\u0005\u0003\u0017\taaY8n[>t'bA\u000f\u0002\u000e)\u0019\u0011q\u0002\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019\"a\u0001\u0003\u001f\r{gNZ5h\u000bb\u001cW\r\u001d;j_:Dq!a\u0006\u0019\u0001\u0004\tI\"\u0001\tm_\u000e\fGNU3uK:$\u0018n\u001c8NgB\u0019\u0011%a\u0007\n\u0007\u0005u!E\u0001\u0003M_:<\u0007bBA\u00111\u0001\u0007\u00111E\u0001\u0014Y>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u0005f$Xm\u001d\t\u0004C\u0005\u0015\u0012bAA\u0014E\t\u0019\u0011J\u001c;\t\u000f\u0005-\u0002\u00041\u0001\u0002$\u0005q!/\u001a;f]RLwN\u001c\"zi\u0016\u001c\bbBA\u00181\u0001\u0007\u0011\u0011D\u0001\fe\u0016$XM\u001c;j_:l5\u000f")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableLike)LogConfig$.MODULE$.configNames().filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$.version(), logProps.get(LogConfig$.MODULE$.MessageFormatVersionProp()));
    }

    @Test
    public void testEnableSchemaValidationWithoutSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            logProps.put(cfg, "true");
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> new LogConfig(logProps, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    @Test
    public void testEnableSchemaValidationWithSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithoutInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        logProps.remove("confluent.schema.validator.interceptor.class");
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithCustomInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.validator.interceptor.class", "non.existing.interceptor");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), (List)new .colon.colon((Object)LogConfig$.MODULE$.KeySchemaValidationEnableProp(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$testFromPropsEmpty$1(x$1))));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.ValueSchemaValidationStrategyProp()));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.KeySchemaValidationStrategyProp()));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig$.MODULE$.validate(props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        kafkaProps.put("confluent.ssl.keystore.password", "akeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(LogConfig$.MODULE$.RetentionBytesProp(), "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        topicOverrides.setProperty("confluent.ssl.truststore.password", "sometrustpasswrd");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig), topicOverrides);
        Assertions.assertEquals((Object)"{confluent.ssl.truststore.password=(redacted), min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionMs(), (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionSize(), (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(2000));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Integer.toString(1000));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Integer.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Long.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig$.MODULE$.configsWithNoServerDefaults().contains((Object)config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Option serverConfigOpt;
        boolean bl;
        String string = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
        if (!(string != null ? !string.equals(config) : config != null)) {
            bl = true;
        } else {
            String string2 = LogConfig$.MODULE$.KeySchemaValidationEnableProp();
            if (!(string2 != null ? !string2.equals(config) : config != null)) {
                bl = true;
            } else {
                String string3 = LogConfig$.MODULE$.ValueSchemaValidationEnableProp();
                if (!(string3 != null ? !string3.equals(config) : config != null)) {
                    bl = true;
                } else {
                    String string4 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                    if (!(string4 != null ? !string4.equals(config) : config != null)) {
                        bl = true;
                    } else {
                        String string5 = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                        bl = !(string5 != null ? !string5.equals(config) : config != null);
                    }
                }
            }
        }
        boolean bl2 = bl ? !LogConfig$.MODULE$.serverConfigName(config).isDefined() : (serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config)).isDefined() && serverConfigOpt.get() != null;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(Map logProps$2, String cfg) {
        logProps$2.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$2, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(Map logProps$3, String cfg) {
        logProps$3.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$3, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(Map logProps$4, String cfg) {
        logProps$4.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$4, LogConfig$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)"Class non.existing.interceptor cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testFromPropsEmpty$1(Tuple2 x$1) {
        return x$1._2() == null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        block18: {
            block21: {
                String string;
                block20: {
                    block19: {
                        String string2;
                        block17: {
                            String string3 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                            if (!(string3 != null ? !string3.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                                return;
                            }
                            String string4 = LogConfig$.MODULE$.RetentionBytesProp();
                            if (!(string4 != null ? !string4.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                                return;
                            }
                            String string5 = LogConfig$.MODULE$.RetentionMsProp();
                            if (!(string5 != null ? !string5.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                                return;
                            }
                            String string6 = LogConfig$.MODULE$.CleanupPolicyProp();
                            if (!(string6 != null ? !string6.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                                return;
                            }
                            String string7 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                            if (!(string7 != null ? !string7.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string8 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                            if (!(string8 != null ? !string8.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                return;
                            }
                            String string9 = LogConfig$.MODULE$.MessageFormatVersionProp();
                            if (!(string9 != null ? !string9.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                return;
                            }
                            String string10 = LogConfig$.MODULE$.RemoteLogStorageEnableProp();
                            if (!(string10 != null ? !string10.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                                return;
                            }
                            String string11 = LogConfig$.MODULE$.LocalLogRetentionMsProp();
                            if (!(string11 != null ? !string11.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                                return;
                            }
                            String string12 = LogConfig$.MODULE$.LocalLogRetentionBytesProp();
                            if (!(string12 != null ? !string12.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                                return;
                            }
                            String string13 = LogConfig$.MODULE$.TierLocalHotsetBytesProp();
                            if (!(string13 != null ? !string13.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string14 = LogConfig$.MODULE$.TierLocalHotsetMsProp();
                            if (!(string14 != null ? !string14.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string15 = LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp();
                            if (!(string15 != null ? !string15.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string16 = LogConfig$.MODULE$.PreferTierFetchMsProp();
                            if (!(string16 != null ? !string16.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                return;
                            }
                            String string17 = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
                            if (!(string17 != null ? !string17.equals(name) : name != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"json only", "null"}));
                                return;
                            }
                            string2 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                            if (string2 != null) break block17;
                            if (name == null) break block18;
                            break block19;
                        }
                        if (string2.equals(name)) {
                            return;
                        }
                    }
                    string = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                    if (string != null) break block20;
                    if (name == null) break block18;
                    break block21;
                }
                if (string.equals(name)) {
                    return;
                }
            }
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        }
    }
}

