/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.MaybeResolvedTimestampAndOffset;
import kafka.common.TierUnfetchedTimestampAndOffset;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogLoaderTest;
import kafka.log.LogLoaderTest$;
import kafka.log.LogLoaderTest$SimulateError$2$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.tier.state.TierPartitionState;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001\u0002&L\u0001ACQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001A\u0002\u0013\u0005A\fC\u0004d\u0001\u0001\u0007I\u0011\u00013\t\r)\u0004\u0001\u0015)\u0003^\u0011\u001dY\u0007A1A\u0005\u00021Da\u0001\u001d\u0001!\u0002\u0013i\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000fq\u0004!\u0019!C\u0001e\"1Q\u0010\u0001Q\u0001\nMDqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0001\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\f\u0001\t\u0003\t\t\u0002C\u0004\u00028\u0001!\t!!\u0005\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002\u0012!9\u0011Q\t\u0001\u0005\u0002\u0005E\u0001bBA%\u0001\u0011\u0005\u00111\n\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0001\u0003\u0007D\u0011\"!7\u0001#\u0003%\t!a7\t\u0013\u0005}\u0007!%A\u0005\u0002\u0005\u0005\b\"CAs\u0001E\u0005I\u0011AAt\u0011%\tY\u000fAI\u0001\n\u0003\t9\u000fC\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002p\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003k\u0004\u0011\u0013!C\u0001\u0003oD\u0011\"a?\u0001#\u0003%\t!!@\t\u0013\t\u0005\u0001!%A\u0005\u0002\t\r\u0001\"\u0003B\u0004\u0001E\u0005I\u0011\u0001B\u0002\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017AqA!\b\u0001\t\u0013\u0011y\u0002C\u0004\u00034\u0001!IA!\u000e\t\u0013\tE\u0004!%A\u0005\n\tM\u0004\"\u0003B<\u0001E\u0005I\u0011\u0002B=\u0011%\u0011i\bAI\u0001\n\u0013\t9\u000fC\u0005\u0003\u0000\u0001\t\n\u0011\"\u0003\u0003\u0002\"9!Q\u0011\u0001\u0005\n\t\u001d\u0005b\u0002BO\u0001\u0011%!q\u0014\u0005\b\u0005S\u0003A\u0011\u0002BV\u0011\u001d\u00119\r\u0001C\u0001\u0003#AqAa3\u0001\t\u0003\t\t\u0002C\u0004\u0003P\u0002!\t!!\u0005\t\u000f\tM\u0007\u0001\"\u0001\u0002\u0012!9!q\u001b\u0001\u0005\u0002\u0005E\u0001b\u0002Bn\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0005?\u0004A\u0011AA\t\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0003#AqAa:\u0001\t\u0003\t\t\u0002C\u0004\u0003l\u0002!\t!!\u0005\t\u000f\t=\b\u0001\"\u0001\u0002\u0012!9!1\u001f\u0001\u0005\u0002\u0005E\u0001b\u0002B|\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0005w\u0004A\u0011AA\t\u0011\u001d\u0011y\u0010\u0001C\u0001\u0003#Aqaa\u0001\u0001\t\u0003\t\t\u0002C\u0004\u0004\b\u0001!\t!!\u0005\t\u000f\r-\u0001\u0001\"\u0001\u0002\u0012!91q\u0002\u0001\u0005\u0002\u0005E\u0001bBB\n\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0007/\u0001A\u0011AA\t\u0011\u001d\u0019Y\u0002\u0001C\u0001\u0003#Aqaa\b\u0001\t\u0003\t\t\u0002C\u0004\u0004$\u0001!\t!!\u0005\t\u000f\r\u001d\u0002\u0001\"\u0001\u0002\u0012!911\u0006\u0001\u0005\u0002\u0005E\u0001bBB\u0018\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0007g\u0001A\u0011AA\t\u0011\u001d\u00199\u0004\u0001C\u0001\u0003#Aqaa\u000f\u0001\t\u0003\t\t\u0002C\u0004\u0004@\u0001!\t!!\u0005\t\u000f\r\r\u0003\u0001\"\u0001\u0002\u0012!91q\t\u0001\u0005\u0002\u0005E\u0001bBB&\u0001\u0011\u0005\u0011\u0011\u0003\u0002\u000e\u0019><Gj\\1eKJ$Vm\u001d;\u000b\u00051k\u0015a\u00017pO*\ta*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00023B\u0011!\fA\u0007\u0002\u0017\u000611m\u001c8gS\u001e,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A6\u000baa]3sm\u0016\u0014\u0018B\u00012`\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002fQB\u0011!KZ\u0005\u0003ON\u0013A!\u00168ji\"9\u0011nAA\u0001\u0002\u0004i\u0016a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\u0005i\u0007C\u00010o\u0013\tywL\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\rQl\u0007\u000fR5s+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\tIwNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i,(\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003!iwnY6US6,WCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\u001b\u0006)Q\u000f^5mg&!\u00111BA\u0003\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u0015\u0019X\r^+q)\u0005)\u0007fA\u0007\u0002\u0016A!\u0011qCA\u0015\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011aA1qS*!\u0011qDA\u0011\u0003\u001dQW\u000f]5uKJTA!a\t\u0002&\u0005)!.\u001e8ji*\u0011\u0011qE\u0001\u0004_J<\u0017\u0002BA\u0016\u00033\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\b\u00022A!\u0011qCA\u001a\u0013\u0011\t)$!\u0007\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\n;fgRdun\u001a*fG>4XM]=Jg\u000e\u000bG\u000e\\3e+B|gN\u0011:pW\u0016\u00148I]1tQ\"\u001aq\"a\u000f\u0011\t\u0005]\u0011QH\u0005\u0005\u0003\u007f\tIB\u0001\u0003UKN$\u0018a\r;fgR\u0004&o\u001c3vG\u0016\u00148K\\1qg\"|Go\u001d*fG>4XM]=BMR,'/\u00168dY\u0016\fgn\u00155vi\u0012|wO\u001c,2Q\r\u0001\u00121H\u0001Fi\u0016\u001cH\u000f\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;t%\u0016\u001cwN^3ss\u00063G/\u001a:V]\u000edW-\u00198TQV$Hm\\<o\u0007V\u0014(/\u001a8u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;)\u0007E\tY$A\u0005de\u0016\fG/\u001a'pORa\u0012QJA*\u0003/\ny&!\u0019\u0002l\u0005\r\u0015QRAI\u00037\u000by*!+\u00024\u0006u\u0006c\u0001.\u0002P%\u0019\u0011\u0011K&\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\u0007\u0003+\u0012\u0002\u0019A:\u0002\u0007\u0011L'\u000f\u0003\u0004\\%\u0001\u0007\u0011\u0011\f\t\u00045\u0006m\u0013bAA/\u0017\nIAj\\4D_:4\u0017n\u001a\u0005\bWJ\u0001\n\u00111\u0001n\u0011%\t\u0019G\u0005I\u0001\u0002\u0004\t)'A\u0005tG\",G-\u001e7feB!\u00111AA4\u0013\u0011\tI'!\u0002\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\"CA7%A\u0005\t\u0019AA8\u0003\u0011!\u0018.\\3\u0011\t\u0005E\u0014qP\u0007\u0003\u0003gRA!a\u0002\u0002v)!\u0011qOA=\u0003\u0019\u0019w.\\7p]*\u0019a*a\u001f\u000b\t\u0005u\u0014QE\u0001\u0007CB\f7\r[3\n\t\u0005\u0005\u00151\u000f\u0002\u0005)&lW\rC\u0005\u0002\u0006J\u0001\n\u00111\u0001\u0002\b\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bc\u0001*\u0002\n&\u0019\u00111R*\u0003\t1{gn\u001a\u0005\n\u0003\u001f\u0013\u0002\u0013!a\u0001\u0003\u000f\u000bQB]3d_Z,'/\u001f)pS:$\b\"CAJ%A\u0005\t\u0019AAK\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\u0011\u0007I\u000b9*C\u0002\u0002\u001aN\u00131!\u00138u\u0011%\tiJ\u0005I\u0001\u0002\u0004\t)*A\u0012qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\\"iK\u000e\\\u0017J\u001c;feZ\fG.T:\t\u0013\u0005\u0005&\u0003%AA\u0002\u0005\r\u0016!\u0005;jKJdunZ\"p[B|g.\u001a8ugB\u0019!,!*\n\u0007\u0005\u001d6JA\tUS\u0016\u0014Hj\\4D_6\u0004xN\\3oiND\u0011\"a+\u0013!\u0003\u0005\r!!,\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\rq\u0016qV\u0005\u0004\u0003c{&\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eC\u0005\u00026J\u0001\n\u00111\u0001\u00028\u0006\tB.Y:u'\",H\u000fZ8x]\u000ecW-\u00198\u0011\u0007I\u000bI,C\u0002\u0002<N\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002@J\u0001\n\u00111\u0001\u00028\u0006I2.Z3q!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t)MK\u0002n\u0003\u000f\\#!!3\u0011\t\u0005-\u0017Q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\u001c\u0016AC1o]>$\u0018\r^5p]&!\u0011q[Ag\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003;TC!!\u001a\u0002H\u0006\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u001d\u0016\u0005\u0003_\n9-A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$c'\u0006\u0002\u0002j*\"\u0011qQAd\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00138\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00139+\t\t\tP\u000b\u0003\u0002\u0016\u0006\u001d\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012J\u0014\u0001F2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0002z*\"\u00111UAd\u0003Q\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00132cU\u0011\u0011q \u0016\u0005\u0003[\u000b9-\u0001\u000bde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013GM\u000b\u0003\u0005\u000bQC!a.\u0002H\u0006!2M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cM\n1d\u0019:fCR,Gj\\4XSRDwJ\u001a4tKR|e/\u001a:gY><H\u0003\u0002B\u0007\u00053\u0001rA\u0015B\b\u0003\u001b\u0012\u0019\"C\u0002\u0003\u0012M\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001.\u0003\u0016%\u0019!qC&\u0003\u00151{wmU3h[\u0016tG\u000fC\u0004\u0003\u001cy\u0001\r!!\u0017\u0002\u00131|wmQ8oM&<\u0017a\u0004:fG>4XM]!oI\u000eCWmY6\u0015\r\u00055#\u0011\u0005B\u0012\u0011\u0019Yv\u00041\u0001\u0002Z!9!QE\u0010A\u0002\t\u001d\u0012\u0001D3ya\u0016\u001cG/\u001a3LKf\u001c\bC\u0002B\u0015\u0005_\t9)\u0004\u0002\u0003,)\u0019!QF*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00032\t-\"\u0001C%uKJ\f'\r\\3\u0002?MLgn\u001a7fi>t'+Z2pe\u0012\u001cx+\u001b;i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0006\t\u00038\t\r#1\u000bB,\u00057\u0012yF!\u001b\u0003nA!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\u0005U\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0003B\tm\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0003F\u0001\u0002\rAa\u0012\u0002\u000bY\fG.^3\u0011\u000bI\u0013IE!\u0014\n\u0007\t-3KA\u0003BeJ\f\u0017\u0010E\u0002S\u0005\u001fJ1A!\u0015T\u0005\u0011\u0011\u0015\u0010^3\t\u0013\tU\u0003\u0005%AA\u0002\t\u001d\u0013aA6fs\"9!\u0011\f\u0011A\u0002\u0005U\u0015a\u00037fC\u0012,'/\u00129pG\"DqA!\u0018!\u0001\u0004\t9)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\n\u0005C\u0002\u0003\u0013!a\u0001\u0005G\nQaY8eK\u000e\u0004BA!\u000f\u0003f%!!q\rB\u001e\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007\"\u0003B6AA\u0005\t\u0019AAD\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0005\u0003p\u0001\u0002\n\u00111\u0001\u0003N\u0005QQ.Y4jGZ\u000bG.^3\u0002SMLgn\u001a7fi>t'+Z2pe\u0012\u001cx+\u001b;i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)H\u000b\u0003\u0003H\u0005\u001d\u0017!K:j]\u001edW\r^8o%\u0016\u001cwN\u001d3t/&$\b\u000eT3bI\u0016\u0014X\t]8dQ\u0012\"WMZ1vYR$S'\u0006\u0002\u0003|)\"!1MAd\u0003%\u001a\u0018N\\4mKR|gNU3d_J$7oV5uQ2+\u0017\rZ3s\u000bB|7\r\u001b\u0013eK\u001a\fW\u000f\u001c;%m\u0005I3/\u001b8hY\u0016$xN\u001c*fG>\u0014Hm],ji\"dU-\u00193fe\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uI]*\"Aa!+\t\t5\u0013qY\u0001\u001eCN\u001cXM\u001d;M_\u000e\fG\u000eV5nKN$\u0018-\u001c9B]\u0012|eMZ:fiR!!\u0011\u0012BJ!\u0011\u0011YIa$\u000e\u0005\t5%bAA<\u001b&!!\u0011\u0013BG\u0005e1U\r^2iK\u0012$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;\t\u000f\tUU\u00051\u0001\u0003\u0018\u0006)a-\u001a;dQB!!1\u0012BM\u0013\u0011\u0011YJ!$\u0003?5\u000b\u0017PY3SKN|GN^3e)&lWm\u001d;b[B\fe\u000eZ(gMN,G/\u0001\u0007bgN,'\u000f^(gMN,G\u000fF\u0003f\u0005C\u0013)\u000bC\u0004\u0003$\u001a\u0002\r!a\"\u0002\u0011\u0015D\b/Z2uK\u0012DqAa*'\u0001\u0004\u0011I)\u0001\nuS6,7\u000f^1na\u0006sGm\u00144gg\u0016$\u0018!\r;fgR\u0004&o\u001c3vG\u0016\u00148K\\1qg\"|Go\u001d*fG>4XM]=BMR,'/\u00168dY\u0016\fgn\u00155vi\u0012|wO\u001c\u000b\u0004K\n5\u0006b\u0002BXO\u0001\u0007!\u0011W\u0001\u0015[\u0016\u001c8/Y4f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0011\t\tM&\u0011\u0019\b\u0005\u0005k\u0013i\fE\u0002\u00038Nk!A!/\u000b\u0007\tmv*\u0001\u0004=e>|GOP\u0005\u0004\u0005\u007f\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003D\n\u0015'AB*ue&twMC\u0002\u0003@N\u000b1\u0007^3tiN[\u0017\u000e\u001d'pC\u0012LgnZ%g\u000b6\u0004H/\u001f)s_\u0012,8-\u001a:Ti\u0006$XMQ3g_J,GK];oG\u0006$\u0018n\u001c8)\u0007!\nY$A\u0019uKN$(+Z2pm\u0016\u0014\u0018I\u001a;fe:{g.T8o_R|g.[2D_>\u0014H-\u001b8bi>\u0014X\t]8dQ^\u0013\u0018\u000e^3)\u0007%\nY$A\u001fuKN$8k[5q)J,hnY1uK\u0006sGMU3m_\u0006$\u0017JZ(mI6+7o]1hK\u001a{'/\\1u\u0003:$gj\\\"mK\u0006t7\u000b[;uI><h\u000eK\u0002+\u0003w\t1\b^3tiN[\u0017\u000e\u001d+sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bI&3w\n\u001c3NKN\u001c\u0018mZ3G_Jl\u0017\r^!oI\u000ecW-\u00198TQV$Hm\\<oQ\rY\u00131H\u0001<i\u0016\u001cHoU6jaR\u0013XO\\2bi\u0016\fe\u000e\u001a*fY>\fG-\u00134OK^lUm]:bO\u00164uN]7bi\u0006sGm\u00117fC:\u001c\u0006.\u001e;e_^t\u0007f\u0001\u0017\u0002<\u0005iC/Z:u\u0019>\fG\r\u0015:pIV\u001cWM]:BMR,'\u000fR3mKR,'+Z2pe\u0012\u001cX*\u001b3TK\u001elWM\u001c;)\u00075\nY$\u0001\u001buKN$Hj\\1eS:<Gj\\4LK\u0016\u00048\u000fT1sO\u0016\u001cHo\u0015;sCf\u0004&o\u001c3vG\u0016\u00148\u000b^1uKNs\u0017\r]:i_RD3ALA\u001e\u00031\"Xm\u001d;M_\u0006$\u0007K]8ek\u000e,'o]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIN|enU3h[\u0016tG\u000fK\u00020\u0003w\ta\u0004^3ti2{wMU3d_Z,'o\u001d+p\u0007>\u0014(/Z2u\u001f\u001a47/\u001a;)\u0007A\nY$\u0001\tuKN$\u0018J\u001c3fqJ+'-^5mI\"\u001a\u0011'a\u000f\u0002EQ,7\u000f\u001e*fEVLG\u000e\u001a+j[\u0016Le\u000eZ3y\r>\u0014x\n\u001c3NKN\u001c\u0018mZ3tQ\r\u0011\u00141H\u0001\u0018i\u0016\u001cHoQ8seV\u0004H/\u00138eKb\u0014VMY;jY\u0012D3aMA\u001e\u0003\u0001\"Xm\u001d;C_\u001e,8/\u00138eKb\u001cVmZ7f]R\u001c\u0018I]3SK6|g/\u001a3)\u0007Q\nY$\u0001\fuKN$(+Z8qK:$\u0006.\u001a8UeVt7-\u0019;fQ\r)\u00141H\u0001\u001di\u0016\u001cHo\u00149f]\u0012+G.\u001a;fg>\u00137o\u001c7fi\u00164\u0015\u000e\\3tQ\r1\u00141H\u0001\u000fi\u0016\u001cHoQ8seV\u0004H\u000fT8hQ\r9\u00141H\u0001\u001di\u0016\u001cHo\u0014<fe\u000e{W\u000e]1di\u0016$Gj\\4SK\u000e|g/\u001a:zQ\rA\u00141H\u0001=i\u0016\u001cH\u000fT3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3DY\u0016\f'/\u001a3BMR,'o\u0015;bi&\u001cW*Z:tC\u001e,gi\u001c:nCR$un\u001e8he\u0006$W\rK\u0002:\u0003w\tq\u0005^3ti>3XM]\"p[B\f7\r^3e\u0019><'+Z2pm\u0016\u0014\u00180T;mi&\u0014VmY8sI\"\u001a!(a\u000f\u0002SQ,7\u000f^(wKJ\u001cu.\u001c9bGR,G\rT8h%\u0016\u001cwN^3ss6+H\u000e^5SK\u000e|'\u000f\u001a,2Q\rY\u00141H\u0001(i\u0016\u001cHOU3d_Z,'/_(g'\u0016<W.\u001a8u/&$\bn\u00144gg\u0016$xJ^3sM2|w\u000fK\u0002=\u0003w\tq\u0005^3tiJ+7m\u001c<fef\fe\r^3s\u0007J\f7\u000f\u001b#ve&twm\u00159mSR\u0004\u0006.Y:fc!\u001aQ(a\u000f\u0002OQ,7\u000f\u001e*fG>4XM]=BMR,'o\u0011:bg\"$UO]5oON\u0003H.\u001b;QQ\u0006\u001cXM\r\u0015\u0004}\u0005m\u0012a\n;fgR\u0014VmY8wKJL\u0018I\u001a;fe\u000e\u0013\u0018m\u001d5EkJLgnZ*qY&$\b\u000b[1tKNB3aPA\u001e\u0003\u001d\"Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCNDG)\u001e:j]\u001e\u001c\u0006\u000f\\5u!\"\f7/\u001a\u001b)\u0007\u0001\u000bY$A\u0014uKN$(+Z2pm\u0016\u0014\u00180\u00114uKJ\u001c%/Y:i\tV\u0014\u0018N\\4Ta2LG\u000f\u00155bg\u0016,\u0004fA!\u0002<\u0005)B/Z:u\u00072,\u0017M\\*ikR$wn\u001e8GS2,\u0007f\u0001\"\u0002<\u0005iB/Z:u\u0019><'+Z2pm\u0016\u00148OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eK\u0002D\u0003w\t\u0001\u0005^3ti\u001a+H\u000e\u001c+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y%\u0016\u001cwN^3ss\"\u001aA)a\u000f\u00025Q,7\u000f\u001e*fG>4XM](oYfd\u0015m\u001d;TK\u001elWM\u001c;)\u0007\u0015\u000bY$A\u0013uKN$(+Z2pm\u0016\u0014H*Y:u'\u0016<W.\u001a8u/&$\bNT8T]\u0006\u00048\u000f[8ug\"\u001aa)a\u000f\u0002YQ,7\u000f\u001e*fG>4XM\u001d'fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f\u001f:,fn\u00197fC:\u001c\u0006.\u001e;e_^t\u0007fA$\u0002<\u0005\u0011C/Z:u\u0019><WI\u001c3MKN\u001cH\u000b[1o'R\f'\u000f^!gi\u0016\u0014(+Z8qK:D3\u0001SA\u001e\u0003\u001d#Xm\u001d;D_J\u0014X\u000f\u001d;fI2{wMU3d_Z,'/\u001f#pKNtu\u000e\u001e#fY\u0016$X\r\u0015:pIV\u001cWM]*uCR,7K\\1qg\"|Go\u001d)pgR\u0014VmY8wKJL\bfA%\u0002<\u0001")
public class LogLoaderTest {
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime mockTime = new MockTime();

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogRecoveryIsCalledUponBrokerCrash() {
        LazyRef SimulateError$module = new LazyRef();
        File logDir = TestUtils$.MODULE$.tempDir();
        Properties logProps = new Properties();
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        .colon.colon logDirs = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        MockTime time = new MockTime();
        BooleanRef cleanShutdownInterceptedValue = BooleanRef.create((boolean)false);
        public class Kafka_log_LogLoaderTest$SimulateError$1
        implements Product,
        scala.Serializable {
            private boolean hasError;
            private final /* synthetic */ LogLoaderTest $outer;

            public boolean hasError() {
                return this.hasError;
            }

            public void hasError_$eq(boolean x$1) {
                this.hasError = x$1;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1 copy(boolean hasError) {
                return new Kafka_log_LogLoaderTest$SimulateError$1(this.$outer, hasError);
            }

            public boolean copy$default$1() {
                return this.hasError();
            }

            public String productPrefix() {
                return "SimulateError";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToBoolean((boolean)this.hasError());
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)-889275714, (int)(this.hasError() ? 1231 : 1237)), (int)1);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        boolean bl = x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
                        if (!bl) break block3;
                        Kafka_log_LogLoaderTest$SimulateError$1 var3_3 = (Kafka_log_LogLoaderTest$SimulateError$1)x$1;
                        if (!(this.hasError() == var3_3.hasError() && var3_3.canEqual(this))) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1(LogLoaderTest $outer, boolean hasError) {
                this.hasError = hasError;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        Kafka_log_LogLoaderTest$SimulateError$1 simulateError = this.SimulateError$3(SimulateError$module).apply(this.SimulateError$3(SimulateError$module).apply$default$1());
        File cleanShutdownFile = new File(logDir, Log$.MODULE$.CleanShutdownFile());
        LogManager logManager = this.interceptedLogManager$1(logConfig, (Seq)logDirs, simulateError, time, cleanShutdownInterceptedValue);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = logManager.getOrCreateLog$default$3();
        logManager.getOrCreateLog(topicPartition, x$2, x$4, (Option)x$3);
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        cleanShutdownInterceptedValue.elem = false;
        ObjectRef defaultConfig = ObjectRef.create((Object)logManager.currentDefaultConfig());
        logManager.loadLogs((LogConfig)defaultConfig.elem, logManager.fetchTopicConfigOverrides((LogConfig)defaultConfig.elem, scala.collection.Set$.MODULE$.empty()));
        Assertions.assertTrue((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        cleanShutdownInterceptedValue.elem = true;
        defaultConfig.elem = logManager.currentDefaultConfig();
        logManager.loadLogs((LogConfig)defaultConfig.elem, logManager.fetchTopicConfigOverrides((LogConfig)defaultConfig.elem, scala.collection.Set$.MODULE$.empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        simulateError.hasError_$eq(true);
        Assertions.assertThrows(RuntimeException.class, () -> logManager.loadLogs((LogConfig)defaultConfig$2.elem, logManager.fetchTopicConfigOverrides((LogConfig)defaultConfig$2.elem, scala.collection.Set$.MODULE$.empty())));
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not have existed");
        simulateError.hasError_$eq(false);
        cleanShutdownInterceptedValue.elem = true;
        defaultConfig.elem = logManager.currentDefaultConfig();
        logManager.loadLogs((LogConfig)defaultConfig.elem, logManager.fetchTopicConfigOverrides((LogConfig)defaultConfig.elem, scala.collection.Set$.MODULE$.empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value for clean shutdown flag");
        logManager.shutdown();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        simulateError.hasError_$eq(true);
        LogManager logManager2 = this.interceptedLogManager$1(logConfig, (Seq)logDirs, simulateError, time, cleanShutdownInterceptedValue);
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = logManager2.getOrCreateLog$default$3();
        logManager2.getOrCreateLog(topicPartition, x$6, x$8, (Option)x$7);
        Assertions.assertThrows(RuntimeException.class, () -> {
            LogConfig defaultConfig = logManager2.currentDefaultConfig();
            logManager2.loadLogs(defaultConfig, logManager2.fetchTopicConfigOverrides(defaultConfig, scala.collection.Set$.MODULE$.empty()));
        });
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not have existed");
        simulateError.hasError_$eq(false);
        cleanShutdownInterceptedValue.elem = true;
        LogConfig defaultConfig2 = logManager2.currentDefaultConfig();
        logManager2.loadLogs(defaultConfig2, logManager2.fetchTopicConfigOverrides(defaultConfig2, scala.collection.Set$.MODULE$.empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value for clean shutdown flag");
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownV1() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V1).version());
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownCurrentMessageFormat() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.latestVersion().version());
    }

    public AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, boolean keepPartitionMetadataFile) {
        LogOffsetsListener x$14 = LogTestUtils$.MODULE$.createLog$default$12();
        Option<Uuid> x$15 = LogTestUtils$.MODULE$.createLog$default$14();
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, tierLogComponents, logDirFailureChannel, x$14, lastShutdownClean, x$15, keepPartitionMetadataFile);
    }

    public BrokerTopicStats createLog$default$3() {
        return this.brokerTopicStats();
    }

    public Scheduler createLog$default$4() {
        return this.mockTime().scheduler();
    }

    public Time createLog$default$5() {
        return this.mockTime();
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 3600000;
    }

    public int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public TierLogComponents createLog$default$10() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    public LogDirFailureChannel createLog$default$11() {
        return new LogDirFailureChannel(10);
    }

    public boolean createLog$default$12() {
        return true;
    }

    public boolean createLog$default$13() {
        return true;
    }

    private Tuple2<AbstractLog, LogSegment> createLogWithOffsetOverflow(LogConfig logConfig) {
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.logDir());
        File x$1 = this.logDir();
        long x$3 = Long.MAX_VALUE;
        BrokerTopicStats x$4 = this.createLog$default$3();
        Scheduler x$5 = this.createLog$default$4();
        Time x$6 = this.createLog$default$5();
        long x$7 = this.createLog$default$6();
        int x$8 = this.createLog$default$8();
        int x$9 = this.createLog$default$9();
        TierLogComponents x$10 = this.createLog$default$10();
        LogDirFailureChannel x$11 = this.createLog$default$11();
        boolean x$12 = this.createLog$default$12();
        boolean x$13 = this.createLog$default$13();
        AbstractLog log = this.createLog(x$1, logConfig, x$4, x$5, x$6, x$7, x$3, x$8, x$9, x$10, x$11, x$12, x$13);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        return new Tuple2((Object)log, (Object)segmentWithOverflow);
    }

    private AbstractLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.logDir(), config, expectedKeys, this.brokerTopicStats(), (Time)this.mockTime(), this.mockTime().scheduler());
    }

    private MemoryRecords singletonRecordsWithLeaderEpoch(byte[] value, byte[] key, int leaderEpoch, long offset, CompressionType codec, long timestamp, byte magicValue) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava()))), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)offset, (long)this.mockTime().milliseconds(), (int)leaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private byte[] singletonRecordsWithLeaderEpoch$default$2() {
        return null;
    }

    private CompressionType singletonRecordsWithLeaderEpoch$default$5() {
        return CompressionType.NONE;
    }

    private long singletonRecordsWithLeaderEpoch$default$6() {
        return -1L;
    }

    private byte singletonRecordsWithLeaderEpoch$default$7() {
        return 2;
    }

    private FetchedTimestampAndOffset assertLocalTimestampAndOffset(MaybeResolvedTimestampAndOffset fetch) {
        if (!(fetch instanceof FetchedTimestampAndOffset)) {
            if (fetch instanceof TierUnfetchedTimestampAndOffset) {
                throw new AssertionError((Object)"unexpected ListOffset result from the tier portion of the log");
            }
            throw new MatchError((Object)fetch);
        }
        FetchedTimestampAndOffset fetchedTimestampAndOffset = (FetchedTimestampAndOffset)fetch;
        return fetchedTimestampAndOffset;
    }

    private void assertOffset(long expected, FetchedTimestampAndOffset timestampAndOffset) {
        Assertions.assertEquals((long)expected, (long)timestampAndOffset.offset());
    }

    /*
     * WARNING - void declaration
     */
    private void testProducerSnapshotsRecoveryAfterUncleanShutdown(String messageFormatVersion) {
        void var14_11;
        void var13_10;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "640");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((AbstractLog)log.elem).oldestProducerSnapshotOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertTrue((((AbstractLog)log.elem).localLogSegments().size() >= 5 ? 1 : 0) != 0);
        Vector segmentOffsets = (Vector)((AbstractLog)log.elem).localLogSegments().toVector().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.baseOffset()), Vector$.MODULE$.canBuildFrom());
        long activeSegmentOffset = BoxesRunTime.unboxToLong((Object)segmentOffsets.last());
        long offsetForSegmentAfterRecoveryPoint = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 3));
        long offsetForRecoveryPointSegment = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 4));
        Tuple2 tuple2 = segmentOffsets.toSet().partition((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 < offsetForRecoveryPointSegment);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set segOffsetsBeforeRecovery = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set segOffsetsAfterRecovery = (scala.collection.immutable.Set)tuple2._2();
        void segOffsetsBeforeRecovery2 = var13_10;
        void segOffsetsAfterRecovery2 = var14_11;
        long recoveryPoint = offsetForRecoveryPointSegment + 1L;
        Assertions.assertTrue((recoveryPoint < offsetForSegmentAfterRecoveryPoint ? 1 : 0) != 0);
        ((AbstractLog)log.elem).close();
        Set segmentsWithReads = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set recoveredSegments = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set expectedSegmentsWithReads = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set expectedSnapshotOffsets = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (logConfig.messageFormatVersion().$less((Object)KAFKA_0_11_0_IV0$.MODULE$)) {
            expectedSegmentsWithReads.$plus$eq((Object)BoxesRunTime.boxToLong((long)activeSegmentOffset));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(2).$colon$plus((Object)BoxesRunTime.boxToLong((long)((AbstractLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        } else {
            expectedSegmentsWithReads.$plus$plus$eq((TraversableOnce)segOffsetsBeforeRecovery2.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset}))));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(4).$colon$plus((Object)BoxesRunTime.boxToLong((long)((AbstractLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        }
        ((AbstractLog)log.elem).producerStateManager().deleteSnapshotsBefore(BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 2)));
        log.elem = this.createLogWithInterceptedReads$1(offsetForRecoveryPointSegment, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)expectedSegmentsWithReads, (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((AbstractLog)log.elem).close();
        segmentsWithReads.clear();
        recoveredSegments.clear();
        ((AbstractLog)log.elem).producerStateManager().deleteSnapshotsBefore(offsetForRecoveryPointSegment);
        log.elem = this.createLogWithInterceptedReads$1(recoveryPoint, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset})), (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((AbstractLog)log.elem).close();
    }

    @Test
    public void testSkipLoadingIfEmptyProducerStateBeforeTruncation() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        stateManager.truncateAndReload(EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.anyLong());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{stateManager});
        LogConfig config = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, config.messageFormatVersion().recordVersion(), "");
        Files.createDirectories(this.logDir().toPath(), new FileAttribute[0]);
        MergedLog log = MergedLog$.MODULE$.apply(this.logDir(), config, segments, 0L, 0L, (Scheduler)this.mockTime().scheduler(), this.brokerTopicStats(), new Metrics(), (Time)this.mockTime(), 300000, 30000, topicPartition, leaderEpochCache, stateManager, logDirFailureChannel, TierLogComponents$.MODULE$.EMPTY(), false, (Option)None$.MODULE$, false, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Option)None$.MODULE$);
        EasyMock.verify((Object[])new Object[]{stateManager});
        EasyMock.reset((Object[])new Object[]{stateManager});
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(1L);
        EasyMock.expectLastCall();
        stateManager.updateMapEndOffset(2L);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{stateManager});
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        EasyMock.verify((Object[])new Object[]{stateManager});
        EasyMock.reset((Object[])new Object[]{stateManager});
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andStubReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)2L));
        stateManager.truncateAndReload(EasyMock.eq((long)0L), EasyMock.eq((long)1L), EasyMock.anyLong());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        stateManager.updateMapEndOffset(1L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        stateManager.onHighWatermarkUpdated(0L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        log.truncateTo(1L);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testRecoverAfterNonMonotonicCoordinatorEpochWrite() {
        long producerId = 1L;
        int coordinatorEpoch = 5;
        int x$1 = 0x500000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        int maxProducerIdExpirationMs = 3600000;
        File x$17 = this.logDir();
        BrokerTopicStats x$20 = this.createLog$default$3();
        Scheduler x$21 = this.createLog$default$4();
        Time x$22 = this.createLog$default$5();
        long x$23 = this.createLog$default$6();
        long x$24 = this.createLog$default$7();
        int x$25 = this.createLog$default$9();
        TierLogComponents x$26 = this.createLog$default$10();
        LogDirFailureChannel x$27 = this.createLog$default$11();
        boolean x$28 = this.createLog$default$12();
        boolean x$29 = this.createLog$default$13();
        AbstractLog log = this.createLog(x$17, logConfig, x$20, x$21, x$22, x$23, x$24, maxProducerIdExpirationMs, x$25, x$26, x$27, x$28, x$29);
        short epoch = (short)0;
        long firstAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, firstAppendTimestamp, coordinatorEpoch, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        Assertions.assertEquals((long)firstAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        this.mockTime().sleep(maxProducerIdExpirationMs);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.producerStateManager().lastEntry(producerId));
        long secondAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, secondAppendTimestamp, coordinatorEpoch - 1, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.close();
        File x$30 = this.logDir();
        long x$32 = 0L;
        boolean x$33 = false;
        BrokerTopicStats x$34 = this.createLog$default$3();
        Scheduler x$35 = this.createLog$default$4();
        Time x$36 = this.createLog$default$5();
        long x$37 = this.createLog$default$6();
        int x$38 = this.createLog$default$8();
        int x$39 = this.createLog$default$9();
        TierLogComponents x$40 = this.createLog$default$10();
        LogDirFailureChannel x$41 = this.createLog$default$11();
        boolean x$42 = this.createLog$default$13();
        log = this.createLog(x$30, logConfig, x$34, x$35, x$36, x$37, x$32, x$38, x$39, x$40, x$41, x$33, x$42);
        Assertions.assertEquals((long)secondAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        log.close();
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndNoCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.messageFormatVersion().recordVersion(), "");
        Files.createDirectories(this.logDir().toPath(), new FileAttribute[0]);
        MergedLog$.MODULE$.apply(this.logDir(), config, segments, 0L, 0L, (Scheduler)this.mockTime().scheduler(), this.brokerTopicStats(), new Metrics(), (Time)this.mockTime(), 300000, 30000, topicPartition, leaderEpochCache, stateManager, null, TierLogComponents$.MODULE$.EMPTY(), false, (Option)None$.MODULE$, true, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Option)None$.MODULE$);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.messageFormatVersion().recordVersion(), "");
        Files.createDirectories(this.logDir().toPath(), new FileAttribute[0]);
        MergedLog$.MODULE$.apply(this.logDir(), config, segments, 0L, 0L, (Scheduler)this.mockTime().scheduler(), this.brokerTopicStats(), new Metrics(), (Time)this.mockTime(), 300000, 30000, topicPartition, leaderEpochCache, stateManager, null, TierLogComponents$.MODULE$.EMPTY(), true, (Option)None$.MODULE$, true, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Option)None$.MODULE$);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testSkipTruncateAndReloadIfNewMessageFormatAndCleanShutdown() {
        ProducerStateManager stateManager = (ProducerStateManager)EasyMock.mock(ProducerStateManager.class);
        stateManager.removeStraySnapshots((Seq)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)stateManager.latestSnapshotOffset()).andReturn((Object)None$.MODULE$);
        stateManager.updateMapEndOffset(0L);
        EasyMock.expectLastCall().anyTimes();
        stateManager.takeSnapshot();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)stateManager.firstUnstableOffset()).andReturn((Object)None$.MODULE$);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{stateManager});
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.messageFormatVersion().recordVersion(), "");
        Files.createDirectories(this.logDir().toPath(), new FileAttribute[0]);
        MergedLog$.MODULE$.apply(this.logDir(), config, segments, 0L, 0L, (Scheduler)this.mockTime().scheduler(), this.brokerTopicStats(), new Metrics(), (Time)this.mockTime(), 300000, 30000, topicPartition, leaderEpochCache, stateManager, null, TierLogComponents$.MODULE$.EMPTY(), true, (Option)None$.MODULE$, true, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Option)None$.MODULE$);
        EasyMock.verify((Object[])new Object[]{stateManager});
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsMidSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$17 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$20 = 0;
        byte x$21 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$22 = TestUtils$.MODULE$.records$default$3();
        long x$23 = TestUtils$.MODULE$.records$default$7();
        int x$24 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$17, x$21, x$22, pid1, epoch, x$20, x$23, x$24), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$25 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$28 = 0;
        byte x$29 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$30 = TestUtils$.MODULE$.records$default$3();
        long x$31 = TestUtils$.MODULE$.records$default$7();
        int x$32 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$25, x$29, x$30, pid2, epoch, x$28, x$31, x$32), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$33 = this.logDir();
        long x$35 = 1L;
        boolean x$36 = false;
        BrokerTopicStats x$37 = this.createLog$default$3();
        Scheduler x$38 = this.createLog$default$4();
        Time x$39 = this.createLog$default$5();
        long x$40 = this.createLog$default$7();
        int x$41 = this.createLog$default$8();
        int x$42 = this.createLog$default$9();
        TierLogComponents x$43 = this.createLog$default$10();
        LogDirFailureChannel x$44 = this.createLog$default$11();
        boolean x$45 = this.createLog$default$13();
        AbstractLog reloadedLog = this.createLog(x$33, logConfig, x$37, x$38, x$39, x$35, x$40, x$41, x$42, x$43, x$44, x$36, x$45);
        Assertions.assertEquals((int)2, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedLastSeqOpt);
    }

    @Test
    public void testLoadingLogKeepsLargestStrayProducerStateSnapshot() {
        int x$1 = 10240;
        long x$2 = 0L;
        long x$3 = 60000L;
        long x$4 = 0L;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        boolean x$122 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$132 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$142 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$4, x$122, x$132, x$142, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        long pid1 = 1L;
        short epoch = (short)0;
        .colon.colon x$17 = new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$);
        int x$20 = 0;
        byte x$21 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$22 = TestUtils$.MODULE$.records$default$3();
        long x$23 = TestUtils$.MODULE$.records$default$7();
        int x$24 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$17, x$21, x$22, pid1, epoch, x$20, x$23, x$24), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$25 = new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$);
        int x$28 = 1;
        byte x$29 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$30 = TestUtils$.MODULE$.records$default$3();
        long x$31 = TestUtils$.MODULE$.records$default$7();
        int x$32 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$25, x$29, x$30, pid1, epoch, x$28, x$31, x$32), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$33 = new .colon.colon((Object)new SimpleRecord("c".getBytes()), (List)Nil$.MODULE$);
        int x$36 = 2;
        byte x$37 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$38 = TestUtils$.MODULE$.records$default$3();
        long x$39 = TestUtils$.MODULE$.records$default$7();
        int x$40 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$33, x$37, x$38, pid1, epoch, x$36, x$39, x$40), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$41 = new .colon.colon((Object)new SimpleRecord("d".getBytes()), (List)Nil$.MODULE$);
        int x$44 = 3;
        byte x$45 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$46 = TestUtils$.MODULE$.records$default$3();
        long x$47 = TestUtils$.MODULE$.records$default$7();
        int x$48 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$41, x$45, x$46, pid1, epoch, x$44, x$47, x$48), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.close();
        Assertions.assertEquals((int)log.localLogSegments().size(), (int)3);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        Files.createFile(Log$.MODULE$.producerSnapshotFile(this.logDir(), 3L).toPath(), new FileAttribute[0]);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        File x$49 = this.logDir();
        boolean x$51 = false;
        BrokerTopicStats x$52 = this.createLog$default$3();
        Scheduler x$53 = this.createLog$default$4();
        Time x$54 = this.createLog$default$5();
        long x$55 = this.createLog$default$6();
        long x$56 = this.createLog$default$7();
        int x$57 = this.createLog$default$8();
        int x$58 = this.createLog$default$9();
        TierLogComponents x$59 = this.createLog$default$10();
        LogDirFailureChannel x$60 = this.createLog$default$11();
        boolean x$61 = this.createLog$default$13();
        this.createLog(x$49, logConfig, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$51, x$61);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsOnSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$17 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$20 = 0;
        byte x$21 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$22 = TestUtils$.MODULE$.records$default$3();
        long x$23 = TestUtils$.MODULE$.records$default$7();
        int x$24 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$17, x$21, x$22, pid1, epoch, x$20, x$23, x$24), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$25 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$28 = 0;
        byte x$29 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$30 = TestUtils$.MODULE$.records$default$3();
        long x$31 = TestUtils$.MODULE$.records$default$7();
        int x$32 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$25, x$29, x$30, pid2, epoch, x$28, x$31, x$32), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$33 = this.logDir();
        long x$35 = 1L;
        boolean x$36 = false;
        BrokerTopicStats x$37 = this.createLog$default$3();
        Scheduler x$38 = this.createLog$default$4();
        Time x$39 = this.createLog$default$5();
        long x$40 = this.createLog$default$7();
        int x$41 = this.createLog$default$8();
        int x$42 = this.createLog$default$9();
        TierLogComponents x$43 = this.createLog$default$10();
        LogDirFailureChannel x$44 = this.createLog$default$11();
        boolean x$45 = this.createLog$default$13();
        AbstractLog reloadedLog = this.createLog(x$33, logConfig, x$37, x$38, x$39, x$35, x$40, x$41, x$42, x$43, x$44, x$36, x$45);
        Assertions.assertEquals((int)1, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedEntryOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedEntryOpt);
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$3 = 4096;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, segmentSize, x$5, x$6, x$7, x$8, x$9, indexInterval, x$3, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogRecoversToCorrectOffset$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((AbstractLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        long lastIndexOffset = ((AbstractLog)log.elem).activeSegment().offsetIndex().lastOffset();
        int numIndexEntries = ((AbstractLog)log.elem).activeSegment().offsetIndex().entries();
        long lastOffset = ((AbstractLog)log.elem).logEndOffset();
        long lastTimeIndexOffset = ((AbstractLog)log.elem).logEndOffset() - 1L;
        long lastTimeIndexTimestamp = ((AbstractLog)log.elem).activeSegment().largestTimestamp();
        int numTimeIndexEntries = ((AbstractLog)log.elem).activeSegment().timeIndex().entries() + (((AbstractLog)log.elem).activeSegment().timeIndex().lastEntry().offset() == ((AbstractLog)log.elem).logEndOffset() - 1L ? 0 : 1);
        ((AbstractLog)log.elem).close();
        File x$27 = this.logDir();
        boolean x$30 = false;
        BrokerTopicStats x$31 = this.createLog$default$3();
        Scheduler x$32 = this.createLog$default$4();
        Time x$33 = this.createLog$default$5();
        long x$34 = this.createLog$default$6();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        TierLogComponents x$37 = this.createLog$default$10();
        LogDirFailureChannel x$38 = this.createLog$default$11();
        boolean x$39 = this.createLog$default$13();
        log.elem = this.createLog(x$27, logConfig, x$31, x$32, x$33, x$34, lastOffset, x$35, x$36, x$37, x$38, x$30, x$39);
        LogLoaderTest.verifyRecoveredLog$1((AbstractLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((AbstractLog)log.elem).close();
        int recoveryPoint = 10;
        File x$40 = this.logDir();
        long x$42 = recoveryPoint;
        boolean x$43 = false;
        BrokerTopicStats x$44 = this.createLog$default$3();
        Scheduler x$45 = this.createLog$default$4();
        Time x$46 = this.createLog$default$5();
        long x$47 = this.createLog$default$6();
        int x$48 = this.createLog$default$8();
        int x$49 = this.createLog$default$9();
        TierLogComponents x$50 = this.createLog$default$10();
        LogDirFailureChannel x$51 = this.createLog$default$11();
        boolean x$52 = this.createLog$default$13();
        log.elem = this.createLog(x$40, logConfig, x$44, x$45, x$46, x$47, x$42, x$48, x$49, x$50, x$51, x$43, x$52);
        LogLoaderTest.verifyRecoveredLog$1((AbstractLog)log.elem, recoveryPoint, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((AbstractLog)log.elem).flush();
        LogLoaderTest.verifyRecoveredLog$1((AbstractLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((AbstractLog)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$152 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$162 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$152, x$162);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((AbstractLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.delete()));
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.delete()));
        File x$27 = this.logDir();
        boolean x$29 = false;
        BrokerTopicStats x$30 = this.createLog$default$3();
        Scheduler x$31 = this.createLog$default$4();
        Time x$32 = this.createLog$default$5();
        long x$33 = this.createLog$default$6();
        long x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        TierLogComponents x$37 = this.createLog$default$10();
        LogDirFailureChannel x$38 = this.createLog$default$11();
        boolean x$39 = this.createLog$default$13();
        log.elem = this.createLog(x$27, logConfig, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$29, x$39);
        Assertions.assertEquals((long)numMessages, (long)((AbstractLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        Assertions.assertTrue((((LogSegment)((AbstractLog)log.elem).localLogSegments().head()).offsetIndex().entries() > 0 ? 1 : 0) != 0, (String)"The index should have been rebuilt");
        Assertions.assertTrue((((LogSegment)((AbstractLog)log.elem).localLogSegments().head()).timeIndex().entries() > 0 ? 1 : 0) != 0, (String)"The time index should have been rebuilt");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((AbstractLog)log$3.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                this.assertOffset(((LogSegment)((AbstractLog)log$3.elem).localLogSegments().head()).baseOffset(), (FetchedTimestampAndOffset)((AbstractLog)log$3.elem).fetchOffsetByTimestamp(this.mockTime().milliseconds() + (long)(i * 10)).map((Function1 & Serializable & scala.Serializable)x$19 -> this.assertLocalTimestampAndOffset((MaybeResolvedTimestampAndOffset)x$19)).get());
                return;
            }
            this.assertOffset(i, (FetchedTimestampAndOffset)((AbstractLog)log$3.elem).fetchOffsetByTimestamp(this.mockTime().milliseconds() + (long)(i * 10)).map((Function1 & Serializable & scala.Serializable)x$20 -> this.assertLocalTimestampAndOffset((MaybeResolvedTimestampAndOffset)x$20)).get());
        });
        ((AbstractLog)log.elem).close();
    }

    @Test
    public void testRebuildTimeIndexForOldMessages() {
        int numMessages = 200;
        int segmentSize = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable timeIndexFiles = (Iterable)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((AbstractLog)log.elem).close();
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$3(file);
            return BoxedUnit.UNIT;
        });
        File x$11 = this.logDir();
        long x$13 = numMessages + 1;
        boolean x$14 = false;
        BrokerTopicStats x$15 = this.createLog$default$3();
        Scheduler x$16 = this.createLog$default$4();
        Time x$17 = this.createLog$default$5();
        long x$18 = this.createLog$default$6();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        TierLogComponents x$212 = this.createLog$default$10();
        LogDirFailureChannel x$22 = this.createLog$default$11();
        boolean x$23 = this.createLog$default$13();
        log.elem = this.createLog(x$11, logConfig, x$15, x$16, x$17, x$18, x$13, x$19, x$20, x$212, x$22, x$14, x$23);
        ((IterableLike)((AbstractLog)log.elem).localLogSegments().init()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$4(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCorruptIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((AbstractLog)log.elem).localLogSegments().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((AbstractLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$4(file);
            return BoxedUnit.UNIT;
        });
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$5(file);
            return BoxedUnit.UNIT;
        });
        File x$27 = this.logDir();
        boolean x$29 = false;
        BrokerTopicStats x$30 = this.createLog$default$3();
        Scheduler x$31 = this.createLog$default$4();
        Time x$32 = this.createLog$default$5();
        long x$33 = this.createLog$default$6();
        long x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        TierLogComponents x$37 = this.createLog$default$10();
        LogDirFailureChannel x$38 = this.createLog$default$11();
        boolean x$39 = this.createLog$default$13();
        log.elem = this.createLog(x$27, logConfig, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$29, x$39);
        Assertions.assertEquals((long)numMessages, (long)((AbstractLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((AbstractLog)log$5.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                this.assertOffset(((LogSegment)((AbstractLog)log$5.elem).localLogSegments().head()).baseOffset(), (FetchedTimestampAndOffset)((AbstractLog)log$5.elem).fetchOffsetByTimestamp(this.mockTime().milliseconds() + (long)(i * 10)).map((Function1 & Serializable & scala.Serializable)x$24 -> this.assertLocalTimestampAndOffset((MaybeResolvedTimestampAndOffset)x$24)).get());
                return;
            }
            this.assertOffset(i, (FetchedTimestampAndOffset)((AbstractLog)log$5.elem).fetchOffsetByTimestamp(this.mockTime().milliseconds() + (long)(i * 10)).map((Function1 & Serializable & scala.Serializable)x$25 -> this.assertLocalTimestampAndOffset((MaybeResolvedTimestampAndOffset)x$25)).get());
        });
        ((AbstractLog)log.elem).close();
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = Log$.MODULE$.offsetIndexFile(this.logDir(), 0L, Log$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex1 = Log$.MODULE$.timeIndexFile(this.logDir(), 0L, Log$.MODULE$.timeIndexFile$default$3());
        File bogusIndex2 = Log$.MODULE$.offsetIndexFile(this.logDir(), 5L, Log$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex2 = Log$.MODULE$.timeIndexFile(this.logDir(), 5L, Log$.MODULE$.timeIndexFile$default$3());
        bogusIndex2.createNewFile();
        bogusTimeIndex2.createNewFile();
        int x$1 = this.createRecords$1().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 1;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        ((LogSegment)log.localLogSegments().toSeq().head()).offsetIndex();
        ((LogSegment)log.localLogSegments().toSeq().head()).timeIndex();
        Assertions.assertTrue((bogusIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first index file should have been replaced with a larger file");
        Assertions.assertTrue((bogusTimeIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first time index file should have been replaced with a larger file");
        Assertions.assertFalse((boolean)bogusIndex2.exists(), (String)"The second index file should have been deleted.");
        Assertions.assertFalse((boolean)bogusTimeIndex2.exists(), (String)"The second time index file should have been deleted.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(this.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        int x$1 = this.createRecords$2().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 10000;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testReopenThenTruncate$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((AbstractLog)log.elem).close();
        File x$22 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        Scheduler x$26 = this.createLog$default$4();
        Time x$27 = this.createLog$default$5();
        long x$28 = this.createLog$default$6();
        long x$29 = this.createLog$default$7();
        int x$30 = this.createLog$default$8();
        int x$31 = this.createLog$default$9();
        TierLogComponents x$32 = this.createLog$default$10();
        LogDirFailureChannel x$33 = this.createLog$default$11();
        boolean x$34 = this.createLog$default$13();
        log.elem = this.createLog(x$22, logConfig, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$24, x$34);
        ((AbstractLog)log.elem).truncateTo(3L);
        Assertions.assertEquals((int)1, (int)((AbstractLog)log.elem).numberOfSegments(), (String)"All but one segment should be deleted.");
        Assertions.assertEquals((long)3L, (long)((AbstractLog)log.elem).logEndOffset(), (String)"Log end offset should be 3.");
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        int x$1 = this.createRecords$3().sizeInBytes() * 5;
        int x$2 = 1000;
        long x$3 = 999L;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$3, x$5, x$6, x$7, x$8, x$9, x$2, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testOpenDeletesObsoleteFiles$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((AbstractLog)log.elem).updateHighWatermark(((AbstractLog)log.elem).logEndOffset());
        ((AbstractLog)log.elem).deleteOldSegments();
        ((AbstractLog)log.elem).close();
        File x$22 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        Scheduler x$26 = this.createLog$default$4();
        Time x$27 = this.createLog$default$5();
        long x$28 = this.createLog$default$6();
        long x$29 = this.createLog$default$7();
        int x$30 = this.createLog$default$8();
        int x$31 = this.createLog$default$9();
        TierLogComponents x$32 = this.createLog$default$10();
        LogDirFailureChannel x$33 = this.createLog$default$11();
        boolean x$34 = this.createLog$default$13();
        log.elem = this.createLog(x$22, logConfig, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$24, x$34);
        Assertions.assertEquals((int)1, (int)((AbstractLog)log.elem).numberOfSegments(), (String)"The deleted segments should be gone.");
    }

    @Test
    public void testCorruptLog() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            this.logDir().mkdirs();
            ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
            int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCorruptLog$2(this, log, BoxesRunTime.unboxToInt((Object)_)));
            List records = ((TraversableOnce)((AbstractLog)log.elem).localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)x$26 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$26.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            ((AbstractLog)log.elem).close();
            TestUtils$.MODULE$.appendNonsenseToFile(((AbstractLog)log.elem).activeSegment().lazyOffsetIndex().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            TestUtils$.MODULE$.appendNonsenseToFile(((AbstractLog)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            File x$22 = this.logDir();
            BrokerTopicStats x$24 = this.brokerTopicStats();
            boolean x$262 = false;
            Scheduler x$272 = this.createLog$default$4();
            Time x$28 = this.createLog$default$5();
            long x$29 = this.createLog$default$6();
            int x$30 = this.createLog$default$8();
            int x$31 = this.createLog$default$9();
            TierLogComponents x$32 = this.createLog$default$10();
            LogDirFailureChannel x$33 = this.createLog$default$11();
            boolean x$34 = this.createLog$default$13();
            log.elem = this.createLog(x$22, logConfig, x$24, x$272, x$28, x$29, recoveryPoint, x$30, x$31, x$32, x$33, x$262, x$34);
            Assertions.assertEquals((long)numMessages, (long)((AbstractLog)log.elem).logEndOffset());
            List recovered = ((TraversableOnce)((AbstractLog)log.elem).localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)x$27 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$27.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            Assertions.assertEquals((int)records.size(), (int)recovered.size());
            records.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Record expected = (Record)records.apply(i);
                Record actual = (Record)recovered.apply(i);
                Assertions.assertEquals((Object)expected.key(), (Object)actual.key(), (String)"Keys not equal");
                Assertions.assertEquals((Object)expected.value(), (Object)actual.value(), (String)"Values not equal");
                Assertions.assertEquals((long)expected.timestamp(), (long)actual.timestamp(), (String)"Timestamps not equal");
            });
            Utils.delete((File)this.logDir());
        });
    }

    @Test
    public void testOverCompactedLogRecovery() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 3L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)Log$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecovery$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecovery$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testLeaderEpochCacheClearedAfterStaticMessageFormatDowngrade() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("foo".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.latestEpoch());
        log.close();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "1000");
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), "65536");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig downgradedLogConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$17 = this.logDir();
        boolean x$19 = false;
        BrokerTopicStats x$20 = this.createLog$default$3();
        Scheduler x$21 = this.createLog$default$4();
        Time x$22 = this.createLog$default$5();
        long x$23 = this.createLog$default$6();
        long x$24 = this.createLog$default$7();
        int x$25 = this.createLog$default$8();
        int x$26 = this.createLog$default$9();
        TierLogComponents x$27 = this.createLog$default$10();
        LogDirFailureChannel x$28 = this.createLog$default$11();
        boolean x$29 = this.createLog$default$13();
        AbstractLog reopened = this.createLog(x$17, downgradedLogConfig, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$19, x$29);
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
        reopened.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("bar".getBytes()), (List)Nil$.MODULE$), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, reopened.appendAsLeader$default$3(), reopened.appendAsLeader$default$4(), reopened.appendAsLeader$default$5());
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecord() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)Log$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecordV1() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        MemoryRecords set1 = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)3L, (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)Log$.MODULE$.producerSnapshotFile(this.logDir(), 3L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)Log$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 4L).exists());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(file)));
        Assertions.assertEquals((int)3, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryOfSegmentWithOffsetOverflow() {
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)var27_19);
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        recoveredLog.localLogSegments().foreach(arg_0 -> LogLoaderTest.$anonfun$testRecoveryOfSegmentWithOffsetOverflow$1((AbstractLog)var27_19, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase1() {
        void var28_20;
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var27_19;
        void segmentWithOverflow2 = var28_20;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2);
        int numSegmentsInitial = log2.localLogSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(file);
            return BoxedUnit.UNIT;
        });
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.localLogSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase2() {
        void var28_20;
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var27_19;
        void segmentWithOverflow2 = var28_20;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2);
        int numSegmentsInitial = log2.localLogSegments().size();
        List newSegments = log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2);
        newSegments.reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(newSegments, segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(file);
            return BoxedUnit.UNIT;
        });
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.localLogSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase3() {
        void var28_20;
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var27_19;
        void segmentWithOverflow2 = var28_20;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2);
        int numSegmentsInitial = log2.localLogSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            segment.changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.localLogSegments().size());
        log2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase4() {
        void var28_20;
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var27_19;
        void segmentWithOverflow2 = var28_20;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2);
        int numSegmentsInitial = log2.localLogSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)x$32 -> {
            x$32.changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.localLogSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase5() {
        void var28_20;
        void var27_19;
        long x$16;
        int x$15;
        long x$14;
        long x$13;
        boolean x$12;
        String x$11;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10(), x$2, x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12(), x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13(), x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14(), x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15(), x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16());
        Tuple2<AbstractLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var27_19;
        void segmentWithOverflow2 = var28_20;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((AbstractLog)log2);
        int numSegmentsInitial = log2.localLogSegments().size();
        ((LogSegment)log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).last()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        segmentWithOverflow2.truncateTo(0L);
        AbstractLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.localLogSegments().size());
        recoveredLog.close();
    }

    @Test
    public void testCleanShutdownFile() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCleanShutdownFile$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((AbstractLog)log.elem).close();
        long recoveryPoint = ((AbstractLog)log.elem).logEndOffset();
        log.elem = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        Assertions.assertEquals((long)recoveryPoint, (long)((AbstractLog)log.elem).logEndOffset());
    }

    @Test
    public void testLogRecoversForLeaderEpoch() {
        AbstractLog log = this.createLog(this.logDir(), LogConfig$.MODULE$.apply(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        LeaderEpochFileCache leaderEpochCache = (LeaderEpochFileCache)log.leaderEpochCache().get();
        byte[] x$1 = "random".getBytes();
        int x$2 = 1;
        long x$3 = 0L;
        byte[] x$4 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$5 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$6 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$7 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords firstBatch = this.singletonRecordsWithLeaderEpoch(x$1, x$4, x$2, x$3, x$5, x$6, x$7);
        log.appendAsFollower(firstBatch);
        byte[] x$8 = "random".getBytes();
        int x$9 = 2;
        long x$10 = 1L;
        byte[] x$11 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$12 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$13 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$14 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords secondBatch = this.singletonRecordsWithLeaderEpoch(x$8, x$11, x$9, x$10, x$12, x$13, x$14);
        log.appendAsFollower(secondBatch);
        byte[] x$15 = "random".getBytes();
        int x$16 = 2;
        long x$17 = 2L;
        byte[] x$18 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$19 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$20 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$21 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords thirdBatch = this.singletonRecordsWithLeaderEpoch(x$15, x$18, x$16, x$17, x$19, x$20, x$21);
        log.appendAsFollower(thirdBatch);
        byte[] x$22 = "random".getBytes();
        int x$23 = 3;
        long x$24 = 3L;
        byte[] x$25 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$26 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$27 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$28 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords fourthBatch = this.singletonRecordsWithLeaderEpoch(x$22, x$25, x$23, x$24, x$26, x$27, x$28);
        log.appendAsFollower(fourthBatch);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        leaderEpochCache.truncateFromEnd(2L);
        Assertions.assertNotEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        log.close();
        File x$29 = this.logDir();
        LogConfig x$30 = LogConfig$.MODULE$.apply();
        boolean x$31 = false;
        BrokerTopicStats x$32 = this.createLog$default$3();
        Scheduler x$33 = this.createLog$default$4();
        Time x$34 = this.createLog$default$5();
        long x$35 = this.createLog$default$6();
        long x$36 = this.createLog$default$7();
        int x$37 = this.createLog$default$8();
        int x$38 = this.createLog$default$9();
        TierLogComponents x$39 = this.createLog$default$10();
        LogDirFailureChannel x$40 = this.createLog$default$11();
        boolean x$41 = this.createLog$default$13();
        AbstractLog recoveredLog = this.createLog(x$29, x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$31, x$41);
        LeaderEpochFileCache recoveredLeaderEpochCache = (LeaderEpochFileCache)recoveredLog.leaderEpochCache().get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)recoveredLeaderEpochCache.epochEntries());
        recoveredLog.close();
    }

    @Test
    public void testFullTransactionIndexRecovery() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testFullTransactionIndexRecovery$1(segment)));
        log.close();
        int x$17 = 5120;
        long x$18 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$19 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$21 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$22 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$23 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$24 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$25 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$26 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$27 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$28 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$29 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$30 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$31 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$32 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$18, x$17, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
        File x$33 = this.logDir();
        boolean x$35 = false;
        BrokerTopicStats x$36 = this.createLog$default$3();
        Scheduler x$37 = this.createLog$default$4();
        Time x$38 = this.createLog$default$5();
        long x$39 = this.createLog$default$6();
        long x$40 = this.createLog$default$7();
        int x$41 = this.createLog$default$8();
        int x$42 = this.createLog$default$9();
        TierLogComponents x$43 = this.createLog$default$10();
        LogDirFailureChannel x$44 = this.createLog$default$11();
        boolean x$45 = this.createLog$default$13();
        AbstractLog reloadedLog = this.createLog(x$33, reloadedLogConfig, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$35, x$45);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverOnlyLastSegment() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogSegment lastSegment = log.activeSegment();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$17 = 5120;
        long x$18 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$19 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$21 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$22 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$23 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$24 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$25 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$26 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$27 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$28 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$29 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$30 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$31 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$32 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$18, x$17, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
        File x$33 = this.logDir();
        boolean x$36 = false;
        BrokerTopicStats x$37 = this.createLog$default$3();
        Scheduler x$38 = this.createLog$default$4();
        Time x$39 = this.createLog$default$5();
        long x$40 = this.createLog$default$6();
        int x$41 = this.createLog$default$8();
        int x$42 = this.createLog$default$9();
        TierLogComponents x$43 = this.createLog$default$10();
        LogDirFailureChannel x$44 = this.createLog$default$11();
        boolean x$45 = this.createLog$default$13();
        AbstractLog reloadedLog = this.createLog(x$33, reloadedLogConfig, x$37, x$38, x$39, x$40, recoveryPoint, x$41, x$42, x$43, x$44, x$36, x$45);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverLastSegmentWithNoSnapshots() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.deleteProducerSnapshotFiles(this.logDir());
        LogSegment lastSegment = log.activeSegment();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$17 = 5120;
        long x$18 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$19 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$21 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$22 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$23 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$24 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$25 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$26 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$27 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$28 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$29 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$30 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$31 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$32 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$18, x$17, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
        File x$33 = this.logDir();
        boolean x$36 = false;
        BrokerTopicStats x$37 = this.createLog$default$3();
        Scheduler x$38 = this.createLog$default$4();
        Time x$39 = this.createLog$default$5();
        long x$40 = this.createLog$default$6();
        int x$41 = this.createLog$default$8();
        int x$42 = this.createLog$default$9();
        TierLogComponents x$43 = this.createLog$default$10();
        LogDirFailureChannel x$44 = this.createLog$default$11();
        boolean x$45 = this.createLog$default$13();
        AbstractLog reloadedLog = this.createLog(x$33, reloadedLogConfig, x$37, x$38, x$39, x$40, recoveryPoint, x$41, x$42, x$43, x$44, x$36, x$45);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverLeaderEpochCacheOnUncleanShutdown() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13());
        MemoryRecords x$17 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("foo".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$18 = 5;
        AppendOrigin x$19 = log.appendAsLeader$default$3();
        ApiVersion x$20 = log.appendAsLeader$default$4();
        RequestLocal x$21 = log.appendAsLeader$default$5();
        log.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.leaderEpochCache().flatMap((Function1 & Serializable & scala.Serializable)x$34 -> x$34.latestEpoch()));
        log.close();
        File x$22 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        Scheduler x$26 = this.createLog$default$4();
        Time x$27 = this.createLog$default$5();
        long x$28 = this.createLog$default$6();
        long x$29 = this.createLog$default$7();
        int x$30 = this.createLog$default$8();
        int x$31 = this.createLog$default$9();
        TierLogComponents x$32 = this.createLog$default$10();
        LogDirFailureChannel x$33 = this.createLog$default$11();
        boolean x$342 = this.createLog$default$13();
        log = this.createLog(x$22, logConfig, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$24, x$342);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.leaderEpochCache().flatMap((Function1 & Serializable & scala.Serializable)x$35 -> x$35.latestEpoch()));
    }

    @Test
    public void testLogEndLessThanStartAfterReopen() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11(), LogTestUtils$.MODULE$.createLogConfig$default$12(), LogTestUtils$.MODULE$.createLogConfig$default$13(), LogTestUtils$.MODULE$.createLogConfig$default$14(), LogTestUtils$.MODULE$.createLogConfig$default$15(), LogTestUtils$.MODULE$.createLogConfig$default$16());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogEndLessThanStartAfterReopen$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)6, (int)((AbstractLog)log.elem).localLogSegments().size());
        int startOffset = 4;
        ((AbstractLog)log.elem).updateHighWatermark(((AbstractLog)log.elem).logEndOffset());
        ((AbstractLog)log.elem).maybeIncrementLogStartOffset((long)startOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((((AbstractLog)log.elem).logEndOffset() > ((AbstractLog)log.elem).logStartOffset() ? 1 : 0) != 0);
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((AbstractLog)log.elem).localLogSegments().take(2)).last();
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((AbstractLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = startOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        Scheduler x$12 = this.createLog$default$4();
        Time x$13 = this.createLog$default$5();
        long x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        TierLogComponents x$17 = this.createLog$default$10();
        LogDirFailureChannel x$18 = this.createLog$default$11();
        boolean x$19 = this.createLog$default$13();
        log.elem = this.createLog(x$7, logConfig, x$11, x$12, x$13, x$9, x$14, x$15, x$16, x$17, x$18, x$10, x$19);
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((int)1, (int)((AbstractLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((long)startOffset, (long)((AbstractLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)startOffset, (long)((AbstractLog)log.elem).logEndOffset());
        LogSegment onlySegment = (LogSegment)((AbstractLog)log.elem).localLogSegments().head();
        Assertions.assertEquals((long)startOffset, (long)onlySegment.baseOffset());
        Assertions.assertTrue((boolean)onlySegment.log().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyOffsetIndex().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyTimeIndex().file().exists());
    }

    @Test
    public void testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11(), LogTestUtils$.MODULE$.createLogConfig$default$12(), LogTestUtils$.MODULE$.createLogConfig$default$13(), LogTestUtils$.MODULE$.createLogConfig$default$14(), LogTestUtils$.MODULE$.createLogConfig$default$15(), LogTestUtils$.MODULE$.createLogConfig$default$16());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11(), this.createLog$default$12(), this.createLog$default$13()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)10, (int)((AbstractLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((long)0L, (long)((AbstractLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((AbstractLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        int newLogStartOffset = 4;
        ((AbstractLog)log.elem).updateHighWatermark(((AbstractLog)log.elem).logEndOffset());
        ((AbstractLog)log.elem).maybeIncrementLogStartOffset((long)newLogStartOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((long)4L, (long)((AbstractLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).logEndOffset());
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((AbstractLog)log.elem).localLogSegments().take(2)).last();
        Assertions.assertEquals((long)1L, (long)segmentToForceTruncation.baseOffset());
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((AbstractLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = newLogStartOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        Scheduler x$12 = this.createLog$default$4();
        Time x$13 = this.createLog$default$5();
        long x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        TierLogComponents x$17 = this.createLog$default$10();
        LogDirFailureChannel x$18 = this.createLog$default$11();
        boolean x$19 = this.createLog$default$13();
        log.elem = this.createLog(x$7, logConfig, x$11, x$12, x$13, x$9, x$14, x$15, x$16, x$17, x$18, x$10, x$19);
        Assertions.assertEquals((int)1, (int)((AbstractLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((long)4L, (long)((AbstractLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)4L, (long)((AbstractLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)4L, (long)((AbstractLog)log.elem).logEndOffset());
        IndexedSeq offsetsWithSnapshotFiles = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)offset -> SnapshotFile$.MODULE$.apply(Log$.MODULE$.producerSnapshotFile(this.logDir(), (long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)snapshotFile -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(snapshotFile)))).map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToLong((long)x$36.offset()), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq inMemorySnapshotFiles = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).flatMap((Function1 & Serializable & scala.Serializable)offset -> Option$.MODULE$.option2Iterable(((AbstractLog)log.elem).producerStateManager().snapshotFileForOffset((long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)offsetsWithSnapshotFiles.isEmpty(), (String)new StringBuilder(76).append("Found offsets with producer state snapshot files: ").append(offsetsWithSnapshotFiles).append(" while none were expected.").toString());
        Assertions.assertTrue((boolean)inMemorySnapshotFiles.isEmpty(), (String)new StringBuilder(73).append("Found in-memory producer state snapshot files: ").append(inMemorySnapshotFiles).append(" while none were expected.").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((AbstractLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((long)newLogStartOffset, (long)((AbstractLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((AbstractLog)log.elem).logEndOffset());
        ListBuffer offsetsWithMissingSnapshotFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFile = ((AbstractLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            if (snapshotFile.isEmpty() || !((SnapshotFile)snapshotFile.get()).file().exists()) {
                offsetsWithMissingSnapshotFiles.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offset}));
            }
        });
        Assertions.assertTrue((boolean)offsetsWithMissingSnapshotFiles.isEmpty(), (String)new StringBuilder(58).append("Found offsets with missing producer state snapshot files: ").append(offsetsWithMissingSnapshotFiles).toString());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).exists((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)x$37.endsWith(Log$.MODULE$.DeletedFileSuffix()))), (String)"Expected no files to be present with the deleted file suffix");
    }

    private final /* synthetic */ LogLoaderTest$SimulateError$2$ SimulateError$lzycompute$1(LazyRef SimulateError$module$1) {
        synchronized (SimulateError$module$1) {
            LogLoaderTest$SimulateError$2$ logLoaderTest$SimulateError$2$ = SimulateError$module$1.initialized() ? (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value()) : (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.initialize((Object)new LogLoaderTest$SimulateError$2$(this)));
            return logLoaderTest$SimulateError$2$;
        }
    }

    private final LogLoaderTest$SimulateError$2$ SimulateError$3(LazyRef SimulateError$module$1) {
        if (SimulateError$module$1.initialized()) {
            return (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value());
        }
        return this.SimulateError$lzycompute$1(SimulateError$module$1);
    }

    private final LogManager interceptedLogManager$1(LogConfig logConfig, Seq logDirs, SimulateError.1 simulateError, MockTime time$1, BooleanRef cleanShutdownInterceptedValue$1) {
        Metrics metrics = new Metrics();
        return new LogManager(this, logDirs, logConfig, time$1, metrics, simulateError, cleanShutdownInterceptedValue$1){
            private final /* synthetic */ LogLoaderTest $outer;
            private final Kafka_log_LogLoaderTest$SimulateError$1 simulateError$1;
            private final BooleanRef cleanShutdownInterceptedValue$1;
            private final MockTime time$1;
            private final Metrics metrics$1;

            public AbstractLog loadLog(File logDir, boolean hadCleanShutdown, Map<TopicPartition, Object> recoveryPoints, Map<TopicPartition, Object> logStartOffsets, LogConfig defaultConfig, Map<String, LogConfig> topicConfigs) {
                if (this.simulateError$1.hasError()) {
                    throw new RuntimeException("Simulated error");
                }
                this.cleanShutdownInterceptedValue$1.elem = hadCleanShutdown;
                TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(logDir);
                LogConfig config = (LogConfig)topicConfigs.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> defaultConfig);
                long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)recoveryPoints.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                long logStartOffset = BoxesRunTime.unboxToLong((Object)logStartOffsets.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
                TierPartitionState tierPartitionState = tierLogComponents.partitionStateFactory().initState(logDir, topicPartition, config, logDirFailureChannel, (Scheduler)this.time$1.scheduler());
                LogSegments segments = new LogSegments(topicPartition);
                Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(logDir, topicPartition, logDirFailureChannel, config.messageFormatVersion().recordVersion(), "");
                ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, logDir, this.maxPidExpirationMs(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
                LoadLogParams loadLogParams = new LoadLogParams(logDir, topicPartition, config, (Scheduler)this.time$1.scheduler(), (Time)this.time$1, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, logRecoveryPoint, this.maxPidExpirationMs(), leaderEpochCache, producerStateManager);
                LoadedLogOffsets offsets = LogLoader$.MODULE$.load(loadLogParams);
                Log localLog = new Log(logDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time$1.scheduler(), this.$outer.brokerTopicStats(), this.metrics$1, (Time)this.time$1, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$2 -> {}, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset, (Option)None$.MODULE$, true, Log$.MODULE$.$lessinit$greater$default$20());
                return new MergedLog(localLog, logStartOffset, hadCleanShutdown, tierPartitionState, tierLogComponents);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulateError$1 = simulateError$1;
                this.cleanShutdownInterceptedValue$1 = cleanShutdownInterceptedValue$1;
                this.time$1 = time$1;
                this.metrics$1 = metrics$1;
                Seq x$11 = (Seq)logDirs$1.map((Function1)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final File apply(File x$1) {
                        return x$1.getAbsoluteFile();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
                MockConfigRepository x$13 = new MockConfigRepository();
                boolean x$1 = false;
                int x$2 = CleanerConfig$.MODULE$.apply$default$1();
                long x$3 = CleanerConfig$.MODULE$.apply$default$2();
                double x$4 = CleanerConfig$.MODULE$.apply$default$3();
                int x$5 = CleanerConfig$.MODULE$.apply$default$4();
                int x$6 = CleanerConfig$.MODULE$.apply$default$5();
                double x$7 = CleanerConfig$.MODULE$.apply$default$6();
                long x$8 = CleanerConfig$.MODULE$.apply$default$7();
                int x$9 = CleanerConfig$.MODULE$.apply$default$9();
                String x$10 = CleanerConfig$.MODULE$.apply$default$10();
                CleanerConfig x$15 = new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10);
                int x$16 = 4;
                long x$17 = 1000L;
                long x$18 = 10000L;
                long x$19 = 10000L;
                int x$20 = 15000;
                long x$21 = 1500L;
                int x$22 = Integer.MAX_VALUE;
                int x$23 = 3600000;
                MockScheduler x$24 = time$1.scheduler();
                BrokerTopicStats x$27 = new BrokerTopicStats();
                LogDirFailureChannel x$28 = new LogDirFailureChannel(logDirs$1.size());
                TierLogComponents x$29 = TierLogComponents$.MODULE$.EMPTY();
                boolean x$30 = $outer.config().usesTopicId();
                ApiVersion x$31 = $outer.config().interBrokerProtocolVersion();
                super(x$11, (Seq)x$12, (ConfigRepository)x$13, logConfig$1, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$31, (Scheduler)x$24, x$27, metrics$1, x$28, x$29, (Time)time$1, x$30);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loadLog$1(kafka.log.LogConfig ), $anonfun$loadLog$2(), $anonfun$loadLog$3(), $anonfun$loadLog$4(long ), $anonfun$loadLog$5(long )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(LogLoaderTest $this, ObjectRef log$1, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        AbstractLog qual$1 = (AbstractLog)log$1.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
    }

    private final MergedLog createLogWithInterceptedReads$1(long recoveryPoint, Set segmentsWithReads$1, Set recoveredSegments$1, LogConfig logConfig$2) {
        int maxProducerIdExpirationMs = 3600000;
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogSegments interceptedLogSegments = new LogSegments(this, topicPartition, segmentsWithReads$1, recoveredSegments$1){
            private final /* synthetic */ LogLoaderTest $outer;
            public final Set segmentsWithReads$1;
            public final Set recoveredSegments$1;

            public LogSegment add(LogSegment segment) {
                LogSegment wrapper = new LogSegment(this, segment){
                    private final /* synthetic */ $anon$2 $outer;

                    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
                        this.$outer.segmentsWithReads$1.$plus$eq((Object)((Object)this));
                        return super.read(startOffset, maxSize, maxPosition, minOneMessage);
                    }

                    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
                        this.$outer.recoveredSegments$1.$plus$eq((Object)((Object)this));
                        return super.recover(producerStateManager, leaderEpochCache);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(segment$1.log(), segment$1.lazyOffsetIndex(), segment$1.lazyTimeIndex(), segment$1.txnIndex(), segment$1.baseOffset(), segment$1.indexIntervalBytes(), segment$1.rollJitterMs(), (Time)$outer.kafka$log$LogLoaderTest$$anon$$$outer().mockTime());
                    }
                };
                return super.add(wrapper);
            }

            public /* synthetic */ LogLoaderTest kafka$log$LogLoaderTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentsWithReads$1 = segmentsWithReads$1;
                this.recoveredSegments$1 = recoveredSegments$1;
                super(topicPartition$1);
            }
        };
        Option leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, logConfig$2.messageFormatVersion().recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.logDir(), maxProducerIdExpirationMs, (Time)this.mockTime());
        LoadLogParams loadLogParams = new LoadLogParams(this.logDir(), topicPartition, logConfig$2, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, interceptedLogSegments, 0L, recoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager);
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(loadLogParams);
        File x$1 = this.logDir();
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        MockScheduler x$6 = this.mockTime().scheduler();
        BrokerTopicStats x$7 = this.brokerTopicStats();
        Metrics x$8 = new Metrics();
        MockTime x$9 = this.mockTime();
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        NoOpLogOffsetsListener$ x$15 = NoOpLogOffsetsListener$.MODULE$;
        None$ x$16 = None$.MODULE$;
        boolean x$17 = true;
        Function1 x$18 = Log$.MODULE$.$lessinit$greater$default$16();
        Function0 x$19 = Log$.MODULE$.$lessinit$greater$default$17();
        Option x$20 = Log$.MODULE$.$lessinit$greater$default$20();
        Log localLog = new Log(x$1, logConfig$2, interceptedLogSegments, x$4, x$5, (Scheduler)x$6, x$7, x$8, (Time)x$9, x$10, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, (LogOffsetsListener)x$15, x$18, x$19, (Option)x$16, x$17, x$20);
        TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        TierPartitionState tierPartitionState = tierLogComponents.partitionStateFactory().initState(this.logDir(), topicPartition, localLog.config(), logDirFailureChannel, (Scheduler)this.mockTime().scheduler());
        return new MergedLog(localLog, 0L, false, tierPartitionState, tierLogComponents);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogRecoversToCorrectOffset$1(LogLoaderTest $this, ObjectRef log$2, int messageSize$1, int i) {
        AbstractLog qual$1 = (AbstractLog)log$2.elem;
        byte[] x$17 = TestUtils$.MODULE$.randomBytes(messageSize$1);
        long x$18 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$19 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$20 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$21 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$22 = TestUtils$.MODULE$.singletonRecords(x$17, x$19, x$20, x$18, x$21);
        int x$23 = 0;
        AppendOrigin x$24 = qual$1.appendAsLeader$default$3();
        ApiVersion x$25 = qual$1.appendAsLeader$default$4();
        RequestLocal x$26 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$22, x$23, x$24, x$25, x$26);
    }

    private static final void verifyRecoveredLog$1(AbstractLog log, long expectedRecoveryPoint, int numMessages$1, long lastIndexOffset$1, int numIndexEntries$1, long lastTimeIndexTimestamp$1, long lastTimeIndexOffset$1, int numTimeIndexEntries$1) {
        Assertions.assertEquals((long)expectedRecoveryPoint, (long)log.recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages$1, (long)log.logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages$1).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((long)lastIndexOffset$1, (long)log.activeSegment().offsetIndex().lastOffset(), (String)"Should have same last index offset as before.");
        Assertions.assertEquals((int)numIndexEntries$1, (int)log.activeSegment().offsetIndex().entries(), (String)"Should have same number of index entries as before.");
        Assertions.assertEquals((long)lastTimeIndexTimestamp$1, (long)log.activeSegment().timeIndex().lastEntry().timestamp(), (String)"Should have same last time index timestamp");
        Assertions.assertEquals((long)lastTimeIndexOffset$1, (long)log.activeSegment().timeIndex().lastEntry().offset(), (String)"Should have same last time index offset");
        Assertions.assertEquals((int)numTimeIndexEntries$1, (int)log.activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testIndexRebuild$1(LogLoaderTest $this, ObjectRef log$3, int i) {
        AbstractLog qual$1 = (AbstractLog)log$3.elem;
        byte[] x$17 = TestUtils$.MODULE$.randomBytes(10);
        long x$18 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$19 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$20 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$21 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$22 = TestUtils$.MODULE$.singletonRecords(x$17, x$19, x$20, x$18, x$21);
        int x$23 = 0;
        AppendOrigin x$24 = qual$1.appendAsLeader$default$3();
        ApiVersion x$25 = qual$1.appendAsLeader$default$4();
        RequestLocal x$26 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$22, x$23, x$24, x$25, x$26);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRebuildTimeIndexForOldMessages$1(LogLoaderTest $this, ObjectRef log$4, int i) {
        AbstractLog qual$1 = (AbstractLog)log$4.elem;
        byte[] x$1 = TestUtils$.MODULE$.randomBytes(10);
        long x$2 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte x$3 = 1;
        byte[] x$4 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$5 = TestUtils$.MODULE$.singletonRecords$default$3();
        MemoryRecords x$6 = TestUtils$.MODULE$.singletonRecords(x$1, x$4, x$5, x$2, x$3);
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$3(File file) {
        Files.delete(file.toPath());
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$4(LogSegment segment) {
        Assertions.assertEquals((int)0, (int)segment.timeIndex().entries(), (String)"The time index should be empty");
        Assertions.assertEquals((long)0L, (long)segment.lazyTimeIndex().file().length(), (String)"The time index file size should be 0");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptIndexRebuild$1(LogLoaderTest $this, ObjectRef log$5, int i) {
        AbstractLog qual$1 = (AbstractLog)log$5.elem;
        byte[] x$17 = TestUtils$.MODULE$.randomBytes(10);
        long x$18 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$19 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$20 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$21 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$22 = TestUtils$.MODULE$.singletonRecords(x$17, x$19, x$20, x$18, x$21);
        int x$23 = 0;
        AppendOrigin x$24 = qual$1.appendAsLeader$default$3();
        ApiVersion x$25 = qual$1.appendAsLeader$default$4();
        RequestLocal x$26 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$22, x$23, x$24, x$25, x$26);
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$4(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$5(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    private final MemoryRecords createRecords$2() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testReopenThenTruncate$1(LogLoaderTest $this, ObjectRef log$7, int _) {
        AbstractLog qual$1 = (AbstractLog)log$7.elem;
        MemoryRecords x$17 = $this.createRecords$2();
        int x$18 = 0;
        AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
    }

    private final MemoryRecords createRecords$3() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds() - 1000L;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testOpenDeletesObsoleteFiles$1(LogLoaderTest $this, ObjectRef log$8, int _) {
        AbstractLog qual$1 = (AbstractLog)log$8.elem;
        MemoryRecords x$17 = $this.createRecords$3();
        int x$18 = 0;
        AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
    }

    private final MemoryRecords createRecords$4() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptLog$2(LogLoaderTest $this, ObjectRef log$9, int _) {
        AbstractLog qual$1 = (AbstractLog)log$9.elem;
        MemoryRecords x$17 = $this.createRecords$4();
        int x$18 = 0;
        AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecovery$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecovery$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecord$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecord$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$testRecoveryOfSegmentWithOffsetOverflow$1(AbstractLog log$10, LogSegment segment) {
        return (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> log$10.splitOverflowedSegment(segment));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(LogSegment segment) {
        segment.changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(List newSegments$1, LogSegment segment) {
        LogSegment logSegment = segment;
        Object object = newSegments$1.last();
        if (logSegment == null ? object != null : !logSegment.equals(object)) {
            segment.changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        } else {
            segment.changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        }
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(File file) {
        Utils.delete((File)file);
    }

    private final MemoryRecords createRecords$5() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleanShutdownFile$1(LogLoaderTest $this, ObjectRef log$11, int _) {
        AbstractLog qual$1 = (AbstractLog)log$11.elem;
        MemoryRecords x$17 = $this.createRecords$5();
        int x$18 = 0;
        AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
    }

    public static final /* synthetic */ boolean $anonfun$testFullTransactionIndexRecovery$1(LogSegment segment) {
        segment.offsetIndex().deleteIfExists();
        return segment.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testLogEndLessThanStartAfterReopen$1(LogLoaderTest $this, ObjectRef log$12, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        AbstractLog qual$1 = (AbstractLog)log$12.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        AbstractLog qual$2 = (AbstractLog)log$12.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        AbstractLog qual$1 = (AbstractLog)log$13.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        AbstractLog qual$2 = (AbstractLog)log$13.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(SnapshotFile snapshotFile) {
        return snapshotFile.file().exists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        AbstractLog qual$3 = (AbstractLog)log$13.elem;
        MemoryRecords x$20 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$21 = 0;
        AppendOrigin x$22 = qual$3.appendAsLeader$default$3();
        ApiVersion x$23 = qual$3.appendAsLeader$default$4();
        RequestLocal x$24 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$20, x$21, x$22, x$23, x$24);
        AbstractLog qual$4 = (AbstractLog)log$13.elem;
        Option x$25 = qual$4.roll$default$1();
        return qual$4.roll(x$25);
    }
}

