/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.NoSuchFileException;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptIndexException;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogTestUtils$;
import kafka.log.OffsetIndex;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004K\u0001\u0001\u0006Ia\u0010\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019A\u0006\u0001)A\u0005\u001b\"I\u0011\f\u0001a\u0001\u0002\u0004%\tA\u0017\u0005\nG\u0002\u0001\r\u00111A\u0005\u0002\u0011D\u0011B\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B.\t\u000b-\u0004A\u0011\u00017\t\u0011}\u0004\u0011\u0013!C\u0001\u0003\u0003A\u0011\"a\u0006\u0001#\u0003%\t!!\u0007\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA4\u0001\u0011\u0005\u0011q\n\u0005\b\u0003c\u0002A\u0011AA(\u0011\u001d\tY\b\u0001C\u0001\u0003\u001fBq!a \u0001\t\u0003\ty\u0005C\u0004\u0002\u0004\u0002!\t!a\u0014\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002P!9\u00111\u0012\u0001\u0005\u0002\u0005=\u0003bBAH\u0001\u0011\u0005\u0011q\n\u0005\b\u0003'\u0003A\u0011AA(\u0011\u001d\t9\n\u0001C\u0001\u0003\u001fBq!a'\u0001\t\u0003\ty\u0005C\u0004\u0002 \u0002!\t!a\u0014\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002P!9\u0011q\u0015\u0001\u0005\u0002\u0005=\u0003bBAV\u0001\u0011\u0005\u0011q\n\u0005\b\u0003_\u0003A\u0011BAY\u0011%\tI\u000eAI\u0001\n\u0013\t\t\u0001C\u0005\u0002\\\u0002\t\n\u0011\"\u0003\u0002\u0002!I\u0011Q\u001c\u0001\u0012\u0002\u0013%\u0011q\u001c\u0005\b\u0003G\u0004A\u0011AA(\u0011\u001d\t9\u000f\u0001C\u0001\u0003\u001fBaa\u001b\u0001\u0005\n\u0005-\bb\u0002B\u0002\u0001\u0011\u0005\u0011q\n\u0005\b\u0005\u000f\u0001A\u0011AA(\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003\u001fBqAa\u0004\u0001\t\u0003\ty\u0005C\u0004\u0003\u0014\u0001!\t!a\u0014\t\u000f\t]\u0001\u0001\"\u0001\u0002P!9!1\u0004\u0001\u0005\u0002\u0005=\u0003b\u0002B\u0010\u0001\u0011\u0005\u0011q\n\u0002\u000f\u0019><7+Z4nK:$H+Z:u\u0015\tqs&A\u0002m_\u001eT\u0011\u0001M\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0002\"\u0001\u0010\u0001\u000e\u00035\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001@!\t\u0001\u0005*D\u0001B\u0015\t\u00115)\u0001\u0004d_6lwN\u001c\u0006\u0003a\u0011S!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO&\u0011\u0011*\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001C:fO6,g\u000e^:\u0016\u00035\u00032AT*V\u001b\u0005y%B\u0001)R\u0003\u001diW\u000f^1cY\u0016T!AU\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\nY\u0011I\u001d:bs\n+hMZ3s!\tad+\u0003\u0002X[\tQAj\\4TK\u001elWM\u001c;\u0002\u0013M,w-\\3oiN\u0004\u0013A\u00027pO\u0012K'/F\u0001\\!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0002j_*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012^\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002fQB\u0011AGZ\u0005\u0003OV\u0012A!\u00168ji\"9\u0011nBA\u0001\u0002\u0004Y\u0016a\u0001=%c\u00059An\\4ESJ\u0004\u0013!D2sK\u0006$XmU3h[\u0016tG\u000f\u0006\u0003V[J<\b\"\u00028\n\u0001\u0004y\u0017AB8gMN,G\u000f\u0005\u00025a&\u0011\u0011/\u000e\u0002\u0005\u0019>tw\rC\u0004t\u0013A\u0005\t\u0019\u0001;\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\t\u0003iUL!A^\u001b\u0003\u0007%sG\u000fC\u0004y\u0013A\u0005\t\u0019A=\u0002\tQLW.\u001a\t\u0003uvl\u0011a\u001f\u0006\u0003y\u0006\u000bQ!\u001e;jYNL!A`>\u0003\tQKW.Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uII*\"!a\u0001+\u0007Q\f)a\u000b\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!C;oG\",7m[3e\u0015\r\t\t\"N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000b\u0003\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001c)\u001a\u00110!\u0002\u0002\u000fI,7m\u001c:egR1\u0011\u0011EA\u0017\u0003_\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\t\u0015A\u0002:fG>\u0014H-\u0003\u0003\u0002,\u0005\u0015\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0003o\u0019\u0001\u0007q\u000eC\u0004\u0002\u001e1\u0001\r!!\r\u0011\u000bQ\n\u0019$a\u000e\n\u0007\u0005URG\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!!\u000f\u0002H9!\u00111HA\"!\r\ti$N\u0007\u0003\u0003\u007fQ1!!\u00112\u0003\u0019a$o\\8u}%\u0019\u0011QI\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI%a\u0013\u0003\rM#(/\u001b8h\u0015\r\t)%N\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002K\"\u001aQ\"a\u0015\u0011\t\u0005U\u00131M\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005\u0019\u0011\r]5\u000b\t\u0005u\u0013qL\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tGR\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003K\n9F\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u001d\u0005-\u0004\u0003BA+\u0003[JA!a\u001c\u0002X\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0017i\u0016\u001cHOU3bI>sW)\u001c9usN+w-\\3oi\"\u001aq\"!\u001e\u0011\t\u0005U\u0013qO\u0005\u0005\u0003s\n9F\u0001\u0003UKN$\u0018!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRD3\u0001EA;\u0003E!Xm\u001d;SK\u0006$\u0017I\u001a;fe2\u000b7\u000f\u001e\u0015\u0004#\u0005U\u0014a\u0004;fgR\u0014V-\u00193Ge>lw)\u00199)\u0007I\t)(\u0001\u0007uKN$HK];oG\u0006$X\rK\u0002\u0014\u0003k\n\u0001\u0004^3tiR\u0013XO\\2bi\u0016,U\u000e\u001d;z'\u0016<W.\u001a8uQ\r!\u0012QO\u00017i\u0016\u001cHOU3m_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e]!oI:+\u0007\u0010^(gMN,G/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0004+\u0005U\u0014\u0001\u0005;fgR$&/\u001e8dCR,g)\u001e7mQ\r1\u0012QO\u0001\u001ai\u0016\u001cHOR5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000fK\u0002\u0018\u0003k\n\u0011\u0004^3ti:+\u0007\u0010^(gMN,GoQ1mGVd\u0017\r^5p]\"\u001a\u0001$!\u001e\u0002-Q,7\u000f^\"iC:<WMR5mKN+hMZ5yKND3!GA;\u0003u!Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f^%oI\u0016D\bf\u0001\u000e\u0002v\u0005YB/Z:u%\u0016\u001cwN^3s)J\fgn]1di&|g.\u00138eKbD3aGA;\u0003y!Xm\u001d;SK\u000e|g/\u001a:z%\u0016\u0014W/\u001b7eg\u0016\u0003xn\u00195DC\u000eDW\rK\u0002\u001d\u0003k\nQ\"\u001a8e)bt'+Z2pe\u0012\u001cH\u0003EA\u0011\u0003g\u000bi,!1\u0002L\u00065\u0017\u0011[Ak\u0011\u001d\t),\ba\u0001\u0003o\u000b\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\t\u0019#!/\n\t\u0005m\u0016Q\u0005\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007BBA`;\u0001\u0007q.\u0001\u0006qe>$WoY3s\u0013\u0012Dq!a1\u001e\u0001\u0004\t)-A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004i\u0005\u001d\u0017bAAek\t)1\u000b[8si\")a.\ba\u0001_\"A\u0011qZ\u000f\u0011\u0002\u0003\u0007A/\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\t\u0003'l\u0002\u0013!a\u0001i\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\t\u0003/l\u0002\u0013!a\u0001_\u0006IA/[7fgR\fW\u000e]\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIU\nq#\u001a8e)bt'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TCAAqU\ry\u0017QA\u0001\"i\u0016\u001cHOU3d_Z,'/\u001f$jq\u0016\u001c8i\u001c:skB$H+[7f\u0013:$W\r\u001f\u0015\u0004C\u0005U\u0014A\b;fgR\u0014VmY8wKJLx+\u001b;i\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4fQ\r\u0011\u0013Q\u000f\u000b\n+\u00065\u0018\u0011_A~\u0003\u007fDa!a<$\u0001\u0004y\u0017A\u00032bg\u0016|eMZ:fi\"9\u00111_\u0012A\u0002\u0005U\u0018!\u00054jY\u0016\fEN]3bIf,\u00050[:ugB\u0019A'a>\n\u0007\u0005eXGA\u0004C_>dW-\u00198\t\r\u0005u8\u00051\u0001u\u00031Ig.\u001b;GS2,7+\u001b>f\u0011\u001d\u0011\ta\ta\u0001\u0003k\f1\u0002\u001d:fC2dwnY1uK\u00069C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4fQ\r!\u0013QO\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:LGOR5mKNK'0Z\"mK\u0006\u00148\u000b[;uI><h\u000eK\u0002&\u0003k\naf\u001d5pk2$GK];oG\u0006$X-\u0012<f]&3wJ\u001a4tKR\u0004v.\u001b8ugR{\u0017iR1q\u0013:$\u0006.\u001a'pO\"\u001aa%!\u001e\u0002%Q,7\u000f^!qa\u0016tGM\u0012:p[\u001aKG.\u001a\u0015\u0004O\u0005U\u0014A\u0007;fgRd\u0015m\u001d;TK\u001elWM\u001c;PM\u001a\u001cX\r^\"bG\",\u0007f\u0001\u0015\u0002v\u0005iC/Z:u'\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000e\u00165s_^\u001cH)\u001e:j]\u001el\u0015n]:j]\u001e|eMZ:fi&sG-\u001a=)\u0007%\n)(A\u0010uKN$8+\u00198jif\u001c\u0005.Z2l%\u0016\u001c\u0018N_3t)&lW-\u00138eKbD3AKA;\u0003\u0011\"Xm\u001d;TC:LG/_\"iK\u000e\\GK]1og\u0006\u001cG/[8o\u0013:$W\r_\"iK\u000e\\\u0007fA\u0016\u0002v\u0001")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertNull((Object)seg.read(40L, 300, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = LogTestUtils$.MODULE$.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = LogTestUtils$.MODULE$.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * LogTestUtils$.MODULE$.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, LogTestUtils$.MODULE$.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, LogTestUtils$.MODULE$.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()), (String)"Segment should be empty.");
        seg.append(41L, -1L, -1L, LogTestUtils$.MODULE$.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = LogTestUtils$.MODULE$.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, LogTestUtils$.MODULE$.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(420L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(421L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(430L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)44L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(431L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assertions.assertEquals((long)41L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(401L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)40L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(399L, seg.findOffsetByTimestamp$default$2()).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assertions.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assertions.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, LogTestUtils$.MODULE$.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long x$1 = i;
            int x$2 = 1;
            boolean x$3 = true;
            long x$4 = seg.read$default$3();
            java.lang.Iterable records = seg.read(x$1, x$2, x$4, x$3).records().records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        ArrayDeque<BatchMetadata> queue = new ArrayDeque<BatchMetadata>();
        queue.add(new BatchMetadata(10, 10L, 5, -1L));
        new BatchMetadata(10, 10L, 5, -1L);
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, queue, producerEpoch, 0, -1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toVector());
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }

            public File file() {
                return this.file;
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }
            {
                this.epochs = Nil$.MODULE$;
                this.file = TestUtils$.MODULE$.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((long)106L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((long)108L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((long)110L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4()), (Option)new Some((Object)cache));
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)})), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, LogTestUtils$.MODULE$.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10), seg.findOffsetByTimestamp$default$2()).get()).offset());
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10 + 1), seg.findOffsetByTimestamp$default$2()).get()).offset());
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, LogTestUtils$.MODULE$.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4()), seg.recover$default$2());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        long x$2 = 40L;
        Time x$4 = Time.SYSTEM;
        int x$5 = 0x20000000;
        boolean x$6 = true;
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, x$2, logConfig, x$4, x$7, x$5, x$6, x$8);
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    @Test
    public void testLastSegmentOffsetCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        seg.append(2L, -1L, -1L, LogTestUtils$.MODULE$.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Field field = LogSegment.class.getDeclaredField("lastSegmentOffset");
        field.setAccessible(true);
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.truncateTo(3L);
        Assertions.assertEquals((long)-1L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.append(5L, -1L, -1L, LogTestUtils$.MODULE$.records(3L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)6L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)5L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
    }

    @Test
    public void testSanityCheckThrowsDuringMissingOffsetIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertTrue((seg.size() == 0 ? 1 : 0) != 0);
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(new boolean[]{true, false})).foreach((Function1 & Serializable & scala.Serializable)timeIndexFileNewlyCreated -> LogSegmentTest.$anonfun$testSanityCheckThrowsDuringMissingOffsetIndex$1(seg, BoxesRunTime.unboxToBoolean((Object)timeIndexFileNewlyCreated)));
        seg.append(0L, -1L, -1L, LogTestUtils$.MODULE$.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        Assertions.assertTrue((seg.size() > 0 ? 1 : 0) != 0);
        OffsetIndex offsetIndex = (OffsetIndex)seg.lazyOffsetIndex().get();
        Assertions.assertTrue((boolean)offsetIndex.file().exists());
        offsetIndex.deleteIfExists();
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(new boolean[]{true, false})).foreach((Function1 & Serializable & scala.Serializable)timeIndexFileNewlyCreated -> LogSegmentTest.$anonfun$testSanityCheckThrowsDuringMissingOffsetIndex$3(seg, BoxesRunTime.unboxToBoolean((Object)timeIndexFileNewlyCreated)));
    }

    @Test
    public void testSanityCheckResizesTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertFalse((boolean)Log$.MODULE$.timeIndexFile(this.logDir(), 0L, Log$.MODULE$.timeIndexFile$default$3()).exists());
        seg.lazyOffsetIndex().get();
        seg.sanityCheck(true, false);
        Assertions.assertTrue((boolean)Log$.MODULE$.timeIndexFile(this.logDir(), 0L, Log$.MODULE$.timeIndexFile$default$3()).exists());
        Assertions.assertTrue((seg.timeIndex().sizeInBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSanityCheckTransactionIndexCheck() {
        LogSegment seg = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        seg.append(100L, -1L, -1L, LogTestUtils$.MODULE$.records(100L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        Assertions.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
        Assertions.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.sanityCheck(false, false);
        seg.txnIndex().append(new AbortedTxn(0L, 0L, 10L, 11L));
        Assertions.assertThrows(CorruptIndexException.class, () -> seg.sanityCheck(false, false));
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }

    private static final long reflectLastSegmentOffset$1(Field field$1, LogSegment seg$7) {
        return ((AtomicLong)field$1.get(seg$7)).get();
    }

    public static final /* synthetic */ NoSuchFileException $anonfun$testSanityCheckThrowsDuringMissingOffsetIndex$1(LogSegment seg$8, boolean timeIndexFileNewlyCreated) {
        return (NoSuchFileException)Assertions.assertThrows(NoSuchFileException.class, () -> seg$8.sanityCheck(timeIndexFileNewlyCreated, false));
    }

    public static final /* synthetic */ NoSuchFileException $anonfun$testSanityCheckThrowsDuringMissingOffsetIndex$3(LogSegment seg$8, boolean timeIndexFileNewlyCreated) {
        return (NoSuchFileException)Assertions.assertThrows(NoSuchFileException.class, () -> seg$8.sanityCheck(timeIndexFileNewlyCreated, true));
    }
}

