/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.durability.audit.SegmentDeletionStats;
import kafka.log.AppendOrigin;
import kafka.log.HotsetRetention$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.RetentionType;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergedLogTest$ {
    public static MergedLogTest$ MODULE$;

    static {
        new MergedLogTest$();
    }

    public MemoryRecords createRecords(int segmentIdx, int messageIdx, long timestamp) {
        String segmentStr = new StringOps(Predef$.MODULE$.augmentString("%06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segmentIdx)}));
        String messageStr = new StringOps(Predef$.MODULE$.augmentString("%06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageIdx)}));
        byte[] x$1 = new StringBuilder(4).append("test").append(segmentStr).append(messageStr).toString().getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, timestamp, x$5);
    }

    public int createRecords$default$1() {
        return 0;
    }

    public int createRecords$default$2() {
        return 0;
    }

    public long createRecords$default$3() {
        return -1L;
    }

    public void initializeTierMetadata(MergedLog log, TopicIdPartition topicIdPartition) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        log.assignTopicId(topicIdPartition.kafkaTopicId(), log.assignTopicId$default$2());
        tierPartitionState.onCatchUpComplete();
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
    }

    public void createTieredSegments(MergedLog log, LogSegment segment, TopicIdPartition topicIdPartition, int epoch) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, epoch, UUID.randomUUID(), segment.baseOffset(), segment.offsetOfMaxTimestampSoFar(), segment.largestTimestamp(), segment.lastModified(), segment.size(), false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        tierPartitionState.flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public int createTieredSegments$default$4() {
        return 0;
    }

    public MergedLog createLogWithOverlap(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk) {
        long x$1 = 1L;
        boolean x$2 = true;
        int x$3 = Predef$.MODULE$.Integer2int(logConfig.segmentSize());
        long x$4 = Predef$.MODULE$.Long2long(logConfig.segmentMs());
        long x$5 = 1L;
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$12 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, x$6, x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$2, x$5, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createMergedLog(tierLogComponents, dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs));
        ObjectRef tierPartitionState = ObjectRef.create((Object)((MergedLog)log.elem).tierPartitionState());
        ((TierPartitionState)tierPartitionState.elem).setTopicId(topicIdPartition.topicId());
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        ((TierPartitionState)tierPartitionState.elem).onCatchUpComplete();
        int epoch = 0;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$25.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$25.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$25.elem;
                MemoryRecords x$17 = MODULE$.createRecords(segment, message, timestamp);
                int x$18 = 0;
                AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
                ApiVersion x$20 = qual$1.appendAsLeader$default$4();
                RequestLocal x$21 = qual$1.appendAsLeader$default$5();
                qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        ((TierPartitionState)tierPartitionState.elem).append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Iterable segmentsToTier = (Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap);
        segmentsToTier.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            MergedLogTest$.$anonfun$createLogWithOverlap$2(tierPartitionState, topicIdPartition, epoch, segment);
            return BoxedUnit.UNIT;
        });
        Iterable localSegmentsToDelete = (Iterable)segmentsToTier.take(numTieredSegments);
        if (localSegmentsToDelete.nonEmpty()) {
            Log qual$2 = ((MergedLog)log.elem).localLog();
            Some x$22 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
            Function0 & Serializable & scala.Serializable x$23 = (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$;
            int x$24 = Integer.MAX_VALUE;
            HotsetRetention$ x$25 = HotsetRetention$.MODULE$;
            Function1 x$26 = qual$2.deleteOldSegments$default$5();
            SegmentDeletionStats x$27 = qual$2.deleteOldSegments$default$6();
            qual$2.deleteOldSegments((Option)x$22, (Function0)x$23, x$24, (RetentionType)x$25, x$26, x$27);
        }
        ((MergedLog)log.elem).close();
        log.elem = this.createMergedLog(tierLogComponents, dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        tierPartitionState.elem = ((MergedLog)log.elem).tierPartitionState();
        ((MergedLog)log.elem).isTieredMetadataRecovering_$eq(false);
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Assertions.assertEquals((int)(numTieredSegments + numOverlap), (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(((TierPartitionState)tierPartitionState.elem).segments()).asScala()).size());
        Tuple2 tuple2 = ((MergedLog)log.elem).uniqueLogSegments();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Iterator tierLogSegments = (Iterator)tuple2._1();
        Iterable localLogSegments = (Iterable)tuple2._2();
        Assertions.assertEquals((int)numTieredSegments, (int)tierLogSegments.size());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)localLogSegments.size());
        return (MergedLog)log.elem;
    }

    public long createLogWithOverlap$default$11() {
        return 0L;
    }

    public long createLogWithOverlap$default$12() {
        return 0L;
    }

    public int createLogWithOverlap$default$13() {
        return 3600000;
    }

    public int createLogWithOverlap$default$14() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public Function0<Object> createLogWithOverlap$default$15() {
        return (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L;
    }

    public Tuple2<MergedLog, Iterable<LogSegment>> createLogWithMissingTierState(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk) {
        long x$1 = 1L;
        boolean x$2 = true;
        int x$3 = Predef$.MODULE$.Integer2int(logConfig.segmentSize());
        long x$4 = Predef$.MODULE$.Long2long(logConfig.segmentMs());
        long x$5 = 1L;
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$12 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig tempConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$3, x$6, x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$2, x$5, x$14, x$15, x$16);
        ObjectRef log = ObjectRef.create((Object)this.createMergedLog(tierLogComponents, dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)segment -> {
            int currentNumSegments = ((MergedLog)log$26.elem).localLogSegments().size();
            long timestamp = segmentMaxTimestampCbk.apply$mcJ$sp();
            int message = 0;
            while (((MergedLog)log$26.elem).localLogSegments().size() == currentNumSegments) {
                MergedLog qual$1 = (MergedLog)log$26.elem;
                MemoryRecords x$17 = MODULE$.createRecords(segment, message, timestamp);
                int x$18 = 0;
                AppendOrigin x$19 = qual$1.appendAsLeader$default$3();
                ApiVersion x$20 = qual$1.appendAsLeader$default$4();
                RequestLocal x$21 = qual$1.appendAsLeader$default$5();
                qual$1.appendAsLeader(x$17, x$18, x$19, x$20, x$21);
                ++message;
            }
        });
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numTieredSegments + numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        Iterable localSegmentsToDelete = (Iterable)((Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap)).take(numTieredSegments);
        Iterable retTierSegments = (Iterable)((MergedLog)log.elem).localLogSegments().take(numTieredSegments + numOverlap);
        Log qual$2 = ((MergedLog)log.elem).localLog();
        Some x$22 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
        Function0 & Serializable & scala.Serializable x$23 = (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$;
        int x$24 = Integer.MAX_VALUE;
        HotsetRetention$ x$25 = HotsetRetention$.MODULE$;
        Function1 x$26 = qual$2.deleteOldSegments$default$5();
        SegmentDeletionStats x$27 = qual$2.deleteOldSegments$default$6();
        qual$2.deleteOldSegments((Option)x$22, (Function0)x$23, x$24, (RetentionType)x$25, x$26, x$27);
        ((MergedLog)log.elem).close();
        log.elem = this.createMergedLog(tierLogComponents, dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs);
        ((MergedLog)log.elem).updateHighWatermark(((MergedLog)log.elem).logEndOffset());
        Assertions.assertEquals((int)(numLocalSegments + numOverlap), (int)((MergedLog)log.elem).localLogSegments().size());
        return new Tuple2((Object)((MergedLog)log.elem), (Object)retTierSegments);
    }

    public long createLogWithMissingTierState$default$11() {
        return 0L;
    }

    public long createLogWithMissingTierState$default$12() {
        return 0L;
    }

    public int createLogWithMissingTierState$default$13() {
        return 3600000;
    }

    public int createLogWithMissingTierState$default$14() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public Function0<Object> createLogWithMissingTierState$default$15() {
        return (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L;
    }

    public MergedLog createMergedLog(TierLogComponents tierLogComponents, File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        Metrics x$7 = new Metrics();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        boolean x$13 = true;
        boolean x$14 = true;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        LogOffsetsListener x$17 = MergedLog$.MODULE$.apply$default$16();
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, x$7, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, x$11, tierLogComponents, x$14, (Option)x$15, x$13, x$17, (Option)x$16);
    }

    public long createMergedLog$default$7() {
        return 0L;
    }

    public long createMergedLog$default$8() {
        return 0L;
    }

    public int createMergedLog$default$9() {
        return 3600000;
    }

    public int createMergedLog$default$10() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public void kafka$log$MergedLogTest$$deleteOldLogSegments(MergedLog log, int expectedNumDeleted) {
        int maxNumSegmentsToDeletePerRun = 1;
        IntRef numDeleted = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), expectedNumDeleted).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            numDeleted$1.elem += log.deleteOldSegments(maxNumSegmentsToDeletePerRun);
            Assertions.assertEquals((int)i, (int)numDeleted$1.elem);
        });
        Assertions.assertEquals((int)expectedNumDeleted, (int)numDeleted.elem);
        Assertions.assertEquals((int)0, (int)log.deleteOldSegments());
    }

    public static final /* synthetic */ void $anonfun$createLogWithOverlap$2(ObjectRef tierPartitionState$17, TopicIdPartition topicIdPartition$1, int epoch$5, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata((TierPartitionState)tierPartitionState$17.elem, topicIdPartition$1, epoch$5, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.lastModified(), segment.size(), false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        ((TierPartitionState)tierPartitionState$17.elem).flush();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    private MergedLogTest$() {
        MODULE$ = this;
    }
}

