/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B%K\u0001=CQA\u0016\u0001\u0005\u0002]CqA\u0017\u0001A\u0002\u0013\u00051\fC\u0004e\u0001\u0001\u0007I\u0011A3\t\r-\u0004\u0001\u0015)\u0003]\u0011\u001da\u0007\u00011A\u0005\u00025Dq!\u001d\u0001A\u0002\u0013\u0005!\u000f\u0003\u0004u\u0001\u0001\u0006KA\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0011\u001d\t)\u0001\u0001Q\u0001\n]D\u0011\"a\u0002\u0001\u0005\u0004%\t!!\u0003\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0017A\u0011\"a\u0005\u0001\u0005\u0004%\t!!\u0006\t\u0011\u0005u\u0001\u0001)A\u0005\u0003/A\u0011\"a\b\u0001\u0005\u0004%\t!!\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003GAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002L\u0001!\t!a\r\t\u000f\u0005U\u0003\u0001\"\u0001\u00024!9\u0011q\f\u0001\u0005\u0002\u0005M\u0002bBA2\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003O\u0002A\u0011AA\u001a\u0011\u001d\tY\u0007\u0001C\u0001\u0003gAq!a\u001c\u0001\t\u0003\t\u0019\u0004C\u0004\u0002t\u0001!\t!a\r\t\u000f\u0005]\u0004\u0001\"\u0001\u00024!9\u00111\u0010\u0001\u0005\u0002\u0005M\u0002bBA@\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u0007\u0003A\u0011AA\u001a\u0011\u001d\t9\t\u0001C\u0001\u0003gAq!a#\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\u0010\u0002!\t!a\r\t\u000f\u0005M\u0005\u0001\"\u0001\u00024!9\u0011q\u0013\u0001\u0005\u0002\u0005M\u0002bBAN\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003?\u0003A\u0011AA\u001a\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003gAq!a*\u0001\t\u0003\t\u0019\u0004C\u0004\u0002,\u0002!\t!a\r\t\u000f\u0005=\u0006\u0001\"\u0001\u00024!9\u00111\u0017\u0001\u0005\u0002\u0005M\u0002bBA\\\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003w\u0003A\u0011AA\u001a\u0011\u001d\ty\f\u0001C\u0001\u0003gAq!a1\u0001\t\u0003\t\u0019\u0004C\u0004\u0002H\u0002!\t!a\r\t\u000f\u0005-\u0007\u0001\"\u0001\u00024!9\u0011q\u001a\u0001\u0005\u0002\u0005M\u0002bBAj\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003/\u0004A\u0011AA\u001a\u0011\u001d\tY\u000e\u0001C\u0001\u0003gAq!a8\u0001\t\u0003\t\u0019\u0004C\u0004\u0002d\u0002!\t!a\r\t\u000f\u0005\u001d\b\u0001\"\u0001\u00024!9\u00111\u001e\u0001\u0005\u0002\u0005M\u0002bBAx\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003g\u0004A\u0011AA\u001a\u0011\u001d\t9\u0010\u0001C\u0001\u0003gAq!a?\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\u0000\u0002!\t!a\r\t\u000f\t\u0005\u0001\u0001\"\u0001\u00024!9!Q\u0001\u0001\u0005\u0002\u0005M\u0002b\u0002B\u0005\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[A\u0011Ba\u001a\u0001#\u0003%IA!\u001b\t\u0013\t}\u0004!%A\u0005\n\t\u0005\u0005b\u0002BC\u0001\u0011%!q\u0011\u0005\n\u0005W\u0003\u0011\u0013!C\u0005\u0005\u0003C\u0011B!,\u0001#\u0003%IAa,\t\u0013\tM\u0006!%A\u0005\n\tU\u0006b\u0002BC\u0001\u0011%!\u0011\u0018\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0005a\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u00172\u000b1\u0001\\8h\u0015\u0005i\u0015!B6bM.\f7\u0001A\n\u0003\u0001A\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001Y!\tI\u0006!D\u0001K\u0003\u0019awn\u001a#jeV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006\u0011\u0011n\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gL\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011a-\u001b\t\u0003#\u001eL!\u0001\u001b*\u0003\tUs\u0017\u000e\u001e\u0005\bU\u000e\t\t\u00111\u0001]\u0003\rAH%M\u0001\bY><G)\u001b:!\u00031\u0019H/\u0019;f\u001b\u0006t\u0017mZ3s+\u0005q\u0007CA-p\u0013\t\u0001(J\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\u0001\u0011gR\fG/Z'b]\u0006<WM]0%KF$\"AZ:\t\u000f)4\u0011\u0011!a\u0001]\u0006i1\u000f^1uK6\u000bg.Y4fe\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003]\u00042\u0001_A\u0001\u001b\u0005I(B\u0001>|\u0003\u0019\u0019w.\\7p]*\u0011Q\n \u0006\u0003{z\fa!\u00199bG\",'\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004e\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\n!\u0002\u001d:pIV\u001cWM]%e+\t\tY\u0001E\u0002R\u0003\u001bI1!a\u0004S\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u0013[\u0006D\b+\u001b3FqBL'/\u0019;j_:l5/\u0006\u0002\u0002\u0018A\u0019\u0011+!\u0007\n\u0007\u0005m!KA\u0002J]R\f1#\\1y!&$W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0002\nA\u0001^5nKV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F=\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0012q\u0005\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005)1/\u001a;VaR\ta\rK\u0002\u0011\u0003o\u0001B!!\u000f\u0002H5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0002ba&TA!!\u0011\u0002D\u00059!.\u001e9ji\u0016\u0014(bAA#}\u0006)!.\u001e8ji&!\u0011\u0011JA\u001e\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011#a\u0014\u0011\t\u0005e\u0012\u0011K\u0005\u0005\u0003'\nYDA\u0005BMR,'/R1dQ\u0006\u0011B/Z:u\u0005\u0006\u001c\u0018nY%e\u001b\u0006\u0004\b/\u001b8hQ\r\u0011\u0012\u0011\f\t\u0005\u0003s\tY&\u0003\u0003\u0002^\u0005m\"\u0001\u0002+fgR\fa\u0005^3ti\u0006\u0003\b/\u001a8e)btW*\u0019:lKJ<\u0016\u000e\u001e5O_B\u0013x\u000eZ;dKJ\u001cF/\u0019;fQ\r\u0019\u0012\u0011L\u0001\u001fi\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3Xe\u0006\u0004\u0018I]8v]\u0012D3\u0001FA-\u00035\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^KG\u000f[,sCB\f%o\\;oI\n\u000bGo\u00195SK\u000e|'\u000f\u001a\u0015\u0004+\u0005e\u0013!\n;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cW-\u00138wC2LGm\u0016:ba\u0006\u0013x.\u001e8eQ\r1\u0012\u0011L\u0001+i\u0016\u001cHOT8WC2LG-\u0019;j_:|eNR5sgR,e\u000e\u001e:z/\",g\u000eT8bI&tw\rT8hQ\r9\u0012\u0011L\u0001$i\u0016\u001cHoQ8oiJ|GNU3d_J$')^7qgB\u0013x\u000eZ;dKJ,\u0005o\\2iQ\rA\u0012\u0011L\u0001!i\u0016\u001cH\u000f\u0016=o\r&\u00148\u000f^(gMN,G/T3uC\u0012\fG/Y\"bG\",G\rK\u0002\u001a\u00033\n\u0011\u0004^3tiN[\u0017\u000e]#naRLHK]1og\u0006\u001cG/[8og\"\u001a!$!\u0017\u0002AQ,7\u000f\u001e'bgR\u001cF/\u00192mK>3gm]3u\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0015\u00047\u0005e\u0013A\b;fgR\u0004&/\u001a9be\u0016,\u0006\u000fZ1uK\u0012{Wm\u001d(pi6+H/\u0019;fQ\ra\u0012\u0011L\u0001\u001fkB$\u0017\r^3Qe>$WoY3s)J\fgn]1di&|gn\u0015;bi\u0016D3!HA-\u00031\"Xm\u001d;PkR|emU3rk\u0016t7-Z!gi\u0016\u00148i\u001c8ue>d'+Z2pe\u0012,\u0005o\\2i\u0005Vl\u0007\u000fK\u0002\u001f\u00033\n\u0001\u0007^3ti:{g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\t\u001d9f]\u0012<\u0016\u000e\u001e5P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0007fA\u0010\u0002Z\u0005yC/Z:u)J,hnY1uK\u0006sGMU3m_\u0006$'+Z7pm\u0016\u001cx*\u001e;PMJ\u000bgnZ3T]\u0006\u00048\u000f[8ug\"\u001a\u0001%!\u0017\u0002!Q,7\u000f\u001e+bW\u0016\u001cf.\u00199tQ>$\bfA\u0011\u0002Z\u0005aC/Z:u%\u0016\u001cwN^3s\rJ|Wn\u00158baNDw\u000e^+oM&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004E\u0005e\u0013A\u000b;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\r&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004G\u0005e\u0013a\n;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:D3\u0001JA-\u0003!\"Xm\u001d;Qe>$WoY3s'R\fG/Z!gi\u0016\u0014h)\u001a8dS:<\u0017IY8si6\u000b'o[3sQ\r)\u0013\u0011L\u0001\u001ei\u0016\u001cHOU3n_Z,W\t\u001f9je\u0016$\u0007+\u001b3t\u001f:\u0014V\r\\8bI\"\u001aa%!\u0017\u0002[Q,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i_V$\bK]8ek\u000e,'o\u0015;bi\u0016|eNU3qY&\u001c\u0017\rK\u0002(\u00033\n\u0011\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRD7+Z9vK:\u001cWmR1qg>s'+\u001a9mS\u000e\f\u0007f\u0001\u0015\u0002Z\u0005IB/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\n+gm\u001c:fQ\rI\u0013\u0011L\u0001\u001ci\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;)\u0007)\nI&\u0001\u0014uKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3aKA-\u00039\"Xm\u001d;M_\u0006$gI]8n':\f\u0007o\u001d5piJ+G/Y5og:{g.\u0012=qSJ,G\r\u0015:pIV\u001cWM]:)\u00071\nI&A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u0002.\u00033\n\u0001\u0004^3tiBKG-\u0012=qSJ\fG/[8o)&lWm\\;uQ\rq\u0013\u0011L\u0001\u0018i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKRD3aLA-\u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u0007A\nI&A\u0017uKN$8+Z9vK:\u001cWMT8u-\u0006d\u0017\u000eZ1uK\u00124uN]$s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000eD3!MA-\u0003q!Xm\u001d;PY\u0012,\u0005o\\2i\r>\u00148i\u001c8ue>d'+Z2pe\u0012D3AMA-\u0003Y!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dS:<\u0007fA\u001a\u0002Z\u0005\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\r!\u0014\u0011L\u0001\u001ei\u0016\u001cH\u000fT8bI\u001a\u0013x.\\#naRL8K\\1qg\"|GOR5mK\"\u001aQ'!\u0017\u0002CQ,7\u000f\u001e'pC\u00124%o\\7UeVt7-\u0019;fINs\u0017\r]:i_R4\u0015\u000e\\3)\u0007Y\nI&A\u0010uKN$Hj\\1e\rJ|WnQ8seV\u0004Ho\u00158baNDw\u000e\u001e$jY\u0016D3aNA-\u0003m!Xm\u001d;BaB,g\u000eZ#naRL8i\u001c8ue>d')\u0019;dQ\"\u001a\u0001(!\u0017\u00029Q,7\u000f\u001e*fY>\fGM\u0012:p[RKWM]3e':\f\u0007o\u001d5pi\"\u001a\u0011(!\u0017\u00023Q,7\u000f^*oCB\u001c\bn\u001c;GS2,gi\u001c:PM\u001a\u001cX\r\u001e\u0015\u0004u\u0005e\u0013!\r;fgR\u0014V-\\8wKN#(/Y=T]\u0006\u00048\u000f[8ug.+W\r]\"mK\u0006t7\u000b[;uI><hn\u00158baNDw\u000e^\u0001\u001ci\u0016\u001cHOU3n_Z,\u0017\t\u001c7TiJ\f\u0017p\u00158baNDw\u000e^:)\u0007q\nI&\u0001\u0013uKN$(+Z7pm\u0016\fe\u000eZ'be.\u001cf.\u00199tQ>$hi\u001c:EK2,G/[8oQ\ri\u0014\u0011L\u00013i\u0016\u001cHOU3n_Z,\u0017I\u001c3NCJ\\7K\\1qg\"|GOR8s\t\u0016dW\r^5p]\u0006c'/Z1es\u0012+G.\u001a;fI\"\u001aa(!\u0017\u00027Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u)\r1'\u0011\u0003\u0005\b\u0005'y\u0004\u0019\u0001B\u000b\u0003=i\u0017m[3GS2,7i\u001c:skB$\bCB)\u0003\u0018\tma-C\u0002\u0003\u001aI\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\tu!qE\u0007\u0003\u0005?QAA!\t\u0003$\u0005A1\r[1o]\u0016d7OC\u0002\u0003&\u0001\f1A\\5p\u0013\u0011\u0011ICa\b\u0003\u0017\u0019KG.Z\"iC:tW\r\\\u0001\u0013CB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\u0006\t\u00030\tm\"q\bB!\u0005\u0017\u0012YFa\u0018\u0003dA)\u0011K!\r\u00036%\u0019!1\u0007*\u0003\r=\u0003H/[8o!\rI&qG\u0005\u0004\u0005sQ%\u0001D\"p[BdW\r^3e)bt\u0007B\u0002B\u001f\u0001\u0002\u0007a.A\u0004nCB\u0004\u0018N\\4\t\u000f\u0005\u001d\u0001\t1\u0001\u0002\f!9!1\t!A\u0002\t\u0015\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002R\u0005\u000fJ1A!\u0013S\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u0011i\u0005\u0011a\u0001\u0005\u001f\n1bY8oiJ|G\u000eV=qKB!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003Ve\faA]3d_J$\u0017\u0002\u0002B-\u0005'\u0012\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\u0011i\u0006\u0011a\u0001\u0003\u0017\taa\u001c4gg\u0016$\b\"\u0003B1\u0001B\u0005\t\u0019AA\f\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0005\u0003f\u0001\u0003\n\u00111\u0001\u0002\f\u0005IA/[7fgR\fW\u000e]\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YG\u000b\u0003\u0002\u0018\t54F\u0001B8!\u0011\u0011\tHa\u001f\u000e\u0005\tM$\u0002\u0002B;\u0005o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te$+\u0001\u0006b]:|G/\u0019;j_:LAA! \u0003t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u0011\u0016\u0005\u0003\u0017\u0011i'\u0001\u0004baB,g\u000e\u001a\u000b\u0012M\n%%1\u0012BG\u0005\u001f\u0013\u0019J!&\u0003\u0018\n\u0005\u0006\"\u00027D\u0001\u0004q\u0007bBA\u0004\u0007\u0002\u0007\u00111\u0002\u0005\b\u0005\u0007\u001a\u0005\u0019\u0001B#\u0011\u001d\u0011\tj\u0011a\u0001\u0003/\t1a]3r\u0011\u001d\u0011if\u0011a\u0001\u0003\u0017A\u0011B!\u001aD!\u0003\u0005\r!a\u0003\t\u0013\te5\t%AA\u0002\tm\u0015aD5t)J\fgn]1di&|g.\u00197\u0011\u0007E\u0013i*C\u0002\u0003 J\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003$\u000e\u0003\n\u00111\u0001\u0003&\u00061qN]5hS:\u00042!\u0017BT\u0013\r\u0011IK\u0013\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIY\n\u0001#\u00199qK:$G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\tE&\u0006\u0002BN\u0005[\n\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\t]&\u0006\u0002BS\u0005[\"2B\u001aB^\u0005{\u0013yL!1\u0003L\")An\u0012a\u0001]\"9\u0011qA$A\u0002\u0005-\u0001b\u0002B/\u000f\u0002\u0007\u00111\u0002\u0005\b\u0005\u0007<\u0005\u0019\u0001Bc\u0003\u0015\u0011\u0017\r^2i!\u0011\u0011\tFa2\n\t\t%'1\u000b\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0004\u0003$\u001e\u0003\rA!*\u0002-\r,(O]3oiNs\u0017\r]:i_R|eMZ:fiN,\"A!5\u0011\r\tM'\u0011]A\u0006\u001d\u0011\u0011)N!8\u0011\u0007\t]'+\u0004\u0002\u0003Z*\u0019!1\u001c(\u0002\rq\u0012xn\u001c;?\u0013\r\u0011yNU\u0001\u0007!J,G-\u001a4\n\t\t\r(Q\u001d\u0002\u0004'\u0016$(b\u0001Bp%\u0002")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            int x$12 = 1;
            long x$13 = 1L;
            boolean x$14 = false;
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = this.append$default$8();
            this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head())).nonEmpty(), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$52, x$72, x$62, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$82 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$132 = 105L;
        boolean x$142 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$92, anotherPid, epoch, sequence, x$132, x$15, x$142, x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testReloadFromTieredSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option maybeFile = this.stateManager().snapshotFileForOffset(3L).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.file());
        Assertions.assertTrue((boolean)maybeFile.isDefined(), (String)"expected to find snapshot file at offset 3");
        File snapshotFile = (File)maybeFile.get();
        ByteBuffer buf = ByteBuffer.allocate((int)snapshotFile.length());
        try (FileChannel fc = FileChannel.open(snapshotFile.toPath(), new OpenOption[0]);){
            Utils.readFully((FileChannel)fc, (ByteBuffer)buf, (long)0L);
        }
        buf.flip();
        long originalLastDataOffset = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastDataOffset();
        int originalLastOffsetDelta = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastOffsetDelta();
        int originalLastSeq = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq();
        long originalLastTimestamp = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastTimestamp();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateFullyAndStartAt(0L);
        this.stateManager().reloadFromTieredSnapshot(0L, this.time().milliseconds(), buf, 3L);
        this.stateManager().takeSnapshot();
        Assertions.assertTrue((boolean)this.stateManager().snapshotFileForOffset(3L).isDefined(), (String)"expected a snapshot file to exist for the restored snapshot");
        Assertions.assertEquals((int)this.logDir().listFiles().length, (int)1, (String)"expected all other snapshot files to be cleared, leaving only the restored snapshot file");
        ProducerStateEntry reloadedLastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((long)originalLastDataOffset, (long)reloadedLastEntry.lastDataOffset(), (String)"expected lastDataOffset to be restored");
        Assertions.assertEquals((int)originalLastOffsetDelta, (int)reloadedLastEntry.lastOffsetDelta(), (String)"expected lastOffsetDelta to be restored");
        Assertions.assertEquals((int)originalLastSeq, (int)reloadedLastEntry.lastSeq(), (String)"expected lastSeq to be restored");
        Assertions.assertEquals((long)originalLastTimestamp, (long)reloadedLastEntry.lastTimestamp(), (String)"expected lastTimestamp to be restored");
    }

    @Test
    public void testSnapshotFileForOffset() {
        Assertions.assertTrue((boolean)Paths.get(this.logDir().getAbsolutePath(), "00000000000000000020.snapshot").toFile().createNewFile());
        TopicPartition tp = new TopicPartition("test_topic", 0);
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3(), ProducerStateManager$.MODULE$.$lessinit$greater$default$4());
        File foundFile = ((SnapshotFile)producerStateManager.snapshotFileForOffset(20L).get()).file();
        Assertions.assertEquals((Object)"00000000000000000020.snapshot", (Object)foundFile.getName());
        Assertions.assertTrue((boolean)foundFile.exists());
        Assertions.assertFalse((boolean)producerStateManager.snapshotFileForOffset(19L).isDefined());
    }

    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        TopicPartition x$1 = this.partition();
        File x$2 = this.logDir();
        MockTime x$3 = this.time();
        int x$4 = ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
        ProducerStateManager manager = new ProducerStateManager(x$1, x$2, x$4, (Time)x$3);
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(Log$.MODULE$.DeletedFileSuffix()));
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L);
        file.createNewFile();
        TopicPartition x$1 = this.partition();
        File x$2 = this.logDir();
        MockTime x$3 = this.time();
        int x$4 = ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
        ProducerStateManager manager = new ProducerStateManager(x$1, x$2, x$4, (Time)x$3);
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Files.delete(file.toPath());
        Assertions.assertTrue((boolean)manager.removeAndMarkSnapshotForDeletion(5L).isEmpty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

