/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.metrics.BrokerLoad;
import kafka.metrics.BrokerLoad$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u00181\u0001UBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019\t\u0006\u0001)A\u0005\u001d\"I!\u000b\u0001a\u0001\u0002\u0004%\ta\u0015\u0005\n/\u0002\u0001\r\u00111A\u0005\u0002aC\u0011B\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\t\u0013E\u0002\u0001\u0019!a\u0001\n\u0003y\u0006\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0001n\u0011%y\u0007\u00011A\u0001B\u0003&\u0001\rC\u0004q\u0001\t\u0007I\u0011A9\t\ri\u0004\u0001\u0015!\u0003s\u0011\u001dY\bA1A\u0005\u0002qDq!a\u0003\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001r\u0011\u001d\ty\u0001\u0001Q\u0001\nID\u0011\"!\u0005\u0001\u0005\u0004%\t!a\u0005\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003+A\u0011\"a\t\u0001\u0005\u0004%\t!!\n\t\u0011\u0005M\u0002\u0001)A\u0005\u0003OAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\tY\u000b\u0001C\u0001\u0003'Cq!a,\u0001\t\u0003\t\u0019\nC\u0004\u00024\u0002!\t!a%\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u0014\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006\"CAy\u0001E\u0005I\u0011BAz\u0011\u001d\tY\f\u0001C\u0005\u0005\u0013AqA!\u0006\u0001\t\u0003\t\u0019\nC\u0004\u0003\u001a\u0001!\t!a%\t\u000f\tu\u0001\u0001\"\u0001\u0002\u0014\"9!\u0011\u0005\u0001\u0005\u0002\u0005M\u0005b\u0002B\u0013\u0001\u0011\u0005\u00111\u0013\u0005\b\u0005S\u0001A\u0011AAJ\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003'CqA!\r\u0001\t\u0003\t\u0019\nC\u0004\u00036\u0001!\t!a%\t\u000f\te\u0002\u0001\"\u0001\u0002\u0014\"9!Q\b\u0001\u0005\u0002\u0005M\u0005b\u0002B!\u0001\u0011\u0005\u00111\u0013\u0002\u000f\u0005J|7.\u001a:M_\u0006$G+Z:u\u0015\t\t$'A\u0004nKR\u0014\u0018nY:\u000b\u0003M\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0007CA\u001fA\u001b\u0005q$BA 3\u0003\u0015)H/\u001b7t\u0013\t\teHA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005!\u0005CA#\u0001\u001b\u0005\u0001\u0014A\u00028pI\u0016LE-F\u0001I!\t9\u0014*\u0003\u0002Kq\t\u0019\u0011J\u001c;\u0002\u000f9|G-Z%eA\u0005!A/[7f+\u0005q\u0005CA\u001fP\u0013\t\u0001fH\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003)\u0011'o\\6fe2{\u0017\rZ\u000b\u0002)B\u0011Q)V\u0005\u0003-B\u0012!B\u0011:pW\u0016\u0014Hj\\1e\u00039\u0011'o\\6fe2{\u0017\rZ0%KF$\"!\u0017/\u0011\u0005]R\u0016BA.9\u0005\u0011)f.\u001b;\t\u000fu;\u0011\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\t\u0014xn[3s\u0019>\fG\rI\u000b\u0002AB\u0011\u0011M[\u0007\u0002E*\u0011\u0011g\u0019\u0006\u0003I\u0016\faaY8n[>t'BA\u001ag\u0015\t9\u0007.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0006\u0019qN]4\n\u0005-\u0014'aB'fiJL7m]\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0002Z]\"9QLCA\u0001\u0002\u0004\u0001\u0017\u0001C7fiJL7m\u001d\u0011\u00021M+G.Z2u_JlU\r\u001e:jGN<%\u000f\u001d)sK\u001aL\u00070F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014aa\u0015;sS:<\u0017!G*fY\u0016\u001cGo\u001c:NKR\u0014\u0018nY:HeB\u0004&/\u001a4jq\u0002\n\u0001c]3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA!Y;uQ*\u0019\u0011QA2\u0002\u0011M,7-\u001e:jifL1!!\u0003\u0000\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.A\ttK\u000e,(/\u001b;z!J|Go\\2pY\u0002\nq#\\;mi&$VM\\1oi2K7\u000f^3oKJt\u0015-\\3\u000215,H\u000e^5UK:\fg\u000e\u001e'jgR,g.\u001a:OC6,\u0007%\u0001\u0007eK\u001a\fW\u000f\u001c;Qe>\u00048/\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cY\fA!\u001e;jY&!\u0011qDA\r\u0005)\u0001&o\u001c9feRLWm]\u0001\u000eI\u00164\u0017-\u001e7u!J|\u0007o\u001d\u0011\u0002\u001b\u0011,g-Y;mi\u000e{gNZ5h+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCM\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u00121\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\beK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u0011\u0002\u001b5|7m[*fY\u0016\u001cGo\u001c:t)\u0011\tI$!\u0018\u0011\r\u0005m\u00121JA)\u001d\u0011\ti$a\u0012\u000f\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u00115\u0003\u0019a$o\\8u}%\t\u0011(C\u0002\u0002Ja\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0005=#\u0001\u0002'jgRT1!!\u00139!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,G\u00069a.\u001a;x_J\\\u0017\u0002BA.\u0003+\u0012\u0001bU3mK\u000e$xN\u001d\u0005\u0006cY\u0001\r\u0001Y\u0001\u0011[>\u001c7nS1gW\u0006\u001c\u0005.\u00198oK2$\u0002\"a\u0019\u0002j\u0005M\u0014q\u000f\t\u0005\u0003'\n)'\u0003\u0003\u0002h\u0005U#\u0001D&bM.\f7\t[1o]\u0016d\u0007bBA6/\u0001\u0007\u0011QN\u0001\re\u0016<\u0017n\u001d;feRKW.\u001a\t\u0004o\u0005=\u0014bAA9q\t!Aj\u001c8h\u0011\u001d\t)h\u0006a\u0001\u0003[\nQ\u0002[1oIND\u0017m[3US6,\u0007bBA=/\u0001\u0007\u0011QN\u0001\u0013CV$\b.\u001a8uS\u000e\fG/[8o)&lW-A\u0005oC:|7\u000fV8NgR!\u0011qPAC!\r9\u0014\u0011Q\u0005\u0004\u0003\u0007C$A\u0002#pk\ndW\rC\u0004\u0002\bb\u0001\r!!\u001c\u0002\u000b9\fgn\\:\u0002\u001fI\fg\u000eZ8n)&lWMT1o_N,\"!!\u001c\u0002\u0017I\fg\u000eZ8n%\u0006$\u0018n\\\u000b\u0003\u0003\u007f\n!\u0005^3ti^\u0013\u0018\r]!s_VtGMU3d_J$WM\u001d*fcV,7\u000f^:P]2LH#A-)\u0007m\t9\n\u0005\u0003\u0002\u001a\u0006\u001dVBAAN\u0015\u0011\ti*a(\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\"\u0006\r\u0016a\u00026va&$XM\u001d\u0006\u0004\u0003KC\u0017!\u00026v]&$\u0018\u0002BAU\u00037\u0013A\u0001V3ti\u0006qC/Z:u/J\f\u0007/\u0011:pk:$'+Z2pe\u0012,'oQ8o]\u0016\u001cG/[8o\u0011\u0006tGm\u001d5bW\u0016\u001cxJ\u001c7zQ\ra\u0012qS\u00014i\u0016\u001cHo\u0016:ba\u0006\u0013x.\u001e8e%\u0016\u001cwN\u001d3fe\u000e{gN\\3di&|g.Q;uQ\u0016tG/[2bi&|gn](oYfD3!HAL\u0003\u0005\"Xm\u001d;Xe\u0006\u0004\u0018I]8v]\u0012\u0014VmY8sI\u0016\u0014H\u000b\u001b:fC\u0012\u001cxJ\u001c7zQ\rq\u0012qS\u0001\u001bi\u0016\u001cH/\u00138de\u0016lWM\u001c;bY2{\u0017\rZ!wKJ\fw-\u001a\u0015\u0004?\u0005]\u0015a\u0007;fgR<\u0016\u000e\u001e5TC6\u0004H.Z:ESN$(/\u001b2vi&|g\u000eF\u0004Z\u0003\u007f\u000b\u0019/!<\t\u000f\u0005\u0005\u0007\u00051\u0001\u0002D\u00061QM^3oiN\u0004b!!2\u0002P\u0006MWBAAd\u0015\u0011\tI-a3\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u001a\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0006\u001d'A\u0003'jgR\u0014UO\u001a4feB9q'!6\u0002\u0000\u0005e\u0017bAAlq\t1A+\u001e9mKJ\u0002B!a7\u0002`6\u0011\u0011Q\u001c\u0006\u0003\u0019ZLA!!9\u0002^\nAA)\u001e:bi&|g\u000eC\u0004\u0002f\u0002\u0002\r!a:\u0002\u0013\u0005\u001c8/\u001a:uS>t\u0007\u0003C\u001c\u0002j\u0006}\u0014qP-\n\u0007\u0005-\bHA\u0005Gk:\u001cG/[8oe!I\u0011q\u001e\u0011\u0011\u0002\u0003\u0007\u0011qE\u0001\u0007G>tg-[4\u0002KQ,7\u000f^,ji\"\u001c\u0016-\u001c9mKN$\u0015n\u001d;sS\n,H/[8oI\u0011,g-Y;mi\u0012\u001aTCAA{U\u0011\t9#a>,\u0005\u0005e\b\u0003BA~\u0005\u000bi!!!@\u000b\t\u0005}(\u0011A\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u00019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\tiPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$\u0012\"\u0017B\u0006\u0005\u001b\u0011\tBa\u0005\t\u000bI\u0013\u0003\u0019\u0001+\t\u000f\t=!\u00051\u0001\u0002:\u0005I1/\u001a7fGR|'o\u001d\u0005\b\u0003\u0003\u0014\u0003\u0019AAb\u0011\u001d\t)O\ta\u0001\u0003O\f!\u0003^3ti&#G.\u001a\"s_.,'\u000fT8bI\"\u001a1%a&\u0002+Q,7\u000f^*j]\u001edWMU3rk\u0016\u001cH\u000fT8bI\"\u001aA%a&\u0002/Q,7\u000f^'vYRL\u0007\u000f\\3SKF,Xm\u001d;M_\u0006$\u0007fA\u0013\u0002\u0018\u0006aB/Z:u'&tw\r\\3SKF,Xm\u001d;US6,\u0017I^3sC\u001e,\u0007f\u0001\u0014\u0002\u0018\u0006\u0001D/Z:u\u001bVdG/\u001b9mKJ+\u0017/^3tiRKW.Z!wKJ\fw-Z,ji\"LgnU1na2,\u0007+\u001a:j_\u0012D3aJAL\u0003u!Xm\u001d;Es:\fW.[2TKJ4\u0018nY3SKF,Xm\u001d;US6,\u0007f\u0001\u0015\u0002\u0018\u0006yB/Z:u\tft\u0017-\\5d/>\u00148\u000e\\8bI\u000e{WM\u001a4jG&,g\u000e^:)\u0007%\n9*A\u000euKN$X*\u001e7uSBdWmU1na2Lgn\u001a)fe&|Gm\u001d\u0015\u0004U\u0005]\u0015\u0001\u0007;fgRlU\u000f\u001c;ja2,7+Y7qY\u0016\u001cu.\u001e8ug\"\u001a1&a&\u0002'Q,7\u000f\u001e\"s_.,'\u000fT8bI\u000ecwn]3)\u00071\n9*A\ruKN$(I]8lKJdu.\u00193JI\u0016l\u0007o\u001c;f]\u000eL\bfA\u0017\u0002\u0018\u0006AA/Z1s\t><h\u000eK\u0002/\u0005\u000b\u0002B!!'\u0003H%!!\u0011JAN\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000eK\u0004\u0001\u0005\u001b\u0012\u0019F!\u0016\u0011\t\u0005e%qJ\u0005\u0005\u0005#\nYJA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0007\u0005!\u000e\u0019")
public class BrokerLoadTest
implements Logging {
    private final int nodeId;
    private final MockTime time;
    private BrokerLoad brokerLoad;
    private Metrics metrics;
    private final String SelectorMetricsGrpPrefix;
    private final SecurityProtocol securityProtocol;
    private final String multiTenantListenerName;
    private final Properties defaultProps;
    private final KafkaConfig defaultConfig;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerLoad brokerLoad() {
        return this.brokerLoad;
    }

    public void brokerLoad_$eq(BrokerLoad x$1) {
        this.brokerLoad = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public String SelectorMetricsGrpPrefix() {
        return this.SelectorMetricsGrpPrefix;
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String multiTenantListenerName() {
        return this.multiTenantListenerName;
    }

    public Properties defaultProps() {
        return this.defaultProps;
    }

    public KafkaConfig defaultConfig() {
        return this.defaultConfig;
    }

    private List<Selector> mockSelectors(Metrics metrics) {
        ChannelBuilder channelBuilderMock = (ChannelBuilder)Mockito.mock(ChannelBuilder.class);
        LogContext logContextMock = (LogContext)Mockito.mock(LogContext.class);
        Logger loggerMock = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logContextMock.logger(Selector.class)).thenReturn((Object)loggerMock);
        Selector selector = new Selector(0L, metrics, (Time)this.time(), this.SelectorMetricsGrpPrefix(), channelBuilderMock, logContextMock);
        return new .colon.colon((Object)selector, (List)Nil$.MODULE$);
    }

    private KafkaChannel mockKafkaChannel(long registerTime, long handshakeTime, long authenticationTime) {
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        KafkaChannel.KafkaChannelMetrics channelMetrics = (KafkaChannel.KafkaChannelMetrics)Mockito.mock(KafkaChannel.KafkaChannelMetrics.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.transportHandshakeTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)handshakeTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.authenticationTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)authenticationTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.computeConnectionLocalServiceTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)(registerTime + handshakeTime + authenticationTime)));
        Mockito.when((Object)channel.metrics()).thenReturn((Object)channelMetrics);
        return channel;
    }

    private double nanosToMs(long nanos) {
        long positiveNanos = package$.MODULE$.max(nanos, 0L);
        return (double)TimeUnit.NANOSECONDS.toMicros(positiveNanos) / (double)TimeUnit.MILLISECONDS.toMicros(1L);
    }

    private long randomTimeNanos() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return Duration.ofMillis(1L).toNanos() + (long)Random$.MODULE$.nextInt((int)1000000.0);
    }

    private double randomRatio() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return 0.0 + 1.0 * Random$.MODULE$.nextDouble();
    }

    @Test
    public void testWrapAroundRecorderRequestsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderRequestsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        Option optionalBrokerLoadMetric = this.brokerLoad().brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), this.randomTimeNanos());
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderConnectionHandshakesOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderConnectionHandshakesOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        Option optionalBrokerLoadMetric = this.brokerLoad().brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(0.0));
            KafkaChannel channel = this.mockKafkaChannel(0L, this.randomTimeNanos(), 0L);
            this.brokerLoad().notifyOnConnection(channel);
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderConnectionAuthenticationsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderConnectionAuthenticationsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        Option optionalBrokerLoadMetric = this.brokerLoad().brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(0.0));
            this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(0.0));
            KafkaChannel channel = this.mockKafkaChannel(0L, 0L, this.randomTimeNanos());
            this.brokerLoad().notifyOnConnection(channel);
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderThreadsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderThreadsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        Option optionalBrokerLoadMetric = this.brokerLoad().brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        double prevLoad = 0.0;
        double idleRatio = 0.99;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(idleRatio));
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(idleRatio));
            this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(idleRatio));
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
                idleRatio -= 1.0E-4;
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testIncrementalLoadAverage() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        props.put("confluent.broker.load.window.size.ms", "6000");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testIncrementalLoadAverage$1(this, selector);
            return BoxedUnit.UNIT;
        });
        Option optionalBrokerLoadMetric = this.brokerLoad().brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        double prevLoad = 0.0;
        long timeMs = 1L;
        this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(this.randomRatio()));
        this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(this.randomRatio()));
        this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(this.randomRatio()));
        this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(2L).toNanos());
        this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
        for (int maxRequests = 50000; maxRequests > 0; --maxRequests) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), Predef$.MODULE$.double2Double(this.randomRatio()));
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, Predef$.MODULE$.double2Double(this.randomRatio()));
            this.brokerLoad().notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(this.randomRatio()));
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(timeMs).toNanos());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
            ++timeMs;
            double curLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            Predef$.MODULE$.assert(curLoad != prevLoad);
            prevLoad = curLoad;
        }
    }

    private void testWithSamplesDistribution(ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion, KafkaConfig config) {
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
    }

    private void testWithSamplesDistribution(BrokerLoad brokerLoad, List<Selector> selectors, ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion) {
        Option optionalBrokerLoadMetric = brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)optionalBrokerLoadMetric.isDefined());
        Metric brokerLoadMetric = (Metric)optionalBrokerLoadMetric.get();
        events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double brokerLoadValue = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
        Assertions.assertTrue((brokerLoadValue >= 0.0 && brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option optionalServiceTimeMetric = brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)optionalServiceTimeMetric.isDefined());
        double averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(averageTotalServiceLocalTimeValue, brokerLoadValue);
    }

    private KafkaConfig testWithSamplesDistribution$default$3() {
        return this.defaultConfig();
    }

    @Test
    public void testIdleBrokerLoad() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3600).foreach((Function1 & Serializable & scala.Serializable)_ -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)Duration.ofSeconds(1L))));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)BrokerLoadTest.assertion$1(), this.testWithSamplesDistribution$default$3());
    }

    @Test
    public void testSingleRequestLoad() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs())), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0);
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config2 = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config3 = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestLoad() {
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_config2;
        void testWithSamplesDistribution_config3;
        void testWithSamplesDistribution_config4;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)Duration.ZERO)}))));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config4, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config3, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) - 1).foreach((Function1 & Serializable & scala.Serializable)i -> BrokerLoadTest.$anonfun$testMultipleRequestLoad$3(this, samples, BoxesRunTime.unboxToInt((Object)i)));
        DoubleRef prevLoad = DoubleRef.create((double)0.0);
        KafkaConfig kafkaConfig3 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config2, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestLoad$4(prevLoad, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) + 1)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()));
        KafkaConfig kafkaConfig4 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4.get();
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestLoad$5(prevLoad, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4);
    }

    @Test
    public void testSingleRequestTimeAverage() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)this.assertion$2(samples), this.testWithSamplesDistribution$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestTimeAverageWithinSamplePeriod() {
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_config2;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}))));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config2, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$1(this, samples, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)config.brokerLoadWindowSizeMs())}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(config.brokerLoadNumSamples()) - 2).foreach((Function1 & Serializable & scala.Serializable)_ -> BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(samples, config, BoxesRunTime.unboxToInt((Object)_)));
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(this.nanosToMs((long)testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) < 1.0, (Function0 & Serializable & scala.Serializable)() -> "Avg request time should be less than 1.0");
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric4.get();
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4);
    }

    @Test
    public void testDynamicServiceRequestTime() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), this.defaultConfig(), BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$1(this, selector);
            return BoxedUnit.UNIT;
        });
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        DoubleRef defaultLoad = DoubleRef.create((double)0.0);
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$2(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$3(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_brokerLoadValue2);
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$4(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testDynamicWorkloadCoefficients() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), this.defaultConfig(), BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$1(this, selector);
            return BoxedUnit.UNIT;
        });
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        DoubleRef defaultLoad = DoubleRef.create((double)0.0);
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$2(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) * (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$3(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_brokerLoadValue2);
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) / (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$4(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testMultipleSamplingPeriods() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        DoubleRef load = DoubleRef.create((double)0.0);
        KafkaConfig testWithSamplesDistribution_config = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$1(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        long newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config2 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$2(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config3 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$3(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testMultipleSampleCounts() {
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        ObjectRef config = ObjectRef.create((Object)KafkaConfig$.MODULE$.fromProps(props));
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2).foreach((Function1 & Serializable & scala.Serializable)i -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)i)), (Object)((KafkaConfig)config.elem).brokerLoadWindowSizeMs())));
        DoubleRef load = DoubleRef.create((double)0.0);
        KafkaConfig testWithSamplesDistribution_config = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$2(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        long newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config2 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric2.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$3(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) / 4;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config3 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, BrokerLoad$.MODULE$.apply$default$3()));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.brokerLoadPercentMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.isDefined());
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = (Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalBrokerLoadMetric3.get();
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$4(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testBrokerLoadClose() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3600).foreach((Function1 & Serializable & scala.Serializable)i -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)i)), (Object)this.defaultConfig().brokerLoadWindowSizeMs())));
        DoubleRef lastLoad = DoubleRef.create((double)0.0);
        DoubleRef lastServiceLocalTime = DoubleRef.create((double)0.0);
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)BrokerLoadTest.assertion$3(lastLoad, lastServiceLocalTime), this.testWithSamplesDistribution$default$3());
        this.brokerLoad().close();
        Assertions.assertFalse((boolean)this.brokerLoad().brokerLoadPercentMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageRequestHandlerThreadIdleRatioMetric().isDefined());
    }

    @Test
    public void testBrokerLoadIdempotency() {
        int requiredInstanceCount = 100;
        ConcurrentLinkedQueue brokerLoadInstances = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue taskStatus = new ConcurrentLinkedQueue();
        ObjectRef executor = ObjectRef.create((Object)Executors.newSingleThreadExecutor());
        this.metrics_$eq(new Metrics((Time)this.time()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), requiredInstanceCount).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)_ -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$2(this, brokerLoadInstances)))));
        Duration waitTimeout = Duration.ofSeconds(10L);
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
        executor.elem = Executors.newFixedThreadPool(10);
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$5(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        DoubleRef firstBrokerLoadPercent = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadServiceTime = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadExternalThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadReplicationThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadRequestThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue()));
        brokerLoadInstances.forEach(brokerLoad -> {
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric().get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        Selector mockSelector = (Selector)this.mockSelectors(this.metrics()).head();
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$9(this, brokerLoad, mockSelector)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        firstBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric().get()).metricValue());
        firstBrokerLoadServiceTime.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
        firstBrokerLoadExternalThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadReplicationThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadRequestThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
        brokerLoadInstances.forEach(brokerLoad -> {
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric().get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$13(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        firstBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric().get()).metricValue());
        firstBrokerLoadServiceTime.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
        firstBrokerLoadExternalThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadReplicationThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadRequestThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
        brokerLoadInstances.forEach(brokerLoad -> {
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric().get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$17(brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerLoad() != null) {
            this.brokerLoad().close();
        }
        if (this.metrics() != null) {
            this.metrics().close();
        }
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderRequestsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderConnectionHandshakesOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderConnectionAuthenticationsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderThreadsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalLoadAverage$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$3(BrokerLoadTest $this, BrokerLoad brokerLoad$1, List selectors$1, Tuple2 x$1) {
        if (x$1 != null) {
            double value = x$1._1$mcD$sp();
            Duration duration = (Duration)x$1._2();
            if (!Double.isNaN(value)) {
                long timeNanos = (long)(value * 1000000.0);
                brokerLoad$1.notifyOnThreadUsage($this.multiTenantListenerName(), Predef$.MODULE$.double2Double(0.0));
                brokerLoad$1.notifyOnThreadUsage($this.securityProtocol().name, Predef$.MODULE$.double2Double(0.0));
                brokerLoad$1.notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(0.0));
                brokerLoad$1.recordRequestTimeNanos((Selector)selectors$1.head(), timeNanos);
            }
            $this.time().sleep(duration.toMillis());
            return;
        }
        throw new MatchError(null);
    }

    private static final Function2 assertion$1() {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(x$2, brokerLoad) -> Predef$.MODULE$.assert(brokerLoad == 0.0);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestLoad$3(BrokerLoadTest $this, ObjectRef samples$2, int i) {
        return ((ListBuffer)samples$2.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(i + 1)), (Object)$this.defaultConfig().brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$4(DoubleRef prevLoad$1, double x$8, double brokerLoad) {
        prevLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(prevLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$5(DoubleRef prevLoad$1, double x$9, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad > prevLoad$1.elem);
    }

    private final Function2 assertion$2(ListBuffer samples$3) {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(avgRequestTime, x$10) -> Assertions.assertEquals((double)((Tuple2)samples$3.head())._1$mcD$sp(), (double)this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$1(BrokerLoadTest $this, ObjectRef samples$4, double avgRequestTime, double x$11) {
        Assertions.assertEquals((double)((((Tuple2)((ListBuffer)samples$4.elem).apply(0))._1$mcD$sp() + ((Tuple2)((ListBuffer)samples$4.elem).apply(1))._1$mcD$sp()) / (double)2), (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(BrokerLoadTest $this, double avgRequestTime, double x$12) {
        Assertions.assertEquals((double)0.5, (double)$this.nanosToMs((long)avgRequestTime), (double)1.0E-6);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(ObjectRef samples$4, KafkaConfig config$1, int _) {
        return ((ListBuffer)samples$4.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config$1.brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(BrokerLoadTest $this, double avgRequestTime, double x$14) {
        Assertions.assertEquals((double)1.0, (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$2(DoubleRef defaultLoad$1, double x$15, double brokerLoad) {
        defaultLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$3(DoubleRef defaultLoad$1, double x$16, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$4(DoubleRef defaultLoad$1, double x$17, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$2(DoubleRef defaultLoad$2, double x$18, double brokerLoad) {
        defaultLoad$2.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$3(DoubleRef defaultLoad$2, double x$19, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$4(DoubleRef defaultLoad$2, double x$20, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$1(DoubleRef load$1, double x$21, double brokerLoad) {
        load$1.elem = brokerLoad;
        Predef$.MODULE$.assert(load$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$2(DoubleRef load$1, double x$22, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$3(DoubleRef load$1, double x$23, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$2(DoubleRef load$2, double x$24, double brokerLoad) {
        load$2.elem = brokerLoad;
        Predef$.MODULE$.assert(load$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$3(DoubleRef load$2, double x$25, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$4(DoubleRef load$2, double x$26, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    private static final Function2 assertion$3(DoubleRef lastLoad$1, DoubleRef lastServiceLocalTime$1) {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(serviceLocalTimeAvg, brokerLoad) -> {
            Predef$.MODULE$.assert(brokerLoad > 0.0);
            Predef$.MODULE$.assert(serviceLocalTimeAvg > 0.0);
            lastLoad$1.elem = brokerLoad;
            lastServiceLocalTime$1.elem = serviceLocalTimeAvg;
        };
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$2(BrokerLoadTest $this, Queue brokerLoadInstances$1) {
        BrokerLoad brokerLoad = BrokerLoad$.MODULE$.apply($this.metrics(), $this.defaultConfig(), BrokerLoad$.MODULE$.apply$default$3());
        Assertions.assertTrue((boolean)brokerLoad.brokerLoadPercentMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageRequestHandlerThreadIdleRatioMetric().isDefined());
        return brokerLoadInstances$1.add(brokerLoad);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$5(BrokerLoadTest $this, BrokerLoad brokerLoad$2) {
        KafkaChannel channel = $this.mockKafkaChannel($this.randomTimeNanos(), $this.randomTimeNanos(), $this.randomTimeNanos());
        brokerLoad$2.notifyOnConnection(channel);
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$9(BrokerLoadTest $this, BrokerLoad brokerLoad$3, Selector mockSelector$1) {
        brokerLoad$3.recordRequestTimeNanos(mockSelector$1, $this.randomTimeNanos());
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$13(BrokerLoadTest $this, BrokerLoad brokerLoad$4) {
        brokerLoad$4.notifyOnThreadUsage($this.multiTenantListenerName(), Predef$.MODULE$.double2Double($this.randomRatio()));
        brokerLoad$4.notifyOnThreadUsage($this.securityProtocol().name, Predef$.MODULE$.double2Double($this.randomRatio()));
        brokerLoad$4.notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double($this.randomRatio()));
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$17(BrokerLoad brokerLoad$5) {
        brokerLoad$5.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public BrokerLoadTest() {
        void var1_21;
        Logging.$init$((Logging)this);
        this.nodeId = 0;
        this.time = new MockTime();
        this.SelectorMetricsGrpPrefix = "";
        this.securityProtocol = SecurityProtocol.PLAINTEXT;
        this.multiTenantListenerName = "EXTERNAL";
        int x$1 = this.nodeId();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)this.securityProtocol());
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, (Option<SecurityProtocol>)x$3, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        properties.put("confluent.multitenant.listener.names", this.multiTenantListenerName());
        this.defaultProps = var1_21;
        this.defaultConfig = KafkaConfig$.MODULE$.apply((Map)this.defaultProps());
    }
}

