/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0001e3Aa\u0003\u0007\u0001#!)a\u0004\u0001C\u0001?!9!\u0005\u0001a\u0001\n\u0003\u0019\u0003b\u0002\u0017\u0001\u0001\u0004%\t!\f\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u0013\t\u000bQ\u0002A\u0011A\u001b\t\u000b\r\u0003A\u0011A\u001b\t\u000b!\u0003A\u0011A\u001b\t\u000b5\u0003A\u0011A\u001b\t\u000b=\u0003A\u0011A\u001b\t\u000bE\u0003A\u0011A\u001b\u000391Kg.\u001e=DaVlU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fV3ti*\u0011QBD\u0001\b[\u0016$(/[2t\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u001d\u0005)Q\u000f^5mg&\u0011QD\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\tA\"A\u0004cCN,G)\u001b:\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u0005%|'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012AAR5mK\u0006Y!-Y:f\t&\u0014x\fJ3r)\tq\u0013\u0007\u0005\u0002\u0014_%\u0011\u0001\u0007\u0006\u0002\u0005+:LG\u000fC\u00043\u0007\u0005\u0005\t\u0019\u0001\u0013\u0002\u0007a$\u0013'\u0001\u0005cCN,G)\u001b:!\u0003\u0015\u0019X\r^+q)\u0005q\u0003FA\u00038!\tA\u0014)D\u0001:\u0015\tQ4(A\u0002ba&T!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tK$A\u0003\"fM>\u0014X-R1dQ\u000691\r\\3b]V\u0003\bF\u0001\u0004F!\tAd)\u0003\u0002Hs\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0013i\u0016\u001cHo\u00119v+RLG.\u001b>bi&|g\u000e\u000b\u0002\b\u0015B\u0011\u0001hS\u0005\u0003\u0019f\u0012A\u0001V3ti\u0006QA/Z:u+N\f'\r\\3)\u0005!Q\u0015a\u0004;fgR\u0014V-\u00193M_\u0006$\u0017I^4)\u0005%Q\u0015a\t;fgR,f.\u00192mKR{'+Z1e\u001d>tW\r_5ti\u0016tG\u000f\u0015:pG\u001aKG.\u001a\u0015\u0003\u0015)CC\u0001\u0001+X1B\u0011\u0001(V\u0005\u0003-f\u0012q\u0001V5nK>,H/A\u0003wC2,XMH\u0002\u0002)\u0004\u0007")
public class LinuxCpuMetricsCollectorTest
implements Logging {
    private File baseDir;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.baseDir_$eq(TestUtils.tempDirectory());
    }

    @AfterEach
    public void cleanUp() {
        Utils.delete((File)this.baseDir());
    }

    @Test
    public void testCpuUtilization() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying());
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 1260 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.0, (double)collector.systemCpuUtilization(), (double)0.0);
        cpuStat = "cpu  10711892 409 4188649 124938617 516537 0 2369826 1262 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.15, (double)collector.systemCpuUtilization(), (double)2.0);
        cpuStat = "cpu  10754158 411 4204810 126043403 516852 0 2371170 1266 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.15, (double)collector.systemCpuUtilization(), (double)2.0);
    }

    @Test
    public void testUsable() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying());
        String loadStr = new StringOps(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 1260 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertTrue((boolean)collector.usable());
    }

    @Test
    public void testReadLoadAvg() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying());
        String loadStr = new StringOps(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.11, (double)collector.oneMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.22, (double)collector.fiveMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.33, (double)collector.fifteenMinLoadAvg(), (double)0.0);
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        MockTime time = new MockTime(100L, 1000L);
        Assertions.assertFalse((boolean)new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying()).usable());
    }

    public LinuxCpuMetricsCollectorTest() {
        Logging.$init$((Logging)this);
        this.baseDir = null;
    }
}

