/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0001=4Aa\u0004\t\u0001+!)!\u0005\u0001C\u0001G!9a\u0005\u0001a\u0001\n\u00039\u0003b\u0002\u0019\u0001\u0001\u0004%\t!\r\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u0015\t\u000fa\u0002\u0001\u0019!C\u0001s!9a\t\u0001a\u0001\n\u00039\u0005BB%\u0001A\u0003&!\bC\u0003K\u0001\u0011\u00051\nC\u0003X\u0001\u0011\u00051\nC\u0003]\u0001\u0011\u00051\nC\u0003b\u0001\u0011\u00051\nC\u0003d\u0001\u0011\u00051\nC\u0003f\u0001\u0011\u00051\nC\u0003h\u0001\u0011\u00051JA\u000fMS:,\b\u0010R5tW6+GO]5dg\u000e{G\u000e\\3di>\u0014H+Z:u\u0015\t\t\"#A\u0004nKR\u0014\u0018nY:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0013\u0003\u0015)H/\u001b7t\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005\u0001\u0012a\u00022bg\u0016$\u0015N]\u000b\u0002QA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0003S>T\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t!a)\u001b7f\u0003-\u0011\u0017m]3ESJ|F%Z9\u0015\u0005I*\u0004CA\f4\u0013\t!\u0004D\u0001\u0003V]&$\bb\u0002\u001c\u0004\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0014\u0001\u00032bg\u0016$\u0015N\u001d\u0011\u0002\tQLW.Z\u000b\u0002uA\u00111\bR\u0007\u0002y)\u0011q$\u0010\u0006\u0003}}\naaY8n[>t'BA\nA\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015c$\u0001\u0002+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0003e!CqA\u000e\u0004\u0002\u0002\u0003\u0007!(A\u0003uS6,\u0007%A\u0003tKR,\u0006\u000fF\u00013Q\tAQ\n\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006\u0019\u0011\r]5\u000b\u0005I\u001b\u0016a\u00026va&$XM\u001d\u0006\u0003)\n\u000bQA[;oSRL!AV(\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0004dY\u0016\fg.\u00169)\u0005%I\u0006C\u0001([\u0013\tYvJA\u0005BMR,'/R1dQ\u0006qA/Z:u\t\u00164\u0018nY3MSN$\bF\u0001\u0006_!\tqu,\u0003\u0002a\u001f\n!A+Z:u\u0003-!Xm\u001d;NKR\u0014\u0018nY:)\u0005-q\u0016\u0001\u0003;fgR\u0014\u0016\r^3)\u00051q\u0016A\u0003;fgR,6/\u00192mK\"\u0012QBX\u0001$i\u0016\u001cH/\u00168bE2,Gk\u001c*fC\u0012tuN\\3ySN$XM\u001c;Qe>\u001cg)\u001b7fQ\tqa\f\u000b\u0003\u0001U6t\u0007C\u0001(l\u0013\tawJA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0007\u0005!\u000e\u0019")
public class LinuxDiskMetricsCollectorTest
implements Logging {
    private File baseDir;
    private Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.baseDir_$eq(TestUtils.tempDirectory());
        this.time_$eq((Time)new MockTime(100L, 1000L));
    }

    @AfterEach
    public void cleanUp() {
        Utils.delete((File)this.baseDir());
    }

    @Test
    public void testDeviceList() {
        String diskStats = "  8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417\n\t8 16 sdb 6396 757 340594 87481 23734 54031 739680 88939 0 78283 171644\n 0 0";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])collector.devices())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sda", "sdb"})));
    }

    @Test
    public void testMetrics() {
        String diskStats1 = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertEquals((int)11, (int)collector.metrics().length);
    }

    @Test
    public void testRate() {
        String diskStats1 = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 1 71146779 233664417";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertEquals((double)0.0, (double)collector.metricRate("sda", 0), (double)1.0E-4);
        Assertions.assertEquals((double)1.0, (double)collector.metricRate("sda", 8), (double)1.0E-4);
        this.time().sleep(10L);
        String diskStats2 = "8 0 sda 425440 145628 83735176 3176407 71440550 167315203 2216615250 269742334 10 71146779 233664417";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)10000.0, (double)collector.metricRate("sda", 0), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)collector.metricRate("sda", 8), (double)1.0E-4);
        Assertions.assertEquals((double)-1.0, (double)collector.metricRate("sdd", 0), (double)1.0E-4);
        Assertions.assertEquals((double)-1.0, (double)collector.metricRate("sda", 11), (double)1.0E-4);
    }

    @Test
    public void testUsable() {
        String diskStats = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertTrue((boolean)new LinuxDiskMetricsCollector(this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying()).usable());
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertFalse((boolean)collector.usable());
        Assertions.assertEquals((int)0, (int)collector.metrics().length);
    }

    public LinuxDiskMetricsCollectorTest() {
        Logging.$init$((Logging)this);
        this.baseDir = null;
        this.time = null;
    }
}

