/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001:\u0011\u0019\u0011\u0005\u0001)A\u0005u!91\t\u0001b\u0001\n\u0003!\u0005BB'\u0001A\u0003%Q\tC\u0004O\u0001\t\u0007I\u0011A(\t\rY\u0003\u0001\u0015!\u0003Q\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001d)\u0007A1A\u0005\u0002eBaA\u001a\u0001!\u0002\u0013Q\u0004\"B4\u0001\t\u0003A\u0007\"B=\u0001\t\u0003A\u0007\"B>\u0001\t\u0003A\u0007\"B?\u0001\t\u0003A\u0007\"B@\u0001\t\u0003A\u0007BBA\u0002\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002\b\u0001!\t\u0001\u001b\u0005\u0007\u0003\u0017\u0001A\u0011\u00015\t\r\u0005=\u0001\u0001\"\u0001i\u0011\u0019\t\u0019\u0002\u0001C\u0001Q\"1\u0011q\u0003\u0001\u0005\u0002!Da!a\u0007\u0001\t\u0003A\u0007BBA\u0010\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002$\u0001!\t\u0001\u001b\u0005\u0007\u0003O\u0001A\u0011\u00015\t\r\u0005-\u0002\u0001\"\u0001i\u0011\u0019\ty\u0003\u0001C\u0001Q\"9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003C\u0002A\u0011BA2\u0005-iU\r\u001e:jGN$Vm\u001d;\u000b\u0005\r\"\u0013aB7fiJL7m\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006J\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002.U\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u00020e5\t\u0001G\u0003\u00022I\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t!%\u0001\u0005ok6tu\u000eZ3t+\u0005Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$aA%oi\u0006Ia.^7O_\u0012,7\u000fI\u0001\t]Vl\u0007+\u0019:ug\u0006Ia.^7QCJ$8\u000fI\u0001\u001ae\u0016\fX/\u001b:fI.\u000bgm[1TKJ4XM\u001d)sK\u001aL\u00070F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013aa\u0015;sS:<\u0017A\u0007:fcVL'/\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bK]3gSb\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS!aU%\u0002\tU$\u0018\u000e\\\u0005\u0003+J\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005I\u0006c\u0001.^?6\t1L\u0003\u0002]y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005y[&aA*fcB\u0011\u0001mY\u0007\u0002C*\u0011!\rJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\f'aC&bM.\f7i\u001c8gS\u001e\f\u0011B\\'fgN\fw-Z:\u0002\u00159lUm]:bO\u0016\u001c\b%A\u0013uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\t\u0011\u000e\u0005\u0002<U&\u00111\u000e\u0010\u0002\u0005+:LG\u000f\u000b\u0002\u000e[B\u0011an^\u0007\u0002_*\u0011\u0001/]\u0001\u0004CBL'B\u0001:t\u0003\u001dQW\u000f]5uKJT!\u0001^;\u0002\u000b),h.\u001b;\u000b\u0003Y\f1a\u001c:h\u0013\tAxN\u0001\u0003UKN$\u0018\u0001\u000e;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:V]J,w-[:uKJ,G-\u00114uKJ$U\r\\3uS:<Gk\u001c9jG\"\u0012a\"\\\u0001\u0014i\u0016\u001cHo\u00117vgR,'/\u00133NKR\u0014\u0018n\u0019\u0015\u0003\u001f5\fQ\u0003^3ti\n\u0013xn[3s'R\fG/Z'fiJL7\r\u000b\u0002\u0011[\u0006aB/Z:u3\u0006lW.\u001a:NKR\u0014\u0018nY:D_VtG/T3ue&\u001c\u0007FA\tn\u0003I!Xm\u001d;MS:,\b0S8NKR\u0014\u0018nY:)\u0005Ii\u0017!\u0004;fgRTU\n\u0017$jYR,'\u000f\u000b\u0002\u0014[\u0006\u0019B/Z:u+B$\u0017\r^3K\u001bb3\u0015\u000e\u001c;fe\"\u0012A#\\\u00013i\u0016\u001cHoR3oKJ\fGN\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006\u0013Xm\u0012:fK\u0012LG.\u001f*fO&\u001cH/\u001a:fI\"\u0012Q#\\\u0001\u0019i\u0016\u001cHoV5oI><8o\u0015;zY\u0016$\u0016m\u001a(b[\u0016\u001c\bF\u0001\fn\u0003\u0001\"Xm\u001d;Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c()\u001f;fg&sw*\u001e;)\u0005]i\u0017A\n;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:D_6\u0004\u0018m\u0019;fI\nKH/Z:J]\"\u0012\u0001$\\\u00017i\u0016\u001cHO\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg:{7*Z=D_6\u0004\u0018m\u0019;fIR{\u0007/[2SK\u000e|'\u000fZ:M_\u001e<W\r\u001a\u0015\u000335\fQ\u0003^3ti\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7\u000f\u000b\u0002\u001b[\u0006)C/Z:u\u0003\u001e<'/Z4bi\u0016\u0014VmY8sI6+GO]5dg&s\u0017\u000e^5bY&TX\r\u001a\u0015\u000375\f!\u0005^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m]*fO6,g\u000e\u001e*fC\u0012\u001c\bF\u0001\u000fn\u0003\u0001\"Xm\u001d;TKN\u001c\u0018n\u001c8FqBL'/\u001a'jgR,g.\u001a:NKR\u0014\u0018nY:)\u0005ui\u0017\u0001\u0004;pa&\u001cW*\u001a;sS\u000e\u001cH\u0003BA\u001c\u0003#\u0002RAWA\u001d\u0003{I1!a\u000f\\\u0005\r\u0019V\r\u001e\t\u0005\u0003\u007f\tiE\u0004\u0003\u0002B\u0005%\u0003cAA\"y5\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0013A\u0002\u001fs_>$h(C\u0002\u0002Lq\na\u0001\u0015:fI\u00164\u0017b\u0001'\u0002P)\u0019\u00111\n\u001f\t\u000f\u0005Mc\u00041\u0001\u0002V\u0005)Ao\u001c9jGB)1(a\u0016\u0002>%\u0019\u0011\u0011\f\u001f\u0003\r=\u0003H/[8o\u0003E!x\u000e]5d\u001b\u0016$(/[2He>,\bo\u001d\u000b\u0005\u0003o\ty\u0006C\u0004\u0002T}\u0001\r!!\u0010\u00021\u0019LG\u000e^3s\u0005f$v\u000e]5d\u001b\u0016$(/[2SK\u001e,\u0007\u0010\u0006\u0004\u00028\u0005\u0015\u0014q\r\u0005\u0007G\u0001\u0002\r!a\u000e\t\u000f\u0005M\u0003\u00051\u0001\u0002V\u0001")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @Test
    public void testBrokerStateMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @Test
    public void testYammerMetricsCountMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @Test
    public void testLinuxIoMetrics() {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableLike)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testJMXFilter() {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @Test
    public void testUpdateJMXFilter() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(server);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @Test
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaServer)this.servers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testBrokerTopicMetricsCompactedBytesIn() {
        String topicCompacted = "test-bytes-in-compacted-topic";
        String topicNotCompacted = "test-bytes-in-not-compacted-topic";
        .colon.colon topics = new .colon.colon((Object)topicCompacted, (List)new .colon.colon((Object)topicNotCompacted, (List)Nil$.MODULE$));
        String bytesInCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicCompacted).toString();
        String bytesInNotCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicNotCompacted).toString();
        String totalBytesIn = BrokerTopicStats$.MODULE$.BytesInPerSec();
        String totalCompactedBytesIn = BrokerTopicStats$.MODULE$.CompactedTopicsBytesInPerSec();
        Properties topicConfigCompacted = new Properties();
        topicConfigCompacted.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicConfigCompacted.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topicCompacted, 1, this.numNodes(), topicConfigCompacted);
        Properties topicConfigNotCompacted = new Properties();
        topicConfigNotCompacted.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicConfigNotCompacted.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        this.createTopic(topicNotCompacted, 1, this.numNodes(), topicConfigNotCompacted);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), (String)topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4()));
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$2(this, topic);
            return BoxedUnit.UNIT;
        });
        long initialCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long initialNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long initialTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long initialTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(initialCompactedTopicBytesIn + initialNotCompactedTopicBytesIn), (long)initialTotalBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialTotalCompactedBytesIn);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), (String)topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4()));
        long finalCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long finalNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long finalTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long finalTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(finalCompactedTopicBytesIn + finalNotCompactedTopicBytesIn), (long)finalTotalBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalTotalCompactedBytesIn);
        Assertions.assertTrue((finalCompactedTopicBytesIn > initialCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalNotCompactedTopicBytesIn > initialNotCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalBytesIn > initialTotalBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalCompactedBytesIn > initialTotalCompactedBytesIn ? 1 : 0) != 0);
    }

    @Test
    public void testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged() {
        String topic = "test-compacted-topic-record-no-key";
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        try {
            TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)new .colon.colon((Object)new ProducerRecord(topic, (Object)"test".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.produceMessages$default$3());
            Assertions.fail((String)"Exception should have been thrown since a compacted topic cannot accept a message without keys");
        }
        catch (Exception exception) {}
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(x$10))));
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount("name=NoKeyCompactedTopicRecordsPerSec") > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$1(x$11))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$2(x$12))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$3(x$13))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$4(x$14))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$5(x$15))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$6(x$16))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$7(x$17))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$8(x$18))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$9(x$19))), (int)1);
    }

    @Test
    public void testAggregateRecordMetricsInitialized() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$1(x$20))));
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$2(x$21))));
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$3(x$22))));
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$4(x$23))));
    }

    @Test
    public void testBrokerTopicMetricsSegmentReads() {
        String topic = "test-segment-reads";
        String segmentReads = BrokerTopicStats$.MODULE$.SegmentReadsPerSec();
        String segmentSpeculativePrefetches = BrokerTopicStats$.MODULE$.SegmentSpeculativePrefetchesPerSec();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentSpeculativePrefetchEnableProp(), "true");
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentBytesProp(), "128");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentReads));
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        MetricsTest.testTopicMetricFails$1(segmentReads, topic);
        MetricsTest.testTopicMetricFails$1(segmentSpeculativePrefetches, topic);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, 1, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 32).foreach((Function1 & Serializable & scala.Serializable)x$24 -> TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4()));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, 32, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 1L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) - 1L > TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) ? 1 : 0) != 0);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$25))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$26))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$27))), (int)1);
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.getMBeanName(), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString())).r().pattern();
        return (Set)metrics.filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$29)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaServer s) {
        Assertions.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics$1.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaServer server) {
        server.kafkaYammerMetrics().reconfigure((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$3(String topic$3, TopicPartition topicPartition$2, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$3, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$2).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$2(MetricsTest $this, String topic) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        $this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$3(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(MetricName x$10) {
        return x$10.getMBeanName().endsWith("name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$1(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$2(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$3(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$4(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$5(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$6(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$7(MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$8(MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$9(MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$1(MetricName x$20) {
        return x$20.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$2(MetricName x$21) {
        return x$21.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMagicNumberRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$3(MetricName x$22) {
        return x$22.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMessageCrcRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$4(MetricName x$23) {
        return x$23.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NonIncreasingOffsetRecordsPerSec");
    }

    private static final void testTopicMetricFails$1(String metric, String topic$4) {
        Assertions.assertThrows(Throwable.class, () -> TestUtils$.MODULE$.meterCount(new StringBuilder(7).append(metric).append(",topic=").append(topic$4).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$25) {
        String string = x$25.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$26) {
        String string = x$26.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$27) {
        String string = x$27.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$29) {
        return pattern$1.matcher(x$29).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        this.nMessages = 2;
    }
}

