/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005BeBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019I\u0006\u0001)A\u0005\u001b\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00022\u0001A\u0003%A\fC\u0004d\u0001\t\u0007I\u0011A!\t\r\u0011\u0004\u0001\u0015!\u0003C\u0011\u001d)\u0007A1A\u0005\u0002eBaA\u001a\u0001!\u0002\u0013Q\u0004\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0001i\u0011%\t\b\u00011AA\u0002\u0013\u0005!\u000fC\u0005y\u0001\u0001\u0007\t\u0011)Q\u0005S\")\u0011\u0010\u0001C!u\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u000f\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003O\u0001A\u0011AA\u0003\u0011\u001d\t\t\u0004\u0001C\u0001\u0003\u000bAq!!\u000e\u0001\t\u0003\t)\u0001C\u0004\u0002:\u0001!\t!!\u0002\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u001d\tY\n\u0001C\u0005\u0003;C\u0011\"!-\u0001#\u0003%I!a-\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"1\u0011\u0011\u001c\u0001\u0005\u0002eBq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002h\u0002!I!!;\t\u0013\u00055\b!%A\u0005\n\u0005=\bbBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001fAqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003 \u0001!IA!\t\u00035\u0011Kh.Y7jG\u000e{gN\\3di&|g.U;pi\u0006$Vm\u001d;\u000b\u0005%R\u0013a\u00028fi^|'o\u001b\u0006\u0002W\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\t\t$&\u0001\u0004tKJ4XM]\u0005\u0003gA\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003!\n1B\u0019:pW\u0016\u00148i\\;oiV\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0002J]R\fQ\u0001^8qS\u000e,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0001\u0002\\5ti\u0016tWM]\u000b\u0002\u001bB\u0011ajV\u0007\u0002\u001f*\u0011\u0011\u0006\u0015\u0006\u0003#J\u000baaY8n[>t'BA\u0016T\u0015\t!V+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0006\u0019qN]4\n\u0005a{%\u0001\u0004'jgR,g.\u001a:OC6,\u0017!\u00037jgR,g.\u001a:!\u00031awnY1m\u0003\u0012$'/Z:t+\u0005a\u0006CA/a\u001b\u0005q&BA0G\u0003\rqW\r^\u0005\u0003Cz\u00131\"\u00138fi\u0006#GM]3tg\u0006iAn\\2bY\u0006#GM]3tg\u0002\n1\"\u001e8l]><h\u000eS8ti\u0006aQO\\6o_^t\u0007j\\:uA\u0005i\u0002\u000f\\1j]R,\u0007\u0010\u001e'jgR,g.\u001a:EK\u001a\fW\u000f\u001c;Rk>$\u0018-\u0001\u0010qY\u0006Lg\u000e^3yi2K7\u000f^3oKJ$UMZ1vYR\fVo\u001c;bA\u0005AQ\r_3dkR|'/F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\u001c$\u0002\tU$\u0018\u000e\\\u0005\u0003a.\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003gZ\u0004\"a\u000f;\n\u0005Ud$\u0001B+oSRDqa\u001e\b\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHCA:|\u0011\u0015a\b\u00031\u0001~\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003}~l\u0011!\\\u0005\u0004\u0003\u0003i'A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\t1\u000fK\u0002\u0012\u0003\u0013\u0001B!a\u0003\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0002ba&TA!a\u0005\u0002\u0016\u00059!.\u001e9ji\u0016\u0014(bAA\f+\u0006)!.\u001e8ji&!\u00111DA\u0007\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!#!\t\u0011\t\u0005-\u00111E\u0005\u0005\u0003K\tiAA\u0005BMR,'/R1dQ\u0006QB/Z:u\tft\u0017-\\5d\u0007>tg.Z2uS>t\u0017+^8uC\"\u001a1#a\u000b\u0011\t\u0005-\u0011QF\u0005\u0005\u0003_\tiA\u0001\u0003UKN$\u0018A\t;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\rK\u0002\u0015\u0003W\ta\u0006^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\\\"sK\u0006$\u0018n\u001c8SCR,\u0017+^8uC\"\u001aQ#a\u000b\u0002AQ,7\u000f\u001e#z]\u0006l\u0017nY%q\u0007>tg.Z2uS>t'+\u0019;f#V|G/\u0019\u0015\u0004-\u0005-\u0012A\u0005:fG>tg-[4ve\u0016\u001cVM\u001d<feN$ra]A!\u0003\u000b\ny\u0005\u0003\u0004\u0002D]\u0001\r!`\u0001\t]\u0016<\bK]8qg\"9\u0011qI\fA\u0002\u0005%\u0013a\u00049fe\n\u0013xn[3s\u0007>tg-[4\u0011\u0007m\nY%C\u0002\u0002Nq\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002R]\u0001\r!a\u0015\u0002\u001b\u0005\u0004&o\u001c9U_Z+'/\u001b4z!\u001dY\u0014QKA-\u00033J1!a\u0016=\u0005\u0019!V\u000f\u001d7feA!\u00111LA5\u001d\u0011\ti&!\u001a\u0011\u0007\u0005}C(\u0004\u0002\u0002b)\u0019\u00111\r\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t9\u0007P\u0001\u0007!J,G-\u001a4\n\u0007%\u000bYGC\u0002\u0002hq\na#\u001e9eCR,\u0017\n]\"p]:,7\r^5p]J\u000bG/\u001a\u000b\u0006g\u0006E\u00141\u0010\u0005\b\u0003gB\u0002\u0019AA;\u0003\tI\u0007\u000fE\u0003<\u0003o\nI&C\u0002\u0002zq\u0012aa\u00149uS>t\u0007BBA?1\u0001\u0007!(A\u0006va\u0012\fG/\u001a3SCR,\u0017aD<bSR4uN\u001d'jgR,g.\u001a:\u0015\u0007M\f\u0019\tC\u0004\u0002\u0006f\u0001\r!!\u0017\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002\fB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!B1e[&t'bAAK%\u000691\r\\5f]R\u001c\u0018\u0002BAM\u0003\u001f\u0013Q!\u00113nS:\fQc^1ji\u001a{'oQ8oM&<wJ\\*feZ,'\u000fF\u0004t\u0003?\u000b\u0019+a*\t\u000f\u0005\u00056\u00041\u0001\u0002Z\u0005A\u0001O]8q\u001d\u0006lW\rC\u0004\u0002&n\u0001\r!!\u0017\u0002\u0013A\u0014x\u000e\u001d,bYV,\u0007\"CAU7A\u0005\t\u0019AAV\u0003%i\u0017\r_,bSRl5\u000fE\u0002<\u0003[K1!a,=\u0005\u0011auN\\4\u0002?]\f\u0017\u000e\u001e$pe\u000e{gNZ5h\u001f:\u001cVM\u001d<fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00026*\"\u00111VA\\W\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\u0013Ut7\r[3dW\u0016$'bAAby\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00049s_\u0012,8-\u001a*fcV,7\u000f^\u000b\u0003\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\u0004\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0017\u0011\u001b\u0002\u000f!J|G-^2f%\u0016\fX/Z:u\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\u0018aB2p]:,7\r\u001e\u000b\u0005\u0003?\f)\u000fE\u0002^\u0003CL1!a9_\u0005\u0019\u0019vnY6fi\"11j\ba\u0001\u00033\n\u0011d\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]R\u00191/a;\t\u0011-\u0003\u0003\u0013!a\u0001\u00033\n1e\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r*\"\u0011\u0011LA\\\u0003A1XM]5gs\u000e{gN\\3di&|g\u000eF\u0002t\u0003oDq!!?#\u0001\u0004\ty.\u0001\u0004t_\u000e\\W\r^\u0001\u0015m\u0016\u0014\u0018NZ=NCb\u001cuN\u001c8fGRLwN\\:\u0015\u000bM\fyPa\u0001\t\r\t\u00051\u00051\u0001;\u00039i\u0017\r_\"p]:,7\r^5p]NDqA!\u0002$\u0001\u0004\u00119!\u0001\nd_:tWm\u0019;XSRDg)Y5mkJ,\u0007\u0003B\u001e\u0003\nML1Aa\u0003=\u0005%1UO\\2uS>t\u0007'\u0001\td_:tWm\u0019;B]\u00124VM]5gsR1\u0011\u0011\nB\t\u0005'Aaa\u0013\u0013A\u0002\u0005e\u0003b\u0002B\u000bI\u0001\u0007\u0011\u0011J\u0001\u0013S\u001etwN]3J\u001f\u0016C8-\u001a9uS>t7/\u0001\fxC&$hi\u001c:D_:tWm\u0019;j_:\u001cu.\u001e8u)\r\u0019(1\u0004\u0005\u0007\u0005;)\u0003\u0019\u0001\u001e\u0002/\u0015D\b/Z2uK\u0012\u001cuN\u001c8fGRLwN\\\"pk:$\u0018\u0001\u0006<fe&4\u0017pQ8o]\u0016\u001cG/[8o%\u0006$X\rF\u0005t\u0005G\u00119Ca\u000b\u0003.!1!Q\u0005\u0014A\u0002i\n\u0011#\\5o\u0007>tg.Z2uS>t'+\u0019;f\u0011\u0019\u0011IC\na\u0001u\u0005\tR.\u0019=D_:tWm\u0019;j_:\u0014\u0016\r^3\t\r-3\u0003\u0019AA-\u0011\u001d\u0011)B\na\u0001\u0003\u0013\u0002")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final String unknownHost;
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public String unknownHost() {
        return this.unknownHost;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), "1");
        properties.put("listener.name.plaintext.max.connection.creation.rate", Integer.toString(this.plaintextListenerDefaultQuota()));
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assertions.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIP - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicListenerConnectionQuota() {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$1 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        conns = (IndexedSeq)conns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$2 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        conns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        IndexedSeq plaintextConnections = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable & scala.Serializable)x$4 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection(this.createAndVerifyConnection$default$1()));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        IndexedSeq plaintextConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$6 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq internalConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$7 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom());
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable & scala.Serializable)x$8 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l18 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$20());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IOException.class, () -> internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))));
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        long l19 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l20 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$27());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicListenerConnectionCreationRateQuota() {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("EXTERNAL");
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(connRateLimit));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), (Object)Integer.toString(connRateLimit)));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL", false);
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        props.put(new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(listenerConnRateLimit));
        props.put(plaintextListenerProp, Integer.toString(listenerConnRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(listenerConnRateLimit)));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((Seq)newListenerNames.map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener, false)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, Integer.toString(newPlaintextRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(newPlaintextRateLimit)));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT", false));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL", false));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    @Test
    public void testDynamicIpConnectionRateQuota() {
        int connRateLimit = 10;
        int initialConnectionCount = this.connectionCount();
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.updateIpConnectionRate((Option<String>)None$.MODULE$, connRateLimit);
        this.verifyConnectionRate(8, connRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
        int newRateLimit = 18;
        this.updateIpConnectionRate((Option<String>)new Some((Object)this.localAddress().getHostAddress()), newRateLimit);
        this.verifyConnectionRate(14, newRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        try (Admin adminClient = this.createAdminClient();){
            TestUtils$.MODULE$.incrementalAlterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig, TestUtils$.MODULE$.incrementalAlterConfigs$default$5()).all().get();
            this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateIpConnectionRate(Option<String> ip, int updatedRate) {
        int initialConnectionCount = this.connectionCount();
        try (Admin adminClient = this.createAdminClient();){
            ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), ip.orNull(Predef$.MODULE$.$conforms()))}))).asJava());
            scala.collection.immutable.Map request = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)updatedRate)))})))}));
            TestUtils$.MODULE$.alterClientQuotas(adminClient, (Map<ClientQuotaEntity, Map<String, Option<Object>>>)request).all().get();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$1(this, ip, updatedRate)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$4(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$5(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForListener(String listenerName) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    private ProduceRequest produceRequest() {
        return (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(this.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}))))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> connectWithFailure.apply$mcV$sp());
        ((Socket)conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean connectAndVerify(String listener, boolean ignoreIOExceptions) {
        boolean bl;
        try (Socket socket = this.connect(listener);){
            try {
                this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                bl = true;
            }
            catch (IOException e) {
                if (!ignoreIOExceptions) {
                    throw e;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener, boolean ignoreIOExceptions) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            if (!this.connectAndVerify(listener, ignoreIOExceptions)) continue;
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : (double)Integer.MAX_VALUE;
        Assertions.assertTrue((actualRate <= rateCap ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be below ").append(rateCap).toString());
        Assertions.assertTrue((actualRate >= (double)minConnectionRate ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be above ").append(minConnectionRate).toString());
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$2).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$1(DynamicConnectionQuotaTest $this, Option ip$1, int updatedRate$1) {
        return ((KafkaServer)$this.servers().head()).socketServer().connectionQuotas().connectionRateForIp(InetAddress.getByName((String)ip$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.unknownHost()))) == updatedRate$1;
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$3() {
        return "Timed out waiting for connection rate update to propagate";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$4(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$5(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$3).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assertions.assertTrue((((KafkaServer)$this.servers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaServer)$this.servers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$5(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$6() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$8(DynamicConnectionQuotaTest $this, int initialConnectionCount$4) {
        return initialConnectionCount$4 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$9() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return new StringBuilder(47).append("Connections not closed (expected = ").append(expectedConnectionCount$1).append(" current = ").append($this.connectionCount()).append(")").toString();
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.unknownHost = "255.255.0.1";
        this.plaintextListenerDefaultQuota = 30;
    }
}

