/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import kafka.network.PrincipalConvertToJson$;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogAction;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0002\rBQ\u0001\u000e\u0001\u0005\u0002\rBQA\u000e\u0001\u0005\u0002\rBQ\u0001\u000f\u0001\u0005\u0002\rBQA\u000f\u0001\u0005\u0002\rBQ\u0001\u0010\u0001\u0005\u0002\rBQA\u0010\u0001\u0005\u0002\rBQ\u0001\u0011\u0001\u0005\u0002\rBQA\u0011\u0001\u0005\u0002\rBQ\u0001\u0012\u0001\u0005\n\u0015CQ!\u0016\u0001\u0005\nYCQA\u001a\u0001\u0005\n\u001dDQ!\u001c\u0001\u0005\n9DQ\u0001 \u0001\u0005\u0002uDq!a\u0007\u0001\t\u0013\tiB\u0001\rSKF,Xm\u001d;D_:4XM\u001d;U_*\u001bxN\u001c+fgRT!a\u0005\u000b\u0002\u000f9,Go^8sW*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002%\u0005QB/Z:u\u00032d'+Z9vKN$H+\u001f9fg\"\u000bg\u000e\u001a7fIR\tA\u0005\u0005\u0002\u001aK%\u0011aE\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0003QA\u0011\u0011FM\u0007\u0002U)\u00111\u0006L\u0001\u0004CBL'BA\u0017/\u0003\u001dQW\u000f]5uKJT!a\f\u0019\u0002\u000b),h.\u001b;\u000b\u0003E\n1a\u001c:h\u0013\t\u0019$F\u0001\u0003UKN$\u0018a\u0007;fgR\fE\u000e\u001c*fgB|gn]3UsB,7\u000fS1oI2,G\r\u000b\u0002\u0004Q\u0005)B/Z:u%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:O_\u0012,\u0007F\u0001\u0003)\u0003I!Xm\u001d;DY&,g\u000e^%oM>tu\u000eZ3)\u0005\u0015A\u0013a\u0004;fgR\u0014V-];fgR$Um]2)\u0005\u0019A\u0013A\u0006;fgR\u0014V-];fgR$Um]2NKR\u0014\u0018nY:)\u0005\u001dA\u0013\u0001\t;fgR\\\u0015MZ6b!JLgnY5qC2T5o\u001c8D_:4XM]:j_:D#\u0001\u0003\u0015\u0002IQ,7\u000f^\"p]\u001adW/\u001a8u!JLgnY5qC2T5o\u001c8D_:4XM]:j_:D#!\u0003\u0015\u0002CQ,7\u000f\u001e+f]\u0006tG\u000f\u0015:j]\u000eL\u0007/\u00197Kg>t7i\u001c8wKJ\u001c\u0018n\u001c8)\u0005)A\u0013aE1tg\u0016\u0014H\u000f\u0015:j]\u000eL\u0007/\u00197Kg>tGC\u0001\u0013G\u0011\u001595\u00021\u0001I\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0002J'6\t!J\u0003\u0002L\u0019\u0006!\u0011-\u001e;i\u0015\tie*\u0001\u0005tK\u000e,(/\u001b;z\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003+ES!A\u0015\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!&J\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u00021\u0005\u001c8/\u001a:u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0015N|g\u000eF\u0002%/bCQa\u0012\u0007A\u0002!CQ!\u0017\u0007A\u0002i\u000bAA[:p]B\u00111\fZ\u0007\u00029*\u0011QLX\u0001\tI\u0006$\u0018MY5oI*\u0011q\fY\u0001\bU\u0006\u001c7n]8o\u0015\t\t'-A\u0005gCN$XM\u001d=nY*\t1-A\u0002d_6L!!\u001a/\u0003\u0011)\u001bxN\u001c(pI\u0016\fA$Y:tKJ$8i\u001c8gYV,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0015N|g\u000eF\u0002%Q2DQaR\u0007A\u0002%\u0004\"!\u00136\n\u0005-T%AE\"p]\u001adW/\u001a8u!JLgnY5qC2DQ!W\u0007A\u0002i\u000b\u0011$Y:tKJ$H+\u001a8b]R\u0004&/\u001b8dSB\fGNS:p]R\u0019Ae\\>\t\u000b\u001ds\u0001\u0019\u00019\u0011\u0005ELX\"\u0001:\u000b\u0005M$\u0018aC7vYRLG/\u001a8b]RT!!F;\u000b\u0005Y<\u0018!C2p]\u001adW/\u001a8u\u0015\u0005A\u0018AA5p\u0013\tQ(O\u0001\u000bNk2$\u0018\u000eV3oC:$\bK]5oG&\u0004\u0018\r\u001c\u0005\u00063:\u0001\rAW\u0001\be\u0016\fX/Z:u)\rq\u00181\u0002\t\u0004\u007f\u0006\u0015abA\u0011\u0002\u0002%\u0019\u00111\u0001\n\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011qAA\u0005\u0005\u001d\u0011V-];fgRT1!a\u0001\u0013\u0011\u001d\tia\u0004a\u0001\u0003\u001f\t1A]3r!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b\u001d\u0006A!/Z9vKN$8/\u0003\u0003\u0002\u001a\u0005M!aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002#9,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0003\u0002 \u0005\u0015\u0002\u0003BA\t\u0003CIA!a\t\u0002\u0014\tq!+Z9vKN$8i\u001c8uKb$\bbBA\u0014!\u0001\u0007\u0011\u0011F\u0001\u0007EV4g-\u001a:\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005\u0019a.[8\u000b\u0005\u0005M\u0012\u0001\u00026bm\u0006LA!a\u000e\u0002.\tQ!)\u001f;f\u0005V4g-\u001a:")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            Object object = ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)object, (short)version);
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes, (MessageContext)MessageContext.IDENTITY).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)ApiMessageType.fromApiKey((short)key.id).newResponse(), (short)version);
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)version, (MessageContext)MessageContext.IDENTITY);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int temporaryMemoryBytes = 8;
        int messageConversionsTimeMs = 9;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, LogAction.LOGGED);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testKafkaPrincipalJsonConversion() {
        this.assertPrincipalJson(KafkaPrincipal.ANONYMOUS);
        this.assertPrincipalJson(new KafkaPrincipal("User", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("User", "userbar", true));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userbar", false));
    }

    @Test
    public void testConfluentPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userfoo", "authfoo"));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("group", "userbar", "authfoo", false));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userbar", "authfoo", true));
    }

    @Test
    public void testTenantPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(RequestConvertToJsonTest.tenantMetadata$default$1$1(), RequestConvertToJsonTest.tenantMetadata$default$2$1(), RequestConvertToJsonTest.tenantMetadata$default$3$1(), RequestConvertToJsonTest.tenantMetadata$default$4$1())));
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1("clusterbar", RequestConvertToJsonTest.tenantMetadata$default$2$1(), RequestConvertToJsonTest.tenantMetadata$default$3$1(), RequestConvertToJsonTest.tenantMetadata$default$4$1())));
        String x$1 = "envbar";
        String x$2 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$3 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        boolean x$4 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$2, x$3, x$1, x$4)));
        String x$5 = "orgbar";
        String x$6 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$7 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        boolean x$8 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$6, x$5, x$7, x$8)));
        boolean x$9 = true;
        String x$10 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$11 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        String x$12 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$10, x$11, x$12, x$9)));
    }

    private void assertPrincipalJson(KafkaPrincipal principal) {
        JsonNode jsonNode = PrincipalConvertToJson$.MODULE$.convert(principal);
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            this.assertTenantPrincipalJson(multiTenantPrincipal, jsonNode);
            return;
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            this.assertConfluentPrincipalJson(confluentPrincipal, jsonNode);
            return;
        }
        if (principal != null) {
            this.assertKafkaPrincipalJson(principal, jsonNode);
            return;
        }
        throw new MatchError(null);
    }

    private void assertKafkaPrincipalJson(KafkaPrincipal principal, JsonNode json) {
        Assertions.assertEquals((Object)principal.getClass().getSimpleName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalClassKey()).textValue());
        Assertions.assertEquals((Object)principal.getPrincipalType(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalTypeKey()).textValue());
        Assertions.assertEquals((Object)principal.getName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalNameKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tokenAuthenticated()), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.TokenAuthenticatedKey()).booleanValue()));
    }

    private void assertConfluentPrincipalJson(ConfluentPrincipal principal, JsonNode json) {
        this.assertKafkaPrincipalJson((KafkaPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.authenticationId(), (Object)json.get(PrincipalConvertToJson$.MODULE$.AuthenticationIdKey()).textValue());
    }

    private void assertTenantPrincipalJson(MultiTenantPrincipal principal, JsonNode json) {
        this.assertConfluentPrincipalJson((ConfluentPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.user(), (Object)json.get(PrincipalConvertToJson$.MODULE$.UserKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().tenantName, (Object)json.get(PrincipalConvertToJson$.MODULE$.TenantNameKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().clusterId, (Object)json.get(PrincipalConvertToJson$.MODULE$.ClusterIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().organizationId, (Object)json.get(PrincipalConvertToJson$.MODULE$.OrganizationIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().environmentId, (Object)json.get(PrincipalConvertToJson$.MODULE$.EnvironmentIdKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isSuperUser), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsSuperUserKey()).booleanValue()));
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)EasyMock.createNiceMock(MemoryPool.class), buffer, (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    private static final TenantMetadata tenantMetadata$1(String clusterId, String organizationId, String environmentId, boolean isSuperUser) {
        return new TenantMetadata.Builder(clusterId, null).organizationId(organizationId).environmentId(environmentId).superUser(isSuperUser).build();
    }

    private static final String tenantMetadata$default$1$1() {
        return "clusterfoo";
    }

    private static final String tenantMetadata$default$2$1() {
        return "orgfoo";
    }

    private static final String tenantMetadata$default$3$1() {
        return "envfoo";
    }

    private static final boolean tenantMetadata$default$4$1() {
        return false;
    }
}

