/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.Log$;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.SegmentDeletion$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002 @\u0005\u0011CQa\u0013\u0001\u0005\u00021C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001)\t\u0013e\u0003\u0001\u0019!a\u0001\n\u0003Q\u0006\"\u00031\u0001\u0001\u0004\u0005\t\u0015)\u0003R\u0011\u001d\t\u0007A1A\u0005\u0002\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0007q\u0002\u0001\u000b\u0011\u00027\t\u000be\u0004A\u0011\u0001>\t\r\u00055\u0001\u0001\"\u0001{\u0011\u0019\t9\u0002\u0001C\u0001u\"1\u0011\u0011\u0005\u0001\u0005\u0002iDa!!\n\u0001\t\u0003Q\bBBA\u0015\u0001\u0011\u0005!\u0010\u0003\u0004\u0002.\u0001!\tA\u001f\u0005\u0007\u0003c\u0001A\u0011\u0001>\t\r\u0005U\u0002\u0001\"\u0001{\u0011\u0019\tI\u0004\u0001C\u0001u\"1\u0011Q\b\u0001\u0005\u0002iDa!!\u0011\u0001\t\u0003Q\bBBA#\u0001\u0011\u0005!\u0010\u0003\u0004\u0002J\u0001!\tA\u001f\u0005\u0007\u0003\u001b\u0002A\u0011\u0001>\t\r\u0005E\u0003\u0001\"\u0001{\u0011\u0019\t)\u0006\u0001C\u0001u\"1\u0011\u0011\f\u0001\u0005\u0002iDa!!\u0018\u0001\t\u0003Q\bBBA1\u0001\u0011\u0005!\u0010\u0003\u0004\u0002f\u0001!\tA\u001f\u0005\u0007\u0003S\u0002A\u0011\u0001>\t\r\u00055\u0004\u0001\"\u0001{\u0011\u0019\t\t\b\u0001C\u0001u\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004BBAL\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\u001c\u0002!\tA\u001f\u0005\u0007\u0003?\u0003A\u0011\u0001>\t\r\u0005\r\u0006\u0001\"\u0001{\u0011\u0019\t9\u000b\u0001C\u0001u\"1\u00111\u0016\u0001\u0005\u0002iDa!a,\u0001\t\u0003Q\bBBAZ\u0001\u0011\u0005!\u0010\u0003\u0004\u00028\u0002!\tA\u001f\u0005\u0007\u0003w\u0003A\u0011\u0001>\t\r\u0005}\u0006\u0001\"\u0001{\u0011\u0019\t\u0019\r\u0001C\u0001u\u001a1\u0011q\u0019\u0001\u0001\u0003\u0013Daa\u0013\u0018\u0005\u0002\u0005U\bbBAI]\u0011\u0005\u00131 \u0005\b\u0005#qC\u0011\tB\n\u0011\u001d\u0011\u0019C\fC!\u0005KA\u0011B!\u000e\u0001\u0005\u0004%\tAa\u000e\t\u0011\t}\u0002\u0001)A\u0005\u0005sAqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0005\u0003n\u0001\t\n\u0011\"\u0001\u0003p!I!Q\u0011\u0001\u0012\u0002\u0013\u0005!q\u0011\u0005\b\u0005\u0017\u0003A\u0011\u0001BG\u0011%\u00119\nAI\u0001\n\u0003\u0011y\u0007C\u0005\u0003\u001a\u0002\t\n\u0011\"\u0001\u0003\b\"9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002BN\u0001\u0011\u0005!1\u0018\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0005QY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rV3ti*\u0011\u0001)Q\u0001\u0005e\u00064GOC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A#\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0005\u0002O\u00015\tq(A\u0004uK6\u0004H)\u001b:\u0016\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u0005%|'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013AAR5mK\u0006YA/Z7q\t&\u0014x\fJ3r)\tYf\f\u0005\u0002G9&\u0011Ql\u0012\u0002\u0005+:LG\u000fC\u0004`\u0007\u0005\u0005\t\u0019A)\u0002\u0007a$\u0013'\u0001\u0005uK6\u0004H)\u001b:!\u0003!iwnY6US6,W#A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\f\u0015!B;uS2\u001c\u0018B\u00015f\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u001c\t\u0003[Zl\u0011A\u001c\u0006\u0003U>T!\u0001]9\u0002\r\r|W.\\8o\u0015\t\u0011%O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<o\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00027\"\u0012\u0011\u0002 \t\u0004{\u0006%Q\"\u0001@\u000b\u0007}\f\t!A\u0002ba&TA!a\u0001\u0002\u0006\u00059!.\u001e9ji\u0016\u0014(bAA\u0004i\u0006)!.\u001e8ji&\u0019\u00111\u0002@\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rQ\u0011\u0011\u0003\t\u0004{\u0006M\u0011bAA\u000b}\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cHoQ8oM&<\u0007fA\u0006\u0002\u001cA\u0019Q0!\b\n\u0007\u0005}aP\u0001\u0003UKN$\u0018A\u0007;fgR,f.\u001a=qK\u000e$X\rZ!qa\u0016tGm\u00144gg\u0016$\bf\u0001\u0007\u0002\u001c\u0005\u0011B/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8uQ\ri\u00111D\u0001 i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GO\u0012:p[\u0016sGm\u00144gg\u0016$\bf\u0001\b\u0002\u001c\u0005AC/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u0019\u0006$XM\u001d+iC:D\u0015n\u001a5XCR,'/\\1sW\"\u001aq\"a\u0007\u0002AQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^'vG\"d\u0015\r^3s\u000bB|7\r\u001b\u0015\u0004!\u0005m\u0011A\n;fgR\u001c%/Z1uKNs\u0017\r]:i_R\u0014UMZ8sK2{wm\u0015;beR|eMZ:fi\"\u001a\u0011#a\u0007\u0002AQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e#jm\u0016\u0014x-\u001b8h\u000bB|7\r\u001b\u0015\u0004%\u0005m\u0011\u0001\b;fgR\u001c%/Z1uKNs\u0017\r]:i_R|E\u000eZ3s\u000bB|7\r\u001b\u0015\u0004'\u0005m\u0011A\t;fgR\u001c%/Z1uKNs\u0017\r]:i_R<\u0016\u000e\u001e5NSN\u001c\u0018N\\4Fa>\u001c\u0007\u000eK\u0002\u0015\u00037\t!\u0004^3ti\u000e\u0013X-\u0019;f\u000bbL7\u000f^5oONs\u0017\r]:i_RD3!FA\u000e\u0003-!Xm\u001d;U_BL7-\u00133)\u0007Y\tY\"A\fuKN$(+Z1e\u001b&\u001c8/\u001b8h':\f\u0007o\u001d5pi\"\u001aq#a\u0007\u0002;Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^3oiNs\u0017\r]:i_RD3\u0001GA\u000e\u0003\u0005\"Xm\u001d;UeVt7-\u0019;f\rVdG.\u001f+p\u0019\u0006$Xm\u001d;T]\u0006\u00048\u000f[8uQ\rI\u00121D\u0001$i\u0016\u001cH\u000f\u0016:v]\u000e\fG/Z,jY2\u0014V-\\8wK>cG-\u001a:T]\u0006\u00048\u000f[8uQ\rQ\u00121D\u0001\u0018i\u0016\u001cH\u000fR8fg:$HK];oG\u0006$XMR;mYfD3aGA\u000e\u0003m!Xm\u001d;DY\u0016\fg.\u001e9QCJ$\u0018.\u00197T]\u0006\u00048\u000f[8ug\"\u001aA$a\u0007\u00023Q,7\u000f^\"mK\u0006tW\u000f](mI\u0016\u00148K\\1qg\"|Go\u001d\u0015\u0004;\u0005m\u0011!\n;fgR\u001c%/Z1uKJ+\u0007\u000f\\5dCR,G\rT8h)J,hnY1uKN4U\u000f\u001c7zQ\rq\u00121D\u0001\u0011i\u0016\u001cH/T1y\u0005\u0006$8\r[*ju\u0016D3aHA\u000e\u0003y!Xm\u001d;UeVt7-\u0019;f\u0005\u0016dwn\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eK\u0002!\u00037\taBY;jY\u00124U\u000f\u001c7CCR\u001c\u0007\u000e\u0006\u0005\u0002z\u0005\u0015\u0015qRAJ!\u0011\tY(!!\u000e\u0005\u0005u$bAA@_\u00061!/Z2pe\u0012LA!a!\u0002~\tiQ*Z7pef\u0014VmY8sINDq!a\"\"\u0001\u0004\tI)A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001$\u0002\f&\u0019\u0011QR$\u0003\u0007%sG\u000fC\u0004\u0002\u0012\u0006\u0002\r!!#\u0002\u0015I,7m\u001c:e'&TX\rC\u0004\u0002\u0016\u0006\u0002\r!!#\u0002'5\f\u0007PQ1uG\"\u001c\u0016N_3J]\nKH/Z:\u0002UQ,7\u000f\u001e,bY&$\u0017\r^3Fa>\u001c\u0007n\u0012:fCR,'\u000f\u00165b]2\u000b7\u000f^&o_^tW\t]8dQ\"\u001a!%a\u0007\u0002YQ,7\u000f\u001e,bY&$\u0017\r^3Fa>\u001c\u0007\u000eT3tgRC\u0017M\\(mI\u0016\u001cHo\u00158baNDw\u000e^#q_\u000eD\u0007fA\u0012\u0002\u001c\u0005qC/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u0019\u0016\u001c8\u000f\u00165b]>cG-Z:u':\f\u0007o\u001d5pi>3gm]3uQ\r!\u00131D\u0001.i\u0016\u001cHOV1mS\u0012\fG/Z(gMN,G/R9vC2$vn\u00147eKN$8K\\1qg\"|Go\u00144gg\u0016$\bfA\u0013\u0002\u001c\u0005\u0011E/Z:u-\u0006d\u0017\u000eZ1uKVs7N\\8x]\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\u0019\u0006\u001cHo\u00138po:<%/Z1uKJ$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;)\u0007\u0019\nY\"\u0001\u0015uKN$h+\u00197jI\u0006$X-\u00129pG\"dUm]:UQ\u0006tg)\u001b:ti\u0016\u0003xn\u00195J]2{w\rK\u0002(\u00037\tA\u0005^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi\u001e\u0013X-\u0019;UQ\u0006tWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004Q\u0005m\u0011!\b;fgR4\u0016\r\\5eCR,wJ\u001a4tKRdUm]:UQ\u0006tG*R()\u0007%\nY\"A\u0010uKN$h+\u00197jI\u0006$XMV1mS\u0012,\u0005o\\2i\u0003:$wJ\u001a4tKRD3AKA\u000e\u0003\u0019\"Xm\u001d;BIZ\fgnY3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'o\u00117fC:Lgn\u001a\u0015\u0004W\u0005m\u0011a\u0005;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c\bf\u0001\u0017\u0002\u001c\u00051B/Z:u'>4GOU3uK:$\u0018n\u001c8MS6LG\u000fK\u0002.\u00037\u0011aBQ=uK\u0006\u0013(/Y=TKJ$WmE\u0003/\u0003\u0017\f9\u000e\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\t.V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002V\u0006='AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002Z\u0006\u0015\u0018\u0011^\u0007\u0003\u00037TA!!8\u0002`\u0006i1/\u001a:jC2L'0\u0019;j_:T1\u0001]Aq\u0015\r\t\u0019/]\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u001d\u00181\u001c\u0002\f%\u0016\u001cwN\u001d3TKJ$W\rE\u0003G\u0003W\fy/C\u0002\u0002n\u001e\u0013Q!\u0011:sCf\u00042ARAy\u0013\r\t\u0019p\u0012\u0002\u0005\u0005f$X\r\u0006\u0002\u0002xB\u0019\u0011\u0011 \u0018\u000e\u0003\u0001!b!!#\u0002~\n\u0005\u0001bBA\u0000a\u0001\u0007\u0011\u0011^\u0001\u0005I\u0006$\u0018\rC\u0004\u0003\u0004A\u0002\rA!\u0002\u0002%M,'/[1mSj\fG/[8o\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1B8\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0004\u0003\n\tArJ\u00196fGR\u001cVM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000fm\u0013)Ba\u0006\u0003\u001a!9\u0011q`\u0019A\u0002\u0005%\bb\u0002B\u0002c\u0001\u0007!Q\u0001\u0005\b\u00057\t\u0004\u0019\u0001B\u000f\u0003\ryW\u000f\u001e\t\u0005\u0005\u000f\u0011y\"\u0003\u0003\u0003\"\t%!\u0001C,sSR\f'\r\\3\u0002\tI,\u0017\r\u001a\u000b\u0007\u0003S\u00149C!\r\t\u000f\t%\"\u00071\u0001\u0003,\u0005)\u0011N\u001c9viB!!q\u0001B\u0017\u0013\u0011\u0011yC!\u0003\u0003\u0011I+\u0017\rZ1cY\u0016DqAa\r3\u0001\u0004\tI)\u0001\u0003tSj,\u0017\u0001\u0007#fM\u0006,H\u000e^'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jOV\u0011!\u0011\b\t\u0004\u001d\nm\u0012b\u0001B\u001f\u007f\t\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u00023\u0011+g-Y;mi6+G/\u00193bi\u0006dunZ\"p]\u001aLw\rI\u0001\u0017EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e\fe\u000e\u001a#jeRQ!Q\tB1\u0005G\u00129Ga\u001b\u0011\u0013\u0019\u00139Ea\u0013\u0003\\\te\u0012b\u0001B%\u000f\n1A+\u001e9mKN\u0002BA!\u0014\u0003X5\u0011!q\n\u0006\u0005\u0005#\u0012\u0019&\u0001\u0003gS2,'b\u0001B++\u0006\u0019a.[8\n\t\te#q\n\u0002\u0005!\u0006$\b\u000eE\u0002O\u0005;J1Aa\u0018@\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rC\u0003Pk\u0001\u0007\u0011\u000b\u0003\u0004\u0003fU\u0002\raY\u0001\u0005i&lW\rC\u0005\u0003jU\u0002\n\u00111\u0001\u0003:\u0005\tR.\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\t\u000f),\u0004\u0013!a\u0001Y\u0006\u0001#-^5mI6+G/\u00193bi\u0006dunZ!oI\u0012K'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tH\u000b\u0003\u0003:\tM4F\u0001B;!\u0011\u00119H!!\u000e\u0005\te$\u0002\u0002B>\u0005{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}t)\u0001\u0006b]:|G/\u0019;j_:LAAa!\u0003z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002A\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><\u0017I\u001c3ESJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0013S3\u0001\u001cB:\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0006\u0003\\\t=%\u0011\u0013BJ\u0005+CQa\u0014\u001dA\u0002ECaA!\u001a9\u0001\u0004\u0019\u0007\"\u0003B5qA\u0005\t\u0019\u0001B\u001d\u0011\u001dQ\u0007\b%AA\u00021\f!DY;jY\u0012lU\r^1eCR\fGj\\4%I\u00164\u0017-\u001e7uIM\n!DY;jY\u0012lU\r^1eCR\fGj\\4%I\u00164\u0017-\u001e7uIQ\na!\u00199qK:$G\u0003\u0003BP\u0005S\u0013\u0019La.\u0011\t\t\u0005&QU\u0007\u0003\u0005GS!\u0001Q9\n\t\t\u001d&1\u0015\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\t-6\b1\u0001\u0003.\u0006\u0019An\\4\u0011\t\t\u0005&qV\u0005\u0005\u0005c\u0013\u0019KA\u0007SKBd\u0017nY1uK\u0012dun\u001a\u0005\b\u0005k[\u0004\u0019AAE\u0003=qW/\u001c2fe>3'+Z2pe\u0012\u001c\bb\u0002B]w\u0001\u0007\u0011\u0011R\u0001\u0006KB|7\r\u001b\u000b\u00067\nu&Q\u001a\u0005\b\u0005\u007fc\u0004\u0019\u0001Ba\u00039\u0019h.\u00199tQ>$xK]5uKJ\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0004\u0005\u000f\f\u0018\u0001C:oCB\u001c\bn\u001c;\n\t\t-'Q\u0019\u0002\u0012%\u0006<8K\\1qg\"|Go\u0016:ji\u0016\u0014\bb\u0002B[y\u0001\u0007\u0011\u0011R\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010F\u0003R\u0005'\u00149\u000e\u0003\u0004\u0003Vv\u0002\r!U\u0001\u0007Y><G)\u001b:\t\u000f\teW\b1\u0001\u0003\\\u0006QAn\\4ESJt\u0015-\\3\u0011\t\tu'1\u001e\b\u0005\u0005?\u00149\u000fE\u0002\u0003b\u001ek!Aa9\u000b\u0007\t\u00158)\u0001\u0004=e>|GOP\u0005\u0004\u0005S<\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003n\n=(AB*ue&twMC\u0002\u0003j\u001e\u0003")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private final MetadataLogConfig DefaultMetadataLogConfig = new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, Defaults$.MODULE$.FileDeleteDelayMs(), 1);

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
        this.metrics().close();
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList((Object[])new String[]{"broker"}));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.buildMetadataLog$default$4());
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.buildMetadataLog$default$4());
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        this.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset(snapshotId.offset - 1L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset - 2L, snapshotId.epoch)));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$1.offset, snapshotId$1.epoch - 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotOlderEpoch() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId$2.offset, snapshotId$2.epoch - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        this.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateExistingSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 10;
        int epoch = 0;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateFullyToLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset, (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        this.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        this.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertNotEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        Assertions.assertTrue((boolean)log2.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        log2.close();
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDoesntTruncateFully() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void resource_resource;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig cfr_ignored_0 = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.flush();
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$4 -> x$4.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.buildMetadataLogAndDir$default$3(), this.buildMetadataLogAndDir$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        this.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        this.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$6 -> x$6.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch, (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset, (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = this.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = this.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = this.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = this.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = this.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = this.DefaultMetadataLogConfig().copy$default$7();
        int x$8 = this.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = this.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9), this.buildMetadataLog$default$4());
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numRecords = 10;
        int epoch = 5;
        this.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset((long)offset, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 1);
        this.append((ReplicatedLog)log, numOfRecords, 2);
        this.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.buildMetadataLog$default$3(), this.buildMetadataLog$default$4());
        int numberOfRecords = 5;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, this.DefaultMetadataLogConfig().maxFetchSizeInBytes(), Defaults$.MODULE$.FileDeleteDelayMs(), 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource2;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(this, rawSnapshotWriter);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(this, rawSnapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            void resource_resource;
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(this, rawSnapshotWriter);
            }
            finally {
                resource_resource.close();
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.buildMetadataLog$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource2;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(this, rawSnapshotWriter);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(this, rawSnapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public MetadataLogConfig DefaultMetadataLogConfig() {
        return this.DefaultMetadataLogConfig;
    }

    public Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        File logDir = this.createLogDirectory(tempDir, Log$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition()));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), logDir, (Time)time, metrics, (Scheduler)time.scheduler(), metadataLogConfig);
        return new Tuple3((Object)logDir.toPath(), (Object)metadataLog, (Object)metadataLogConfig);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        void var6_6;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(tempDir, time, metadataLogConfig, metrics);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        return var6_6;
    }

    public MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLogAndDir$default$4() {
        return this.metrics();
    }

    public MetadataLogConfig buildMetadataLog$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLog$default$4() {
        return this.metrics();
    }

    public LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return log.appendAsLeader((Records)MemoryRecords.withRecords((long)log.endOffset().offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(epoch), (SimpleRecord[])((SimpleRecord[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable & scala.Serializable)number -> KafkaMetadataLogTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)number)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), epoch);
    }

    public void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        snapshotWriter.append(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable & scala.Serializable)number -> KafkaMetadataLogTest.$anonfun$append$2(BoxesRunTime.unboxToInt((Object)number)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private File createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        if (!Files.exists(dir.toPath(), new LinkOption[0])) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        return dir;
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset, (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$2(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        /*
         * WARNING - void declaration
         */
        public byte[] read(Readable input, int size) {
            void var3_3;
            byte[] array = new byte[size];
            input.readArray(array);
            return var3_3;
        }

        public /* synthetic */ KafkaMetadataLogTest kafka$raft$KafkaMetadataLogTest$ByteArraySerde$$$outer() {
            return KafkaMetadataLogTest.this;
        }

        public ByteArraySerde() {
            if (KafkaMetadataLogTest.this == null) {
                throw null;
            }
        }
    }
}

