/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaNetworkChannelTest$;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0013Y\u0005BB-\u0001A\u0003%A\nC\u0004[\u0001\t\u0007I\u0011B.\t\r\t\u0004\u0001\u0015!\u0003]\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da!\u001b\u0001!\u0002\u0013)\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000bA\u0004A\u0011A9\t\r\u0005\u0005\u0001\u0001\"\u0001r\u0011\u0019\tY\u0001\u0001C\u0001c\"1\u0011q\u0002\u0001\u0005\u0002EDa!a\u0005\u0001\t\u0003\t\bBBA\f\u0001\u0011\u0005\u0011\u000fC\u0004\u0002\u001c\u0001!I!!\b\t\r\u0005\r\u0002\u0001\"\u0001r\u0011\u0019\t9\u0003\u0001C\u0001c\"9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u001e9\u00111U\u0015\t\u0002\u0005\u0015fA\u0002\u0015*\u0011\u0003\t9\u000b\u0003\u00046?\u0011\u0005\u0011\u0011\u0016\u0005\n\u0003W{\"\u0019!C\u0001\u0003[C\u0001\"a/ A\u0003%\u0011q\u0016\u0004\u0007\u0003{{B!a0\t\rU\u001aC\u0011AAv\u0011\u001d\t\tp\tC!\u0003gDqAa\u0002$\t\u0003\u0012I\u0001C\u0004\u0003\u0012\r\"\tEa\u0005\u0003/-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7UKN$(B\u0001\u0016,\u0003\u0011\u0011\u0018M\u001a;\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002\u0013\rdWo\u001d;fe&#W#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u00027b]\u001eT\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t11\u000b\u001e:j]\u001e\f!b\u00197vgR,'/\u00133!\u0003A\u0011X-];fgR$\u0016.\\3pkRl5/F\u0001G!\t\u0001t)\u0003\u0002Ic\t\u0019\u0011J\u001c;\u0002#I,\u0017/^3tiRKW.Z8vi6\u001b\b%\u0001\u0003uS6,W#\u0001'\u0011\u00055;V\"\u0001(\u000b\u0005=\u0003\u0016!B;uS2\u001c(BA)S\u0003\u0019\u0019w.\\7p]*\u0011Af\u0015\u0006\u0003)V\u000ba!\u00199bG\",'\"\u0001,\u0002\u0007=\u0014x-\u0003\u0002Y\u001d\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0004dY&,g\u000e^\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLU\u0001\bG2LWM\u001c;t\u0013\t\tgL\u0001\u0006N_\u000e\\7\t\\5f]R\fqa\u00197jK:$\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003\u0015\u0004\"AZ4\u000e\u0003AK!\u0001\u001b)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\u0004dQ\u0006tg.\u001a7\u0016\u00031\u0004\"\u0001O7\n\u00059L#aE&bM.\fg*\u001a;x_J\\7\t[1o]\u0016d\u0017\u0001C2iC:tW\r\u001c\u0011\u0002%M,G/\u001e9TkB\u0004xN\u001d;fI\u0006\u0003\u0018n\u001d\u000b\u0002eB\u0011\u0001g]\u0005\u0003iF\u0012A!\u00168ji\"\u0012aB\u001e\t\u0003ozl\u0011\u0001\u001f\u0006\u0003sj\f1!\u00199j\u0015\tYH0A\u0004kkBLG/\u001a:\u000b\u0005u,\u0016!\u00026v]&$\u0018BA@y\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001di\u0016\u001cHoU3oIR{WK\\6o_^tG)Z:uS:\fG/[8oQ\ry\u0011Q\u0001\t\u0004o\u0006\u001d\u0011bAA\u0005q\n!A+Z:u\u0003}!Xm\u001d;TK:$Gk\u001c\"mC\u000e\\W\rZ(vi\u0012+7\u000f^5oCRLwN\u001c\u0015\u0004!\u0005\u0015\u0011A\u0006;fgR<\u0016m[3va\u000ec\u0017.\u001a8u\u001f:\u001cVM\u001c3)\u0007E\t)!A\u000buKN$8+\u001a8e\u0003:$G)[:d_:tWm\u0019;)\u0007I\t)!A\u000fuKN$8+\u001a8e\u0003:$g)Y5m\u0003V$\b.\u001a8uS\u000e\fG/[8oQ\r\u0019\u0012QA\u0001\u0019CN\u001cXM\u001d;Ce>\\WM\u001d(pi\u00063\u0018-\u001b7bE2,Gc\u0001:\u0002 !1\u0011\u0011\u0005\u000bA\u0002\u0019\u000bQ\u0002Z3ti&t\u0017\r^5p]&#\u0017!\t;fgR\u001cVM\u001c3B]\u0012\u0014VmY3jm\u0016|U\u000f\u001e2pk:$'+Z9vKN$\bfA\u000b\u0002\u0006\u0005YB/Z:u+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012:s_JD3AFA\u0003\u0003=\u0019XM\u001c3UKN$(+Z9vKN$HCBA\u0018\u0003\u0003\n\t\u0006\u0005\u0003\u00022\u0005mb\u0002BA\u001a\u0003oi!!!\u000e\u000b\u0005)\u0012\u0016\u0002BA\u001d\u0003k\t1BU1giJ+\u0017/^3ti&!\u0011QHA \u0005!yU\u000f\u001e2pk:$'\u0002BA\u001d\u0003kAq!a\u0011\u0018\u0001\u0004\t)%\u0001\u0004ba&\\U-\u001f\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n)\u0002\u0011A\u0014x\u000e^8d_2LA!a\u0014\u0002J\t9\u0011\t]5LKf\u001c\bBBA\u0011/\u0001\u0007a)A\fbgN,'\u000f\u001e*fgB|gn]3D_6\u0004H.\u001a;fIR)!/a\u0016\u0002\\!9\u0011\u0011\f\rA\u0002\u0005=\u0012a\u0002:fcV,7\u000f\u001e\u0005\b\u0003;B\u0002\u0019AA0\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB!\u0011qIA1\u0013\u0011\t\u0019'!\u0013\u0003\r\u0015\u0013(o\u001c:t\u0003i\u0019XM\u001c3B]\u0012\f5o]3si\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u001d\u0011\u0018\u0011NA6\u0003[Bq!a\u0011\u001a\u0001\u0004\t)\u0005\u0003\u0004\u0002\"e\u0001\rA\u0012\u0005\b\u0003_J\u0002\u0019AA0\u0003\u0015)'O]8s\u0003A\u0011W/\u001b7e)\u0016\u001cHOU3rk\u0016\u001cH\u000f\u0006\u0003\u0002v\u0005m\u0004\u0003BA$\u0003oJA!!\u001f\u0002J\tQ\u0011\t]5NKN\u001c\u0018mZ3\t\u000f\u0005u$\u00041\u0001\u0002F\u0005\u00191.Z=\u0002-\t,\u0018\u000e\u001c3UKN$XI\u001d:peJ+7\u000f]8og\u0016$b!!\u001e\u0002\u0004\u0006\u0015\u0005bBA?7\u0001\u0007\u0011Q\t\u0005\b\u0003_Z\u0002\u0019AA0\u00031)\u0007\u0010\u001e:bGR,%O]8s)\u0011\ty&a#\t\u000f\u00055E\u00041\u0001\u0002v\u0005A!/Z:q_:\u001cX-A\u0007ck&dGMU3ta>t7/\u001a\u000b\u0005\u0003'\u000by\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI\nU\u0001\te\u0016\fX/Z:ug&!\u0011QTAL\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0004\u0002\"v\u0001\r!!\u001e\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0002/-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7UKN$\bC\u0001\u001d '\tyr\u0006\u0006\u0002\u0002&\u0006A!+\u00194u\u0003BL7/\u0006\u0002\u00020B1\u0011\u0011WA\\\u0003\u000bj!!a-\u000b\u0007\u0005U\u0016'\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00024\n\u00191+Z9\u0002\u0013I\u000bg\r^!qSN\u0004#aE*uk\nlU\r^1eCR\fW\u000b\u001d3bi\u0016\u00148#B\u0012\u0002B\u0006\u001d\u0007c\u0001\u001f\u0002D&\u0019\u0011QY\u001f\u0003\r=\u0013'.Z2u!\u0011\tI-!:\u000f\t\u0005-\u0017\u0011\u001d\b\u0005\u0003\u001b\fyN\u0004\u0003\u0002P\u0006ug\u0002BAi\u00037tA!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/l\u0013A\u0002\u001fs_>$h(C\u0001W\u0013\t!V+\u0003\u0002-'&\u0011qLU\u0005\u0004\u0003Gt\u0016AC'pG.\u001cE.[3oi&!\u0011q]Au\u0005MiunY6NKR\fG-\u0019;b+B$\u0017\r^3s\u0015\r\t\u0019O\u0018\u000b\u0003\u0003[\u00042!a<$\u001b\u0005y\u0012A\u00034fi\u000eDgj\u001c3fgR\u0011\u0011Q\u001f\t\u0007\u0003o\fiP!\u0001\u000e\u0005\u0005e(bAA~\u007f\u0005!Q\u000f^5m\u0013\u0011\ty0!?\u0003\t1K7\u000f\u001e\t\u0004M\n\r\u0011b\u0001B\u0003!\n!aj\u001c3f\u00039I7/\u00169eCR,g*Z3eK\u0012$\"Aa\u0003\u0011\u0007A\u0012i!C\u0002\u0003\u0010E\u0012qAQ8pY\u0016\fg.\u0001\u0004va\u0012\fG/\u001a\u000b\u0006e\nU!Q\u0004\u0005\u0007\u0015\u001e\u0002\rAa\u0006\u0011\u00075\u0013I\"C\u0002\u0003\u001c9\u0013A\u0001V5nK\"9!\u0011C\u0014A\u0002\t}\u0001\u0003\u0002B\u0011\u0005Gq1!XAq\u0013\u0011\u0011)#!;\u0003\u001d5+G/\u00193bi\u0006,\u0006\u000fZ1uK\u0002")
public class KafkaNetworkChannelTest {
    private final String clusterId;
    private final int requestTimeoutMs;
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time(), (MockClient.MockMetadataUpdater)new StubMetadataUpdater());
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel = new KafkaNetworkChannel((Time)this.time(), (KafkaClient)this.client(), this.requestTimeoutMs(), "test-raft");

    public static Seq<ApiKeys> RaftApis() {
        return KafkaNetworkChannelTest$.MODULE$.RaftApis();
    }

    private String clusterId() {
        return this.clusterId;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel() {
        return this.kafka$raft$KafkaNetworkChannelTest$$channel;
    }

    @BeforeEach
    public void setupSupportedApis() {
        Seq supportedApis = (Seq)KafkaNetworkChannelTest$.MODULE$.RaftApis().map((Function1 & Serializable & scala.Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1), Seq$.MODULE$.canBuildFrom());
        this.client().setNodeApiVersions(NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(supportedApis).asJava())));
    }

    @Test
    public void testSendToUnknownDestination() {
        int destinationId = 2;
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testSendToBlackedOutDestination() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().backoff(destinationNode, 500L);
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testWakeupClientOnSend() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().enableBlockingUntilWakeup(1);
        Thread ioThread = new Thread(this){
            private final /* synthetic */ KafkaNetworkChannelTest $outer;

            public void run() {
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        AbstractResponse response = this.buildResponse(this.buildTestErrorResponse(ApiKeys.FETCH, Errors.INVALID_REQUEST));
        this.client().prepareResponseFrom(response, destinationNode, false);
        ioThread.start();
        RaftRequest.Outbound request = this.sendTestRequest(ApiKeys.FETCH, destinationId);
        ioThread.join();
        this.assertResponseCompleted(request, Errors.INVALID_REQUEST);
    }

    @Test
    public void testSendAndDisconnect() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndDisconnect$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndFailAuthentication() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndFailAuthentication$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private void assertBrokerNotAvailable(int destinationId) {
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.sendAndAssertErrorResponse(apiKey, destinationId, Errors.BROKER_NOT_AVAILABLE);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndReceiveOutboundRequest() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndReceiveOutboundRequest$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUnsupportedVersionError() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testUnsupportedVersionError$1(this, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private RaftRequest.Outbound sendTestRequest(ApiKeys apiKey, int destinationId) {
        int correlationId = this.kafka$raft$KafkaNetworkChannelTest$$channel().newCorrelationId();
        long createdTimeMs = this.time().milliseconds();
        ApiMessage apiRequest = this.buildTestRequest(apiKey);
        RaftRequest.Outbound request = new RaftRequest.Outbound(correlationId, apiRequest, destinationId, createdTimeMs);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().send(request);
        return request;
    }

    private void assertResponseCompleted(RaftRequest.Outbound request, Errors expectedError) {
        Assertions.assertTrue((boolean)request.completion.isDone());
        RaftResponse.Inbound response = (RaftResponse.Inbound)request.completion.get();
        Assertions.assertEquals((int)request.destinationId(), (int)response.sourceId());
        Assertions.assertEquals((int)request.correlationId(), (int)response.correlationId());
        Assertions.assertEquals((short)request.data().apiKey(), (short)response.data().apiKey());
        Assertions.assertEquals((Object)expectedError, (Object)this.extractError(response.data()));
    }

    private void sendAndAssertErrorResponse(ApiKeys apiKey, int destinationId, Errors error) {
        RaftRequest.Outbound request = this.sendTestRequest(apiKey, destinationId);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
        this.assertResponseCompleted(request, error);
    }

    private ApiMessage buildTestRequest(ApiKeys key) {
        BeginQuorumEpochRequestData beginQuorumEpochRequestData;
        int leaderEpoch = 5;
        int leaderId = 1;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochRequestData = BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId);
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochRequestData = EndQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderId, (int)leaderEpoch, Collections.singletonList(Predef$.MODULE$.int2Integer(2)));
        } else if (ApiKeys.VOTE.equals(key)) {
            int lastEpoch = 4;
            beginQuorumEpochRequestData = VoteRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId, (int)lastEpoch, (long)329L);
        } else if (ApiKeys.FETCH.equals(key)) {
            TopicPartition singletonFetchRequest_topicPartition = this.topicPartition();
            FetchRequestData.FetchPartition singletonFetchRequest_fetchPartition = new FetchRequestData.FetchPartition().setPartition(singletonFetchRequest_topicPartition.partition());
            KafkaNetworkChannelTest.$anonfun$buildTestRequest$1(singletonFetchRequest_fetchPartition);
            FetchRequestData.FetchTopic singletonFetchRequest_fetchTopic = new FetchRequestData.FetchTopic().setTopic(singletonFetchRequest_topicPartition.topic()).setPartitions(Collections.singletonList(singletonFetchRequest_fetchPartition));
            beginQuorumEpochRequestData = new FetchRequestData().setTopics(Collections.singletonList(singletonFetchRequest_fetchTopic)).setReplicaId(1);
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochRequestData;
    }

    private ApiMessage buildTestErrorResponse(ApiKeys key, Errors error) {
        BeginQuorumEpochResponseData beginQuorumEpochResponseData;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new BeginQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            beginQuorumEpochResponseData = new EndQuorumEpochResponseData().setErrorCode(error.code());
        } else if (ApiKeys.VOTE.equals(key)) {
            beginQuorumEpochResponseData = VoteResponse.singletonResponse((Errors)error, (TopicPartition)this.topicPartition(), (Errors)Errors.NONE, (int)1, (int)5, (boolean)false);
        } else if (ApiKeys.FETCH.equals(key)) {
            beginQuorumEpochResponseData = new FetchResponseData().setErrorCode(error.code());
        } else {
            throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
        }
        return beginQuorumEpochResponseData;
    }

    private Errors extractError(ApiMessage response) {
        short s;
        if (response instanceof BeginQuorumEpochResponseData) {
            s = ((BeginQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof EndQuorumEpochResponseData) {
            s = ((EndQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof FetchResponseData) {
            s = ((FetchResponseData)response).errorCode();
        } else if (response instanceof VoteResponseData) {
            s = ((VoteResponseData)response).errorCode();
        } else {
            throw new MatchError((Object)response);
        }
        return Errors.forCode((short)s);
    }

    public AbstractResponse buildResponse(ApiMessage responseData) {
        VoteResponse voteResponse;
        if (responseData instanceof VoteResponseData) {
            VoteResponseData voteResponseData = (VoteResponseData)responseData;
            voteResponse = new VoteResponse(voteResponseData);
        } else if (responseData instanceof BeginQuorumEpochResponseData) {
            BeginQuorumEpochResponseData beginQuorumEpochResponseData = (BeginQuorumEpochResponseData)responseData;
            voteResponse = new BeginQuorumEpochResponse(beginQuorumEpochResponseData);
        } else if (responseData instanceof EndQuorumEpochResponseData) {
            EndQuorumEpochResponseData endQuorumEpochResponseData = (EndQuorumEpochResponseData)responseData;
            voteResponse = new EndQuorumEpochResponse(endQuorumEpochResponseData);
        } else if (responseData instanceof FetchResponseData) {
            FetchResponseData fetchResponseData = (FetchResponseData)responseData;
            voteResponse = new FetchResponse(fetchResponseData);
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("Unexpected type for responseData: ").append(responseData).toString());
        }
        return voteResponse;
    }

    public static final /* synthetic */ void $anonfun$testSendAndDisconnect$1(KafkaNetworkChannelTest $this, Node destinationNode$1, int destinationId$1, ApiKeys apiKey) {
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, Errors.INVALID_REQUEST));
        $this.client().prepareResponseFrom(response, destinationNode$1, true);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$1, Errors.BROKER_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$testSendAndFailAuthentication$1(KafkaNetworkChannelTest $this, Node destinationNode$2, int destinationId$2, ApiKeys apiKey) {
        $this.client().createPendingAuthenticationError(destinationNode$2, 100L);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$2, Errors.NETWORK_EXCEPTION);
        $this.client().reset();
    }

    public static final /* synthetic */ void $anonfun$testSendAndReceiveOutboundRequest$1(KafkaNetworkChannelTest $this, Node destinationNode$3, int destinationId$4, ApiKeys apiKey) {
        Errors expectedError = Errors.INVALID_REQUEST;
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, expectedError));
        $this.client().prepareResponseFrom(response, destinationNode$3);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$4, expectedError);
    }

    public static final /* synthetic */ void $anonfun$testUnsupportedVersionError$1(KafkaNetworkChannelTest $this, int destinationId$5, ApiKeys apiKey) {
        $this.client().prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            return !(apiKeys != null ? !apiKeys.equals(apiKey) : apiKey != null);
        });
        $this.sendAndAssertErrorResponse(apiKey, destinationId$5, Errors.UNSUPPORTED_VERSION);
    }

    public static final /* synthetic */ void $anonfun$buildTestRequest$1(FetchRequestData.FetchPartition fetchPartition) {
        fetchPartition.setCurrentLeaderEpoch(5).setFetchOffset(333L).setLastFetchedEpoch(5);
    }

    public KafkaNetworkChannelTest() {
        this.clusterId = "clusterId";
        this.requestTimeoutMs = 30000;
    }

    private static class StubMetadataUpdater
    implements MockClient.MockMetadataUpdater {
        public void updateWithCurrentMetadata(Time x$1) {
            super.updateWithCurrentMetadata(x$1);
        }

        public void close() {
            super.close();
        }

        public List<Node> fetchNodes() {
            return Collections.emptyList();
        }

        public boolean isUpdateNeeded() {
            return false;
        }

        public void update(Time time, MockClient.MetadataUpdate update) {
        }
    }
}

