/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherPool;
import kafka.server.FetcherStats;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0003BB\u0013\u0001A\u0003%!\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\t\r-\u0002\u0001\u0015!\u0003)\u0011\u001da\u0003A1A\u0005\u00025Ba\u0001\u000e\u0001!\u0002\u0013q\u0003\"B\u001b\u0001\t\u00031\u0004\"B$\u0001\t\u0013A\u0005\"B-\u0001\t\u00031\u0004\"\u00020\u0001\t\u00031\u0004\"\u00021\u0001\t\u00031\u0004\"\u00022\u0001\t\u00031\u0004\"\u00023\u0001\t\u00031$AG!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:UKN$(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002!\u0005Ya-\u001a;dQ>3gm]3u+\u0005\u0011\u0003CA\f$\u0013\t!\u0003D\u0001\u0003M_:<\u0017\u0001\u00044fi\u000eDwJ\u001a4tKR\u0004\u0013a\u00037fC\u0012,'/\u00129pG\",\u0012\u0001\u000b\t\u0003/%J!A\u000b\r\u0003\u0007%sG/\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\n\u0002\u000f\rdWo\u001d;fe&\u00111\u0007\r\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003=\u0011'o\\6fe\u0016sG\rU8j]R\u0004\u0013aE2mK\u0006tW*\u001a;sS\u000e\u0014VmZ5tiJLH#A\u001c\u0011\u0005]A\u0014BA\u001d\u0019\u0005\u0011)f.\u001b;)\u0005!Y\u0004C\u0001\u001fF\u001b\u0005i$B\u0001 @\u0003\r\t\u0007/\u001b\u0006\u0003\u0001\u0006\u000bqA[;qSR,'O\u0003\u0002C\u0007\u0006)!.\u001e8ji*\tA)A\u0002pe\u001eL!AR\u001f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\bhKRlU\r\u001e:jGZ\u000bG.^3\u0015\u0005%c\u0005CA\fK\u0013\tY\u0005DA\u0002B]fDQ!T\u0005A\u00029\u000bAA\\1nKB\u0011qJ\u0016\b\u0003!R\u0003\"!\u0015\r\u000e\u0003IS!a\u0015\u000b\u0002\rq\u0012xn\u001c;?\u0013\t)\u0006$\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u0019\u0003e!Xm\u001d;BI\u0012\fe\u000e\u001a*f[>4X\rU1si&$\u0018n\u001c8)\u0005)Y\u0006C\u0001\u001f]\u0013\tiVH\u0001\u0003UKN$\u0018A\b;fgRlU\r\u001e:jG\u001a\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\tY1,A\ruKN$H)Z1e)\"\u0014X-\u00193D_VtG/T3ue&\u001c\u0007F\u0001\u0007\\\u0003Y!Xm\u001d;NS:4U\r^2i%\u0006$X-T3ue&\u001c\u0007FA\u0007\\\u0003m!Xm\u001d;NS\u001e\u0014\u0018\r^3J]NKhn\u0019)beRLG/[8og\"\u0012ab\u0017")
public class AbstractFetcherManagerTest {
    private final long fetchOffset;
    private final int leaderEpoch;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 9092);

    public long fetchOffset() {
        return this.fetchOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply(this.fetchOffset(), (Option)None$.MODULE$, this.leaderEpoch(), (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$)));
        EasyMock.expect((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).andReturn((Object)Map$.MODULE$.empty());
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{fetcher});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        EasyMock.verify((Object[])new Object[]{fetcher});
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$1;
            private final AbstractFetcherThread fetcher2$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$1;
                }
                return this.fetcher2$1;
            }
            {
                this.fetcher1$1 = fetcher1$1;
                this.fetcher2$1 = fetcher2$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$);
        Assertions.assertEquals((int)2, (int)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.reset((Object[])new Object[]{fetcher1});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{fetcher1});
        EasyMock.reset((Object[])new Object[]{fetcher2});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{fetcher2});
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.reset((Object[])new Object[]{fetcher1});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{fetcher1});
        EasyMock.reset((Object[])new Object[]{fetcher2});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{fetcher2});
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
    }

    @Test
    public void testMinFetchRateMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$2;
            private final AbstractFetcherThread fetcher2$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$2;
                }
                return this.fetcher2$2;
            }
            {
                this.fetcher1$2 = fetcher1$2;
                this.fetcher2$2 = fetcher2$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Meter requestRate1 = (Meter)EasyMock.mock(Meter.class);
        Meter requestRate2 = (Meter)EasyMock.mock(Meter.class);
        EasyMock.expect((Object)BoxesRunTime.boxToDouble((double)requestRate1.oneMinuteRate())).andStubReturn((Object)BoxesRunTime.boxToDouble((double)10.0));
        EasyMock.expect((Object)BoxesRunTime.boxToDouble((double)requestRate2.oneMinuteRate())).andStubReturn((Object)BoxesRunTime.boxToDouble((double)5.0));
        EasyMock.replay((Object[])new Object[]{requestRate1});
        EasyMock.replay((Object[])new Object[]{requestRate2});
        FetcherStats fetcherStats1 = (FetcherStats)EasyMock.mock(FetcherStats.class);
        FetcherStats fetcherStats2 = (FetcherStats)EasyMock.mock(FetcherStats.class);
        EasyMock.expect((Object)fetcherStats1.requestRate()).andStubReturn((Object)requestRate1);
        EasyMock.expect((Object)fetcherStats2.requestRate()).andStubReturn((Object)requestRate2);
        EasyMock.replay((Object[])new Object[]{fetcherStats1});
        EasyMock.replay((Object[])new Object[]{fetcherStats2});
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).times(2);
        EasyMock.expect((Object)fetcher1.sourceBroker()).andReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher1.fetcherStats()).andStubReturn((Object)fetcherStats1);
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).times(2);
        EasyMock.expect((Object)fetcher2.sourceBroker()).andReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher2.fetcherStats()).andStubReturn((Object)fetcherStats2);
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$1(x0$1)))).values().headOption().get()).value()));
        Assertions.assertEquals((int)0, (int)((TraversableOnce)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$2(x0$2)))).keys().filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$3(k)))).size());
        fetcherManager.createSeparateFetcherMetrics();
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$4(x0$3)))).values().headOption().get()).value()));
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testMinFetchRateMetric$5(x0$4)))).values().headOption().get()).value()));
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.verify((Object[])new Object[]{fetcherStats1});
        EasyMock.verify((Object[])new Object[]{fetcherStats2});
        EasyMock.verify((Object[])new Object[]{requestRate1});
        EasyMock.verify((Object[])new Object[]{requestRate2});
    }

    @Test
    public void testMigrateInSyncPartitions() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$3;
            private final AbstractFetcherThread fetcher2$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (!(fetcherPool2 != null ? !fetcherPool2.equals(default$) : default$ != null)) {
                    return this.fetcher1$3;
                }
                return this.fetcher2$3;
            }
            {
                this.fetcher1$3 = fetcher1$3;
                this.fetcher2$3 = fetcher2$3;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$1.scheduler()), AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6());
            }
        };
        TopicPartition tp_0 = new TopicPartition("topic", 0);
        TopicPartition tp_1 = new TopicPartition("topic", 1);
        InitialFetchState initialFetchState_0 = new InitialFetchState(this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        InitialFetchState initialFetchState_1 = new InitialFetchState(this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        PartitionFetchState partitionFetchState_0 = new PartitionFetchState(this.fetchOffset(), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), this.leaderEpoch(), (Option)None$.MODULE$, (ReplicaState)EasyMock.mock(ReplicaState.class), (Option)None$.MODULE$);
        Function1 & Serializable & scala.Serializable valueFactory = arg_0 -> AbstractFetcherManagerTest.$anonfun$testMigrateInSyncPartitions$1(new ClientIdAndBroker("0", "localhost", 9092), arg_0);
        Pool lagStats = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_0)).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_1)).lag_$eq(1L);
        FetcherLagStats fetcherLagStats = (FetcherLagStats)EasyMock.mock(FetcherLagStats.class);
        EasyMock.expect((Object)fetcherLagStats.stats()).andStubReturn((Object)lagStats);
        EasyMock.replay((Object[])new Object[]{fetcherLagStats});
        fetcher1.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher1.sourceBroker()).andStubReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        EasyMock.expect((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_1})));
        EasyMock.expect((Object)fetcher1.fetcherLagStats()).andStubReturn((Object)fetcherLagStats);
        EasyMock.expect((Object)fetcher1.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})))).andReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)partitionFetchState_0)})));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcher1.partitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)1));
        EasyMock.replay((Object[])new Object[]{fetcher1});
        fetcher2.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher2.sourceBroker()).andStubReturn((Object)this.brokerEndPoint());
        EasyMock.expect((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_1)})))).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        EasyMock.expect((Object)fetcher2.fetcherLagStats()).andStubReturn((Object)fetcherLagStats);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcher2.partitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)1));
        EasyMock.replay((Object[])new Object[]{fetcher2});
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})), (FetcherPool)FetcherPool.Default$.MODULE$);
        Assertions.assertEquals((int)1, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertTrue((boolean)fetcherManager.fetcherThreadMap().contains((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        time.sleep(1001L);
        Assertions.assertEquals((int)2, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertEquals((Object)fetcher1, (Object)fetcherManager.fetcherThreadMap().get((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)).get());
        Assertions.assertEquals((Object)fetcher2, (Object)fetcherManager.fetcherThreadMap().get((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.InSync$.MODULE$)).get());
        EasyMock.verify((Object[])new Object[]{fetcher1});
        EasyMock.verify((Object[])new Object[]{fetcher2});
        EasyMock.verify((Object[])new Object[]{fetcherLagStats});
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$3(MetricName k) {
        return k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name()) || k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$3._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMinFetchRateMetric$5(Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$4._1();
        String string = k.getName();
        String string2 = "MinFetchRate";
        boolean bl = string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
        return bl;
    }

    public static final /* synthetic */ FetcherLagMetrics $anonfun$testMigrateInSyncPartitions$1(ClientIdAndBroker metricId$1, TopicPartition k) {
        return new FetcherLagMetrics(new ClientIdTopicPartition(metricId$1.clientId(), k), (Map)Map$.MODULE$.empty());
    }

    public AbstractFetcherManagerTest() {
        this.fetchOffset = 10L;
        this.leaderEpoch = 15;
    }
}

