/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrItem$;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019a\u0005\u0001)A\u0005\r\"9Q\n\u0001b\u0001\n\u0003q\u0005BB.\u0001A\u0003%q\nC\u0004]\u0001\t\u0007I\u0011A/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011%\u0011\u0007\u00011AA\u0002\u0013\u00051\rC\u0005h\u0001\u0001\u0007\t\u0019!C\u0001Q\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u0019)\b\u0001)A\u0005c\"9a\u000f\u0001b\u0001\n\u0003\u0001\bBB<\u0001A\u0003%\u0011\u000fC\u0004y\u0001\t\u0007I\u0011\u00019\t\re\u0004\u0001\u0015!\u0003r\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0019\ty\u0001\u0001C\u0001w\"1\u0011\u0011\u0004\u0001\u0005\u0002mDa!!\b\u0001\t\u0003Y\bBBA\u0011\u0001\u0011\u00051\u0010\u0003\u0004\u0002&\u0001!\ta\u001f\u0005\u0007\u0003S\u0001A\u0011A>\t\r\u00055\u0002\u0001\"\u0001|\u0011\u0019\t\t\u0004\u0001C\u0001w\"9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA%\u0001\u0011%\u00111\n\u0005\u0007\u0003;\u0002A\u0011A>\t\r\u0005\u0005\u0004\u0001\"\u0001|\u0011\u0019\t)\u0007\u0001C\u0001w\"9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\u0007\u0003\u007f\u0002A\u0011A>\t\r\u0005\r\u0005\u0001\"\u0001|\u0011\u0019\t9\t\u0001C\u0001w\"1\u00111\u0012\u0001\u0005\u0002mDq!a$\u0001\t\u0013\t\tJA\nBYR,'/S:s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002+W\u000511/\u001a:wKJT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003%\nQ\u0001^8qS\u000e,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0001^5nKV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002JW\u0005)Q\u000f^5mg&\u00111\n\u0013\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A(\u0011\u0005AKV\"A)\u000b\u00055\u0013&BA*U\u0003\u0019\u0019w.\\7p]*\u0011A&\u0016\u0006\u0003-^\u000ba!\u00199bG\",'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[#\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\u0018\t\u0003a}K!\u0001Y\u0019\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005\u0011\"M]8lKJ$vnQ8oiJ|G\u000e\\3s+\u0005!\u0007C\u0001\u001df\u0013\t1\u0017F\u0001\u0011Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u00062s_.,'\u000fV8D_:$(o\u001c7mKJ|F%Z9\u0015\u0005%d\u0007C\u0001\u0019k\u0013\tY\u0017G\u0001\u0003V]&$\bbB7\f\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013a\u0001;qaU\t\u0011\u000f\u0005\u0002sg6\t!+\u0003\u0002u%\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qa\u0001\n1\u0001\u001e92\u0003\u0011!\b/\r\u0011\u0002\u0007Q\u0004('\u0001\u0003uaJ\u0002\u0013!B:fiV\u0004H#A5)\u0005Mi\bc\u0001@\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aA1qS*!\u0011QAA\u0004\u0003\u001dQW\u000f]5uKJT1!!\u0003X\u0003\u0015QWO\\5u\u0013\r\tia \u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0003;fgR\u0014\u0015m]5dQ\r!\u00121\u0003\t\u0004}\u0006U\u0011bAA\f\u007f\n!A+Z:u\u0003a!Xm\u001d;Pm\u0016\u0014xO]5uK^KG\u000f[5o\u0005\u0006$8\r\u001b\u0015\u0004+\u0005M\u0011a\u0004;fgR\u001c\u0016N\\4mK\n\u000bGo\u00195)\u0007Y\t\u0019\"A\fuKN$\u0018)\u001e;i_JL'0\u0019;j_:4\u0015-\u001b7fI\"\u001aq#a\u0005\u0002)Q,7\u000f^*uC2,'I]8lKJ,\u0005o\\2iQ\rA\u00121C\u0001\u0012i\u0016\u001cH/\u00168l]><hnU3sm\u0016\u0014\bfA\r\u0002\u0014\u0005\u0001C/Z:u%\u0016$(/_(o\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\rQ\u00121C\u0001#i\u0016\u001cHOU3uef|e.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016\u0013(o\u001c:)\u0007m\t\u0019\"\u0001\ruKN$(+\u001a;ss>sGk\u001c9MKZ,G.\u0012:s_J$2![A\u001d\u0011\u001d\tY\u0004\ba\u0001\u0003{\tQ!\u001a:s_J\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0012\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005\u001d\u0013\u0011\t\u0002\u0007\u000bJ\u0014xN]:\u00021Q,7\u000f\u001e*fiJLxJ\\#se>\u0014(+Z:q_:\u001cX\rF\u0002j\u0003\u001bBq!a\u0014\u001e\u0001\u0004\t\t&\u0001\u0005sKN\u0004xN\\:f!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,)\u000691\r\\5f]R\u001c\u0018\u0002BA.\u0003+\u0012ab\u00117jK:$(+Z:q_:\u001cX-\u0001\ruKN$\u0018J\u001c<bY&$W\u000b\u001d3bi\u00164VM]:j_:D3AHA\n\u0003e!Xm\u001d;V].twn\u001e8U_BL7\rU1si&$\u0018n\u001c8)\u0007}\t\u0019\"A\fuKN$hj\u001c;MK\u0006$WM](s\r>dGn\\<fe\"\u001a\u0001%a\u0005\u0002'\rDWmY6QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:\u0015\u0007%\fi\u0007C\u0004\u0002<\u0005\u0002\r!!\u0010\u0002%Q,7\u000f\u001e)beRLG/[8o\u000bJ\u0014xN\u001d\u000b\u0007\u0003g\nI(! \u0011\u0007a\n)(C\u0002\u0002x%\u0012q\"\u00117uKJL5O]'b]\u0006<WM\u001d\u0005\u0007\u0003w\u0012\u0003\u0019A9\u0002\u0005Q\u0004\bbBA\u001eE\u0001\u0007\u0011QH\u0001\u0010i\u0016\u001cHo\u00148f\u0013:4E.[4ii\"\u001a1%a\u0005\u0002=Q,7\u000f\u001e)beRLG/[8o\u001b&\u001c8/\u001b8h\u0013:\u0014Vm\u001d9p]N,\u0007f\u0001\u0013\u0002\u0014\u0005YA/Z:u5.\u0014\u0015m]5dQ\r)\u00131C\u0001\u001ai\u0016\u001cHoQ1o'V\u0014W.\u001b;Ge>l7)\u00197mE\u0006\u001c7\u000eK\u0002'\u0003'\t\u0011\u0003]1si&$\u0018n\u001c8SKN\u0004xN\\:f)\u0019\t\u0019*a(\u0002\"B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001aJ\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003;\u000b9J\u0001\tBYR,'/S:s%\u0016\u001c\bo\u001c8tK\"1\u00111P\u0014A\u0002EDq!a\u000f(\u0001\u0004\ti\u0004")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)EasyMock.createMock(BrokerToControllerChannelManager.class));
    }

    @Test
    public void testBasic() {
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$1 -> {
            AlterIsrManagerTest.$anonfun$testBasic$2(x$1);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testOverwriteWithinBatch() {
        Capture capture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        Assertions.assertTrue((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$2 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$2(x$2);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
        Assertions.assertFalse((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$3 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$3(x$3);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
        AlterIsrResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$4 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$4(x$4);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterIsrRequestData.PartitionData)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @Test
    public void testSingleBatch() {
        Capture capture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$5 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$2(x$5);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> alterIsrManager.submit(new AlterIsrItem(new TopicPartition(this.topic(), i), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$6 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$4(x$6);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$);
        .colon.colon isrs = new .colon.colon((Object)new AlterIsrItem(this.tp0(), leaderAndIsr, (Function1 & Serializable & scala.Serializable)x$7 -> {
            AlterIsrManagerTest.$anonfun$testRetryOnErrorResponse$1(x$7);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()), (List)Nil$.MODULE$);
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        isrs.foreach((Function1 & Serializable & scala.Serializable)alterIsrItem -> BoxesRunTime.boxToBoolean((boolean)alterIsrManager.submit(alterIsrItem)));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterIsrResponse retryAlterIsrResponse = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterIsrResponse);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertTrue((boolean)this.testPartitionError(this.tp0(), error).submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$8 -> {
            AlterIsrManagerTest.$anonfun$checkPartitionError$1(x$8);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        ObjectRef capturedError = ObjectRef.create((Object)None$.MODULE$);
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
            AlterIsrManagerTest.$anonfun$testPartitionError$2(capturedError, result);
            return BoxedUnit.UNIT;
        };
        alterIsrManager.submit(new AlterIsrItem(tp, new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1)callback, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = this.partitionResponse(tp, error);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)((Option)capturedError.elem).isDefined());
        Assertions.assertEquals((Object)((Option)capturedError.elem).get(), (Object)error);
        return alterIsrManager;
    }

    @Test
    public void testOneInFlight() {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$9 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$2(x$9);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        alterIsrManager.submit(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$10 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$3(x$10);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        alterIsrManager.submit(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$11 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$4(x$11);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5()));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testPartitionMissingInResponse() {
        Object object = new Object();
        try {
            Capture callbackCapture = EasyMock.newCapture();
            EasyMock.reset((Object[])new Object[]{this.brokerToController()});
            this.brokerToController().start();
            EasyMock.expect((Object)BoxedUnit.UNIT);
            this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
            EasyMock.replay((Object[])new Object[]{this.brokerToController()});
            MockScheduler scheduler = new MockScheduler((Time)this.time());
            DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
            alterIsrManager.start();
            AtomicInteger count = new AtomicInteger(0);
            Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
                count.incrementAndGet();
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1)callback, 0, AlterIsrItem$.MODULE$.apply$default$5()));
            alterIsrManager.submit(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1)callback, 0, AlterIsrItem$.MODULE$.apply$default$5()));
            alterIsrManager.submit(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1)callback, 0, AlterIsrItem$.MODULE$.apply$default$5()));
            EasyMock.verify((Object[])new Object[]{this.brokerToController()});
            AlterIsrResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR);
            ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
            ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
            Assertions.assertEquals((int)count.get(), (int)3, (String)"Expected all callbacks to run");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$12 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$13 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        Assertions.assertTrue((boolean)zkIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 1, false, (Option)None$.MODULE$), arg_0 -> AlterIsrManagerTest.$anonfun$testZkBasic$3$adapted(package$.MODULE$.Right().apply((Object)new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 2, false, (Option)None$.MODULE$)), arg_0), 0, AlterIsrItem$.MODULE$.apply$default$5())));
        Assertions.assertTrue((boolean)zkIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 3, false, (Option)None$.MODULE$), arg_0 -> AlterIsrManagerTest.$anonfun$testZkBasic$4$adapted(package$.MODULE$.Left().apply((Object)Errors.INVALID_UPDATE_VERSION), arg_0), 0, AlterIsrItem$.MODULE$.apply$default$5())));
    }

    @Test
    public void testCanSubmitFromCallback() {
        Capture capture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (ControllerRequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L);
        alterIsrManager.start();
        Assertions.assertTrue((boolean)alterIsrManager.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)results -> {
            this.callback$1(results, alterIsrManager);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
        AlterIsrResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterIsrRequestData.PartitionData)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    private AlterIsrResponse partitionResponse(TopicPartition tp, Errors error) {
        return new AlterIsrResponse(new AlterIsrResponseData().setTopics(Collections.singletonList(new AlterIsrResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterIsrResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(error.code()))))));
    }

    public static final /* synthetic */ void $anonfun$testBasic$2(Either x$1) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$2(Either x$2) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$3(Either x$3) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$4(Either x$4) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$2(Either x$5) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$4(Either x$6) {
    }

    public static final /* synthetic */ void $anonfun$testRetryOnErrorResponse$1(Either x$7) {
    }

    public static final /* synthetic */ void $anonfun$checkPartitionError$1(Either x$8) {
    }

    public static final /* synthetic */ void $anonfun$testPartitionError$2(ObjectRef capturedError$1, Either result) {
        Errors error;
        if (result instanceof Left && (error = (Errors)((Left)result).value()) != null) {
            capturedError$1.elem = new Some((Object)error);
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should have seen error");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$2(Either x$9) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$3(Either x$10) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$4(Either x$11) {
    }

    private static final void expectMatch$1(Either expect, Either result) {
        Assertions.assertEquals((Object)expect, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testCanSubmitFromCallback$2(Either x$14) {
    }

    private final void callback$1(Either results, DefaultAlterIsrManager alterIsrManager$3) {
        Assertions.assertTrue((boolean)alterIsrManager$3.submit(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), 10, false, (Option)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$14 -> {
            AlterIsrManagerTest.$anonfun$testCanSubmitFromCallback$2(x$14);
            return BoxedUnit.UNIT;
        }, 0, AlterIsrItem$.MODULE$.apply$default$5())));
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }

    public static final /* synthetic */ Object $anonfun$testZkBasic$3$adapted(Right eta$0$1$1, Either result) {
        AlterIsrManagerTest.expectMatch$1((Either)eta$0$1$1, result);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testZkBasic$4$adapted(Left eta$0$2$1, Either result) {
        AlterIsrManagerTest.expectMatch$1((Either)eta$0$2$1, result);
        return BoxedUnit.UNIT;
    }
}

