/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.server.BaseRequestTest;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0011#\u0001\u001dBQ\u0001\f\u0001\u0005\u00025BQa\f\u0001\u0005BABqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006)\u0002!\ta\u0011\u0005\u0006-\u0002!\ta\u0011\u0005\u00061\u0002!\ta\u0011\u0005\u00065\u0002!\ta\u0011\u0005\u00069\u0002!\ta\u0011\u0005\u0006=\u0002!\ta\u0011\u0005\u0006A\u0002!\ta\u0011\u0005\u0006E\u0002!\ta\u0011\u0005\u0006I\u0002!\ta\u0011\u0005\u0006M\u0002!\ta\u0011\u0005\u0006Q\u0002!I!\u001b\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011%\ty\u0002AI\u0001\n\u0013\t\t\u0003C\u0005\u00028\u0001\t\n\u0011\"\u0003\u0002\"!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!a \u0001\t\u0013\t\t\tC\u0005\u00028\u0002\t\n\u0011\"\u0003\u0002:\"I\u0011Q\u0018\u0001\u0012\u0002\u0013%\u0011q\u0018\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9\u0011q \u0001\u0005\n\t\u0005!aF!mi\u0016\u0014X*\u001b:s_J\u001c(+Z9vKN$H+Z:u\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tI#&D\u0001#\u0013\tY#EA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u0002*\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$aA%oi\u0006AA.\u001b8l\u001d\u0006lW-F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0017!\u00037j].t\u0015-\\3!\u0003U!Xm\u001d;BYR,'/T5se>\u00148/R7qif$\u0012\u0001\u0012\t\u0003e\u0015K!AR\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000b!\u0003\"!\u0013*\u000e\u0003)S!a\u0013'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002N\u001d\u00069!.\u001e9ji\u0016\u0014(BA(Q\u0003\u0015QWO\\5u\u0015\u0005\t\u0016aA8sO&\u00111K\u0013\u0002\u0005)\u0016\u001cH/A\u000buKN$\u0018\t\u001c;fe6K'O]8sg\n\u000bGm\u00149)\u0005\u0019A\u0015a\u0005;fgR\u001cFo\u001c9NSJ\u0014xN\u001d+pa&\u001c\u0007FA\u0004I\u0003}!Xm\u001d;Ti>\u0004X*\u001b:s_J$v\u000e]5d\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u0015\u0003\u0011!\u000b1\u0005^3tiN#x\u000e]'jeJ|'\u000fV8qS\u000etuN\\3ySN$XM\u001c;U_BL7\r\u000b\u0002\n\u0011\u0006!B/Z:u\u00072,\u0017M]'jeJ|'\u000fV8qS\u000eD#A\u0003%\u0002AQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5d\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u0015\u0003\u0017!\u000bA\u0005^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001cgj\u001c8fq&\u001cH/\u001a8u)>\u0004\u0018n\u0019\u0015\u0003\u0019!\u000bA\u0003^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c\u0007FA\u0007I\u0003\u0001\"Xm\u001d;QCV\u001cX-T5se>\u0014Hk\u001c9jG&sg/\u00197jIR{\u0007/[2)\u00059A\u0015\u0001\n;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7MT8oKbL7\u000f^3oiR{\u0007/[2)\u0005=A\u0015!F2sK\u0006$Xm\u00117vgR,'\u000fT5oW^KG\u000f\u001b\u000b\u0006\t*<\u0018Q\u0001\u0005\u0006WB\u0001\r\u0001\\\u0001\fC\u0012l\u0017N\\\"mS\u0016tG\u000f\u0005\u0002nk6\taN\u0003\u0002pa\u0006)\u0011\rZ7j]*\u0011\u0011O]\u0001\bG2LWM\u001c;t\u0015\t)3O\u0003\u0002u!\u00061\u0011\r]1dQ\u0016L!A\u001e8\u0003\u000b\u0005#W.\u001b8\t\u000b]\u0002\u0002\u0019\u0001=\u0011\u0007e\f\tA\u0004\u0002{}B\u00111pM\u0007\u0002y*\u0011QPJ\u0001\u0007yI|w\u000e\u001e \n\u0005}\u001c\u0014A\u0002)sK\u0012,g-C\u0002A\u0003\u0007Q!a`\u001a\t\r\u0005\u001d\u0001\u00031\u0001y\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148/A\bde\u0016\fG/\u001a+pa&\u001cw+\u001b;i)%!\u0015QBA\b\u0003'\tY\u0002C\u0003l#\u0001\u0007A\u000e\u0003\u0004\u0002\u0012E\u0001\r\u0001_\u0001\u0006i>\u0004\u0018n\u0019\u0005\toE\u0001\n\u00111\u0001\u0002\u0016A!!'a\u0006y\u0013\r\tIb\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005u\u0011\u0003%AA\u0002\u0005U\u0011aC7jeJ|'\u000fV8qS\u000e\f\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0005\u0016\u0005\u0003+\t)c\u000b\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C;oG\",7m[3e\u0015\r\t\tdM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e\u0019'/Z1uKR{\u0007/[2XSRDG\u0005Z3gCVdG\u000f\n\u001b\u0002\u001fM$x\u000e]'jeJ|'\u000fV8qS\u000e$R\u0001RA\u001f\u0003\u007fAa!!\u0005\u0015\u0001\u0004A\bbBA!)\u0001\u0007\u00111I\u0001\fgft7\r\u001b:p]&TX\rE\u00023\u0003\u000bJ1!a\u00124\u0005\u001d\u0011un\u001c7fC:\f\u0001c\u00197fCJl\u0015N\u001d:peR{\u0007/[2\u0015\u0007\u0011\u000bi\u0005\u0003\u0004\u0002\u0012U\u0001\r\u0001_\u0001\u0011a\u0006,8/Z'jeJ|'\u000fV8qS\u000e$R\u0001RA*\u0003+Ba!!\u0005\u0017\u0001\u0004A\bbBA,-\u0001\u0007\u00111I\u0001\u0007K:\f'\r\\3\u0002\u0017\u0005dG/\u001a:NSJ\u0014xN\u001d\u000b\u0007\u0003;\n\u0019(!\u001e\u0011\r\u0005}\u0013\u0011NA7\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!C5oi\u0016\u0014h.\u00197t\u0015\r\t9G]\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0010\u0017\u000647.\u0019$viV\u0014X-S7qYB\u0019!(a\u001c\n\u0007\u0005E4H\u0001\u0003W_&$\u0007BBA\t/\u0001\u0007\u0001\u0010C\u0004\u0002x]\u0001\r!!\u001f\u0002\u0005=\u0004\bcA7\u0002|%\u0019\u0011Q\u00108\u0003\u001b\u0005cG/\u001a:NSJ\u0014xN](q\u00031\tG\u000e^3s\u001b&\u0014(o\u001c:t)!\t\u0019)!&\u00020\u0006M\u0006CBAC\u0003\u001f\u000biF\u0004\u0003\u0002\b\u0006-ebA>\u0002\n&\tA'C\u0002\u0002\u000eN\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0006M%\u0001\u0002'jgRT1!!$4\u0011\u001d\t9\n\u0007a\u0001\u00033\u000b1a\u001c9t!\u0019\t))a$\u0002\u001cB!\u0011QTAU\u001d\u0011\ty*!*\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\nq!\\3tg\u0006<W-\u0003\u0003\u0002(\u0006\u0005\u0016aF!mi\u0016\u0014X*\u001b:s_J\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\tY+!,\u0003\u001f5K'O]8s\u001fB,'/\u0019;j_:TA!a*\u0002\"\"I\u0011\u0011\u0017\r\u0011\u0002\u0003\u0007\u00111I\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\t\u0003kC\u0002\u0013!a\u0001c\u0005IA/[7f_V$Xj]\u0001\u0017C2$XM]'jeJ|'o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0018\u0016\u0005\u0003\u0007\n)#\u0001\fbYR,'/T5se>\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tMK\u00022\u0003K\tqc]3oI\u0006cG/\u001a:NSJ\u0014xN]:SKF,Xm\u001d;\u0015\u0011\u0005\u001d\u00171[Ak\u0003/\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\f)'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t.a3\u0003)\u0005cG/\u001a:NSJ\u0014xN]:SKN\u0004xN\\:f\u0011\u001d\t9j\u0007a\u0001\u00033Cq!!-\u001c\u0001\u0004\t\u0019\u0005\u0003\u0004\u00026n\u0001\r!M\u0001\u0017O\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\r>\u0014Hk\u001c9jGR!\u0011Q\\Av!\u0015\u0011\u0014qCAp!\u0011\t\t/a:\u000e\u0005\u0005\r(bAAsE\u0005!A.\u001b8l\u0013\u0011\tI/a9\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"1\u0011\u0011\u0003\u000fA\u0002a\f1\u0003^8qS\u000eL5/Q2uSZ,W*\u001b:s_J$B!a\u0011\u0002r\"1\u0011\u0011C\u000fA\u0002a\f1\u0003^8qS\u000eL5\u000fU1vg\u0016$W*\u001b:s_J$B!a\u0011\u0002x\"1\u0011\u0011\u0003\u0010A\u0002a\f1\u0004^8qS\u000eL5\u000fU3oI&twm\u0015;paB,G-T5se>\u0014H\u0003BA\"\u0003{Da!!\u0005 \u0001\u0004A\u0018\u0001\u0006;pa&\u001c\u0017j]*u_B\u0004X\rZ'jeJ|'\u000f\u0006\u0003\u0002D\t\r\u0001BBA\tA\u0001\u0007\u0001\u0010")
public class AlterMirrorsRequestTest
extends BaseRequestTest {
    private final String linkName;

    @Override
    public int brokerCount() {
        return 1;
    }

    private String linkName() {
        return this.linkName;
    }

    @Test
    public void testAlterMirrorsEmpty() {
        Assertions.assertTrue((boolean)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)List$.MODULE$.empty(), this.alterMirrors$default$2(), this.alterMirrors$default$3()).isEmpty());
    }

    @Test
    public void testAlterMirrorsBadOp() {
        AlterMirrorsRequestData.MirrorOperation badOp = new AlterMirrorsRequestData.MirrorOperation().setTopic("topic").setOperationCode((byte)127);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)badOp, (List)Nil$.MODULE$), this.alterMirrors$default$2(), this.alterMirrors$default$3()).head(), InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testStopMirrorTopic() {
        .colon.colon topics = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-no-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$));
        ConfluentAdmin localAdmin = this.createAdminClient(this.createAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new IntegrationTestHarness(){

            public int brokerCount() {
                return 1;
            }
        };
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            IntegrationTestHarness integrationTestHarness = runWithRemoteCluster_remoteCluster;
            AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1(this, localAdmin, (Seq)topics, integrationTestHarness);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testStopMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.stopMirrorTopic("topic!", false));
    }

    @Test
    public void testStopMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.stopMirrorTopic("unknown-topic", false));
    }

    @Test
    public void testClearMirrorTopic() {
        String activeTopic = "active-topic";
        String stoppedTopic = "stopped-topic";
        ConfluentAdmin localAdmin = this.createAdminClient(this.createAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            IntegrationTestHarness integrationTestHarness = runWithRemoteCluster_remoteCluster;
            AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1(this, localAdmin, activeTopic, stoppedTopic, integrationTestHarness);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testClearMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.clearMirrorTopic("topic!"));
    }

    @Test
    public void testClearMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.clearMirrorTopic("unknown-topic"));
    }

    @Test
    public void testPauseMirrorTopic() {
        String topic = "topic";
        ConfluentAdmin localAdmin = this.createAdminClient(this.createAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            IntegrationTestHarness integrationTestHarness = runWithRemoteCluster_remoteCluster;
            AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1(this, localAdmin, topic, integrationTestHarness);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testPauseMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", true));
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", false));
    }

    @Test
    public void testPauseMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", false));
    }

    private void createClusterLinkWith(Admin adminClient, String linkName, String bootstrapServers) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers)}));
        NewClusterLink newClusterLink = new NewClusterLink(linkName, null, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)configs).asJava());
        admin.createClusterLinks(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)newClusterLink, (List)Nil$.MODULE$)).asJavaCollection(), (CreateClusterLinksOptions)new CreateClusterLinksOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private void createTopicWith(Admin adminClient, String topic, Option<String> linkName, Option<String> mirrorTopic) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)1)));
        linkName.foreach((Function1 & Serializable & scala.Serializable)ln -> newTopic.mirror(Optional.of(new NewMirrorTopic(ln, (String)mirrorTopic.get()))));
        admin.createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJavaCollection(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private Option<String> createTopicWith$default$3() {
        return None$.MODULE$;
    }

    private Option<String> createTopicWith$default$4() {
        return None$.MODULE$;
    }

    private void stopMirrorTopic(String topic, boolean synchronize) {
        try {
            AlterMirrorOp stopOp = synchronize ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER;
            this.alterMirror(topic, stopOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void clearMirrorTopic(String topic) {
        try {
            this.alterMirror(topic, AlterMirrorOp.CLEAR).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void pauseMirrorTopic(String topic, boolean enable) {
        try {
            AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME;
            this.alterMirror(topic, pauseOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private KafkaFutureImpl<Void> alterMirror(String topic, AlterMirrorOp op) {
        AlterMirrorsRequestData.MirrorOperation mirrorOp = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
        return (KafkaFutureImpl)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)mirrorOp, (List)Nil$.MODULE$), this.alterMirrors$default$2(), this.alterMirrors$default$3()).head();
    }

    private List<KafkaFutureImpl<Void>> alterMirrors(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        LinkedHashMap results = new LinkedHashMap();
        ops.foreach((Function1 & Serializable & scala.Serializable)op -> results.put(op.topic(), new KafkaFutureImpl()));
        this.sendAlterMirrorsRequest(ops, validateOnly, timeoutMs).complete(results);
        Assertions.assertEquals((int)ops.size(), (int)results.size());
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(results.values()).asScala()).toList();
    }

    private boolean alterMirrors$default$2() {
        return false;
    }

    private int alterMirrors$default$3() {
        return 5000;
    }

    private AlterMirrorsResponse sendAlterMirrorsRequest(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ops).asJava(), validateOnly, timeoutMs).build();
        return (AlterMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<ClusterLinkTopicState> getClusterLinkForTopic(String topic) {
        return this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
    }

    private boolean topicIsActiveMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsActiveMirror$1(x$1)));
    }

    private boolean topicIsPausedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPausedMirror$1(x$2)));
    }

    private boolean topicIsPendingStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPendingStoppedMirror$1(x$3)));
    }

    private boolean topicIsStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsStoppedMirror$1(x$4)));
    }

    public static final /* synthetic */ void $anonfun$testStopMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        ConfluentAdmin remoteAdmin = remoteCluster.createAdminClient(remoteCluster.createAdminClient$default$1());
        $this.createClusterLinkWith((Admin)localAdmin$1, $this.linkName(), remoteCluster.brokerList());
        topics$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            boolean synchronize = x0$1._2$mcZ$sp();
            $this.createTopicWith((Admin)remoteAdmin, topic, $this.createTopicWith$default$3(), $this.createTopicWith$default$4());
            $this.createTopicWith((Admin)localAdmin$1, topic, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic));
            $this.stopMirrorTopic(topic, synchronize);
            InvalidRequestException invalidRequestException = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> $this.stopMirrorTopic(topic, synchronize));
            return invalidRequestException;
        });
    }

    private final boolean hasClusterLink$1(String topic) {
        return this.getClusterLinkForTopic(topic).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testClearMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        ConfluentAdmin remoteAdmin = remoteCluster.createAdminClient(remoteCluster.createAdminClient$default$1());
        $this.createClusterLinkWith((Admin)localAdmin$2, $this.linkName(), remoteCluster.brokerList());
        $this.createTopicWith((Admin)remoteAdmin, activeTopic$1, $this.createTopicWith$default$3(), $this.createTopicWith$default$4());
        $this.createTopicWith((Admin)localAdmin$2, activeTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)activeTopic$1));
        Assertions.assertTrue((boolean)$this.topicIsActiveMirror(activeTopic$1));
        $this.clearMirrorTopic(activeTopic$1);
        Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
        $this.clearMirrorTopic(activeTopic$1);
        Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
        $this.createTopicWith((Admin)remoteAdmin, stoppedTopic$1, $this.createTopicWith$default$3(), $this.createTopicWith$default$4());
        $this.createTopicWith((Admin)localAdmin$2, stoppedTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)stoppedTopic$1));
        Assertions.assertTrue((boolean)$this.topicIsActiveMirror(stoppedTopic$1));
        $this.stopMirrorTopic(stoppedTopic$1, false);
        Assertions.assertTrue(($this.topicIsPendingStoppedMirror(stoppedTopic$1) || $this.topicIsStoppedMirror(stoppedTopic$1) ? 1 : 0) != 0, (String)new StringBuilder(23).append("Unexpected topic state ").append($this.getClusterLinkForTopic(stoppedTopic$1)).toString());
        $this.clearMirrorTopic(stoppedTopic$1);
        Assertions.assertFalse((boolean)$this.hasClusterLink$1(stoppedTopic$1));
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        ConfluentAdmin remoteAdmin = remoteCluster.createAdminClient(remoteCluster.createAdminClient$default$1());
        $this.createClusterLinkWith((Admin)localAdmin$3, $this.linkName(), remoteCluster.brokerList());
        $this.createTopicWith((Admin)remoteAdmin, topic$2, $this.createTopicWith$default$3(), $this.createTopicWith$default$4());
        $this.createTopicWith((Admin)localAdmin$3, topic$2, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$2));
        Assertions.assertTrue((boolean)$this.topicIsActiveMirror(topic$2));
        $this.pauseMirrorTopic(topic$2, true);
        Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
        $this.pauseMirrorTopic(topic$2, true);
        Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
        $this.pauseMirrorTopic(topic$2, false);
        Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
        $this.pauseMirrorTopic(topic$2, false);
        Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
    }

    public static final /* synthetic */ boolean $anonfun$topicIsActiveMirror$1(ClusterLinkTopicState x$1) {
        return x$1 instanceof ClusterLinkTopicState.Mirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPausedMirror$1(ClusterLinkTopicState x$2) {
        return x$2 instanceof ClusterLinkTopicState.PausedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPendingStoppedMirror$1(ClusterLinkTopicState x$3) {
        return x$3 instanceof ClusterLinkTopicState.PendingStoppedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsStoppedMirror$1(ClusterLinkTopicState x$4) {
        return x$4 instanceof ClusterLinkTopicState.StoppedMirror;
    }

    public AlterMirrorsRequestTest() {
        this.linkName = "test-link";
    }

    public static final /* synthetic */ Object $anonfun$testStopMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1($this, localAdmin$1, topics$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClearMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1($this, localAdmin$2, activeTopic$1, stoppedTopic$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPauseMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1($this, localAdmin$3, topic$2, remoteCluster);
        return BoxedUnit.UNIT;
    }
}

