/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B#G\u0001-CQ\u0001\u0015\u0001\u0005\u0002ECqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\u00063\u0002!IA\u0017\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\ty\r\u0001C\u0001\u0003gCq!a5\u0001\t\u0003\t\u0019\fC\u0004\u0002X\u0002!\t!a-\t\u000f\u0005m\u0007\u0001\"\u0001\u00024\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\bb\u0002B\u0002\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u000f\u0001A\u0011AAZ\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003gCqAa\u0004\u0001\t\u0003\t\u0019\fC\u0004\u0003\u0014\u0001!\t!a-\t\u000f\t]\u0001\u0001\"\u0001\u00024\"9!1\u0004\u0001\u0005\u0002\u0005M\u0006b\u0002B\u0010\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005G\u0001A\u0011AAZ\u0011\u001d\u00119\u0003\u0001C\u0001\u0003gCqAa\u000b\u0001\t\u0003\t\u0019\fC\u0004\u00030\u0001!\t!a-\t\u000f\tM\u0002\u0001\"\u0001\u00024\"9!q\u0007\u0001\u0005\u0002\u0005M\u0006b\u0002B\u001e\u0001\u0011\u0005\u00111\u0017\u0005\b\u0005\u007f\u0001A\u0011AAZ\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003gCqAa\u0012\u0001\t\u0003\t\u0019\fC\u0004\u0003L\u0001!\t!a-\t\u000f\t=\u0003\u0001\"\u0001\u00024\"9!1\u000b\u0001\u0005\u0002\u0005M\u0006b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005k2AA\u001a\u0001EO\"A\u0011o\tBK\u0002\u0013\u0005!\u000f\u0003\u0005\u007fG\tE\t\u0015!\u0003t\u0011!y8E!f\u0001\n\u0003\u0011\b\"CA\u0001G\tE\t\u0015!\u0003t\u0011)\t\u0019a\tBK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003\u001b\u0019#\u0011#Q\u0001\n\u0005\u001d\u0001BCA\bG\tU\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011C\u0012\u0003\u0012\u0003\u0006I!a\u0002\t\rA\u001bC\u0011AA\n\u0011\u001d\tib\tC\u0001\u0003?A\u0011\"!\r$\u0003\u0003%\t!a\r\t\u0013\u0005u2%%A\u0005\u0002\u0005}\u0002\"CA+GE\u0005I\u0011AA \u0011%\t9fII\u0001\n\u0003\tI\u0006C\u0005\u0002^\r\n\n\u0011\"\u0001\u0002Z!I\u0011qL\u0012\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003G\u001a\u0013\u0011!C\u0001\u0003KB\u0011\"!\u001c$\u0003\u0003%\t!a\u001c\t\u0013\u0005m4%!A\u0005B\u0005u\u0004\"CAFG\u0005\u0005I\u0011AAG\u0011%\t9jIA\u0001\n\u0003\nI\nC\u0005\u0002\u001c\u000e\n\t\u0011\"\u0011\u0002\u001e\"I\u0011qT\u0012\u0002\u0002\u0013\u0005\u0013\u0011U\u0004\n\u0005\u001b\u0003\u0011\u0011!E\u0005\u0005\u001f3\u0001B\u001a\u0001\u0002\u0002#%!\u0011\u0013\u0005\u0007!r\"\tAa(\t\u0013\u0005mE(!A\u0005F\u0005u\u0005\"\u0003BQy\u0005\u0005I\u0011\u0011BR\u0011%\u0011i\u000bPI\u0001\n\u0003\tI\u0006C\u0005\u00030r\n\n\u0011\"\u0001\u0002Z!I!\u0011\u0017\u001f\u0002\u0002\u0013\u0005%1\u0017\u0005\n\u0005\u0003d\u0014\u0013!C\u0001\u00033B\u0011Ba1=#\u0003%\t!!\u0017\u0003-\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgRT!a\u0012%\u0002\rM,'O^3s\u0015\u0005I\u0015!B6bM.\f7\u0001A\n\u0003\u00011\u0003\"!\u0014(\u000e\u0003\u0019K!a\u0014$\u00035\t\u000b7/Z\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0006CA'\u0001\u0003\u0019\u0019wN\u001c4jOV\tQ\u000b\u0005\u0002N-&\u0011qK\u0012\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0011i\u0016\u001cH/U;pi\u0006\u0004\u0016M]:j]\u001e$\u0012bW1c\u0003K\u000bI+!,\u0011\u0005q{V\"A/\u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\u0012\u0001\r!\u0016\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\bG2LWM\u001c;2!\t)7%D\u0001\u0001\u0005))6/\u001a:DY&,g\u000e^\n\u0005G!\\g\u000e\u0005\u0002]S&\u0011!.\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qc\u0017BA7^\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001X8\n\u0005Al&\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B;tKJ,\u0012a\u001d\t\u0003int!!^=\u0011\u0005YlV\"A<\u000b\u0005aT\u0015A\u0002\u001fs_>$h(\u0003\u0002{;\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQX,A\u0003vg\u0016\u0014\b%\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0006d_:4\u0017nZ+tKJ,\"!a\u0002\u0011\tq\u000bIa]\u0005\u0004\u0003\u0017i&AB(qi&|g.A\u0006d_:4\u0017nZ+tKJ\u0004\u0013AD2p]\u001aLwm\u00117jK:$\u0018\nZ\u0001\u0010G>tg-[4DY&,g\u000e^%eAQIA-!\u0006\u0002\u0018\u0005e\u00111\u0004\u0005\u0006c2\u0002\ra\u001d\u0005\u0006\u007f2\u0002\ra\u001d\u0005\n\u0003\u0007a\u0003\u0013!a\u0001\u0003\u000fA\u0011\"a\u0004-!\u0003\u0005\r!a\u0002\u0002/M\fg.\u001b;ju\u0016$7i\u001c8gS\u001e\u001cE.[3oi&#WCAA\u0011!\u0015a\u0016\u0011BA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-C\u0002}\u0003O\tAaY8qsRIA-!\u000e\u00028\u0005e\u00121\b\u0005\bc:\u0002\n\u00111\u0001t\u0011\u001dyh\u0006%AA\u0002MD\u0011\"a\u0001/!\u0003\u0005\r!a\u0002\t\u0013\u0005=a\u0006%AA\u0002\u0005\u001d\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003R3a]A\"W\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAA(;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0013\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYF\u000b\u0003\u0002\b\u0005\r\u0013AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA4!\ra\u0016\u0011N\u0005\u0004\u0003Wj&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA9\u0003o\u00022\u0001XA:\u0013\r\t)(\u0018\u0002\u0004\u0003:L\b\"CA=k\u0005\u0005\t\u0019AA4\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0010\t\u0007\u0003\u0003\u000b9)!\u001d\u000e\u0005\u0005\r%bAAC;\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00151\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0010\u0006U\u0005c\u0001/\u0002\u0012&\u0019\u00111S/\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011P\u001c\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qM\u0001\ti>\u001cFO]5oOR\u0011\u00111E\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u00151\u0015\u0005\n\u0003sR\u0014\u0011!a\u0001\u0003cBa!a*\u0005\u0001\u0004!\u0017aB2mS\u0016tGO\r\u0005\u0007\u0003W#\u0001\u0019\u00013\u0002\u0019I\fg\u000eZ8n\u00072LWM\u001c;\t\r\u0005=F\u00011\u0001e\u0003M!WMZ1vYR\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0003a!Xm\u001d;DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u000b\u00027\"\u001aQ!a.\u0011\t\u0005e\u00161Z\u0007\u0003\u0003wSA!!0\u0002@\u0006\u0019\u0011\r]5\u000b\t\u0005\u0005\u00171Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t)-a2\u0002\u000b),h.\u001b;\u000b\u0005\u0005%\u0017aA8sO&!\u0011QZA^\u0005\u0011!Vm\u001d;\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r1\u0011qW\u0001\u001di\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r9\u0011qW\u0001-i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3\u0001CA\\\u0003Q\"Xm\u001d;Vg\u0016\u00148\t\\5f]R\fVo\u001c;b!\u0006\u00148/\u001b8h\u0013\u0012<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004\u0013\u0005]\u0016AC2iK\u000e\\\u0017+^8uCRi1,a9\u0002n\u0006=\u0018\u0011_A~\u0003\u007fDq!!:\u000b\u0001\u0004\t9/\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002N\u0003SL1!a;G\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u000bET\u0001\u0019A:\t\u000b}T\u0001\u0019A:\t\u000f\u0005M(\u00021\u0001\u0002v\u0006iQ\r\u001f9fGR,GMQ8v]\u0012\u00042\u0001XA|\u0013\r\tI0\u0018\u0002\u0005\u0019>tw\rC\u0004\u0002~*\u0001\r!a\u001a\u0002\u000bY\fG.^3\t\u000f\t\u0005!\u00021\u0001\u0002\u0010\u0006qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u000e;fgR<U\r^'bqZ\u000bG.^3J]F+x\u000e^1XS:$wn^,ji\"tuN\u001c#fM\u0006,H\u000e^)v_R\fw+\u001b8e_^D3aCA\\\u0003\u0001\"Xm\u001d;TKR\fe\u000e\u001a*f[>4X\rR3gCVdG/V:feF+x\u000e^1)\u00071\t9,A\ruKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM])v_R\f\u0007fA\u0007\u00028\u0006yB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\u001cE.[3oiF+x\u000e^1)\u00079\t9,A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007fA\b\u00028\u0006\u0011B/Z:u#V|G/\u0019,j_2\fG/[8oQ\r\u0001\u0012qW\u0001\u001di\u0016\u001cH/\u0012=qSJ,G\u000b\u001b:piRdW\rV5nKN+gn]8sQ\r\t\u0012qW\u0001\u0017i\u0016\u001cH/\u0012=qSJ,\u0017+^8uCN+gn]8sg\"\u001a!#a.\u00021Q,7\u000f^\"mS\u0016tG/\u00133O_R\u001c\u0016M\\5uSj,G\rK\u0002\u0014\u0003o\u000bq\u0004^3tiVs\u0017N^3sg\u0006d\u0017\u000e^=PM\u0006\u001bG/\u001b<f)\u0016t\u0017M\u001c;tQ\r!\u0012qW\u0001\u001di\u0016\u001cHO\u0012:fcV,gnY=PM\u0006+Ho\u001c+v]\u0016\fVo\u001c;bQ\r)\u0012qW\u0001\u001ei\u0016\u001cH/\u00138bGRLg/\u001a+f]\u0006tGo\u001d*fg\u0016$\u0018+^8uC\"\u001aa#a.\u0002WQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1BY2\f%m\u001c<f\r\u0006L'\u000fT5nSRD3aFA\\\u0003A\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u0003\n|g/Z!oI\n+Gn\\<GC&\u0014H*[7ji\"\u001a\u0001$a.\u0002WQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1BY2\u0014U\r\\8x\r\u0006L'\u000fT5nSRD3!GA\\\u0003%\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u001bVdG/\u001b9mKR+g.\u00198ug\"\u001a!$a.\u0002QQ,7\u000f^!vi>$VO\\3XSRD7\t[1oO&twM\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;)\u0007m\t9,A\u0016uKN$\u0018)\u001e;p)VtWmV5uQ\u000eC\u0017M\\4j]\u001e|%/[4j]\u0006d7\t\\5f]R\fVo\u001c;bQ\ra\u0012qW\u0001'i\u0016\u001cH/Q;u_R+h.Z,iK:\u001cE.[3oiN#x\u000e]:TK:$\u0017N\\4M_\u0006$\u0007fA\u000f\u00028\u0006\u0019D/Z:u\u0003V$x\u000eV;oK^CWM\\\"mS\u0016tG/V:bO\u0016$Um\u0019:fCNLgnZ!gi\u0016\u0014H\u000b\u001b:piRdW\r\u001a\u0015\u0004=\u0005]\u0016!\u000b;fgR\u0004&o\u001c3vG\u0016\u0014\u0018j\u001d+ie>$H\u000f\\3e/\",g\u000eR5tWN\u0003\u0018mY3Jg2{w\u000fK\u0002 \u0003o\u000bq\"\\5mY&\u001cHk\u001c)fe\u000e,g\u000e\u001e\u000b\u0005\u00057\u0012\t\u0007E\u0002]\u0005;J1Aa\u0018^\u0005\u0019!u.\u001e2mK\"9!1\r\u0011A\u0002\tm\u0013AB7jY2L7/\u0001\u0006nKR\u0014\u0018n\u0019+bON$bA!\u001b\u0003p\tE\u0004#\u0002;\u0003lM\u001c\u0018b\u0001B7{\n\u0019Q*\u00199\t\u000bE\f\u0003\u0019A:\t\u000b}\f\u0003\u0019A:\u0002\u00159,w/T3ue&\u001c7/\u0006\u0002\u0003xA!!\u0011\u0010BE\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014aB7fiJL7m\u001d\u0006\u0005\u0005\u0003\u0013\u0019)\u0001\u0004d_6lwN\u001c\u0006\u0004\u0013\n\u0015%\u0002\u0002BD\u0003\u000f\fa!\u00199bG\",\u0017\u0002\u0002BF\u0005w\u0012q!T3ue&\u001c7/\u0001\u0006Vg\u0016\u00148\t\\5f]R\u0004\"!\u001a\u001f\u0014\tq\u0012\u0019J\u001c\t\f\u0005+\u0013Yj]:\u0002\b\u0005\u001dA-\u0004\u0002\u0003\u0018*\u0019!\u0011T/\u0002\u000fI,h\u000e^5nK&!!Q\u0014BL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0005\u001f\u000bQ!\u00199qYf$\u0012\u0002\u001aBS\u0005O\u0013IKa+\t\u000bE|\u0004\u0019A:\t\u000b}|\u0004\u0019A:\t\u0013\u0005\rq\b%AA\u0002\u0005\u001d\u0001\"CA\b\u007fA\u0005\t\u0019AA\u0004\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0017B_!\u0015a\u0016\u0011\u0002B\\!%a&\u0011X:t\u0003\u000f\t9!C\u0002\u0003<v\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B`\u0005\u0006\u0005\t\u0019\u00013\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5());

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5());
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                this.time().sleep((long)Math.max(100, throttleTime));
            });
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                this.time().sleep((long)Math.max(100, throttleTime));
            });
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime1 = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                this.time().sleep((long)Math.max(100, throttleTime1));
            });
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            Assertions.assertEquals((double)quotaManager.quota("", "Client1").bound(), (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime1 = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                int throttleTime2 = this.maybeRecord(quotaManager, "", "Client2", 300.0);
                this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime1 = this.maybeRecord(quotaManager, "", "Client1", 350.0);
                int throttleTime2 = this.maybeRecord(quotaManager, "", "Client2", 200.0);
                this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTime1 = this.maybeRecord(quotaManager, "", "Client1", 200.0);
                int throttleTime2 = this.maybeRecord(quotaManager, "", "Client2", 200.0);
                this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)quotaManager.quota("", "Client2").bound(), (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assertions.assertEquals((double)quotaManager.quota("", "Client2").bound(), (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                List throttles = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)}));
                this.time().sleep((long)Math.max(1000, BoxesRunTime.unboxToInt((Object)throttles.max((Ordering)Ordering.Int$.MODULE$))));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)175.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assertions.assertEquals((double)150.0, (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
            Assertions.assertEquals((double)175.0, (double)quotaManager.dynamicQuota("", "Client3").bound(), (double)0.0);
            Assertions.assertEquals((double)125.0, (double)quotaManager.dynamicQuota("", "Client4").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        double x$1 = 250.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTimeMs = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                this.time().sleep((long)Math.max(1000, throttleTimeMs));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        double x$1 = 250.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTimeMs = this.maybeRecord(quotaManager, "", "Client1", 300.0);
                this.time().sleep((long)Math.max(1000, throttleTimeMs));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)200.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C1", 200.0);
                int throttleTimeMs2 = this.maybeRecord(quotaManager, "", "C2", 400.0);
                this.time().sleep((long)Math.max(1000, Math.max(throttleTimeMs1, throttleTimeMs2)));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
                this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        double x$1 = 500.0;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$1);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
                this.time().sleep(1000L);
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C1", 100.0);
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 100.0));
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.time().milliseconds());
            Assertions.assertEquals((double)330.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        .colon.colon x$2 = new .colon.colon((Object)((Object)tempLogDir).toString(), (List)Nil$.MODULE$);
        boolean x$3 = true;
        long x$4 = 1000L;
        long x$5 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1();
        double x$6 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6();
        boolean x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7();
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$5, x$1, (Seq)x$2, x$3, x$4, x$6, x$7);
        long x$9 = 300L;
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, x$9, x$10, x$11, x$12, x$13, x$14);
        int x$15 = 2;
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(BrokerBackpressureConfig$.MODULE$.apply$default$1(), BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        int x$18 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        double x$19 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$15, x$18, x$16, diskThrottlingConfig, x$19);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                String x$5 = "";
                Some x$6 = new Some((Object)activeTenantsManager$1);
                Option x$7 = ClientQuotaManager$.MODULE$.$lessinit$greater$default$6();
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, x$5, x$7, (Option)x$6);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private final ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    private class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

