/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.LinkState;
import kafka.server.link.PausedClusterLink$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.DescribeMirrorsRequest;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;
import org.apache.kafka.common.requests.ListClusterLinksRequest;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListMirrorsRequest;
import org.apache.kafka.common.requests.ListMirrorsResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B A\u0001\u0015CQA\u0013\u0001\u0005\u0002-CQ!\u0014\u0001\u0005B9CQ!\u0016\u0001\u0005RYCQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001d\u0001\u0005\u0002\u0015DQ!\u001e\u0001\u0005\u0002\u0015DQa\u001e\u0001\u0005\u0002\u0015DQ!\u001f\u0001\u0005\u0002\u0015DQa\u001f\u0001\u0005\u0002\u0015DQ! \u0001\u0005\u0002\u0015DQa \u0001\u0005\u0002\u0015Da!a\u0001\u0001\t\u0003)\u0007BBA\u0004\u0001\u0011\u0005Q\r\u0003\u0004\u0002\f\u0001!\t!\u001a\u0005\u0007\u0003\u001f\u0001A\u0011A3\t\r\u0005M\u0001\u0001\"\u0001f\u0011\u0019\t9\u0002\u0001C\u0001K\"1\u00111\u0004\u0001\u0005\u0002\u0015Da!a\b\u0001\t\u0003)\u0007BBA\u0012\u0001\u0011\u0005Q\r\u0003\u0004\u0002(\u0001!\t!\u001a\u0005\u0007\u0003W\u0001A\u0011A3\t\r\u0005=\u0002\u0001\"\u0001f\u0011\u0019\t\u0019\u0004\u0001C\u0001K\"1\u0011q\u0007\u0001\u0005\u0002\u0015Da!a\u000f\u0001\t\u0003)\u0007BBA \u0001\u0011\u0005Q\r\u0003\u0004\u0002D\u0001!\t!\u001a\u0005\u0007\u0003\u000f\u0002A\u0011A3\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007D\u0011\"a8\u0001#\u0003%I!!9\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9\u0011Q \u0001\u0005\n\u0005}\b\"\u0003B\u0018\u0001E\u0005I\u0011\u0002B\u0019\u0011%\u0011)\u0004AI\u0001\n\u0013\u00119\u0004C\u0004\u0003<\u0001!IA!\u0010\t\u000f\tU\u0003\u0001\"\u0003\u0003X!I!\u0011\u0010\u0001\u0012\u0002\u0013%!1\u0010\u0005\n\u0005\u007f\u0002\u0011\u0013!C\u0005\u0005\u0003C\u0011B!\"\u0001#\u0003%IA!\r\t\u0013\t\u001d\u0005!%A\u0005\n\t]\u0002b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u00057\u0003A\u0011\u0002BO\u0011%\u0011Y\u000bAI\u0001\n\u0013\u0011\t\u0004C\u0005\u0003.\u0002\t\n\u0011\"\u0003\u00038!9!q\u0016\u0001\u0005\n\tE\u0006b\u0002Bb\u0001\u0011%!Q\u0019\u0005\n\u00053\u0004\u0011\u0013!C\u0005\u0005\u0003C\u0011Ba7\u0001#\u0003%IA!\r\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\f\u0001\u0011%1\u0011\u0004\u0005\n\u0007O\u0001\u0011\u0013!C\u0005\u0005\u0003C\u0011b!\u000b\u0001#\u0003%IA!\r\t\u000f\r-\u0002\u0001\"\u0003\u0004.!91Q\b\u0001\u0005\n\r}\u0002\"CB&\u0001E\u0005I\u0011\u0002B\u0019\u0011\u001d\u0019i\u0005\u0001C\u0005\u0007\u001f\u0012qc\u00117vgR,'\u000fT5oWN\u0014V-];fgR$Vm\u001d;\u000b\u0005\u0005\u0013\u0015AB:feZ,'OC\u0001D\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001$\u0011\u0005\u001dCU\"\u0001!\n\u0005%\u0003%a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005a\u0005CA$\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)F\u00131!\u00138u\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002X5B\u0011\u0001\u000bW\u0005\u00033F\u0013A!\u00168ji\")1l\u0001a\u00019\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001B;uS2T\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\nQ\u0001K]8qKJ$\u0018.Z:\u0002-Q,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWN$\u0012a\u0016\u0015\u0003\t\u001d\u0004\"\u0001[9\u000e\u0003%T!A[6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002m[\u00069!.\u001e9ji\u0016\u0014(B\u00018p\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0018aA8sO&\u0011!/\u001b\u0002\u0005)\u0016\u001cH/\u0001\u0011uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t/&$\bNU3n_R,\u0007FA\u0003h\u0003\t\"Xm\u001d;De\u0016\fG/Z\"mkN$XM\u001d'j].\u001ch+\u00197jI\u0006$Xm\u00148ms\"\u0012aaZ\u0001\u001di\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgR{7+\u001a7gQ\t9q-A\u0010uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t\u000b6\u0004H/\u001f(b[\u0016D#\u0001C4\u0002CQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWNLeN^1mS\u0012t\u0015-\\3)\u0005%9\u0017A\t;fgR\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:J]Z\fG.\u001b3Qe>\u00048\u000f\u000b\u0002\u000bO\u00069C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\\u0017J\u001c<bY&$7\t\\5f]R\u0004&o\u001c9tQ\tYq-A\u0012uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t\tV\u0004H.[2bi\u0016t\u0015-\\3)\u000519\u0017a\t;fgR\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u0015\u0003\u001b\u001d\f\u0001\u0006^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d#va2L7-\u0019;f\u00072,8\u000f^3s\u0013\u0012D#AD4\u0002CQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWNtun\u00117vgR,'/\u00133)\u0005=9\u0017a\u0007;fgR\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:F[B$\u0018\u0010\u000b\u0002\u0011O\u00069C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3n_R,WK\u001c:fC\u000eD\u0017M\u00197fQ\t\tr-\u0001\u000buKN$H*[:u\u00072,8\u000f^3s\u0019&t7n\u001d\u0015\u0003%\u001d\fa\u0004^3ti2K7\u000f^\"mkN$XM\u001d'j].\u001cx+\u001b;i)>\u0004\u0018nY:)\u0005M9\u0017A\u0006;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn[:)\u0005Q9\u0017A\t;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn[:WC2LG-\u0019;f\u001f:d\u0017\u0010\u000b\u0002\u0016O\u0006\tC/Z:u\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7OT8oKbL7\u000f^3oi\"\u0012acZ\u0001\u001di\u0016\u001cH\u000fR3mKR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0007/Z1uQ\t9r-A\u0010uKN$H)\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6t\u000b6\u0004H/\u001f(b[\u0016D#\u0001G4\u0002CQ,7\u000f\u001e#fY\u0016$Xm\u00117vgR,'\u000fT5oWNLeN^1mS\u0012t\u0015-\\3)\u0005e9\u0017a\t;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn[:EkBd\u0017nY1uK:\u000bW.\u001a\u0015\u00035\u001d\fQ\u0003^3tiB\u000bWo]3DYV\u001cH/\u001a:MS:\\7\u000f\u000b\u0002\u001cO\u0006\u0001C/Z:u\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7oV5uQJ+Wn\u001c;fQ\tar-\u0001\u0013uKN$8\t\\;ti\u0016\u0014H*\u001b8lg\u0012K7/\u00192mK\u0012\u001cu.\u001c2j]\u0006$\u0018n\u001c8tQ\tir-\u0001\ruKN$8\t\\;ti\u0016\u0014H*\u001b8lg\u0012K7/\u00192mK\u0012$2aVA(\u0011\u001d\t\tF\ba\u0001\u0003'\n\u0011\u0003^3ti\u000e{W\u000e]1uS\nLG.\u001b;z!\r\u0001\u0016QK\u0005\u0004\u0003/\n&a\u0002\"p_2,\u0017M\\\u0001\u0015eVtw+\u001b;i%\u0016lw\u000e^3DYV\u001cH/\u001a:\u0015\u0007]\u000bi\u0006C\u0004\u0002`}\u0001\r!!\u0019\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\"\u0002UA2\u0003O\ni(a!X\u0013\r\t)'\u0015\u0002\n\rVt7\r^5p]N\u0002B!!\u001b\u0002x9!\u00111NA:!\r\ti'U\u0007\u0003\u0003_R1!!\u001dE\u0003\u0019a$o\\8u}%\u0019\u0011QO)\u0002\rA\u0013X\rZ3g\u0013\u0011\tI(a\u001f\u0003\rM#(/\u001b8h\u0015\r\t)(\u0015\t\u0006!\u0006}\u0014qM\u0005\u0004\u0003\u0003\u000b&AB(qi&|g\u000e\u0005\u0003\u0002\u0006\u0006UUBAAD\u0015\u0011\tI)a#\u0002\u000b\u0005$W.\u001b8\u000b\t\u00055\u0015qR\u0001\bG2LWM\u001c;t\u0015\r\u0019\u0015\u0011\u0013\u0006\u0004\u0003'{\u0017AB1qC\u000eDW-\u0003\u0003\u0002\u0018\u0006\u001d%AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0019CN\u001cXM\u001d;DYV\u001cH/\u001a:MS:\\7/R9vC2\u001cHcA,\u0002\u001e\"9\u0011q\u0014\u0011A\u0002\u0005\u0005\u0016!\u00037j].t\u0015-\\3t!\u0019\t\u0019+!,\u0002h9!\u0011QUAU\u001d\u0011\ti'a*\n\u0003IK1!a+R\u0003\u001d\u0001\u0018mY6bO\u0016LA!a,\u00022\nA\u0011\n^3sC\ndWMC\u0002\u0002,F\u000b\u0011c\u0019:fCR,G*\u001b8lK\u0012$v\u000e]5d)\u001d9\u0016qWA]\u0003{Cq!!#\"\u0001\u0004\t\u0019\tC\u0004\u0002<\u0006\u0002\r!a\u001a\u0002\u000bQ|\u0007/[2\t\u000f\u0005}\u0016\u00051\u0001\u0002~\u0005AA.\u001b8l\u001d\u0006lW-A\toK^tUm^\"mkN$XM\u001d'j].$\"\"!2\u0002L\u00065\u0017\u0011[An!\u0011\t))a2\n\t\u0005%\u0017q\u0011\u0002\u000f\u001d\u0016<8\t\\;ti\u0016\u0014H*\u001b8l\u0011\u001d\tyL\ta\u0001\u0003OBq!a4#\u0001\u0004\ti(A\u0005dYV\u001cH/\u001a:JI\"9\u00111\u001b\u0012A\u0002\u0005U\u0017aB2p]\u001aLwm\u001d\t\t\u0003S\n9.a\u001a\u0002h%!\u0011\u0011\\A>\u0005\ri\u0015\r\u001d\u0005\n\u0003;\u0014\u0003\u0013!a\u0001\u0003O\n\u0001CY8piN$(/\u00199TKJ4XM]:\u000279,wOT3x\u00072,8\u000f^3s\u0019&t7\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019O\u000b\u0003\u0002h\u0005\u00158FAAt!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E\u0018+\u0001\u0006b]:|G/\u0019;j_:LA!!>\u0002l\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r\u0014X-\u0019;f\u0005\u0006\u001c\u0018nY\"mkN$XM\u001d'j].\u001cHcA,\u0002|\"9\u0011q\u0014\u0013A\u0002\u0005\u0005\u0016AE2sK\u0006$Xm\u00117vgR,'\u000fT5oWN$BB!\u0001\u0003\u0014\te!Q\u0004B\u0011\u0005K\u0001\u0002\"!\u001b\u0002X\u0006\u001d$1\u0001\t\u0005\u0005\u000b\u0011y!\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003!\u0001(o\u001c;pG>d'\u0002\u0002B\u0007\u0003\u001f\u000baaY8n[>t\u0017\u0002\u0002B\t\u0005\u000f\u0011a!\u0012:s_J\u001c\bb\u0002B\u000bK\u0001\u0007!qC\u0001\u0010]\u0016<8\t\\;ti\u0016\u0014H*\u001b8lgB1\u00111UAW\u0003\u000bDqAa\u0007&\u0001\u0004\t\u0019&\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010C\u0004\u0003 \u0015\u0002\r!a\u0015\u0002\u0019Y\fG.\u001b3bi\u0016d\u0015N\\6\t\u0011\t\rR\u0005%AA\u0002=\u000b\u0011\u0002^5nK>,H/T:\t\u0013\t\u001dR\u0005%AA\u0002\t%\u0012A\u0004:fcV,7\u000f\u001e,feNLwN\u001c\t\u0004!\n-\u0012b\u0001B\u0017#\n)1\u000b[8si\u0006a2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6tI\u0011,g-Y;mi\u0012\"TC\u0001B\u001aU\ry\u0015Q]\u0001\u001dGJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011ID\u000b\u0003\u0003*\u0005\u0015\u0018!H:f]\u0012\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;\u0015\u0019\t}\"1\nB'\u0005\u001f\u0012\tFa\u0015\u0011\t\t\u0005#qI\u0007\u0003\u0005\u0007RAA!\u0012\u0003\f\u0005A!/Z9vKN$8/\u0003\u0003\u0003J\t\r#AG\"sK\u0006$Xm\u00117vgR,'\u000fT5oWN\u0014Vm\u001d9p]N,\u0007b\u0002B\u000bQ\u0001\u0007!q\u0003\u0005\b\u00057A\u0003\u0019AA*\u0011\u001d\u0011y\u0002\u000ba\u0001\u0003'BaAa\t)\u0001\u0004y\u0005b\u0002B\u0014Q\u0001\u0007!\u0011F\u0001\u0011Y&\u001cHo\u00117vgR,'\u000fT5oWN$\"B!\u0017\u0003l\tE$Q\u000fB<!\u001d\u0001&1\fB0\u0005\u0007I1A!\u0018R\u0005\u0019!V\u000f\u001d7feA1\u0011\u0011\u000eB1\u0005KJAAa\u0019\u0002|\t\u00191+\u001a;\u0011\t\u0005\u0015%qM\u0005\u0005\u0005S\n9I\u0001\nDYV\u001cH/\u001a:MS:\\G*[:uS:<\u0007\"CAPSA\u0005\t\u0019\u0001B7!\u0015\u0001\u0016q\u0010B8!\u0019\tIG!\u0019\u0002h!I!1O\u0015\u0011\u0002\u0003\u0007\u00111K\u0001\u000eS:\u001cG.\u001e3f)>\u0004\u0018nY:\t\u0011\t\r\u0012\u0006%AA\u0002=C\u0011Ba\n*!\u0003\u0005\rA!\u000b\u000251L7\u000f^\"mkN$XM\u001d'j].\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu$\u0006\u0002B7\u0003K\f!\u0004\\5ti\u000ecWo\u001d;fe2Kgn[:%I\u00164\u0017-\u001e7uII*\"Aa!+\t\u0005M\u0013Q]\u0001\u001bY&\u001cHo\u00117vgR,'\u000fT5oWN$C-\u001a4bk2$HeM\u0001\u001bY&\u001cHo\u00117vgR,'\u000fT5oWN$C-\u001a4bk2$H\u0005N\u0001\u001cg\u0016tG\rT5ti\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;\u0015\u0015\t5%1\u0013BK\u0005/\u0013I\n\u0005\u0003\u0003B\t=\u0015\u0002\u0002BI\u0005\u0007\u0012\u0001\u0004T5ti\u000ecWo\u001d;fe2Kgn[:SKN\u0004xN\\:f\u0011\u001d\tyJ\fa\u0001\u0005[BqAa\u001d/\u0001\u0004\t\u0019\u0006\u0003\u0004\u0003$9\u0002\ra\u0014\u0005\b\u0005Oq\u0003\u0019\u0001B\u0015\u0003I!W\r\\3uK\u000ecWo\u001d;fe2Kgn[:\u0015\u0019\t\u0005!q\u0014BQ\u0005G\u00139K!+\t\u000f\u0005}u\u00061\u0001\u0002\"\"9!1D\u0018A\u0002\u0005M\u0003b\u0002BS_\u0001\u0007\u00111K\u0001\u0006M>\u00148-\u001a\u0005\t\u0005Gy\u0003\u0013!a\u0001\u001f\"I!qE\u0018\u0011\u0002\u0003\u0007!\u0011F\u0001\u001dI\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003q!W\r\\3uK\u000ecWo\u001d;fe2Kgn[:%I\u00164\u0017-\u001e7uIU\nQd]3oI\u0012+G.\u001a;f\u00072,8\u000f^3s\u0019&t7n\u001d*fcV,7\u000f\u001e\u000b\r\u0005g\u0013ILa/\u0003>\n}&\u0011\u0019\t\u0005\u0005\u0003\u0012),\u0003\u0003\u00038\n\r#A\u0007#fY\u0016$Xm\u00117vgR,'\u000fT5oWN\u0014Vm\u001d9p]N,\u0007bBAPe\u0001\u0007\u0011\u0011\u0015\u0005\b\u00057\u0011\u0004\u0019AA*\u0011\u001d\u0011)K\ra\u0001\u0003'BaAa\t3\u0001\u0004y\u0005b\u0002B\u0014e\u0001\u0007!\u0011F\u0001\fC2$XM]'jeJ|'\u000f\u0006\u0007\u0003\u0002\t\u001d'\u0011\u001aBj\u0005+\u00149\u000eC\u0004\u0002<N\u0002\r!a\u001a\t\u000f\t-7\u00071\u0001\u0003N\u0006\u0011q\u000e\u001d\t\u0005\u0003\u000b\u0013y-\u0003\u0003\u0003R\u0006\u001d%!D!mi\u0016\u0014X*\u001b:s_J|\u0005\u000fC\u0005\u0003\u001cM\u0002\n\u00111\u0001\u0002T!A!1E\u001a\u0011\u0002\u0003\u0007q\nC\u0004\u0003(M\u0002\rA!\u000b\u0002+\u0005dG/\u001a:NSJ\u0014xN\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005)\u0012\r\u001c;fe6K'O]8sI\u0011,g-Y;mi\u0012\"\u0014\u0001D1mi\u0016\u0014X*\u001b:s_J\u001cHC\u0003B\u0001\u0005C\u0014yp!\u0001\u0004\u0004!9!1\u001d\u001cA\u0002\t\u0015\u0018aA8qgB1\u00111\u0015Bt\u0005WLAA!;\u00022\n!A*[:u!\u0011\u0011iO!?\u000f\t\t=(Q_\u0007\u0003\u0005cTAAa=\u0003\f\u00059Q.Z:tC\u001e,\u0017\u0002\u0002B|\u0005c\fq#\u00117uKJl\u0015N\u001d:peN\u0014V-];fgR$\u0015\r^1\n\t\tm(Q \u0002\u0010\u001b&\u0014(o\u001c:Pa\u0016\u0014\u0018\r^5p]*!!q\u001fBy\u0011\u001d\u0011YB\u000ea\u0001\u0003'BaAa\t7\u0001\u0004y\u0005b\u0002B\u0014m\u0001\u0007!\u0011F\u0001\u0018g\u0016tG-\u00117uKJl\u0015N\u001d:peN\u0014V-];fgR$\"b!\u0003\u0004\u0010\rE11CB\u000b!\u0011\u0011\tea\u0003\n\t\r5!1\t\u0002\u0015\u00032$XM]'jeJ|'o\u001d*fgB|gn]3\t\u000f\t\rx\u00071\u0001\u0003f\"9!1D\u001cA\u0002\u0005M\u0003B\u0002B\u0012o\u0001\u0007q\nC\u0004\u0003(]\u0002\rA!\u000b\u0002\u00171L7\u000f^'jeJ|'o\u001d\u000b\u000b\u00077\u0019iba\b\u0004$\r\u0015\u0002c\u0002)\u0003\\\t=$1\u0001\u0005\b\u0003\u007fC\u0004\u0019AA4\u0011%\u0019\t\u0003\u000fI\u0001\u0002\u0004\t\u0019&\u0001\bj]\u000edW\u000fZ3Ti>\u0004\b/\u001a3\t\u0011\t\r\u0002\b%AA\u0002=CqAa\n9\u0001\u0004\u0011I#A\u000bmSN$X*\u001b:s_J\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002+1L7\u000f^'jeJ|'o\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u000512/\u001a8e\u0019&\u001cH/T5se>\u00148OU3rk\u0016\u001cH\u000f\u0006\u0006\u00040\rU2qGB\u001d\u0007w\u0001BA!\u0011\u00042%!11\u0007B\"\u0005Ma\u0015n\u001d;NSJ\u0014xN]:SKN\u0004xN\\:f\u0011\u001d\tyl\u000fa\u0001\u0003OBqa!\t<\u0001\u0004\t\u0019\u0006\u0003\u0004\u0003$m\u0002\ra\u0014\u0005\b\u0005OY\u0004\u0019\u0001B\u0015\u0003=!Wm]2sS\n,W*\u001b:s_J\u001cH\u0003\u0003B\u0001\u0007\u0003\u001a9e!\u0013\t\u000f\r\rC\b1\u0001\u0004F\u0005QAo\u001c9jG:\u000bW.Z:\u0011\r\u0005\r&q]A4\u0011!\u0011\u0019\u0003\u0010I\u0001\u0002\u0004y\u0005b\u0002B\u0014y\u0001\u0007!\u0011F\u0001\u001aI\u0016\u001c8M]5cK6K'O]8sg\u0012\"WMZ1vYR$#'\u0001\u000etK:$G)Z:de&\u0014W-T5se>\u00148OU3rk\u0016\u001cH\u000f\u0006\u0005\u0004R\r]3\u0011LB.!\u0011\u0011\tea\u0015\n\t\rU#1\t\u0002\u0018\t\u0016\u001c8M]5cK6K'O]8sgJ+7\u000f]8og\u0016Dqaa\u0011?\u0001\u0004\u0019)\u0005\u0003\u0004\u0003$y\u0002\ra\u0014\u0005\b\u0005Oq\u0004\u0019\u0001B\u0015\u0001")
public class ClusterLinksRequestTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
    }

    @Test
    public void testCreateClusterLinks() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster-1", (Option<String>)new Some((Object)"cluster-id-1"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)new .colon.colon((Object)this.newNewClusterLink("cluster-2", (Option<String>)new Some((Object)"cluster-id-2"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"10000")}))), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$));
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLinks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.linkName(), Seq$.MODULE$.canBuildFrom())));
    }

    @Test
    public void testCreateClusterLinksWithRemote() {
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new IntegrationTestHarness(null){

            public int brokerCount() {
                return 1;
            }
        };
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            ConfluentAdmin runWithRemoteCluster_admin = runWithRemoteCluster_remoteCluster.createAdminClient(runWithRemoteCluster_remoteCluster.createAdminClient$default$1());
            String runWithRemoteCluster_clusterId = (String)runWithRemoteCluster_admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            ConfluentAdmin confluentAdmin = runWithRemoteCluster_admin;
            Option option = Option$.MODULE$.apply((Object)runWithRemoteCluster_clusterId);
            String string = runWithRemoteCluster_remoteCluster.brokerList();
            ClusterLinksRequestTest.$anonfun$testCreateClusterLinksWithRemote$1(this, string, option, confluentAdmin);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testCreateClusterLinksValidateOnly() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)new Some((Object)"cluster-id"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, true, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksToSelf() {
        String clusterId = (String)this.createAdminClient(this.createAdminClient$default$1()).describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)new Some((Object)clusterId), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_REQUEST), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, true, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksEmptyName() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("", (Option<String>)new Some((Object)"cluster-id"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_CLUSTER_LINK), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksInvalidName() {
        .colon.colon newClusterLink = new .colon.colon((Object)this.newNewClusterLink("cluster+1", (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLink.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_CLUSTER_LINK), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLink, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksInvalidProps() {
        this.verifyCreateClusterLink$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)"invalid")})));
        this.verifyCreateClusterLink$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)"invalid")})));
        this.verifyCreateClusterLink$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp()), (Object)"invalid")})));
    }

    @Test
    public void testCreateClusterLinkInvalidClientProps() {
        String linkName = "testlink1";
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            ConfluentAdmin runWithRemoteCluster_admin = runWithRemoteCluster_remoteCluster.createAdminClient(runWithRemoteCluster_remoteCluster.createAdminClient$default$1());
            String runWithRemoteCluster_clusterId = (String)runWithRemoteCluster_admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            ConfluentAdmin confluentAdmin = runWithRemoteCluster_admin;
            Option option = Option$.MODULE$.apply((Object)runWithRemoteCluster_clusterId);
            String string = runWithRemoteCluster_remoteCluster.brokerList();
            ClusterLinksRequestTest.$anonfun$testCreateClusterLinkInvalidClientProps$1(this, linkName, string, option, confluentAdmin);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testCreateClusterLinksDuplicateName() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)new Some((Object)"cluster-id"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)new Some((Object)"cluster-id"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"10000")}))), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$));
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_REQUEST), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksAlreadyExists() {
        .colon.colon newClusterLink = new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)new Some((Object)"cluster-id"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults1 = ((TraversableOnce)newClusterLink.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results1 = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLink, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults1, results1);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLink.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.linkName(), Seq$.MODULE$.canBuildFrom())));
        scala.collection.immutable.Map expectedResults2 = ((TraversableOnce)newClusterLink.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.CLUSTER_LINK_EXISTS), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results2 = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLink, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults2, results2);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLink.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.linkName(), Seq$.MODULE$.canBuildFrom())));
    }

    @Test
    public void testCreateClusterLinksDuplicateClusterId() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster-1", (Option<String>)new Some((Object)"shared-cluster-id"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)new .colon.colon((Object)this.newNewClusterLink("cluster-2", (Option<String>)new Some((Object)"shared-cluster-id"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"10000")}))), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$));
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLinks.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.linkName(), Seq$.MODULE$.canBuildFrom())));
    }

    @Test
    public void testCreateClusterLinksNoClusterId() {
        .colon.colon newClusterLink = new .colon.colon((Object)this.newNewClusterLink("cluster-1", (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLink.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLink, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLink.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.linkName(), Seq$.MODULE$.canBuildFrom())));
    }

    @Test
    public void testCreateClusterLinksEmpty() {
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)Nil$.MODULE$, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testCreateClusterLinksRemoteUnreachable() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster", (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), "doesnt-exist:12345"), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_CONFIG), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, true, 1000, this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListClusterLinks() {
        void var16_16;
        void var15_15;
        void var10_10;
        void var9_9;
        void var4_4;
        void var3_3;
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)Errors.NONE), this.listClusterLinks(this.listClusterLinks$default$1(), this.listClusterLinks$default$2(), this.listClusterLinks$default$3(), this.listClusterLinks$default$4()));
        .colon.colon linkNames = new .colon.colon((Object)"cluster-1", (List)new .colon.colon((Object)"cluster-2", (List)new .colon.colon((Object)"cluster-3", (List)Nil$.MODULE$)));
        this.createBasicClusterLinks((Iterable<String>)linkNames);
        Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> tuple2 = this.listClusterLinks(this.listClusterLinks$default$1(), this.listClusterLinks$default$2(), this.listClusterLinks$default$3(), this.listClusterLinks$default$4());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set results1 = (scala.collection.immutable.Set)tuple2._1();
        Errors error1 = (Errors)tuple2._2();
        void results12 = var3_3;
        void error12 = var4_4;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error12);
        Assertions.assertEquals((Object)linkNames.toSet(), (Object)results12.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.linkName(), Set$.MODULE$.canBuildFrom()));
        Assertions.assertFalse((boolean)results12.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$testListClusterLinks$2(x$10))));
        scala.collection.immutable.Set subLinkNames = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)linkNames.apply(0), (String)linkNames.apply(2)}));
        Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> tuple22 = this.listClusterLinks((Option<scala.collection.immutable.Set<String>>)new Some((Object)subLinkNames), this.listClusterLinks$default$2(), this.listClusterLinks$default$3(), this.listClusterLinks$default$4());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set results2 = (scala.collection.immutable.Set)tuple22._1();
        Errors error2 = (Errors)tuple22._2();
        void results22 = var9_9;
        void error22 = var10_10;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error22);
        Assertions.assertEquals((Object)subLinkNames, (Object)results22.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.linkName(), Set$.MODULE$.canBuildFrom()));
        Assertions.assertFalse((boolean)results22.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$testListClusterLinks$4(x$13))));
        scala.collection.immutable.Set otherLinkNames = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"other-1", "other-2"}));
        Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> tuple23 = this.listClusterLinks((Option<scala.collection.immutable.Set<String>>)new Some((Object)otherLinkNames), this.listClusterLinks$default$2(), this.listClusterLinks$default$3(), this.listClusterLinks$default$4());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set results3 = (scala.collection.immutable.Set)tuple23._1();
        Errors error3 = (Errors)tuple23._2();
        void results32 = var15_15;
        void error32 = var16_16;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error32);
        Assertions.assertTrue((boolean)results32.isEmpty());
    }

    @Test
    public void testListClusterLinksWithTopics() {
        ConfluentAdmin localAdmin = this.createAdminClient(this.createAdminClient$default$1());
        String linkName = "link-name";
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3"}));
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            ConfluentAdmin runWithRemoteCluster_admin = runWithRemoteCluster_remoteCluster.createAdminClient(runWithRemoteCluster_remoteCluster.createAdminClient$default$1());
            String runWithRemoteCluster_clusterId = (String)runWithRemoteCluster_admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            ConfluentAdmin confluentAdmin = runWithRemoteCluster_admin;
            Option option = Option$.MODULE$.apply((Object)runWithRemoteCluster_clusterId);
            String string = runWithRemoteCluster_remoteCluster.brokerList();
            ClusterLinksRequestTest.$anonfun$testListClusterLinksWithTopics$1(this, linkName, topics, localAdmin, string, option, confluentAdmin);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testDeleteClusterLinks() {
        .colon.colon linkNames = new .colon.colon((Object)"cluster-1", (List)new .colon.colon((Object)"cluster-2", (List)Nil$.MODULE$));
        this.createBasicClusterLinks((Iterable<String>)linkNames);
        this.assertClusterLinksEquals((Iterable<String>)linkNames);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testDeleteClusterLinksValidateOnly() {
        .colon.colon linkNames = new .colon.colon((Object)"cluster-1", (List)new .colon.colon((Object)"cluster-2", (List)Nil$.MODULE$));
        this.createBasicClusterLinks((Iterable<String>)linkNames);
        this.assertClusterLinksEquals((Iterable<String>)linkNames);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, true, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)linkNames);
    }

    @Test
    public void testDeleteClusterLinksNonexistent() {
        .colon.colon linkNames = new .colon.colon((Object)"cluster-nonexistent", (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.CLUSTER_LINK_NOT_FOUND), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testDeleteClusterLinksRepeat() {
        .colon.colon linkNames = new .colon.colon((Object)"cluster", (List)Nil$.MODULE$);
        this.createBasicClusterLinks((Iterable<String>)linkNames);
        this.assertClusterLinksEquals((Iterable<String>)linkNames);
        scala.collection.immutable.Map expectedResults1 = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results1 = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults1, results1);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults2 = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.CLUSTER_LINK_NOT_FOUND), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results2 = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults2, results2);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    @Test
    public void testDeleteClusterLinksEmptyName() {
        .colon.colon linkNames = new .colon.colon((Object)"", (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.INVALID_CLUSTER_LINK), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
    }

    @Test
    public void testDeleteClusterLinksInvalidName() {
        .colon.colon linkNames = new .colon.colon((Object)"cluster+1", (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.INVALID_CLUSTER_LINK), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
    }

    @Test
    public void testDeleteClusterLinksDuplicateName() {
        this.createBasicClusterLinks((Iterable<String>)new .colon.colon((Object)"cluster", (List)Nil$.MODULE$));
        this.assertClusterLinksEquals((Iterable<String>)new .colon.colon((Object)"cluster", (List)Nil$.MODULE$));
        .colon.colon linkNames = new .colon.colon((Object)"cluster", (List)new .colon.colon((Object)"cluster", (List)Nil$.MODULE$));
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)Errors.INVALID_REQUEST), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.deleteClusterLinks((Iterable<String>)linkNames, false, false, this.deleteClusterLinks$default$4(), this.deleteClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)new .colon.colon((Object)"cluster", (List)Nil$.MODULE$));
    }

    @Test
    public void testPauseClusterLinks() {
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink("cluster-link-1", (Option<String>)new Some((Object)"cluster-id-1"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)new .colon.colon((Object)this.newNewClusterLink("cluster-link-2", (Option<String>)new Some((Object)"cluster-id-2"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"10000")}))), this.newNewClusterLink$default$4()), (List)new .colon.colon((Object)this.newNewClusterLink("cluster-link-3", (Option<String>)new Some((Object)"cluster-id-3"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cluster.link.paused"), (Object)"true")}))), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$)));
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)((Iterable)newClusterLinks.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.linkName(), Seq$.MODULE$.canBuildFrom())));
        this.waitForLinkState$1("cluster-link-1", (LinkState)ActiveClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-2", (LinkState)ActiveClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-3", (LinkState)PausedClusterLink$.MODULE$);
        ConfluentAdmin admin = this.createAdminClient(this.createAdminClient$default$1());
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Set<AlterConfigOp>> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "cluster-link-2"), Collections.singleton(alterOp));
        admin.incrementalAlterConfigs(configs).all().get(15L, TimeUnit.SECONDS);
        admin.close();
        this.waitForLinkState$1("cluster-link-1", (LinkState)ActiveClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-2", (LinkState)PausedClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-3", (LinkState)PausedClusterLink$.MODULE$);
        this.killAllBrokers();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.waitForLinkState$1("cluster-link-1", (LinkState)ActiveClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-2", (LinkState)PausedClusterLink$.MODULE$);
        this.waitForLinkState$1("cluster-link-3", (LinkState)PausedClusterLink$.MODULE$);
    }

    @Test
    public void testDeleteClusterLinksWithRemote() {
        String topic = "mirror-topic";
        String linkName = "remote";
        ConfluentAdmin localAdmin = this.createAdminClient(this.createAdminClient$default$1());
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
        runWithRemoteCluster_remoteCluster.setUp();
        try {
            ConfluentAdmin runWithRemoteCluster_admin = runWithRemoteCluster_remoteCluster.createAdminClient(runWithRemoteCluster_remoteCluster.createAdminClient$default$1());
            String runWithRemoteCluster_clusterId = (String)runWithRemoteCluster_admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            ConfluentAdmin confluentAdmin = runWithRemoteCluster_admin;
            Option option = Option$.MODULE$.apply((Object)runWithRemoteCluster_clusterId);
            String string = runWithRemoteCluster_remoteCluster.brokerList();
            ClusterLinksRequestTest.$anonfun$testDeleteClusterLinksWithRemote$1(this, linkName, topic, localAdmin, string, option, confluentAdmin);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @Test
    public void testClusterLinksDisabledCombinations() {
        this.testClusterLinksDisabled(true);
        this.testClusterLinksDisabled(false);
    }

    private void testClusterLinksDisabled(boolean testCompatibility) {
        ((KafkaServer)this.servers().head()).shutdown();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        TestUtils.setFieldValue((Object)((KafkaServer)this.servers().head()).config(), (String)"clusterLinkEnable", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        ((KafkaServer)this.servers().head()).startup();
        Errors expectedError = testCompatibility ? Errors.CLUSTER_AUTHORIZATION_FAILED : Errors.CLUSTER_LINK_DISABLED;
        String linkName = "testLink";
        .colon.colon newClusterLinks = new .colon.colon((Object)this.newNewClusterLink(linkName, (Option<String>)new Some((Object)"cluster-id-1"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        short version = testCompatibility ? (short)0 : ApiKeys.CREATE_CLUSTER_LINKS.latestVersion();
        boolean x$2 = false;
        boolean x$3 = false;
        int x$5 = this.createClusterLinks$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)expectedError)})), this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, x$2, x$3, x$5, version));
        boolean x$7 = true;
        boolean x$8 = false;
        int x$10 = this.createClusterLinks$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)expectedError)})), this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, x$7, x$8, x$10, version));
        version = testCompatibility ? (short)0 : ApiKeys.DELETE_CLUSTER_LINKS.latestVersion();
        .colon.colon x$11 = new .colon.colon((Object)linkName, (List)Nil$.MODULE$);
        boolean x$12 = false;
        boolean x$13 = true;
        int x$15 = this.deleteClusterLinks$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)expectedError)})), this.deleteClusterLinks((Iterable<String>)x$11, x$12, x$13, x$15, version));
        .colon.colon x$16 = new .colon.colon((Object)linkName, (List)Nil$.MODULE$);
        boolean x$17 = true;
        boolean x$18 = true;
        int x$20 = this.deleteClusterLinks$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)expectedError)})), this.deleteClusterLinks((Iterable<String>)x$16, x$17, x$18, x$20, version));
        version = testCompatibility ? (short)0 : ApiKeys.LIST_CLUSTER_LINKS.latestVersion();
        Option<scala.collection.immutable.Set<String>> x$22 = this.listClusterLinks$default$1();
        boolean x$23 = this.listClusterLinks$default$2();
        int x$24 = this.listClusterLinks$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)expectedError), this.listClusterLinks(x$22, x$23, x$24, version));
        String topicName = "testTopic";
        version = testCompatibility ? (short)0 : ApiKeys.ALTER_MIRRORS.latestVersion();
        AlterMirrorOp x$26 = AlterMirrorOp.PROMOTE;
        boolean x$28 = this.alterMirror$default$3();
        int x$29 = this.alterMirror$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)expectedError)})), this.alterMirror(topicName, x$26, x$28, x$29, version));
        AlterMirrorOp x$31 = AlterMirrorOp.PROMOTE;
        boolean x$32 = true;
        int x$34 = this.alterMirror$default$4();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)expectedError)})), this.alterMirror(topicName, x$31, x$32, x$34, version));
        version = testCompatibility ? (short)0 : ApiKeys.LIST_MIRRORS.latestVersion();
        boolean x$37 = this.listMirrors$default$2();
        int x$38 = this.listMirrors$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)expectedError), this.listMirrors(linkName, x$37, x$38, version));
        boolean x$40 = true;
        int x$42 = this.listMirrors$default$3();
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)expectedError), this.listMirrors(linkName, x$40, x$42, version));
        version = testCompatibility ? (short)0 : ApiKeys.DESCRIBE_MIRRORS.latestVersion();
        .colon.colon x$43 = new .colon.colon((Object)topicName, (List)Nil$.MODULE$);
        int x$45 = this.describeMirrors$default$2();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)expectedError)})), this.describeMirrors((List<String>)x$43, x$45, version));
        .colon.colon x$46 = new .colon.colon((Object)linkName, (List)Nil$.MODULE$);
        int x$48 = this.describeMirrors$default$2();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)expectedError)})), this.describeMirrors((List<String>)x$46, x$48, version));
    }

    private void runWithRemoteCluster(Function3<String, Option<String>, ConfluentAdmin, BoxedUnit> callback) {
        IntegrationTestHarness remoteCluster = new /* invalid duplicate definition of identical inner class */;
        remoteCluster.setUp();
        try {
            ConfluentAdmin admin = remoteCluster.createAdminClient(remoteCluster.createAdminClient$default$1());
            String clusterId = (String)admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).clusterId().get();
            callback.apply((Object)remoteCluster.brokerList(), (Object)Option$.MODULE$.apply((Object)clusterId), (Object)admin);
        }
        finally {
            remoteCluster.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertClusterLinksEquals(Iterable<String> linkNames) {
        void var4_4;
        void var3_3;
        Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> tuple2 = this.listClusterLinks(this.listClusterLinks$default$1(), this.listClusterLinks$default$2(), this.listClusterLinks$default$3(), this.listClusterLinks$default$4());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set clusterLinks = (scala.collection.immutable.Set)tuple2._1();
        Errors error = (Errors)tuple2._2();
        void clusterLinks2 = var3_3;
        void error2 = var4_4;
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2);
        Assertions.assertEquals((Object)linkNames.toSet(), (Object)clusterLinks2.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.linkName(), Set$.MODULE$.canBuildFrom()));
    }

    private void createLinkedTopic(ConfluentAdmin admin, String topic, Option<String> linkName) {
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.empty());
        linkName.foreach((Function1 & Serializable & scala.Serializable)ln -> newTopic.mirror(Optional.of(new NewMirrorTopic(ln, topic))));
        admin.createTopics(Collections.singleton(newTopic)).all().get();
    }

    private NewClusterLink newNewClusterLink(String linkName, Option<String> clusterId, scala.collection.immutable.Map<String, String> configs, String bootstrapServers) {
        return new NewClusterLink(linkName, (String)clusterId.orNull(Predef$.MODULE$.$conforms()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)configs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers))).asJava());
    }

    private String newNewClusterLink$default$4() {
        return "localhost:12345";
    }

    private void createBasicClusterLinks(Iterable<String> linkNames) {
        Iterable newClusterLinks = (Iterable)linkNames.map((Function1 & Serializable & scala.Serializable)name -> this.newNewClusterLink((String)name, (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.newNewClusterLink$default$4()), Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.NONE), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
    }

    private scala.collection.immutable.Map<String, Errors> createClusterLinks(Iterable<NewClusterLink> newClusterLinks, boolean validateOnly, boolean validateLink, int timeoutMs, short requestVersion) {
        java.util.Map tmpResults = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)newClusterLinks.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)new KafkaFutureImpl()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.sendCreateClusterLinksRequest(newClusterLinks, validateOnly, validateLink, timeoutMs, requestVersion).complete(tmpResults);
        return ((TraversableOnce)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tmpResults).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            String linkName;
            if (x0$1 != null) {
                linkName = (String)x0$1._1();
                KafkaFutureImpl future = (KafkaFutureImpl)x0$1._2();
                Assertions.assertTrue((boolean)newClusterLinks.exists((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$createClusterLinks$3(linkName, x$20))));
                try {
                    future.get();
                    errors = Errors.NONE;
                }
                catch (ExecutionException executionException) {
                    errors = Errors.forException((Throwable)executionException.getCause());
                }
            } else {
                throw new MatchError(null);
            }
            Errors error = errors;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)error);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private int createClusterLinks$default$4() {
        return 2000;
    }

    private short createClusterLinks$default$5() {
        return ApiKeys.CREATE_CLUSTER_LINKS.latestVersion();
    }

    private CreateClusterLinksResponse sendCreateClusterLinksRequest(Iterable<NewClusterLink> newClusterLinks, boolean validateOnly, boolean validateLink, int timeoutMs, short requestVersion) {
        CreateClusterLinksRequest request = new CreateClusterLinksRequest.Builder(CollectionConverters$.MODULE$.asJavaCollectionConverter(newClusterLinks).asJavaCollection(), validateOnly, validateLink, timeoutMs).build(requestVersion);
        return (CreateClusterLinksResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(CreateClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> listClusterLinks(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics, int timeoutMs, short requestVersion) {
        KafkaFutureImpl tmpResults = new KafkaFutureImpl();
        this.sendListClusterLinksRequest(linkNames, includeTopics, timeoutMs, requestVersion).complete(tmpResults);
        try {
            return new Tuple2((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)tmpResults.get()).asScala()).toSet(), (Object)Errors.NONE);
        }
        catch (ExecutionException e) {
            return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)Errors.forException((Throwable)e.getCause()));
        }
    }

    private Option<scala.collection.immutable.Set<String>> listClusterLinks$default$1() {
        return None$.MODULE$;
    }

    private boolean listClusterLinks$default$2() {
        return false;
    }

    private int listClusterLinks$default$3() {
        return 2000;
    }

    private short listClusterLinks$default$4() {
        return ApiKeys.LIST_CLUSTER_LINKS.latestVersion();
    }

    private ListClusterLinksResponse sendListClusterLinksRequest(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics, int timeoutMs, short requestVersion) {
        Optional javaLinkNames = (Optional)linkNames.map((Function1 & Serializable & scala.Serializable)ln -> Optional.of(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)ln).asJavaCollection())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Optional.empty());
        ListClusterLinksRequest request = new ListClusterLinksRequest.Builder(javaLinkNames, includeTopics, timeoutMs).build(requestVersion);
        return (ListClusterLinksResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private scala.collection.immutable.Map<String, Errors> deleteClusterLinks(Iterable<String> linkNames, boolean validateOnly, boolean force, int timeoutMs, short requestVersion) {
        java.util.Map tmpResults = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)linkNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)new KafkaFutureImpl()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.sendDeleteClusterLinksRequest(linkNames, validateOnly, force, timeoutMs, requestVersion).complete(tmpResults);
        return ((TraversableOnce)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tmpResults).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            String linkName;
            if (x0$1 != null) {
                linkName = (String)x0$1._1();
                KafkaFutureImpl future = (KafkaFutureImpl)x0$1._2();
                Assertions.assertTrue((boolean)linkNames.find((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$deleteClusterLinks$3(linkName, x$21))).isDefined());
                try {
                    future.get();
                    errors = Errors.NONE;
                }
                catch (ExecutionException executionException) {
                    errors = Errors.forException((Throwable)executionException.getCause());
                }
            } else {
                throw new MatchError(null);
            }
            Errors error = errors;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), (Object)error);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private int deleteClusterLinks$default$4() {
        return 2000;
    }

    private short deleteClusterLinks$default$5() {
        return ApiKeys.DELETE_CLUSTER_LINKS.latestVersion();
    }

    private DeleteClusterLinksResponse sendDeleteClusterLinksRequest(Iterable<String> linkNames, boolean validateOnly, boolean force, int timeoutMs, short requestVersion) {
        DeleteClusterLinksRequest request = new DeleteClusterLinksRequest.Builder(CollectionConverters$.MODULE$.asJavaCollectionConverter(linkNames).asJavaCollection(), validateOnly, force, timeoutMs).build(requestVersion);
        return (DeleteClusterLinksResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private scala.collection.immutable.Map<String, Errors> alterMirror(String topic, AlterMirrorOp op, boolean validateOnly, int timeoutMs, short requestVersion) {
        AlterMirrorsRequestData.MirrorOperation mirrorOp = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
        return this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)mirrorOp, (List)Nil$.MODULE$), validateOnly, timeoutMs, requestVersion);
    }

    private boolean alterMirror$default$3() {
        return false;
    }

    private int alterMirror$default$4() {
        return 5000;
    }

    private scala.collection.immutable.Map<String, Errors> alterMirrors(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs, short requestVersion) {
        LinkedHashMap tmpResults = new LinkedHashMap();
        ops.foreach((Function1 & Serializable & scala.Serializable)op -> tmpResults.put(op.topic(), new KafkaFutureImpl()));
        this.sendAlterMirrorsRequest(ops, validateOnly, timeoutMs, requestVersion).complete(tmpResults);
        Assertions.assertEquals((int)ops.size(), (int)tmpResults.size());
        return ((TraversableOnce)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tmpResults).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            String topic;
            if (x0$1 != null) {
                topic = (String)x0$1._1();
                KafkaFutureImpl future = (KafkaFutureImpl)x0$1._2();
                Assertions.assertTrue((boolean)ops.exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$alterMirrors$3(topic, x$22))));
                try {
                    future.get();
                    errors = Errors.NONE;
                }
                catch (ExecutionException executionException) {
                    errors = Errors.forException((Throwable)executionException.getCause());
                }
            } else {
                throw new MatchError(null);
            }
            Errors error = errors;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)error);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private AlterMirrorsResponse sendAlterMirrorsRequest(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs, short requestVersion) {
        AlterMirrorsRequest request = new AlterMirrorsRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ops).asJava(), validateOnly, timeoutMs).build(requestVersion);
        return (AlterMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Tuple2<scala.collection.immutable.Set<String>, Errors> listMirrors(String linkName, boolean includeStopped, int timeoutMs, short requestVersion) {
        KafkaFutureImpl tmpResults = new KafkaFutureImpl();
        this.sendListMirrorsRequest(linkName, includeStopped, timeoutMs, requestVersion).complete(tmpResults);
        try {
            return new Tuple2((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)tmpResults.get()).asScala()).toSet(), (Object)Errors.NONE);
        }
        catch (ExecutionException e) {
            return new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)Errors.forException((Throwable)e.getCause()));
        }
    }

    private boolean listMirrors$default$2() {
        return false;
    }

    private int listMirrors$default$3() {
        return 2000;
    }

    private ListMirrorsResponse sendListMirrorsRequest(String linkName, boolean includeStopped, int timeoutMs, short requestVersion) {
        Optional<String> javaLinkName = Optional.of(linkName);
        ListMirrorsRequest request = new ListMirrorsRequest.Builder(javaLinkName, includeStopped, timeoutMs).build(requestVersion);
        return (ListMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private scala.collection.immutable.Map<String, Errors> describeMirrors(List<String> topicNames, int timeoutMs, short requestVersion) {
        java.util.Map tmpResults = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicNames.map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)new KafkaFutureImpl()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.sendDescribeMirrorsRequest(topicNames, timeoutMs, requestVersion).complete(tmpResults);
        return ((TraversableOnce)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tmpResults).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            String topicName;
            if (x0$1 != null) {
                topicName = (String)x0$1._1();
                KafkaFutureImpl future = (KafkaFutureImpl)x0$1._2();
                Assertions.assertTrue((boolean)topicNames.find((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$describeMirrors$3(topicName, x$23))).isDefined());
                try {
                    future.get();
                    errors = Errors.NONE;
                }
                catch (ExecutionException executionException) {
                    errors = Errors.forException((Throwable)executionException.getCause());
                }
            } else {
                throw new MatchError(null);
            }
            Errors error = errors;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)error);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private int describeMirrors$default$2() {
        return 5000;
    }

    private DescribeMirrorsResponse sendDescribeMirrorsRequest(List<String> topicNames, int timeoutMs, short requestVersion) {
        DescribeMirrorsRequest request = new DescribeMirrorsRequest.Builder(CollectionConverters$.MODULE$.asJavaCollectionConverter(topicNames).asJavaCollection(), timeoutMs).build(requestVersion);
        return (DescribeMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterLinksWithRemote$1(ClusterLinksRequestTest $this, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin x$2) {
        .colon.colon newClusterLinks = new .colon.colon((Object)$this.newNewClusterLink("cluster-1", (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), remoteBootstrapServers), (List)new .colon.colon((Object)$this.newNewClusterLink("cluster-2", (Option<String>)remoteClusterId, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), remoteBootstrapServers), (List)new .colon.colon((Object)$this.newNewClusterLink("cluster-3", (Option<String>)new Some((Object)"bad"), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), remoteBootstrapServers), (List)Nil$.MODULE$)));
        scala.collection.immutable.Map expectedResults = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cluster-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cluster-2"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cluster-3"), (Object)Errors.INVALID_REQUEST)}));
        scala.collection.immutable.Map<String, Errors> results = $this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, true, $this.createClusterLinks$default$4(), $this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        $this.assertClusterLinksEquals((Iterable<String>)new .colon.colon((Object)"cluster-1", (List)new .colon.colon((Object)"cluster-2", (List)Nil$.MODULE$)));
    }

    private final void verifyCreateClusterLink$1(scala.collection.immutable.Map props) {
        .colon.colon newClusterLink = new .colon.colon((Object)this.newNewClusterLink("testlink1", (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)props, this.newNewClusterLink$default$4()), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedResults = ((TraversableOnce)newClusterLink.map((Function1 & Serializable & scala.Serializable)ncl -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ncl.linkName()), (Object)Errors.INVALID_CONFIG), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map<String, Errors> results = this.createClusterLinks((Iterable<NewClusterLink>)newClusterLink, false, false, this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedResults, results);
        this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterLinkInvalidClientProps$1(ClusterLinksRequestTest $this, String linkName$1, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin x$3) {
        scala.collection.immutable.Map invalidLinkProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default.api.timeout.ms"), (Object)"2000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"20000")}));
        .colon.colon invalidClusterLinks = new .colon.colon((Object)$this.newNewClusterLink(linkName$1, (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)invalidLinkProps, remoteBootstrapServers), (List)Nil$.MODULE$);
        scala.collection.immutable.Map<String, Errors> invalidResults = $this.createClusterLinks((Iterable<NewClusterLink>)invalidClusterLinks, false, true, $this.createClusterLinks$default$4(), $this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$1), (Object)Errors.INVALID_CONFIG)})), invalidResults);
        $this.assertClusterLinksEquals((Iterable<String>)Nil$.MODULE$);
        scala.collection.immutable.Map goodLinkProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default.api.timeout.ms"), (Object)"20000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"20000")}));
        .colon.colon goodClusterLinks = new .colon.colon((Object)$this.newNewClusterLink(linkName$1, (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)goodLinkProps, remoteBootstrapServers), (List)Nil$.MODULE$);
        scala.collection.immutable.Map<String, Errors> goodResults = $this.createClusterLinks((Iterable<NewClusterLink>)goodClusterLinks, false, true, $this.createClusterLinks$default$4(), $this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$1), (Object)Errors.NONE)})), goodResults);
        $this.assertClusterLinksEquals((Iterable<String>)new .colon.colon((Object)linkName$1, (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testListClusterLinks$2(ClusterLinkListing x$10) {
        return x$10.topics().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testListClusterLinks$4(ClusterLinkListing x$13) {
        return x$13.topics().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testListClusterLinksWithTopics$2(ClusterLinksRequestTest $this, ConfluentAdmin remoteAdmin$1, ConfluentAdmin localAdmin$1, String linkName$2, String topic) {
        $this.createLinkedTopic(remoteAdmin$1, topic, (Option<String>)None$.MODULE$);
        $this.createLinkedTopic(localAdmin$1, topic, (Option<String>)new Some((Object)linkName$2));
    }

    public static final /* synthetic */ void $anonfun$testListClusterLinksWithTopics$1(ClusterLinksRequestTest $this, String linkName$2, scala.collection.immutable.Set topics$1, ConfluentAdmin localAdmin$1, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        .colon.colon newClusterLinks = new .colon.colon((Object)$this.newNewClusterLink(linkName$2, (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), remoteBootstrapServers), (List)Nil$.MODULE$);
        scala.collection.immutable.Map expectedCreateResults = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$2), (Object)Errors.NONE)}));
        scala.collection.immutable.Map<String, Errors> createResults = $this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, true, $this.createClusterLinks$default$4(), $this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)expectedCreateResults, createResults);
        $this.assertClusterLinksEquals((Iterable<String>)new .colon.colon((Object)linkName$2, (List)Nil$.MODULE$));
        topics$1.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ClusterLinksRequestTest.$anonfun$testListClusterLinksWithTopics$2($this, remoteAdmin, localAdmin$1, linkName$2, topic);
            return BoxedUnit.UNIT;
        });
        ApiKeys.LIST_CLUSTER_LINKS.allVersions().forEach(version -> {
            void var10_10;
            void var9_9;
            Some x$1 = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{linkName$2})));
            boolean x$2 = true;
            short x$3 = Predef$.MODULE$.Short2short(version);
            int x$4 = $this.listClusterLinks$default$3();
            Tuple2<scala.collection.immutable.Set<ClusterLinkListing>, Errors> tuple2 = $this.listClusterLinks((Option<scala.collection.immutable.Set<String>>)x$1, x$2, x$4, x$3);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            scala.collection.immutable.Set results = (scala.collection.immutable.Set)tuple2._1();
            Errors error = (Errors)tuple2._2();
            void results2 = var9_9;
            void error2 = var10_10;
            Assertions.assertEquals((Object)Errors.NONE, (Object)error2);
            Assertions.assertEquals((int)results2.size(), (int)1);
            ClusterLinkListing result = (ClusterLinkListing)results2.head();
            Assertions.assertEquals((Object)linkName$2, (Object)result.linkName());
            Assertions.assertTrue((boolean)result.topics().isPresent());
            Assertions.assertEquals((Object)topics$1, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)result.topics().get()).asScala()).toSet());
            if (Predef$.MODULE$.Short2short(version) >= 1) {
                Assertions.assertEquals((Object)((KafkaServer)$this.servers().head()).clusterId(), (Object)result.localClusterId());
            }
            if (Predef$.MODULE$.Short2short(version) >= 2) {
                Assertions.assertTrue((boolean)result.available());
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLinks$4(LinkState expectedState$1, LinkState x$17) {
        LinkState linkState = x$17;
        return !(linkState != null ? !linkState.equals(expectedState$1) : expectedState$1 != null);
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForLinkState$1(String name, LinkState expectedState) {
        void var4_10;
        Tuple2 tuple2;
        ClusterLinkManager clusterLinkManager = (ClusterLinkManager)((KafkaBroker)this.servers().head()).clusterLinkManager();
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            LinkState computeUntilTrue_result;
            LinkState linkState;
            if (ClusterLinksRequestTest.$anonfun$testPauseClusterLinks$4(expectedState, linkState = (computeUntilTrue_result = clusterLinkManager.linkState(name)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        LinkState state = (LinkState)tuple2._1();
        Assertions.assertEquals((Object)expectedState, (Object)var4_10);
    }

    public static final /* synthetic */ void $anonfun$testDeleteClusterLinksWithRemote$1(ClusterLinksRequestTest $this, String linkName$3, String topic$1, ConfluentAdmin localAdmin$2, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        .colon.colon newClusterLinks = new .colon.colon((Object)$this.newNewClusterLink(linkName$3, (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), remoteBootstrapServers), (List)Nil$.MODULE$);
        scala.collection.immutable.Map<String, Errors> results = $this.createClusterLinks((Iterable<NewClusterLink>)newClusterLinks, false, true, $this.createClusterLinks$default$4(), $this.createClusterLinks$default$5());
        Assertions.assertEquals((Object)new Some((Object)Errors.NONE), (Object)results.get((Object)linkName$3));
        $this.createLinkedTopic(remoteAdmin, topic$1, (Option<String>)None$.MODULE$);
        $this.createLinkedTopic(localAdmin$2, topic$1, (Option<String>)new Some((Object)linkName$3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$3), (Object)Errors.CLUSTER_LINK_IN_USE)})), $this.deleteClusterLinks((Iterable<String>)new .colon.colon((Object)linkName$3, (List)Nil$.MODULE$), true, false, $this.deleteClusterLinks$default$4(), $this.deleteClusterLinks$default$5()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$3), (Object)Errors.NONE)})), $this.deleteClusterLinks((Iterable<String>)new .colon.colon((Object)linkName$3, (List)Nil$.MODULE$), true, true, $this.deleteClusterLinks$default$4(), $this.deleteClusterLinks$default$5()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$3), (Object)Errors.CLUSTER_LINK_IN_USE)})), $this.deleteClusterLinks((Iterable<String>)new .colon.colon((Object)linkName$3, (List)Nil$.MODULE$), false, false, $this.deleteClusterLinks$default$4(), $this.deleteClusterLinks$default$5()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$3), (Object)Errors.NONE)})), $this.deleteClusterLinks((Iterable<String>)new .colon.colon((Object)linkName$3, (List)Nil$.MODULE$), false, true, $this.deleteClusterLinks$default$4(), $this.deleteClusterLinks$default$5()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName$3), (Object)Errors.CLUSTER_LINK_NOT_FOUND)})), $this.deleteClusterLinks((Iterable<String>)new .colon.colon((Object)linkName$3, (List)Nil$.MODULE$), true, true, $this.deleteClusterLinks$default$4(), $this.deleteClusterLinks$default$5()));
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLinks$3(String linkName$4, NewClusterLink x$20) {
        String string = x$20.linkName();
        return !(string != null ? !string.equals(linkName$4) : linkName$4 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteClusterLinks$3(String linkName$5, String x$21) {
        String string = x$21;
        return !(string != null ? !string.equals(linkName$5) : linkName$5 != null);
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrors$3(String topic$3, AlterMirrorsRequestData.MirrorOperation x$22) {
        String string = x$22.topic();
        return !(string != null ? !string.equals(topic$3) : topic$3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$describeMirrors$3(String topicName$1, String x$23) {
        String string = x$23;
        return !(string != null ? !string.equals(topicName$1) : topicName$1 != null);
    }

    public static final /* synthetic */ Object $anonfun$testCreateClusterLinksWithRemote$1$adapted(ClusterLinksRequestTest $this, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin x$2) {
        ClusterLinksRequestTest.$anonfun$testCreateClusterLinksWithRemote$1($this, remoteBootstrapServers, remoteClusterId, x$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateClusterLinkInvalidClientProps$1$adapted(ClusterLinksRequestTest $this, String linkName$1, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin x$3) {
        ClusterLinksRequestTest.$anonfun$testCreateClusterLinkInvalidClientProps$1($this, linkName$1, remoteBootstrapServers, remoteClusterId, x$3);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testListClusterLinksWithTopics$1$adapted(ClusterLinksRequestTest $this, String linkName$2, scala.collection.immutable.Set topics$1, ConfluentAdmin localAdmin$1, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        ClusterLinksRequestTest.$anonfun$testListClusterLinksWithTopics$1($this, linkName$2, topics$1, localAdmin$1, remoteBootstrapServers, remoteClusterId, remoteAdmin);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteClusterLinksWithRemote$1$adapted(ClusterLinksRequestTest $this, String linkName$3, String topic$1, ConfluentAdmin localAdmin$2, String remoteBootstrapServers, Option remoteClusterId, ConfluentAdmin remoteAdmin) {
        ClusterLinksRequestTest.$anonfun$testDeleteClusterLinksWithRemote$1($this, linkName$3, topic$1, localAdmin$2, remoteBootstrapServers, remoteClusterId, remoteAdmin);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPauseClusterLinks$4$adapted(LinkState expectedState$1, LinkState x$17) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinksRequestTest.$anonfun$testPauseClusterLinks$4(expectedState$1, x$17));
    }
}

