/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.ConfluentBrokerPlacementConstraintTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\f\u0018\u0005qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001A\u0002\u0013\u0005\u0001\u0006C\u00045\u0001\u0001\u0007I\u0011A\u001b\t\rq\u0002\u0001\u0015)\u0003*\u0011\u001di\u0004A1A\u0005\u0002yBaA\u0011\u0001!\u0002\u0013y\u0004bB\"\u0001\u0005\u0004%\tA\u0010\u0005\u0007\t\u0002\u0001\u000b\u0011B \t\u000f\u0015\u0003!\u0019!C\u0001\r\"1q\n\u0001Q\u0001\n\u001dCQ\u0001\u0015\u0001\u0005BECQa\u0018\u0001\u0005BECQ\u0001\u001a\u0001\u0005\u0002ECQ!\u001b\u0001\u0005\u0002ECQa\u001b\u0001\u0005\u0002ECQ!\u001c\u0001\u0005\u0002E;Qa\\\f\t\u0002A4QAF\f\t\u0002EDQa\t\n\u0005\u0002UDQA\u001e\n\u0005\u0002]Dq!a\u0005\u0013\t\u0003\t)B\u0001\u0014D_:4G.^3oi\n\u0013xn[3s!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e+fgRT!\u0001G\r\u0002\rM,'O^3s\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\r\u0002\u0005i\\\u0017B\u0001\u0012 \u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aF\u0001\bg\u0016\u0014h/\u001a:t+\u0005I\u0003c\u0001\u00160c5\t1F\u0003\u0002-[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0016\u0003\u0007M+\u0017\u000f\u0005\u0002'e%\u00111g\u0006\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHC\u0001\u001c;!\t9\u0004(D\u0001.\u0013\tITF\u0001\u0003V]&$\bbB\u001e\u0004\u0003\u0003\u0005\r!K\u0001\u0004q\u0012\n\u0014\u0001C:feZ,'o\u001d\u0011\u0002\u000f\t\u0014xn[3scU\tq\b\u0005\u00028\u0001&\u0011\u0011)\f\u0002\u0004\u0013:$\u0018\u0001\u00032s_.,'/\r\u0011\u0002\u000f\t\u0014xn[3se\u0005A!M]8lKJ\u0014\u0004%A\u000bce>\\WM]\"p]N$(/Y5oiZ\u000bG.^3\u0016\u0003\u001d\u0003\"\u0001S'\u000e\u0003%S!AS&\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0015J\u0001\u0004TiJLgnZ\u0001\u0017EJ|7.\u001a:D_:\u001cHO]1j]R4\u0016\r\\;fA\u0005)1/\u001a;VaR\ta\u0007\u000b\u0002\f'B\u0011A+X\u0007\u0002+*\u0011akV\u0001\u0004CBL'B\u0001-Z\u0003\u001dQW\u000f]5uKJT!AW.\u0002\u000b),h.\u001b;\u000b\u0003q\u000b1a\u001c:h\u0013\tqVK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0019\u0005\u0004\"\u0001\u00162\n\u0005\r,&!C!gi\u0016\u0014X)Y2i\u0003}!Xm\u001d;De\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0005J|7.\u001a:WC2,Xm\u001d\u0015\u0003\u001b\u0019\u0004\"\u0001V4\n\u0005!,&\u0001\u0002+fgR\fa\u0004^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY(wKJ\u0014\u0018\u000eZ3EK\u001a\fW\u000f\u001c;)\u000591\u0017!\f;fgR$U\r\\3uS:<Gk\u001c9jG\u000e{gNZ5h\t>,7OT8u%\u00164XM\u001d;U_\u0012+g-Y;mi\"\u0012qBZ\u0001\u001ei\u0016\u001cHOV1mS\u0012\fG/Z\"p]N$(/Y5oi\u0012+g-Y;mi\"\u0012\u0001CZ\u0001'\u0007>tg\r\\;f]R\u0014%o\\6feBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;UKN$\bC\u0001\u0014\u0013'\t\u0011\"\u000f\u0005\u00028g&\u0011A/\f\u0002\u0007\u0003:L(+\u001a4\u0015\u0003A\fAb\u0019:fCR,7i\u001c8gS\u001e$2\u0001_A\t!\u001dI\u0018\u0011AA\u0004\u0003\u0017q!A\u001f@\u0011\u0005mlS\"\u0001?\u000b\u0005u\\\u0012A\u0002\u001fs_>$h(\u0003\u0002\u0000[\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t\u0019Q*\u00199\u000b\u0005}l\u0003cA=\u0002\n%\u0019a*!\u0002\u0011\u0007!\u000bi!C\u0002\u0002\u0010%\u0013aa\u00142kK\u000e$\b\"B\u0014\u0015\u0001\u0004I\u0013\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t)\u0011\t9!a\u0006\t\u000b\u001d*\u0002\u0019A\u0015")
public final class ConfluentBrokerPlacementConstraintTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int broker1;
    private final int broker2;
    private final String brokerConstraintValue;

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public String brokerConstraintValue() {
        return this.brokerConstraintValue;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)rack.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.TopicPlacementConstraintsProp(), this.brokerConstraintValue());
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicWithBrokerValues() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicOverrideDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingTopicConfigDoesNotRevertToDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateConstraintDefault() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicWithBrokerValues$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicOverrideDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        String overrideConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}]}";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)overrideConstraintValue)}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertNotEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
        Assertions.assertEquals((Object)overrideConstraintValue, (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        AlterConfigOp operation = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ""), AlterConfigOp.OpType.DELETE);
        client.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)operation, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)Defaults$.MODULE$.TopicPlacementConstraints(), (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testValidateConstraintDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        CreateTopicsOptions option = new CreateTopicsOptions().validateOnly(true);
        ConfigEntry constraint = ((Config)client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava(), option).config(topic).get()).get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public ConfluentBrokerPlacementConstraintTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.brokerConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}]}";
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicWithBrokerValues$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicOverrideDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1$adapted(AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateConstraintDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1($this, client);
        return BoxedUnit.UNIT;
    }
}

