/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-d\u0001\u0002*T\u0005aCQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001A\u0002\u0013\u0005A\rC\u0004q\u0001\u0001\u0007I\u0011A9\t\ra\u0004\u0001\u0015)\u0003f\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\bbB@\u0001\u0005\u0004%\tA\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003|\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003Q\bbBA\u0003\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u000f\u0001!\u0019!C\u0001u\"9\u0011\u0011\u0002\u0001!\u0002\u0013Y\b\u0002CA\u0006\u0001\t\u0007I\u0011\u0001>\t\u000f\u00055\u0001\u0001)A\u0005w\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0017\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003o\u0001A\u0011AA\t\u0011\u001d\t\t\u0005\u0001C\u0001\u0003#Aq!!\u0012\u0001\t\u0003\t\t\u0002C\u0004\u0002J\u0001!\t!!\u0005\t\u000f\u00055\u0003\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005E\u0001bBA+\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u00033\u0002A\u0011AA\t\u0011\u001d\ti\u0006\u0001C\u0001\u0003#Aq!!\u0019\u0001\t\u0003\t\t\u0002C\u0004\u0002f\u0001!\t!!\u0005\t\u000f\u0005%\u0004\u0001\"\u0001\u0002\u0012!9\u0011Q\u000e\u0001\u0005\u0002\u0005E\u0001bBA9\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003k\u0002A\u0011AA\t\u0011\u001d\tI\b\u0001C\u0001\u0003#Aq!! \u0001\t\u0013\ty\bC\u0004\u00026\u0002!\t!!\u0005\t\u000f\u0005e\u0006\u0001\"\u0001\u0002\u0012!9\u0011Q\u0018\u0001\u0005\u0002\u0005E\u0001bBAa\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u000b\u0004A\u0011AA\t\u0011\u001d\tI\r\u0001C\u0001\u0003#Aq!!4\u0001\t\u0003\t\t\u0002C\u0004\u0002R\u0002!\t!!\u0005\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005E\u0001bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011%\u0011\t\u0002AI\u0001\n\u0013\u0011\u0019bB\u0004\u0003*MC\tAa\u000b\u0007\rI\u001b\u0006\u0012\u0001B\u0017\u0011\u0019y\u0006\u0007\"\u0001\u00036\u00191!q\u0007\u0019A\u0005sA\u0011Ba\u00123\u0005+\u0007I\u0011\u0001>\t\u0013\t%#G!E!\u0002\u0013Y\bB\u0003B&e\tU\r\u0011\"\u0001\u0003N!Q!q\n\u001a\u0003\u0012\u0003\u0006I!a(\t\r}\u0013D\u0011\u0001B)\u0011%\u0011YFMA\u0001\n\u0003\u0011i\u0006C\u0005\u0003dI\n\n\u0011\"\u0001\u0003f!I!\u0011\u000e\u001a\u0012\u0002\u0013\u0005!1\u000e\u0005\n\u0005_\u0012\u0014\u0011!C!\u0005cB\u0001B!!3\u0003\u0003%\tA\u001f\u0005\n\u0005\u0007\u0013\u0014\u0011!C\u0001\u0005\u000bC\u0011Ba$3\u0003\u0003%\tE!%\t\u0013\te%'!A\u0005\u0002\tm\u0005\"\u0003BSe\u0005\u0005I\u0011\tBT\u0011%\u0011IKMA\u0001\n\u0003\u0012Y\u000bC\u0005\u0003.J\n\t\u0011\"\u0011\u00030\u001eI!1\u0017\u0019\u0002\u0002#\u0005!Q\u0017\u0004\n\u0005o\u0001\u0014\u0011!E\u0001\u0005oCaa\u0018#\u0005\u0002\t\u0015\u0007\"\u0003BU\t\u0006\u0005IQ\tBV\u0011%\u00119\rRA\u0001\n\u0003\u0013I\rC\u0005\u0003P\u0012\u000b\t\u0011\"!\u0003R\"I!1\u001d#\u0002\u0002\u0013%!Q\u001d\u0005\t\u0005[\u0004D\u0011A*\u0003p\"91Q\u0002\u0019\u0005\u0002\r=\u0001bBB\ra\u0011\u000511\u0004\u0005\b\u0007g\u0001D\u0011AB\u001b\u0011\u001d\u0019I\u0004\rC\u0001\u0007wAqaa\u00131\t\u0003\u0019i\u0005C\u0004\u0004RA\"\taa\u0015\t\u000f\r}\u0003\u0007\"\u0001\u0004b\t)2i\u001c8gYV,g\u000e^(cg\u0016\u0014h/\u001a:UKN$(B\u0001+V\u0003\u0019\u0019XM\u001d<fe*\ta+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0006C\u0001.^\u001b\u0005Y&B\u0001/V\u0003\tQ8.\u0003\u0002_7\n!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A1\u0011\u0005\t\u0004Q\"A*\u0002\u000fM,'O^3sgV\tQ\rE\u0002gW6l\u0011a\u001a\u0006\u0003Q&\f!bY8mY\u0016\u001cG/[8o\u0015\u0005Q\u0017!B:dC2\f\u0017B\u00017h\u0005\r\u0019V-\u001d\t\u0003E:L!a\\*\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002smB\u00111\u000f^\u0007\u0002S&\u0011Q/\u001b\u0002\u0005+:LG\u000fC\u0004x\u0007\u0005\u0005\t\u0019A3\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u001d\u0011'o\\6feF*\u0012a\u001f\t\u0003grL!!`5\u0003\u0007%sG/\u0001\u0005ce>\\WM]\u0019!\u0003\u001d\u0011'o\\6feJ\n\u0001B\u0019:pW\u0016\u0014(\u0007I\u0001\bEJ|7.\u001a:4\u0003!\u0011'o\\6feN\u0002\u0013a\u00022s_.,'\u000fN\u0001\tEJ|7.\u001a:5A\u00059!M]8lKJ,\u0014\u0001\u00032s_.,'/\u000e\u0011\u0002\u000bM,G/\u00169\u0015\u0003ID3aDA\u000b!\u0011\t9\"!\u000b\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t1!\u00199j\u0015\u0011\ty\"!\t\u0002\u000f),\b/\u001b;fe*!\u00111EA\u0013\u0003\u0015QWO\\5u\u0015\t\t9#A\u0002pe\u001eLA!a\u000b\u0002\u001a\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3\u0001EA\u0019!\u0011\t9\"a\r\n\t\u0005U\u0012\u0011\u0004\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0004^3ti>\u00137/\u001a:wKJ\u001c8\u000b[8vY\u0012tu\u000e\u001e&pS:L5O\u001d\u0015\u0004#\u0005m\u0002\u0003BA\f\u0003{IA!a\u0010\u0002\u001a\t!A+Z:u\u0003Q!Xm\u001d;PEN,'O^3s\u000b2,7\r^5p]\"\u001a!#a\u000f\u0002\u007fQ,7\u000f^(cg\u0016\u0014h/\u001a:FY\u0016\u001cG/[8o/&$\b\u000eT3bI\u0016\u0014\u0018j](cg\u0016\u0014h/\u001a:PEN,'O^3s!J|Wn\u001c;j_:\u0004v\u000e\\5ds\"\u001a1#a\u000f\u0002uQ,7\u000f^(cg\u0016\u0014h/\u001a:FY\u0016\u001cG/[8o/&$\b.\u00168eKJl\u0015N\\%te>\u00137/\u001a:wKJ\u0004&o\\7pi&|g\u000eU8mS\u000eL\bf\u0001\u000b\u0002<\u0005qE/Z:u\u001f\n\u001cXM\u001d<fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5D_6\u0004H.\u001a;f'\",H\u000fZ8x]^KG\u000f[+oI\u0016\u0014X*\u001b8JgJ|%m]3sm\u0016\u0014\bK]8n_RLwN\u001c)pY&\u001c\u0017\u0010K\u0002\u0016\u0003w\ta\b^3ti>\u00137/\u001a:wKJ,E.Z2uS>tw+\u001b;i+:$WM\u001d*fa2L7-\u0019;fI>\u00137/\u001a:wKJ\u0004&o\\7pi&|g\u000eU8mS\u000eL\bf\u0001\f\u0002<\u0005\u0011F/Z:u\u001f\n\u001cXM\u001d<fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5D_6\u0004H.\u001a;f'\",H\u000fZ8x]^KG\u000f[+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3PEN,'O^3s!J|Wn\u001c;j_:\u0004v\u000e\\5ds\"\u001aq#a\u000f\u0002wQ,7\u000f^(cg\u0016\u0014h/\u001a:Qe>lw\u000e^5p]^KG\u000f[+oI\u0016\u0014X*\u001b8JgJ|%m]3sm\u0016\u0014\bK]8n_RLwN\u001c)pY&\u001c\u0017\u0010K\u0002\u0019\u0003w\tq\b^3ti>\u00137/\u001a:wKJ\u0004&o\\7pi&|gnV5uQVsG-\u001a:SKBd\u0017nY1uK\u0012|%m]3sm\u0016\u0014\bK]8n_RLwN\u001c)pY&\u001c\u0017\u0010K\u0002\u001a\u0003w\t\u0001\t^3ti>\u00137/\u001a:wKJ\u0004&o\\7pi&|gnV5uQ2+\u0017\rZ3s\u0013N|%m]3sm\u0016\u0014xJY:feZ,'\u000f\u0015:p[>$\u0018n\u001c8Q_2L7-\u001f\u0015\u00045\u0005m\u0012A\n;fgR\u0014V-Y:tS\u001etwJY:feZ,'/T1uG\"LgnZ\"p]N$(/Y5oi\"\u001a1$a\u000f\u0002SQ,7\u000f\u001e*fCN\u001c\u0018n\u001a8XSRD7\t[1oO\u0016$wJY:feZ,'oQ8ogR\u0014\u0018-\u001b8uQ\ra\u00121H\u0001\"i\u0016\u001cHOU3bgNLwM\\*z]\u000e\u0014V\r\u001d7jG\u0006$vn\u00142tKJ4XM\u001d\u0015\u0004;\u0005m\u0012!\r;fgR\u0014V-Y:tS\u001etw+\u001b;i'^\f\u0007\u000f]3e'ft7-\u00118e\u001f\n\u001cXM\u001d<fe\u000e{gn\u001d;sC&tGo\u001d\u0015\u0004=\u0005m\u0012!\t;fgR\u0014V-Y:tS\u001etwJY:feZ,'\u000fV8Ts:\u001c'+\u001a9mS\u000e\f\u0007fA\u0010\u0002<\u0005yB/Z:u%\u0016\f7o]5h]^KG\u000f\u001b*f[>4X\rZ(cg\u0016\u0014h/\u001a:)\u0007\u0001\nY$A\u0010eK2,G/\u001a+pa&\u001c\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oiN$RA]AA\u00037Cq!a!\"\u0001\u0004\t))\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003\u000f\u000b9*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0015\tG-\\5o\u0015\u0011\ty)!%\u0002\u000f\rd\u0017.\u001a8ug*\u0019a+a%\u000b\t\u0005U\u0015QE\u0001\u0007CB\f7\r[3\n\t\u0005e\u0015\u0011\u0012\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fC\u0004\u0002\u001e\u0006\u0002\r!a(\u0002\u000bQ|\u0007/[2\u0011\t\u0005\u0005\u0016q\u0016\b\u0005\u0003G\u000bY\u000bE\u0002\u0002&&l!!a*\u000b\u0007\u0005%v+\u0001\u0004=e>|GOP\u0005\u0004\u0003[K\u0017A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0006M&AB*ue&twMC\u0002\u0002.&\fQ\u0004^3tiJ+\u0017m]:jO:<\u0016\u000e\u001e5BI\u0012,Gm\u00142tKJ4XM\u001d\u0015\u0004E\u0005m\u0012a\t;fgR\u0014V-Y:tS\u001etw+\u001b;i\u0013:4\u0018\r\\5e'ft7MU3qY&\u001c\u0017m\u001d\u0015\u0004G\u0005m\u0012a\n;fgR\u0014V-Y:tS\u001et'+Z1se\u0006tw-\u001a*fa2L7-Y!oI>\u00137/\u001a:wKJD3\u0001JA\u001e\u0003\u001d\"Xm\u001d;SK\u0006\u001c8/[4o/&$\b.\u00138wC2LGm\u00142tKJ4XM\u001d*fa2L7-Y:)\u0007\u0015\nY$A\u0011uKN$(+Z1tg&<gnV5uQ:+wo\u00144gY&tWM\u0011:pW\u0016\u00148\u000fK\u0002'\u0003w\t1\u0005^3ti\u001ac\u0017\u000e\u001d*fCN\u001c\u0018n\u001a8XSRDwJ\u001a4mS:,wJY:feZ,'\u000fK\u0002(\u0003w\tq\u0004^3ti\u001ac\u0017\u000e\u001d*fCN\u001c\u0018n\u001a8XSRDwJ\u001a4mS:,7+\u001f8dQ\rA\u00131H\u0001$i\u0016\u001cHOW6SK\u0006\u001c8/[4o/&$\b.\u00138wC2LG-Q:tS\u001etW.\u001a8uQ\rI\u00131H\u0001.i\u0016\u001cH/\u00138wC2LG\r\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]RLenQ8oM&<WO]1uS>t\u0007f\u0001\u0016\u0002<\u0005\u0019B/Z:u\u000b6\u0004H/_\"p]N$(/Y5oi\"\u001a1&a\u000f\u0002\u0017\u0015dWm\u0019;MK\u0006$WM\u001d\u000b\be\u0006\u0005\u0018\u0011^A}\u0011\u001d\t\u0019\t\fa\u0001\u0003G\u0004B!a\"\u0002f&!\u0011q]AE\u0005\u0015\tE-\\5o\u0011\u001d\tY\u000f\fa\u0001\u0003[\f!\u0001\u001e9\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cTA!a=\u0002\u0012\u000611m\\7n_:LA!a>\u0002r\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA~Y\u0001\u0007\u0011Q`\u0001\rK2,7\r^5p]RK\b/\u001a\t\u0005\u0003_\fy0\u0003\u0003\u0003\u0002\u0005E(\u0001D#mK\u000e$\u0018n\u001c8UsB,\u0017aH<bSR4uN\u001d.l%\u0016\f7o]5h]6,g\u000e\u001e+p\u0007>l\u0007\u000f\\3uKR\u0019!Oa\u0002\t\u0013\t%Q\u0006%AA\u0002\t-\u0011!\u00029bkN,\u0007cA:\u0003\u000e%\u0019!qB5\u0003\t1{gnZ\u0001*o\u0006LGOR8s5.\u0014V-Y:tS\u001etW.\u001a8u)>\u001cu.\u001c9mKR,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU!\u0006\u0002B\u0006\u0005/Y#A!\u0007\u0011\t\tm!QE\u0007\u0003\u0005;QAAa\b\u0003\"\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005GI\u0017AC1o]>$\u0018\r^5p]&!!q\u0005B\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016\u0007>tg\r\\;f]R|%m]3sm\u0016\u0014H+Z:u!\t\u0011\u0007gE\u00021\u0005_\u00012a\u001dB\u0019\u0013\r\u0011\u0019$\u001b\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t-\"a\u0004\"bg&\u001c7i\u001c8tiJ\f\u0017N\u001c;\u0014\u000fI\u0012yCa\u000f\u0003BA\u00191O!\u0010\n\u0007\t}\u0012NA\u0004Qe>$Wo\u0019;\u0011\u0007M\u0014\u0019%C\u0002\u0003F%\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fQaY8v]R\faaY8v]R\u0004\u0013\u0001\u0002:bG.,\"!a(\u0002\u000bI\f7m\u001b\u0011\u0015\r\tM#q\u000bB-!\r\u0011)FM\u0007\u0002a!1!qI\u001cA\u0002mDqAa\u00138\u0001\u0004\ty*\u0001\u0003d_BLHC\u0002B*\u0005?\u0012\t\u0007\u0003\u0005\u0003Ha\u0002\n\u00111\u0001|\u0011%\u0011Y\u0005\u000fI\u0001\u0002\u0004\ty*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d$fA>\u0003\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B7U\u0011\tyJa\u0006\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\u0019\b\u0005\u0003\u0003v\t}TB\u0001B<\u0015\u0011\u0011IHa\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0005{\nAA[1wC&!\u0011\u0011\u0017B<\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\"\u0003\u000eB\u00191O!#\n\u0007\t-\u0015NA\u0002B]fDqa^\u001f\u0002\u0002\u0003\u000710A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\nE\u0003g\u0005+\u00139)C\u0002\u0003\u0018\u001e\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u0014BR!\r\u0019(qT\u0005\u0004\u0005CK'a\u0002\"p_2,\u0017M\u001c\u0005\to~\n\t\u00111\u0001\u0003\b\u0006A\u0001.Y:i\u0007>$W\rF\u0001|\u0003!!xn\u0015;sS:<GC\u0001B:\u0003\u0019)\u0017/^1mgR!!Q\u0014BY\u0011!9()!AA\u0002\t\u001d\u0015a\u0004\"bg&\u001c7i\u001c8tiJ\f\u0017N\u001c;\u0011\u0007\tUCiE\u0003E\u0005s\u0013\t\u0005E\u0005\u0003<\n\u000570a(\u0003T5\u0011!Q\u0018\u0006\u0004\u0005\u007fK\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005\u0007\u0014iLA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\tM#1\u001aBg\u0011\u0019\u00119e\u0012a\u0001w\"9!1J$A\u0002\u0005}\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005'\u0014y\u000eE\u0003t\u0005+\u0014I.C\u0002\u0003X&\u0014aa\u00149uS>t\u0007CB:\u0003\\n\fy*C\u0002\u0003^&\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003Bq\u0011\u0006\u0005\t\u0019\u0001B*\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003hB!!Q\u000fBu\u0013\u0011\u0011YOa\u001e\u0003\r=\u0013'.Z2u\u0003E\tG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\t\u0005c\u00149Pa?\u0003~B!\u0011q\u0011Bz\u0013\u0011\u0011)0!#\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\b\u0005sT\u0005\u0019AAr\u0003-\tG-\\5o\u00072LWM\u001c;\t\u000f\u0005u%\n1\u0001\u0002 \"9!q &A\u0002\r\u0005\u0011\u0001\u0004;pa&\u001c7i\u001c8gS\u001e\u001c\b\u0003BB\u0002\u0007\u0013i!a!\u0002\u000b\t\r\u001d!1P\u0001\u0005kRLG.\u0003\u0003\u0004\f\r\u0015!A\u0003)s_B,'\u000f^5fg\u0006a1M]3bi\u0016\u001cuN\u001c4jOR!1\u0011CB\f!\u001d171CAP\u0005OL1a!\u0006h\u0005\ri\u0015\r\u001d\u0005\u0006G.\u0003\r!Z\u0001\u0012e\u0016\f7o]5h]6,g\u000e^#oiJLHCBB\u000f\u0007S\u0019y\u0003\u0005\u0004\u0004\u0004\r}11E\u0005\u0005\u0007C\u0019)A\u0001\u0005PaRLwN\\1m!\u0011\t9i!\n\n\t\r\u001d\u0012\u0011\u0012\u0002\u0019\u001d\u0016<\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\bbBB\u0016\u0019\u0002\u00071QF\u0001\te\u0016\u0004H.[2bgB\u0019am[>\t\u000f\rEB\n1\u0001\u0004.\u0005IqNY:feZ,'o]\u0001\"o\u0006LGOR8s\u00032d'+Z1tg&<g.\\3oiN$vnQ8na2,G/\u001a\u000b\u0004e\u000e]\u0002bBAB\u001b\u0002\u0007\u0011QQ\u0001\u0017I\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]R11QHB#\u0007\u000f\u0002Ra\u001dBk\u0007\u007f\u0001B!a<\u0004B%!11IAy\u0005I!v\u000e]5d!\u0006\u0014H/\u001b;j_:LeNZ8\t\u000f\u0005\re\n1\u0001\u0002\u0006\"91\u0011\n(A\u0002\u00055\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$B!a(\u0004P!)1m\u0014a\u0001K\u0006\u0019\"-Y:jGR{\u0007/[2QY\u0006\u001cW-\\3oiR1\u0011qTB+\u00073Bqaa\u0016Q\u0001\u0004\u0011\u0019&A\tsKBd\u0017nY1D_:\u001cHO]1j]RDqaa\u0017Q\u0001\u0004\u0019i&\u0001\npEN,'O^3s\u0007>t7\u000f\u001e:bS:$\b#B:\u0003V\nM\u0013\u0001\u0005<3)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u)!\tyja\u0019\u0004h\r%\u0004bBB3#\u0002\u0007\u0011qT\u0001\u0018_\n\u001cXM\u001d<feB\u0013x.\\8uS>t\u0007k\u001c7jGfDqaa\u0016R\u0001\u0004\u0011\u0019\u0006C\u0004\u0004\\E\u0003\ra!\u0018")
public final class ConfluentObserverTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int broker1;
    private final int broker2;
    private final int broker3;
    private final int broker4;
    private final int broker5;

    public static String v2TopicPlacement(String string, BasicConstraint basicConstraint, Option<BasicConstraint> option) {
        return ConfluentObserverTest$.MODULE$.v2TopicPlacement(string, basicConstraint, option);
    }

    public static String basicTopicPlacement(BasicConstraint basicConstraint, Option<BasicConstraint> option) {
        return ConfluentObserverTest$.MODULE$.basicTopicPlacement(basicConstraint, option);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return ConfluentObserverTest$.MODULE$.bootstrapServers(seq);
    }

    public static Option<TopicPartitionInfo> describeTopicPartition(AdminClient adminClient, TopicPartition topicPartition) {
        return ConfluentObserverTest$.MODULE$.describeTopicPartition(adminClient, topicPartition);
    }

    public static void waitForAllReassignmentsToComplete(AdminClient adminClient) {
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(adminClient);
    }

    public static Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> seq, Seq<Object> seq2) {
        return ConfluentObserverTest$.MODULE$.reassignmentEntry(seq, seq2);
    }

    public static Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ConfluentObserverTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    public int broker4() {
        return this.broker4;
    }

    public int broker5() {
        return this.broker5;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Map rack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker3())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker4())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker5())), (Object)"c")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(5, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)rack.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserversShouldNotJoinIsr() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserversShouldNotJoinIsr$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElection() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElection$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElectionWithLeaderIsObserverObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElectionWithLeaderIsObserverObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElectionWithUnderMinIsrObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElectionWithUnderMinIsrObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElectionWithCompleteShutdownWithUnderMinIsrObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElectionWithCompleteShutdownWithUnderMinIsrObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElectionWithUnderReplicatedObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElectionWithUnderReplicatedObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverElectionWithCompleteShutdownWithUnderReplicatedObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverElectionWithCompleteShutdownWithUnderReplicatedObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverPromotionWithUnderMinIsrObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverPromotionWithUnderMinIsrObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverPromotionWithUnderReplicatedObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverPromotionWithUnderReplicatedObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testObserverPromotionWithLeaderIsObserverObserverPromotionPolicy() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testObserverPromotionWithLeaderIsObserverObserverPromotionPolicy$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignObserverMatchingConstraint() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignObserverMatchingConstraint$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithChangedObserverConstraint() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithChangedObserverConstraint$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignSyncReplicaToObserver() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignSyncReplicaToObserver$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithSwappedSyncAndObserverConstraints() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithSwappedSyncAndObserverConstraints$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignObserverToSyncReplica() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignObserverToSyncReplica$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithRemovedObserver() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithRemovedObserver$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    private void deleteTopicPlacementConstraints(AdminClient client, String topic) {
        Properties deleteTopicPlacementConstraintsProps = new Properties();
        deleteTopicPlacementConstraintsProps.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), "");
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, deleteTopicPlacementConstraintsProps, AlterConfigOp.OpType.DELETE);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithAddedObserver() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithAddedObserver$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithInvalidSyncReplicas() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithInvalidSyncReplicas$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignRearrangeReplicaAndObserver() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignRearrangeReplicaAndObserver$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithInvalidObserverReplicas() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithInvalidObserverReplicas$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignWithNewOfflineBrokers() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testReassignWithNewOfflineBrokers$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlipReassignWithOfflineObserver() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testFlipReassignWithOfflineObserver$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlipReassignWithOfflineSync() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testFlipReassignWithOfflineSync$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkReassignWithInvalidAssignment() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testZkReassignWithInvalidAssignment$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidPlacementConstraintInConfiguration() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ConfluentObserverTest.$anonfun$testInvalidPlacementConstraintInConfiguration$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyConstraint() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ConfluentObserverTest.$anonfun$testEmptyConstraint$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    private void electLeader(Admin client, TopicPartition tp, ElectionType electionType) {
        ElectLeadersResult electionResult = client.electLeaders(electionType, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric((Optional)((java.util.Map)electionResult.partitions().get()).get(tp))).foreach((Function1 & Serializable & scala.Serializable)exception -> {
            throw exception;
        });
    }

    private void waitForZkReassignmentToComplete(long pause) {
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConfluentObserverTest.$anonfun$waitForZkReassignmentToComplete$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ConfluentObserverTest.$anonfun$waitForZkReassignmentToComplete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), pause));
        }
    }

    private long waitForZkReassignmentToComplete$default$1() {
        return 100L;
    }

    public static final /* synthetic */ void $anonfun$testObserversShouldNotJoinIsr$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElection$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        $this.electLeader((Admin)client, topicPartition, ElectionType.UNCLEAN);
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElectionWithLeaderIsObserverObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("leader-is-observer", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        $this.electLeader((Admin)client, topicPartition, ElectionType.UNCLEAN);
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElectionWithUnderMinIsrObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-min-isr", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinInSyncReplicasProp()), (Object)"2")}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            ((KafkaServer)$this.servers().apply(broker)).shutdown();
            TestUtils$.MODULE$.waitForOneOfBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        });
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElectionWithCompleteShutdownWithUnderMinIsrObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-min-isr", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        $this.electLeader((Admin)client, topicPartition, ElectionType.UNCLEAN);
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElectionWithUnderReplicatedObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-replicated", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            ((KafkaServer)$this.servers().apply(broker)).shutdown();
            TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1()}))));
        });
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverElectionWithCompleteShutdownWithUnderReplicatedObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-replicated", new BasicConstraint(1, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        int leader = TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        $this.electLeader((Admin)client, topicPartition, ElectionType.UNCLEAN);
        TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, $this.broker3(), $this.broker4()}))));
        $this.electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverPromotionWithUnderMinIsrObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-min-isr", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinInSyncReplicasProp()), (Object)"2")}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        int leader = TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        scala.collection.immutable.Set rollingServers = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))).$minus((Object)BoxesRunTime.boxToInteger((int)leader));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        TestUtils$.MODULE$.waitForLeaderPlusOneOfBrokersInIsr((Admin)client, topicPartition, leader, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverPromotionWithUnderReplicatedObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("under-replicated", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        int leader = TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        scala.collection.immutable.Set rollingServers = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))).$minus((Object)BoxesRunTime.boxToInteger((int)leader));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        TestUtils$.MODULE$.waitForLeaderPlusOneOfBrokersInIsr((Admin)client, topicPartition, leader, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testObserverPromotionWithLeaderIsObserverObserverPromotionPolicy$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.v2TopicPlacement("leader-is-observer", new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        int leader = TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        scala.collection.immutable.Set rollingServers = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))).$minus((Object)BoxesRunTime.boxToInteger((int)leader));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).shutdown());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))).$minus((Object)BoxesRunTime.boxToInteger((int)leader))));
        rollingServers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> ((KafkaServer)$this.servers().apply(broker)).startup());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignObserverMatchingConstraint$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker4()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker4()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker4()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker4()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithChangedObserverConstraint$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        Properties observerCConfig = new Properties();
        observerCConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "c"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerCConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker5()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker5()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker5()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker5()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignSyncReplicaToObserver$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers(), new Properties());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)$this.broker1())));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))));
        Properties observerBConfig = new Properties();
        observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerBConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithSwappedSyncAndObserverConstraints$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Properties observerBConfig = new Properties();
        observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerBConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignObserverToSyncReplica$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        $this.deleteTopicPlacementConstraints(client, topic);
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))), (Seq<Object>)Nil$.MODULE$))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithRemovedObserver$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        $this.deleteTopicPlacementConstraints(client, topic);
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))), (Seq<Object>)Nil$.MODULE$))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithAddedObserver$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers(), new Properties());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)$this.broker1())));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        Properties observerBConfig = new Properties();
        observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerBConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithInvalidSyncReplicas$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker5(), $this.broker3(), $this.broker4()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()})))))}))).asJava()).all().get());
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ void $anonfun$testReassignRearrangeReplicaAndObserver$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Seq replicas = ((TraversableOnce)((TraversableLike)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).all().get()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2.replicas()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Seq newReplicaOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(1)), BoxesRunTime.unboxToInt((Object)replicas.apply(0)), BoxesRunTime.unboxToInt((Object)replicas.apply(3)), BoxesRunTime.unboxToInt((Object)replicas.apply(2))}));
        Seq newObserverOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(3)), BoxesRunTime.unboxToInt((Object)replicas.apply(2))}));
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)newReplicaOrder, (Seq<Object>)newObserverOrder))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)newReplicaOrder);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker1()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker4(), $this.broker3()}))));
    }

    public static final /* synthetic */ void $anonfun$testReassignWithInvalidObserverReplicas$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker5()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker5()})))))}))).asJava()).all().get());
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ InvalidReplicaAssignmentException $anonfun$testReassignWithNewOfflineBrokers$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        int offlineBrokerId = 5;
        return (InvalidReplicaAssignmentException)TestUtils.assertFutureThrows((Future)client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), offlineBrokerId}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), offlineBrokerId})))))}))).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    public static final /* synthetic */ void $anonfun$testFlipReassignWithOfflineObserver$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Properties observerBConfig = new Properties();
        observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerBConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        ((KafkaServer)$this.servers().apply($this.broker1())).shutdown();
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()})))))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
    }

    public static final /* synthetic */ void $anonfun$testFlipReassignWithOfflineSync$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Properties observerBConfig = new Properties();
        observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, observerBConfig, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4(), $this.broker1(), $this.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()})))))}))).asJava()).all().get());
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ void $anonfun$testZkReassignWithInvalidAssignment$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "observer-topic";
        int partition = 0;
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Map zkReassignments = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2(), $this.broker3(), $this.broker4()})))}));
        $this.zkClient().setOrCreatePartitionReassignment(zkReassignments, ZkVersion$.MODULE$.MatchAnyVersion());
        $this.waitForZkReassignmentToComplete($this.waitForZkReassignmentToComplete$default$1());
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    public static final /* synthetic */ Throwable $anonfun$testInvalidPlacementConstraintInConfiguration$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        Properties configUpdate = new Properties();
        configUpdate.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), "invalid json");
        TestUtils.assertFutureError((Future)ConfluentObserverTest$.MODULE$.alterTopicConfigs((Admin)client, topic, configUpdate).all(), InvalidRequestException.class);
        return TestUtils.assertFutureError((Future)TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all(), InvalidRequestException.class);
    }

    public static final /* synthetic */ void $anonfun$testEmptyConstraint$1(ConfluentObserverTest $this, AdminClient client) {
        String topic = "empty-constraints";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.of((short)2));
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)"")}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        Seq secondAssignment = (Seq)((TraversableOnce)((TraversableLike)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).all().get()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$4.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$5.replicas()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Iterable$.MODULE$.canBuildFrom())).toSeq().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)id -> (id + 1) % $this.servers().size(), Seq$.MODULE$.canBuildFrom());
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)secondAssignment, (Seq<Object>)Nil$.MODULE$))}))).asJava()).all().get();
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)secondAssignment);
        Seq thirdAssignment = (Seq)secondAssignment.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)id -> (id + 1) % $this.servers().size(), Seq$.MODULE$.canBuildFrom());
        $this.zkClient().setOrCreatePartitionReassignment((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)thirdAssignment)})), ZkVersion$.MODULE$.MatchAnyVersion());
        $this.waitForZkReassignmentToComplete($this.waitForZkReassignmentToComplete$default$1());
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)thirdAssignment);
    }

    public static final /* synthetic */ boolean $anonfun$waitForZkReassignmentToComplete$1(ConfluentObserverTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$waitForZkReassignmentToComplete$2() {
        return new StringBuilder(21).append("Znode ").append(ReassignPartitionsZNode$.MODULE$.path()).append(" wasn't deleted").toString();
    }

    public ConfluentObserverTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
        this.broker4 = 3;
        this.broker5 = 4;
    }

    public static final /* synthetic */ Object $anonfun$testObserversShouldNotJoinIsr$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserversShouldNotJoinIsr$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElection$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElection$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElectionWithLeaderIsObserverObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElectionWithLeaderIsObserverObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElectionWithUnderMinIsrObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElectionWithUnderMinIsrObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElectionWithCompleteShutdownWithUnderMinIsrObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElectionWithCompleteShutdownWithUnderMinIsrObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElectionWithUnderReplicatedObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElectionWithUnderReplicatedObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverElectionWithCompleteShutdownWithUnderReplicatedObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverElectionWithCompleteShutdownWithUnderReplicatedObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverPromotionWithUnderMinIsrObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverPromotionWithUnderMinIsrObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverPromotionWithUnderReplicatedObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverPromotionWithUnderReplicatedObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testObserverPromotionWithLeaderIsObserverObserverPromotionPolicy$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testObserverPromotionWithLeaderIsObserverObserverPromotionPolicy$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignObserverMatchingConstraint$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignObserverMatchingConstraint$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithChangedObserverConstraint$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithChangedObserverConstraint$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignSyncReplicaToObserver$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignSyncReplicaToObserver$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithSwappedSyncAndObserverConstraints$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithSwappedSyncAndObserverConstraints$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignObserverToSyncReplica$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignObserverToSyncReplica$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithRemovedObserver$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithRemovedObserver$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithAddedObserver$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithAddedObserver$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithInvalidSyncReplicas$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithInvalidSyncReplicas$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignRearrangeReplicaAndObserver$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignRearrangeReplicaAndObserver$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testReassignWithInvalidObserverReplicas$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testReassignWithInvalidObserverReplicas$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testFlipReassignWithOfflineObserver$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testFlipReassignWithOfflineObserver$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testFlipReassignWithOfflineSync$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testFlipReassignWithOfflineSync$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testZkReassignWithInvalidAssignment$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testZkReassignWithInvalidAssignment$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testEmptyConstraint$1$adapted(ConfluentObserverTest $this, AdminClient client) {
        ConfluentObserverTest.$anonfun$testEmptyConstraint$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static class BasicConstraint
    implements Product,
    scala.Serializable {
        private final int count;
        private final String rack;

        public int count() {
            return this.count;
        }

        public String rack() {
            return this.rack;
        }

        public BasicConstraint copy(int count, String rack) {
            return new BasicConstraint(count, rack);
        }

        public int copy$default$1() {
            return this.count();
        }

        public String copy$default$2() {
            return this.rack();
        }

        public String productPrefix() {
            return "BasicConstraint";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.count());
                }
                case 1: {
                    return this.rack();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BasicConstraint;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.count()), (int)Statics.anyHash((Object)this.rack())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof BasicConstraint)) return false;
            boolean bl = true;
            if (!bl) return false;
            BasicConstraint basicConstraint = (BasicConstraint)x$1;
            if (this.count() != basicConstraint.count()) return false;
            String string = this.rack();
            String string2 = basicConstraint.rack();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!basicConstraint.canEqual(this)) return false;
            return true;
        }

        public BasicConstraint(int count, String rack) {
            this.count = count;
            this.rack = rack;
            Product.$init$((Product)this);
        }
    }
}

