/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiVersionManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerApis;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestLocal$;
import kafka.server.SimpleApiVersionManager;
import kafka.test.MockController;
import kafka.utils.MockTime;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0015\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019q\u0006\u0001)A\u0005-\"9q\f\u0001b\u0001\n\u0013)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00022\t\r5\u0004\u0001\u0015!\u0003d\u0011\u001dq\u0007A1A\u0005\n=Daa\u001d\u0001!\u0002\u0013\u0001\bb\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007y\u0002\u0001\u000b\u0011\u0002<\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011Q\u0001\u0001!\u0002\u0013y\b\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\ti\u0002\u0001Q\u0001\n\u0005]\u0001\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011!\tI\u0003\u0001Q\u0001\n\u0005\r\u0002\"CA\u0016\u0001\t\u0007I\u0011BA\u0017\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005=\u0002\"CA+\u0001\t\u0007I\u0011BA,\u0011!\t)\b\u0001Q\u0001\n\u0005e\u0003bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\n\u0003g\u0003\u0011\u0013!C\u0005\u0003kCq!a3\u0001\t\u0013\ti\rC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0003\u0003\u0006!9!Q\u0002\u0001\u0005\u0002\t=\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005c\u0001A\u0011\u0001B\n\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005'AqA!\u000f\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003>\u0001!\tAa\u0005\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003\u0014!9!Q\t\u0001\u0005\u0002\tM\u0001b\u0002B%\u0001\u0011\u0005!1\u0003\u0005\b\u0005\u001b\u0002A\u0011\u0001B\n\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005'AqA!\u0016\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003Z\u0001!\tAa\u0005\t\u000f\tu\u0003\u0001\"\u0001\u0003\u0014!9!\u0011\r\u0001\u0005\u0002\tM\u0001b\u0002B3\u0001\u0011\u0005!1\u0003\u0005\b\u0005S\u0002A\u0011\u0001B\n\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005'AqA!\u001d\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003v\u0001!\tAa\u0005\t\u000f\te\u0004\u0001\"\u0001\u0003\u0014!9!Q\u0010\u0001\u0005\u0002\tM\u0001b\u0002BA\u0001\u0011\u0005!1\u0003\u0005\b\u0005\u000b\u0003A\u0011\u0001B\n\u0011\u001d\u0011I\t\u0001C\u0001\u0005'AqA!$\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0012\u0002!\tAa\u0005\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0014!9!\u0011\u0014\u0001\u0005\u0002\tM\u0001b\u0002BO\u0001\u0011\u0005!1\u0003\u0005\b\u0005C\u0003A\u0011\u0001B\n\u0005I\u0019uN\u001c;s_2dWM]!qSN$Vm\u001d;\u000b\u0005}\u0002\u0015AB:feZ,'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\n\u0005\u0002N\u00015\ta(\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0002!B\u0011Q)U\u0005\u0003%\u001a\u00131!\u00138u\u0003\u001dqw\u000eZ3JI\u0002\n!B\u0019:pW\u0016\u0014(+Y2l+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\t\u0014xn[3s%\u0006\u001c7\u000eI\u0001\tG2LWM\u001c;J\t\u0006I1\r\\5f]RLE\tI\u0001\u0016e\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2t+\u0005\u0019\u0007C\u00013k\u001d\t)\u0007.D\u0001g\u0015\t9\u0007)A\u0004oKR<xN]6\n\u0005%4\u0017A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003W2\u0014q!T3ue&\u001c7O\u0003\u0002jM\u00061\"/Z9vKN$8\t[1o]\u0016dW*\u001a;sS\u000e\u001c\b%\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003A\u0004\"!Z9\n\u0005I4'A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!A/[7f+\u00051\bCA<{\u001b\u0005A(BA=A\u0003\u0015)H/\u001b7t\u0013\tY\bP\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019G.[3oiF+x\u000e^1NC:\fw-\u001a:\u0016\u0003}\u00042!TA\u0001\u0013\r\t\u0019A\u0010\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'/A\ndY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b%A\rdY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014XCAA\u0006!\ri\u0015QB\u0005\u0004\u0003\u001fq$!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\f!d\u00197jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\u0002\nAd\u00197jK:$8i\u001c8ue>dG.\u001a:Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u0018A\u0019Q*!\u0007\n\u0007\u0005maH\u0001\u0010D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC6\u000bg.Y4fe\u0006i2\r\\5f]R\u001cuN\u001c;s_2dWM])v_R\fW*\u00198bO\u0016\u0014\b%A\nsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002$A\u0019Q*!\n\n\u0007\u0005\u001dbHA\fSKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4fe\u0006!\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4fe\u0002\n1B]1gi6\u000bg.Y4feV\u0011\u0011q\u0006\t\u0007\u0003c\t9$a\u000f\u000e\u0005\u0005M\"bAA\u001b\u0001\u0006!!/\u00194u\u0013\u0011\tI$a\r\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0005\u0003{\ty%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0019\u0019w.\\7p]*\u0019q(!\u0012\u000b\u0007\u0005\u000b9E\u0003\u0003\u0002J\u0005-\u0013AB1qC\u000eDWM\u0003\u0002\u0002N\u0005\u0019qN]4\n\t\u0005E\u0013q\b\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011\u0002\rE,x\u000e^1t+\t\tI\u0006\u0005\u0003\u0002\\\u0005=d\u0002BA/\u0003WrA!a\u0018\u0002j9!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\t\u000ba\u0001\u0010:p_Rt\u0014\"A!\n\u0005}\u0002\u0015bAA7}\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011\u0011OA:\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u0011Q\u000e \u0002\u000fE,x\u000e^1tA\u0005!2M]3bi\u0016\u001cuN\u001c;s_2dWM]!qSN$\u0002\"a\u001f\u0002\u0002\u0006U\u00151\u0015\t\u0004\u001b\u0006u\u0014bAA@}\tq1i\u001c8ue>dG.\u001a:Ba&\u001c\bbBAB5\u0001\u0007\u0011QQ\u0001\u000bCV$\bn\u001c:ju\u0016\u0014\b#B#\u0002\b\u0006-\u0015bAAE\r\n1q\n\u001d;j_:\u0004B!!$\u0002\u00126\u0011\u0011q\u0012\u0006\u0005\u0003\u0007\u000b\u0019%\u0003\u0003\u0002\u0014\u0006=%AC!vi\"|'/\u001b>fe\"9\u0011q\u0013\u000eA\u0002\u0005e\u0015AC2p]R\u0014x\u000e\u001c7feB!\u00111TAP\u001b\t\tiJ\u0003\u0003\u0002\u0018\u0006\u0015\u0013\u0002BAQ\u0003;\u0013!bQ8oiJ|G\u000e\\3s\u0011%\t)K\u0007I\u0001\u0002\u0004\t9+A\u0003qe>\u00048\u000f\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\tiKW\u0001\u0005kRLG.\u0003\u0003\u00022\u0006-&A\u0003)s_B,'\u000f^5fg\u0006q2M]3bi\u0016\u001cuN\u001c;s_2dWM]!qSN$C-\u001a4bk2$HeM\u000b\u0003\u0003oSC!a*\u0002:.\u0012\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003%)hn\u00195fG.,GMC\u0002\u0002F\u001a\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI-a0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007ck&dGMU3rk\u0016\u001cH/\u0006\u0003\u0002P\u0006]HCBAi\u0003/\fI\u000fE\u0002e\u0003'L1!!6m\u0005\u001d\u0011V-];fgRDq!!7\u001d\u0001\u0004\tY.A\u0004sKF,Xm\u001d;\u0011\t\u0005u\u0017Q]\u0007\u0003\u0003?TA!!9\u0002d\u0006A!/Z9vKN$8O\u0003\u0003\u0002B\u0005\u0015\u0013\u0002BAt\u0003?\u0014q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\n\u0003Wd\u0002\u0013!a\u0001\u0003[\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a<\u0002t6\u0011\u0011\u0011\u001f\u0006\u0004O\u0006\r\u0018\u0002BA{\u0003c\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016$q!!?\u001d\u0005\u0004\tYPA\u0001U#\u0011\ti0a7\u0011\u0007\u0015\u000by0C\u0002\u0003\u0002\u0019\u0013qAT8uQ&tw-\u0001\fck&dGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u00119Aa\u0003\u0016\u0005\t%!\u0006BAw\u0003s#q!!?\u001e\u0005\u0004\tY0A\fde\u0016\fG/\u001a#f]f\fE\u000e\\!vi\"|'/\u001b>feR\u0011\u00111R\u0001\u0016i\u0016\u001cH/\u00168bkRDwN]5{K\u00124U\r^2i)\t\u0011)\u0002E\u0002F\u0005/I1A!\u0007G\u0005\u0011)f.\u001b;)\u0007}\u0011i\u0002\u0005\u0003\u0003 \t5RB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003(\t%\u0012a\u00026va&$XM\u001d\u0006\u0005\u0005W\tY%A\u0003kk:LG/\u0003\u0003\u00030\t\u0005\"\u0001\u0002+fgR\fA\u0003^3ti\u001a+Go\u00195TK:$Hk\\&SC\u001a$\bf\u0001\u0011\u0003\u001e\u0005iB/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a$fi\u000eD7K\\1qg\"|G\u000fK\u0002\"\u0005;\tA\u0004^3ti\u001a+Go\u00195T]\u0006\u00048\u000f[8u'\u0016tG\u000fV8L%\u00064G\u000fK\u0002#\u0005;\tA\u0003^3tiVs\u0017-\u001e;i_JL'0\u001a3W_R,\u0007fA\u0012\u0003\u001e\u0005\u0011C/Z:u\u0011\u0006tG\r\\3MK\u001e\f7-_!mi\u0016\u00148i\u001c8gS\u001e\u001cXI\u001d:peND3\u0001\nB\u000f\u0003\u0001\"Xm\u001d;V]\u0006,H\u000f[8sSj,GMQ3hS:\fVo\u001c:v[\u0016\u0003xn\u00195)\u0007\u0015\u0012i\"\u0001\u0010uKN$XK\\1vi\"|'/\u001b>fI\u0016sG-U;peVlW\t]8dQ\"\u001aaE!\b\u0002=Q,7\u000f^+oCV$\bn\u001c:ju\u0016$G)Z:de&\u0014W-U;peVl\u0007fA\u0014\u0003\u001e\u0005)C/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a%b]\u0012dW-\u00117uKJL5O\u001d*fcV,7\u000f\u001e\u0015\u0004Q\tu\u0011\u0001\f;fgR,f.Y;uQ>\u0014\u0018N_3e\u0011\u0006tG\r\\3Ce>\\WM\u001d%fCJ$()Z1u%\u0016\fX/Z:uQ\rI#QD\u0001'i\u0016\u001cH/\u00168bkRDwN]5{K\u0012D\u0015M\u001c3mKVs'/Z4jgR,'O\u0011:pW\u0016\u0014\bf\u0001\u0016\u0003\u001e\u0005IA/Z:u\u00072|7/\u001a\u0015\u0004W\tu\u0011A\t;fgR,f.Y;uQ>\u0014\u0018N_3e\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g\u000eK\u0002-\u0005;\tq\u0005^3tiVs\u0017-\u001e;i_JL'0\u001a3IC:$G.Z!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg\"\u001aQF!\b\u0002[Q,7\u000f^+oCV$\bn\u001c:ju\u0016$\u0007*\u00198eY\u0016Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000fK\u0002/\u0005;\t1\u0006^3ti&sg/\u00197jI&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:pkJ\u001cWm\u001d\u0015\u0004_\tu\u0011!\r;fgR,f.Y;uQ>\u0014\u0018N_3e\u0011\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u001d\u0015\u0004a\tu\u0011!\u000b;fgR,f.Y;uQ>\u0014\u0018N_3e\u0011\u0006tG\r\\3BY2|7-\u0019;f!J|G-^2fe&#7\u000fK\u00022\u0005;\t\u0001\u0007^3tiVs\u0017-\u001e;i_JL'0\u001a3IC:$G.\u001a'jgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u001c\bf\u0001\u001a\u0003\u001e\u0005\u0001B/Z:u\u0007J,\u0017\r^3U_BL7m\u001d\u0015\u0004g\tu\u0011A\u0006;fgR$U\r\\3uKR{\u0007/[2t\u0005ft\u0015-\\3)\u0007Q\u0012i\"\u0001\u000buKN$H)\u001a7fi\u0016$v\u000e]5dg\nK\u0018\n\u001a\u0015\u0004k\tu\u0011A\b;fgRLeN^1mS\u0012$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:uQ\r1$QD\u0001+i\u0016\u001cHOT8u\u0003V$\bn\u001c:ju\u0016$Gk\u001c#fY\u0016$XmV5uQR{\u0007/[2Fq&\u001cH/\u001b8hQ\r9$QD\u0001.i\u0016\u001cHOT8u\u0003V$\bn\u001c:ju\u0016$Gk\u001c#fY\u0016$XmV5uQR{\u0007/[2O_R,\u00050[:uS:<\u0007f\u0001\u001d\u0003\u001e\u0005aC/Z:u\u001d>$8i\u001c8ue>dG.\u001a:FeJ|'\u000f\u0015:fm\u0016tGo\u001d#fY\u0016$\u0018N\\4U_BL7m\u001d\u0015\u0004s\tu\u0011\u0001\u0007;fgR$U\r\\3uKR{\u0007/[2t\t&\u001c\u0018M\u00197fI\"\u001a!H!\b\u00027Q,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8t%\u0016\fX/Z:uQ\rY$QD\u0001\ti\u0016\f'\u000fR8x]\"\u001aAH!*\u0011\t\t}!qU\u0005\u0005\u0005S\u0013\tCA\u0005BMR,'/R1dQ\u0002")
public class ControllerApisTest {
    private final int nodeId;
    private final String brokerRack;
    private final String clientID;
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
    private final MockTime time = new MockTime();
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private final ControllerMutationQuotaManager clientControllerQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private final RaftManager<ApiMessageAndVersion> raftManager = (RaftManager)Mockito.mock(RaftManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.clientControllerQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);

    private int nodeId() {
        return this.nodeId;
    }

    private String brokerRack() {
        return this.brokerRack;
    }

    private String clientID() {
        return this.clientID;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ControllerMutationQuotaManager clientControllerQuotaManager() {
        return this.clientControllerQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private ControllerApis createControllerApis(Option<Authorizer> authorizer, Controller controller, Properties props) {
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Predef$.MODULE$.int2Integer(this.nodeId()));
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(this.nodeId()).append("@localhost:9093").toString());
        return new ControllerApis(this.requestChannel(), authorizer, this.quotas(), (Time)this.time(), Predef$.MODULE$.Map().empty(), controller, this.raftManager(), new KafkaConfig((Map)props), new MetaProperties("JgxuGe9URy-E-ceaL04lEw", this.nodeId()), (Seq)Nil$.MODULE$, (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER));
    }

    private Properties createControllerApis$default$3() {
        return new Properties();
    }

    private <T extends AbstractRequest> RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) {
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(request.apiKey(), request.version(), this.clientID(), 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    /*
     * WARNING - void declaration
     */
    public Authorizer createDenyAllAuthorizer() {
        void var1_1;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Mockito.mock(Authorizer.class);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(AuthorizableRequestContext.class), (List)ArgumentMatchers.any(List.class))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        return var1_1;
    }

    @Test
    public void testUnauthorizedFetch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedFetchSnapshot() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSnapshotSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedVote() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleVote(this.buildRequest((AbstractRequest)new VoteRequest.Builder(new VoteRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testHandleLegacyAlterConfigsErrors() {
        AlterConfigsRequestData requestData = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("baz").setResourceType((byte)123).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new AlterConfigsRequest(requestData, 0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleLegacyAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        AlterConfigsResponse response = (AlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 123.").setResourceName("baz").setResourceType((byte)123), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("Cluster authorization failed.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedBeginQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBeginQuorumEpoch(this.buildRequest((AbstractRequest)new BeginQuorumEpochRequest.Builder(new BeginQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedEndQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleEndQuorumEpoch(this.buildRequest((AbstractRequest)new EndQuorumEpochRequest.Builder(new EndQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedDescribeQuorum() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleDescribeQuorum(this.buildRequest((AbstractRequest)new DescribeQuorumRequest.Builder(new DescribeQuorumRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAlterIsrRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterIsrRequest(this.buildRequest((AbstractRequest)new AlterIsrRequest.Builder(new AlterIsrRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleBrokerHeartBeatRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBrokerHeartBeatRequest(this.buildRequest((AbstractRequest)new BrokerHeartbeatRequest.Builder(new BrokerHeartbeatRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleUnregisterBroker() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleUnregisterBroker(this.buildRequest((AbstractRequest)new UnregisterBrokerRequest.Builder(new UnregisterBrokerRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testClose() {
        ControllerApis apis = this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3());
        apis.close();
        Assertions.assertTrue((boolean)apis.isClosed());
    }

    @Test
    public void testUnauthorizedBrokerRegistration() {
        BrokerRegistrationRequest brokerRegistrationRequest = (BrokerRegistrationRequest)new BrokerRegistrationRequest.Builder(new BrokerRegistrationRequestData().setBrokerId(this.nodeId()).setRack(this.brokerRack())).build();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)brokerRegistrationRequest, this.buildRequest$default$2());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3()).handle(request, RequestLocal$.MODULE$.withThreadConfinedCaching());
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        BrokerRegistrationResponse brokerRegistrationResponse = (BrokerRegistrationResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.CLUSTER_AUTHORIZATION_FAILED), (Object)BoxesRunTime.boxToInteger((int)1))})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(brokerRegistrationResponse.errorCounts()).asScala());
    }

    @Test
    public void testUnauthorizedHandleAlterClientQuotas() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterClientQuotas(this.buildRequest((AbstractRequest)new AlterClientQuotasRequest(new AlterClientQuotasRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleIncrementalAlterConfigs() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("flush.ms").setValue("1000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()).setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testInvalidIncrementalAlterConfigsResources() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("kafka.server.KafkaConfig").setValue("TRACE").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType((byte)124).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Unexpected resource type BROKER_LOGGER.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 124.").setResourceName("foo").setResourceType((byte)124)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterPartitionReassignments(this.buildRequest(new AlterPartitionReassignmentsRequest.Builder(new AlterPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAllocateProducerIds() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAllocateProducerIdsRequest(this.buildRequest(new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleListPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleListPartitionReassignments(this.buildRequest(new ListPartitionReassignmentsRequest.Builder(new ListPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testCreateTopics() {
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreateTopicsRequestData request = new CreateTopicsRequestData().setTopics(new CreateTopicsRequestData.CreatableTopicCollection(Arrays.asList((Object[])new CreateTopicsRequestData.CreatableTopic[]{new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(1).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("baz").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("quux").setNumPartitions(2).setReplicationFactor((short)3)}).iterator()));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateTopicsResponseData.CreatableTopicResult[]{new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("baz").setErrorCode(Errors.NONE.code()).setTopicId(new Uuid(0L, 1L)), new CreateTopicsResponseData.CreatableTopicResult().setName("quux").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((CreateTopicsResponseData)controllerApis.createTopics(request, false, (Function1 & Serializable & scala.Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz"}))).get()).topics()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsByName() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"foo", "bar", "quux", "quux"}));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("This server does not host this topic-partition."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$2 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$3 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsById() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid quuxId = Uuid.fromString((String)"ObXkLhL_S5W62FAE67U3MQ");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(quuxId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage("This server does not host this topic ID."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$4 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$5 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testInvalidDeleteTopicsRequest() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"YOS4oQ3UT9eSAZahN1ysSA");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Neither topic name nor id were specified."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("You may not specify both topic name and topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setTopicId(barId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The provided topic name maps to an ID that was already supplied."), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(bazId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id.")}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)names -> names.toSet(), (Function1 & Serializable & scala.Serializable)names -> names.toSet()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicExisting() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w");
        Uuid quuxId = Uuid.fromString((String)"5URoQzW_RJiERVZXJgUVLg");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).newInitialTopic("baz", bazId).newInitialTopic("quux", quuxId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("baz").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("baz").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$6 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "baz"})), (Function1 & Serializable & scala.Serializable)x$7 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicNotExisting() {
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_ID.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$8 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Function1 & Serializable & scala.Serializable)x$9 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotControllerErrorPreventsDeletingTopics() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        controller.setActive(false);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals(NotControllerException.class, Assertions.assertThrows(ExecutionException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$10 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$11 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).getCause().getClass());
    }

    @Test
    public void testDeleteTopicsDisabled() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "false");
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, props);
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$12 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$13 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        Assertions.assertThrows(InvalidRequestException.class, () -> controllerApis.deleteTopics(request, 1, false, (Function1 & Serializable & scala.Serializable)x$14 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$15 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
    }

    @Test
    public void testCreatePartitionsRequest() {
        MockController controller = new MockController.Builder().newInitialTopic("foo", Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).newInitialTopic("bar", Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw")).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreatePartitionsRequestData request = new CreatePartitionsRequestData();
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("baz").setAssignments(null).setCount(5));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsResponseData.CreatePartitionsTopicResult[]{new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("foo").setErrorCode(Errors.NONE.code()).setErrorMessage(null), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("baz").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(null)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.createPartitions(request, false, (Function1 & Serializable & scala.Serializable)x$16 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).asScala()).toSet());
    }

    @AfterEach
    public void tearDown() {
        this.quotas().shutdown();
    }

    public ControllerApisTest() {
        this.nodeId = 1;
        this.brokerRack = "Rack1";
        this.clientID = "Client1";
    }
}

