/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.cluster.PartitionListener;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierFetchDataInfo;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.ReclaimableMemoryRecords;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0012%\u0001%BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u00199\u0005\u0001)A\u0005\u0003\"9\u0001\n\u0001b\u0001\n\u0013I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011B(\t\rM\u0003\u0001\u0015!\u0003Q\u0011%!\u0006\u00011AA\u0002\u0013%Q\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\"I\u0001\r\u0001a\u0001\u0002\u0003\u0006KA\u0016\u0005\u0006C\u0002!\tA\u0019\u0005\u0006]\u0002!\tA\u0019\u0005\u0006g\u0002!\tA\u0019\u0005\u0006q\u0002!\tA\u0019\u0005\u0006u\u0002!\tA\u0019\u0005\u0006y\u0002!\tA\u0019\u0005\u0006}\u0002!\tA\u0019\u0005\u0007\u0003\u0003\u0001A\u0011\u00012\t\r\u0005\u0015\u0001\u0001\"\u0001c\u0011\u0019\tI\u0001\u0001C\u0001E\"1\u0011Q\u0002\u0001\u0005\u0002\tDa!!\u0005\u0001\t\u0003\u0011\u0007BBA\u000b\u0001\u0011\u0005!\rC\u0004\u0002\u001a\u0001!I!a\u0007\t\u0013\u0005U\u0004!%A\u0005\n\u0005]\u0004bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!a2\u0001\t\u0013\tI\rC\u0005\u0003\u0010\u0001\t\n\u0011\"\u0003\u0003\u0012!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u001c\u0001\u0011%!\u0011\b\u0002\u0011\t\u0016d\u0017-_3e\r\u0016$8\r\u001b+fgRT!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u0011\u0015\f7/_7pG.T\u0011aL\u0001\u0004_J<\u0017BA\u0019-\u0005=)\u0015m]=N_\u000e\\7+\u001e9q_J$\u0018A\u0002\u001fj]&$h\bF\u00015!\t)\u0004!D\u0001%\u0003!i\u0017\r\u001f\"zi\u0016\u001cX#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/A\u0005nCb\u0014\u0015\u0010^3tA\u0005AQn\\2l)&lW-F\u0001B!\t\u0011U)D\u0001D\u0015\t!e%A\u0003vi&d7/\u0003\u0002G\u0007\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001&\u0011\u0005UZ\u0015B\u0001'%\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\re\u0016\u0004H.[2b#V|G/Y\u000b\u0002!B\u0011Q'U\u0005\u0003%\u0012\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fQB]3qY&\u001c\u0017-U;pi\u0006\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\u00051\u0006CA\u001bX\u0013\tAFE\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006!\"M]8lKJ$v\u000e]5d'R\fGo]0%KF$\"a\u00170\u0011\u0005eb\u0016BA/;\u0005\u0011)f.\u001b;\t\u000f}[\u0011\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%A\u0003tKR,\u0006\u000fF\u0001\\Q\tiA\r\u0005\u0002fY6\taM\u0003\u0002hQ\u0006\u0019\u0011\r]5\u000b\u0005%T\u0017a\u00026va&$XM\u001d\u0006\u0003W:\nQA[;oSRL!!\u001c4\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\tq\u0001\u000f\u0005\u0002fc&\u0011!O\u001a\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti6K\u00070\u001a3US\u0016\u0014h)\u001a;dQ\"\u0012q\"\u001e\t\u0003KZL!a\u001e4\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cH\u000fV5fe\u001a+Go\u00195fe\u0016C8-\u001a9uS>t\u0007F\u0001\tv\u0003a!Xm\u001d;GKR\u001c\u0007nV5uQ\u001a+gnY3e\u000bB|7\r\u001b\u0015\u0003#U\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0005I)\u0018A\r;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQRKW.\u001a'bO:{GOU3d_J$W\rZ!t\u0007>t7/^7fe\u001a+Go\u00195)\u0005M)\u0018\u0001\b;fgR\u001cuN\\:v[\u0016\u0014H+[3s\r\u0016$8\r\u001b+j[\u0016d\u0015m\u001a\u0015\u0003)U\f\u0001\u0007^3ti2{7-\u00197TK\u001elWM\u001c;EK2,G/\u001a3BMR,'\u000fR3mCf,GMR3uG\"\u001c%/Z1uS>t\u0007FA\u000bv\u0003I!Xm\u001d;ESZ,'oZ5oO\u0016\u0003xn\u00195)\u0005Y)\u0018!\b;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8)\u0005])\u0018\u0001\r;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8XQ\u0016t\u0007K];oS:<G)[:bE2,G\r\u000b\u0002\u0019k\u0006\u0011C/Z:u\u001b&DX\r\u001a$fi\u000eDGi\\3t\u001d>$8i\\7qY\u0016$X-R1sYfD#!G;\u0002A\t,\u0018\u000e\u001c3Nk2$\u0018\u000eU1si&$\u0018n\u001c8GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u000b\u0003;\t\u0019#a\n\u0002V\u0005-\u0004cA\u001b\u0002 %\u0019\u0011\u0011\u0005\u0013\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u0011\u0019\t)C\u0007a\u0001q\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0003SQ\u0002\u0019AA\u0016\u0003)1W\r^2i\u0013:4wn\u001d\t\u0007\u0003[\t\u0019$a\u000e\u000e\u0005\u0005=\"bAA\u0019u\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0012q\u0006\u0002\u0004'\u0016\f\bcB\u001d\u0002:\u0005u\u0012qJ\u0005\u0004\u0003wQ$A\u0002+va2,'\u0007\u0005\u0003\u0002@\u0005-SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\r\r|W.\\8o\u0015\r9\u0013q\t\u0006\u0004\u0003\u0013r\u0013AB1qC\u000eDW-\u0003\u0003\u0002N\u0005\u0005#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004k\u0005E\u0013bAA*I\t1\u0002+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0004\u0002Xi\u0001\r!!\u0017\u0002-\u0019,Go\u00195PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1NCB\u0004\u0002\"a\u0017\u0002b\u0005u\u0012QM\u0007\u0003\u0003;RA!a\u0018\u00020\u00059Q.\u001e;bE2,\u0017\u0002BA2\u0003;\u00121!T1q!\r)\u0014qM\u0005\u0004\u0003S\"#!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I\u0011Q\u000e\u000e\u0011\u0002\u0003\u0007\u0011qN\u0001\u000fSN4%o\\7G_2dwn^3s!\rI\u0014\u0011O\u0005\u0004\u0003gR$a\u0002\"p_2,\u0017M\\\u0001+EVLG\u000eZ'vYRL\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tIH\u000b\u0003\u0002p\u0005m4FAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d%(\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\t,\u0018\u000e\u001c3GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u000b\u0003;\t\t*a%\u0002\u0018\u0006m\u0005BBA\u00139\u0001\u0007\u0001\bC\u0004\u0002\u0016r\u0001\r!!\u0010\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0014\u000fA\u0002\u0005=\u0013!\u00034fi\u000eD\u0017J\u001c4p\u0011\u001d\ti\n\ba\u0001\u0003K\n1CZ3uG\"|eMZ:fi6+G/\u00193bi\u0006\fQ#\u001a=qK\u000e$(+Z1e\rJ|WNU3qY&\u001c\u0017\rF\u0005\\\u0003G\u000b)+a*\u0002,\"1\u0011QE\u000fA\u0002aBq!!&\u001e\u0001\u0004\ti\u0004C\u0004\u0002*v\u0001\r!a\u0014\u0002%\u0019,Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0003[k\u0002\u0019AAX\u0003\u0015)'O]8s!\u0011\t\t,a.\u000e\u0005\u0005M&\u0002BA[\u0003\u0003\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003s\u000b\u0019L\u0001\u0004FeJ|'o]\u0001\u0010EVLG\u000e\u001a*fC\u0012\u0014Vm];miR!\u0011qXAc!\r)\u0014\u0011Y\u0005\u0004\u0003\u0007$#!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0004\u0002.z\u0001\r!a,\u00023\u0015D\b/Z2u\u000f\u0016$H+[3s\r\u0016$8\r\u001b*fgVdGo\u001d\u000b\b7\u0006-\u0017q\u001cB\u0003\u0011\u001d\tim\ba\u0001\u0003\u001f\fA\u0002]3oI&twMR3uG\"\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0004gKR\u001c\u0007.\u001a:\u000b\u0007\u0005eg%\u0001\u0003uS\u0016\u0014\u0018\u0002BAo\u0003'\u0014A\u0002U3oI&twMR3uG\"Dq!!9 \u0001\u0004\t\u0019/A\fu_BL7\rU1si&$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]B1\u0011QFA\u001a\u0003K\u0004r!OA\u001d\u0003{\t9\u000fE\u0003:\u0003S\fi/C\u0002\u0002lj\u0012aa\u00149uS>t\u0007\u0003BAx\u0003\u007ftA!!=\u0002|:!\u00111_A}\u001b\t\t)PC\u0002\u0002x\"\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0007\u0005u((A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005!1\u0001\u0002\n)\"\u0014xn^1cY\u0016T1!!@;\u0011%\u00119a\bI\u0001\u0002\u0004\u0011I!A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005E'1B\u0005\u0005\u0005\u001b\t\u0019N\u0001\rSK\u000ed\u0017-[7bE2,W*Z7pef\u0014VmY8sIN\f1%\u001a=qK\u000e$x)\u001a;US\u0016\u0014h)\u001a;dQJ+7/\u001e7ug\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0014)\"!\u0011BA>\u0003Y)\u0007\u0010]3diJ+\u0017\r\u001a$s_6dunY1m\u0019><GcB.\u0003\u001a\tm!Q\u0006\u0005\u0006\u0011\u0006\u0002\rA\u0013\u0005\b\u0005;\t\u0003\u0019\u0001B\u0010\u000391W\r^2i\t\u0006$\u0018-\u00138g_N\u0004b!!\f\u00024\t\u0005\u0002#C\u001d\u0003$\u0005u\"qEAt\u0013\r\u0011)C\u000f\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007U\u0012I#C\u0002\u0003,\u0011\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u00030\u0005\u0002\rA!\r\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l!\rI$1G\u0005\u0004\u0005kQ$\u0001\u0002'p]\u001e\f!CY;jY\u0012\u0004\u0016M\u001d;ji&|g\u000eR1uCR!\u0011q\nB\u001e\u0011\u001d\u0011iD\ta\u0001\u0005c\t1BZ3uG\"|eMZ:fi\u0002")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final MockTime mockTime = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);
    private BrokerTopicStats brokerTopicStats;

    private int maxBytes() {
        return this.maxBytes;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private void brokerTopicStats_$eq(BrokerTopicStats x$1) {
        this.brokerTopicStats = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.brokerTopicStats_$eq(new BrokerTopicStats());
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerTopicStats() != null) {
            this.brokerTopicStats().close();
        }
    }

    @Test
    public void testMixedTierFetch() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)this.buildPartitionData(fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)this.buildPartitionData(fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())), new Tuple2((Object)topicPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), this.buildMultiPartitionFetchMetadata$default$4());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        pendingFetch.cancel();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)None$.MODULE$), (List)Nil$.MODULE$), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testMixedTierFetch$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
    }

    @Test
    public void testTierFetcherException() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        TopicPartition topicPartition2 = new TopicPartition("topic", 2);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)this.buildPartitionData(fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)this.buildPartitionData(fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition2, (Object)this.buildPartitionData(fetchOffset)), (List)Nil$.MODULE$))), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()), new Tuple2((Object)topicPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()), new Tuple2((Object)topicPartition2, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), this.buildMultiPartitionFetchMetadata$default$4());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        pendingFetch.cancel();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)new Some((Object)new UnknownServerException())), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition2, (Object)new Some((Object)new UnknownServerException())), (List)Nil$.MODULE$))), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)new .colon.colon((Object)new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicPartition2, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)Nil$.MODULE$))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 fetch results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition0)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition0 to return a FencedLeaderException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition1)).error(), (Object)Errors.UNKNOWN_SERVER_ERROR, (String)"Expected topicPartition1 to return a UnknownServerErrorException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition2)).error(), (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition2 to return a FencedLeaderException as it takes precedence over TierFetcher exceptions");
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)topicPartition);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty());
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andThrow((Throwable)new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicPartition).append(" not available").toString()));
        this.expectReadFromReplica(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, Errors.NOT_LEADER_OR_FOLLOWER);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testFollowerFetchTimeLagNotRecordedAsConsumerFetch() {
        boolean isFromFollower = true;
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)this.buildPartitionData(fetchOffset)), (List)Nil$.MODULE$), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))}))), isFromFollower);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)Nil$.MODULE$), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Expected tiered fetch result");
        Assertions.assertEquals((int)0, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Follower fetch is not recorded, snapshot size is 0");
    }

    @Test
    public void testConsumerTierFetchTimeLag() {
        boolean isFromFollower = false;
        int fetchDelta = 3;
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)this.buildPartitionData(fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)this.buildPartitionData(fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())), new Tuple2((Object)topicPartition1, (Object)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())}))), isFromFollower);
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        pendingFetch.cancel();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        ReclaimableMemoryRecords records = new ReclaimableMemoryRecords(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5).buffer(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        this.mockTime().sleep(fetchDelta);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)None$.MODULE$), (List)Nil$.MODULE$), records);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Expected tiered and local fetch result");
        Assertions.assertEquals((int)2, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Expected size of recorded consumer fetch lag snapshot");
        double firstLagTimeMs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).headOption().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)firstLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
        double lastLagTimeMs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).lastOption().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)lastLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
    }

    @Test
    public void testLocalSegmentDeletedAfterDelayedFetchCreation() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition0, (Object)this.buildPartitionData(fetchOffset)), (List)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)this.buildPartitionData(fetchOffset)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())), new Tuple2((Object)topicPartition1, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))}))), this.buildMultiPartitionFetchMetadata$default$4());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        pendingFetch.cancel();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicPartition1, (Object)None$.MODULE$), (List)Nil$.MODULE$), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition0)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition1)).records(), (Object)ReclaimableMemoryRecords.EMPTY);
    }

    @Test
    public void testDivergingEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch);
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)topicPartition);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE);
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testIncrementalFetchPartition() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        IncrementalPartitionFetchMetadata fooFetch1 = new IncrementalPartitionFetchMetadata(foo1, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch1.maybeUpdateResponseData(initialFetchResponse, true);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0, (PartitionListener)fooFetch0))).andAnswer(() -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$1(fooFetch0, foo0)));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo1, (PartitionListener)fooFetch1))).andAnswer(() -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartition$2(fooFetch1, foo1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        fooFetch0.maybeRegisterAsListener(this.replicaManager());
        fooFetch1.maybeRegisterAsListener(this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        Assertions.assertFalse((boolean)fooFetch1.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        FetchMetadata fetchMetadata = new FetchMetadata(1, Integer.MAX_VALUE, false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, true, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)fooFetch1), (List)Nil$.MODULE$)), Map$.MODULE$.empty());
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap(Predef$.MODULE$.$conforms()));
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertFalse((boolean)((Option)fetchResult.elem).isDefined());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        fooFetch1.onEndOffsetUpdated(foo1, 10L);
        Assertions.assertFalse((boolean)fooFetch1.isCaughtUp(), (String)fooFetch1.toString());
        Partition fooPartition1 = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)fooPartition1.topicPartition()).andReturn((Object)foo1);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(foo1)).andReturn((Object)fooPartition1);
        EasyMock.expect((Object)fooPartition1.convertToLocalOffsetMetadata(0L)).andReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        EasyMock.expect((Object)fooPartition1.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition1, 1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int x$1 = fetchMetadata.replicaId();
        boolean x$2 = fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = fetchMetadata.fetchIsolation();
        int x$4 = fetchMetadata.fetchMaxBytes();
        boolean x$5 = fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = fetchMetadata.fetchInfos();
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$1, x$2, x$3, x$4, x$5, x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo1, fetchMetadata.replicaId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), fooPartition1});
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo1})), (Object)((MapLike)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testIncrementalFetchPartitionWhenPruningDisabled() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(0L, 0L, 100, Optional.empty(), Optional.empty());
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata fooFetch0 = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        fooFetch0.maybeUpdateResponseData(initialFetchResponse, true);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(foo0, (PartitionListener)fooFetch0))).andAnswer(() -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(fooFetch0, foo0)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        fooFetch0.maybeRegisterAsListener(this.replicaManager());
        Assertions.assertFalse((boolean)fooFetch0.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)fooFetch0.isCaughtUp(), (String)fooFetch0.toString());
        FetchMetadata fetchMetadata = new FetchMetadata(1, Integer.MAX_VALUE, false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, false, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)fooFetch0), (List)Nil$.MODULE$), Map$.MODULE$.empty());
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap(Predef$.MODULE$.$conforms()));
            return BoxedUnit.UNIT;
        });
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Partition fooPartition0 = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)fooPartition0.topicPartition()).andReturn((Object)foo0);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(foo0)).andReturn((Object)fooPartition0);
        EasyMock.expect((Object)fooPartition0.convertToLocalOffsetMetadata(0L)).andReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        EasyMock.expect((Object)fooPartition0.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition0, 1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int x$1 = fetchMetadata.replicaId();
        boolean x$2 = fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = fetchMetadata.fetchIsolation();
        int x$4 = fetchMetadata.fetchMaxBytes();
        boolean x$5 = fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = fetchMetadata.fetchInfos();
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$1, x$2, x$3, x$4, x$5, x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo0, fetchMetadata.replicaId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), fooPartition0});
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0})), (Object)((MapLike)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testMixedFetchDoesNotCompleteEarly() {
        TopicPartition localTopicPartition = new TopicPartition("topic1", 0);
        TopicPartition tieredTopicPartition = new TopicPartition("topic2", 1);
        int replicaId = 1;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)localTopicPartition, (Object)this.buildPartitionData(500L)), (List)new .colon.colon((Object)new Tuple2((Object)tieredTopicPartition, (Object)this.buildPartitionData(500L)), (List)Nil$.MODULE$)), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)localTopicPartition, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())), new Tuple2((Object)tieredTopicPartition, (Object)new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))}))), this.buildMultiPartitionFetchMetadata$default$4());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(2);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.expect((Object)pendingFetch.finish()).andReturn(new HashMap()).once();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            DelayedFetchTest.$anonfun$testMixedFetchDoesNotCompleteEarly$1(x$1);
            return BoxedUnit.UNIT;
        });
        Partition localPartition = (Partition)this.mock(Partition.class);
        Partition tieredPartition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)localPartition.topicPartition()).andReturn((Object)localTopicPartition).times(2);
        EasyMock.expect((Object)tieredPartition.topicPartition()).andReturn((Object)tieredTopicPartition).times(2);
        LogOffsetSnapshot logOffsetSnapshot = new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()), new LogOffsetMetadata(500L, 250L, LogOffsetMetadata$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)localPartition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)logOffsetSnapshot);
        EasyMock.expect((Object)tieredPartition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)logOffsetSnapshot);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(localTopicPartition)).andReturn((Object)localPartition).times(2);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(tieredTopicPartition)).andReturn((Object)tieredPartition).times(2);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(EasyMock.eq((int)1), EasyMock.eq((boolean)true), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((int)1024), EasyMock.eq((boolean)false), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Option)EasyMock.anyObject())).andReturn((Object)Nil$.MODULE$).once();
        this.replayAll();
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
    }

    private FetchMetadata buildMultiPartitionFetchMetadata(int replicaId, Seq<Tuple2<TopicPartition, PartitionFetchMetadata>> fetchInfos, scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata> fetchOffsetMetadataMap, boolean isFromFollower) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, isFromFollower, replicaId, true, fetchInfos, fetchOffsetMetadataMap);
    }

    private boolean buildMultiPartitionFetchMetadata$default$4() {
        return true;
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, PartitionFetchMetadata fetchInfo, LogOffsetMetadata fetchOffsetMetadata) {
        return this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchInfo), (List)Nil$.MODULE$), (scala.collection.mutable.Map<TopicPartition, LogOffsetMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)fetchOffsetMetadata)}))), this.buildMultiPartitionFetchMetadata$default$4());
    }

    private void expectReadFromReplica(int replicaId, TopicPartition topicPartition, PartitionFetchMetadata fetchPartitionData, Errors error) {
        boolean x$2 = true;
        FetchLogEnd$ x$3 = FetchLogEnd$.MODULE$;
        int x$4 = this.maxBytes();
        boolean x$5 = false;
        .colon.colon x$6 = new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$);
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, x$2, (FetchIsolation)x$3, x$4, x$5, (Seq)x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = FetchDataInfo$.MODULE$.empty();
        None$ x$3 = None$.MODULE$;
        long x$4 = -1L;
        long x$5 = -1L;
        long x$6 = -1L;
        long x$7 = -1L;
        long x$8 = -1L;
        boolean x$9 = false;
        None$ x$10 = None$.MODULE$;
        Option x$11 = LogReadResult$.MODULE$.apply$default$10();
        return new LogReadResult(x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$10, x$9, x$11, (Option)x$1);
    }

    private void expectGetTierFetchResults(PendingFetch pendingFetch, Seq<Tuple2<TopicPartition, Option<Throwable>>> topicPartitionException, ReclaimableMemoryRecords records) {
        java.util.Map results = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitionException.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option exceptionOpt;
            TopicPartition topicPartition;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    topicPartition = (TopicPartition)x0$1._1();
                    exceptionOpt = (Option)x0$1._2();
                    if (topicPartition != null && exceptionOpt != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)new TierFetchResult(records, Collections.emptyList(), (Throwable)exceptionOpt.orNull(Predef$.MODULE$.$conforms())));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        EasyMock.expect((Object)pendingFetch.finish()).andReturn((Object)results);
    }

    private ReclaimableMemoryRecords expectGetTierFetchResults$default$3() {
        return ReclaimableMemoryRecords.EMPTY;
    }

    private void expectReadFromLocalLog(ReplicaManager replicaManager, Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>> fetchDataInfos, long highWatermark) {
        Seq readResults = (Seq)fetchDataInfos.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                AbstractFetchDataInfo tierFetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
                Option exceptionOpt = (Option)x0$1._3();
                if (tierFetchDataInfo instanceof TierFetchDataInfo) {
                    TierFetchDataInfo tierFetchDataInfo2 = (TierFetchDataInfo)tierFetchDataInfo;
                    if (exceptionOpt != null) {
                        return new Tuple2((Object)tp, (Object)new TierLogReadResult(tierFetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), 0, (Option)None$.MODULE$, (Option)None$.MODULE$, exceptionOpt));
                    }
                }
            }
            if (x0$1 == null) throw new MatchError(x0$1);
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractFetchDataInfo fetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
            Option exceptionOpt = (Option)x0$1._3();
            if (!(fetchDataInfo instanceof FetchDataInfo)) throw new MatchError(x0$1);
            FetchDataInfo fetchDataInfo2 = (FetchDataInfo)fetchDataInfo;
            if (exceptionOpt == null) throw new MatchError(x0$1);
            return new Tuple2((Object)tp, (Object)new LogReadResult(fetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), (Option)None$.MODULE$, true, (Option)None$.MODULE$, exceptionOpt));
        }, Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)replicaManager.readFromLocalLog(BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (FetchIsolation)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Option)EasyMock.anyObject())).andReturn((Object)readResults);
    }

    private PartitionFetchMetadata buildPartitionData(long fetchOffset) {
        return new FullPartitionFetchMetadata(fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty(), Optional.empty());
    }

    public static final /* synthetic */ boolean $anonfun$testMixedTierFetch$2(int highWatermark$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$1;
        return bl;
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(int highWatermark$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((FetchPartitionData)x0$1._2()).highWatermark() == (long)highWatermark$2;
        return bl;
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$1(IncrementalPartitionFetchMetadata fooFetch0$1, TopicPartition foo0$1) {
        fooFetch0$1.onStartOffsetUpdated(foo0$1, 0L);
        fooFetch0$1.onEndOffsetUpdated(foo0$1, 0L);
        fooFetch0$1.onHighWatermarkUpdated(foo0$1, 0L);
        fooFetch0$1.onLastStableOffsetUpdated(foo0$1, 0L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartition$2(IncrementalPartitionFetchMetadata fooFetch1$1, TopicPartition foo1$1) {
        fooFetch1$1.onStartOffsetUpdated(foo1$1, 0L);
        fooFetch1$1.onEndOffsetUpdated(foo1$1, 0L);
        fooFetch1$1.onHighWatermarkUpdated(foo1$1, 0L);
        fooFetch1$1.onLastStableOffsetUpdated(foo1$1, 0L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalFetchPartitionWhenPruningDisabled$1(IncrementalPartitionFetchMetadata fooFetch0$2, TopicPartition foo0$2) {
        fooFetch0$2.onStartOffsetUpdated(foo0$2, 0L);
        fooFetch0$2.onEndOffsetUpdated(foo0$2, 0L);
        fooFetch0$2.onHighWatermarkUpdated(foo0$2, 0L);
        fooFetch0$2.onLastStableOffsetUpdated(foo0$2, 0L);
        return true;
    }

    public static final /* synthetic */ void $anonfun$testMixedFetchDoesNotCompleteEarly$1(Seq x$1) {
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

