/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0006\r\u0001EAQA\u0006\u0001\u0005\u0002]Aq!\u0007\u0001C\u0002\u0013\u0005!\u0004\u0003\u0004.\u0001\u0001\u0006Ia\u0007\u0005\u0006]\u0001!\te\f\u0005\u0006y\u0001!\t%\u0010\u0005\u0006\u0017\u0002!\t!\u0010\u0005\u0006!\u0002!\t!\u0010\u0005\u0006%\u0002!\ta\u0015\u0005\u00063\u0002!IA\u0017\u0005\bm\u0002\t\n\u0011\"\u0003x\u0005i!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$H+Z:u\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\r\u0013\t)BBA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u0014\u0001\u0005Q!I]8lKJ$\u0016mZ:\u0016\u0003m\u0001B\u0001H\u0012&K5\tQD\u0003\u0002\u001f?\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003A\u0005\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\u001e\u0005\ri\u0015\r\u001d\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019\u0019FO]5oO\u0006Y!I]8lKJ$\u0016mZ:!\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u00021iA\u0011\u0011GM\u0007\u0002C%\u00111'\t\u0002\u0005+:LG\u000fC\u00036\t\u0001\u0007a'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\u000e\u001e\u000e\u0003aR!!O\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003wa\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\u0005\u0001\u0004FA\u0003@!\t\u0001\u0015*D\u0001B\u0015\t\u00115)A\u0002ba&T!\u0001R#\u0002\u000f),\b/\u001b;fe*\u0011aiR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005)\u000b%A\u0003\"fM>\u0014X-R1dQ\u0006qD/Z:u\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3ti&s7\r\\;eS:<7\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]ND#AB'\u0011\u0005\u0001s\u0015BA(B\u0005\u0011!Vm\u001d;\u0002}Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;Fq\u000edW\u000fZ5oO\u000ecWo\u001d;fe\u0006+H\u000f[8sSj,Gm\u00149fe\u0006$\u0018n\u001c8tQ\t9Q*\u0001\u000euKN$H)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000f\u0006\u00021)\")Q\u000b\u0003a\u0001-\u0006\u0011\u0013N\\2mk\u0012,7\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]N\u0004\"!M,\n\u0005a\u000b#a\u0002\"p_2,\u0017M\\\u0001\u001bg\u0016tG\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f\u001e\u000b\u00047\u001a\\\u0007C\u0001/e\u001b\u0005i&B\u00010`\u0003!\u0011X-];fgR\u001c(B\u00011b\u0003\u0019\u0019w.\\7p]*\u0011qB\u0019\u0006\u0003G\u001e\u000ba!\u00199bG\",\u0017BA3^\u0005]!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:q_:\u001cX\rC\u0003h\u0013\u0001\u0007\u0001.A\u0004sKF,Xm\u001d;\u0011\u0005qK\u0017B\u00016^\u0005Y!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$\bb\u00027\n!\u0003\u0005\r!\\\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000eE\u00022]BL!a\\\u0011\u0003\r=\u0003H/[8o!\t\tH/D\u0001s\u0015\t\u0019h\"A\u0004oKR<xN]6\n\u0005U\u0014(\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001J:f]R$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003aT#!\\=,\u0003i\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003%)hn\u00195fG.,GM\u0003\u0002\u0000C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\rAPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    private final scala.collection.immutable.Map<String, String> BrokerTags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}));

    public scala.collection.immutable.Map<String, String> BrokerTags() {
        return this.BrokerTags;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)this.BrokerTags().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(KafkaConfig$.MODULE$.BrokerTagsProp()).append(".").append(name).toString()), (Object)value);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava()));
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(true);
    }

    @Test
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            void var2_2;
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            DescribeClusterResponseData.DescribeClusterBroker broker = new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull(Predef$.MODULE$.$conforms()));
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$2(broker, name, value));
            Map map = Implicits$.MODULE$.MapExtensionMethods(this.BrokerTags());
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
        int expectedControllerId = ((KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$3(x$1)))).last()).config().brokerId();
        String expectedClusterId = ((KafkaServer)this.servers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()), Set$.MODULE$.canBuildFrom())).asJava())) : Integer.MIN_VALUE;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, this.sentDescribeClusterRequest$default$2());
            Assertions.assertEquals((int)expectedControllerId, (int)describeClusterResponse.data().controllerId());
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeClusterResponse.data().brokers()).asScala()).toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$2(DescribeClusterResponseData.DescribeClusterBroker broker$1, String name, String value) {
        return broker$1.tags().add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.TagKeyValue().setName(name).setValue(value));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$3(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

